/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.IndexedElement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="The contact\u2019s name, affiliation and e-mail. Several contacts can be given by indicating the number in the square brackets after \"contact\". A contact has to be supplied in the format [first name] [initials] [last name]. ")
@XmlRootElement(name="Contact")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="Contact")
public class Contact
extends IndexedElement {
    @JsonProperty(value="name")
    @JacksonXmlProperty(localName="name")
    @XmlElement(name="name")
    private String name = null;
    @JsonProperty(value="affiliation")
    @JacksonXmlProperty(localName="affiliation")
    @XmlElement(name="affiliation")
    private String affiliation = null;
    @JsonProperty(value="email")
    @JacksonXmlProperty(localName="email")
    @XmlElement(name="email")
    private String email = null;

    @Override
    public Contact id(Integer id) {
        super.setId(id);
        return this;
    }

    @Override
    public Contact elementType(String elementType) {
        super.setElementType(elementType);
        return this;
    }

    public Contact name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The contact's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Contact affiliation(String affiliation) {
        this.affiliation = affiliation;
        return this;
    }

    @ApiModelProperty(value="The contact's affiliation.")
    public String getAffiliation() {
        return this.affiliation;
    }

    public void setAffiliation(String affiliation) {
        this.affiliation = affiliation;
    }

    public Contact email(String email) {
        this.email = email;
        return this;
    }

    @Pattern(regexp="^\\w+([\\.-]?\\w+)*@\\w+([\\.-]?\\w+)*(\\.\\w{2,3})+$")
    @ApiModelProperty(value="The contact's e-mail address.")
    public @Pattern(regexp="^\\w+([\\.-]?\\w+)*@\\w+([\\.-]?\\w+)*(\\.\\w{2,3})+$") String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contact contact = (Contact)o;
        return Objects.equals(this.name, contact.name) && Objects.equals(this.affiliation, contact.affiliation) && Objects.equals(this.email, contact.email) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.affiliation, this.email, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Contact {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    affiliation: ").append(this.toIndentedString(this.affiliation)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum Properties {
        name("name"),
        affiliation("affiliation"),
        email("email");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

