/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.Comment;
import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.SmallMoleculeEvidence;
import de.isas.mztab2.model.SmallMoleculeFeature;
import de.isas.mztab2.model.SmallMoleculeSummary;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="mzTab-M is intended as a reporting standard for quantitative results from metabolomics/lipodomics approaches.  This format is further intended to provide local LIMS systems as well as MS metabolomics repositories a simple way to share and combine basic information.  The mzTab-M format consists of four cross-referenced data tables:          * Metadata (MTD),      * Small Molecule (SML),      * Small Molecule Feature (SMF) and the      * Small Molecule Evidence (SME).   The MTD and SML tables are mandatory, and for a file to contain any evidence about how molecules were quantified or identified by software, then all four tables must be present. The tables must follow the order MTD, SML, SMF and SME, with a blank line separating each table.   The structure of each table, in terms of the rows and columns that must be present is tightly specified and formally defined and explained in the mzTab-M specification document. mzTab-M files MUST have one Metadata (MTD) section and one Small Molecule (SML) Section. In practice, we expect that most files SHOULD also include one Small Molecule Feature (SMF) section, and one Small Molecule Evidence (SME) Section.  Files lacking SMF and SME sections can only present summary data about quantified molecules, without any evidence trail for how those values were derived. It will be left to reading software to determine whether additional validation will be requested such that SMF and SME tables MUST be present. ")
@XmlRootElement(name="MzTab")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="MzTab")
public class MzTab {
    @JsonProperty(value="metadata")
    @JacksonXmlProperty(localName="metadata")
    @XmlElement(name="metadata")
    private Metadata metadata = null;
    @JsonProperty(value="smallMoleculeSummary")
    @XmlElement(name="smallMoleculeSummary")
    private List<SmallMoleculeSummary> smallMoleculeSummary = new ArrayList<SmallMoleculeSummary>();
    @JsonProperty(value="smallMoleculeFeature")
    @XmlElement(name="smallMoleculeFeature")
    private List<SmallMoleculeFeature> smallMoleculeFeature = new ArrayList<SmallMoleculeFeature>();
    @JsonProperty(value="smallMoleculeEvidence")
    @XmlElement(name="smallMoleculeEvidence")
    private List<SmallMoleculeEvidence> smallMoleculeEvidence = new ArrayList<SmallMoleculeEvidence>();
    @JsonProperty(value="comment")
    @XmlElement(name="comment")
    private List<Comment> comment = null;

    public MzTab metadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public MzTab smallMoleculeSummary(List<SmallMoleculeSummary> smallMoleculeSummary) {
        this.smallMoleculeSummary = smallMoleculeSummary;
        return this;
    }

    public MzTab addSmallMoleculeSummaryItem(SmallMoleculeSummary smallMoleculeSummaryItem) {
        this.smallMoleculeSummary.add(smallMoleculeSummaryItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=1)
    @ApiModelProperty(required=true, value="The small molecule section is table-based. The small molecule section MUST always come after the metadata section. All table columns MUST be Tab separated. There MUST NOT be any empty cells; missing values MUST be reported using \u201cnull\u201d for columns where Is Nullable = \u201cTrue\u201d.  Each row of the small molecule section is intended to report one final result to be communicated in terms of a molecule that has been quantified. In many cases, this may be the molecule of biological interest, although in some cases, the final result could be a derivatized form as appropriate \u2013 although it is desirable for the database identifier(s) to reference to the biological (non-derivatized) form. In general, different adduct forms would generally be reported in the Small Molecule Feature section.  The order of columns MUST follow the order specified below.  All columns are MANDATORY except for \u201copt_\u201d columns. ")
    public @NotNull @Valid @Size(min=1) List<SmallMoleculeSummary> getSmallMoleculeSummary() {
        return this.smallMoleculeSummary;
    }

    public void setSmallMoleculeSummary(List<SmallMoleculeSummary> smallMoleculeSummary) {
        this.smallMoleculeSummary = smallMoleculeSummary;
    }

    public MzTab smallMoleculeFeature(List<SmallMoleculeFeature> smallMoleculeFeature) {
        this.smallMoleculeFeature = smallMoleculeFeature;
        return this;
    }

    public MzTab addSmallMoleculeFeatureItem(SmallMoleculeFeature smallMoleculeFeatureItem) {
        this.smallMoleculeFeature.add(smallMoleculeFeatureItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The small molecule feature section is table-based, representing individual MS regions (generally considered to be the elution profile for all isotopomers formed from a single charge state of a molecule), that have been measured/quantified. However, for approaches that quantify individual isotopomers e.g. stable isotope labelling/flux studies, then each SMF row SHOULD represent a single isotopomer.  Different adducts or derivatives and different charge states of individual molecules should be reported as separate SMF rows.  The small molecule feature section MUST always come after the Small Molecule Table. All table columns MUST be Tab separated. There MUST NOT be any empty cells. Missing values MUST be reported using \u201cnull\u201d.  The order of columns MUST follow the order specified below.  All columns are MANDATORY except for \u201copt_\u201d columns. ")
    public List<SmallMoleculeFeature> getSmallMoleculeFeature() {
        return this.smallMoleculeFeature;
    }

    public void setSmallMoleculeFeature(List<SmallMoleculeFeature> smallMoleculeFeature) {
        this.smallMoleculeFeature = smallMoleculeFeature;
    }

    public MzTab smallMoleculeEvidence(List<SmallMoleculeEvidence> smallMoleculeEvidence) {
        this.smallMoleculeEvidence = smallMoleculeEvidence;
        return this;
    }

    public MzTab addSmallMoleculeEvidenceItem(SmallMoleculeEvidence smallMoleculeEvidenceItem) {
        this.smallMoleculeEvidence.add(smallMoleculeEvidenceItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The small molecule evidence section is table-based, representing evidence for identifications of small molecules/features, from database search or any other process used to give putative identifications to molecules. In a typical case, each row represents one result from a single search or intepretation of a piece of evidence e.g. a database search with a fragmentation spectrum. Multiple results from a given input data item (e.g. one fragment spectrum) SHOULD share the same value under evidence_input_id.  The small molecule evidence section MUST always come after the Small Molecule Feature Table. All table columns MUST be Tab separated. There MUST NOT be any empty cells. Missing values MUST be reported using \u201cnull\u201d.  The order of columns MUST follow the order specified below.  All columns are MANDATORY except for \u201copt_\u201d columns. ")
    public List<SmallMoleculeEvidence> getSmallMoleculeEvidence() {
        return this.smallMoleculeEvidence;
    }

    public void setSmallMoleculeEvidence(List<SmallMoleculeEvidence> smallMoleculeEvidence) {
        this.smallMoleculeEvidence = smallMoleculeEvidence;
    }

    public MzTab comment(List<Comment> comment) {
        this.comment = comment;
        return this;
    }

    public MzTab addCommentItem(Comment commentItem) {
        if (this.comment == null) {
            this.comment = new ArrayList<Comment>();
        }
        this.comment.add(commentItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Comment lines can be placed anywhere in an mzTab file. These lines must start with the three-letter code COM and are ignored by most parsers. Empty lines can also occur anywhere in an mzTab file and are ignored. ")
    public List<Comment> getComment() {
        return this.comment;
    }

    public void setComment(List<Comment> comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MzTab mzTab = (MzTab)o;
        return Objects.equals(this.metadata, mzTab.metadata) && Objects.equals(this.smallMoleculeSummary, mzTab.smallMoleculeSummary) && Objects.equals(this.smallMoleculeFeature, mzTab.smallMoleculeFeature) && Objects.equals(this.smallMoleculeEvidence, mzTab.smallMoleculeEvidence) && Objects.equals(this.comment, mzTab.comment);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.smallMoleculeSummary, this.smallMoleculeFeature, this.smallMoleculeEvidence, this.comment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MzTab {\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    smallMoleculeSummary: ").append(this.toIndentedString(this.smallMoleculeSummary)).append("\n");
        sb.append("    smallMoleculeFeature: ").append(this.toIndentedString(this.smallMoleculeFeature)).append("\n");
        sb.append("    smallMoleculeEvidence: ").append(this.toIndentedString(this.smallMoleculeEvidence)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum Properties {
        metadata("metadata"),
        smallMoleculeSummary("smallMoleculeSummary"),
        smallMoleculeFeature("smallMoleculeFeature"),
        smallMoleculeEvidence("smallMoleculeEvidence"),
        comment("comment");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

