/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.Parameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="Specification of sample. (empty) name: A name for each sample to serve as a list of the samples that MUST be reported in the following tables. Samples MUST be reported if a statistical design is being captured (i.e. bio or tech replicates). If the type of replicates are not known, samples SHOULD NOT be reported.  species: The respective species of the samples analysed. For more complex cases, such as metagenomics, optional columns and userParams should be used.  tissue: The respective tissue(s) of the sample.  cell_type: The respective cell type(s) of the sample.  disease: The respective disease(s) of the sample.  description: A human readable description of the sample.  custom: Custom parameters describing the sample's additional properties. Dates MUST be provided in ISO-8601 format. ")
@XmlRootElement(name="Sample")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="Sample")
public class Sample
extends IndexedElement {
    @JsonProperty(value="name")
    @JacksonXmlProperty(localName="name")
    @XmlElement(name="name")
    private String name = null;
    @JsonProperty(value="custom")
    @XmlElement(name="custom")
    private List<Parameter> custom = null;
    @JsonProperty(value="species")
    @XmlElement(name="species")
    private List<Parameter> species = null;
    @JsonProperty(value="tissue")
    @XmlElement(name="tissue")
    private List<Parameter> tissue = null;
    @JsonProperty(value="cell_type")
    @XmlElement(name="cellType")
    private List<Parameter> cellType = null;
    @JsonProperty(value="disease")
    @XmlElement(name="disease")
    private List<Parameter> disease = null;
    @JsonProperty(value="description")
    @JacksonXmlProperty(localName="description")
    @XmlElement(name="description")
    private String description = null;

    @Override
    public Sample id(Integer id) {
        super.setId(id);
        return this;
    }

    @Override
    public Sample elementType(String elementType) {
        super.setElementType(elementType);
        return this;
    }

    public Sample name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The sample's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Sample custom(List<Parameter> custom) {
        this.custom = custom;
        return this;
    }

    public Sample addCustomItem(Parameter customItem) {
        if (this.custom == null) {
            this.custom = new ArrayList<Parameter>();
        }
        this.custom.add(customItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Additional user or cv parameters.")
    public List<Parameter> getCustom() {
        return this.custom;
    }

    public void setCustom(List<Parameter> custom) {
        this.custom = custom;
    }

    public Sample species(List<Parameter> species) {
        this.species = species;
        return this;
    }

    public Sample addSpeciesItem(Parameter speciesItem) {
        if (this.species == null) {
            this.species = new ArrayList<Parameter>();
        }
        this.species.add(speciesItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Biological species information on the sample.")
    public List<Parameter> getSpecies() {
        return this.species;
    }

    public void setSpecies(List<Parameter> species) {
        this.species = species;
    }

    public Sample tissue(List<Parameter> tissue) {
        this.tissue = tissue;
        return this;
    }

    public Sample addTissueItem(Parameter tissueItem) {
        if (this.tissue == null) {
            this.tissue = new ArrayList<Parameter>();
        }
        this.tissue.add(tissueItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Biological tissue information on the sample.")
    public List<Parameter> getTissue() {
        return this.tissue;
    }

    public void setTissue(List<Parameter> tissue) {
        this.tissue = tissue;
    }

    public Sample cellType(List<Parameter> cellType) {
        this.cellType = cellType;
        return this;
    }

    public Sample addCellTypeItem(Parameter cellTypeItem) {
        if (this.cellType == null) {
            this.cellType = new ArrayList<Parameter>();
        }
        this.cellType.add(cellTypeItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Biological cell type information on the sample.")
    public List<Parameter> getCellType() {
        return this.cellType;
    }

    public void setCellType(List<Parameter> cellType) {
        this.cellType = cellType;
    }

    public Sample disease(List<Parameter> disease) {
        this.disease = disease;
        return this;
    }

    public Sample addDiseaseItem(Parameter diseaseItem) {
        if (this.disease == null) {
            this.disease = new ArrayList<Parameter>();
        }
        this.disease.add(diseaseItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Disease information on the sample.")
    public List<Parameter> getDisease() {
        return this.disease;
    }

    public void setDisease(List<Parameter> disease) {
        this.disease = disease;
    }

    public Sample description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A free form description of the sample.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sample sample = (Sample)o;
        return Objects.equals(this.name, sample.name) && Objects.equals(this.custom, sample.custom) && Objects.equals(this.species, sample.species) && Objects.equals(this.tissue, sample.tissue) && Objects.equals(this.cellType, sample.cellType) && Objects.equals(this.disease, sample.disease) && Objects.equals(this.description, sample.description) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.custom, this.species, this.tissue, this.cellType, this.disease, this.description, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Sample {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    custom: ").append(this.toIndentedString(this.custom)).append("\n");
        sb.append("    species: ").append(this.toIndentedString(this.species)).append("\n");
        sb.append("    tissue: ").append(this.toIndentedString(this.tissue)).append("\n");
        sb.append("    cellType: ").append(this.toIndentedString(this.cellType)).append("\n");
        sb.append("    disease: ").append(this.toIndentedString(this.disease)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum Properties {
        name("name"),
        custom("custom"),
        species("species"),
        tissue("tissue"),
        cellType("cell_type"),
        disease("disease"),
        description("description");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

