/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.Parameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="A list of parameters describing a sample processing, preparation or handling step similar to a biological or analytical methods report. The order of the sample_processing items should reflect the order these processing steps were performed in. If multiple parameters are given for a step these MUST be separated by a \u201c|\u201d. If derivatization was performed, it MUST be reported here as a general step, e.g. 'silylation' and the actual derivatization agens MUST be specified in the Section 6.2.54 part.       ")
@XmlRootElement(name="SampleProcessing")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="SampleProcessing")
public class SampleProcessing
extends IndexedElement {
    @JsonProperty(value="sampleProcessing")
    @XmlElement(name="sampleProcessing")
    private List<Parameter> sampleProcessing = null;

    @Override
    public SampleProcessing id(Integer id) {
        super.setId(id);
        return this;
    }

    @Override
    public SampleProcessing elementType(String elementType) {
        super.setElementType(elementType);
        return this;
    }

    public SampleProcessing sampleProcessing(List<Parameter> sampleProcessing) {
        this.sampleProcessing = sampleProcessing;
        return this;
    }

    public SampleProcessing addSampleProcessingItem(Parameter sampleProcessingItem) {
        if (this.sampleProcessing == null) {
            this.sampleProcessing = new ArrayList<Parameter>();
        }
        this.sampleProcessing.add(sampleProcessingItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Parameters specifiying sample processing that was applied within one step.")
    public List<Parameter> getSampleProcessing() {
        return this.sampleProcessing;
    }

    public void setSampleProcessing(List<Parameter> sampleProcessing) {
        this.sampleProcessing = sampleProcessing;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SampleProcessing sampleProcessing = (SampleProcessing)o;
        return Objects.equals(this.sampleProcessing, sampleProcessing.sampleProcessing) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sampleProcessing, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SampleProcessing {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    sampleProcessing: ").append(this.toIndentedString(this.sampleProcessing)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum Properties {
        sampleProcessing("sampleProcessing");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

