/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.Parameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="Software used to analyze the data and obtain the reported results. The parameter\u2019s value SHOULD contain the software\u2019s version. The order (numbering) should reflect the order in which the tools were used. A software setting used. This field MAY occur multiple times for a single software. The value of this field is deliberately set as a String, since there currently do not exist CV terms for every possible setting. ")
@XmlRootElement(name="Software")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="Software")
public class Software
extends IndexedElement {
    @JsonProperty(value="parameter")
    @JacksonXmlProperty(localName="parameter")
    @XmlElement(name="parameter")
    private Parameter parameter = null;
    @JsonProperty(value="setting")
    @XmlElement(name="setting")
    private List<String> setting = null;

    @Override
    public Software id(Integer id) {
        super.setId(id);
        return this;
    }

    @Override
    public Software elementType(String elementType) {
        super.setElementType(elementType);
        return this;
    }

    public Software parameter(Parameter parameter) {
        this.parameter = parameter;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Parameter defining the software being used.")
    public Parameter getParameter() {
        return this.parameter;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    public Software setting(List<String> setting) {
        this.setting = setting;
        return this;
    }

    public Software addSettingItem(String settingItem) {
        if (this.setting == null) {
            this.setting = new ArrayList<String>();
        }
        this.setting.add(settingItem);
        return this;
    }

    @ApiModelProperty(value="A software setting used. This field MAY occur multiple times for a single software. The value of this field is deliberately set as a String, since there currently do not exist cvParams for every possible setting. ")
    public List<String> getSetting() {
        return this.setting;
    }

    public void setSetting(List<String> setting) {
        this.setting = setting;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Software software = (Software)o;
        return Objects.equals(this.parameter, software.parameter) && Objects.equals(this.setting, software.setting) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.parameter, this.setting, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Software {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    parameter: ").append(this.toIndentedString(this.parameter)).append("\n");
        sb.append("    setting: ").append(this.toIndentedString(this.setting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum Properties {
        parameter("parameter"),
        setting("setting");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

