/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.MsRun;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="Reference to a spectrum in a spectrum file, for example a fragmentation spectrum has been used to support the identification. If a separate spectrum file has been used for fragmentation spectrum, this MUST be reported in the metadata section as additional ms_runs. The reference must be in the format ms_run[1-n]:{SPECTRA_REF} where SPECTRA_REF MUST follow the format defined in 5.2 (including references to chromatograms where these are used to inform identification). Multiple spectra MUST be referenced using a \u201c|\u201d delimited list for the (rare) cases in which search engines have combined or aggregated multiple spectra in advance of the search to make identifications.  If a fragmentation spectrum has not been used, the value should indicate the ms_run to which is identification is mapped e.g. \u201cms_run[1]\u201d. ")
@XmlRootElement(name="SpectraRef")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="SpectraRef")
public class SpectraRef {
    @JsonProperty(value="ms_run")
    @JacksonXmlProperty(localName="ms_run")
    @XmlElement(name="ms_run")
    private MsRun msRun = null;
    @JsonProperty(value="reference")
    @JacksonXmlProperty(localName="reference")
    @XmlElement(name="reference")
    private String reference = null;

    public SpectraRef msRun(MsRun msRun) {
        this.msRun = msRun;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The ms run object reference by this spectral reference. ")
    public MsRun getMsRun() {
        return this.msRun;
    }

    public void setMsRun(MsRun msRun) {
        this.msRun = msRun;
    }

    public SpectraRef reference(String reference) {
        this.reference = reference;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The (vendor-dependendent) reference string to the actual mass spectrum. ")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpectraRef spectraRef = (SpectraRef)o;
        return Objects.equals(this.msRun, spectraRef.msRun) && Objects.equals(this.reference, spectraRef.reference);
    }

    public int hashCode() {
        return Objects.hash(this.msRun, this.reference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SpectraRef {\n");
        sb.append("    msRun: ").append(this.toIndentedString(this.msRun)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum Properties {
        msRun("ms_run"),
        reference("reference");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

