/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.utils.errors;

import java.io.Serializable;
import java.util.Objects;
import uk.ac.ebi.pride.jmztab2.model.MZTabStringUtils;
import uk.ac.ebi.pride.jmztab2.utils.MZTabProperties;

public class MZTabErrorType
implements Serializable {
    private Integer code;
    private Category category;
    private Level level;
    private String original;
    private String cause;

    protected MZTabErrorType() {
    }

    private MZTabErrorType(Integer code, Category category, Level level, String original, String cause) {
        this.code = code;
        if (category == null) {
            throw new NullPointerException("MZTabErrorType category can not set null!");
        }
        this.category = category;
        Level level2 = this.level = level == null ? Level.Info : level;
        if (original == null || original.trim().length() == 0) {
            throw new IllegalArgumentException("Original " + original + " is empty!");
        }
        this.original = original.trim();
        this.cause = cause;
    }

    public static MZTabErrorType forLevel(Category category, Level level, String keyword) {
        return MZTabErrorType.createMZTabError(category, level, keyword);
    }

    protected static MZTabErrorType createError(Category category, String keyword) {
        return MZTabErrorType.createMZTabError(category, Level.Error, keyword);
    }

    protected static MZTabErrorType createWarn(Category category, String keyword) {
        return MZTabErrorType.createMZTabError(category, Level.Warn, keyword);
    }

    protected static MZTabErrorType createInfo(Category category, String keyword) {
        return MZTabErrorType.createMZTabError(category, Level.Info, keyword);
    }

    private static MZTabErrorType createMZTabError(Category category, Level level, String keyword) {
        if (MZTabStringUtils.isEmpty(keyword)) {
            throw new NullPointerException(keyword + " can not empty!");
        }
        String prefix = null;
        switch (category) {
            case Format: {
                prefix = "f_";
                break;
            }
            case Logical: {
                prefix = "l_";
                break;
            }
            case CrossCheck: {
                prefix = "c_";
            }
        }
        Integer code = new Integer(MZTabProperties.getProperty(prefix + "code_" + keyword));
        String original = MZTabProperties.getProperty(prefix + "original_" + keyword);
        String cause = MZTabProperties.getProperty(prefix + "cause_" + keyword);
        return new MZTabErrorType(code, category, level, original, cause);
    }

    public Integer getCode() {
        return this.code;
    }

    public Category getCategory() {
        return this.category;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getOriginal() {
        return this.original;
    }

    public String getCause() {
        return this.cause;
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + Objects.hashCode(this.code);
        hash = 29 * hash + Objects.hashCode((Object)this.category);
        hash = 29 * hash + Objects.hashCode(this.original);
        hash = 29 * hash + Objects.hashCode(this.cause);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MZTabErrorType other = (MZTabErrorType)obj;
        if (!Objects.equals(this.original, other.original)) {
            return false;
        }
        if (!Objects.equals(this.cause, other.cause)) {
            return false;
        }
        if (!Objects.equals(this.code, other.code)) {
            return false;
        }
        return this.category == other.category;
    }

    public String toString() {
        return "    Code:\t" + this.code + "\r\nCategory:\t" + (Object)((Object)this.category) + "\r\nOriginal:\t" + this.original + "\r\n   Cause:\t" + (this.cause == null ? "" : this.cause) + "\r\n";
    }

    public static Level findLevel(String target) {
        Level level;
        if (MZTabStringUtils.isEmpty(target)) {
            return null;
        }
        target = MZTabStringUtils.toCapital(target.trim());
        try {
            level = Level.valueOf(target);
        }
        catch (IllegalArgumentException e) {
            level = null;
        }
        return level;
    }

    public static enum Level {
        Info,
        Warn,
        Error;

    }

    public static enum Category {
        Format,
        Logical,
        CrossCheck;

    }
}

