/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda;

import at.tugraz.genome.lda.LipidDataAnalyzer;
import at.tugraz.genome.lda.verifier.DoubleVerifier;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DisplayTolerancePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private LipidDataAnalyzer lda_;
    private static final Font SMALL_FONT = new Font("Arial", 0, 9);
    public static final String CHANGE_LOCK_MZ_RANGE = "lockMzRange";
    public static final String DISPLAY_LOCK_MZ_TEXT = "Lock m/z range ";
    public static final String UPDATE_QUANT_TOL_OF_CURRENTLY_SELECTED = "updateQuantTolOfCurrentlySelected";
    public static final String SHOW_MSN_ONLY = "showMSnOnly";
    public static final String SHOW_CHAIN_ONLY = "showChainOnly";
    public static final String SHOW_MSN_NAMES = "showMSnNames";
    public static final String SHOW_2D_CHANGED = "show2dChanged";
    public static final String SHOW_OMEGA_NAMES = "showOmegaNames";
    private JTextField displayMinusTolerance_;
    private JTextField displayPlusTolerance_;
    private JTextField displayRtStart_;
    private JTextField displayRtStop_;
    private JCheckBox lockMzRange_;
    private JTextField displayMzStart_;
    private JTextField displayMzStop_;
    private JCheckBox showMSnEvidence_;
    private JCheckBox showChainEvidence_;
    private JCheckBox showMSnNames_;
    private JCheckBox show2D_;
    private JCheckBox showOmegaNames_;
    private boolean showOmegaEditingTools_;

    public DisplayTolerancePanel(LipidDataAnalyzer lda, boolean showOmegaEditingTools) {
        this.lda_ = lda;
        this.showOmegaEditingTools_ = showOmegaEditingTools;
        this.setLayout(new GridBagLayout());
        JLabel diplayTolMinus = new JLabel("- m/z: ");
        diplayTolMinus.setFont(SMALL_FONT);
        diplayTolMinus.setToolTipText("<html>Display range for the 3D viewer in Dalton.<br/>It defines which m/z range before the m/z of the analyte should be displayed</html>");
        this.add((Component)diplayTolMinus, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 0, 0), 0, 0));
        JLabel diplayTolPlus = new JLabel("+ m/z: ");
        diplayTolPlus.setFont(SMALL_FONT);
        diplayTolPlus.setToolTipText("<html>Display range for the 3D viewer in Dalton.<br/>It defines which m/z range after the m/z of the analyte should be displayed</html>");
        this.add((Component)diplayTolPlus, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 0, 0), 0, 0));
        this.displayMinusTolerance_ = new JTextField(2);
        this.displayMinusTolerance_.setFont(SMALL_FONT);
        this.displayMinusTolerance_.setText("1.5");
        this.displayMinusTolerance_.setHorizontalAlignment(4);
        this.displayMinusTolerance_.setToolTipText("<html>Display range for the 3D viewer in Dalton.<br/>It defines which m/z range before the m/z of the analyte should be displayed</html>");
        this.displayMinusTolerance_.setInputVerifier(new DoubleVerifier());
        this.add((Component)this.displayMinusTolerance_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 1, 0, 0), 0, 0));
        this.displayPlusTolerance_ = new JTextField(2);
        this.displayPlusTolerance_.setFont(SMALL_FONT);
        this.displayPlusTolerance_.setText("2.5");
        this.displayPlusTolerance_.setHorizontalAlignment(4);
        this.displayPlusTolerance_.setToolTipText("<html>Display range for the 3D viewer in Dalton.<br/>It defines which m/z range after the m/z of the analyte should be displayed</html>");
        this.displayPlusTolerance_.setInputVerifier(new DoubleVerifier());
        this.add((Component)this.displayPlusTolerance_, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 1, 0, 0), 0, 0));
        JLabel diplayTolUnit1 = new JLabel("[Da]");
        diplayTolUnit1.setFont(SMALL_FONT);
        this.add((Component)diplayTolUnit1, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 1, 0, 0), 0, 0));
        JLabel rtTolMinusText = new JLabel("Start: ");
        rtTolMinusText.setFont(SMALL_FONT);
        rtTolMinusText.setToolTipText("<html>Display range for the 3D viewer in minutes.<br/>This defines the start retention time.</html>");
        this.add((Component)rtTolMinusText, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        JLabel rtTolPlusText = new JLabel("Stop: ");
        rtTolPlusText.setFont(SMALL_FONT);
        rtTolPlusText.setToolTipText("<html>Display range for the 3D viewer in minutes.<br/>This defines the stop retention time.</html>");
        this.add((Component)rtTolPlusText, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.displayRtStart_ = new JTextField(2);
        this.displayRtStart_.setFont(SMALL_FONT);
        this.displayRtStart_.setText("");
        this.displayRtStart_.setHorizontalAlignment(4);
        this.displayRtStart_.setToolTipText("<html>Display range for the 3D viewer in minutes.<br/>This defines the start retention time.</html>");
        this.displayRtStart_.setInputVerifier(new DoubleVerifier());
        this.add((Component)this.displayRtStart_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 1, 0, 0), 0, 0));
        this.displayRtStop_ = new JTextField(2);
        this.displayRtStop_.setFont(SMALL_FONT);
        this.displayRtStop_.setText("");
        this.displayRtStop_.setHorizontalAlignment(4);
        this.displayRtStop_.setToolTipText("<html>Display range for the 3D viewer in minutes.<br/>This defines the stop retention time.</html>");
        this.displayRtStop_.setInputVerifier(new DoubleVerifier());
        this.add((Component)this.displayRtStop_, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 1, 0, 0), 0, 0));
        JLabel diplayTolUnit2 = new JLabel("[min]");
        diplayTolUnit2.setFont(SMALL_FONT);
        this.add((Component)diplayTolUnit2, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 1, 0, 0), 0, 0));
        JPanel lockMxSelectionPanel = new JPanel();
        this.lockMzRange_ = new JCheckBox();
        this.lockMzRange_.setFont(SMALL_FONT);
        this.lockMzRange_.addItemListener(new PanelItemListener(CHANGE_LOCK_MZ_RANGE));
        this.lockMzRange_.setToolTipText("<html>This setting locks the 3D viewer to a certain m/z range</html>");
        lockMxSelectionPanel.add(this.lockMzRange_);
        JLabel lockMz = new JLabel(DISPLAY_LOCK_MZ_TEXT);
        lockMz.setToolTipText("<html>This setting locks the 3D viewer to a certain m/z range</html>");
        lockMz.setFont(SMALL_FONT);
        lockMxSelectionPanel.add(lockMz);
        this.displayMzStart_ = new JTextField(4);
        this.displayMzStart_.setFont(SMALL_FONT);
        this.displayMzStart_.setText("");
        this.displayMzStart_.setHorizontalAlignment(4);
        this.displayMzStart_.setToolTipText("<html>Display range for the 3D viewer in Dalton.<br/>It defines which m/z range before the m/z of the analyte should be displayed</html>");
        this.displayMzStart_.setInputVerifier(new DoubleVerifier());
        this.displayMzStart_.setEnabled(false);
        lockMxSelectionPanel.add(this.displayMzStart_);
        JLabel mzRangeSign = new JLabel("-");
        lockMxSelectionPanel.add(mzRangeSign);
        this.displayMzStop_ = new JTextField(4);
        this.displayMzStop_.setFont(SMALL_FONT);
        this.displayMzStop_.setText("");
        this.displayMzStop_.setHorizontalAlignment(4);
        this.displayMzStop_.setToolTipText("<html>Display range for the 3D viewer in Dalton.<br/>It defines which m/z range before the m/z of the analyte should be displayed</html>");
        this.displayMzStop_.setInputVerifier(new DoubleVerifier());
        this.displayMzStop_.setEnabled(false);
        lockMxSelectionPanel.add(this.displayMzStop_);
        this.add((Component)lockMxSelectionPanel, new GridBagConstraints(0, 2, 6, 1, 0.0, 0.0, 17, 0, new Insets(0, 1, 0, 0), 0, 0));
        JButton quantTolUpdate = new JButton("Update");
        quantTolUpdate.addActionListener(this.lda_);
        quantTolUpdate.setFont(quantTolUpdate.getFont().deriveFont(10.0f));
        quantTolUpdate.setMargin(new Insets(1, 5, 1, 5));
        quantTolUpdate.setActionCommand(UPDATE_QUANT_TOL_OF_CURRENTLY_SELECTED);
        quantTolUpdate.setToolTipText("<html>Update the settings in the 3D viewer.</html>");
        this.add((Component)quantTolUpdate, new GridBagConstraints(5, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(5, 6, 0, 0), 0, 0));
        JPanel showOptionsPanel = new JPanel();
        this.add((Component)showOptionsPanel, new GridBagConstraints(0, 3, 6, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel showOptionsPanel2 = new JPanel();
        this.add((Component)showOptionsPanel2, new GridBagConstraints(0, 4, 6, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel showOptionsPanel3 = new JPanel();
        this.add((Component)showOptionsPanel3, new GridBagConstraints(0, 5, 6, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.showMSnEvidence_ = new JCheckBox("");
        this.showMSnEvidence_.addItemListener(new PanelItemListener(SHOW_MSN_ONLY));
        showOptionsPanel2.add(this.showMSnEvidence_);
        JLabel showMSnEvidence = new JLabel("Show MSn Only");
        showMSnEvidence.setToolTipText("Show only lipids with MSn headgroup evidence");
        showOptionsPanel2.add(showMSnEvidence);
        this.showChainEvidence_ = new JCheckBox("");
        this.showChainEvidence_.setEnabled(false);
        this.showChainEvidence_.addItemListener(new PanelItemListener(SHOW_CHAIN_ONLY));
        showOptionsPanel3.add(this.showChainEvidence_);
        JLabel showChainEvidence = new JLabel("Chain Evidence Only");
        showChainEvidence.setToolTipText("Show only lipids with MSn headgroup- and chain evidence");
        showOptionsPanel3.add(showChainEvidence);
        this.showMSnNames_ = new JCheckBox();
        this.showMSnNames_.addItemListener(new PanelItemListener(SHOW_MSN_NAMES));
        this.showMSnNames_.setToolTipText("<html>Should the names be displayed using MSn evidence?</html>");
        showOptionsPanel.add(this.showMSnNames_);
        JLabel showMSn = new JLabel("Show MSn");
        showMSn.setToolTipText("<html>Should the names be displayed using MSn evidence?</html>");
        showOptionsPanel.add(showMSn);
        this.show2D_ = new JCheckBox();
        this.show2D_.setSelected(true);
        this.show2D_.addItemListener(new PanelItemListener(SHOW_2D_CHANGED));
        this.show2D_.setToolTipText("<html>Should the 2D viewer be displayed or not?<br/>The 2D viewer allows to change the quantitation manually. The 3D viewer is just for displaying purposes</html>");
        showOptionsPanel.add(this.show2D_);
        JLabel show2d = new JLabel("Show 2D-View");
        show2d.setToolTipText("<html>Should the 2D viewer be displayed or not?<br/>The 2D viewer allows to change the quantitation manually. The 3D viewer is just for displaying purposes</html>");
        showOptionsPanel.add(show2d);
        this.showOmegaNames_ = new JCheckBox();
        if (this.showOmegaEditingTools_) {
            this.showOmegaNames_.addItemListener(new PanelItemListener(SHOW_OMEGA_NAMES));
            this.showOmegaNames_.setToolTipText("<html>Should assigned \u03c9 double bond positions be displayed?</html>");
            JPanel showOmegaOptionPanel = new JPanel();
            showOmegaOptionPanel.add(this.showOmegaNames_);
            JLabel showOmega = new JLabel("Show assigned \u03c9-DB");
            showOmegaOptionPanel.add(showOmega);
            this.add((Component)showOmegaOptionPanel, new GridBagConstraints(0, 6, 6, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public JTextField getDisplayMinusTolerance() {
        return this.displayMinusTolerance_;
    }

    public JTextField getDisplayPlusTolerance() {
        return this.displayPlusTolerance_;
    }

    public JTextField getDisplayRtStart() {
        return this.displayRtStart_;
    }

    public JTextField getDisplayRtStop() {
        return this.displayRtStop_;
    }

    public JCheckBox getLockMzRange() {
        return this.lockMzRange_;
    }

    public JTextField getDisplayMzStart() {
        return this.displayMzStart_;
    }

    public JTextField getDisplayMzStop() {
        return this.displayMzStop_;
    }

    public JCheckBox getShowMSnEvidence() {
        return this.showMSnEvidence_;
    }

    public JCheckBox getShowChainEvidence() {
        return this.showChainEvidence_;
    }

    public JCheckBox getShowMSnNames() {
        return this.showMSnNames_;
    }

    public JCheckBox getShow2D() {
        return this.show2D_;
    }

    public JCheckBox getShowOmegaNames() {
        return this.showOmegaNames_;
    }

    public boolean isShowOmegaEditingTools() {
        return this.showOmegaEditingTools_;
    }

    private class PanelItemListener
    implements ItemListener {
        private String m_ctrl;

        public PanelItemListener(String ctrl) {
            this.m_ctrl = ctrl;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            DisplayTolerancePanel.this.lda_.change2DTypeState(e, this.m_ctrl);
        }
    }
}

