/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda;

import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.exception.SettingsException;
import at.tugraz.genome.lda.msn.hydroxy.parser.HydroxyEncoding;
import at.tugraz.genome.lda.utils.ExcelUtils;
import at.tugraz.genome.lda.utils.Pair;
import at.tugraz.genome.lda.utils.StaticUtils;
import de.isas.mztab2.model.Contact;
import de.isas.mztab2.model.Instrument;
import de.isas.mztab2.model.Parameter;
import de.isas.mztab2.model.Publication;
import de.isas.mztab2.model.PublicationItem;
import de.isas.mztab2.model.Sample;
import de.isas.mztab2.model.SampleProcessing;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Vector;
import org.apache.poi.ss.usermodel.Sheet;

public class LipidomicsConstants {
    public static final String EXCEL_MS_OH = "OH";
    public static final int EXCEL_NO_OH_INFO = -1;
    public static final String EXCEL_KEY = "Key";
    public static final String EXCEL_VALUE = "Value";
    public static final String EXCEL_MSN_SECTION_HEAD_FRAGMENTS = "Head group fragments";
    public static final String EXCEL_MSN_SECTION_HEAD_INTENSITIES = "Head group rules";
    public static final String EXCEL_MSN_SECTION_CHAIN_FRAGMENTS = "Chain fragments";
    public static final String EXCEL_MSN_SECTION_CHAIN_INTENSITIES = "Chain rules";
    public static final String EXCEL_MSN_SECTION_POSITION_INTENSITIES = "Position rules";
    public static final String EXCEL_MSN_FRAGMENT_NAME = "Name";
    public static final String EXCEL_MSN_FRAGMENT_OH = "OH";
    public static final String EXCEL_MSN_FRAGMENT_CHAIN_TYPE = "Chain type";
    public static final String EXCEL_MSN_FRAGMENT_FORMULA = "Formula";
    public static final String EXCEL_MSN_FRAGMENT_CHARGE = "Charge";
    public static final String EXCEL_MSN_FRAGMENT_MSLEVEL = "msLevel";
    public static final String EXCEL_MSN_FRAGMENT_MZ = "Mz";
    public static final String EXCEL_MSN_FRAGMENT_MZ_TOLERANCE = "MzTolerance";
    public static final String EXCEL_MSN_FRAGMENT_AREA = "Area";
    public static final String EXCEL_MSN_FRAGMENT_PEAK = "Peak";
    public static final String EXCEL_MSN_FRAGMENT_TIME_LOWER = "LowerValley";
    public static final String EXCEL_MSN_FRAGMENT_TIME_UPPER = "UpperValley";
    public static final String EXCEL_MSN_FRAGMENT_MZ_LOWER = "LowMz";
    public static final String EXCEL_MSN_FRAGMENT_MZ_UPPER = "UpMz";
    public static final String EXCEL_MSN_FRAGMENT_ELLIPSE_TIME = "EllCentTime";
    public static final String EXCEL_MSN_FRAGMENT_ELLIPSE_MZ = "EllCentMz";
    public static final String EXCEL_MSN_FRAGMENT_ELLIPSE_TIME_RANGE = "EllStretchTime";
    public static final String EXCEL_MSN_FRAGMENT_ELLIPSE_MZ_RANGE = "EllStretchMz";
    public static final String EXCEL_MSN_INTENSITY_RULE = "Rule";
    public static final String EXCEL_MSN_INTENSITY_ORIGINAL = "Original";
    public static final String EXCEL_MSN_INTENSITY_VALUES = "Values";
    public static final String EXCEL_MSN_INTENSITY_MISSED = "Missed";
    public static final String EXCEL_HYDROXY_FA_PREFIX = "faOHEncoding_";
    public static final String EXCEL_HYDROXY_LCB_PREFIX = "lcbOHEncoding_";
    public static final short EXPORT_ANALYTE_TYPE_SPECIES = 0;
    public static final short EXPORT_ANALYTE_TYPE_CHAIN = 1;
    public static final short EXPORT_ANALYTE_TYPE_POSITION = 2;
    public static final String CHAIN_COMBI_SEPARATOR = "<->";
    public static final String CHAIN_OH_INDEX_SEPARATOR = "^";
    public static final String CHAIN_NAME_TYPE_SEPARATOR = "@";
    public static final String CHAIN_LINKAGE_INCLUSION_START = "{";
    public static final String CHAIN_LINKAGE_INCLUSION_STOP = "}";
    public static final String CHAIN_TYPE_FA_NAME = "FA";
    public static final String CHAIN_TYPE_LCB_NAME = "LCB";
    public static final short CHAIN_TYPE_MISSED = -2;
    public static final short CHAIN_TYPE_NO_CHAIN = -1;
    public static final short CHAIN_TYPE_FA_ACYL = 0;
    public static final short CHAIN_TYPE_FA_ALKYL = 1;
    public static final short CHAIN_TYPE_FA_ALKENYL = 2;
    public static final short CHAIN_TYPE_LCB = 3;
    public static final String ALKYL_PREFIX = "O-";
    public static final String ALKENYL_PREFIX = "P-";
    public static final String CHAIN_SEPARATOR_NO_POS = "_";
    public static final String CHAIN_SEPARATOR_KNOWN_POS = "/";
    public static final String CHAIN_SEPARATOR_DBS = ":";
    public static final String CHAIN_COMBI_SEPARATOR_AMBIG_POS_OLD = ";";
    public static final String SN_POSITION_START = "(sn-";
    public static final String SN_POSITION_END = ")";
    public static final String OMEGA_POSITION_START = "(n-";
    public static final String OMEGA_POSITION_END = ")";
    public static final String NO_FA_LINKED = "-";
    public static final String ALEX_OH_SEPARATOR = ";";
    public static final String ALEX_ALKYL_PREFIX = "O-";
    public static final String ALEX_ALKENYL_PREFIX = "P-";
    public static final String ALEX_CHAIN_SEPARATOR = "-";
    public static final String ALEX_IS_PREFIX = "IS ";
    public static final String CHAIN_MOD_SEPARATOR = ";";
    public static final String CHAIN_MOD_COLUMN_NAME = "PSM";
    public static String LDA_PROPERTIES_FILE = "LipidDataAnalyzer.properties";
    public static String MZTAB_PROPERTIES_FILE = "mzTab.properties";
    private static final String MZTAB_ADDUCT_PREFIX = "adduct_";
    private static LipidomicsConstants instance_ = null;
    private String ldaVersion_;
    private String rawFileName_;
    private boolean alexTargetlist_;
    private Hashtable<String, Boolean> alexTargetlistUsed_;
    private String relativeMS1BasePeakCutoff_;
    private String currentMSMachine_;
    private float neutronMass_;
    private String basePeakDefaultCutoff_;
    private double massShift_;
    private int maxFileSizeForChromTranslationAtOnceInMB_;
    private float coarseChromMzTolerance_;
    private float chromSmoothRange_;
    private int chromSmoothRepeats_;
    private boolean isotopeCorrection_;
    private boolean removeFromOtherIsotopes_;
    private boolean respectIsotopicDistribution_;
    private boolean checkChainLabelCombination_;
    private int minimumThresholdForHighConfidenceRTMatch_;
    private boolean useNoiseCutoff_;
    private float noiseCutoffDeviationValue_;
    private Float minimumRelativeIntensity_;
    private int scanStep_;
    private boolean use3D_;
    private boolean sparseData_;
    private float profileMzRange_;
    private float profileTimeTolerance_;
    private float profileIntThreshold_;
    private float broaderProfileTimeTolerance_;
    private float profileSmoothRange_;
    private int profileSmoothRepeats_;
    private int profileMeanSmoothRepeats_;
    private float profileMzMinRange_;
    private float profileSteepnessChange1_;
    private float profileSteepnessChange2_;
    private float profileIntensityCutoff1_;
    private float profileIntensityCutoff2_;
    private float profileGeneralIntCutoff_;
    private float profilePeakAcceptanceRange_;
    private float profileSmoothingCorrection_;
    private float profileMaxRange_;
    private float smallChromMzRange_;
    private int smallChromSmoothRepeats_;
    private int smallChromMeanSmoothRepeats_;
    private float smallChromSmoothRange_;
    private float smallChromIntensityCutoff_;
    private int broadChromSmoothRepeats_;
    private int broadChromMeanSmoothRepeats_;
    private int broadChromSmoothRange_;
    private float broadChromIntensityCutoff_;
    private float broadChromSteepnessChangeNoSmall_;
    private float broadChromIntensityCutoffNoSmall_;
    private float finalProbeTimeCompTolerance_;
    private float finalProbeMzCompTolerance_;
    private float overlapDistanceDeviationFactor_;
    private float overlapPossibleIntensityThreshold_;
    private float overlapSureIntensityThreshold_;
    private float overlapPeakDistanceDivisor_;
    private float overlapFullDistanceDivisor_;
    private int peakDiscardingAreaFactor_;
    private int isotopeInBetweenTime_;
    private float isoInBetweenAreaFactor_;
    private int isoInBetweenMaxTimeDistance_;
    private int isoNearNormalProbeTime_;
    private float relativeAreaCutoff_;
    private float relativeFarAreaCutoff_;
    private int relativeFarAreaTimeSpace_;
    private float relativeIsoInBetweenCutoff_;
    private int closePeakTimeTolerance_;
    private float twinInBetweenCutoff_;
    private float unionInBetweenCutoff_;
    private int chromMultiplicationFactorForInt_;
    private int chromLowestResolution_;
    private String threeDViewerDefaultTimeResolution_;
    private String threeDViewerDefaultMZResolution_;
    private boolean ms2_;
    private boolean useMostOverlappingIsotopeOnly_;
    private float ms2PrecursorTolerance_;
    private short ms2PrecursorToleranceUnit_;
    private int ms2ChromMultiplicationFactorForInt_;
    private String threeDViewerMs2DefaultTimeResolution_;
    private String threeDViewerMs2DefaultMZResolution_;
    private boolean useMsconvertForWaters_;
    private Parameter mzTabInstrumentName_;
    private Parameter mzTabInstrumentSource_;
    private Parameter mzTabInstrumentAnalyzer_;
    private Parameter mzTabInstrumentDetector_;
    private List<Contact> mzTabContacts_;
    private Sample mzTabSample_;
    private List<SampleProcessing> mzTabSampleProcessings_;
    private List<Publication> mzTabPubs_;
    private List<Parameter> fragmethods_;
    private Hashtable<String, String> mzTabAdductLookup_;
    private boolean cvSepRequired_ = false;
    private boolean cvChmoRequired_ = false;
    private boolean cvNcbiTaxonRequired_ = false;
    private boolean cvClRequired_ = false;
    private boolean cvBtoRequired_ = false;
    private boolean cvDoidRequired_ = false;
    private boolean chromExportShowLegend_;
    private float ms2MzTolerance_;
    private short ms2MzToleranceUnit_;
    private int ms2MinIntsForNoiseRemoval_;
    private double chainCutoffValue_;
    private float ms2IsobarSCExclusionRatio_;
    private float ms2IsobarSCFarExclusionRatio_;
    private float ms2IsobaricOtherRtDifference_;
    private short shotgun_;
    private String mzUnit_;
    private int shotgunProcessing_;
    private boolean shotgunIntensityRemoval_;
    private float shotgunRelIntCutoff_;
    private String intermediateFileFormat_;
    public static final short SHOTGUN_FALSE = 0;
    public static final short SHOTGUN_TRUE = 1;
    public static final short SHOTGUN_PRM = 2;
    public static final String LDA_VERSION = "LDA-version";
    public static final String RAW_FILE = "rawFile";
    public static final String BASE_PEAK_CUTOFF = "basePeakCutoff";
    private static final String BASE_PEAK_CUTOFF_DEFAULT = "0.1";
    public static final String MASS_SHIFT = "massShift";
    private static final String MASS_SHIFT_DEFAULT = "0";
    private static final String MACHINE_NAME = "machineName";
    private static final String MACHINE_NAME_DEFAULT = "";
    private static final String NEUTRON_MASS = "neutronMass";
    private static final String NEUTRON_MASS_DEFAULT = "1.005";
    private static final String MAX_CHROM_AT_ONCE_MB = "maxFileSizeForChromTranslationAtOnce";
    private static final String MAX_CHROM_AT_ONCE_MB_DEFAULT = "50";
    private static final String COARSE_CHROM_MZ_TOL = "coarseChromMzTolerance";
    private static final String COARSE_CHROM_MZ_TOL_DEFAULT = "0.02";
    private static final String CHROM_SMOOTH_RANGE = "chromSmoothRange";
    private static final String CHROM_SMOOTH_RANGE_DEFAULT = "0.5";
    private static final String CHROM_SMOOTH_REPEATS = "chromSmoothRepeats";
    private static final String CHROM_SMOOTH_REPEATS_DEFAULT = "10";
    private static final String ISOTOPE_CORRECTION = "isotopeCorrection";
    private static final String ISOTOPE_CORRECTION_DEFAULT = "false";
    private static final String DEISOTOPE_BY_MOST_OVERLAPPING = "deisotopeByMostOverlappingOnly";
    private static final String DEISOTOPE_BY_MOST_OVERLAPPING_DEFAULT = "false";
    private static final String REMOVE_FROM_OTHER_ISOTOPE = "removeFromOtherIsotopes";
    private static final String REMOVE_FROM_OTHER_ISOTOPE_DEFAULT = "true";
    private static final String RESPECT_ISO_DISTRI = "respectIsotopicDistribution";
    private static final String RESPECT_ISO_DISTRI_DEFAULT = "true";
    private static final String CHECK_CHAIN_LABEL_COMBINATION = "checkChainLabelCombinationFromSpeciesName";
    private static final String CHECK_CHAIN_LABEL_COMBINATION_DEFAULT = "false";
    private static final String NOISE_CUTOFF = "useNoiseCutoff";
    private static final String NOISE_CUTOFF_DEFAULT = "false";
    private static final String NOISE_DEVIATION = "noiseCutoffDeviationValue";
    private static final String NOISE_DEVIATION_DEFAULT = "2";
    private static final String NOISE_MIN_INTENSITY = "minimumRelativeIntensity";
    private static final String SCAN_STEP = "scanStep";
    private static final String SCAN_STEP_DEFAULT = "1";
    private static final String USE_3D = "use3D";
    private static final String SPARSE_DATA = "sparseData";
    private static final String USE_3D_DEFAULT = "true";
    private static final String PROFILE_MZ_RANGE = "profileMzRangeExtraction";
    private static final String PROFILE_MZ_RANGE_DEFAULT = "0.2";
    private static final String PROFILE_TIME_TOL = "profileTimeTolerance";
    private static final String PROFILE_TIME_TOL_DEFAULT = "2";
    private static final String PROFILE_INT_THRESHOLD = "profileIntThreshold";
    private static final String PROFILE_INT_THRESHOLD_DEFAULT = "5";
    private static final String PROFILE_BROADER_TIME_TOL = "broaderProfileTimeTolerance";
    private static final String PROFILE_BROADER_TIME_TOL_DEFAULT = "3";
    private static final String PROFILE_SMOOTH_RANGE = "profileSmoothRange";
    private static final String PROFILE_SMOOTH_RANGE_DEFAULT = "0.02";
    private static final String PROFILE_SMOOTH_REPEATS = "profileSmoothRepeats";
    private static final String PROFILE_SMOOTH_REPEATS_DEFAULT = "5";
    private static final String PROFILE_MEAN_SMOOTH_REPEATS = "profileMeanSmoothRepeats";
    private static final String PROFILE_MEAN_SMOOTH_REPEATS_DEFAULT = "0";
    private static final String PROFILE_MZ_MIN_RANGE = "profileMzMinRange";
    private static final String PROFILE_MZ_MIN_RANGE_DEFAULT = "0.0";
    private static final String PROFILE_STEEPNESS_CHANGE_1 = "profileSteepnessChange1";
    private static final String PROFILE_STEEPNESS_CHANGE_1_DEFAULT = "1.5";
    private static final String PROFILE_STEEPNESS_CHANGE_2 = "profileSteepnessChange2";
    private static final String PROFILE_STEEPNESS_CHANGE_2_DEFAULT = "1.8";
    private static final String PROFILE_INT_CUTOFF_1 = "profileIntensityCutoff1";
    private static final String PROFILE_INT_CUTOFF_1_DEFAULT = "0.15";
    private static final String PROFILE_INT_CUTOFF_2 = "profileIntensityCutoff2";
    private static final String PROFILE_INT_CUTOFF_2_DEFAULT = "0.2";
    private static final String PROFILE_GENERAL_INT_CUTOFF = "profileGeneralIntCutoff";
    private static final String PROFILE_GENERAL_INT_CUTOFF_DEFAULT = "0.03";
    private static final String PROFILE_PEAK_ACCEPTANCE_RANGE = "profilePeakAcceptanceRange";
    private static final String PROFILE_PEAK_ACCEPTANCE_RANGE_DEFAULT = "0.034";
    private static final String PROFILE_SMOOTHING_CORRECTION = "profileSmoothingCorrection";
    private static final String PROFILE_SMOOTHING_CORRECTION_DEFAULT = "0.0";
    private static final String PROFILE_MZ_MAX_RANGE = "profileMaxRange";
    private static final String PROFILE_MZ_MAX_RANGE_DEFAULT = "0.02";
    private static final String SMALL_CHROM_MZ_RANGE = "smallChromMzRange";
    private static final String SMALL_CHROM_MZ_RANGE_DEFAULT = "0.002";
    private static final String SMALL_CHROM_SMOOTH_REPEATS = "smallChromSmoothRepeats";
    private static final String SMALL_CHROM_SMOOTH_REPEATS_DEFAULT = "15";
    private static final String SMALL_CHROM_MEAN_SMOOTH_REPEATS = "smallChromMeanSmoothRepeats";
    private static final String SMALL_CHROM_MEAN_SMOOTH_REPEATS_DEFAULT = "0";
    private static final String SMALL_CHROM_SMOOTH_RANGE = "smallChromSmoothRange";
    private static final String SMALL_CHROM_SMOOTH_RANGE_DEFAULT = "5";
    private static final String SMALL_CHROM_INT_CUTOFF = "smallChromIntensityCutoff";
    private static final String SMALL_CHROM_INT_CUTOFF_DEFAULT = "0.03";
    private static final String BROAD_CHROM_SMOOTH_REPEATS = "broadChromSmoothRepeats";
    private static final String BROAD_CHROM_SMOOTH_REPEATS_DEFAULT = "10";
    private static final String BROAD_CHROM_MEAN_SMOOTH_REPEATS = "broadChromMeanSmoothRepeats";
    private static final String BROAD_CHROM_MEAN_SMOOTH_REPEATS_DEFAULT = "0";
    private static final String BROAD_CHROM_SMOOTH_RANGE = "broadChromSmoothRange";
    private static final String BROAD_CHROM_SMOOTH_RANGE_DEFAULT = "5";
    private static final String BROAD_CHROM_INT_CUTOFF = "broadChromIntensityCutoff";
    private static final String BROAD_CHROM_INT_CUTOFF_DEFAULT = "0.0";
    private static final String BROAD_CHROM_STEEPNESS_CHANGE_NO_SMALL = "broadChromSteepnessChangeNoSmall";
    private static final String BROAD_CHROM_STEEPNESS_CHANGE_NO_SMALL_DEFAULT = "1.33";
    private static final String BROAD_CHROM_INT_CUTOFF_NO_SMALL = "broadChromIntensityCutoffNoSmall";
    private static final String BROAD_CHROM_INT_CUTOFF_NO_SMALL_DEFAULT = "0.05";
    private static final String FINAL_PROBE_TIME_COMP_TOL = "finalProbeTimeCompTolerance";
    private static final String FINAL_PROBE_TIME_COMP_TOL_DEFAULT = "0.1";
    private static final String FINAL_PROBE_MZ_COMP_TOL = "finalProbeMzCompTolerance";
    private static final String FINAL_PROBE_MZ_COMP_TOL_DEFAULT = "0.0005";
    private static final String OVERLAP_DIST_DEV_FACTOR = "overlapDistanceDeviationFactor";
    private static final String OVERLAP_DIST_DEV_FACTOR_DEFAULT = "1.5";
    private static final String OVERLAP_INT_THRESHOLD = "overlapPossibleIntensityThreshold";
    private static final String OVERLAP_INT_THRESHOLD_DEFAULT = "0.15";
    private static final String OVERLAP_INT_SURE_THRESHOLD = "overlapSureIntensityThreshold";
    private static final String OVERLAP_INT_SURE_THRESHOLD_DEFAULT = "0.7";
    private static final String OVERLAP_PEAK_DIST_DIVISOR = "overlapPeakDistanceDivisor";
    private static final String OVERLAP_PEAK_DIST_DIVISOR_DEFAULT = "3";
    private static final String OVERLAP_FULL_DIST_DIVISOR = "overlapFullDistanceDivisor";
    private static final String OVERLAP_FULL_DIST_DIVISOR_DEFAULT = "6";
    private static final String PEAK_DISCARD_AREA_FACTOR = "peakDiscardingAreaFactor";
    private static final String PEAK_DISCARD_AREA_FACTOR_DEFAULT = "1000";
    private static final String ISO_IN_BETWEEN_TIME = "isotopeInBetweenTime";
    private static final String ISO_IN_BETWEEN_TIME_DEFAULT = "30";
    private static final String ISO_IN_BETWEEN_AREA_FACTOR = "isoInBetweenAreaFactor";
    private static final String ISO_IN_BETWEEN_AREA_FACTOR_DEFAULT = "3";
    private static final String ISO_IN_BETWEEN_TIME_MAX = "isoInBetweenMaxTimeDistance";
    private static final String ISO_IN_BETWEEN_TIME_MAX_DEFAULT = "300";
    private static final String ISO_NEAR_NORMAL_PROBE_TIME = "isoNearNormalProbeTime";
    private static final String ISO_NEAR_NORMAL_PROBE_TIME_DEFAULT = "30";
    private static final String RELATIVE_AREA_CUTOFF = "relativeAreaCutoff";
    private static final String RELATIVE_AREA_CUTOFF_DEFAULT = "0.01";
    private static final String RELATIVE_AREA_FAR_CUTOFF = "relativeFarAreaCutoff";
    private static final String RELATIVE_AREA_FAR_CUTOFF_DEFAULT = "0.1";
    private static final String RELATIVE_AREA_FAR_TIME_SPACE = "relativeFarAreaTimeSpace";
    private static final String RELATIVE_AREA_FAR_TIME_SPACE_DEFAULT = "30";
    private static final String RELATIVE_ISO_INBETWEEN_CUTOFF = "relativeIsoInBetweenCutoff";
    private static final String RELATIVE_ISO_INBETWEEN_CUTOFF_DEFAULT = "0.5";
    private static final String PEAK_CLOSE_TIME_TOL = "closePeakTimeTolerance";
    private static final String PEAK_CLOSE_TIME_TOL_DEFAULT = "10";
    private static final String CHROM_MULT_FOR_INT = "chromMultiplicationFactorForInt";
    private static final String CHROM_MULT_FOR_INT_DEFAULT = "1000";
    private static final String CHROM_RESOLUTION_LOWEST = "chromLowestResolution";
    private static final String CHROM_RESOLUTION_LOWEST_DEFAULT = "1";
    private static final String VIEWER_TIME_RESOLUTION = "threeDViewerDefaultTimeResolution";
    private static final String VIEWER_TIME_RESOLUTION_DEFAULT = "5";
    private static final String VIEWER_MZ_RESOLUTION = "threeDViewerDefaultMZResolution";
    private static final String VIEWER_MZ_RESOLUTION_DEFAULT = "0.005";
    private static final String TWIN_INBETWEEN_CUTOFF = "twinInBetweenCutoff";
    private static final String TWIN_INBETWEEN_CUTOFF_DEFAULT = "0.95";
    private static final String UNION_INBETWEEN_CUTOFF = "unionInBetweenCutoff";
    private static final String UNION_INBETWEEN_CUTOFF_DEFAULT = "0.8";
    private static final String MS2 = "MS2";
    private static final String MS2_DEFAULT = "false";
    private static final String MS2_PRECURSOR_TOL = "ms2PrecursorTolerance";
    private static final String MS2_PRECURSOR_TOL_DEFAULT = "0.01";
    private static final String MS2_PRECURSOR_TOL_UNIT = "ms2PrecursorToleranceUnit";
    private static final String MS2_CHROM_MULT_FOR_INT = "ms2ChromMultiplicationFactorForInt";
    private static final String MS2_CHROM_MULT_FOR_INT_DEFAULT = "10";
    private static final String MS2_VIEWER_TIME_RESOLUTION = "threeDViewerMs2DefaultTimeResolution";
    private static final String MS2_VIEWER_TIME_RESOLUTION_DEFAULT = "1";
    private static final String MS2_VIEWER_MZ_RESOLUTION = "threeDViewerMs2DefaultMZResolution";
    private static final String MS2_VIEWER_MZ_RESOLUTION_DEFAULT = "1";
    private static final String MS2_MZ_TOL = "ms2MzTolerance";
    private static final String MS2_MZ_TOL_UNIT = "ms2MzToleranceUnit";
    private static final String MS2_MIN_NOISE_REMOVAL = "ms2MinIntsForNoiseRemoval";
    private static final String MS2_ISOBAR_RATIO = "ms2IsobarSCExclusionRatio";
    private static final String MS2_ISOBAR_FAR_RATIO = "ms2IsobarSCFarExclusionRatio";
    private static final String MS2_ISOBAR_FAR_RT = "ms2IsobaricOtherRtDifference";
    private static final String MS2_MZ_TOL_DEFAULT = "0.2";
    private static final String MS2_MIN_NOISE_REMOVAL_DEFAULT = "100";
    private static final String CHAIN_CUTOFF = "chainCutoffValue";
    private static final String CHAIN_CUTOFF_DEFAULT = "0.01";
    private static final String ALEX_TARGETLIST = "alexTargetlist";
    private static final String USE_MSCONVERT_FOR_WATERS = "useMsconvertForWaters";
    private static final String MINIMUM_THRESHOLD_FOR_HIGH_CONFIDENCE_RT_MATCH = "minimumThresholdForHighConfidenceRTMatch";
    private static final String MINIMUM_THRESHOLD_FOR_HIGH_CONFIDENCE_RT_MATCH_DEFAULT = "4";
    private static final String MZTAB_INSTRUMENT = "mzTabInstrumentName";
    private static final String MZTAB_IONSOURCE = "mzTabInstrumentIonsource";
    private static final String MZTAB_MSANALYZER = "mzTabInstrumentAnalyzer";
    private static final String MZTAB_DETECTOR = "mzTabInstrumentDetector";
    private static final String CHROM_EXPORT_LEGEND_IN_CHROM = "chromexportPaintLegendInChrom";
    private static final String SHOTGUN = "shotgun";
    private static final String MZUNIT = "mzUnit";
    private static final String SHOTGUN_PROCESSING = "shotgunProcessing";
    private static final String SHOTGUN_ZERO_HANDLING = "shotgunDiscardZeros";
    public static final String MZUNIT_PPM = "ppm";
    public static final String MZUNIT_DA = "Da";
    private static final String MZUNIT_DALTON = "Dalton";
    private static final String MZUNIT_THOMPSON = "Thompson";
    private static final String MZUNIT_TH = "Th";
    private static final String MZUNIT_MZ = "m/z";
    public static final short MZUNIT_DA_ID = 0;
    public static final short MZUNIT_PPM_ID = 1;
    private static final String SHOTGUN_PROCESSING_MEAN = "mean";
    private static final String SHOTGUN_PROCESSING_MEDIAN = "median";
    private static final String SHOTGUN_PROCESSING_SUM = "sum";
    private static final String INTERMEDIATE_FILE_FORMAT = "intermediateFileFormat";
    private static final String INTERMEDIATE_FILE_FORMAT_DEFAULT = "mzXML";

    public static LipidomicsConstants getInstance() {
        if (instance_ == null) {
            instance_ = new LipidomicsConstants();
        }
        return instance_;
    }

    public LipidomicsConstants(boolean dummy) {
    }

    private LipidomicsConstants() {
        this(false);
        this.ldaVersion_ = "2.10.0_1";
        this.readConstantsFile(LDA_PROPERTIES_FILE);
        this.readmzTabConfFile(MZTAB_PROPERTIES_FILE);
    }

    private void readConstantsFile(String fileName) {
        try {
            File file = new File(fileName);
            System.out.println(file.getAbsolutePath());
            FileInputStream inNew = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(inNew);
            inNew.close();
            this.setVariables(properties);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setVariables(Properties properties) throws SettingsException {
        String sparseDataString;
        String cutoff = properties.getProperty(BASE_PEAK_CUTOFF, "0.1");
        try {
            Double.parseDouble(cutoff);
        }
        catch (NumberFormatException nfx) {
            cutoff = "0.1";
        }
        this.massShift_ = 0.0;
        String massShiftString = properties.getProperty(MASS_SHIFT, "0");
        try {
            this.massShift_ = Double.parseDouble(massShiftString) / 1000.0;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.currentMSMachine_ = properties.getProperty(MACHINE_NAME, MACHINE_NAME_DEFAULT);
        this.neutronMass_ = Float.parseFloat(properties.getProperty(NEUTRON_MASS, NEUTRON_MASS_DEFAULT));
        this.basePeakDefaultCutoff_ = cutoff;
        this.intermediateFileFormat_ = properties.getProperty(INTERMEDIATE_FILE_FORMAT, INTERMEDIATE_FILE_FORMAT_DEFAULT);
        this.maxFileSizeForChromTranslationAtOnceInMB_ = Integer.parseInt(properties.getProperty(MAX_CHROM_AT_ONCE_MB, MAX_CHROM_AT_ONCE_MB_DEFAULT));
        this.coarseChromMzTolerance_ = Float.parseFloat(properties.getProperty(COARSE_CHROM_MZ_TOL, "0.02"));
        this.chromSmoothRange_ = Float.parseFloat(properties.getProperty(CHROM_SMOOTH_RANGE, "0.5"));
        this.chromSmoothRepeats_ = Integer.parseInt(properties.getProperty(CHROM_SMOOTH_REPEATS, "10"));
        this.isotopeCorrection_ = false;
        String isotopeCorrectionString = properties.getProperty(ISOTOPE_CORRECTION, "false");
        if (isotopeCorrectionString != null && (isotopeCorrectionString.equalsIgnoreCase("yes") || isotopeCorrectionString.equalsIgnoreCase("true"))) {
            this.isotopeCorrection_ = true;
        }
        this.useMostOverlappingIsotopeOnly_ = false;
        String mostOverlappingOnlyString = properties.getProperty(DEISOTOPE_BY_MOST_OVERLAPPING, "false");
        if (mostOverlappingOnlyString != null && (mostOverlappingOnlyString.equalsIgnoreCase("yes") || mostOverlappingOnlyString.equalsIgnoreCase("true"))) {
            this.useMostOverlappingIsotopeOnly_ = true;
        }
        this.removeFromOtherIsotopes_ = true;
        String removeIsotopesString = properties.getProperty(REMOVE_FROM_OTHER_ISOTOPE, "true");
        if (removeIsotopesString != null && (removeIsotopesString.equalsIgnoreCase("no") || removeIsotopesString.equalsIgnoreCase("false"))) {
            this.removeFromOtherIsotopes_ = false;
        }
        this.respectIsotopicDistribution_ = true;
        String respectIsotopesString = properties.getProperty(RESPECT_ISO_DISTRI, "true");
        if (respectIsotopesString != null && (respectIsotopesString.equalsIgnoreCase("no") || respectIsotopesString.equalsIgnoreCase("false"))) {
            this.respectIsotopicDistribution_ = false;
        }
        this.checkChainLabelCombination_ = false;
        String checkChainLabelCombinationString = properties.getProperty(CHECK_CHAIN_LABEL_COMBINATION, "false");
        if (checkChainLabelCombinationString != null && (checkChainLabelCombinationString.equalsIgnoreCase("yes") || checkChainLabelCombinationString.equalsIgnoreCase("true"))) {
            this.checkChainLabelCombination_ = true;
        }
        this.minimumThresholdForHighConfidenceRTMatch_ = Integer.parseInt(properties.getProperty(MINIMUM_THRESHOLD_FOR_HIGH_CONFIDENCE_RT_MATCH, MINIMUM_THRESHOLD_FOR_HIGH_CONFIDENCE_RT_MATCH_DEFAULT));
        this.useNoiseCutoff_ = false;
        String cutoffString = properties.getProperty(NOISE_CUTOFF, "false");
        if (cutoffString != null && (cutoffString.equalsIgnoreCase("yes") || cutoffString.equalsIgnoreCase("true"))) {
            this.useNoiseCutoff_ = true;
        }
        this.noiseCutoffDeviationValue_ = Float.parseFloat(properties.getProperty(NOISE_DEVIATION, "2"));
        this.minimumRelativeIntensity_ = null;
        String minIntString = properties.getProperty(NOISE_MIN_INTENSITY);
        if (minIntString != null && minIntString.length() > 0) {
            try {
                this.minimumRelativeIntensity_ = new Float(minIntString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.scanStep_ = Integer.parseInt(properties.getProperty(SCAN_STEP, "1"));
        String use3DString = properties.getProperty(USE_3D, "true");
        this.use3D_ = false;
        if (use3DString != null && (use3DString.equalsIgnoreCase("true") || use3DString.equalsIgnoreCase("yes"))) {
            this.use3D_ = true;
        }
        if ((sparseDataString = properties.getProperty(SPARSE_DATA, "false")) != null && (sparseDataString.equalsIgnoreCase("true") || sparseDataString.equalsIgnoreCase("yes"))) {
            this.sparseData_ = true;
        }
        this.profileMzRange_ = Float.parseFloat(properties.getProperty(PROFILE_MZ_RANGE, "0.2")) / 2.0f;
        this.profileTimeTolerance_ = Float.parseFloat(properties.getProperty(PROFILE_TIME_TOL, "2"));
        this.profileIntThreshold_ = Float.parseFloat(properties.getProperty(PROFILE_INT_THRESHOLD, "5"));
        this.broaderProfileTimeTolerance_ = Float.parseFloat(properties.getProperty(PROFILE_BROADER_TIME_TOL, "3"));
        this.profileSmoothRange_ = Float.parseFloat(properties.getProperty(PROFILE_SMOOTH_RANGE, "0.02"));
        this.profileSmoothRepeats_ = Integer.parseInt(properties.getProperty(PROFILE_SMOOTH_REPEATS, "5"));
        this.profileMeanSmoothRepeats_ = Integer.parseInt(properties.getProperty(PROFILE_MEAN_SMOOTH_REPEATS, "0"));
        this.profileMzMinRange_ = Float.parseFloat(properties.getProperty(PROFILE_MZ_MIN_RANGE, "0.0"));
        this.profileSteepnessChange1_ = Float.parseFloat(properties.getProperty(PROFILE_STEEPNESS_CHANGE_1, "1.5"));
        this.profileSteepnessChange2_ = Float.parseFloat(properties.getProperty(PROFILE_STEEPNESS_CHANGE_2, PROFILE_STEEPNESS_CHANGE_2_DEFAULT));
        this.profileIntensityCutoff1_ = Float.parseFloat(properties.getProperty(PROFILE_INT_CUTOFF_1, "0.15"));
        this.profileIntensityCutoff2_ = Float.parseFloat(properties.getProperty(PROFILE_INT_CUTOFF_2, "0.2"));
        this.profileGeneralIntCutoff_ = Float.parseFloat(properties.getProperty(PROFILE_GENERAL_INT_CUTOFF, "0.03"));
        this.profilePeakAcceptanceRange_ = Float.parseFloat(properties.getProperty(PROFILE_PEAK_ACCEPTANCE_RANGE, PROFILE_PEAK_ACCEPTANCE_RANGE_DEFAULT));
        this.profileSmoothingCorrection_ = Float.parseFloat(properties.getProperty(PROFILE_SMOOTHING_CORRECTION, "0.0"));
        this.profileMaxRange_ = Float.parseFloat(properties.getProperty(PROFILE_MZ_MAX_RANGE, "0.02"));
        this.smallChromMzRange_ = Float.parseFloat(properties.getProperty(SMALL_CHROM_MZ_RANGE, SMALL_CHROM_MZ_RANGE_DEFAULT));
        this.smallChromSmoothRepeats_ = Integer.parseInt(properties.getProperty(SMALL_CHROM_SMOOTH_REPEATS, SMALL_CHROM_SMOOTH_REPEATS_DEFAULT));
        this.smallChromMeanSmoothRepeats_ = Integer.parseInt(properties.getProperty(SMALL_CHROM_MEAN_SMOOTH_REPEATS, "0"));
        this.smallChromSmoothRange_ = Float.parseFloat(properties.getProperty(SMALL_CHROM_SMOOTH_RANGE, "5"));
        this.smallChromIntensityCutoff_ = Float.parseFloat(properties.getProperty(SMALL_CHROM_INT_CUTOFF, "0.03"));
        this.broadChromSmoothRepeats_ = Integer.parseInt(properties.getProperty(BROAD_CHROM_SMOOTH_REPEATS, "10"));
        this.broadChromMeanSmoothRepeats_ = Integer.parseInt(properties.getProperty(BROAD_CHROM_MEAN_SMOOTH_REPEATS, "0"));
        this.broadChromSmoothRange_ = Integer.parseInt(properties.getProperty(BROAD_CHROM_SMOOTH_RANGE, "5"));
        this.broadChromIntensityCutoff_ = Float.parseFloat(properties.getProperty(BROAD_CHROM_INT_CUTOFF, "0.0"));
        this.broadChromSteepnessChangeNoSmall_ = Float.parseFloat(properties.getProperty(BROAD_CHROM_STEEPNESS_CHANGE_NO_SMALL, BROAD_CHROM_STEEPNESS_CHANGE_NO_SMALL_DEFAULT));
        this.broadChromIntensityCutoffNoSmall_ = Float.parseFloat(properties.getProperty(BROAD_CHROM_INT_CUTOFF_NO_SMALL, BROAD_CHROM_INT_CUTOFF_NO_SMALL_DEFAULT));
        this.finalProbeTimeCompTolerance_ = Float.parseFloat(properties.getProperty(FINAL_PROBE_TIME_COMP_TOL, "0.1"));
        this.finalProbeMzCompTolerance_ = Float.parseFloat(properties.getProperty(FINAL_PROBE_MZ_COMP_TOL, FINAL_PROBE_MZ_COMP_TOL_DEFAULT));
        this.overlapDistanceDeviationFactor_ = Float.parseFloat(properties.getProperty(OVERLAP_DIST_DEV_FACTOR, "1.5"));
        this.overlapPossibleIntensityThreshold_ = Float.parseFloat(properties.getProperty(OVERLAP_INT_THRESHOLD, "0.15"));
        this.overlapSureIntensityThreshold_ = Float.parseFloat(properties.getProperty(OVERLAP_INT_SURE_THRESHOLD, OVERLAP_INT_SURE_THRESHOLD_DEFAULT));
        this.overlapPeakDistanceDivisor_ = Float.parseFloat(properties.getProperty(OVERLAP_PEAK_DIST_DIVISOR, "3"));
        this.overlapFullDistanceDivisor_ = Float.parseFloat(properties.getProperty(OVERLAP_FULL_DIST_DIVISOR, OVERLAP_FULL_DIST_DIVISOR_DEFAULT));
        this.peakDiscardingAreaFactor_ = Integer.parseInt(properties.getProperty(PEAK_DISCARD_AREA_FACTOR, "1000"));
        this.isotopeInBetweenTime_ = Integer.parseInt(properties.getProperty(ISO_IN_BETWEEN_TIME, "30"));
        this.isoInBetweenAreaFactor_ = Float.parseFloat(properties.getProperty(ISO_IN_BETWEEN_AREA_FACTOR, "3"));
        this.isoInBetweenMaxTimeDistance_ = Integer.parseInt(properties.getProperty(ISO_IN_BETWEEN_TIME_MAX, ISO_IN_BETWEEN_TIME_MAX_DEFAULT));
        this.isoNearNormalProbeTime_ = Integer.parseInt(properties.getProperty(ISO_NEAR_NORMAL_PROBE_TIME, "30"));
        this.relativeAreaCutoff_ = Float.parseFloat(properties.getProperty(RELATIVE_AREA_CUTOFF, "0.01"));
        this.relativeFarAreaCutoff_ = Float.parseFloat(properties.getProperty(RELATIVE_AREA_FAR_CUTOFF, "0.1"));
        this.relativeFarAreaTimeSpace_ = Integer.parseInt(properties.getProperty(RELATIVE_AREA_FAR_TIME_SPACE, "30"));
        this.relativeIsoInBetweenCutoff_ = Float.parseFloat(properties.getProperty(RELATIVE_ISO_INBETWEEN_CUTOFF, "0.5"));
        this.closePeakTimeTolerance_ = Integer.parseInt(properties.getProperty(PEAK_CLOSE_TIME_TOL, "10"));
        this.chromMultiplicationFactorForInt_ = Integer.parseInt(properties.getProperty(CHROM_MULT_FOR_INT, "1000"));
        this.chromLowestResolution_ = Integer.parseInt(properties.getProperty(CHROM_RESOLUTION_LOWEST, "1"));
        this.threeDViewerDefaultTimeResolution_ = properties.getProperty(VIEWER_TIME_RESOLUTION, "5");
        try {
            Double.parseDouble(this.threeDViewerDefaultTimeResolution_);
        }
        catch (NumberFormatException nfx) {
            this.threeDViewerDefaultTimeResolution_ = "5";
        }
        this.threeDViewerDefaultMZResolution_ = properties.getProperty(VIEWER_MZ_RESOLUTION, VIEWER_MZ_RESOLUTION_DEFAULT);
        try {
            Double.parseDouble(this.threeDViewerDefaultMZResolution_);
        }
        catch (NumberFormatException nfx) {
            this.threeDViewerDefaultTimeResolution_ = VIEWER_MZ_RESOLUTION_DEFAULT;
        }
        this.twinInBetweenCutoff_ = Float.parseFloat(properties.getProperty(TWIN_INBETWEEN_CUTOFF, TWIN_INBETWEEN_CUTOFF_DEFAULT));
        this.unionInBetweenCutoff_ = Float.parseFloat(properties.getProperty(UNION_INBETWEEN_CUTOFF, UNION_INBETWEEN_CUTOFF_DEFAULT));
        String ms2String = properties.getProperty(MS2, "false");
        this.ms2_ = false;
        if (ms2String != null && (ms2String.equalsIgnoreCase("true") || ms2String.equalsIgnoreCase("yes"))) {
            this.ms2_ = true;
        }
        this.ms2PrecursorTolerance_ = Float.parseFloat(properties.getProperty(MS2_PRECURSOR_TOL, "0.01"));
        String ms2PrecursorToleranceUnitString = properties.getProperty(MS2_PRECURSOR_TOL_UNIT, MZUNIT_DA);
        this.ms2PrecursorToleranceUnit_ = 0;
        if (ms2PrecursorToleranceUnitString.equalsIgnoreCase(MZUNIT_PPM)) {
            this.ms2PrecursorToleranceUnit_ = 1;
        }
        this.ms2ChromMultiplicationFactorForInt_ = Integer.parseInt(properties.getProperty(MS2_CHROM_MULT_FOR_INT, "10"));
        this.threeDViewerMs2DefaultTimeResolution_ = properties.getProperty(MS2_VIEWER_TIME_RESOLUTION, "1");
        try {
            Float.parseFloat(this.threeDViewerMs2DefaultTimeResolution_);
        }
        catch (NumberFormatException nfx) {
            this.threeDViewerMs2DefaultTimeResolution_ = "1";
        }
        this.threeDViewerMs2DefaultMZResolution_ = properties.getProperty(MS2_VIEWER_MZ_RESOLUTION, "1");
        try {
            Float.parseFloat(this.threeDViewerMs2DefaultMZResolution_);
        }
        catch (NumberFormatException nfx) {
            this.threeDViewerMs2DefaultMZResolution_ = "1";
        }
        this.ms2MzTolerance_ = Float.parseFloat(properties.getProperty(MS2_MZ_TOL, "0.2"));
        String ms2MzToleranceString = properties.getProperty(MS2_MZ_TOL_UNIT, MZUNIT_DA);
        this.ms2MzToleranceUnit_ = 0;
        if (ms2MzToleranceString.equalsIgnoreCase(MZUNIT_PPM)) {
            this.ms2MzToleranceUnit_ = 1;
        }
        try {
            this.ms2MinIntsForNoiseRemoval_ = Integer.parseInt(properties.getProperty(MS2_MIN_NOISE_REMOVAL, MS2_MIN_NOISE_REMOVAL_DEFAULT));
        }
        catch (NumberFormatException nfx) {
            throw new SettingsException("Invalid input for ms2MinIntsForNoiseRemoval! The input must be in integer format!");
        }
        this.ms2IsobarSCExclusionRatio_ = 0.0f;
        String ms2IsobarSCExclusionRatioString = properties.getProperty(MS2_ISOBAR_RATIO);
        if (ms2IsobarSCExclusionRatioString != null && ms2IsobarSCExclusionRatioString.length() > 0) {
            try {
                this.ms2IsobarSCExclusionRatio_ = Float.parseFloat(ms2IsobarSCExclusionRatioString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.ms2IsobarSCFarExclusionRatio_ = 0.0f;
        String ms2IsobarSCFarExclusionRatioString = properties.getProperty(MS2_ISOBAR_FAR_RATIO);
        if (ms2IsobarSCFarExclusionRatioString != null && ms2IsobarSCFarExclusionRatioString.length() > 0) {
            try {
                this.ms2IsobarSCFarExclusionRatio_ = Float.parseFloat(ms2IsobarSCFarExclusionRatioString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.ms2IsobaricOtherRtDifference_ = Float.MAX_VALUE;
        String ms2IsobaricOtherRtDifferenceString = properties.getProperty(MS2_ISOBAR_FAR_RT);
        if (ms2IsobaricOtherRtDifferenceString != null && ms2IsobaricOtherRtDifferenceString.length() > 0) {
            try {
                this.ms2IsobaricOtherRtDifference_ = Float.parseFloat(ms2IsobaricOtherRtDifferenceString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.chainCutoffValue_ = Double.parseDouble(properties.getProperty(CHAIN_CUTOFF, "0.01"));
        String chromExportString = properties.getProperty(CHROM_EXPORT_LEGEND_IN_CHROM);
        this.chromExportShowLegend_ = false;
        if (chromExportString != null && (chromExportString.equalsIgnoreCase("true") || chromExportString.equalsIgnoreCase("yes"))) {
            this.chromExportShowLegend_ = true;
        }
        String alexTargetlistString = properties.getProperty(ALEX_TARGETLIST, "false");
        this.alexTargetlist_ = false;
        if (alexTargetlistString != null && (alexTargetlistString.equalsIgnoreCase("true") || alexTargetlistString.equalsIgnoreCase("yes"))) {
            this.alexTargetlist_ = true;
        }
        this.alexTargetlistUsed_ = new Hashtable();
        String useMsconvertForWatersString = properties.getProperty(USE_MSCONVERT_FOR_WATERS, "false");
        this.useMsconvertForWaters_ = false;
        if (useMsconvertForWatersString != null && (useMsconvertForWatersString.equalsIgnoreCase("true") || useMsconvertForWatersString.equalsIgnoreCase("yes"))) {
            this.useMsconvertForWaters_ = true;
        }
        this.mzTabInstrumentName_ = this.extractEBIParam(MZTAB_INSTRUMENT, properties);
        this.mzTabInstrumentSource_ = this.extractEBIParam(MZTAB_IONSOURCE, properties);
        this.mzTabInstrumentAnalyzer_ = this.extractEBIParam(MZTAB_MSANALYZER, properties);
        this.mzTabInstrumentDetector_ = this.extractEBIParam(MZTAB_DETECTOR, properties);
        String shotgunString = properties.getProperty(SHOTGUN, "false");
        this.shotgun_ = 0;
        if (shotgunString != null && (shotgunString.equalsIgnoreCase("true") || shotgunString.equalsIgnoreCase("yes"))) {
            this.shotgun_ = 1;
        }
        if (shotgunString != null && shotgunString.equalsIgnoreCase("prm")) {
            this.shotgun_ = (short)2;
        }
        String mzUnitString = properties.getProperty(MZUNIT, MZUNIT_PPM);
        this.mzUnit_ = MZUNIT_PPM;
        if (this.shotgun_ == 0 || mzUnitString.equalsIgnoreCase(MZUNIT_DA) || mzUnitString.equalsIgnoreCase(MZUNIT_DALTON) || mzUnitString.equalsIgnoreCase(MZUNIT_THOMPSON) || mzUnitString.equalsIgnoreCase(MZUNIT_TH) || mzUnitString.equalsIgnoreCase(MZUNIT_MZ)) {
            this.mzUnit_ = MZUNIT_DA;
        }
        this.shotgunProcessing_ = 0;
        if (this.shotgun_ == 1) {
            String processingString = properties.getProperty(SHOTGUN_PROCESSING);
            if (processingString == null) {
                throw new SettingsException("When there is shotgun data, the \"shotgunProcessing\" has to be set!");
            }
            if (processingString.equalsIgnoreCase(SHOTGUN_PROCESSING_MEAN)) {
                this.shotgunProcessing_ = 0;
            } else if (processingString.equalsIgnoreCase(SHOTGUN_PROCESSING_MEDIAN)) {
                this.shotgunProcessing_ = 1;
            } else if (processingString.equalsIgnoreCase(SHOTGUN_PROCESSING_SUM)) {
                this.shotgunProcessing_ = 2;
            } else {
                throw new SettingsException("The shotgun processing type \"" + processingString + "\" is unknown! Please use " + SHOTGUN_PROCESSING_MEAN + ", " + SHOTGUN_PROCESSING_MEDIAN + ", or " + SHOTGUN_PROCESSING_SUM + " instead!");
            }
        }
        String shotgunZeroHandlingString = properties.getProperty(SHOTGUN_ZERO_HANDLING, "false");
        this.shotgunIntensityRemoval_ = false;
        this.shotgunRelIntCutoff_ = -1.0f;
        if (!shotgunZeroHandlingString.equalsIgnoreCase("false") && !shotgunZeroHandlingString.equalsIgnoreCase("no")) {
            if (shotgunZeroHandlingString.equalsIgnoreCase("true") || shotgunZeroHandlingString.equalsIgnoreCase("yes")) {
                this.shotgunIntensityRemoval_ = true;
                this.shotgunRelIntCutoff_ = 0.0f;
            } else {
                try {
                    this.shotgunRelIntCutoff_ = (float)StaticUtils.readPercentPermilleValue(shotgunZeroHandlingString);
                    this.shotgunIntensityRemoval_ = true;
                }
                catch (NumberFormatException nfx) {
                    throw new SettingsException("Invalid input for shotgunDiscardZeros! The following values are allowed: true, false, or any float format that might be followed by % or \u2030!");
                }
            }
        }
    }

    public static String getIntermediateFileFormat() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.intermediateFileFormat_;
    }

    public static int getmMaxFileSizeForChromTranslationAtOnceInMB() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.maxFileSizeForChromTranslationAtOnceInMB_;
    }

    public static float getCoarseChromMzTolerance(float mz) {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.getCorrectMzTolerance(LipidomicsConstants.instance_.coarseChromMzTolerance_, LipidomicsConstants.instance_.mzUnit_, mz);
    }

    public static double getMassShift() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.massShift_;
    }

    public static float getChromSmoothRange() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.chromSmoothRange_;
    }

    public static int getChromSmoothRepeats() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.chromSmoothRepeats_;
    }

    public static boolean isotopicCorrection() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.isotopeCorrection_;
    }

    public static boolean removeIfOtherIsotopePresent() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.removeFromOtherIsotopes_;
    }

    public static boolean removeIfDistriDoesNotFit() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.respectIsotopicDistribution_;
    }

    public static boolean useNoiseCutoff() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.useNoiseCutoff_;
    }

    public static boolean checkChainLabelCombination() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.checkChainLabelCombination_;
    }

    public static int getMinimumThresholdForHighConfidenceRTMatch() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.minimumThresholdForHighConfidenceRTMatch_;
    }

    public static float getNoiseCutoffDeviationValue() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.noiseCutoffDeviationValue_;
    }

    public static Float getMinimumRelativeIntensity() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.minimumRelativeIntensity_;
    }

    public static int getScanStep() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.scanStep_;
    }

    public static boolean use3D() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.use3D_;
    }

    public static float getProfileMzRange() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.profileMzRange_;
    }

    public static float getProfileTimeTolerance_() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.profileTimeTolerance_;
    }

    public static float getProfileIntThreshold_() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.profileIntThreshold_;
    }

    public static float getBroaderProfileTimeTolerance_() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.broaderProfileTimeTolerance_;
    }

    public static float getProfileSmoothRange() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.profileSmoothRange_;
    }

    public static int getProfileSmoothRepeats() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.profileSmoothRepeats_;
    }

    public static int getProfileMeanSmoothRepeats() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.profileMeanSmoothRepeats_;
    }

    public static float getProfileMzMinRange() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.profileMzMinRange_;
    }

    public static float getProfileSteepnessChange1() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.profileSteepnessChange1_;
    }

    public static float getProfileSteepnessChange2() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.profileSteepnessChange2_;
    }

    public static float getProfileIntensityCutoff1() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.profileIntensityCutoff1_;
    }

    public static float getProfileIntensityCutoff2() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.profileIntensityCutoff2_;
    }

    public static float getProfileGeneralIntCutoff() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.profileGeneralIntCutoff_;
    }

    public static float getProfilePeakAcceptanceRange() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.profilePeakAcceptanceRange_;
    }

    public static float getProfileSmoothingCorrection() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.profileSmoothingCorrection_;
    }

    public static float getProfileMaxRange() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.profileMaxRange_;
    }

    public static float getSmallChromMzRange() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.smallChromMzRange_;
    }

    public static int getSmallChromSmoothRepeats() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.smallChromSmoothRepeats_;
    }

    public static int getSmallChromMeanSmoothRepeats() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.smallChromMeanSmoothRepeats_;
    }

    public static float getSmallChromSmoothRange() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.smallChromSmoothRange_;
    }

    public static float getSmallChromIntensityCutoff() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.smallChromIntensityCutoff_;
    }

    public static int getBroadChromSmoothRepeats() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.broadChromSmoothRepeats_;
    }

    public static int getBroadChromMeanSmoothRepeats() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.broadChromMeanSmoothRepeats_;
    }

    public static float getBroadChromSmoothRange() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.broadChromSmoothRange_;
    }

    public static float getBroadChromIntensityCutoff() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.broadChromIntensityCutoff_;
    }

    public static float getBroadChromSteepnessChangeNoSmall() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.broadChromSteepnessChangeNoSmall_;
    }

    public static float getBroadIntensityCutoffNoSmall() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.broadChromIntensityCutoffNoSmall_;
    }

    public static float getFinalProbeTimeCompTolerance() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.finalProbeTimeCompTolerance_;
    }

    public static float getFinalProbeMzCompTolerance() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.finalProbeMzCompTolerance_;
    }

    public static float getOverlapDistanceDeviationFactor() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.overlapDistanceDeviationFactor_;
    }

    public static float getOverlapPossibleIntensityThreshold() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.overlapPossibleIntensityThreshold_;
    }

    public static float getOverlapSureIntensityThreshold() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.overlapSureIntensityThreshold_;
    }

    public static float getOverlapPeakDistanceDivisor() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.overlapPeakDistanceDivisor_;
    }

    public static float getOverlapFullDistanceDivisor() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.overlapFullDistanceDivisor_;
    }

    public static int getPeakDiscardingAreaFactor() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.peakDiscardingAreaFactor_;
    }

    public static int getIsotopeInBetweenTime() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.isotopeInBetweenTime_;
    }

    public static float getIsoInBetweenAreaFactor() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.isoInBetweenAreaFactor_;
    }

    public static int getIsoInBetweenMaxTimeDistance() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.isoInBetweenMaxTimeDistance_;
    }

    public static int getIsoNearNormalProbeTime() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.isoNearNormalProbeTime_;
    }

    public static float getRelativeAreaCutoff() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.relativeAreaCutoff_;
    }

    public static float getRelativeFarAreaCutoff() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.relativeFarAreaCutoff_;
    }

    public static int getRelativeFarAreaTimeSpace() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.relativeFarAreaTimeSpace_;
    }

    public static float getTwinInBetweenCutoff() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.twinInBetweenCutoff_;
    }

    public static float getUnionInBetweenCutoff() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.unionInBetweenCutoff_;
    }

    public static float getRelativeIsoInBetweenCutoff() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.relativeIsoInBetweenCutoff_;
    }

    public static int getClosePeakTimeTolerance() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.closePeakTimeTolerance_;
    }

    public static String getBasePeakDefaultCutoff() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.basePeakDefaultCutoff_;
    }

    public static int getChromMultiplicationFactorForInt() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.chromMultiplicationFactorForInt_;
    }

    public static int getChromLowestResolution() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.chromLowestResolution_;
    }

    public static String getThreeDViewerDefaultTimeResolution() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.threeDViewerDefaultTimeResolution_;
    }

    public static String getThreeDViewerDefaultMZResolution() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.threeDViewerDefaultMZResolution_;
    }

    public static boolean isMS2() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.ms2_;
    }

    private static float getMs2PrecursorTolerance() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.ms2PrecursorTolerance_;
    }

    public static short getMs2PrecursorToleranceUnit() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.ms2PrecursorToleranceUnit_;
    }

    public static int getMs2ChromMultiplicationFactorForInt() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.ms2ChromMultiplicationFactorForInt_;
    }

    public static String getThreeDViewerMs2DefaultTimeResolution_() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.threeDViewerMs2DefaultTimeResolution_;
    }

    public static String getThreeDViewerMs2DefaultMZResolution() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.threeDViewerMs2DefaultMZResolution_;
    }

    public static boolean isChromExportShowLegend() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.chromExportShowLegend_;
    }

    public static float getMs2MzTolerance() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.ms2MzTolerance_;
    }

    public static short getMs2MzToleranceUnit() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.ms2MzToleranceUnit_;
    }

    public static int getMs2MinIntsForNoiseRemoval() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.ms2MinIntsForNoiseRemoval_;
    }

    public static float getMs2IsobarSCExclusionRatio() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.ms2IsobarSCExclusionRatio_;
    }

    public static float getMs2IsobarSCFarExclusionRatio() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.ms2IsobarSCFarExclusionRatio_;
    }

    public static float getMs2IsobaricOtherRtDifference() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.ms2IsobaricOtherRtDifference_;
    }

    public static short isShotgun() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.shotgun_;
    }

    public static String getMzUnit() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.mzUnit_;
    }

    public static int getShogunProcessing() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.shotgunProcessing_;
    }

    public static boolean isShotgunIntensityRemoval() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.shotgunIntensityRemoval_;
    }

    public static float getShotgunRelIntCutoff() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.shotgunRelIntCutoff_;
    }

    public static double getChainCutoffValue() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.chainCutoffValue_;
    }

    public static String getCurrentMSMachine() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.currentMSMachine_;
    }

    public static float getNeutronMass() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.neutronMass_;
    }

    public static boolean useMostOverlappingIsotopeOnly() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.useMostOverlappingIsotopeOnly_;
    }

    public static boolean isSparseData() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.sparseData_;
    }

    public static Instrument getMzTabInstrument() {
        LipidomicsConstants.getInstance();
        if (LipidomicsConstants.instance_.mzTabInstrumentName_ != null || LipidomicsConstants.instance_.mzTabInstrumentSource_ != null || LipidomicsConstants.instance_.mzTabInstrumentAnalyzer_ != null || LipidomicsConstants.instance_.mzTabInstrumentDetector_ != null) {
            Instrument instrument = new Instrument().id(1);
            instrument.addAnalyzerItem(LipidomicsConstants.instance_.mzTabInstrumentAnalyzer_);
            instrument.setDetector(LipidomicsConstants.instance_.mzTabInstrumentDetector_);
            instrument.setName(LipidomicsConstants.instance_.mzTabInstrumentName_);
            instrument.setSource(LipidomicsConstants.instance_.mzTabInstrumentSource_);
            return instrument;
        }
        return null;
    }

    public static List<Contact> getMzTabContacts() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.mzTabContacts_;
    }

    public static List<SampleProcessing> getMzTabSampleprocessings() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.mzTabSampleProcessings_;
    }

    public static List<Publication> getMzTabPublications() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.mzTabPubs_;
    }

    public static List<Parameter> getFragmentationMethods() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.fragmethods_;
    }

    public static Sample getMzTabSample() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.mzTabSample_;
    }

    public short getShotgun() {
        LipidomicsConstants.getInstance();
        return this.shotgun_;
    }

    public static String getMzTabAdduct(String ldaAdduct) {
        LipidomicsConstants.getInstance();
        String mzTabAdduct = null;
        if (LipidomicsConstants.instance_.mzTabAdductLookup_.containsKey(ldaAdduct)) {
            mzTabAdduct = LipidomicsConstants.instance_.mzTabAdductLookup_.get(ldaAdduct);
        }
        return mzTabAdduct;
    }

    public static boolean isCvSepRequired() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.cvSepRequired_;
    }

    public static boolean isCvNcbiTaxonRequired() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.cvNcbiTaxonRequired_;
    }

    public static boolean isClRequired() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.cvClRequired_;
    }

    public static boolean isCvBtoRequired() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.cvBtoRequired_;
    }

    public static boolean isCvDoidRequired() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.cvDoidRequired_;
    }

    public static boolean isCvChmoRequired() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.cvChmoRequired_;
    }

    public static void switchToOtherConfFile(File newConfFile) {
        LipidomicsConstants.getInstance();
        instance_.readConstantsFile(newConfFile.getAbsolutePath());
    }

    public static void switchToOtherDefaultConfFile(File newConfFile) throws IOException {
        int len;
        LipidomicsConstants.getInstance();
        int chunkSize = 1024;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(newConfFile));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(LDA_PROPERTIES_FILE));
        byte[] buffer = new byte[chunkSize];
        while ((len = ((InputStream)in).read(buffer)) > 0) {
            ((OutputStream)out).write(buffer, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
        instance_.readConstantsFile(LDA_PROPERTIES_FILE);
    }

    private Parameter extractEBIParam(String key, Properties properties) {
        Vector<String> split;
        Parameter param = null;
        String paramString = properties.getProperty(key, MACHINE_NAME_DEFAULT);
        if (paramString != null && paramString.length() > 0 && paramString.indexOf(",") != -1 && (split = LipidomicsConstants.splitByComma(paramString)).size() == 4) {
            String cvLabel = MACHINE_NAME_DEFAULT;
            if (split.get(0) != null && split.get(0).length() > 0) {
                cvLabel = split.get(0);
                if (!this.cvSepRequired_ && cvLabel.equalsIgnoreCase("SEP")) {
                    this.cvSepRequired_ = true;
                } else if (!this.cvNcbiTaxonRequired_ && cvLabel.equalsIgnoreCase("NCBITaxon")) {
                    this.cvNcbiTaxonRequired_ = true;
                } else if (!this.cvClRequired_ && cvLabel.equalsIgnoreCase("CL")) {
                    this.cvClRequired_ = true;
                } else if (!this.cvBtoRequired_ && cvLabel.equalsIgnoreCase("BTO")) {
                    this.cvBtoRequired_ = true;
                } else if (!this.cvDoidRequired_ && cvLabel.equalsIgnoreCase("DOID")) {
                    this.cvDoidRequired_ = true;
                }
                if (!this.cvChmoRequired_ && cvLabel.equalsIgnoreCase("CHMO")) {
                    this.cvChmoRequired_ = true;
                }
            }
            String accession = MACHINE_NAME_DEFAULT;
            if (split.get(1) != null && split.get(1).length() > 0) {
                accession = split.get(1);
            }
            String name = MACHINE_NAME_DEFAULT;
            if (split.get(2) != null && split.get(2).length() > 0) {
                name = split.get(2);
            }
            String value = null;
            if (split.get(3) != null && split.get(3).length() > 0) {
                value = split.get(3);
            }
            param = new Parameter().cvLabel(cvLabel).cvAccession(accession).name(name).value(value);
        }
        return param;
    }

    private static Vector<String> splitByComma(String str) {
        Vector<String> splitString = new Vector<String>();
        String clone = new String(str);
        int pos = -1;
        while ((pos = clone.indexOf(",")) != -1) {
            splitString.add(clone.substring(0, pos).trim());
            clone = clone.substring(pos + 1);
        }
        splitString.add(clone.trim());
        return splitString;
    }

    private static int countComma(String str) {
        String clone = new String(str);
        int pos = -1;
        int count = 0;
        while ((pos = clone.indexOf(",")) != -1) {
            clone = clone.substring(pos + 1);
            ++count;
        }
        return count;
    }

    private void readmzTabConfFile(String fileName) {
        try {
            File file = new File(fileName);
            this.mzTabAdductLookup_ = new Hashtable();
            if (file.exists()) {
                FileInputStream inNew = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(inNew);
                inNew.close();
                this.mzTabContacts_ = new ArrayList<Contact>();
                String propBase = "contact_";
                String propBase2 = MACHINE_NAME_DEFAULT;
                int count = 1;
                String contactString = MACHINE_NAME_DEFAULT;
                while ((contactString = properties.getProperty(propBase + String.valueOf(count), MACHINE_NAME_DEFAULT)) != null && contactString.length() > 0) {
                    ++count;
                    if (LipidomicsConstants.countComma(contactString) < 2) continue;
                    String name = contactString.substring(0, contactString.indexOf(","));
                    contactString = contactString.substring(contactString.indexOf(",") + 1);
                    String email = contactString.substring(0, contactString.indexOf(","));
                    String affiliation = contactString.substring(contactString.indexOf(",") + 1);
                    Contact contact = new Contact();
                    contact.setId(count - 1);
                    contact.setAffiliation(affiliation);
                    contact.setEmail(email);
                    contact.setName(name);
                    this.mzTabContacts_.add(contact);
                }
                this.mzTabSampleProcessings_ = new ArrayList<SampleProcessing>();
                String processingString = MACHINE_NAME_DEFAULT;
                propBase = "sampleprocessing_";
                count = 1;
                while ((processingString = properties.getProperty(propBase + String.valueOf(count), MACHINE_NAME_DEFAULT)) != null && processingString.length() > 0) {
                    ++count;
                    int commas = LipidomicsConstants.countComma(processingString);
                    if (LipidomicsConstants.countComma(processingString) < 1) continue;
                    SampleProcessing processing = new SampleProcessing().id(count - 1);
                    Parameter procDetails = null;
                    procDetails = commas == 1 ? new Parameter().name(processingString.substring(0, processingString.indexOf(","))).value(processingString.substring(processingString.indexOf(",") + 1)) : this.extractEBIParam(propBase + String.valueOf(count - 1), properties);
                    processing.addSampleProcessingItem(procDetails);
                    this.mzTabSampleProcessings_.add(processing);
                }
                this.mzTabPubs_ = new ArrayList<Publication>();
                String publicationString1 = MACHINE_NAME_DEFAULT;
                String publicationString2 = MACHINE_NAME_DEFAULT;
                propBase = "pubmedid_";
                propBase2 = "doi_";
                count = 1;
                while (true) {
                    PublicationItem item;
                    publicationString2 = properties.getProperty(propBase2 + String.valueOf(count), MACHINE_NAME_DEFAULT);
                    publicationString1 = properties.getProperty(propBase + String.valueOf(count), MACHINE_NAME_DEFAULT);
                    if (!((publicationString1 != null && publicationString1.length() > 0) | (publicationString2 != null && publicationString2.length() > 0))) break;
                    Publication pub = new Publication().id(++count - 1);
                    if (publicationString1 != null && publicationString1.length() > 0) {
                        item = new PublicationItem().accession(publicationString1).type(PublicationItem.TypeEnum.PUBMED);
                        pub.addPublicationItemsItem(item);
                    }
                    if (publicationString2 != null && publicationString2.length() > 0) {
                        item = new PublicationItem().accession(publicationString2).type(PublicationItem.TypeEnum.DOI);
                        pub.addPublicationItemsItem(item);
                    }
                    this.mzTabPubs_.add(pub);
                }
                this.mzTabSample_ = null;
                Parameter mzTabSpecies = this.extractEBIParam("species", properties);
                Parameter mzTabTissue = this.extractEBIParam("tissue", properties);
                Parameter mzTabCelltype = this.extractEBIParam("celltype", properties);
                List<Parameter> speciesDiseases = this.extractParameterList("species_disease_", properties);
                if (mzTabSpecies != null || mzTabTissue != null || mzTabCelltype != null) {
                    this.mzTabSample_ = new Sample().id(1);
                    if (mzTabSpecies != null) {
                        this.mzTabSample_.setSpecies(new Vector<Parameter>());
                        this.mzTabSample_.getSpecies().add(mzTabSpecies);
                    }
                    if (mzTabTissue != null) {
                        this.mzTabSample_.setTissue(new Vector<Parameter>());
                        this.mzTabSample_.getTissue().add(mzTabTissue);
                    }
                    if (mzTabCelltype != null) {
                        this.mzTabSample_.setCellType(new Vector<Parameter>());
                        this.mzTabSample_.getCellType().add(mzTabCelltype);
                    }
                    if (speciesDiseases.size() > 0) {
                        this.mzTabSample_.setDisease(speciesDiseases);
                    }
                }
                this.fragmethods_ = this.extractParameterList("fragmentationmethod_", properties);
                for (Object keyObject : properties.keySet()) {
                    String key;
                    if (!(keyObject instanceof String) || !(key = (String)keyObject).startsWith(MZTAB_ADDUCT_PREFIX)) continue;
                    String adductKey = key.substring(MZTAB_ADDUCT_PREFIX.length());
                    String value = properties.getProperty(key);
                    this.mzTabAdductLookup_.put(adductKey, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Parameter> extractParameterList(String propBase, Properties properties) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        int count = 1;
        String value = MACHINE_NAME_DEFAULT;
        while ((value = properties.getProperty(propBase + String.valueOf(count), MACHINE_NAME_DEFAULT)) != null && value.length() > 0) {
            int commas = LipidomicsConstants.countComma(value);
            if (LipidomicsConstants.countComma(value) < 1) continue;
            Parameter param = null;
            param = commas == 1 ? new Parameter().name(value.substring(0, value.indexOf(","))).value(value.substring(value.indexOf(",") + 1)) : this.extractEBIParam(propBase + String.valueOf(count), properties);
            parameters.add(param);
            ++count;
        }
        return parameters;
    }

    public List<Pair<String, String>> getPropertyRowList(HydroxyEncoding faHydroxyEncoding, HydroxyEncoding lcbHydroxyEncoding) {
        String value;
        String key;
        ArrayList<Pair<String, String>> propertyRows = new ArrayList<Pair<String, String>>();
        propertyRows.add(new Pair<String, String>(EXCEL_KEY, EXCEL_VALUE));
        propertyRows.add(new Pair<String, String>(LDA_VERSION, this.ldaVersion_));
        if (this.rawFileName_ != null) {
            propertyRows.add(new Pair<String, String>(RAW_FILE, this.rawFileName_));
        }
        propertyRows.add(new Pair<String, String>(MACHINE_NAME, this.currentMSMachine_));
        propertyRows.add(new Pair<String, String>(NEUTRON_MASS, String.valueOf(this.neutronMass_)));
        propertyRows.add(new Pair<String, String>(COARSE_CHROM_MZ_TOL, String.valueOf(this.coarseChromMzTolerance_)));
        propertyRows.add(new Pair<String, String>(MS2, String.valueOf(this.ms2_)));
        if (this.relativeMS1BasePeakCutoff_ != null) {
            propertyRows.add(new Pair<String, String>(BASE_PEAK_CUTOFF, String.valueOf(this.relativeMS1BasePeakCutoff_)));
        }
        propertyRows.add(new Pair<String, String>(MASS_SHIFT, String.valueOf(this.massShift_)));
        propertyRows.add(new Pair<String, String>(VIEWER_TIME_RESOLUTION, String.valueOf(this.threeDViewerDefaultTimeResolution_)));
        propertyRows.add(new Pair<String, String>(VIEWER_MZ_RESOLUTION, String.valueOf(this.threeDViewerDefaultMZResolution_)));
        propertyRows.add(new Pair<String, String>(MS2_PRECURSOR_TOL, String.valueOf(this.ms2PrecursorTolerance_)));
        String ms2PrecursorToleranceString = MZUNIT_DA;
        if (this.ms2PrecursorToleranceUnit_ == 1) {
            ms2PrecursorToleranceString = MZUNIT_PPM;
        }
        propertyRows.add(new Pair<String, String>(MS2_PRECURSOR_TOL_UNIT, String.valueOf(ms2PrecursorToleranceString)));
        propertyRows.add(new Pair<String, String>(MS2_MZ_TOL, String.valueOf(this.ms2MzTolerance_)));
        String ms2MzToleranceString = MZUNIT_DA;
        if (this.ms2MzToleranceUnit_ == 1) {
            ms2MzToleranceString = MZUNIT_PPM;
        }
        propertyRows.add(new Pair<String, String>(MS2_MZ_TOL_UNIT, String.valueOf(ms2MzToleranceString)));
        propertyRows.add(new Pair<String, String>(MS2_MIN_NOISE_REMOVAL, String.valueOf(this.ms2MinIntsForNoiseRemoval_)));
        propertyRows.add(new Pair<String, String>(MS2_ISOBAR_RATIO, String.valueOf(this.ms2IsobarSCExclusionRatio_)));
        propertyRows.add(new Pair<String, String>(MS2_ISOBAR_FAR_RATIO, String.valueOf(this.ms2IsobarSCFarExclusionRatio_)));
        propertyRows.add(new Pair<String, String>(MS2_ISOBAR_FAR_RT, String.valueOf(this.ms2IsobaricOtherRtDifference_)));
        propertyRows.add(new Pair<String, String>(CHAIN_CUTOFF, String.valueOf(this.chainCutoffValue_)));
        propertyRows.add(new Pair<String, String>(MS2_CHROM_MULT_FOR_INT, String.valueOf(this.ms2ChromMultiplicationFactorForInt_)));
        propertyRows.add(new Pair<String, String>(MS2_VIEWER_TIME_RESOLUTION, this.threeDViewerMs2DefaultTimeResolution_));
        propertyRows.add(new Pair<String, String>(MS2_VIEWER_MZ_RESOLUTION, this.threeDViewerMs2DefaultMZResolution_));
        propertyRows.add(new Pair<String, String>(MAX_CHROM_AT_ONCE_MB, String.valueOf(this.maxFileSizeForChromTranslationAtOnceInMB_)));
        propertyRows.add(new Pair<String, String>(CHROM_MULT_FOR_INT, String.valueOf(this.chromMultiplicationFactorForInt_)));
        propertyRows.add(new Pair<String, String>(CHROM_RESOLUTION_LOWEST, String.valueOf(this.chromLowestResolution_)));
        if (this.shotgun_ > 0) {
            propertyRows.add(new Pair<String, String>(SHOTGUN, String.valueOf(this.shotgun_)));
            propertyRows.add(new Pair<String, String>(MZUNIT, this.mzUnit_));
        }
        if (this.shotgun_ == 1) {
            String shotgunProcessingString = null;
            switch (this.shotgunProcessing_) {
                case 0: {
                    shotgunProcessingString = SHOTGUN_PROCESSING_MEAN;
                    break;
                }
                case 1: {
                    shotgunProcessingString = SHOTGUN_PROCESSING_MEDIAN;
                    break;
                }
                case 2: {
                    shotgunProcessingString = SHOTGUN_PROCESSING_SUM;
                }
            }
            propertyRows.add(new Pair<String, String>(SHOTGUN_PROCESSING, shotgunProcessingString));
            String shotgunZeroHandlingString = "false";
            if (this.shotgunRelIntCutoff_ > 0.0f) {
                shotgunZeroHandlingString = String.valueOf(this.shotgunRelIntCutoff_);
            } else if (this.shotgunRelIntCutoff_ == 0.0f) {
                shotgunZeroHandlingString = "true";
            }
            propertyRows.add(new Pair<String, String>(SHOTGUN_ZERO_HANDLING, shotgunZeroHandlingString));
        } else {
            propertyRows.add(new Pair<String, String>(CHROM_SMOOTH_RANGE, String.valueOf(this.chromSmoothRange_)));
            propertyRows.add(new Pair<String, String>(CHROM_SMOOTH_REPEATS, String.valueOf(this.chromSmoothRepeats_)));
        }
        if (this.shotgun_ == 0) {
            propertyRows.add(new Pair<String, String>(USE_3D, String.valueOf(this.use3D_)));
            propertyRows.add(new Pair<String, String>(ISOTOPE_CORRECTION, String.valueOf(this.isotopeCorrection_)));
            propertyRows.add(new Pair<String, String>(REMOVE_FROM_OTHER_ISOTOPE, String.valueOf(this.removeFromOtherIsotopes_)));
            propertyRows.add(new Pair<String, String>(RESPECT_ISO_DISTRI, String.valueOf(this.respectIsotopicDistribution_)));
            propertyRows.add(new Pair<String, String>(CHECK_CHAIN_LABEL_COMBINATION, String.valueOf(this.checkChainLabelCombination_)));
            propertyRows.add(new Pair<String, String>(NOISE_CUTOFF, String.valueOf(this.useNoiseCutoff_)));
            propertyRows.add(new Pair<String, String>(NOISE_DEVIATION, String.valueOf(this.noiseCutoffDeviationValue_)));
            if (this.minimumRelativeIntensity_ != null) {
                propertyRows.add(new Pair<String, String>(NOISE_MIN_INTENSITY, this.minimumRelativeIntensity_.toString()));
            }
            propertyRows.add(new Pair<String, String>(SCAN_STEP, String.valueOf(this.scanStep_)));
            propertyRows.add(new Pair<String, String>(PROFILE_MZ_RANGE, String.valueOf(this.profileMzRange_ * 2.0f)));
            propertyRows.add(new Pair<String, String>(PROFILE_TIME_TOL, String.valueOf(this.profileTimeTolerance_)));
            propertyRows.add(new Pair<String, String>(PROFILE_INT_THRESHOLD, String.valueOf(this.profileIntThreshold_)));
            propertyRows.add(new Pair<String, String>(PROFILE_BROADER_TIME_TOL, String.valueOf(this.broaderProfileTimeTolerance_)));
            propertyRows.add(new Pair<String, String>(PROFILE_SMOOTH_RANGE, String.valueOf(this.profileSmoothRange_)));
            propertyRows.add(new Pair<String, String>(PROFILE_SMOOTH_REPEATS, String.valueOf(this.profileSmoothRepeats_)));
            propertyRows.add(new Pair<String, String>(PROFILE_MEAN_SMOOTH_REPEATS, String.valueOf(this.profileMeanSmoothRepeats_)));
            propertyRows.add(new Pair<String, String>(PROFILE_MZ_MIN_RANGE, String.valueOf(this.profileMzMinRange_)));
            propertyRows.add(new Pair<String, String>(PROFILE_STEEPNESS_CHANGE_1, String.valueOf(this.profileSteepnessChange1_)));
            propertyRows.add(new Pair<String, String>(PROFILE_STEEPNESS_CHANGE_2, String.valueOf(this.profileSteepnessChange2_)));
            propertyRows.add(new Pair<String, String>(PROFILE_INT_CUTOFF_1, String.valueOf(this.profileIntensityCutoff1_)));
            propertyRows.add(new Pair<String, String>(PROFILE_INT_CUTOFF_2, String.valueOf(this.profileIntensityCutoff2_)));
            propertyRows.add(new Pair<String, String>(PROFILE_GENERAL_INT_CUTOFF, String.valueOf(this.profileGeneralIntCutoff_)));
            propertyRows.add(new Pair<String, String>(PROFILE_PEAK_ACCEPTANCE_RANGE, String.valueOf(this.profilePeakAcceptanceRange_)));
            propertyRows.add(new Pair<String, String>(PROFILE_SMOOTHING_CORRECTION, String.valueOf(this.profileSmoothingCorrection_)));
            propertyRows.add(new Pair<String, String>(PROFILE_MZ_MAX_RANGE, String.valueOf(this.profileMaxRange_)));
            propertyRows.add(new Pair<String, String>(SMALL_CHROM_MZ_RANGE, String.valueOf(this.smallChromMzRange_)));
            propertyRows.add(new Pair<String, String>(SMALL_CHROM_SMOOTH_REPEATS, String.valueOf(this.smallChromSmoothRepeats_)));
            propertyRows.add(new Pair<String, String>(SMALL_CHROM_MEAN_SMOOTH_REPEATS, String.valueOf(this.smallChromMeanSmoothRepeats_)));
            propertyRows.add(new Pair<String, String>(SMALL_CHROM_SMOOTH_RANGE, String.valueOf(this.smallChromSmoothRange_)));
            propertyRows.add(new Pair<String, String>(SMALL_CHROM_INT_CUTOFF, String.valueOf(this.smallChromIntensityCutoff_)));
            propertyRows.add(new Pair<String, String>(BROAD_CHROM_SMOOTH_REPEATS, String.valueOf(this.broadChromSmoothRepeats_)));
            propertyRows.add(new Pair<String, String>(BROAD_CHROM_MEAN_SMOOTH_REPEATS, String.valueOf(this.broadChromMeanSmoothRepeats_)));
            propertyRows.add(new Pair<String, String>(BROAD_CHROM_SMOOTH_RANGE, String.valueOf(this.broadChromSmoothRange_)));
            propertyRows.add(new Pair<String, String>(BROAD_CHROM_INT_CUTOFF, String.valueOf(this.broadChromIntensityCutoff_)));
            propertyRows.add(new Pair<String, String>(BROAD_CHROM_STEEPNESS_CHANGE_NO_SMALL, String.valueOf(this.broadChromSteepnessChangeNoSmall_)));
            propertyRows.add(new Pair<String, String>(FINAL_PROBE_TIME_COMP_TOL, String.valueOf(this.finalProbeTimeCompTolerance_)));
            propertyRows.add(new Pair<String, String>(FINAL_PROBE_MZ_COMP_TOL, String.valueOf(this.finalProbeMzCompTolerance_)));
            propertyRows.add(new Pair<String, String>(OVERLAP_DIST_DEV_FACTOR, String.valueOf(this.overlapDistanceDeviationFactor_)));
            propertyRows.add(new Pair<String, String>(OVERLAP_INT_THRESHOLD, String.valueOf(this.overlapPossibleIntensityThreshold_)));
            propertyRows.add(new Pair<String, String>(OVERLAP_INT_SURE_THRESHOLD, String.valueOf(this.overlapSureIntensityThreshold_)));
            propertyRows.add(new Pair<String, String>(OVERLAP_PEAK_DIST_DIVISOR, String.valueOf(this.overlapPeakDistanceDivisor_)));
            propertyRows.add(new Pair<String, String>(OVERLAP_FULL_DIST_DIVISOR, String.valueOf(this.overlapFullDistanceDivisor_)));
        }
        if (this.shotgun_ != 1) {
            propertyRows.add(new Pair<String, String>(PEAK_DISCARD_AREA_FACTOR, String.valueOf(this.peakDiscardingAreaFactor_)));
        }
        if (this.shotgun_ == 0) {
            propertyRows.add(new Pair<String, String>(ISO_IN_BETWEEN_TIME, String.valueOf(this.isotopeInBetweenTime_)));
            propertyRows.add(new Pair<String, String>(ISO_IN_BETWEEN_AREA_FACTOR, String.valueOf(this.isoInBetweenAreaFactor_)));
            propertyRows.add(new Pair<String, String>(ISO_NEAR_NORMAL_PROBE_TIME, String.valueOf(this.isoNearNormalProbeTime_)));
        }
        if (this.shotgun_ != 1) {
            propertyRows.add(new Pair<String, String>(RELATIVE_AREA_CUTOFF, String.valueOf(this.relativeAreaCutoff_)));
            propertyRows.add(new Pair<String, String>(RELATIVE_AREA_FAR_CUTOFF, String.valueOf(this.relativeFarAreaCutoff_)));
            propertyRows.add(new Pair<String, String>(RELATIVE_AREA_FAR_TIME_SPACE, String.valueOf(this.relativeFarAreaTimeSpace_)));
        }
        if (this.shotgun_ == 0) {
            propertyRows.add(new Pair<String, String>(RELATIVE_ISO_INBETWEEN_CUTOFF, String.valueOf(this.relativeIsoInBetweenCutoff_)));
            propertyRows.add(new Pair<String, String>(ISO_IN_BETWEEN_TIME_MAX, String.valueOf(this.isoInBetweenMaxTimeDistance_)));
            propertyRows.add(new Pair<String, String>(PEAK_CLOSE_TIME_TOL, String.valueOf(this.closePeakTimeTolerance_)));
            propertyRows.add(new Pair<String, String>(TWIN_INBETWEEN_CUTOFF, String.valueOf(this.twinInBetweenCutoff_)));
            propertyRows.add(new Pair<String, String>(UNION_INBETWEEN_CUTOFF, String.valueOf(this.unionInBetweenCutoff_)));
            propertyRows.add(new Pair<String, String>(SPARSE_DATA, String.valueOf(this.sparseData_)));
        }
        if (this.mzTabInstrumentName_ != null) {
            propertyRows.add(new Pair<String, String>(MZTAB_INSTRUMENT, this.getStringFromMzTabParameter(this.mzTabInstrumentName_)));
        }
        if (this.mzTabInstrumentSource_ != null) {
            propertyRows.add(new Pair<String, String>(MZTAB_IONSOURCE, this.getStringFromMzTabParameter(this.mzTabInstrumentSource_)));
        }
        if (this.mzTabInstrumentAnalyzer_ != null) {
            propertyRows.add(new Pair<String, String>(MZTAB_MSANALYZER, this.getStringFromMzTabParameter(this.mzTabInstrumentAnalyzer_)));
        }
        if (this.mzTabInstrumentDetector_ != null) {
            propertyRows.add(new Pair<String, String>(MZTAB_DETECTOR, this.getStringFromMzTabParameter(this.mzTabInstrumentDetector_)));
        }
        if (this.alexTargetlist_) {
            propertyRows.add(new Pair<String, String>(ALEX_TARGETLIST, String.valueOf(this.alexTargetlist_)));
        }
        if (this.useMsconvertForWaters_) {
            propertyRows.add(new Pair<String, String>(USE_MSCONVERT_FOR_WATERS, String.valueOf(this.useMsconvertForWaters_)));
        }
        if (faHydroxyEncoding != null) {
            for (Short oh : faHydroxyEncoding.getHydroxyNumbersInAscendingOrder()) {
                try {
                    key = EXCEL_HYDROXY_FA_PREFIX + String.valueOf(oh);
                    value = faHydroxyEncoding.getEncodedPrefix(oh);
                    propertyRows.add(new Pair<String, String>(key, value));
                }
                catch (HydroxylationEncodingException hydroxylationEncodingException) {}
            }
        }
        if (lcbHydroxyEncoding != null) {
            for (Short oh : lcbHydroxyEncoding.getHydroxyNumbersInAscendingOrder()) {
                try {
                    key = EXCEL_HYDROXY_LCB_PREFIX + String.valueOf(oh);
                    value = lcbHydroxyEncoding.getEncodedPrefix(oh);
                    propertyRows.add(new Pair<String, String>(key, value));
                }
                catch (HydroxylationEncodingException hydroxylationEncodingException) {}
            }
        }
        return propertyRows;
    }

    @Deprecated
    public static Object[] readSettingsFromExcelApachePOI(Sheet sheet) throws SettingsException {
        Properties properties = new Properties();
        int keyColumn = -1;
        int valueColumn = -1;
        Hashtable<String, Short> faOhEncondings = new Hashtable<String, Short>();
        Hashtable<String, Short> lcbOhEncondings = new Hashtable<String, Short>();
        for (int rowCount = 0; rowCount != sheet.getLastRowNum() + 1; ++rowCount) {
            Hashtable<Integer, Object> entries = ExcelUtils.getEntriesOfOneRow(sheet.getRow(rowCount), true);
            if (keyColumn > -1 && valueColumn > -1) {
                if (!entries.containsKey(keyColumn) || !entries.containsKey(valueColumn) || !(entries.get(keyColumn) instanceof String)) continue;
                String key = (String)entries.get(keyColumn);
                String value = MACHINE_NAME_DEFAULT;
                value = entries.get(valueColumn) instanceof String ? (String)entries.get(valueColumn) : String.valueOf((Double)entries.get(valueColumn));
                if (key.startsWith(EXCEL_HYDROXY_FA_PREFIX) || key.startsWith(EXCEL_HYDROXY_LCB_PREFIX)) {
                    String ohNumberString = null;
                    if (key.startsWith(EXCEL_HYDROXY_FA_PREFIX)) {
                        ohNumberString = key.substring(EXCEL_HYDROXY_FA_PREFIX.length());
                    } else if (key.startsWith(EXCEL_HYDROXY_LCB_PREFIX)) {
                        ohNumberString = key.substring(EXCEL_HYDROXY_LCB_PREFIX.length());
                    }
                    Short ohNumber = Short.parseShort(ohNumberString);
                    if (key.startsWith(EXCEL_HYDROXY_FA_PREFIX)) {
                        faOhEncondings.put(value, ohNumber);
                        continue;
                    }
                    if (!key.startsWith(EXCEL_HYDROXY_LCB_PREFIX)) continue;
                    lcbOhEncondings.put(value, ohNumber);
                    continue;
                }
                properties.put(key, value);
                continue;
            }
            for (Integer columnId : entries.keySet()) {
                if (entries.get(columnId) == null || !(entries.get(columnId) instanceof String) || ((String)entries.get(columnId)).length() == 0) continue;
                String entry = (String)entries.get(columnId);
                if (entry.equalsIgnoreCase(EXCEL_KEY)) {
                    keyColumn = columnId;
                }
                if (!entry.equalsIgnoreCase(EXCEL_VALUE)) continue;
                valueColumn = columnId;
            }
        }
        LipidomicsConstants consts = new LipidomicsConstants(false);
        consts.ldaVersion_ = properties.getProperty(LDA_VERSION, "2.10.0_1");
        String rawFile = null;
        if (properties.containsKey(RAW_FILE)) {
            rawFile = properties.getProperty(RAW_FILE);
        }
        consts.rawFileName_ = rawFile;
        String usedCutoff = null;
        if (properties.containsKey(BASE_PEAK_CUTOFF)) {
            usedCutoff = properties.getProperty(BASE_PEAK_CUTOFF);
        }
        if (usedCutoff != null) {
            try {
                Double.parseDouble(usedCutoff);
                consts.relativeMS1BasePeakCutoff_ = usedCutoff;
            }
            catch (NumberFormatException columnId) {
                // empty catch block
            }
        }
        if (properties.containsKey(MASS_SHIFT)) {
            properties.put(MASS_SHIFT, String.valueOf(Double.parseDouble(properties.getProperty(MASS_SHIFT)) * 1000.0));
        }
        consts.setVariables(properties);
        Object[] returnValues = new Object[]{consts, new HydroxyEncoding(faOhEncondings), new HydroxyEncoding(lcbOhEncondings)};
        return returnValues;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LipidomicsConstants other = (LipidomicsConstants)obj;
        return Objects.equals(this.alexTargetlistUsed_, other.alexTargetlistUsed_) && this.alexTargetlist_ == other.alexTargetlist_ && Objects.equals(this.basePeakDefaultCutoff_, other.basePeakDefaultCutoff_) && Float.floatToIntBits(this.broadChromIntensityCutoffNoSmall_) == Float.floatToIntBits(other.broadChromIntensityCutoffNoSmall_) && Float.floatToIntBits(this.broadChromIntensityCutoff_) == Float.floatToIntBits(other.broadChromIntensityCutoff_) && this.broadChromMeanSmoothRepeats_ == other.broadChromMeanSmoothRepeats_ && this.broadChromSmoothRange_ == other.broadChromSmoothRange_ && this.broadChromSmoothRepeats_ == other.broadChromSmoothRepeats_ && Float.floatToIntBits(this.broadChromSteepnessChangeNoSmall_) == Float.floatToIntBits(other.broadChromSteepnessChangeNoSmall_) && Float.floatToIntBits(this.broaderProfileTimeTolerance_) == Float.floatToIntBits(other.broaderProfileTimeTolerance_) && Double.doubleToLongBits(this.chainCutoffValue_) == Double.doubleToLongBits(other.chainCutoffValue_) && this.checkChainLabelCombination_ == other.checkChainLabelCombination_ && this.chromExportShowLegend_ == other.chromExportShowLegend_ && this.chromLowestResolution_ == other.chromLowestResolution_ && this.chromMultiplicationFactorForInt_ == other.chromMultiplicationFactorForInt_ && Float.floatToIntBits(this.chromSmoothRange_) == Float.floatToIntBits(other.chromSmoothRange_) && this.chromSmoothRepeats_ == other.chromSmoothRepeats_ && this.closePeakTimeTolerance_ == other.closePeakTimeTolerance_ && Float.floatToIntBits(this.coarseChromMzTolerance_) == Float.floatToIntBits(other.coarseChromMzTolerance_) && Objects.equals(this.currentMSMachine_, other.currentMSMachine_) && this.cvBtoRequired_ == other.cvBtoRequired_ && this.cvChmoRequired_ == other.cvChmoRequired_ && this.cvClRequired_ == other.cvClRequired_ && this.cvDoidRequired_ == other.cvDoidRequired_ && this.cvNcbiTaxonRequired_ == other.cvNcbiTaxonRequired_ && this.cvSepRequired_ == other.cvSepRequired_ && Float.floatToIntBits(this.finalProbeMzCompTolerance_) == Float.floatToIntBits(other.finalProbeMzCompTolerance_) && Float.floatToIntBits(this.finalProbeTimeCompTolerance_) == Float.floatToIntBits(other.finalProbeTimeCompTolerance_) && Objects.equals(this.intermediateFileFormat_, other.intermediateFileFormat_) && Float.floatToIntBits(this.isoInBetweenAreaFactor_) == Float.floatToIntBits(other.isoInBetweenAreaFactor_) && this.isoInBetweenMaxTimeDistance_ == other.isoInBetweenMaxTimeDistance_ && this.isoNearNormalProbeTime_ == other.isoNearNormalProbeTime_ && this.isotopeCorrection_ == other.isotopeCorrection_ && this.isotopeInBetweenTime_ == other.isotopeInBetweenTime_ && Objects.equals(this.ldaVersion_, other.ldaVersion_) && Double.doubleToLongBits(this.massShift_) == Double.doubleToLongBits(other.massShift_) && this.maxFileSizeForChromTranslationAtOnceInMB_ == other.maxFileSizeForChromTranslationAtOnceInMB_ && Objects.equals(this.minimumRelativeIntensity_, other.minimumRelativeIntensity_) && this.minimumThresholdForHighConfidenceRTMatch_ == other.minimumThresholdForHighConfidenceRTMatch_ && this.ms2ChromMultiplicationFactorForInt_ == other.ms2ChromMultiplicationFactorForInt_ && Float.floatToIntBits(this.ms2IsobarSCExclusionRatio_) == Float.floatToIntBits(other.ms2IsobarSCExclusionRatio_) && Float.floatToIntBits(this.ms2IsobarSCFarExclusionRatio_) == Float.floatToIntBits(other.ms2IsobarSCFarExclusionRatio_) && Float.floatToIntBits(this.ms2IsobaricOtherRtDifference_) == Float.floatToIntBits(other.ms2IsobaricOtherRtDifference_) && this.ms2MinIntsForNoiseRemoval_ == other.ms2MinIntsForNoiseRemoval_ && Float.floatToIntBits(this.ms2MzTolerance_) == Float.floatToIntBits(other.ms2MzTolerance_) && Float.floatToIntBits(this.ms2PrecursorTolerance_) == Float.floatToIntBits(other.ms2PrecursorTolerance_) && this.ms2MzToleranceUnit_ == other.ms2MzToleranceUnit_ && this.ms2PrecursorToleranceUnit_ == other.ms2PrecursorToleranceUnit_ && this.ms2_ == other.ms2_ && Objects.equals(this.mzTabInstrumentAnalyzer_, other.mzTabInstrumentAnalyzer_) && Objects.equals(this.mzTabInstrumentDetector_, other.mzTabInstrumentDetector_) && Objects.equals(this.mzTabInstrumentName_, other.mzTabInstrumentName_) && Objects.equals(this.mzTabInstrumentSource_, other.mzTabInstrumentSource_) && Objects.equals(this.mzTabSample_, other.mzTabSample_) && Objects.equals(this.mzUnit_, other.mzUnit_) && Float.floatToIntBits(this.neutronMass_) == Float.floatToIntBits(other.neutronMass_) && Float.floatToIntBits(this.noiseCutoffDeviationValue_) == Float.floatToIntBits(other.noiseCutoffDeviationValue_) && Float.floatToIntBits(this.overlapDistanceDeviationFactor_) == Float.floatToIntBits(other.overlapDistanceDeviationFactor_) && Float.floatToIntBits(this.overlapFullDistanceDivisor_) == Float.floatToIntBits(other.overlapFullDistanceDivisor_) && Float.floatToIntBits(this.overlapPeakDistanceDivisor_) == Float.floatToIntBits(other.overlapPeakDistanceDivisor_) && Float.floatToIntBits(this.overlapPossibleIntensityThreshold_) == Float.floatToIntBits(other.overlapPossibleIntensityThreshold_) && Float.floatToIntBits(this.overlapSureIntensityThreshold_) == Float.floatToIntBits(other.overlapSureIntensityThreshold_) && this.peakDiscardingAreaFactor_ == other.peakDiscardingAreaFactor_ && Float.floatToIntBits(this.profileGeneralIntCutoff_) == Float.floatToIntBits(other.profileGeneralIntCutoff_) && Float.floatToIntBits(this.profileIntThreshold_) == Float.floatToIntBits(other.profileIntThreshold_) && Float.floatToIntBits(this.profileIntensityCutoff1_) == Float.floatToIntBits(other.profileIntensityCutoff1_) && Float.floatToIntBits(this.profileIntensityCutoff2_) == Float.floatToIntBits(other.profileIntensityCutoff2_) && Float.floatToIntBits(this.profileMaxRange_) == Float.floatToIntBits(other.profileMaxRange_) && this.profileMeanSmoothRepeats_ == other.profileMeanSmoothRepeats_ && Float.floatToIntBits(this.profileMzMinRange_) == Float.floatToIntBits(other.profileMzMinRange_) && Float.floatToIntBits(this.profileMzRange_) == Float.floatToIntBits(other.profileMzRange_) && Float.floatToIntBits(this.profilePeakAcceptanceRange_) == Float.floatToIntBits(other.profilePeakAcceptanceRange_) && Float.floatToIntBits(this.profileSmoothRange_) == Float.floatToIntBits(other.profileSmoothRange_) && this.profileSmoothRepeats_ == other.profileSmoothRepeats_ && Float.floatToIntBits(this.profileSmoothingCorrection_) == Float.floatToIntBits(other.profileSmoothingCorrection_) && Float.floatToIntBits(this.profileSteepnessChange1_) == Float.floatToIntBits(other.profileSteepnessChange1_) && Float.floatToIntBits(this.profileSteepnessChange2_) == Float.floatToIntBits(other.profileSteepnessChange2_) && Float.floatToIntBits(this.profileTimeTolerance_) == Float.floatToIntBits(other.profileTimeTolerance_) && Objects.equals(this.rawFileName_, other.rawFileName_) && Float.floatToIntBits(this.relativeAreaCutoff_) == Float.floatToIntBits(other.relativeAreaCutoff_) && Float.floatToIntBits(this.relativeFarAreaCutoff_) == Float.floatToIntBits(other.relativeFarAreaCutoff_) && this.relativeFarAreaTimeSpace_ == other.relativeFarAreaTimeSpace_ && Float.floatToIntBits(this.relativeIsoInBetweenCutoff_) == Float.floatToIntBits(other.relativeIsoInBetweenCutoff_) && Objects.equals(this.relativeMS1BasePeakCutoff_, other.relativeMS1BasePeakCutoff_) && this.removeFromOtherIsotopes_ == other.removeFromOtherIsotopes_ && this.respectIsotopicDistribution_ == other.respectIsotopicDistribution_ && this.scanStep_ == other.scanStep_ && this.shotgunIntensityRemoval_ == other.shotgunIntensityRemoval_ && this.shotgunProcessing_ == other.shotgunProcessing_ && Float.floatToIntBits(this.shotgunRelIntCutoff_) == Float.floatToIntBits(other.shotgunRelIntCutoff_) && this.shotgun_ == other.shotgun_ && Float.floatToIntBits(this.smallChromIntensityCutoff_) == Float.floatToIntBits(other.smallChromIntensityCutoff_) && this.smallChromMeanSmoothRepeats_ == other.smallChromMeanSmoothRepeats_ && Float.floatToIntBits(this.smallChromMzRange_) == Float.floatToIntBits(other.smallChromMzRange_) && Float.floatToIntBits(this.smallChromSmoothRange_) == Float.floatToIntBits(other.smallChromSmoothRange_) && this.smallChromSmoothRepeats_ == other.smallChromSmoothRepeats_ && this.sparseData_ == other.sparseData_ && Objects.equals(this.threeDViewerDefaultMZResolution_, other.threeDViewerDefaultMZResolution_) && Objects.equals(this.threeDViewerDefaultTimeResolution_, other.threeDViewerDefaultTimeResolution_) && Objects.equals(this.threeDViewerMs2DefaultMZResolution_, other.threeDViewerMs2DefaultMZResolution_) && Objects.equals(this.threeDViewerMs2DefaultTimeResolution_, other.threeDViewerMs2DefaultTimeResolution_) && Float.floatToIntBits(this.twinInBetweenCutoff_) == Float.floatToIntBits(other.twinInBetweenCutoff_) && Float.floatToIntBits(this.unionInBetweenCutoff_) == Float.floatToIntBits(other.unionInBetweenCutoff_) && this.use3D_ == other.use3D_ && this.useMostOverlappingIsotopeOnly_ == other.useMostOverlappingIsotopeOnly_ && this.useMsconvertForWaters_ == other.useMsconvertForWaters_ && this.useNoiseCutoff_ == other.useNoiseCutoff_;
    }

    private String getStringFromMzTabParameter(Parameter param) {
        String returnString = param.getCvLabel() + ",";
        if (param.getCvAccession() != null && param.getCvAccession().length() > 0) {
            returnString = returnString + param.getCvAccession() + ",";
        }
        if (param.getName() != null && param.getName().length() > 0) {
            returnString = returnString + param.getName() + ",";
        }
        if (param.getValue() != null && param.getValue().length() > 0) {
            returnString = returnString + param.getValue() + ",";
        }
        return returnString;
    }

    public String getRelativeMS1BasePeakCutoff() {
        return this.relativeMS1BasePeakCutoff_;
    }

    public void setRelativeMS1BasePeakCutoff(String relativeMS1BasePeakCutoff) {
        this.relativeMS1BasePeakCutoff_ = relativeMS1BasePeakCutoff;
    }

    public void setLDAVersion(String ldaVersion) {
        this.ldaVersion_ = ldaVersion;
    }

    public String getLDAVersion() {
        return this.ldaVersion_;
    }

    public String getRawFileName() {
        return this.rawFileName_;
    }

    public void setRawFileName(String rawFileName) {
        this.rawFileName_ = rawFileName;
    }

    public String getMSMachine() {
        return this.currentMSMachine_;
    }

    public double getShift() {
        return this.massShift_;
    }

    public boolean isAlexTargetlist() {
        return this.alexTargetlist_;
    }

    public void setAlexTargetlist(boolean alexTargetlist) {
        this.alexTargetlist_ = alexTargetlist;
    }

    public static boolean useMsconvertForWaters() {
        LipidomicsConstants.getInstance();
        return LipidomicsConstants.instance_.useMsconvertForWaters_;
    }

    public Hashtable<String, Boolean> getAlexTargetlistUsed() {
        return this.alexTargetlistUsed_;
    }

    public void setAlexTargetlistUsed(Hashtable<String, Boolean> alexTargetlistUsed) {
        this.alexTargetlistUsed_ = alexTargetlistUsed;
    }

    public boolean getRespectIsotopicDistribution() {
        return this.respectIsotopicDistribution_;
    }

    public String getChainCombiSeparatorAmbigPosDependingOnVersion() {
        if (this.shouldOldEncodingBeUsed()) {
            return ";";
        }
        return null;
    }

    public String getModSeparatorDependingOnVersion() {
        if (!this.shouldOldEncodingBeUsed()) {
            return ";";
        }
        return "[";
    }

    public boolean shouldOldEncodingBeUsed() {
        String[] version = this.ldaVersion_.split(CHAIN_SEPARATOR_NO_POS)[0].split("\\.");
        if (Integer.parseInt(version[0]) > 2) {
            return false;
        }
        return Integer.parseInt(version[0]) < 2 || Integer.parseInt(version[1]) < 9;
    }

    private static float getCorrectMzTolerance(float tolerance, String mzUnit, float mz) {
        if (mzUnit.equalsIgnoreCase(MZUNIT_DA)) {
            return tolerance;
        }
        if (mzUnit.equalsIgnoreCase(MZUNIT_PPM)) {
            return tolerance * mz / 1000000.0f;
        }
        return tolerance;
    }

    public static float getMs2PrecursorTolerance(float refMz) {
        return StaticUtils.calculatedMzTolValue(refMz, LipidomicsConstants.getMs2PrecursorTolerance(), LipidomicsConstants.getMs2PrecursorToleranceUnit());
    }
}

