/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.xml.RawToChromTranslator;

public class MzxmlToChromThread
extends Thread {
    private String filePath_;
    private boolean finished_ = false;
    private String errorString_;
    private int numberOfThreads_;
    protected boolean polaritySwitched_;

    public MzxmlToChromThread(String filePath, int numberOfThreads) {
        this.filePath_ = filePath;
        this.numberOfThreads_ = numberOfThreads;
    }

    @Override
    public void run() {
        try {
            this.polaritySwitched_ = false;
            this.translateToChrom(this.filePath_, this.numberOfThreads_);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errorString_ = ex.toString();
        }
        this.finished_ = true;
    }

    public boolean finished() {
        return this.finished_;
    }

    public String getErrorString() {
        return this.errorString_;
    }

    protected void translateToChrom(String filePath, int numberOfThreads) throws Exception {
        RawToChromTranslator translator = new RawToChromTranslator(filePath, this.getFileType(filePath), LipidomicsConstants.getmMaxFileSizeForChromTranslationAtOnceInMB(), numberOfThreads, LipidomicsConstants.getChromMultiplicationFactorForInt(), LipidomicsConstants.getChromLowestResolution(), LipidomicsConstants.isMS2());
        translator.translateToChromatograms();
        this.polaritySwitched_ = translator.isPolaritySwitched();
    }

    protected String getFileType(String filePath) {
        return filePath.substring(filePath.lastIndexOf(".") + 1);
    }

    public boolean isPolaritySwitched() {
        return this.polaritySwitched_;
    }
}

