/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.SingleQuantThread;
import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.alex123.RdbOutputWriter;
import at.tugraz.genome.lda.alex123.TargetlistDirParser;
import at.tugraz.genome.lda.alex123.TargetlistParser;
import at.tugraz.genome.lda.alex123.vos.TargetlistEntry;
import at.tugraz.genome.lda.exception.AlexTargetlistParserException;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.ExcelInputFileException;
import at.tugraz.genome.lda.exception.ExportException;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.NoRuleException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.export.QuantificationResultExporter;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.MSnAnalyzer;
import at.tugraz.genome.lda.msn.OtherAdductChecker;
import at.tugraz.genome.lda.msn.PostQuantificationProcessor;
import at.tugraz.genome.lda.msn.RulesContainer;
import at.tugraz.genome.lda.msn.hydroxy.parser.HydroxyEncoding;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.msn.vos.RtPredictVO;
import at.tugraz.genome.lda.parser.ModificationParser;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.LipidomicsAnalyzer;
import at.tugraz.genome.lda.quantification.QuantificationResult;
import at.tugraz.genome.lda.swing.Range;
import at.tugraz.genome.lda.utils.RangeInteger;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.DoubleBondPositionVO;
import at.tugraz.genome.lda.vos.DoubleStringVO;
import at.tugraz.genome.lda.vos.QuantVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.parser.spectrummill.ElementConfigParser;
import at.tugraz.genome.maspectras.quantification.CgException;
import at.tugraz.genome.maspectras.quantification.CgParameterSet;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.maspectras.utils.Calculator;
import at.tugraz.genome.maspectras.utils.StringUtils;
import at.tugraz.genome.voutils.GeneralComparator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JFrame;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class QuantificationThread
extends Thread {
    private String chromFile_;
    private String chromFileName_;
    private String quantFile_;
    private String resultFile_;
    private float minusTime_;
    private float plusTime_;
    private boolean finished_ = false;
    private int amountOfIsotopes_;
    private int isotopesMustMatch_;
    private String errorString_ = null;
    private boolean searchUnknownTime_ = false;
    private float basePeakCutoff_;
    private float rtShift_;
    private int totalAmountOfLipids_;
    private int currentLipidCount_;
    private String currentLipid_;
    private int numberOfProcessors_;
    private boolean ionMode_;
    private boolean msnRoundFinished_;
    private boolean cli_;
    private Hashtable<Integer, Boolean> availableThreads_;
    private Hashtable<Integer, LipidomicsAnalyzer> analyzers_;
    private Hashtable<Integer, SingleQuantThread> threads_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Integer>>> quantStatus_;
    private Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> onlyMS1DataPresent_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> results_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> ms2Removed_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> unsplittedPeaks_;
    private Hashtable<Integer, String> threadToClass_;
    private Hashtable<Integer, String> threadToAnalyte_;
    private Hashtable<Integer, String> threadToMod_;
    private long startCalcTime_;
    private Timer timer_;
    private Hashtable<String, Hashtable<String, RtPredictVO>> latestRtPredictions_;
    private static final int STATUS_WAITING = 0;
    private static final int STATUS_CALCULATING = 1;
    private static final int STATUS_FINISHED = 2;

    public QuantificationThread(String chromFile, String quantFile, String resultFile, float minusTime, float plusTime, int amountOfIsotopes, int isotopesMustMatch, boolean searchUnknownTime, float basePeakCutoff, float rtShift, int numberOfProcessors, boolean ionMode, boolean cli) {
        this.chromFile_ = chromFile;
        this.chromFileName_ = StringUtils.getJustFileName(chromFile);
        this.quantFile_ = quantFile;
        this.resultFile_ = resultFile;
        this.minusTime_ = minusTime;
        this.plusTime_ = plusTime;
        this.amountOfIsotopes_ = amountOfIsotopes;
        this.isotopesMustMatch_ = isotopesMustMatch;
        this.errorString_ = null;
        this.searchUnknownTime_ = searchUnknownTime;
        this.basePeakCutoff_ = basePeakCutoff;
        this.rtShift_ = rtShift;
        this.finished_ = false;
        this.numberOfProcessors_ = numberOfProcessors;
        this.ionMode_ = ionMode;
        this.cli_ = cli;
    }

    @Override
    public void run() {
        try {
            this.startAutomatedLipidomicsQuantification(this.chromFile_, this.quantFile_, this.resultFile_, this.minusTime_, this.plusTime_, this.amountOfIsotopes_, this.isotopesMustMatch_, this.searchUnknownTime_, this.basePeakCutoff_, this.rtShift_, this.numberOfProcessors_, this.ionMode_);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errorString_ = ex.toString();
            this.finished_ = true;
        }
    }

    public String getChromFile() {
        return this.chromFile_;
    }

    public String getResultFile() {
        return this.resultFile_;
    }

    public boolean finished() {
        if (this.finished_ && this.timer_ != null) {
            this.timer_.cancel();
        }
        return this.finished_;
    }

    public String getErrorString() {
        return this.errorString_;
    }

    private void startAutomatedLipidomicsQuantification(String chromFile, String quantFile, String resultFile, float minusTime, float plusTime, int amountOfIsotopes, int isotopesMustMatch, boolean searchUnknownTime, float basePeakCutoff, float rtShift, int numberOfProcessors, boolean ionMode) throws Exception {
        this.startCalcTime_ = System.currentTimeMillis();
        this.totalAmountOfLipids_ = -1;
        this.currentLipidCount_ = -1;
        this.currentLipid_ = "";
        this.msnRoundFinished_ = false;
        this.latestRtPredictions_ = new Hashtable();
        String pureFile = chromFile.substring(0, chromFile.lastIndexOf("."));
        String errorMessage = StaticUtils.existChromNecessaryFiles(pureFile);
        if (errorMessage != null && errorMessage.length() > 0) {
            throw new Exception(errorMessage);
        }
        String[] chromPaths = StringUtils.getChromFilePaths(pureFile + ".chrom");
        float[] maxRetTimes = this.initThreadMonitors(chromPaths, numberOfProcessors, basePeakCutoff);
        float highestRetTime = maxRetTimes[1];
        float lowestRetTime = maxRetTimes[0];
        Vector quantContent = null;
        File quant = new File(quantFile);
        if (quant.isFile() && (quant.getName().endsWith(".xls") || quant.getName().endsWith(".xlsx"))) {
            quantContent = QuantificationThread.parseQuantExcelFile(quantFile, minusTime, plusTime, amountOfIsotopes, isotopesMustMatch, searchUnknownTime, basePeakCutoff, rtShift, lowestRetTime, highestRetTime);
        } else if (quant.isFile() && quant.getName().endsWith(".txt") || quant.isDirectory()) {
            quantContent = QuantificationThread.parseAlex123TargetList(quantFile, minusTime, plusTime, amountOfIsotopes, isotopesMustMatch, searchUnknownTime, basePeakCutoff, rtShift, lowestRetTime, highestRetTime, ionMode);
        }
        if (quantContent != null) {
            LinkedHashMap classSequence = (LinkedHashMap)quantContent.get(0);
            LinkedHashMap analyteSequence = (LinkedHashMap)quantContent.get(1);
            this.totalAmountOfLipids_ = 0;
            for (String className : classSequence.keySet()) {
                this.totalAmountOfLipids_ += ((Vector)analyteSequence.get(className)).size();
            }
            this.timer_ = new Timer();
            this.timer_.schedule((TimerTask)new ThreadSupervisor(quantContent, basePeakCutoff, resultFile), 10L, 100L);
        } else {
            this.errorString_ = "The quantification file/folder does not contain any usable files";
            this.finished_ = true;
        }
    }

    public int getTotalAmountOfLipids() {
        return this.totalAmountOfLipids_;
    }

    public int getCurrentLipidCount() {
        return this.currentLipidCount_;
    }

    public String getCurrentLipid() {
        return this.currentLipid_;
    }

    private static boolean isWithinRemovedBoundaries(CgProbe probe, Vector<CgProbe> removedProbes) {
        boolean isWithinBoundaries = false;
        for (CgProbe removedProbe : removedProbes) {
            if (!(probe.LowerValley > removedProbe.LowerValley - 20.0f && probe.UpperValley < removedProbe.UpperValley + 20.0f) && (!(removedProbe.LowerValley < probe.Peak) || !(removedProbe.LowerValley < removedProbe.UpperValley))) continue;
            isWithinBoundaries = true;
        }
        return isWithinBoundaries;
    }

    public static void setAnalyzerProperties(LipidomicsAnalyzer analyzer) {
        if (LipidomicsConstants.isShotgun() == 1) {
            analyzer.setShotgunParameters(LipidomicsConstants.getShogunProcessing(), LipidomicsConstants.getMs2MzTolerance(), LipidomicsConstants.getMs2MzToleranceUnit());
        } else if (LipidomicsConstants.isShotgun() == 2) {
            analyzer.setPrmParameters(LipidomicsConstants.getChromSmoothRange(), LipidomicsConstants.getChromSmoothRepeats(), LipidomicsConstants.getPeakDiscardingAreaFactor(), LipidomicsConstants.getRelativeAreaCutoff(), LipidomicsConstants.getRelativeFarAreaCutoff(), LipidomicsConstants.getRelativeFarAreaTimeSpace(), LipidomicsConstants.getMs2MzTolerance(), LipidomicsConstants.getMs2MzToleranceUnit());
        } else {
            analyzer.set3DParameters(LipidomicsConstants.getChromSmoothRange(), LipidomicsConstants.getChromSmoothRepeats(), LipidomicsConstants.removeIfOtherIsotopePresent(), LipidomicsConstants.useNoiseCutoff(), LipidomicsConstants.getNoiseCutoffDeviationValue(), LipidomicsConstants.getMinimumRelativeIntensity(), LipidomicsConstants.getScanStep(), LipidomicsConstants.getProfileMzRange(), LipidomicsConstants.getProfileTimeTolerance_(), LipidomicsConstants.getProfileIntThreshold_(), LipidomicsConstants.getBroaderProfileTimeTolerance_(), LipidomicsConstants.getProfileSmoothRange(), LipidomicsConstants.getProfileSmoothRepeats(), LipidomicsConstants.getProfileMeanSmoothRepeats(), LipidomicsConstants.getProfileMzMinRange(), LipidomicsConstants.getProfileSteepnessChange1(), LipidomicsConstants.getProfileSteepnessChange2(), LipidomicsConstants.getProfileIntensityCutoff1(), LipidomicsConstants.getProfileIntensityCutoff2(), LipidomicsConstants.getProfileGeneralIntCutoff(), LipidomicsConstants.getProfilePeakAcceptanceRange(), LipidomicsConstants.getProfileSmoothingCorrection(), LipidomicsConstants.getProfileMaxRange(), LipidomicsConstants.getSmallChromMzRange(), LipidomicsConstants.getSmallChromSmoothRepeats(), LipidomicsConstants.getSmallChromMeanSmoothRepeats(), LipidomicsConstants.getSmallChromSmoothRange(), LipidomicsConstants.getSmallChromIntensityCutoff(), LipidomicsConstants.getBroadChromSmoothRepeats(), LipidomicsConstants.getBroadChromMeanSmoothRepeats(), LipidomicsConstants.getBroadChromSmoothRange(), LipidomicsConstants.getBroadChromIntensityCutoff(), LipidomicsConstants.getBroadChromSteepnessChangeNoSmall(), LipidomicsConstants.getBroadIntensityCutoffNoSmall(), LipidomicsConstants.getFinalProbeTimeCompTolerance(), LipidomicsConstants.getFinalProbeMzCompTolerance(), LipidomicsConstants.getOverlapDistanceDeviationFactor(), LipidomicsConstants.getOverlapPossibleIntensityThreshold(), LipidomicsConstants.getOverlapSureIntensityThreshold(), LipidomicsConstants.getOverlapPeakDistanceDivisor(), LipidomicsConstants.getOverlapFullDistanceDivisor(), LipidomicsConstants.getPeakDiscardingAreaFactor(), LipidomicsConstants.getIsotopeInBetweenTime(), LipidomicsConstants.getIsoInBetweenAreaFactor(), LipidomicsConstants.getIsoInBetweenMaxTimeDistance(), LipidomicsConstants.getIsoNearNormalProbeTime(), LipidomicsConstants.getRelativeAreaCutoff(), LipidomicsConstants.getRelativeFarAreaCutoff(), LipidomicsConstants.getRelativeFarAreaTimeSpace(), LipidomicsConstants.getRelativeIsoInBetweenCutoff(), LipidomicsConstants.getClosePeakTimeTolerance(), LipidomicsConstants.getTwinInBetweenCutoff(), LipidomicsConstants.getUnionInBetweenCutoff(), LipidomicsConstants.getMs2MzTolerance(), LipidomicsConstants.getMs2MzToleranceUnit());
        }
    }

    public static String[] extractFormulaAndAdductName(String contents) throws ExcelInputFileException {
        String[] formulaAndName = new String[4];
        String formula = "";
        String adductName = "";
        String charge = "1";
        String multi = "1";
        String formNameString = contents.substring(contents.indexOf("(") + 1, contents.indexOf(")"));
        if (formNameString.indexOf("form") != -1 && formNameString.indexOf("name") != -1) {
            String nearFormString = formNameString.substring(formNameString.indexOf("form"));
            formula = nearFormString.substring(nearFormString.indexOf("[") + 1, nearFormString.indexOf("]")).trim();
            String nearNameString = formNameString.substring(formNameString.indexOf("name"));
            adductName = nearNameString.substring(nearNameString.indexOf("[") + 1, nearNameString.indexOf("]")).trim();
            if (formNameString.indexOf("charge=") != -1) {
                char[] afterChargeString = formNameString.substring(formNameString.indexOf("charge=") + "charge=".length()).toCharArray();
                try {
                    charge = String.valueOf(QuantificationThread.extractDigitsAfterEqualSign(afterChargeString));
                    if (Integer.parseInt(charge) < 1) {
                        charge = "1";
                        System.out.println("Warning: The charge entry in the column header \"" + contents + "\" is smaller than 1! Setting it to \"1\"");
                    }
                }
                catch (NumberFormatException nfx) {
                    System.out.println("Warning: The charge entry in the column header \"" + contents + "\" is not integer format! Setting it to \"1\"");
                }
            }
            if (formNameString.indexOf("mult=") != -1) {
                char[] afterMultiString = formNameString.substring(formNameString.indexOf("mult=") + "mult=".length()).toCharArray();
                try {
                    multi = String.valueOf(QuantificationThread.extractDigitsAfterEqualSign(afterMultiString));
                    if (Integer.parseInt(charge) < 1) {
                        multi = "1";
                        System.out.println("Warning: The mult entry in the column header \"" + contents + "\" is smaller than 1! Setting it to \"1\"");
                    }
                }
                catch (NumberFormatException nfx) {
                    System.out.println("Warning: The mult entry in the column header \"" + contents + "\" is not integer format! Setting it to \"1\"");
                }
            }
        } else {
            adductName = formNameString;
        }
        formulaAndName[0] = formula;
        formulaAndName[1] = adductName;
        formulaAndName[2] = charge;
        formulaAndName[3] = multi;
        return formulaAndName;
    }

    private static int extractDigitsAfterEqualSign(char[] afterString) {
        String digitsString = "";
        for (int i = 0; i < afterString.length && Character.isDigit(afterString[i]); ++i) {
            digitsString = digitsString + String.valueOf(afterString[i]);
        }
        return Integer.parseInt(digitsString);
    }

    private static Vector parseQuantExcelFile(String quantFile, float minusTime, float plusTime, int amountOfIsotopes, int isotopesMustMatch, boolean searchUnknownTime, float basePeakCutoff, float rtShift, float lowestRetTime, float highestRetTime) throws IOException, SpectrummillParserException, ExcelInputFileException, ChemicalFormulaException, RulesException, HydroxylationEncodingException {
        return QuantificationThread.parseQuantExcelFile(quantFile, minusTime, plusTime, amountOfIsotopes, isotopesMustMatch, searchUnknownTime, basePeakCutoff, rtShift, lowestRetTime, highestRetTime, true);
    }

    public static Vector parseQuantExcelFile(String quantFile, float minusTime, float plusTime, int amountOfIsotopes, int isotopesMustMatch, boolean searchUnknownTime, float basePeakCutoff, float rtShift, float lowestRetTime, float highestRetTime, boolean respectMassShift) throws IOException, SpectrummillParserException, ExcelInputFileException, ChemicalFormulaException, RulesException, HydroxylationEncodingException {
        FileInputStream myxls = new FileInputStream(quantFile);
        Workbook workbook = null;
        if (quantFile.endsWith(".xlsx")) {
            workbook = new XSSFWorkbook(myxls);
        } else if (quantFile.endsWith(".xls")) {
            workbook = new HSSFWorkbook(myxls);
        }
        Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects = new Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>>();
        LinkedHashMap<String, Integer> classSequence = new LinkedHashMap<String, Integer>();
        Hashtable<String, Boolean> adductInsensitiveRtFilter = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> bestMatchBySpectrumCoverage = new Hashtable<String, Boolean>();
        LinkedHashMap<String, Vector<String>> analyteSequence = new LinkedHashMap<String, Vector<String>>();
        boolean excelOK = false;
        ElementConfigParser aaParser = Settings.getElementParser();
        for (int sheetNumber = 0; sheetNumber != workbook.getNumberOfSheets(); ++sheetNumber) {
            Hashtable quantsOfClass = new Hashtable();
            Hashtable quantsOfOxClass = new Hashtable();
            Vector<String> analytes = new Vector<String>();
            Vector<String> oxAnalytes = new Vector<String>();
            Sheet sheet = workbook.getSheetAt(sheetNumber);
            boolean rtFilterInsensitive = false;
            boolean pickBestMatchBySpectrumCoverage = false;
            int sideChainColumn = -1;
            int doubleBondColumn = -1;
            int molecularSpeciesWithDoubleBondPositionsColumn = -1;
            int oxStateColumn = -1;
            Hashtable<Integer, String> massOfInterestColumns = new Hashtable<Integer, String>();
            Hashtable<String, Hashtable<String, Integer>> adductComposition = new Hashtable<String, Hashtable<String, Integer>>();
            Hashtable<String, Integer> charges = new Hashtable<String, Integer>();
            Hashtable<String, Integer> multi = new Hashtable<String, Integer>();
            int retTimeColumn = -1;
            boolean foundColumns = false;
            float fixedStartTime = 0.0f;
            float fixedEndTime = Float.MAX_VALUE;
            Hashtable elementColumns = new Hashtable();
            int msLevel = 1;
            int ohNumber = -1;
            RangeInteger ohRange = null;
            for (int rowCount = 0; rowCount != sheet.getLastRowNum() + 1; ++rowCount) {
                float usedPlusTime;
                Row row = sheet.getRow(rowCount);
                String sideChain = "";
                int doubleBonds = -1;
                String oxState = "";
                Hashtable elementalComposition = new Hashtable();
                Hashtable massesOfInterest = new Hashtable();
                float retTime = -1.0f;
                String molecularSpeciesWithDB = null;
                Hashtable<Integer, String> possibleElementColumns = new Hashtable<Integer, String>();
                for (int i = 0; row != null && i != row.getLastCellNum() + 1; ++i) {
                    Cell cell = row.getCell(i);
                    String contents = "";
                    Double numeric = null;
                    int cellType = -1;
                    if (cell != null) {
                        cellType = cell.getCellType();
                    }
                    if (cellType == 1) {
                        contents = cell.getStringCellValue();
                        try {
                            if (contents != null) {
                                numeric = new Double(contents.replaceAll(",", "."));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (cellType == 0 || cellType == 2) {
                        numeric = cell.getNumericCellValue();
                        contents = String.valueOf(numeric);
                    }
                    if (contents != null) {
                        contents = contents.trim();
                    }
                    if (!foundColumns) {
                        if (contents.equalsIgnoreCase("Seitenkette") || contents.equalsIgnoreCase("Name")) {
                            sideChainColumn = i;
                            continue;
                        }
                        if (contents.equalsIgnoreCase("dbs") || contents.equalsIgnoreCase("dbs_TAG")) {
                            doubleBondColumn = i;
                            continue;
                        }
                        if (contents.equalsIgnoreCase("PSM")) {
                            oxStateColumn = i;
                            continue;
                        }
                        if (contents.startsWith("mass") && contents.contains("(") && contents.contains(")")) {
                            String[] formulaAndName = QuantificationThread.extractFormulaAndAdductName(contents);
                            adductComposition.put(formulaAndName[1], StaticUtils.categorizeFormula(formulaAndName[0]));
                            massOfInterestColumns.put(i, formulaAndName[1]);
                            charges.put(formulaAndName[1], Integer.parseInt(formulaAndName[2]));
                            multi.put(formulaAndName[1], Integer.parseInt(formulaAndName[3]));
                            continue;
                        }
                        if (contents.equalsIgnoreCase("tR (min)")) {
                            retTimeColumn = i;
                            continue;
                        }
                        if (contents.startsWith("Start-RT:")) {
                            try {
                                fixedStartTime = Float.parseFloat(contents.substring("Start-RT:".length()).trim().replaceAll(",", "."));
                            }
                            catch (NumberFormatException nfx) {
                                nfx.printStackTrace();
                            }
                            continue;
                        }
                        if (contents.startsWith("Stop-RT:")) {
                            try {
                                fixedEndTime = Float.parseFloat(contents.substring("Stop-RT:".length()).trim().replaceAll(",", "."));
                            }
                            catch (NumberFormatException nfx) {}
                            continue;
                        }
                        if (contents.startsWith("Mass-Trace:")) {
                            try {
                                msLevel = Integer.parseInt(contents.substring("Mass-Trace:".length()).trim().replaceAll(",", "."));
                            }
                            catch (NumberFormatException nfx) {}
                            continue;
                        }
                        if (contents.trim().length() == 1 || contents.trim().length() == 2) {
                            boolean ok = false;
                            if (!Character.isUpperCase(contents.trim().toCharArray()[0])) continue;
                            if (contents.trim().length() == 2) {
                                if (Character.isLowerCase(contents.trim().toCharArray()[1])) {
                                    ok = true;
                                }
                            } else {
                                ok = true;
                            }
                            if (!ok) continue;
                            String element = contents.trim();
                            if (aaParser.isElementAvailable(element)) {
                                possibleElementColumns.put(i, element);
                                continue;
                            }
                            if (sideChainColumn <= -1) continue;
                            System.out.println("Warning: The elemental column \"" + element + "\" does not seem to be a chemical element!");
                            continue;
                        }
                        if (contents.trim().equalsIgnoreCase("adductInsensitiveRtFilter")) {
                            rtFilterInsensitive = true;
                            continue;
                        }
                        if (contents.startsWith("OH-Number:")) {
                            String ohString = contents.substring("OH-Number:".length()).trim().replaceAll(",", ".");
                            try {
                                ohNumber = Integer.parseInt(ohString);
                            }
                            catch (NumberFormatException nfx) {
                                ohNumber = Settings.getLcbHydroxyEncoding().getHydroxyNumber(ohString).shortValue();
                            }
                            continue;
                        }
                        if (contents.startsWith("OH-Range:")) {
                            String ohRangeString = contents.substring("OH-Range:".length()).trim().replaceAll(",", ".");
                            String[] ohRangeParts = ohRangeString.split("-");
                            boolean error = false;
                            try {
                                int start;
                                if (ohRangeParts.length > 2) {
                                    error = true;
                                }
                                int stop = start = Integer.parseInt(ohRangeParts[0]);
                                if (ohRangeParts.length == 2) {
                                    stop = Integer.parseInt(ohRangeParts[1]);
                                }
                                ohRange = new RangeInteger(start, stop);
                            }
                            catch (NumberFormatException nfx) {
                                error = true;
                            }
                            if (!error) continue;
                            throw new HydroxylationEncodingException("The value \"OH-Range\" must be a single integer, or a range in the format $lower$-$higher$; the value \"" + ohRangeString + "\" in sheet " + sheet.getSheetName() + " does not comply!");
                        }
                        if (contents.trim().equalsIgnoreCase("pickBestMatchBySpectrumCoverage")) {
                            pickBestMatchBySpectrumCoverage = true;
                            continue;
                        }
                        if (!contents.equalsIgnoreCase("mol. species")) continue;
                        molecularSpeciesWithDoubleBondPositionsColumn = i;
                        continue;
                    }
                    if (i == sideChainColumn && contents != null & contents.length() > 0) {
                        sideChain = numeric != null ? String.valueOf((int)Math.round(numeric)) : contents;
                    }
                    if (i == doubleBondColumn && contents != null && contents.length() > 0) {
                        doubleBonds = numeric.intValue();
                    }
                    if (i == oxStateColumn && contents != null && contents.length() > 0) {
                        oxState = contents;
                    }
                    if (elementColumns.containsKey(i) && contents.length() > 0) {
                        int value = 0;
                        if (numeric != null && contents.endsWith(".0")) {
                            value = (int)Math.round(numeric);
                        } else {
                            try {
                                value = Integer.parseInt(contents);
                            }
                            catch (NumberFormatException nfx3) {
                                System.out.println("Warning: The elemental column \"" + (String)elementColumns.get(i) + "\" does not seem to be a chemical element, since float values are there -> I remove it!");
                                elementColumns.remove(i);
                            }
                        }
                        if (value > 0) {
                            elementalComposition.put(elementColumns.get(i), value);
                        }
                    }
                    if (massOfInterestColumns.containsKey(i) && contents != null & contents.length() > 0) {
                        double massOfInterest = numeric;
                        if (respectMassShift) {
                            massOfInterest += LipidomicsConstants.getMassShift();
                        }
                        massesOfInterest.put(massOfInterestColumns.get(i), massOfInterest);
                    }
                    if (i == retTimeColumn && contents != null & contents.length() > 0) {
                        retTime = numeric.floatValue();
                        retTime += rtShift;
                    }
                    if (i != molecularSpeciesWithDoubleBondPositionsColumn || !(contents != null & contents.length() > 0)) continue;
                    molecularSpeciesWithDB = contents;
                }
                if (sideChainColumn != -1 && possibleElementColumns.size() > 0 && massOfInterestColumns.size() > 0 && retTimeColumn != -1 && !foundColumns) {
                    foundColumns = true;
                    elementColumns = new Hashtable(possibleElementColumns);
                }
                if (!foundColumns || sideChain == null || sideChain.length() <= 0 || massesOfInterest.size() <= 0) continue;
                float usedMinusTime = new Float(minusTime).floatValue();
                if (usedMinusTime < 0.0f) {
                    usedMinusTime *= -1.0f;
                }
                if ((usedPlusTime = new Float(plusTime).floatValue()) < 0.0f) {
                    usedPlusTime *= -1.0f;
                }
                if (!(retTime > 0.0f) && !searchUnknownTime) continue;
                if (fixedStartTime > 0.0f || fixedEndTime < Float.MAX_VALUE && fixedStartTime < fixedEndTime) {
                    if (retTime > 0.0f) {
                        if (fixedStartTime < retTime && retTime < fixedEndTime) {
                            if (fixedStartTime > retTime - usedMinusTime) {
                                usedMinusTime = retTime - fixedStartTime;
                            }
                            if (fixedEndTime < retTime + usedPlusTime) {
                                usedPlusTime = fixedEndTime - retTime;
                            }
                        }
                    } else {
                        float startTime = lowestRetTime;
                        float stopTime = highestRetTime;
                        if (fixedStartTime > startTime) {
                            startTime = fixedStartTime;
                        }
                        if (fixedEndTime < stopTime) {
                            stopTime = fixedEndTime;
                        }
                        retTime = (startTime + stopTime) / 2.0f;
                        usedMinusTime = retTime - startTime;
                        usedPlusTime = stopTime - retTime;
                    }
                }
                int startOh = 0;
                int stopOh = 0;
                if (ohNumber > -1) {
                    startOh = ohNumber;
                    stopOh = ohNumber;
                    if (ohRange != null) {
                        startOh = ohRange.getStart();
                        stopOh = ohRange.getStop();
                    }
                }
                String[] oxStates = oxState.split(";");
                if (oxState.length() == 0) {
                    for (int oh = startOh; oh < stopOh + 1; ++oh) {
                        Object modName2;
                        Hashtable<Object, QuantVO> quantsOfAnalyte = new Hashtable<Object, QuantVO>();
                        String analEncoded = null;
                        Hashtable<String, Integer> correctedElementalComposition = new Hashtable<String, Integer>(elementalComposition);
                        double ohDiff = 0.0;
                        int ohToUse = -1;
                        if (ohNumber > -1) {
                            ohToUse = oh;
                            if (oh != ohNumber) {
                                int oxygens = 0;
                                if (correctedElementalComposition.containsKey("O")) {
                                    oxygens = (Integer)correctedElementalComposition.get("O");
                                }
                                if ((oxygens += oh - ohNumber) < 0) continue;
                                correctedElementalComposition.put("O", oxygens);
                                ohDiff = (double)(oh - ohNumber) * Settings.getElementParser().getElementDetails("O").getMonoMass();
                            }
                        }
                        for (Object modName2 : massesOfInterest.keySet()) {
                            Hashtable modElements = (Hashtable)adductComposition.get(modName2);
                            Integer charge = (Integer)charges.get(modName2);
                            double massOfInterest = (Double)massesOfInterest.get(modName2) + ohDiff / (double)charge.intValue();
                            Integer mult = (Integer)multi.get(modName2);
                            String[] formulas = QuantificationThread.getFormulasAsString(correctedElementalComposition, modElements, mult);
                            String analyteFormula = formulas[0];
                            String modificationFormula = formulas[1];
                            String chemicalFormula = formulas[2];
                            if (chemicalFormula.indexOf("-") != -1) continue;
                            Object[] distris = QuantificationThread.getTheoreticalIsoDistributions(aaParser, isotopesMustMatch, amountOfIsotopes, chemicalFormula);
                            Vector mustMatchProbabs = (Vector)distris[0];
                            Vector probabs = (Vector)distris[1];
                            int negativeStartValue = (Integer)distris[2];
                            QuantVO quantVO = new QuantVO(sheet.getSheetName(), sideChain, doubleBonds, ohToUse, analyteFormula, massOfInterest, charge, (String)modName2, modificationFormula, retTime, usedMinusTime, usedPlusTime, mustMatchProbabs, probabs, negativeStartValue, "");
                            analEncoded = quantVO.getAnalyteName();
                            quantsOfAnalyte.put(modName2, quantVO);
                        }
                        String analyteName = StaticUtils.generateLipidNameString(analEncoded != null ? analEncoded : sideChain, (Integer)doubleBonds, -1, "");
                        if (!quantsOfClass.containsKey(analyteName)) {
                            analytes.add(analyteName);
                            quantsOfClass.put(analyteName, quantsOfAnalyte);
                        } else if (!QuantificationThread.hasValidInfoForOmegaAssignment(molecularSpeciesWithDB, retTime)) {
                            System.out.println(String.format("Ignoring duplicate analyte %s in mass list (line %s)!", analyteName, rowCount + 1));
                        }
                        if (!QuantificationThread.hasValidInfoForOmegaAssignment(molecularSpeciesWithDB, retTime)) continue;
                        modName2 = quantsOfAnalyte.keySet().iterator();
                        while (modName2.hasNext()) {
                            String mod = (String)modName2.next();
                            try {
                                Vector<FattyAcidVO> chainCombination = StaticUtils.decodeFAsFromHumanReadableName(molecularSpeciesWithDB, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), false, null);
                                DoubleBondPositionVO doubleBondPositionVO = new DoubleBondPositionVO(chainCombination, retTime);
                                ((QuantVO)((Hashtable)quantsOfClass.get(analyteName)).get(mod)).addInfoForOmegaAssignment(doubleBondPositionVO);
                            }
                            catch (LipidCombinameEncodingException ex) {
                                System.out.println(ex.getMessage());
                            }
                        }
                    }
                    continue;
                }
                for (String oxMod : oxStates) {
                    oxMod = oxMod.replaceAll("\\s", "");
                    for (int oh = startOh; oh < stopOh + 1; ++oh) {
                        Hashtable<String, QuantVO> quantsOfAnalyte = new Hashtable<String, QuantVO>();
                        Hashtable<String, QuantVO> quantsOfOxAnalyte = new Hashtable<String, QuantVO>();
                        String analEncoded = null;
                        Hashtable<String, Integer> correctedElementalComposition = new Hashtable<String, Integer>(elementalComposition);
                        double ohDiff = 0.0;
                        int ohToUse = -1;
                        if (ohNumber > -1) {
                            ohToUse = oh;
                            if (oh != ohNumber) {
                                int oxygens = 0;
                                if (correctedElementalComposition.containsKey("O")) {
                                    oxygens = correctedElementalComposition.get("O");
                                }
                                if ((oxygens += oh - ohNumber) < 0) continue;
                                correctedElementalComposition.put("O", oxygens);
                                ohDiff = (double)(oh - ohNumber) * Settings.getElementParser().getElementDetails("O").getMonoMass();
                            }
                        }
                        ModificationParser mp = new ModificationParser(oxMod);
                        mp.parse();
                        correctedElementalComposition = mp.getNewChemicalComposition(correctedElementalComposition);
                        for (String modName : massesOfInterest.keySet()) {
                            String analyteClass = sheet.getSheetName();
                            Hashtable modElements = (Hashtable)adductComposition.get(modName);
                            Integer charge = (Integer)charges.get(modName);
                            double massOfInterest = mp.getNewMass((Double)massesOfInterest.get(modName) + ohDiff / (double)charge.intValue());
                            Integer mult = (Integer)multi.get(modName);
                            String[] formulas = QuantificationThread.getFormulasAsString(correctedElementalComposition, modElements, mult);
                            String analyteFormula = formulas[0];
                            String modificationFormula = formulas[1];
                            String chemicalFormula = formulas[2];
                            if (chemicalFormula.indexOf("-") != -1) continue;
                            Object[] distris = QuantificationThread.getTheoreticalIsoDistributions(aaParser, isotopesMustMatch, amountOfIsotopes, chemicalFormula);
                            Vector mustMatchProbabs = (Vector)distris[0];
                            Vector probabs = (Vector)distris[1];
                            int negativeStartValue = (Integer)distris[2];
                            if (!oxMod.equals("")) {
                                analyteClass = "ox" + analyteClass;
                            }
                            QuantVO quantVO = new QuantVO(analyteClass, sideChain, doubleBonds, ohToUse, analyteFormula, massOfInterest, charge, modName, modificationFormula, retTime, usedMinusTime, usedPlusTime, mustMatchProbabs, probabs, negativeStartValue, oxMod);
                            analEncoded = quantVO.getAnalyteName();
                            if (oxMod.equals("")) {
                                quantsOfAnalyte.put(modName, quantVO);
                                continue;
                            }
                            quantsOfOxAnalyte.put(modName, quantVO);
                        }
                        String analyteName = StaticUtils.generateLipidNameString(analEncoded != null ? analEncoded : sideChain, (Integer)doubleBonds, -1, oxMod);
                        if (oxMod.equals("")) {
                            analytes.add(analyteName);
                            quantsOfClass.put(analyteName, quantsOfAnalyte);
                            continue;
                        }
                        oxAnalytes.add(analyteName);
                        quantsOfOxClass.put(analyteName, quantsOfOxAnalyte);
                    }
                }
            }
            quantObjects.put(sheet.getSheetName(), quantsOfClass);
            analyteSequence.put(sheet.getSheetName(), analytes);
            classSequence.put(sheet.getSheetName(), msLevel);
            adductInsensitiveRtFilter.put(sheet.getSheetName(), rtFilterInsensitive);
            bestMatchBySpectrumCoverage.put(sheet.getSheetName(), pickBestMatchBySpectrumCoverage);
            if (!oxAnalytes.isEmpty()) {
                quantObjects.put("ox" + sheet.getSheetName(), quantsOfOxClass);
                analyteSequence.put("ox" + sheet.getSheetName(), oxAnalytes);
                classSequence.put("ox" + sheet.getSheetName(), msLevel);
                adductInsensitiveRtFilter.put("ox" + sheet.getSheetName(), rtFilterInsensitive);
                bestMatchBySpectrumCoverage.put("ox" + sheet.getSheetName(), pickBestMatchBySpectrumCoverage);
            }
            if (!foundColumns) continue;
            excelOK = true;
        }
        ((InputStream)myxls).close();
        if (!excelOK) {
            throw new ExcelInputFileException("The Excel file is not valid!");
        }
        QuantificationThread.checkForIsobaricSpecies(classSequence, analyteSequence, quantObjects);
        Vector<Map<String, Serializable>> results = new Vector<Map<String, Serializable>>();
        results.add(classSequence);
        results.add(analyteSequence);
        results.add(adductInsensitiveRtFilter);
        results.add(bestMatchBySpectrumCoverage);
        results.add(quantObjects);
        return results;
    }

    private static boolean hasValidInfoForOmegaAssignment(String molecularSpeciesWithDB, float retTime) {
        return molecularSpeciesWithDB != null && retTime > 0.0f;
    }

    public static Vector getCorrectAnalyteSequence(String filePath, boolean ionMode) throws Exception {
        File quant = new File(filePath);
        Vector quantContent = null;
        if (quant.isFile() && (quant.getName().endsWith(".xls") || quant.getName().endsWith(".xlsx"))) {
            quantContent = QuantificationThread.parseQuantExcelFile(filePath, 0.0f, 0.0f, 0, 0, true, 0.0f, 0.0f, 0.0f, 0.0f);
        } else if (quant.isFile() && quant.getName().endsWith(".txt") || quant.isDirectory()) {
            System.out.println("Ion mode: " + ionMode);
            quantContent = QuantificationThread.parseAlex123TargetList(filePath, 0.0f, 0.0f, 0, 0, true, 0.0f, 0.0f, 0.0f, 0.0f, ionMode);
        }
        if (quantContent != null) {
            return quantContent;
        }
        return null;
    }

    private float[] initThreadMonitors(String[] chromPaths, int numberOfProcessors, float basePeakCutoff) throws CgException {
        this.availableThreads_ = new Hashtable();
        this.analyzers_ = new Hashtable();
        this.threadToClass_ = new Hashtable();
        this.threadToAnalyte_ = new Hashtable();
        this.threadToMod_ = new Hashtable();
        float[] maxRetTimes = new float[2];
        for (int i = 0; i != numberOfProcessors; ++i) {
            this.availableThreads_.put(i, true);
            LipidomicsAnalyzer analyzer = new LipidomicsAnalyzer(chromPaths[1], chromPaths[2], chromPaths[3], chromPaths[0], Settings.useCuda());
            if (i == 0) {
                float highestRetTime = 0.0f;
                float lowestRetTime = Float.MAX_VALUE;
                for (float retTime : analyzer.getRetentionTimes().values()) {
                    if (retTime > highestRetTime) {
                        highestRetTime = retTime;
                    }
                    if (!(retTime < lowestRetTime)) continue;
                    lowestRetTime = retTime;
                }
                maxRetTimes[1] = highestRetTime / 60.0f;
                maxRetTimes[0] = lowestRetTime / 60.0f;
            }
            QuantificationThread.setAnalyzerProperties(analyzer);
            analyzer.setGeneralBasePeakCutoff(basePeakCutoff / 3.0f);
            this.analyzers_.put(i, analyzer);
        }
        return maxRetTimes;
    }

    /*
     * WARNING - void declaration
     */
    private void handleTimerEvent(LinkedHashMap<String, Integer> classSequence, LinkedHashMap<String, Vector<String>> analyteSequence, Hashtable<String, Boolean> adductInsensitiveRtFilter, Hashtable<String, Boolean> bestMatchBySpectrumCoverage, Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects, float basePeakCutoff, String resultFile, String chromFile) {
        boolean allFinished = true;
        boolean error = false;
        boolean stopThread = false;
        for (int i = 0; i != this.availableThreads_.size(); ++i) {
            if (this.availableThreads_.get(i).booleanValue() || this.threads_.get(i) == null || !this.threads_.get(i).finished()) continue;
            SingleQuantThread singleThread = this.threads_.get(i);
            String className = this.threadToClass_.get(i);
            String string = this.threadToAnalyte_.get(i);
            String string2 = this.threadToMod_.get(i);
            if (singleThread.getErrorString() != null) {
                this.errorString_ = singleThread.getErrorString();
                error = true;
                stopThread = true;
            } else {
                Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> hitsAccordingToQuant = singleThread.getResults();
                Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> hashtable = singleThread.getMs2Removedhits();
                Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> beforeSplitToQuant = singleThread.getPeaksBeforeSplit();
                Hashtable<String, Hashtable<QuantVO, LipidParameterSet>> msnHitsWithSameRt = this.groupHitsWithSameRt(hitsAccordingToQuant);
                for (QuantVO quantVO : hitsAccordingToQuant.keySet()) {
                    Hashtable<String, LipidParameterSet> hitsOfOneMod = hitsAccordingToQuant.get(quantVO);
                    Hashtable<Object, Object> ms2Removed = new Hashtable();
                    if (hashtable.containsKey(quantVO)) {
                        ms2Removed = hashtable.get(quantVO);
                    }
                    Hashtable<Object, Object> beforeSplit = new Hashtable();
                    if (beforeSplitToQuant.containsKey(quantVO)) {
                        beforeSplit = beforeSplitToQuant.get(quantVO);
                    }
                    if (hitsOfOneMod.size() > 0) {
                        Hashtable<Object, Object> resultsClass = new Hashtable();
                        if (this.results_.containsKey(quantVO.getAnalyteClass())) {
                            resultsClass = this.results_.get(quantVO.getAnalyteClass());
                        }
                        Hashtable resultsAnalyte = new Hashtable();
                        if (resultsClass.containsKey(quantVO.getIdString())) {
                            resultsAnalyte = (Hashtable)resultsClass.get(quantVO.getIdString());
                        }
                        Hashtable<String, LipidParameterSet> newHits = new Hashtable<String, LipidParameterSet>();
                        for (String string3 : hitsOfOneMod.keySet()) {
                            LipidParameterSet set = hitsOfOneMod.get(string3);
                            set.setOxState(quantVO.getOxState());
                            boolean insideAllowedMz = false;
                            if (LipidomicsConstants.isShotgun() == 1) {
                                insideAllowedMz = true;
                            } else {
                                for (CgProbe probe : set.getIsotopicProbes().get(0)) {
                                    if (!((float)quantVO.getAnalyteMass() - LipidomicsConstants.getProfilePeakAcceptanceRange() <= probe.Mz) || !(probe.Mz <= (float)quantVO.getAnalyteMass() + LipidomicsConstants.getProfilePeakAcceptanceRange())) continue;
                                    insideAllowedMz = true;
                                    break;
                                }
                            }
                            if (!insideAllowedMz) continue;
                            newHits.put(string3, set);
                        }
                        if (resultsAnalyte.containsKey(quantVO.getModName())) {
                            Hashtable hashMods = (Hashtable)resultsAnalyte.get(quantVO.getModName());
                            for (LipidParameterSet set : newHits.values()) {
                                Vector<CgProbe> probes = set.getIsotopicProbes().get(0);
                                boolean overlap = false;
                                block23: for (LipidParameterSet there : hashMods.values()) {
                                    if (overlap) break;
                                    block24: for (CgProbe probe : probes) {
                                        if (overlap) continue block23;
                                        for (CgProbe other : there.getIsotopicProbes().get(0)) {
                                            if (overlap) continue block24;
                                            if (probe.isCoveredByThisProbe(other)) {
                                                overlap = true;
                                            }
                                            if (probe.Peak < other.Peak) {
                                                if (!(probe.UpperValley > other.LowerValley)) continue;
                                                overlap = true;
                                                continue;
                                            }
                                            if (!(probe.LowerValley < other.UpperValley)) continue;
                                            overlap = true;
                                        }
                                    }
                                }
                                if (overlap) continue;
                                hashMods.put(set.getRt(), set);
                            }
                        } else {
                            resultsAnalyte.put(quantVO.getModName(), newHits);
                        }
                        resultsClass.put(quantVO.getIdString(), resultsAnalyte);
                        this.results_.put(quantVO.getAnalyteClass(), resultsClass);
                        if (beforeSplit.size() > 0) {
                            this.unsplittedPeaks_.get(quantVO.getAnalyteClass()).get(quantVO.getIdString()).put(quantVO.getModName(), beforeSplit);
                        }
                    } else if (singleThread.isMsnFirst() && !singleThread.areMSnSpectraPresent()) {
                        try {
                            int msIdentOrder = RulesContainer.getMSIdentificationOrder(StaticUtils.getRuleName(quantVO.getAnalyteClass(), quantVO.getModName()));
                            if (msIdentOrder == 1) {
                                quantVO.removeOtherIsobaricSpecies();
                                Hashtable<Object, Object> quantClass = new Hashtable();
                                if (this.onlyMS1DataPresent_.containsKey(quantVO.getAnalyteClass())) {
                                    quantClass = this.onlyMS1DataPresent_.get(quantVO.getAnalyteClass());
                                }
                                Hashtable quantAnalyte = new Hashtable();
                                if (quantClass.containsKey(quantVO.getIdString())) {
                                    quantAnalyte = (Hashtable)quantClass.get(quantVO.getIdString());
                                }
                                quantAnalyte.put(quantVO.getModName(), quantVO);
                                quantClass.put(quantVO.getIdString(), quantAnalyte);
                                this.onlyMS1DataPresent_.put(quantVO.getAnalyteClass(), quantClass);
                            }
                        }
                        catch (Exception msIdentOrder) {
                            // empty catch block
                        }
                    }
                    try {
                        if (!RulesContainer.isRtPostprocessing(StaticUtils.getRuleName(quantVO.getAnalyteClass(), quantVO.getModName())) || !RulesContainer.correctRtForParallelModel(StaticUtils.getRuleName(quantVO.getAnalyteClass(), quantVO.getModName())) || ms2Removed.size() <= 0) continue;
                        this.ms2Removed_.get(quantVO.getAnalyteClass()).get(quantVO.getIdString()).put(quantVO.getModName(), ms2Removed);
                    }
                    catch (Exception msIdentOrder) {}
                }
                for (String string4 : msnHitsWithSameRt.keySet()) {
                    if (msnHitsWithSameRt.get(string4).size() < 2) continue;
                    int count = 0;
                    LipidParameterSet set = null;
                    QuantVO toQuant = null;
                    for (QuantVO quant : msnHitsWithSameRt.get(string4).keySet()) {
                        if (!this.results_.containsKey(quant.getAnalyteClass()) || !this.results_.get(quant.getAnalyteClass()).containsKey(quant.getIdString()) || !this.results_.get(quant.getAnalyteClass()).get(quant.getIdString()).containsKey(quant.getModName()) || !this.results_.get(quant.getAnalyteClass()).get(quant.getIdString()).get(quant.getModName()).containsKey(string4)) continue;
                        set = this.results_.get(quant.getAnalyteClass()).get(quant.getIdString()).get(quant.getModName()).get(string4);
                        toQuant = quant;
                        ++count;
                    }
                    if (count != 1 || !(set instanceof LipidomicsMSnSet)) continue;
                    try {
                        MSnAnalyzer msnAnalyzer = new MSnAnalyzer(toQuant.getAnalyteClass(), toQuant.getModName(), set, singleThread.getAnalyzer(), toQuant, true, false);
                        if (msnAnalyzer.checkStatus() <= 1) {
                            this.results_.get(toQuant.getAnalyteClass()).get(toQuant.getIdString()).get(toQuant.getModName()).remove(string4);
                            if (this.results_.get(toQuant.getAnalyteClass()).get(toQuant.getIdString()).get(toQuant.getModName()).size() == 0) {
                                this.results_.get(toQuant.getAnalyteClass()).get(toQuant.getIdString()).remove(toQuant.getModName());
                            }
                            if (this.results_.get(toQuant.getAnalyteClass()).get(toQuant.getIdString()).size() != 0) continue;
                            this.results_.get(toQuant.getAnalyteClass()).remove(toQuant.getIdString());
                            continue;
                        }
                        this.results_.get(toQuant.getAnalyteClass()).get(toQuant.getIdString()).get(toQuant.getModName()).put(string4, msnAnalyzer.getResult());
                    }
                    catch (ChemicalFormulaException | HydroxylationEncodingException | LipidCombinameEncodingException | RulesException | SpectrummillParserException | CgException | IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.quantStatus_.get(className).get(string).put(string2, 2);
            singleThread = null;
            this.availableThreads_.put(i, true);
        }
        Vector<Integer> availableThread = new Vector<Integer>();
        if (!error) {
            for (int i = 0; i != this.availableThreads_.size(); ++i) {
                if (!this.availableThreads_.get(i).booleanValue()) continue;
                availableThread.add(i);
            }
        }
        int currentThreadNumber = 0;
        if (!error && availableThread.size() > 0) {
            block29: for (String string : classSequence.keySet()) {
                if (currentThreadNumber >= availableThread.size()) break;
                Hashtable<String, Hashtable<String, QuantVO>> hashtable = quantObjects.get(string);
                quantObjects.get(string);
                int msLevel = classSequence.get(string);
                block30: for (String analyteName : analyteSequence.get(string)) {
                    if (currentThreadNumber >= availableThread.size()) continue block29;
                    Hashtable<String, QuantVO> analyteQuant = hashtable.get(analyteName);
                    int modCount = 0;
                    for (String mod : analyteQuant.keySet()) {
                        if (currentThreadNumber >= availableThread.size()) continue block30;
                        if (this.quantStatus_.get(string).get(analyteName).get(mod) == 0) {
                            int threadIndex = (Integer)availableThread.get(currentThreadNumber);
                            this.availableThreads_.put(threadIndex, false);
                            this.quantStatus_.get(string).get(analyteName).put(mod, 1);
                            boolean msnFirst = false;
                            if (LipidomicsConstants.isMS2() && !this.msnRoundFinished_) {
                                Vector<QuantVO> quants = new Vector<QuantVO>();
                                quants.add(analyteQuant.get(mod));
                                quants.addAll(analyteQuant.get(mod).getOtherIsobaricSpecies());
                                Collections.sort(quants);
                                for (int i = 0; i != quants.size(); ++i) {
                                    QuantVO quant = (QuantVO)quants.get(i);
                                    try {
                                        int msIdentOrder = RulesContainer.getMSIdentificationOrder(StaticUtils.getRuleName(quant.getAnalyteClass(), quant.getModName()));
                                        if (i == 0 && (msIdentOrder == 1 || msIdentOrder == 2)) {
                                            msnFirst = true;
                                            continue;
                                        }
                                        if (msIdentOrder != 0) continue;
                                        msnFirst = false;
                                        continue;
                                    }
                                    catch (Exception msIdentOrder) {
                                        // empty catch block
                                    }
                                }
                            }
                            SingleQuantThread thread = new SingleQuantThread(this.analyzers_.get(threadIndex), analyteQuant.get(mod), msLevel, msnFirst);
                            this.threads_.put(threadIndex, thread);
                            this.threadToClass_.put(threadIndex, string);
                            this.threadToAnalyte_.put(threadIndex, analyteName);
                            this.threadToMod_.put(threadIndex, mod);
                            thread.start();
                            if (modCount == 0) {
                                this.currentLipid_ = string + " " + analyteName;
                            }
                            ++currentThreadNumber;
                        }
                        ++modCount;
                    }
                }
            }
            int currentLipidCount = 0;
            for (String string : this.quantStatus_.keySet()) {
                for (String string5 : this.quantStatus_.get(string).keySet()) {
                    Hashtable<String, Integer> modStati = this.quantStatus_.get(string).get(string5);
                    boolean oneDifferent = false;
                    for (Integer n : modStati.values()) {
                        if (n == 0) continue;
                        oneDifferent = true;
                        break;
                    }
                    if (!oneDifferent || this.onlyMS1DataPresent_.containsKey(string) && this.onlyMS1DataPresent_.get(string).containsKey(string5)) continue;
                    ++currentLipidCount;
                }
            }
            this.currentLipidCount_ = currentLipidCount;
        }
        if (!error && availableThread.size() > 0 && currentThreadNumber == 0) {
            for (String string : this.quantStatus_.keySet()) {
                block37: for (String analyte : this.quantStatus_.get(string).keySet()) {
                    for (String mod : this.quantStatus_.get(string).get(analyte).keySet()) {
                        if (this.quantStatus_.get(string).get(analyte).get(mod) == 2) continue;
                        allFinished = false;
                        continue block37;
                    }
                }
            }
        } else {
            allFinished = false;
        }
        if (allFinished) {
            stopThread = true;
        }
        if (stopThread) {
            void var15_35;
            boolean areThereMS1HitsToProcess = false;
            this.msnRoundFinished_ = true;
            if (!error && this.onlyMS1DataPresent_.size() > 0) {
                areThereMS1HitsToProcess = true;
            }
            boolean bl = false;
            if (areThereMS1HitsToProcess) {
                PostQuantificationProcessor postQuantificationProcessor = new PostQuantificationProcessor(this.results_, this.ms2Removed_, adductInsensitiveRtFilter);
                try {
                    Hashtable<String, Hashtable<String, QuantVO>> ofClass;
                    this.latestRtPredictions_ = postQuantificationProcessor.predictRetentionTimesBasedOnResults(this.onlyMS1DataPresent_, this.latestRtPredictions_);
                    Hashtable<String, Hashtable> predictionFound = new Hashtable<String, Hashtable>();
                    Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
                    for (String className : this.onlyMS1DataPresent_.keySet()) {
                        ofClass = this.onlyMS1DataPresent_.get(className);
                        for (String analyteName : ofClass.keySet()) {
                            Hashtable ofAnalyte = (Hashtable)ofClass.get(analyteName);
                            for (String modName : ofAnalyte.keySet()) {
                                void var30_132;
                                void var15_34;
                                QuantVO vo = (QuantVO)ofAnalyte.get(modName);
                                if (vo.getRetTime() < 0.0f) continue;
                                this.quantStatus_.get(className).get(analyteName).put(modName, 0);
                                ++var15_34;
                                Hashtable modFound = new Hashtable();
                                if (predictionFound.containsKey(className)) {
                                    modFound = (Hashtable)predictionFound.get(className);
                                }
                                modFound.put(modName, true);
                                predictionFound.put(className, modFound);
                                Hashtable classToRemove = new Hashtable();
                                if (hashtable.containsKey(className)) {
                                    classToRemove = (Hashtable)hashtable.get(className);
                                }
                                Hashtable hashtable2 = new Hashtable();
                                if (classToRemove.containsKey(analyteName)) {
                                    Hashtable hashtable3 = (Hashtable)classToRemove.get(analyteName);
                                }
                                var30_132.put(modName, modName);
                                classToRemove.put(analyteName, var30_132);
                                hashtable.put(className, classToRemove);
                            }
                        }
                    }
                    for (String className : hashtable.keySet()) {
                        for (String string : ((Hashtable)hashtable.get(className)).keySet()) {
                            for (String modName : ((Hashtable)((Hashtable)hashtable.get(className)).get(string)).keySet()) {
                                this.onlyMS1DataPresent_.get(className).get(string).remove(modName);
                            }
                            if (this.onlyMS1DataPresent_.get(className).get(string).size() != 0) continue;
                            this.onlyMS1DataPresent_.get(className).remove(string);
                        }
                        if (this.onlyMS1DataPresent_.get(className).size() != 0) continue;
                        this.onlyMS1DataPresent_.remove(className);
                    }
                    Hashtable<String, Hashtable> hashtable4 = new Hashtable<String, Hashtable>();
                    for (String className : this.onlyMS1DataPresent_.keySet()) {
                        ofClass = this.onlyMS1DataPresent_.get(className);
                        for (String analyteName : ofClass.keySet()) {
                            Hashtable<String, QuantVO> ofAnalyte = ofClass.get(analyteName);
                            for (String modName : ofAnalyte.keySet()) {
                                if (predictionFound.containsKey(className) && ((Hashtable)predictionFound.get(className)).containsKey(modName) && ((Boolean)((Hashtable)predictionFound.get(className)).get(modName)).booleanValue()) continue;
                                this.quantStatus_.get(className).get(analyteName).put(modName, 0);
                                ++var15_35;
                                ofAnalyte.remove(modName);
                                Hashtable classToRemove = new Hashtable();
                                if (hashtable4.containsKey(className)) {
                                    classToRemove = (Hashtable)hashtable4.get(className);
                                }
                                Hashtable analyteToRemove = new Hashtable();
                                if (classToRemove.containsKey(analyteName)) {
                                    analyteToRemove = (Hashtable)classToRemove.get(analyteName);
                                }
                                analyteToRemove.put(modName, modName);
                                classToRemove.put(analyteName, analyteToRemove);
                                hashtable4.put(className, classToRemove);
                            }
                        }
                    }
                    for (String className : hashtable4.keySet()) {
                        for (String string : ((Hashtable)hashtable4.get(className)).keySet()) {
                            for (String modName : ((Hashtable)((Hashtable)hashtable4.get(className)).get(string)).keySet()) {
                                this.onlyMS1DataPresent_.get(className).get(string).remove(modName);
                            }
                            if (this.onlyMS1DataPresent_.get(className).get(string).size() != 0) continue;
                            this.onlyMS1DataPresent_.get(className).remove(string);
                        }
                        if (this.onlyMS1DataPresent_.get(className).size() != 0) continue;
                        this.onlyMS1DataPresent_.remove(className);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    new WarningMessage(new JFrame(), "Warning", "Post processing could not be executed because of: " + e.getMessage() + "!");
                }
            }
            if (var15_35 > 0) {
                stopThread = false;
            }
        }
        if (stopThread) {
            if (!error) {
                if (LipidomicsConstants.isShotgun() != 1) {
                    try {
                        this.results_ = OtherAdductChecker.checkTheResultsForOtherAdducts(this.results_, this.unsplittedPeaks_, quantObjects, this.analyzers_.get(0), classSequence);
                    }
                    catch (LipidCombinameEncodingException | CgException e) {
                        e.printStackTrace();
                    }
                }
                if (LipidomicsConstants.isShotgun() != 1 && LipidomicsConstants.isMS2()) {
                    PostQuantificationProcessor processor = new PostQuantificationProcessor(this.results_, this.ms2Removed_, adductInsensitiveRtFilter);
                    try {
                        this.results_ = processor.chooseMoreLikelyOne(quantObjects);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        new WarningMessage(new JFrame(), "Warning", "Choose more likely one could not be executed because of: " + exception.getMessage() + "!");
                    }
                    try {
                        this.results_ = processor.processData();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        new WarningMessage(new JFrame(), "Warning", "Post processing could not be executed because of: " + exception.getMessage() + "!");
                    }
                    this.results_ = this.reuniteWronglySeparatedPeaks(this.results_, quantObjects, this.unsplittedPeaks_);
                }
                if (LipidomicsConstants.isShotgun() != 1) {
                    try {
                        OtherAdductChecker.removePeaksThatFallBelowTheBasepeakCutoff(this.results_, this.extractHighestArea() * (basePeakCutoff / 1000.0f));
                        this.results_ = OtherAdductChecker.checkTheResultsForOtherAdducts(this.results_, this.unsplittedPeaks_, quantObjects, this.analyzers_.get(0), classSequence);
                    }
                    catch (LipidCombinameEncodingException | CgException e) {
                        e.printStackTrace();
                    }
                }
                this.executeFinalProcesses(classSequence, analyteSequence, quantObjects, basePeakCutoff, resultFile, chromFile, bestMatchBySpectrumCoverage);
            }
            this.finished_ = true;
            for (Integer n : this.analyzers_.keySet()) {
                if (!this.analyzers_.get(n).getUseCuda()) continue;
                this.analyzers_.get(n).getSavGolJNI().Frees();
            }
        }
    }

    private Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> reuniteWronglySeparatedPeaks(Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> results, Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects, Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> unsplittedPeaks_) {
        Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> result = new Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>>();
        for (String className : results.keySet()) {
            Hashtable classResult = new Hashtable();
            Hashtable<String, Hashtable<String, QuantVO>> quantsOfClass = quantObjects.get(className);
            Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>> oldClassResult = results.get(className);
            for (String analyte : oldClassResult.keySet()) {
                Hashtable analyteResults = new Hashtable();
                Hashtable<String, QuantVO> quantsOfAnalyte = quantsOfClass.get(analyte);
                Hashtable<String, Hashtable<String, LipidParameterSet>> oldAnalyteResults = oldClassResult.get(analyte);
                for (String mod : oldAnalyteResults.keySet()) {
                    Hashtable<String, LipidParameterSet> modResults = new Hashtable<String, LipidParameterSet>();
                    QuantVO quant = quantsOfAnalyte.get(mod);
                    Vector<QuantVO> quants = new Vector<QuantVO>();
                    quants.add(quant);
                    quants.addAll(quant.getOtherIsobaricSpecies());
                    Hashtable<String, LipidParameterSet> oldModResults = oldAnalyteResults.get(mod);
                    Hashtable<Object, Object> unsplittedMod = new Hashtable();
                    if (unsplittedPeaks_.containsKey(className) && unsplittedPeaks_.get(className).containsKey(analyte) && unsplittedPeaks_.get(className).get(analyte).containsKey(mod)) {
                        unsplittedMod = unsplittedPeaks_.get(className).get(analyte).get(mod);
                    }
                    for (String rt : oldModResults.keySet()) {
                        LipidParameterSet set = oldModResults.get(rt);
                        if (!this.splittingPartnerPresent(quants, className, analyte, mod, rt, results)) {
                            if (unsplittedMod.containsKey(rt)) {
                                set = (LipidParameterSet)unsplittedMod.get(rt);
                            } else {
                                set.setPercentalSplit(-1.0f);
                            }
                        }
                        modResults.put(rt, set);
                    }
                    if (modResults.size() <= 0) continue;
                    analyteResults.put(mod, modResults);
                }
                if (analyteResults.size() <= 0) continue;
                classResult.put(analyte, analyteResults);
            }
            result.put(className, classResult);
        }
        return result;
    }

    private boolean splittingPartnerPresent(Vector<QuantVO> quants, String className, String analyte, String mod, String rt, Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> result) {
        boolean partnerThere = false;
        for (QuantVO quant : quants) {
            String quantAnalName = quant.getIdString();
            if (quant.getAnalyteClass().equalsIgnoreCase(className) && quantAnalName.equalsIgnoreCase(analyte) && quant.getModName().equalsIgnoreCase(mod) || !result.containsKey(quant.getAnalyteClass()) || !result.get(quant.getAnalyteClass()).containsKey(quantAnalName) || !result.get(quant.getAnalyteClass()).get(quantAnalName).containsKey(quant.getModName()) || !result.get(quant.getAnalyteClass()).get(quantAnalName).get(quant.getModName()).containsKey(rt)) continue;
            partnerThere = true;
            break;
        }
        return partnerThere;
    }

    private void executeFinalProcesses(LinkedHashMap<String, Integer> classSequence, LinkedHashMap<String, Vector<String>> analyteSequence, Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects, float basePeakCutoff, String resultFile, String chromFile, Hashtable<String, Boolean> bestMatchBySpectrumCoverage) {
        Hashtable sheetParams = new Hashtable();
        boolean omegaInfoAvailable = false;
        for (String className : classSequence.keySet()) {
            Vector<LipidParameterSet> params = new Vector<LipidParameterSet>();
            Hashtable<String, Hashtable<String, QuantVO>> classQuant = quantObjects.get(className);
            for (String analyteName : analyteSequence.get(className)) {
                Hashtable analyteQuant = (Hashtable)classQuant.get(analyteName);
                for (String mod : analyteQuant.keySet()) {
                    if (!omegaInfoAvailable && !((QuantVO)analyteQuant.get(mod)).getInfoForOmegaAssignment().isEmpty()) {
                        omegaInfoAvailable = true;
                    }
                    if (!this.results_.containsKey(className) || !this.results_.get(className).containsKey(analyteName) || !this.results_.get(className).get(analyteName).containsKey(mod) || this.results_.get(className).get(analyteName).get(mod) == null) continue;
                    Hashtable<String, LipidParameterSet> hitsOfOneMod = this.results_.get(className).get(analyteName).get(mod);
                    if (LipidomicsConstants.isShotgun() == 1) {
                        for (String string : hitsOfOneMod.keySet()) {
                            params.add(hitsOfOneMod.get(string));
                        }
                        continue;
                    }
                    ArrayList<DoubleStringVO> keys = new ArrayList<DoubleStringVO>();
                    for (String string : hitsOfOneMod.keySet()) {
                        keys.add(new DoubleStringVO(string, Double.valueOf(string)));
                    }
                    Collections.sort(keys, new GeneralComparator("at.tugraz.genome.lda.vos.DoubleStringVO", "getValue", "java.lang.Double"));
                    for (DoubleStringVO doubleStringVO : keys) {
                        params.add(hitsOfOneMod.get(doubleStringVO.getKey()));
                    }
                }
            }
            sheetParams.put(className, params);
        }
        float highestArea = this.extractHighestArea();
        float cutOffValue = basePeakCutoff / 1000.0f * highestArea;
        Hashtable<String, Vector<LipidParameterSet>> correctedParams = new Hashtable<String, Vector<LipidParameterSet>>();
        for (String sheetName : sheetParams.keySet()) {
            Vector params = (Vector)sheetParams.get(sheetName);
            Vector<LipidParameterSet> corrected = new Vector<LipidParameterSet>();
            for (Object param : params) {
                boolean acceptProbe = false;
                if (LipidomicsConstants.isShotgun() == 1) {
                    acceptProbe = true;
                } else if (((CgParameterSet)param).getIsotopicProbes().size() > 0) {
                    Vector<CgProbe> newIsoProbes = new Vector<CgProbe>();
                    Vector<CgProbe> vector = new Vector<CgProbe>();
                    for (CgProbe probe : ((CgParameterSet)param).getIsotopicProbes().get(0)) {
                        if (probe.Area > cutOffValue) {
                            newIsoProbes.add(probe);
                            continue;
                        }
                        vector.add(probe);
                    }
                    if (newIsoProbes.size() == ((CgParameterSet)param).getIsotopicProbes().get(0).size()) {
                        acceptProbe = true;
                    } else if (vector.size() != ((CgParameterSet)param).getIsotopicProbes().get(0).size()) {
                        Vector<Vector<CgProbe>> vector2 = new Vector<Vector<CgProbe>>();
                        vector2.add(newIsoProbes);
                        if (((CgParameterSet)param).getIsotopicProbes().size() > 1) {
                            for (int i = 1; i != ((CgParameterSet)param).getIsotopicProbes().size(); ++i) {
                                Vector<CgProbe> newProbes = new Vector<CgProbe>();
                                for (CgProbe probe : ((CgParameterSet)param).getIsotopicProbes().get(i)) {
                                    if (!QuantificationThread.isWithinRemovedBoundaries(probe, vector)) {
                                        newProbes.add(probe);
                                        continue;
                                    }
                                    if (!QuantificationThread.isWithinRemovedBoundaries(probe, newIsoProbes)) continue;
                                    newProbes.add(probe);
                                }
                                vector2.add(newProbes);
                            }
                        }
                        ((CgParameterSet)param).setIsotopicProbes(vector2);
                        acceptProbe = true;
                    }
                }
                if (!acceptProbe) continue;
                corrected.add((LipidParameterSet)param);
            }
            correctedParams.put(sheetName, corrected);
        }
        if (omegaInfoAvailable) {
            this.applyOmegaInfo(correctedParams, classSequence, analyteSequence, quantObjects);
            LipidParameterSet.setOmegaInformationAvailable(true);
        }
        long timeMilliSeconds = System.currentTimeMillis() - this.startCalcTime_;
        System.out.println(String.format("Required time: %s minutes, %s seconds", timeMilliSeconds / 60000L, timeMilliSeconds % 60000L / 1000L));
        try {
            LipidomicsConstants constants = LipidomicsConstants.getInstance();
            constants.setRawFileName(chromFile);
            boolean isAlexTargetList = false;
            Hashtable<String, Boolean> alexTargetlistUsed = new Hashtable<String, Boolean>();
            if (Settings.useAlex()) {
                block14: for (String className : quantObjects.keySet()) {
                    Hashtable<String, Hashtable<String, QuantVO>> quantsOfClass = quantObjects.get(className);
                    for (Hashtable<String, QuantVO> hashtable : quantsOfClass.values()) {
                        for (QuantVO quant : hashtable.values()) {
                            if (!(quant instanceof TargetlistEntry)) continue;
                            isAlexTargetList = true;
                            if (!((TargetlistEntry)quant).hasAlex123FragmentsForClass() || alexTargetlistUsed.containsKey(className)) continue;
                            alexTargetlistUsed.put(className, true);
                        }
                        if (!isAlexTargetList) continue;
                        continue block14;
                    }
                }
            }
            constants.setAlexTargetlist(isAlexTargetList);
            constants.setAlexTargetlistUsed(alexTargetlistUsed);
            HydroxyEncoding[] encodings = this.getOnlyUsedHydroxyEncodings(correctedParams, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding());
            QuantificationResult quantRes = new QuantificationResult(correctedParams, constants, classSequence, encodings[0], encodings[1]);
            QuantificationResultExporter.writeResultsToExcel(resultFile, quantRes, bestMatchBySpectrumCoverage);
            if (isAlexTargetList || this.cli_) {
                String alexResultFile = new String(resultFile);
                if (alexResultFile.endsWith(".xls") || alexResultFile.endsWith(".xlsx")) {
                    alexResultFile = alexResultFile.substring(0, alexResultFile.lastIndexOf("."));
                }
                alexResultFile = alexResultFile + ".tab";
                Vector<QuantificationResult> vector = new Vector<QuantificationResult>();
                vector.add(quantRes);
                RdbOutputWriter rdbOutputWriter = new RdbOutputWriter();
                Hashtable<String, Vector<String>> analyteSeq = new Hashtable<String, Vector<String>>();
                analyteSeq.putAll(analyteSequence);
                rdbOutputWriter.write(alexResultFile, vector, classSequence, analyteSeq, quantObjects);
            }
        }
        catch (ExportException ex) {
            new WarningMessage(new JFrame(), "Error", ex.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorString_ = e.toString();
        }
    }

    private void applyOmegaInfo(Hashtable<String, Vector<LipidParameterSet>> correctedParams, LinkedHashMap<String, Integer> classSequence, LinkedHashMap<String, Vector<String>> analyteSequence, Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects) {
        for (String className : classSequence.keySet()) {
            Hashtable<String, Hashtable<String, QuantVO>> classQuant = quantObjects.get(className);
            Vector<LipidParameterSet> lipidParameterSet = correctedParams.get(className);
            for (String analyteName : analyteSequence.get(className)) {
                Hashtable<String, QuantVO> analyteQuant = classQuant.get(analyteName);
                for (String mod : analyteQuant.keySet()) {
                    Vector<DoubleBondPositionVO> infoForOmegaAssignment = analyteQuant.get(mod).getInfoForOmegaAssignment();
                    if (infoForOmegaAssignment.isEmpty()) continue;
                    try {
                        if (Integer.parseInt(RulesContainer.getAmountOfChains(StaticUtils.getRuleName(className, mod))) < 2) {
                            this.addOmegaInformationToParameterSets(lipidParameterSet, analyteName, infoForOmegaAssignment, false);
                        }
                    }
                    catch (NoRuleException | RulesException | SpectrummillParserException | IOException ex) {
                        System.out.println(ex.getMessage());
                    }
                    this.addOmegaInformationToParameterSets(lipidParameterSet, analyteName, infoForOmegaAssignment, true);
                }
            }
        }
    }

    private void addOmegaInformationToParameterSets(Vector<LipidParameterSet> lipidParameterSets, String analyteName, Vector<DoubleBondPositionVO> infoForOmegaAssignment, boolean needsMSnEvidence) {
        for (int i = 0; i < lipidParameterSets.size(); ++i) {
            LipidParameterSet param;
            if (needsMSnEvidence && (!needsMSnEvidence || !(lipidParameterSets.get(i) instanceof LipidomicsMSnSet) || lipidParameterSets.get(i).hasOmegaInformation()) || !(param = lipidParameterSets.get(i)).getNameStringWithoutRt().equals(analyteName)) continue;
            Range[] peakRanges = StaticUtils.determinePeakRanges(param);
            Range peakLimits = peakRanges[0];
            Range mediumAccuracy = peakRanges[1];
            Range highAccuracy = peakRanges[2];
            for (DoubleBondPositionVO doubleBondPositionVO : infoForOmegaAssignment) {
                float expectedRetentionTime = doubleBondPositionVO.getExpectedRetentionTime();
                if (!peakLimits.insideRange(expectedRetentionTime)) continue;
                if (mediumAccuracy.insideRange(expectedRetentionTime)) {
                    doubleBondPositionVO.setAccuracy(1);
                }
                if (highAccuracy.insideRange(expectedRetentionTime)) {
                    doubleBondPositionVO.setAccuracy(2);
                }
                if (needsMSnEvidence) {
                    String chainCombination = this.getEquivalentChainCombination((LipidomicsMSnSet)param, doubleBondPositionVO);
                    if (chainCombination == null) continue;
                    this.orderChainCombination(chainCombination, doubleBondPositionVO);
                    doubleBondPositionVO.setMolecularSpecies(chainCombination);
                    param.addOmegaInformation(doubleBondPositionVO);
                    continue;
                }
                if (needsMSnEvidence) continue;
                String doubleBondPositionsHumanReadable = doubleBondPositionVO.getDoubleBondPositionsHumanReadable();
                doubleBondPositionVO.setMolecularSpecies(StaticUtils.getHumanReadableWODoubleBondPositions(doubleBondPositionsHumanReadable));
                param.addOmegaInformation(doubleBondPositionVO);
            }
            Vector<DoubleBondPositionVO> paramOmegaInfo = param.getOmegaInformation();
            Collections.sort(paramOmegaInfo);
            Vector<DoubleBondPositionVO> highAccuracyHits = StaticUtils.getHighAccuracyDoubleBondPositions(paramOmegaInfo);
            Vector<DoubleBondPositionVO> assignedHits = StaticUtils.findUnambiguousDoubleBondPositions(highAccuracyHits);
            for (DoubleBondPositionVO assignedHit : assignedHits) {
                assignedHit.setIsAssigned(true);
            }
        }
    }

    private void orderChainCombination(String chainCombination, DoubleBondPositionVO doubleBondPositionVO) {
        String doubleBondPositionsHumanReadable = doubleBondPositionVO.getDoubleBondPositionsHumanReadable();
        if (chainCombination.contains("/")) {
            doubleBondPositionsHumanReadable = this.orderChainsAccordingToTemplate(chainCombination, doubleBondPositionsHumanReadable);
            try {
                Vector<FattyAcidVO> orderedFattyAcids = StaticUtils.decodeFAsFromHumanReadableName(doubleBondPositionsHumanReadable, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), false, null);
                doubleBondPositionVO.setChainCombination(orderedFattyAcids);
            }
            catch (LipidCombinameEncodingException ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    private String orderChainsAccordingToTemplate(String equivalentChainCombination, String doubleBondPositionsHumanReadable) {
        int i;
        String[] templateArray = StaticUtils.splitChainCombinationsAtChainSeparators(equivalentChainCombination);
        String[] doubleBondPositionsArray = StaticUtils.splitChainCombinationsAtChainSeparators(doubleBondPositionsHumanReadable);
        String[] noDoubleBondPositionsArray = new String[templateArray.length];
        String[] nakedPositionsArray = new String[templateArray.length];
        String orderedChains = null;
        for (i = 0; i < templateArray.length; ++i) {
            noDoubleBondPositionsArray[i] = StaticUtils.getHumanReadableWODoubleBondPositions(doubleBondPositionsArray[i]);
            nakedPositionsArray[i] = doubleBondPositionsArray[i].replace(noDoubleBondPositionsArray[i], "");
        }
        block1: for (i = 0; i < templateArray.length; ++i) {
            for (int j = 0; j < templateArray.length; ++j) {
                if (!noDoubleBondPositionsArray[j].equals(templateArray[i])) continue;
                if (i == 0) {
                    orderedChains = templateArray[0] + nakedPositionsArray[j];
                    continue;
                }
                orderedChains = orderedChains + "/";
                orderedChains = orderedChains + templateArray[i] + nakedPositionsArray[j];
                continue block1;
            }
        }
        return orderedChains;
    }

    private String getEquivalentChainCombination(LipidomicsMSnSet lipidomicsMsnSet, DoubleBondPositionVO doubleBondPositionVO) {
        Set<String> mSnNamesHumanReadable = lipidomicsMsnSet.getHumanReadableNameSet();
        String doubleBondPositionsHumanReadable = doubleBondPositionVO.getDoubleBondPositionsHumanReadable();
        String equivalentChainCombination = null;
        for (String mSnName : mSnNamesHumanReadable) {
            if (!StaticUtils.isChainCombinationEquivalent(doubleBondPositionsHumanReadable, mSnName)) continue;
            equivalentChainCombination = mSnName;
        }
        return equivalentChainCombination;
    }

    private float extractHighestArea() {
        float highestArea = 0.0f;
        for (Integer key : this.analyzers_.keySet()) {
            LipidomicsAnalyzer analyzer = this.analyzers_.get(key);
            if (!(analyzer.getHighestArea() > highestArea)) continue;
            highestArea = analyzer.getHighestArea();
        }
        return highestArea;
    }

    private static void checkForIsobaricSpecies(LinkedHashMap<String, Integer> classSequence, LinkedHashMap<String, Vector<String>> analyteSequence, Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects) throws RulesException, IOException, SpectrummillParserException {
        Vector<String> classes = new Vector<String>(classSequence.keySet());
        Hashtable<Integer, Vector> tenDaIsobaricClusters = new Hashtable<Integer, Vector>();
        for (int i = 0; i != classes.size(); ++i) {
            String lipidClass = classes.get(i);
            Vector<String> analytes = analyteSequence.get(lipidClass);
            Hashtable<String, Hashtable<String, QuantVO>> quantClass = quantObjects.get(lipidClass);
            for (int j = 0; j != analytes.size(); ++j) {
                String anal = analytes.get(j);
                Hashtable<String, QuantVO> quantAnal = quantClass.get(anal);
                for (String mod : quantAnal.keySet()) {
                    QuantVO quant = quantAnal.get(mod);
                    float mz = (float)quant.getAnalyteMass();
                    int clusterId = QuantificationThread.getTenDaClusterId(mz);
                    Vector vosOfCluster = new Vector();
                    if (tenDaIsobaricClusters.containsKey(clusterId)) {
                        vosOfCluster = (Vector)tenDaIsobaricClusters.get(clusterId);
                    }
                    vosOfCluster.add(quant);
                    tenDaIsobaricClusters.put(clusterId, vosOfCluster);
                }
            }
        }
        Hashtable<String, String> alreadyUsed = new Hashtable<String, String>();
        for (int i = 0; i != classes.size(); ++i) {
            String lipidClass = classes.get(i);
            Vector<String> analytes = analyteSequence.get(lipidClass);
            Hashtable<String, Hashtable<String, QuantVO>> quantClass = quantObjects.get(lipidClass);
            for (int j = 0; j != analytes.size(); ++j) {
                String anal = analytes.get(j);
                Hashtable<String, QuantVO> quantAnal = quantClass.get(anal);
                for (String mod : quantAnal.keySet()) {
                    QuantVO quant1 = quantAnal.get(mod);
                    if (quant1.isQuantifiedByOtherIsobar()) continue;
                    float tol = LipidomicsConstants.getCoarseChromMzTolerance((float)quant1.getAnalyteMass());
                    float sameTol = tol / 5.0f;
                    try {
                        RulesContainer.getAmountOfChains(StaticUtils.getRuleName(quant1.getAnalyteClass(), quant1.getModName()));
                    }
                    catch (NoRuleException nrx) {
                        if (j != 0) continue;
                        System.out.println(nrx.getMessage());
                        continue;
                    }
                    float lowerMz = (float)quant1.getAnalyteMass() - tol;
                    float upperMz = (float)quant1.getAnalyteMass() + tol;
                    float lowerSame = (float)quant1.getAnalyteMass() - sameTol;
                    float upperSame = (float)quant1.getAnalyteMass() + sameTol;
                    int clusterId = QuantificationThread.getTenDaClusterId(lowerMz);
                    Vector toCompare = new Vector();
                    if (tenDaIsobaricClusters.containsKey(clusterId)) {
                        toCompare.addAll((Collection)tenDaIsobaricClusters.get(clusterId));
                    }
                    if (clusterId != QuantificationThread.getTenDaClusterId(upperMz) && tenDaIsobaricClusters.containsKey(clusterId = QuantificationThread.getTenDaClusterId(upperMz))) {
                        toCompare.addAll((Collection)tenDaIsobaricClusters.get(clusterId));
                    }
                    for (QuantVO quant2 : toCompare) {
                        boolean sameMass;
                        if (quant1.equals(quant2) || alreadyUsed.containsKey(QuantificationThread.getUniqueQuantVOString(quant2))) continue;
                        try {
                            RulesContainer.getAmountOfChains(StaticUtils.getRuleName(quant2.getAnalyteClass(), quant2.getModName()));
                        }
                        catch (NoRuleException nrx) {
                            if (j != 0) continue;
                            System.out.println(nrx.getMessage());
                            continue;
                        }
                        float mz2 = (float)quant2.getAnalyteMass();
                        boolean similarMass = lowerMz < mz2 && mz2 < upperMz;
                        boolean bl = sameMass = lowerSame < mz2 && mz2 < upperSame;
                        if (!similarMass) continue;
                        quant1.addIsobaricSpecies(quant2);
                        quant2.addIsobaricSpecies(quant1);
                        if (!sameMass) continue;
                        quant2.setQuantifiedByOtherIsobar(true);
                    }
                    String idString = QuantificationThread.getUniqueQuantVOString(quant1);
                    alreadyUsed.put(idString, idString);
                }
            }
        }
    }

    private static String getUniqueQuantVOString(QuantVO vo) {
        return vo.getAnalyteClass() + "_;%" + vo.getIdString() + "_;%" + vo.getModName();
    }

    private static int getTenDaClusterId(float mz) {
        return Math.round(Calculator.roundFloat(mz, 0, 1));
    }

    private static Vector parseAlex123TargetList(String quantFile, float minusTime, float plusTime, int amountOfIsotopes, int isotopesMustMatch, boolean searchUnknownTime, float basePeakCutoff, float rtShift, float lowestRetTime, float highestRetTime, boolean positiveIonMode) throws IOException, SpectrummillParserException, AlexTargetlistParserException, ChemicalFormulaException, RulesException {
        File file = new File(quantFile);
        LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, TargetlistEntry>>> sortedEntries = null;
        if (file.isFile() && file.getName().endsWith(".txt")) {
            Vector<Hashtable<Integer, Vector<TargetlistEntry>>> parsedEntries = new Vector<Hashtable<Integer, Vector<TargetlistEntry>>>();
            TargetlistParser parser = new TargetlistParser(quantFile, positiveIonMode);
            parser.parse();
            parsedEntries.add(parser.getResults());
            sortedEntries = TargetlistDirParser.sortEntriesForLDA(parsedEntries);
        } else if (file.isDirectory()) {
            TargetlistDirParser dirParser = new TargetlistDirParser(quantFile, positiveIonMode);
            dirParser.parse();
            sortedEntries = dirParser.getResults();
        }
        if (sortedEntries == null || sortedEntries.size() == 0) {
            throw new AlexTargetlistParserException("There are unusable entries in your target list");
        }
        LinkedHashMap<String, Integer> classSequence = new LinkedHashMap<String, Integer>();
        Hashtable<String, Boolean> adductInsensitiveRtFilter = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> bestMatchBySpectrumCoverage = new Hashtable<String, Boolean>();
        LinkedHashMap<String, Vector<String>> analyteSequence = new LinkedHashMap<String, Vector<String>>();
        Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects = new Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>>();
        ElementConfigParser elementParser = Settings.getElementParser();
        for (String className : sortedEntries.keySet()) {
            classSequence.put(className, 1);
            LinkedHashMap<String, LinkedHashMap<String, TargetlistEntry>> classEntries = sortedEntries.get(className);
            Vector<String> analytes = new Vector<String>();
            Hashtable quantsOfClass = new Hashtable();
            for (String analyteOriginalName : classEntries.keySet()) {
                LinkedHashMap<String, TargetlistEntry> analyteEntries = classEntries.get(analyteOriginalName);
                String sideChain = "";
                int doubleBonds = -1;
                Hashtable<String, TargetlistEntry> quantsOfAnalyte = new Hashtable<String, TargetlistEntry>();
                for (String mod : analyteEntries.keySet()) {
                    TargetlistEntry entry = analyteEntries.get(mod);
                    sideChain = entry.getAnalyteName();
                    doubleBonds = entry.getDbs();
                    entry.setTimeConstraints(-1.0f, minusTime, plusTime);
                    Hashtable<String, Integer> formAnal = StaticUtils.categorizeFormula(entry.getAnalyteFormula());
                    Hashtable<String, Integer> formMod = StaticUtils.categorizeFormula(entry.getModFormula());
                    String[] formulas = QuantificationThread.getFormulasAsString(formAnal, formMod, 1);
                    String chemicalFormula = formulas[2];
                    Object[] distris = QuantificationThread.getTheoreticalIsoDistributions(elementParser, isotopesMustMatch, amountOfIsotopes, chemicalFormula);
                    Vector mustMatchProbabs = (Vector)distris[0];
                    Vector probabs = (Vector)distris[1];
                    int negativeStartValue = (Integer)distris[2];
                    entry.setDistributionValues(mustMatchProbabs, probabs, negativeStartValue);
                    quantsOfAnalyte.put(entry.getModName(), entry);
                }
                String analyteName = StaticUtils.generateLipidNameString(sideChain, (Integer)doubleBonds, -1, "");
                analytes.add(analyteName);
                quantsOfClass.put(analyteName, quantsOfAnalyte);
            }
            quantObjects.put(className, quantsOfClass);
            analyteSequence.put(className, analytes);
            adductInsensitiveRtFilter.put(className, false);
            bestMatchBySpectrumCoverage.put(className, false);
        }
        QuantificationThread.checkForIsobaricSpecies(classSequence, analyteSequence, quantObjects);
        Vector<Map<String, Serializable>> results = new Vector<Map<String, Serializable>>();
        results.add(classSequence);
        results.add(analyteSequence);
        results.add(adductInsensitiveRtFilter);
        results.add(bestMatchBySpectrumCoverage);
        results.add(quantObjects);
        return results;
    }

    private static String[] getFormulasAsString(Hashtable<String, Integer> elementalComposition, Hashtable<String, Integer> modElements, int mult) {
        Hashtable<String, Integer> chemicalFormula = new Hashtable<String, Integer>(elementalComposition);
        for (String element : modElements.keySet()) {
            int amount = modElements.get(element);
            if (chemicalFormula.containsKey(element)) {
                amount += chemicalFormula.get(element).intValue();
            }
            chemicalFormula.put(element, amount);
        }
        String[] formulas = new String[]{StaticUtils.getFormulaInHillNotation(elementalComposition, true), StaticUtils.getFormulaInHillNotation(modElements, true), StaticUtils.getFormulaInHillNotation(chemicalFormula, true)};
        return formulas;
    }

    private static Object[] getTheoreticalIsoDistributions(ElementConfigParser elementParser, int isotopesMustMatch, int amountOfIsotopes, String chemicalFormula) throws SpectrummillParserException {
        boolean negativeDistribution = false;
        Vector<Double> probabs = new Vector<Double>();
        if (amountOfIsotopes < isotopesMustMatch) {
            amountOfIsotopes = isotopesMustMatch;
        }
        if (amountOfIsotopes > 0) {
            Vector<Double> negDistri;
            Vector<Vector<Double>> bothDistris = elementParser.calculateChemicalFormulaIntensityDistribution(chemicalFormula, amountOfIsotopes + 1, false);
            probabs = bothDistris.get(0);
            if (bothDistris.size() > 1 && StaticUtils.useNegativeDistribution(probabs, negDistri = bothDistris.get(1))) {
                probabs = negDistri;
                negativeDistribution = true;
            }
        } else {
            probabs.add(1.0);
        }
        Vector<Double> mustMatchProbabs = new Vector();
        if (isotopesMustMatch > 0) {
            if (amountOfIsotopes == isotopesMustMatch) {
                mustMatchProbabs = new Vector(probabs);
            } else {
                Vector<Double> negDistri;
                Vector<Vector<Double>> bothDistris = elementParser.calculateChemicalFormulaIntensityDistribution(chemicalFormula, isotopesMustMatch + 1, false);
                mustMatchProbabs = bothDistris.get(0);
                if (bothDistris.size() > 1 && StaticUtils.useNegativeDistribution(mustMatchProbabs, negDistri = bothDistris.get(1))) {
                    mustMatchProbabs = negDistri;
                    negativeDistribution = true;
                }
            }
        }
        int negativeStartValue = 0;
        if (negativeDistribution) {
            negativeStartValue = mustMatchProbabs.size() * -1 + 1;
        }
        Object[] distris = new Object[]{mustMatchProbabs, probabs, negativeStartValue};
        return distris;
    }

    private HydroxyEncoding[] getOnlyUsedHydroxyEncodings(Hashtable<String, Vector<LipidParameterSet>> correctedParams, HydroxyEncoding faHydroxyEncoding, HydroxyEncoding lcbHydroxyEncoding) {
        Hashtable<String, Short> usedFaEncodings = new Hashtable<String, Short>();
        Hashtable<String, Short> usedLcbEncodings = new Hashtable<String, Short>();
        for (Vector<LipidParameterSet> params : correctedParams.values()) {
            for (LipidParameterSet param : params) {
                LipidomicsMSnSet msn;
                if (!(param instanceof LipidomicsMSnSet) || (msn = (LipidomicsMSnSet)param).getStatus() < 3) continue;
                for (FattyAcidVO fa : msn.getInvolvedFAs().values()) {
                    if (fa.getOhNumber() < 0) continue;
                    Short oh = (short)fa.getOhNumber();
                    if (fa.getChainType() < 3) {
                        if (usedFaEncodings.contains(oh)) continue;
                        try {
                            usedFaEncodings.put(faHydroxyEncoding.getEncodedPrefix(oh), oh);
                        }
                        catch (HydroxylationEncodingException hydroxylationEncodingException) {}
                        continue;
                    }
                    if (fa.getChainType() != 3 || usedLcbEncodings.contains(oh)) continue;
                    try {
                        usedLcbEncodings.put(lcbHydroxyEncoding.getEncodedPrefix(oh), oh);
                    }
                    catch (HydroxylationEncodingException hydroxylationEncodingException) {}
                }
            }
        }
        HydroxyEncoding[] encodings = new HydroxyEncoding[]{new HydroxyEncoding(usedFaEncodings), new HydroxyEncoding(usedLcbEncodings)};
        return encodings;
    }

    private Hashtable<String, Hashtable<QuantVO, LipidParameterSet>> groupHitsWithSameRt(Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> hitsAccordingToQuant) {
        Hashtable<String, Hashtable<QuantVO, LipidParameterSet>> sameRt = new Hashtable<String, Hashtable<QuantVO, LipidParameterSet>>();
        for (QuantVO quant : hitsAccordingToQuant.keySet()) {
            for (String rt : hitsAccordingToQuant.get(quant).keySet()) {
                Hashtable<QuantVO, LipidParameterSet> hash = new Hashtable<QuantVO, LipidParameterSet>();
                if (sameRt.containsKey(rt)) {
                    hash = sameRt.get(rt);
                }
                hash.put(quant, hitsAccordingToQuant.get(quant).get(rt));
                sameRt.put(rt, hash);
            }
        }
        return sameRt;
    }

    public static boolean hasRtInfo(Hashtable<String, Vector<LipidParameterSet>> sheetParams) {
        boolean hasRt = true;
        for (Vector<LipidParameterSet> params : sheetParams.values()) {
            boolean hasEntry = false;
            Iterator<LipidParameterSet> iterator = params.iterator();
            if (iterator.hasNext()) {
                LipidParameterSet param = iterator.next();
                hasRt = param.getRt() != null && param.getRt().length() > 0;
                hasEntry = true;
            }
            if (!hasEntry) continue;
            break;
        }
        return hasRt;
    }

    private class ThreadSupervisor
    extends TimerTask {
        private LinkedHashMap<String, Integer> classSequence_;
        private LinkedHashMap<String, Vector<String>> analyteSequence_;
        private Hashtable<String, Boolean> adductInsensitiveRtFilter_;
        private Hashtable<String, Boolean> bestMatchBySpectrumCoverage_;
        private Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects_;
        private float bpCutoff_;
        private String rsFile_;

        protected ThreadSupervisor(Vector excelContent, float basePeakCutoff, String resultFile) {
            QuantificationThread.this.currentLipidCount_ = 0;
            this.classSequence_ = (LinkedHashMap)excelContent.get(0);
            this.analyteSequence_ = (LinkedHashMap)excelContent.get(1);
            this.adductInsensitiveRtFilter_ = (Hashtable)excelContent.get(2);
            this.bestMatchBySpectrumCoverage_ = (Hashtable)excelContent.get(3);
            this.quantObjects_ = (Hashtable)excelContent.get(4);
            this.bpCutoff_ = basePeakCutoff;
            this.rsFile_ = resultFile;
            this.initThreadHashes();
        }

        @Override
        public void run() {
            block3: {
                try {
                    if (QuantificationThread.this.finished_) break block3;
                    QuantificationThread.this.handleTimerEvent(this.classSequence_, this.analyteSequence_, this.adductInsensitiveRtFilter_, this.bestMatchBySpectrumCoverage_, this.quantObjects_, this.bpCutoff_, this.rsFile_, QuantificationThread.this.chromFileName_);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    QuantificationThread.this.errorString_ = ex.toString();
                    QuantificationThread.this.finished_ = true;
                    for (Integer analyzer : QuantificationThread.this.analyzers_.keySet()) {
                        if (!((LipidomicsAnalyzer)QuantificationThread.this.analyzers_.get(analyzer)).getUseCuda()) continue;
                        ((LipidomicsAnalyzer)QuantificationThread.this.analyzers_.get(analyzer)).getSavGolJNI().Frees();
                    }
                }
            }
        }

        private void initThreadHashes() {
            QuantificationThread.this.quantStatus_ = new Hashtable();
            QuantificationThread.this.results_ = new Hashtable();
            QuantificationThread.this.ms2Removed_ = new Hashtable();
            QuantificationThread.this.unsplittedPeaks_ = new Hashtable();
            QuantificationThread.this.threads_ = new Hashtable();
            QuantificationThread.this.onlyMS1DataPresent_ = new Hashtable();
            for (String className : this.classSequence_.keySet()) {
                Hashtable<String, Hashtable<String, QuantVO>> classQuant = this.quantObjects_.get(className);
                Hashtable statusClass = new Hashtable();
                Hashtable resultsClass = new Hashtable();
                Hashtable resultsNeg = new Hashtable();
                Hashtable unsplitted = new Hashtable();
                for (String analyteName : this.analyteSequence_.get(className)) {
                    Hashtable<String, QuantVO> analyteQuant = classQuant.get(analyteName);
                    Hashtable<String, Integer> status = new Hashtable<String, Integer>();
                    for (String mod : analyteQuant.keySet()) {
                        if (analyteQuant.get(mod).isQuantifiedByOtherIsobar()) {
                            status.put(mod, 2);
                            continue;
                        }
                        status.put(mod, 0);
                    }
                    statusClass.put(analyteName, status);
                    resultsClass.put(analyteName, new Hashtable());
                    resultsNeg.put(analyteName, new Hashtable());
                    unsplitted.put(analyteName, new Hashtable());
                }
                QuantificationThread.this.quantStatus_.put(className, statusClass);
                QuantificationThread.this.results_.put(className, resultsClass);
                QuantificationThread.this.ms2Removed_.put(className, resultsNeg);
                QuantificationThread.this.unsplittedPeaks_.put(className, unsplitted);
            }
        }
    }
}

