/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.SettingsException;
import at.tugraz.genome.lda.msn.RulesContainer;
import at.tugraz.genome.lda.msn.hydroxy.parser.HydroxyEncoding;
import at.tugraz.genome.lda.quantification.SavGolJNI;
import at.tugraz.genome.lda.swing.RuleDefinitionInterface;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.xml.ModConfigParser;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.parser.spectrummill.ElementConfigParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class Settings {
    private static Settings instance_ = null;
    public static final String VERSION = "2.10.0_1";
    public static final String SETTINGS_FILE = ".settings";
    public static final String EMPTY_ENTRY_FOR_QUANT_ANAL_NOT_FOUND = "EmptyEntriesForQuantAnalNotFound";
    public static final boolean SHOW_OMEGA_TOOLS = false;
    private static String operatingSystem_;
    private static String ldaUserHomePath_;
    private static String readWPath_;
    private static String msConvertPath_;
    private static String massWolfPath_;
    private static String massPlusPlusPath_;
    private static String elementConfigPath_;
    private static String modConfigPath_;
    private static ElementConfigParser elementParser_;
    private static ModConfigParser modParser_;
    private static String alexIsotopeLookup_;
    private static boolean overviewExcelWorkbook_;
    private static boolean overviewExcelMass_;
    private static boolean overviewExcelIsotope_;
    private static boolean mergeMultipleMSMSFiles_;
    private static boolean skipLastMzXML_;
    private static boolean useCuda_;
    private static boolean useAlex_;
    private static boolean emptyEntriesForQuantAnalNotFound_;
    private static boolean alwaysEditOmega_;
    private static String PROPERTY_ALWAYS_EDIT_OMEGA;
    private static Hashtable<String, String> alexIsoLookup_;
    private static String isDefaultInput_;
    private static String esDefaultInput_;
    private static String fragmentationSelection1_;
    private static String fragmentationSelection2_;
    private static float msn3DDisplayTolerance_;
    public static final String PROPERTIES_DIRECTORY = "properties";
    public static final String PROPERTYFILE_PREFIX = "LipidDataAnalyzer_";
    public static final String PROPERTYFILE_SUFFIX = "properties";
    public static final String FRAG_SELECTION_NONE = "none";
    public static final String FRAG_SELECTION_NO_INTENSITY = "noIntensity";
    public static final String FRAG_SETTINGS_FILE = ".selected";
    public static final short OMEGA_PEAK_STRONGEST = 0;
    public static final short OMEGA_PEAK_RTDIFF = 1;
    private LinkedHashMap<String, File> propertiesFiles_;
    private static String faHydroxyEncodingPath_;
    private static HydroxyEncoding faHydroxyEncoding_;
    private static String lcbHydroxyEncodingPath_;
    private static HydroxyEncoding lcbHydroxyEncoding_;

    private static Settings getInstance() {
        return Settings.getInstance(false);
    }

    private static Settings getInstance(boolean ignoreMissingSettingsFile) {
        if (instance_ == null) {
            instance_ = new Settings();
            operatingSystem_ = System.getProperty("os.name");
            ldaUserHomePath_ = System.getProperty("user.home") + File.separator + ".lda";
            Settings.readSettingsFile(ignoreMissingSettingsFile);
            Settings.readFragSelectedFile();
            Settings.instance_.propertiesFiles_ = instance_.getPropertiesFiles(ignoreMissingSettingsFile);
        }
        return instance_;
    }

    private static void readSettingsFile(boolean ignoreMissingSettingsFile) {
        try {
            File alexFile;
            String overviewExcelIsotopeString;
            String overviewExcelMassString;
            File file = new File(SETTINGS_FILE);
            useAlex_ = false;
            if (!file.exists() && ignoreMissingSettingsFile) {
                return;
            }
            FileInputStream inNew = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(inNew);
            inNew.close();
            readWPath_ = properties.getProperty("ReadWPath", null);
            msConvertPath_ = properties.getProperty("MsconvertPath", null);
            massWolfPath_ = properties.getProperty("MassWolfPath", null);
            massPlusPlusPath_ = properties.getProperty("MassPPPath", null);
            elementConfigPath_ = properties.getProperty("ElementConfig", null);
            try {
                elementParser_ = new ElementConfigParser(elementConfigPath_);
                elementParser_.parse();
            }
            catch (SpectrummillParserException e) {
                e.printStackTrace();
                new WarningMessage(new JFrame(), "Error", "There is something wrong with the elementconfig.xml: " + e.getMessage());
            }
            modConfigPath_ = properties.getProperty("ModConfig", null);
            modParser_ = new ModConfigParser(modConfigPath_);
            modParser_.parse();
            alexIsotopeLookup_ = properties.getProperty("AlexIsotopeLookup", "alex123_isotopeLookup.txt");
            String overviewExcelString = properties.getProperty("OverviewExcelWorkbook", null);
            if (overviewExcelString != null && (overviewExcelString.equalsIgnoreCase("true") || overviewExcelString.equalsIgnoreCase("yes"))) {
                overviewExcelWorkbook_ = true;
            }
            if ((overviewExcelMassString = properties.getProperty("OverviewExcelMass", null)) != null && (overviewExcelMassString.equalsIgnoreCase("true") || overviewExcelMassString.equalsIgnoreCase("yes"))) {
                overviewExcelMass_ = true;
            }
            if ((overviewExcelIsotopeString = properties.getProperty("OverviewIsotopicValues", null)) != null && (overviewExcelIsotopeString.equalsIgnoreCase("true") || overviewExcelIsotopeString.equalsIgnoreCase("yes"))) {
                overviewExcelIsotope_ = true;
            }
            mergeMultipleMSMSFiles_ = false;
            String mergeMultipleMSMSFilesString = properties.getProperty("MergeMultipleMSMSFiles", null);
            if (mergeMultipleMSMSFilesString != null && (mergeMultipleMSMSFilesString.equalsIgnoreCase("true") || mergeMultipleMSMSFilesString.equalsIgnoreCase("yes"))) {
                mergeMultipleMSMSFiles_ = true;
            }
            skipLastMzXML_ = false;
            String skipLastMzXMLString = properties.getProperty("SkipLastMzXML", null);
            if (skipLastMzXMLString != null && (skipLastMzXMLString.equalsIgnoreCase("true") || skipLastMzXMLString.equalsIgnoreCase("yes"))) {
                skipLastMzXML_ = true;
            }
            useCuda_ = false;
            String useCudaString = properties.getProperty("useCuda", null);
            if (useCudaString != null && (useCudaString.equalsIgnoreCase("true") || useCudaString.equalsIgnoreCase("yes"))) {
                useCuda_ = true;
            }
            useAlex_ = false;
            String useAlexString = properties.getProperty("Alex123", null);
            if (useAlexString != null && (useAlexString.equalsIgnoreCase("true") || useAlexString.equalsIgnoreCase("yes"))) {
                useAlex_ = true;
            }
            emptyEntriesForQuantAnalNotFound_ = false;
            String emptyEntriesForQuantAnalNotFoundString = properties.getProperty(EMPTY_ENTRY_FOR_QUANT_ANAL_NOT_FOUND, null);
            if (emptyEntriesForQuantAnalNotFoundString != null && (emptyEntriesForQuantAnalNotFoundString.equalsIgnoreCase("true") || emptyEntriesForQuantAnalNotFoundString.equalsIgnoreCase("yes"))) {
                emptyEntriesForQuantAnalNotFound_ = true;
            }
            alwaysEditOmega_ = false;
            String property = properties.getProperty(PROPERTY_ALWAYS_EDIT_OMEGA, null);
            if (property != null && (property.equalsIgnoreCase("true") || property.equalsIgnoreCase("yes"))) {
                alwaysEditOmega_ = true;
            }
            isDefaultInput_ = properties.getProperty("ISDefaultInput", "IS");
            esDefaultInput_ = properties.getProperty("ESDefaultInput", "Ex-IS");
            msn3DDisplayTolerance_ = 60.0f;
            String msn3DDisplayToleranceString = properties.getProperty("MSn3DDisplayTimeWindow", "1");
            if (msn3DDisplayToleranceString != null) {
                try {
                    msn3DDisplayTolerance_ = Float.parseFloat(msn3DDisplayToleranceString) * 60.0f;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            alexIsoLookup_ = new Hashtable();
            if (useAlex_ && (alexFile = new File(Settings.getAlexIsotopeLookup())).exists()) {
                Properties alexProperties = new Properties();
                FileInputStream alexNew = new FileInputStream(alexFile);
                alexProperties.load(alexNew);
                alexNew.close();
                for (Object key : alexProperties.keySet()) {
                    alexIsoLookup_.put((String)key, alexProperties.getProperty((String)key));
                }
            }
            if ((faHydroxyEncodingPath_ = properties.getProperty("FaHydroxyEncodingPath", "faHydroxylationEncoding.txt")) == null || faHydroxyEncodingPath_.length() == 0) {
                throw new Exception("In order to work, LDA must have a lookup file for the encoding of the FA hydroxylation sites. Please specify it in the \"FahydroxyEncodingPath\" settings of the .settings file");
            }
            File hydroxyEncoding = new File(faHydroxyEncodingPath_);
            if (!hydroxyEncoding.exists()) {
                throw new Exception("The file \"" + faHydroxyEncodingPath_ + "\" (specified in the FaHydroxyEncodingPath of the .settings file) does not exist!");
            }
            faHydroxyEncoding_ = new HydroxyEncoding(faHydroxyEncodingPath_);
            lcbHydroxyEncodingPath_ = properties.getProperty("LcbHydroxyEncodingPath", "lcbHydroxylationEncoding.txt");
            if (lcbHydroxyEncodingPath_ == null || lcbHydroxyEncodingPath_.length() == 0) {
                throw new Exception("In order to work, LDA must have a lookup file for the encoding of the LCB hydroxylation sites. Please specify it in the \"LCBHydroxyEncodingPath\" settings of the .settings file");
            }
            hydroxyEncoding = new File(lcbHydroxyEncodingPath_);
            if (!hydroxyEncoding.exists()) {
                throw new Exception("The file \"" + lcbHydroxyEncodingPath_ + "\" (specified in the LcbHydroxyEncodingPath of the .settings file) does not exist!");
            }
            lcbHydroxyEncoding_ = new HydroxyEncoding(lcbHydroxyEncodingPath_);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String getSettingsFilePath() {
        return RulesContainer.currentRulesDir_ + "/" + FRAG_SETTINGS_FILE;
    }

    private static void readFragSelectedFile() {
        fragmentationSelection1_ = FRAG_SELECTION_NONE;
        fragmentationSelection2_ = FRAG_SELECTION_NONE;
        File file = new File(Settings.getSettingsFilePath());
        if (!file.exists() || !file.isFile()) {
            return;
        }
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(new FileReader(file));
            boolean firstSet = false;
            while ((line = reader.readLine()) != null) {
                if (line == null || line.trim().length() == 0) continue;
                if (firstSet) {
                    fragmentationSelection2_ = line.trim();
                    break;
                }
                fragmentationSelection1_ = line.trim();
                firstSet = true;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void rereadSettings() {
        Settings.getInstance();
        Settings.readSettingsFile(false);
        Settings.readFragSelectedFile();
    }

    public static String getOperatingSystem() {
        Settings.getInstance();
        return operatingSystem_;
    }

    public static String getReadWPath() {
        Settings.getInstance();
        return readWPath_;
    }

    public static String getMsConvertPath() {
        Settings.getInstance();
        return msConvertPath_;
    }

    public static String getMassWolfPath() {
        Settings.getInstance();
        return massWolfPath_;
    }

    public static String getMassPlusPlusPath() {
        Settings.getInstance();
        return massPlusPlusPath_;
    }

    public static String getElementConfigPath() {
        Settings.getInstance();
        return elementConfigPath_;
    }

    public static ElementConfigParser getElementParser() {
        Settings.getInstance();
        return elementParser_;
    }

    public static ModConfigParser getModParser() {
        Settings.getInstance();
        return modParser_;
    }

    public static String getAlexIsotopeLookup() {
        Settings.getInstance();
        return alexIsotopeLookup_;
    }

    public static boolean isOverviewInExcelDesired() {
        Settings.getInstance();
        return overviewExcelWorkbook_;
    }

    public static boolean isMassInOverviewExcelDesired() {
        Settings.getInstance();
        return overviewExcelMass_;
    }

    public static boolean isIsotopeInOverviewExcelDesired() {
        Settings.getInstance();
        return overviewExcelIsotope_;
    }

    public static boolean mergeMultipleMSMSFiles() {
        Settings.getInstance();
        return mergeMultipleMSMSFiles_;
    }

    public static boolean skipLastMzXML() {
        Settings.getInstance();
        return skipLastMzXML_;
    }

    public static boolean useCuda() {
        Settings.getInstance();
        if (useCuda_) {
            useCuda_ = Settings.hasCuda();
        }
        return useCuda_;
    }

    public static boolean hasCuda() {
        boolean cudaCapable;
        SavGolJNI sav_gol_jni = null;
        try {
            sav_gol_jni = new SavGolJNI();
            cudaCapable = sav_gol_jni.cudaCapableDeviceNative();
        }
        catch (UnsatisfiedLinkError e) {
            cudaCapable = false;
        }
        if (!cudaCapable) {
            new WarningMessage(new JFrame(), "Error", "Your GPU is not ready for CUDA! The calculation will continue without GPU assistance.");
        }
        return cudaCapable;
    }

    public static boolean useAlex() {
        Settings.getInstance(true);
        return useAlex_;
    }

    public static boolean emptyEntriesForQuantAnalNotFound() {
        Settings.getInstance();
        return emptyEntriesForQuantAnalNotFound_;
    }

    public static boolean getAlwaysEditOmega() {
        Settings.getInstance();
        return alwaysEditOmega_;
    }

    public static String getInternalStandardDefaultInput() {
        Settings.getInstance();
        return isDefaultInput_;
    }

    public static String getExternalStandardDefaultInput() {
        Settings.getInstance();
        return esDefaultInput_;
    }

    public static String getLdaUserHomePath() {
        Settings.getInstance();
        return ldaUserHomePath_;
    }

    public static String getLicensePath() {
        Settings.getInstance();
        return Settings.getLdaUserHomePath() + File.separator + "License";
    }

    public static boolean isWindows() {
        return Settings.getOperatingSystem().startsWith("Windows");
    }

    public static boolean isOSMac() {
        return Settings.getOperatingSystem().startsWith("Mac OS");
    }

    public static boolean isOSMacAndJavaLookAndFeel() {
        Settings.getInstance();
        return Settings.getOperatingSystem().startsWith("Mac OS") && UIManager.getLookAndFeel().getName().equalsIgnoreCase("Metal");
    }

    public static String getFragmentationSelection1() {
        Settings.getInstance();
        return fragmentationSelection1_;
    }

    public static String getFragmentationSelection2() {
        Settings.getInstance();
        return fragmentationSelection2_;
    }

    public static String getFragmentSettingsString() {
        Settings.getInstance();
        String settingsString = "";
        if (fragmentationSelection1_ != null && fragmentationSelection1_.length() > 0 && !fragmentationSelection1_.equalsIgnoreCase(FRAG_SELECTION_NONE)) {
            settingsString = settingsString + fragmentationSelection1_;
            if (!fragmentationSelection1_.equalsIgnoreCase(FRAG_SELECTION_NO_INTENSITY) && fragmentationSelection2_ != null && fragmentationSelection2_.length() > 0 && !fragmentationSelection2_.equalsIgnoreCase(FRAG_SELECTION_NONE)) {
                settingsString = settingsString + " " + fragmentationSelection2_;
            }
        }
        return settingsString;
    }

    public static float getMsn3DDisplayTolerance() {
        Settings.getInstance();
        return msn3DDisplayTolerance_;
    }

    public static Hashtable<String, String> getAlexIsoLookup() {
        Settings.getInstance();
        return alexIsoLookup_;
    }

    public static void applySettings(String machine) throws SettingsException {
        if (!Settings.instance_.propertiesFiles_.containsKey(machine)) {
            throw new SettingsException("There are no settings for the machine \"" + machine + "\"!");
        }
        LipidomicsConstants.switchToOtherConfFile(Settings.instance_.propertiesFiles_.get(machine));
    }

    public static void saveMachineSettings(String machine) throws SettingsException {
        if (instance_ == null) {
            Settings.getInstance();
        }
        if (Settings.instance_.propertiesFiles_.containsKey(machine)) {
            try {
                LipidomicsConstants.switchToOtherDefaultConfFile(Settings.instance_.propertiesFiles_.get(machine));
            }
            catch (IOException iox) {
                throw new SettingsException(iox);
            }
        } else {
            throw new SettingsException("There are no settings for the machine \"" + machine + "\"!");
        }
    }

    public static Set<String> getPropertyFileNames() {
        if (instance_ == null) {
            Settings.getInstance();
        }
        return Settings.instance_.propertiesFiles_.keySet();
    }

    public static Vector<String> getFragmentationSettings(String currentMSMachine) {
        if (instance_ == null) {
            Settings.getInstance();
        }
        Vector<String> fragSettings = new Vector<String>();
        fragSettings.add(FRAG_SELECTION_NONE);
        fragSettings.add(FRAG_SELECTION_NO_INTENSITY);
        List<String> fragOptions = Settings.getFragmentationOptions(currentMSMachine);
        for (String option : fragOptions) {
            fragSettings.add(option);
        }
        return fragSettings;
    }

    public static HydroxyEncoding getFaHydroxyEncoding() {
        Settings.getInstance();
        return faHydroxyEncoding_;
    }

    public static HydroxyEncoding getLcbHydroxyEncoding() {
        Settings.getInstance();
        return lcbHydroxyEncoding_;
    }

    private static List<String> getFragmentationOptions(String currentMSMachine) {
        File[] files;
        ArrayList<String> fragOptions = new ArrayList<String>();
        File fragDir = new File("fragRules");
        for (File file : files = fragDir.listFiles()) {
            if (!file.isDirectory() || !file.getName().equalsIgnoreCase(currentMSMachine)) continue;
            for (File optionDir : file.listFiles()) {
                if (!optionDir.isDirectory()) continue;
                fragOptions.add(optionDir.getName());
            }
        }
        Collections.sort(fragOptions);
        return fragOptions;
    }

    private LinkedHashMap<String, File> getPropertiesFiles(boolean ignoreMissingSettingsFile) {
        File propDir = new File("properties");
        if (!propDir.exists() && ignoreMissingSettingsFile) {
            return null;
        }
        File[] files = propDir.listFiles();
        LinkedHashMap<String, File> propFiles = new LinkedHashMap<String, File>();
        for (int i = 0; i != files.length; ++i) {
            String fileName = StaticUtils.extractFileName(files[i].getAbsolutePath());
            if (fileName.length() <= PROPERTYFILE_PREFIX.length() + "properties".length() + 1 || !fileName.startsWith(PROPERTYFILE_PREFIX) || !fileName.endsWith(".properties")) continue;
            String machineName = fileName.substring(PROPERTYFILE_PREFIX.length(), fileName.indexOf(".properties"));
            propFiles.put(machineName, files[i]);
        }
        return propFiles;
    }

    public static void applyFragmentationSettings(String settings1, String settings2) throws SettingsException {
        RulesContainer.useInterimRulesDir();
        Settings.copyFragmentationSettings(settings1, settings2);
        Settings.readFragSelectedFile();
    }

    public static void saveFragmentationSettings(String settings1, String settings2) throws SettingsException {
        RulesContainer.usePermanentRulesDir();
        Settings.copyFragmentationSettings(settings1, settings2);
        Settings.readFragSelectedFile();
    }

    private static void copyFragmentationSettings(String settings1, String settings2) throws SettingsException {
        String selectedFileContents = "";
        if (settings1 == null || settings1.length() == 0) {
            return;
        }
        Settings.removeOldRules();
        if (!settings1.equalsIgnoreCase(FRAG_SELECTION_NONE)) {
            selectedFileContents = selectedFileContents + settings1;
        }
        boolean settings2Selected = false;
        if (settings2 != null && settings2.length() > 0 && !settings2.equalsIgnoreCase(FRAG_SELECTION_NONE)) {
            settings2Selected = true;
        }
        try {
            if (!settings1.equalsIgnoreCase(FRAG_SELECTION_NONE) && !settings1.equalsIgnoreCase(FRAG_SELECTION_NO_INTENSITY) && settings2Selected) {
                selectedFileContents = selectedFileContents + "\n" + settings2;
                Settings.copyFragSettingsFiles(Settings.getFragSettingsDirectory(settings2), RulesContainer.currentRulesDir_);
            }
            if (!settings1.equalsIgnoreCase(FRAG_SELECTION_NONE)) {
                Settings.copyFragSettingsFiles(Settings.getFragSettingsDirectory(settings1), RulesContainer.currentRulesDir_);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(Settings.getSettingsFilePath()));
                ((OutputStream)out).write(selectedFileContents.getBytes());
                ((OutputStream)out).close();
            }
        }
        catch (IOException iox) {
            throw new SettingsException(iox);
        }
    }

    private static String getFragSettingsDirectory(String fragSettings) {
        String dir = "fragRules/";
        if (!fragSettings.equalsIgnoreCase(FRAG_SELECTION_NO_INTENSITY)) {
            dir = dir + LipidomicsConstants.getCurrentMSMachine() + "/";
        }
        dir = dir + fragSettings;
        return dir;
    }

    private static void copyFragSettingsFiles(String fromPath, String toPath) throws SettingsException, IOException {
        File fromDir = new File(fromPath);
        File toDir = new File(toPath);
        boolean settingsFileFound = false;
        if (!fromDir.exists()) {
            throw new SettingsException("The path \"" + fromPath + "\" does not exist!");
        }
        if (!toDir.exists()) {
            throw new SettingsException("The path \"" + toPath + "\" does not exist!");
        }
        if (!fromDir.isDirectory()) {
            throw new SettingsException("The path \"" + fromPath + "\" does not point to a directory!");
        }
        if (!toDir.isDirectory()) {
            throw new SettingsException("The path \"" + toPath + "\" does not point to a directory!");
        }
        for (File file : fromDir.listFiles()) {
            int len;
            if (!file.isFile() || !file.getName().endsWith(".frag.txt")) continue;
            settingsFileFound = true;
            String outPath = Settings.getActiveRulesFilename(file.getName());
            int chunkSize = 1024;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outPath));
            byte[] buffer = new byte[chunkSize];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        if (!settingsFileFound) {
            new WarningMessage(new JFrame(), "Warning", String.format("<html><body>Your selected Fragmentation Rule Folder '%s' does not contain any fragmentation files! <br>Defaulting to '%s' <br>Make sure your selected folder contains files with the required suffix '%s'</body></html>", fromPath, FRAG_SELECTION_NONE, ".frag.txt"));
        }
        RulesContainer.clearCache();
        RuleDefinitionInterface.clearCacheDir();
        RulesContainer.clearCache("cache");
    }

    private static String getActiveRulesFilename(String fileName) {
        return RulesContainer.currentRulesDir_ + "/" + fileName;
    }

    private static void removeOldRules() {
        File rulesDir = new File(RulesContainer.currentRulesDir_);
        for (File file : rulesDir.listFiles()) {
            if (!file.isFile() || !file.getName().equalsIgnoreCase(FRAG_SETTINGS_FILE) && !file.getName().endsWith(".frag.txt")) continue;
            file.delete();
        }
    }

    static {
        PROPERTY_ALWAYS_EDIT_OMEGA = "AlwaysEditOmega";
        alexIsoLookup_ = new Hashtable();
    }
}

