/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.alex123;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.alex123.vos.TargetlistEntry;
import at.tugraz.genome.lda.alex123.vos.TargetlistFloatStringVO;
import at.tugraz.genome.lda.analysis.ComparativeAnalysis;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.ExcelInputFileException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.RdbWriterException;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.parser.LDAResultReader;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.QuantificationResult;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.QuantVO;
import at.tugraz.genome.lda.vos.ResultAreaVO;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.maspectras.quantification.Probe3D;
import at.tugraz.genome.maspectras.utils.Calculator;
import at.tugraz.genome.voutils.GeneralComparator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Vector;

public class RdbOutputWriter {
    public static final String FILENAME_COLUMN = "RAW_ID";
    public static final String MACHINE_COLUMN = "Machine";
    public static final String DETECTOR_COLUMN = "Detector";
    public static final String POLARITY_COLUMN = "Polarity";
    public static final String EVIDENCE_LEVEL_COLUMN = "MS evidence level";
    public static final String SPECIES_COLUMN = "Lipid species";
    public static final String RT_GROUPING_COLUMN = "RT group";
    public static final String MOLECULAR_SPECIES_COLUMN = "Molecular lipid species";
    public static final String MOLECULAR_SPECIES_COLUMN_RANK = "Mol. species rank";
    public static final String LIPID_CLASS_COLUMN = "Lipid class";
    public static final String LEVEL_PREFIX = "MS";
    public static final String FRAGMENT_NAMES_LEVEL_COLUMN_PART = " Fragment names";
    public static final String FRAGMENT_MZ_LEVEL_COLUMN_PART = " Fragment m/z";
    public static final String NUMBER_MS_SCANS_PREFIX = "#";
    public static final String NUMBER_MS_SCANS_SUFFIX = " scans";
    public static final String MSN_RTS_COLUMN_PART = " RTs";
    public static final String PRECURSOR_COLUMN_PART = " precursor m/z";
    public static final String ACTIVATION_COLUMN_PART = " activation";
    public static final String RT_COLUMN = "Retention time";
    public static final String ISOTOPES_COLUMN = "Isotope clusters";
    public static final String LOWER_VALLEY_COLUMN = "Lower valley";
    public static final String UPPER_VALLEY_COLUMN = "Upper valley";
    public static final String LOWER_VALLEY_10_COLUMN = "Lower valley 10%";
    public static final String UPPER_VALLEY_10_COLUMN = "Upper valley 10%";
    public static final String LOWER_VALLEY_50_COLUMN = "Lower valley 50%";
    public static final String UPPER_VALLEY_50_COLUMN = "Upper valley 50%";
    public static final String LOW_MZ_COLUMN = "Low m/z";
    public static final String UP_MZ_COLUMN = "Up m/z";
    public static final String LOW_MZ_10_COLUMN = "Low m/z 10%";
    public static final String UP_MZ_10_COLUMN = "Up m/z 10%";
    public static final String LOW_MZ_50_COLUMN = "Low m/z 50%";
    public static final String UP_MZ_50_COLUMN = "Up m/z 50%";
    public static final String PEAK_AREA_COLUMN = "Peak area (total)";
    public static final String ISO_PEAK_AREA_COLUMN_PART = "Peak area M";
    public static final String INTENSITY_MAX_COLUMN_PART = "Max intensity";
    public static final String TARGET_MZ_COLUMN = "Target m/z";
    public static final String MEASURED_MZ_COLUMN = "Measured m/z";
    public static final String MZ_CORRECTION_COLUMN = "Applied m/z correction";
    public static final String MZ_CORRECTED_COLUMN = "Corrected measured m/z";
    public static final String MZ_OFFSET_COLUMN = "m/z offset";
    public static final String PPM_ERROR_COLUMN = "ppm error";
    public static final String ADDUCT_COLUMN = "Adduct";
    public static final String LIPID_ID_COLUMN = "Lipid ID";
    public static final String LIPID_CATEGORY_COLUMN = "Lipid category";
    public static final String CONFLICTS_COLUMN = "Conflicts";
    public static final String CHARGE_COLUMN = "Charge";
    public static final String C_INDEX_COLUMN = "C index of lipid species";
    public static final String DB_INDEX_COLUMN = "DB index of lipid species";
    public static final String OH_INDEX_COLUMN = "OH index of lipid species";
    public static final String SUM_SPECIES_COLUMN = "Sum composition of lipid species";
    public static final String SUM_FORMULA_COLUMN = "Sum formula of lipid species";
    public static final String TAB = "\t";

    public RdbOutputWriter() {
        this(null, null);
    }

    public RdbOutputWriter(String internalStandardPrefix, String externalStandardPrefix) {
    }

    public void write(String fileName, Vector<QuantificationResult> results, LinkedHashMap<String, Integer> classSequence, Hashtable<String, Vector<String>> analyteSequence, Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects) throws RdbWriterException, ChemicalFormulaException, LipidCombinameEncodingException {
        this.write(fileName, results, null, classSequence, analyteSequence, null, null, null, quantObjects, false);
    }

    /*
     * WARNING - void declaration
     */
    private void write(String fileNameOut, Vector<QuantificationResult> results, Hashtable<Integer, String> expLookup, LinkedHashMap<String, Integer> classSequence, Hashtable<String, Vector<String>> correctAnalyteSequence, Hashtable<String, Hashtable<String, String>> acceptedMolecules, ComparativeAnalysis analysisModule, Hashtable<String, Integer> maxIsotopes, Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects, boolean alexRtGrouper) throws RdbWriterException, ChemicalFormulaException, LipidCombinameEncodingException {
        boolean detectorColumn = false;
        boolean polarityColumn = false;
        boolean lipidIdColumn = false;
        boolean lipidCategoryColumn = false;
        boolean conflictsColumn = false;
        boolean ohIndexColumn = false;
        boolean containsMSnInformation = false;
        int highestIsotopeNumber = 0;
        int highestMSLevel = 1;
        boolean isCompModulePresent = analysisModule != null;
        boolean isRtGrouped = isCompModulePresent && analysisModule.isRtGrouped();
        boolean foundAlexQuantObjects = false;
        if (quantObjects != null) {
            for (Hashtable hashtable : quantObjects.values()) {
                for (Hashtable quantsOfAnalyte : hashtable.values()) {
                    for (QuantVO quant : quantsOfAnalyte.values()) {
                        TargetlistEntry entry;
                        if (!(quant instanceof TargetlistEntry)) continue;
                        if (!isCompModulePresent) {
                            foundAlexQuantObjects = true;
                        }
                        if ((entry = (TargetlistEntry)quant).getDetector() != null) {
                            detectorColumn = true;
                        }
                        if (entry.getPolarity() != null) {
                            polarityColumn = true;
                        }
                        if (entry.getId() != null) {
                            lipidIdColumn = true;
                        }
                        if (entry.getCategory() != null) {
                            lipidCategoryColumn = true;
                        }
                        if (entry.getConflicts() != null) {
                            conflictsColumn = true;
                        }
                        if (entry.getOhNumber() >= 0) {
                            ohIndexColumn = true;
                        }
                        if (!isCompModulePresent) {
                            if (entry.getMsnFragments() != null && entry.getMsnFragments().size() > 0) {
                                containsMSnInformation = true;
                            }
                            for (Integer n : entry.getMsnFragments().keySet()) {
                                if (n <= highestMSLevel) continue;
                                highestMSLevel = n;
                            }
                            continue;
                        }
                        if (entry.getMsLevel() <= highestMSLevel) continue;
                        highestMSLevel = entry.getMsLevel();
                    }
                }
            }
        }
        if (!foundAlexQuantObjects) {
            for (QuantificationResult quantificationResult : results) {
                for (String className : quantificationResult.getIdentifications().keySet()) {
                    for (LipidParameterSet set : quantificationResult.getIdentifications().get(className)) {
                        if (!(set instanceof LipidomicsMSnSet)) continue;
                        if (quantObjects != null && (detectorColumn || polarityColumn || lipidIdColumn || lipidCategoryColumn || conflictsColumn || ohIndexColumn)) {
                            containsMSnInformation = true;
                        }
                        LipidomicsMSnSet msn = (LipidomicsMSnSet)set;
                        for (CgProbe cgProbe : msn.getHeadGroupFragments().values()) {
                            if (cgProbe.getMsLevel() <= highestMSLevel) continue;
                            highestMSLevel = cgProbe.getMsLevel();
                        }
                        for (Hashtable hashtable : msn.getChainFragments().values()) {
                            for (CgProbe cgProbe : hashtable.values()) {
                                if (cgProbe.getMsLevel() <= highestMSLevel) continue;
                                highestMSLevel = cgProbe.getMsLevel();
                            }
                        }
                    }
                }
            }
        }
        for (QuantificationResult quantificationResult : results) {
            for (String className : quantificationResult.getIdentifications().keySet()) {
                if (maxIsotopes != null) {
                    int maxIso = maxIsotopes.get(className);
                    if (maxIso <= highestIsotopeNumber) continue;
                    highestIsotopeNumber = maxIso;
                    continue;
                }
                for (LipidParameterSet set : quantificationResult.getIdentifications().get(className)) {
                    if (set == null || set.getIsotopicProbes().size() - 1 <= highestIsotopeNumber) continue;
                    highestIsotopeNumber = set.getIsotopicProbes().size() - 1;
                }
            }
        }
        try {
            int i;
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(fileNameOut));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("RAW_ID\tMachine");
            if (detectorColumn) {
                stringBuilder.append("\tDetector");
            }
            if (polarityColumn) {
                stringBuilder.append("\tPolarity");
            }
            stringBuilder.append("\tMS evidence level\tLipid species");
            if (isRtGrouped) {
                stringBuilder.append("\tRT group");
            }
            stringBuilder.append("\tMolecular lipid species\tMol. species rank\tLipid class");
            for (i = 2; i <= highestMSLevel; ++i) {
                String levelName = LEVEL_PREFIX + i;
                stringBuilder.append(TAB + levelName + FRAGMENT_NAMES_LEVEL_COLUMN_PART + TAB + levelName + FRAGMENT_MZ_LEVEL_COLUMN_PART + TAB + NUMBER_MS_SCANS_PREFIX + levelName + NUMBER_MS_SCANS_SUFFIX + TAB + levelName + MSN_RTS_COLUMN_PART);
                if (!containsMSnInformation) continue;
                stringBuilder.append(TAB + levelName + PRECURSOR_COLUMN_PART + TAB + levelName + ACTIVATION_COLUMN_PART);
            }
            stringBuilder.append("\tRetention time\tIsotope clusters\tLower valley\tUpper valley\tLower valley 10%\tUpper valley 10%\tLower valley 50%\tUpper valley 50%\tLow m/z\tUp m/z\tLow m/z 10%\tUp m/z 10%\tLow m/z 50%\tUp m/z 50%\tPeak area (total)");
            for (i = 0; i != highestIsotopeNumber + 1; ++i) {
                stringBuilder.append("\tPeak area M" + i);
            }
            stringBuilder.append("\tMax intensity\tTarget m/z\tMeasured m/z\tApplied m/z correction\tCorrected measured m/z\tm/z offset\tppm error\tAdduct");
            if (lipidIdColumn) {
                stringBuilder.append("\tLipid ID");
            }
            if (lipidCategoryColumn) {
                stringBuilder.append("\tLipid category");
            }
            if (conflictsColumn) {
                stringBuilder.append("\tConflicts");
            }
            stringBuilder.append("\tCharge\tC index of lipid species\tDB index of lipid species");
            if (ohIndexColumn) {
                stringBuilder.append("\tOH index of lipid species");
            }
            stringBuilder.append("\tSum composition of lipid species\tSum formula of lipid species\n");
            stream.write(stringBuilder.toString().getBytes());
            for (i = 0; i != results.size(); ++i) {
                void var31_49;
                QuantificationResult result = results.get(i);
                String msMachine = "";
                float mzCorrection = 0.0f;
                String expName = null;
                if (expLookup != null) {
                    expName = expLookup.get(result.hashCode());
                }
                String resultsExcelName = null;
                if (result.getConstants() != null && result.getConstants().getRawFileName() != null) {
                    resultsExcelName = result.getConstants().getRawFileName();
                    if (resultsExcelName.endsWith(".chrom")) {
                        resultsExcelName = resultsExcelName.substring(0, resultsExcelName.length() - ".chrom".length());
                    }
                } else {
                    resultsExcelName = analysisModule.getFullFilePath(expName).getName();
                }
                if (result.getConstants() != null) {
                    mzCorrection = (float)result.getConstants().getShift();
                    msMachine = result.getConstants().getMSMachine();
                }
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                if (classSequence != null) {
                    LinkedHashMap<String, Integer> linkedHashMap2 = new LinkedHashMap<String, Integer>(classSequence);
                }
                for (String string : result.getIdentifications().keySet()) {
                    if (classSequence == null || classSequence.containsKey(string)) continue;
                    System.out.println("ATTENTION: the class " + string + " is not in your target list!");
                    var31_49.put(string, 1);
                }
                for (String string : var31_49.keySet()) {
                    Object molWithRt2;
                    if (!result.getIdentifications().containsKey(string)) continue;
                    Hashtable<Object, Object> selectedMolHash = null;
                    Hashtable<String, Vector> fromSpeciesToSpeciesWithRt = new Hashtable<String, Vector>();
                    if (acceptedMolecules != null) {
                        selectedMolHash = acceptedMolecules.containsKey(string) ? acceptedMolecules.get(string) : new Hashtable();
                    } else if (isCompModulePresent) {
                        selectedMolHash = new Hashtable();
                        for (String string2 : analysisModule.getAllMoleculeNames().get(string)) {
                            selectedMolHash.put(string2, string2);
                        }
                    }
                    if (selectedMolHash != null) {
                        for (Object molWithRt2 : selectedMolHash.keySet()) {
                            String molName;
                            if (analysisModule.isISorES(string, (String)molWithRt2) || LipidomicsConstants.isShotgun() == 1) {
                                String molName2 = new String((String)molWithRt2);
                            } else {
                                molName = ((String)molWithRt2).substring(0, ((String)molWithRt2).lastIndexOf("_"));
                            }
                            Vector molsWithRt = new Vector();
                            if (fromSpeciesToSpeciesWithRt.containsKey(molName)) {
                                molsWithRt = (Vector)fromSpeciesToSpeciesWithRt.get(molName);
                            }
                            molsWithRt.add(molWithRt2);
                            fromSpeciesToSpeciesWithRt.put(molName, molsWithRt);
                        }
                    }
                    Vector<LipidParameterSet> classResultsFile = result.getIdentifications().get(string);
                    Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
                    molWithRt2 = classResultsFile.iterator();
                    block24: while (molWithRt2.hasNext()) {
                        LipidParameterSet set = (LipidParameterSet)molWithRt2.next();
                        if (set == null) continue;
                        if (isRtGrouped) {
                            if (!fromSpeciesToSpeciesWithRt.containsKey(set.getNameStringWithoutRt())) continue;
                            Vector possSpeciesDiffRt = (Vector)fromSpeciesToSpeciesWithRt.get(set.getNameStringWithoutRt());
                            for (String molWithRt3 : possSpeciesDiffRt) {
                                ResultAreaVO vo = analysisModule.getResultAreaVO(string, molWithRt3, expName);
                                if (vo == null || !vo.belongsRtToThisAreaVO(set.getRt(), set.getModificationName())) continue;
                                Vector ofOneAnalyte = new Vector();
                                if (hashtable.containsKey(molWithRt3)) {
                                    ofOneAnalyte = (Vector)hashtable.get(molWithRt3);
                                }
                                ofOneAnalyte.add(set);
                                hashtable.put(molWithRt3, ofOneAnalyte);
                                continue block24;
                            }
                            continue;
                        }
                        Vector ofOneAnalyte = new Vector();
                        if (hashtable.containsKey(set.getNameStringWithoutRt())) {
                            ofOneAnalyte = (Vector)hashtable.get(set.getNameStringWithoutRt());
                        }
                        ofOneAnalyte.add(set);
                        hashtable.put(set.getNameStringWithoutRt(), ofOneAnalyte);
                    }
                    Hashtable<String, Hashtable<String, QuantVO>> quantsOfClass = null;
                    if (quantObjects != null && quantObjects.containsKey(string)) {
                        quantsOfClass = quantObjects.get(string);
                    }
                    int maxIsotope = 0x7FFFFFFE;
                    if (maxIsotopes != null) {
                        maxIsotope = maxIsotopes.get(string);
                    }
                    for (String molName : correctAnalyteSequence.get(string)) {
                        if (selectedMolHash != null && !selectedMolHash.containsKey(molName) || !hashtable.containsKey(molName)) continue;
                        Hashtable<String, QuantVO> quantsOfAnalyte = null;
                        String molNameWoRt = molName;
                        if (isRtGrouped && !analysisModule.isISorES(string, molName)) {
                            molNameWoRt = molName.substring(0, molName.lastIndexOf("_"));
                        }
                        if (quantsOfClass != null && quantsOfClass.containsKey(molNameWoRt)) {
                            quantsOfAnalyte = quantsOfClass.get(molNameWoRt);
                        }
                        String speciesId = "";
                        String classNameToWrite = "";
                        int cIndexSpecies = 0;
                        int dbIndexSpecies = 0;
                        String sumComposition = "";
                        speciesId = string + " " + molName;
                        classNameToWrite = string;
                        int startChar = 0;
                        char[] chars = molName.toCharArray();
                        for (int j = 0; j != chars.length; ++j) {
                            startChar = j;
                            if (Character.isDigit(chars[j])) break;
                        }
                        String indices = molName.substring(startChar);
                        String[] cAndDbs = indices.split(":");
                        try {
                            cIndexSpecies = Integer.parseInt(cAndDbs[0]);
                            dbIndexSpecies = Integer.parseInt(cAndDbs[1]);
                            sumComposition = indices;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        for (LipidParameterSet set : (Vector)hashtable.get(molName)) {
                            int j;
                            TargetlistEntry quantObject = null;
                            if (quantsOfAnalyte != null && quantsOfAnalyte.containsKey(set.getModificationName()) && quantsOfAnalyte.get(set.getModificationName()) instanceof TargetlistEntry) {
                                quantObject = (TargetlistEntry)quantsOfAnalyte.get(set.getModificationName());
                            }
                            String msLevel = "ms";
                            String molSpeciesId = "";
                            float totalArea = 0.0f;
                            Hashtable<Integer, Float> isotopicAreas = new Hashtable<Integer, Float>();
                            int maxIterate = maxIsotope + 1;
                            if (maxIterate > set.getIsotopicProbes().size()) {
                                maxIterate = set.getIsotopicProbes().size();
                            }
                            float measuredMz = 0.0f;
                            float apexIntensity = 0.0f;
                            float lowerValley = Float.MAX_VALUE;
                            float lowerValley10Pc = Float.MAX_VALUE;
                            float lowerValley50Pc = Float.MAX_VALUE;
                            float upperValley = 0.0f;
                            float upperValley10Pc = 0.0f;
                            float upperValley50Pc = 0.0f;
                            float lowerMz = Float.MAX_VALUE;
                            float lowerMz10Pc = Float.MAX_VALUE;
                            float lowerMz50Pc = Float.MAX_VALUE;
                            float upperMz = 0.0f;
                            float upperMz10Pc = 0.0f;
                            float upperMz50Pc = 0.0f;
                            String apexString = "";
                            String lowerValleyString = "";
                            String lowerValley10PcString = "";
                            String lowerValley50PcString = "";
                            String upperValleyString = "";
                            String upperValley10PcString = "";
                            String upperValley50PcString = "";
                            String lowerMzString = "";
                            String lowerMz10PcString = "";
                            String lowerMz50PcString = "";
                            String upperMzString = "";
                            String upperMz10PcString = "";
                            String upperMz50PcString = "";
                            String detector = "";
                            String polarity = "";
                            String speciesToWrite = new String(speciesId);
                            String groupingId = "";
                            String lipidId = "";
                            String lipidCategory = "";
                            String conflicts = "";
                            int charge = set.getCharge();
                            int cIndexSpeciesToWrite = cIndexSpecies;
                            int dbIndexSpeciesToWrite = dbIndexSpecies;
                            Integer ohIndex = null;
                            String sumCompositionToWrite = new String(sumComposition);
                            String sumFormula = set.getChemicalFormula();
                            if (quantObject != null) {
                                if (quantObject.getDetector() != null) {
                                    detector = quantObject.getDetector();
                                }
                                if (quantObject.getPolarity() != null) {
                                    polarity = quantObject.getPolarity();
                                }
                                speciesToWrite = quantObject.getSpecies();
                                classNameToWrite = quantObject.getOriginalClassName();
                                if (quantObject.getId() != null) {
                                    lipidId = quantObject.getId();
                                }
                                if (quantObject.getCategory() != null) {
                                    lipidCategory = quantObject.getCategory();
                                }
                                if (quantObject.getConflicts() != null) {
                                    conflicts = quantObject.getConflicts();
                                }
                                if (quantObject.getPolarity() != null && quantObject.getPolarity().equalsIgnoreCase("-")) {
                                    charge *= -1;
                                }
                                if (quantObject.getOhNumber() >= 0) {
                                    ohIndex = quantObject.getOhNumber();
                                }
                                if (quantObject.getCarbonNumber() >= 0) {
                                    cIndexSpeciesToWrite = quantObject.getCarbonNumber();
                                }
                                if (quantObject.getDbNumber() >= 0) {
                                    dbIndexSpeciesToWrite = quantObject.getDbNumber();
                                }
                                sumCompositionToWrite = quantObject.getSumComposition() != null ? quantObject.getSumComposition() : "";
                                sumFormula = quantObject.getOriginalSumFormula();
                            }
                            if (isCompModulePresent && !alexRtGrouper && quantObject == null) {
                                sumFormula = set.getChemicalFormula();
                                Hashtable<String, Integer> categorized = StaticUtils.categorizeFormula(sumFormula);
                                if (Settings.useAlex() && result.getConstants() != null && result.getConstants().isAlexTargetlist()) {
                                    Hashtable<String, String> isoLookup = Settings.getAlexIsoLookup();
                                    for (String alexIso : isoLookup.keySet()) {
                                        String ldaIso = (String)isoLookup.get(alexIso);
                                        if (!categorized.containsKey(ldaIso)) continue;
                                        categorized.put(alexIso, categorized.get(ldaIso));
                                        categorized.remove(ldaIso);
                                    }
                                }
                                sumFormula = StaticUtils.getFormulaInHillNotation(categorized, false);
                            }
                            if (isRtGrouped) {
                                groupingId = molName.substring(molName.lastIndexOf("_") + 1);
                                if (speciesToWrite.endsWith("_" + groupingId)) {
                                    speciesToWrite = speciesToWrite.substring(0, speciesToWrite.lastIndexOf("_"));
                                }
                                if (analysisModule.isISorES(string, molName)) {
                                    groupingId = "";
                                }
                            }
                            for (int j2 = 0; j2 != maxIterate; ++j2) {
                                for (CgProbe probe : set.getIsotopicProbes().get(j2)) {
                                    totalArea += probe.Area;
                                    float isoArea = 0.0f;
                                    if (isotopicAreas.containsKey(j2)) {
                                        isoArea = ((Float)isotopicAreas.get(j2)).floatValue();
                                    }
                                    isotopicAreas.put(j2, Float.valueOf(isoArea += probe.Area));
                                    if (j2 != 0) continue;
                                    measuredMz += probe.Mz;
                                    float currentLV = probe.LowerValley;
                                    float currentLV10 = Float.MAX_VALUE;
                                    float currentLV50 = Float.MAX_VALUE;
                                    float currentUV = probe.UpperValley;
                                    float currentUV10 = 0.0f;
                                    float currentUV50 = 0.0f;
                                    float currentLMz = probe.Mz - probe.LowerMzBand;
                                    float currentUMz = probe.Mz + probe.UpperMzBand;
                                    if (probe.getLowerValley10() != null) {
                                        currentLV10 = probe.getLowerValley10().floatValue();
                                        currentLV50 = probe.getLowerValley50().floatValue();
                                        currentUV10 = probe.getUpperValley10().floatValue();
                                        currentUV50 = probe.getUpperValley50().floatValue();
                                    }
                                    if (set.getLowerRtHardLimit() >= 0.0f) {
                                        if (currentLV < set.getLowerRtHardLimit()) {
                                            currentLV = set.getLowerRtHardLimit();
                                        }
                                        if (currentLV10 < set.getLowerRtHardLimit()) {
                                            currentLV10 = set.getLowerRtHardLimit();
                                        }
                                        if (currentLV50 < set.getLowerRtHardLimit()) {
                                            currentLV50 = set.getLowerRtHardLimit();
                                        }
                                    }
                                    if (set.getUpperRtHardLimit() >= 0.0f) {
                                        if (currentUV > set.getUpperRtHardLimit()) {
                                            currentUV = set.getUpperRtHardLimit();
                                        }
                                        if (currentUV10 > set.getUpperRtHardLimit()) {
                                            currentUV10 = set.getUpperRtHardLimit();
                                        }
                                        if (currentUV50 > set.getUpperRtHardLimit()) {
                                            currentUV50 = set.getUpperRtHardLimit();
                                        }
                                    }
                                    if (currentLV < lowerValley) {
                                        lowerValley = currentLV;
                                    }
                                    if (currentUV > upperValley) {
                                        upperValley = currentUV;
                                    }
                                    if (currentLMz < lowerMz) {
                                        lowerMz = currentLMz;
                                    }
                                    if (currentUMz > upperMz) {
                                        upperMz = currentUMz;
                                    }
                                    if (probe.getLowerValley10() != null) {
                                        if (probe.getApexIntensity().floatValue() > apexIntensity) {
                                            apexIntensity = probe.getApexIntensity().floatValue();
                                        }
                                        if (currentLV10 < lowerValley10Pc) {
                                            lowerValley10Pc = currentLV10;
                                        }
                                        if (currentLV50 < lowerValley50Pc) {
                                            lowerValley50Pc = currentLV50;
                                        }
                                        if (currentUV10 > upperValley10Pc) {
                                            upperValley10Pc = currentUV10;
                                        }
                                        if (currentUV50 > upperValley50Pc) {
                                            upperValley50Pc = currentUV50;
                                        }
                                    }
                                    if (!(probe instanceof Probe3D)) continue;
                                    Probe3D probe3D = (Probe3D)probe;
                                    float currentLMz10 = Float.MAX_VALUE;
                                    float currentLMz50 = Float.MAX_VALUE;
                                    float currentUMz10 = 0.0f;
                                    float currentUMz50 = 0.0f;
                                    if (probe3D.getLowMz10() > 0.0f) {
                                        currentLMz10 = probe3D.getLowMz10();
                                        currentLMz50 = probe3D.getLowMz50();
                                        currentUMz10 = probe3D.getUpMz10();
                                        currentUMz50 = probe3D.getUpMz50();
                                    }
                                    if (!(probe3D.getLowMz10() > 0.0f)) continue;
                                    if (currentLMz10 < lowerMz10Pc) {
                                        lowerMz10Pc = currentLMz10;
                                    }
                                    if (currentLMz50 < lowerMz50Pc) {
                                        lowerMz50Pc = currentLMz50;
                                    }
                                    if (currentUMz10 > upperMz10Pc) {
                                        upperMz10Pc = currentUMz10;
                                    }
                                    if (!(currentUMz50 > upperMz50Pc)) continue;
                                    upperMz50Pc = currentUMz50;
                                }
                                if (j2 != 0) continue;
                                measuredMz /= (float)set.getIsotopicProbes().get(j2).size();
                                if (apexIntensity > 0.0f) {
                                    apexString = String.valueOf(Math.round(apexIntensity));
                                }
                                lowerValleyString = Calculator.FormatNumberToString(Calculator.roundFloat(lowerValley / 60.0f, 2), 2.0);
                                upperValleyString = Calculator.FormatNumberToString(Calculator.roundFloat(upperValley / 60.0f, 2), 2.0);
                                lowerMzString = String.valueOf(lowerMz);
                                upperMzString = String.valueOf(upperMz);
                                if (lowerValley10Pc < Float.MAX_VALUE) {
                                    lowerValley10PcString = Calculator.FormatNumberToString(Calculator.roundFloat(lowerValley10Pc / 60.0f, 2), 2.0);
                                    upperValley10PcString = Calculator.FormatNumberToString(Calculator.roundFloat(upperValley10Pc / 60.0f, 2), 2.0);
                                    lowerValley50PcString = Calculator.FormatNumberToString(Calculator.roundFloat(lowerValley50Pc / 60.0f, 2), 2.0);
                                    upperValley50PcString = Calculator.FormatNumberToString(Calculator.roundFloat(upperValley50Pc / 60.0f, 2), 2.0);
                                }
                                if (!(lowerMz10Pc < Float.MAX_VALUE)) continue;
                                lowerMz10PcString = String.valueOf(lowerMz10Pc);
                                upperMz10PcString = String.valueOf(upperMz10Pc);
                                lowerMz50PcString = String.valueOf(lowerMz50Pc);
                                upperMz50PcString = String.valueOf(upperMz50Pc);
                            }
                            StringBuilder isotopeClusters = new StringBuilder();
                            for (int j3 = 0; j3 != isotopicAreas.size(); ++j3) {
                                if (j3 != 0) {
                                    isotopeClusters.append("+");
                                }
                                isotopeClusters.append("M" + String.valueOf(j3));
                            }
                            float targetMz = set.Mz[0] - mzCorrection;
                            float correctedMeasured = measuredMz - mzCorrection;
                            float mzOffset = measuredMz - set.Mz[0];
                            float ppmError = mzOffset * 1000000.0f / targetMz;
                            if (set instanceof LipidomicsMSnSet) {
                                msLevel = "ms/ms";
                                LipidomicsMSnSet msnSet = (LipidomicsMSnSet)set;
                                Hashtable<Integer, LinkedHashMap<Integer, Float>> msnRets = msnSet.getMsnRetentionTimes();
                                Hashtable<Integer, Integer> nrMSnSpectra = new Hashtable<Integer, Integer>();
                                Hashtable<Integer, String> msnRetStrings = new Hashtable<Integer, String>();
                                for (int j4 = 2; j4 <= highestMSLevel; ++j4) {
                                    if (msnRets.containsKey(j4)) {
                                        Vector<Float> rts = new Vector<Float>(msnRets.get(j4).values());
                                        String rtsString = "";
                                        for (Float rt : rts) {
                                            if (rtsString.length() > 0) {
                                                rtsString = rtsString + "|";
                                            }
                                            rtsString = rtsString + Calculator.FormatNumberToString(Calculator.roundFloat(rt.floatValue() / 60.0f, 2), 2.0);
                                        }
                                        nrMSnSpectra.put(j4, rts.size());
                                        msnRetStrings.put(j4, rtsString);
                                        continue;
                                    }
                                    nrMSnSpectra.put(j4, 0);
                                    msnRetStrings.put(j4, "");
                                }
                                int rank = 0;
                                Hashtable<Integer, Hashtable<String, Hashtable<String, TargetlistEntry>>> alexFragments = null;
                                Hashtable<String, String> molLookup = null;
                                if (quantObject != null && containsMSnInformation && quantObject.getMsnFragments() != null && quantObject.getMsnFragments().size() > 0) {
                                    alexFragments = quantObject.getMsnFragments();
                                    molLookup = quantObject.getMolSpeciesLookup();
                                }
                                for (Object msnNames : msnSet.getMSnIdentificationNames()) {
                                    void var127_193;
                                    void var127_198;
                                    void var122_175;
                                    void var122_183;
                                    String nameString = "";
                                    double relativeShare = 1.0;
                                    String oneCombi = "";
                                    ++rank;
                                    if (msnNames instanceof Vector) {
                                        Vector names = (Vector)msnNames;
                                        for (int j6 = 0; j6 != names.size(); ++j6) {
                                            if (j6 == 0 && msnSet.getMSnIdentificationNames().size() > 1) {
                                                relativeShare = msnSet.getRelativeIntensity((String)names.get(j6));
                                            }
                                            nameString = nameString + (String)names.get(j6) + "|";
                                            oneCombi = (String)names.get(j6);
                                        }
                                        nameString = nameString.substring(0, nameString.length() - 1);
                                    } else {
                                        oneCombi = nameString = (String)msnNames;
                                        if (msnSet.getMSnIdentificationNames().size() > 1) {
                                            relativeShare = msnSet.getRelativeIntensity(nameString);
                                        }
                                    }
                                    oneCombi = msnSet.getCombiIdFromHumanReadable(oneCombi);
                                    ArrayList<TargetlistFloatStringVO> fragments = new ArrayList<TargetlistFloatStringVO>();
                                    if (msnSet.getStatus() >= 2) {
                                        Hashtable<String, CgProbe> headFragments = msnSet.getHeadGroupFragments();
                                        for (String string3 : headFragments.keySet()) {
                                            TargetlistEntry ms2Target = this.getMSnTargetlistEntry(string3, null, null, alexFragments);
                                            fragments.add(new TargetlistFloatStringVO(string3, Float.valueOf(headFragments.get((Object)string3).Mz), headFragments.get(string3).getMsLevel(), ms2Target));
                                        }
                                    }
                                    if (msnSet.getStatus() > 2) {
                                        Hashtable<String, Hashtable<String, CgProbe>> chainFrags = msnSet.getChainFragments();
                                        Vector<FattyAcidVO> fas = StaticUtils.decodeLipidNamesFromChainCombi(oneCombi);
                                        molSpeciesId = StaticUtils.encodeAlexMolSpeciesName(classNameToWrite, fas);
                                        if (molLookup != null) {
                                            if (molLookup.containsKey(oneCombi)) {
                                                molSpeciesId = molLookup.get(oneCombi);
                                            } else {
                                                for (String combiName : StaticUtils.getPermutedChainNames(StaticUtils.splitChainCombiToEncodedStrings(oneCombi, "<->"), "<->")) {
                                                    if (!molLookup.containsKey(combiName)) continue;
                                                    molSpeciesId = molLookup.get(combiName);
                                                    break;
                                                }
                                            }
                                        }
                                        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                                        for (int j7 = 0; j7 != fas.size(); ++j7) {
                                            FattyAcidVO fa = fas.get(j7);
                                            Hashtable<Object, Object> frags = new Hashtable();
                                            frags = chainFrags.get(fa.getChainId());
                                            if (frags == null) continue;
                                            for (String string4 : frags.keySet()) {
                                                String fragmentName = string4;
                                                if (!fragmentName.contains(fa.getChainId())) {
                                                    fragmentName = StaticUtils.getChainFragmentDisplayName(fragmentName, fa.getCarbonDbsId());
                                                }
                                                if (hashtable2.containsKey(fragmentName)) continue;
                                                hashtable2.put(fragmentName, fragmentName);
                                                TargetlistEntry ms2Target = this.getMSnTargetlistEntry(string4, fa.getChainId(), oneCombi, alexFragments);
                                                fragments.add(new TargetlistFloatStringVO(fragmentName, Float.valueOf(((CgProbe)frags.get((Object)string4)).Mz), ((CgProbe)frags.get(string4)).getMsLevel(), ms2Target));
                                            }
                                        }
                                    } else {
                                        molSpeciesId = classNameToWrite + " " + nameString;
                                        if (molLookup != null) {
                                            molSpeciesId = speciesToWrite;
                                        }
                                    }
                                    Collections.sort(fragments, new GeneralComparator("at.tugraz.genome.lda.vos.FloatStringVO", "getValue", "java.lang.Float"));
                                    Hashtable<Integer, String> fragmentNameHash = new Hashtable<Integer, String>();
                                    Hashtable<Integer, String> fragmentMzHash = new Hashtable<Integer, String>();
                                    int n = 2;
                                    while (var122_183 <= highestMSLevel) {
                                        fragmentNameHash.put((int)var122_183, "");
                                        fragmentMzHash.put((int)var122_183, "");
                                        ++var122_183;
                                    }
                                    String string5 = "";
                                    String ms2Activation = "";
                                    String ms3Precursor = "";
                                    String ms3Activation = "";
                                    for (TargetlistFloatStringVO targetlistFloatStringVO : fragments) {
                                        String fragmentNames = (String)fragmentNameHash.get(targetlistFloatStringVO.getMsLevel());
                                        String fragmentMzs = (String)fragmentMzHash.get(targetlistFloatStringVO.getMsLevel());
                                        String mz = Calculator.FormatNumberToString(targetlistFloatStringVO.getValue().floatValue(), 3.0);
                                        if (fragmentNames.length() > 0) {
                                            fragmentNames = fragmentNames + "|";
                                            fragmentMzs = fragmentMzs + "|";
                                        }
                                        fragmentNames = fragmentNames + targetlistFloatStringVO.getKey() + "{" + mz + "}";
                                        fragmentMzs = fragmentMzs + mz;
                                        fragmentNameHash.put(targetlistFloatStringVO.getMsLevel(), fragmentNames);
                                        fragmentMzHash.put(targetlistFloatStringVO.getMsLevel(), fragmentMzs);
                                        if (targetlistFloatStringVO.getMs2Target() != null && targetlistFloatStringVO.getMs2Target().getMs2Precursor() != null) {
                                            if (var122_175 != null && var122_175.length() > 0) {
                                                if (!var122_175.equalsIgnoreCase(targetlistFloatStringVO.getMs2Target().getMs2Precursor())) {
                                                    System.out.println("ATTENTION: The lipid species " + speciesToWrite + " contains fragments that have a different MS-precursors in the ALEX target list");
                                                }
                                                if (!ms2Activation.equalsIgnoreCase(targetlistFloatStringVO.getMs2Target().getMs2Activation())) {
                                                    System.out.println("ATTENTION: The lipid species " + speciesToWrite + " contains fragments that have a different MS2-activation in the ALEX target list");
                                                }
                                            } else {
                                                String string6 = targetlistFloatStringVO.getMs2Target().getMs2Precursor();
                                                ms2Activation = targetlistFloatStringVO.getMs2Target().getMs2Activation();
                                            }
                                        }
                                        if (targetlistFloatStringVO.getMs2Target() != null && targetlistFloatStringVO.getMs2Target().getMs3Precursor() != null) {
                                            if (ms3Precursor != null && ms3Precursor.length() > 0) {
                                                if (!ms3Precursor.contains(targetlistFloatStringVO.getMs2Target().getMs3Precursor())) {
                                                    ms3Precursor = ms3Precursor + "|" + targetlistFloatStringVO.getMs2Target().getMs3Precursor();
                                                    ms3Activation = ms3Activation + "|" + targetlistFloatStringVO.getMs2Target().getMs3Activation();
                                                }
                                            } else {
                                                ms3Precursor = targetlistFloatStringVO.getMs2Target().getMs3Precursor();
                                                ms3Activation = targetlistFloatStringVO.getMs2Target().getMs3Activation();
                                            }
                                        }
                                        if (!isCompModulePresent || quantObject == null) continue;
                                        if (quantObject.getMs2Precursor() != null) {
                                            String string7 = quantObject.getMs2Precursor();
                                        }
                                        if (quantObject.getMs2Activation() != null) {
                                            ms2Activation = quantObject.getMs2Activation();
                                        }
                                        if (quantObject.getMs3Precursor() != null) {
                                            ms3Precursor = quantObject.getMs3Precursor();
                                        }
                                        if (quantObject.getMs3Activation() == null) continue;
                                        ms3Activation = quantObject.getMs3Activation();
                                    }
                                    StringBuilder line = new StringBuilder();
                                    line.append(resultsExcelName).append(TAB).append(msMachine);
                                    if (detectorColumn) {
                                        line.append(TAB).append(detector);
                                    }
                                    if (polarityColumn) {
                                        line.append(TAB).append(polarity);
                                    }
                                    line.append(TAB).append(msLevel).append(TAB).append(speciesToWrite);
                                    if (isRtGrouped) {
                                        line.append(TAB).append(groupingId);
                                    }
                                    line.append(TAB).append(molSpeciesId);
                                    line.append(TAB).append(String.valueOf(rank));
                                    line.append(TAB).append(classNameToWrite);
                                    int n2 = 2;
                                    while (var127_198 <= highestMSLevel) {
                                        line.append(TAB + (String)fragmentNameHash.get((int)var127_198) + TAB + (String)fragmentMzHash.get((int)var127_198) + TAB + nrMSnSpectra.get((int)var127_198) + TAB + (String)msnRetStrings.get((int)var127_198));
                                        if (containsMSnInformation) {
                                            if (var127_198 == 2) {
                                                line.append(TAB).append((String)var122_175).append(TAB).append(ms2Activation);
                                            } else if (var127_198 == 3) {
                                                line.append(TAB).append(ms3Precursor).append(TAB).append(ms3Activation);
                                            }
                                        }
                                        ++var127_198;
                                    }
                                    line.append(TAB).append(set.getRt()).append(TAB).append((CharSequence)isotopeClusters).append(TAB).append(lowerValleyString);
                                    line.append(TAB).append(upperValleyString).append(TAB).append(lowerValley10PcString).append(TAB).append(upperValley10PcString);
                                    line.append(TAB).append(lowerValley50PcString).append(TAB).append(upperValley50PcString).append(TAB).append(lowerMzString);
                                    line.append(TAB).append(upperMzString).append(TAB).append(lowerMz10PcString).append(TAB).append(upperMz10PcString);
                                    line.append(TAB).append(lowerMz50PcString).append(TAB).append(upperMz50PcString).append(TAB).append(String.valueOf((double)totalArea * relativeShare));
                                    boolean bl = false;
                                    while (var127_193 != highestIsotopeNumber + 1) {
                                        line.append(TAB);
                                        if (isotopicAreas.containsKey((int)var127_193)) {
                                            line.append(String.valueOf(isotopicAreas.get((int)var127_193)));
                                        }
                                        ++var127_193;
                                    }
                                    line.append(TAB).append(apexString).append(TAB).append(targetMz).append(TAB).append(measuredMz);
                                    line.append(TAB).append(mzCorrection * -1.0f).append(TAB).append(correctedMeasured).append(TAB).append(mzOffset);
                                    line.append(TAB).append(ppmError).append(TAB).append(set.getModificationName());
                                    if (lipidIdColumn) {
                                        line.append(TAB).append(lipidId);
                                    }
                                    if (lipidCategoryColumn) {
                                        line.append(TAB).append(lipidCategory);
                                    }
                                    if (conflictsColumn) {
                                        line.append(TAB).append(conflicts);
                                    }
                                    line.append(TAB).append(charge).append(TAB).append(cIndexSpeciesToWrite).append(TAB).append(dbIndexSpeciesToWrite);
                                    if (ohIndexColumn) {
                                        line.append(TAB);
                                        if (ohIndex != null) {
                                            line.append(ohIndex);
                                        }
                                    }
                                    line.append(TAB).append(sumCompositionToWrite).append(TAB).append(sumFormula).append("\n");
                                    stream.write(line.toString().getBytes());
                                }
                                continue;
                            }
                            StringBuilder line = new StringBuilder();
                            line.append(resultsExcelName).append(TAB).append(msMachine);
                            if (detectorColumn) {
                                line.append(TAB).append(detector);
                            }
                            if (polarityColumn) {
                                line.append(TAB).append(polarity);
                            }
                            line.append(TAB).append(msLevel).append(TAB).append(speciesToWrite);
                            if (isRtGrouped) {
                                line.append(TAB).append(groupingId);
                            }
                            line.append(TAB).append(molSpeciesId + TAB);
                            line.append(TAB).append(classNameToWrite);
                            for (j = 2; j <= highestMSLevel; ++j) {
                                line.append("\t\t\t\t");
                                if (!containsMSnInformation || j != 2 && j != 3) continue;
                                line.append("\t\t");
                            }
                            line.append(TAB).append(set.getRt()).append(TAB).append((CharSequence)isotopeClusters).append(TAB).append(lowerValleyString);
                            line.append(TAB).append(upperValleyString).append(TAB).append(lowerValley10PcString).append(TAB).append(upperValley10PcString);
                            line.append(TAB).append(lowerValley50PcString).append(TAB).append(upperValley50PcString).append(TAB).append(lowerMzString);
                            line.append(TAB).append(upperMzString).append(TAB).append(lowerMz10PcString).append(TAB).append(upperMz10PcString);
                            line.append(TAB).append(lowerMz50PcString).append(TAB).append(upperMz50PcString).append(TAB).append(String.valueOf(totalArea));
                            for (j = 0; j != highestIsotopeNumber + 1; ++j) {
                                line.append(TAB);
                                if (!isotopicAreas.containsKey(j)) continue;
                                line.append(String.valueOf(isotopicAreas.get(j)));
                            }
                            line.append(TAB).append(apexString).append(TAB).append(targetMz).append(TAB).append(measuredMz);
                            line.append(TAB).append(mzCorrection * -1.0f).append(TAB).append(correctedMeasured).append(TAB).append(mzOffset);
                            line.append(TAB).append(ppmError).append(TAB).append(set.getModificationName());
                            if (lipidIdColumn) {
                                line.append(TAB).append(lipidId);
                            }
                            if (lipidCategoryColumn) {
                                line.append(TAB).append(lipidCategory);
                            }
                            if (conflictsColumn) {
                                line.append(TAB).append(conflicts);
                            }
                            line.append(TAB).append(charge).append(TAB).append(cIndexSpeciesToWrite).append(TAB).append(dbIndexSpeciesToWrite);
                            if (ohIndexColumn) {
                                line.append(TAB);
                                if (ohIndex != null) {
                                    line.append(ohIndex);
                                }
                            }
                            line.append(TAB).append(sumCompositionToWrite).append(TAB).append(sumFormula).append("\n");
                            stream.write(line.toString().getBytes());
                        }
                    }
                }
            }
            stream.close();
        }
        catch (IOException e) {
            throw new RdbWriterException(e);
        }
    }

    public void write(String fileName, ComparativeAnalysis analysisModule, LinkedHashMap<String, Integer> classSequence, Hashtable<String, Vector<String>> analyteSequence, Hashtable<String, Hashtable<String, String>> acceptedMolecules, Hashtable<String, Integer> maxIsotopes, Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects, Vector<String> allowedExps, boolean alexRtGrouper) throws RdbWriterException, ExcelInputFileException, ChemicalFormulaException, LipidCombinameEncodingException {
        Vector<QuantificationResult> results = new Vector<QuantificationResult>();
        Hashtable<Integer, String> expLookup = new Hashtable<Integer, String>();
        for (int i = 0; i != analysisModule.getExpNamesInSequence().size(); ++i) {
            String exp = analysisModule.getExpNamesInSequence().get(i);
            File resultFile = analysisModule.getFullFilePath(exp);
            boolean ok = true;
            if (allowedExps != null) {
                ok = false;
                for (String excelPath : allowedExps) {
                    if (!excelPath.equalsIgnoreCase(resultFile.getAbsolutePath())) continue;
                    ok = true;
                    break;
                }
            }
            if (!ok) continue;
            QuantificationResult result = LDAResultReader.readResultFile(resultFile.getAbsolutePath(), new Hashtable<String, Boolean>());
            results.add(result);
            expLookup.put(result.hashCode(), exp);
        }
        Hashtable<String, Vector<String>> molNamesInSequence = analysisModule.getAllMoleculeNames();
        if (analyteSequence != null) {
            Hashtable changedOrder = new Hashtable();
            for (String lClass : molNamesInSequence.keySet()) {
                Vector<String> newOrder = new Vector<String>();
                Vector<String> oldOrder = molNamesInSequence.get(lClass);
                Vector<String> speciesNames = analyteSequence.get(lClass);
                for (String species : speciesNames) {
                    for (String nameWRt : oldOrder) {
                        if (!nameWRt.startsWith(species + "_")) continue;
                        newOrder.add(nameWRt);
                    }
                }
                changedOrder.put(lClass, newOrder);
            }
            molNamesInSequence = changedOrder;
        }
        this.write(fileName, results, expLookup, analysisModule.getClassSequence() != null ? analysisModule.getClassSequence() : classSequence, molNamesInSequence, acceptedMolecules, analysisModule, maxIsotopes, quantObjects != null ? quantObjects : analysisModule.getQuantObjects(), alexRtGrouper);
    }

    private TargetlistEntry getMSnTargetlistEntry(String fragmentName, String faName, String molSpecies, Hashtable<Integer, Hashtable<String, Hashtable<String, TargetlistEntry>>> alexFragments) throws LipidCombinameEncodingException {
        if (alexFragments == null) {
            return null;
        }
        String name = new String(fragmentName);
        if (molSpecies != null && faName != null && name.endsWith(" (" + faName + ")")) {
            name = name.substring(0, name.length() - (" (" + faName + ")").length());
        }
        TargetlistEntry entry = null;
        for (Hashtable<String, Hashtable<String, TargetlistEntry>> entriesOfLevel : alexFragments.values()) {
            if (!entriesOfLevel.containsKey(name)) {
                String errorMessage = "The fragment \"" + name + "\" ";
                errorMessage = faName != null && molSpecies != null ? errorMessage + "does not exist in the Alex123 target list for the chain \"" + faName + "\" for the molecular species \"" + molSpecies + "\"!" : errorMessage + "does not exist in the Alex123 target list!";
                System.out.println(errorMessage);
                return null;
            }
            Hashtable<String, TargetlistEntry> sameFragType = entriesOfLevel.get(name);
            if (molSpecies == null) {
                if (sameFragType.size() != 1) {
                    System.out.println("A head group fragment in an Alex123 target list must not be assigned to more than one lipid molecular species! This is the case for the fragment \"" + fragmentName + "\"!");
                    return null;
                }
                entry = sameFragType.values().iterator().next();
                continue;
            }
            String molSpeciesKey = molSpecies;
            if (!sameFragType.containsKey(molSpecies)) {
                boolean foundPermutedVersion = false;
                for (String key : sameFragType.keySet()) {
                    if (!StaticUtils.isAPermutedVersion(key, molSpecies, "<->")) continue;
                    foundPermutedVersion = true;
                    molSpeciesKey = key;
                }
                if (!foundPermutedVersion) {
                    System.out.println("The molecular species \"" + molSpecies + "\" of the chain  fragment cannot be assinged (Alex123 target list)!");
                    return null;
                }
            }
            entry = sameFragType.get(molSpeciesKey);
        }
        return entry;
    }
}

