/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.alex123;

import at.tugraz.genome.lda.alex123.vos.TargetlistEntry;
import at.tugraz.genome.lda.exception.AlexTargetlistParserException;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.vos.QuantVO;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Vector;

public class RdbParser {
    private String fileName_;
    private LinkedHashMap<String, Integer> classSequence_;
    private Hashtable<String, Vector<String>> analyteSequence_;
    private Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> results_;

    public RdbParser(String fileName) {
        this.fileName_ = fileName;
    }

    public void parse() throws AlexTargetlistParserException {
        this.results_ = new Hashtable();
        this.classSequence_ = new LinkedHashMap();
        this.analyteSequence_ = new Hashtable();
        LinkedHashMap analyteSequence = new LinkedHashMap();
        BufferedReader reader = null;
        try {
            String line;
            reader = new LineNumberReader(new FileReader(this.fileName_));
            boolean headerLineFound = false;
            int detectorColumn = -1;
            int polarityColumn = -1;
            int speciesColumn = -1;
            int molecularSpeciesColumn = -1;
            int classColumn = -1;
            int idColumn = -1;
            int categoryColumn = -1;
            Hashtable<Integer, Integer> precursorColumns = new Hashtable<Integer, Integer>();
            Hashtable<Integer, Integer> activationColumns = new Hashtable<Integer, Integer>();
            int adductColumn = -1;
            int conflictsColumn = -1;
            int dbNumberColumn = -1;
            int ohNumberColumn = -1;
            int sumFormulaColumn = -1;
            int classNumber = 1;
            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                String[] columns;
                line = line.trim();
                if (headerLineFound) {
                    LinkedHashMap<String, String> analSequ;
                    TargetlistEntry entry;
                    String detector = null;
                    String polarity = null;
                    int msLevel = 1;
                    String species = null;
                    String molecularSpecies = null;
                    String lClass = null;
                    String id = null;
                    String category = null;
                    String precursor = null;
                    Hashtable precursors = new Hashtable();
                    String activation = null;
                    Hashtable activations = new Hashtable();
                    String adduct = null;
                    String conflicts = null;
                    int dbNumber = -1;
                    int ohNumber = -1;
                    String sumFormula = null;
                    columns = line.split("\t");
                    if (detectorColumn >= 0) {
                        detector = columns[detectorColumn];
                    }
                    if (polarityColumn >= 0) {
                        polarity = columns[polarityColumn];
                    }
                    if (speciesColumn >= 0) {
                        species = columns[speciesColumn];
                    }
                    if (molecularSpeciesColumn >= 0) {
                        molecularSpecies = columns[molecularSpeciesColumn];
                    }
                    if (classColumn >= 0) {
                        lClass = columns[classColumn];
                    }
                    if (idColumn >= 0) {
                        id = columns[idColumn];
                    }
                    if (categoryColumn >= 0) {
                        category = columns[categoryColumn];
                    }
                    for (Integer precColumn : precursorColumns.keySet()) {
                        precursor = columns[precColumn];
                        precursors.put(precursorColumns.get(precColumn), precursor);
                        if ((Integer)precursorColumns.get(precColumn) <= msLevel) continue;
                        msLevel = (Integer)precursorColumns.get(precColumn);
                    }
                    for (Integer actColumn : activationColumns.keySet()) {
                        activation = columns[actColumn];
                        activations.put(activationColumns.get(actColumn), activation);
                        if ((Integer)activationColumns.get(actColumn) <= msLevel) continue;
                        msLevel = (Integer)activationColumns.get(actColumn);
                    }
                    if (adductColumn >= 0) {
                        adduct = columns[adductColumn];
                    }
                    if (conflictsColumn >= 0) {
                        conflicts = columns[conflictsColumn];
                    }
                    if (ohNumberColumn >= 0) {
                        ohNumber = Integer.parseInt(columns[ohNumberColumn]);
                    }
                    if (dbNumberColumn >= 0) {
                        dbNumber = Integer.parseInt(columns[dbNumberColumn]);
                    }
                    if (sumFormulaColumn >= 0) {
                        sumFormula = columns[sumFormulaColumn];
                    }
                    if (lClass == null || species == null || lClass == null || adduct == null) continue;
                    if (this.results_.containsKey(lClass) && this.results_.get(lClass).containsKey(species) && this.results_.get(lClass).get(species).containsKey(adduct)) {
                        entry = (TargetlistEntry)this.results_.get(lClass).get(species).get(adduct);
                        if (msLevel > entry.getMsLevel()) {
                            entry.setMsLevel_(msLevel);
                        }
                        if (molecularSpecies != null && (entry.getMolecularSpecies() == null || entry.getMolecularSpecies().length() == 0)) {
                            entry.setOriginalMolecularSpecies(molecularSpecies);
                        }
                        if (precursors.containsKey(2) && (entry.getMs2Precursor() == null || entry.getMs2Precursor().length() == 0)) {
                            entry.setMs2Precursor((String)precursors.get(2));
                        }
                        if (activations.containsKey(2) && (entry.getMs2Activation() == null || entry.getMs2Activation().length() == 0)) {
                            entry.setMs2Activation((String)activations.get(2));
                        }
                        if (precursors.containsKey(3) && (entry.getMs3Precursor() == null || entry.getMs3Precursor().length() == 0)) {
                            entry.setMs3Precursor((String)precursors.get(3));
                        }
                        if (!activations.containsKey(3) || entry.getMs3Precursor() != null && entry.getMs3Precursor().length() != 0) continue;
                        entry.setMs3Activation((String)activations.get(3));
                        continue;
                    }
                    entry = new TargetlistEntry(detector, polarity, msLevel, -1.0, null, null, species, molecularSpecies, lClass, precursors.containsKey(2) ? (String)precursors.get(2) : null, activations.containsKey(2) ? (String)activations.get(2) : null, precursors.containsKey(3) ? (String)precursors.get(3) : null, activations.containsKey(3) ? (String)activations.get(3) : null, adduct, null, id, category, conflicts, -1, -1, dbNumber, ohNumber, null, null, sumFormula, -1, -1, -1, null, null);
                    Hashtable<Object, Object> resultsOfClass = new Hashtable();
                    if (this.classSequence_.containsKey(entry.getAnalyteClass())) {
                        resultsOfClass = this.results_.get(entry.getAnalyteClass());
                        analSequ = (LinkedHashMap<String, String>)analyteSequence.get(entry.getAnalyteClass());
                    } else {
                        this.classSequence_.put(entry.getAnalyteClass(), classNumber);
                        ++classNumber;
                        analSequ = new LinkedHashMap<String, String>();
                        analyteSequence.put(entry.getAnalyteClass(), analSequ);
                    }
                    Hashtable resultsOfSpecies = new Hashtable();
                    if (resultsOfClass.containsKey(species)) {
                        resultsOfSpecies = (Hashtable)resultsOfClass.get(species);
                    } else {
                        analSequ.put(species.substring(entry.getAnalyteClass().length() + 1), species.substring(entry.getAnalyteClass().length() + 1));
                    }
                    resultsOfSpecies.put(adduct, entry);
                    resultsOfClass.put(species, resultsOfSpecies);
                    this.results_.put(entry.getAnalyteClass(), resultsOfClass);
                    continue;
                }
                if (!line.contains("RAW_ID") || !line.contains("Machine") || !line.contains("MS evidence level") || !line.contains("Lipid species") || !line.contains("Molecular lipid species") || !line.contains("Retention time") || !line.contains("Peak area (total)")) continue;
                columns = line.split("\t");
                for (int columnNr = 0; columnNr != columns.length; ++columnNr) {
                    if (columns[columnNr].equalsIgnoreCase("Detector")) {
                        detectorColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase("Polarity")) {
                        polarityColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase("Lipid species")) {
                        speciesColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase("Molecular lipid species")) {
                        molecularSpeciesColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase("Lipid class")) {
                        classColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase("Lipid ID")) {
                        idColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase("Lipid category")) {
                        categoryColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].startsWith("MS") && (columns[columnNr].endsWith(" activation") || columns[columnNr].endsWith(" precursor m/z"))) {
                        String headerPart = columns[columnNr].substring("MS".length());
                        int level = Integer.parseInt(headerPart.substring(0, headerPart.indexOf(" ")));
                        if (columns[columnNr].endsWith(" precursor m/z")) {
                            precursorColumns.put(columnNr, level);
                            continue;
                        }
                        if (!columns[columnNr].endsWith(" activation")) continue;
                        activationColumns.put(columnNr, level);
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase("Adduct")) {
                        adductColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase("Conflicts")) {
                        conflictsColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase("DB index of lipid species")) {
                        dbNumberColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase("OH index of lipid species")) {
                        ohNumberColumn = columnNr;
                        continue;
                    }
                    if (!columns[columnNr].equalsIgnoreCase("Sum formula of lipid species")) continue;
                    sumFormulaColumn = columnNr;
                }
                headerLineFound = true;
            }
            for (String className : analyteSequence.keySet()) {
                this.analyteSequence_.put(className, new Vector(((LinkedHashMap)analyteSequence.get(className)).keySet()));
            }
        }
        catch (HydroxylationEncodingException | IOException ex) {
            throw new AlexTargetlistParserException(ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public LinkedHashMap<String, Integer> getClassSequence() {
        return this.classSequence_;
    }

    public Hashtable<String, Vector<String>> getAnalyteSequence() {
        return this.analyteSequence_;
    }

    public Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> getTargetlistInfo() {
        return this.results_;
    }
}

