/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.alex123;

import at.tugraz.genome.lda.alex123.TargetlistParser;
import at.tugraz.genome.lda.alex123.vos.TargetlistEntry;
import at.tugraz.genome.lda.exception.AlexTargetlistParserException;
import java.io.File;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Vector;

public class TargetlistDirParser {
    private String dirName_;
    private boolean positiveIonMode_;
    private LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, TargetlistEntry>>> sortedEntries_;

    public TargetlistDirParser(String dirName, boolean positiveIonMode) {
        this.dirName_ = dirName;
        this.positiveIonMode_ = positiveIonMode;
    }

    public void parse() throws AlexTargetlistParserException {
        File dir = new File(this.dirName_);
        this.sortedEntries_ = new LinkedHashMap();
        if (!dir.isDirectory()) {
            throw new AlexTargetlistParserException("The select Alex123 directory is not a directory!");
        }
        File[] files = dir.listFiles();
        Vector<Hashtable<Integer, Vector<TargetlistEntry>>> parsedEntries = new Vector<Hashtable<Integer, Vector<TargetlistEntry>>>();
        for (int i = 0; i != files.length; ++i) {
            String fileName = files[i].getAbsolutePath();
            if (!fileName.endsWith(".txt")) continue;
            try {
                TargetlistParser parser = new TargetlistParser(fileName, this.positiveIonMode_);
                parser.parse();
                Hashtable<Integer, Vector<TargetlistEntry>> results = parser.getResults();
                if (results.size() <= 0) continue;
                parsedEntries.add(results);
                continue;
            }
            catch (AlexTargetlistParserException e) {
                e.printStackTrace();
            }
        }
        this.sortedEntries_ = TargetlistDirParser.sortEntriesForLDA(parsedEntries);
    }

    public static LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, TargetlistEntry>>> sortEntriesForLDA(Vector<Hashtable<Integer, Vector<TargetlistEntry>>> parsedEntries) {
        LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, TargetlistEntry>>> sortedEntries = new LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, TargetlistEntry>>>();
        Hashtable<String, Boolean> hasClassMsnFragments = new Hashtable<String, Boolean>();
        for (int msLevel = 1; msLevel != 5; ++msLevel) {
            for (Hashtable<Integer, Vector<TargetlistEntry>> oneFile : parsedEntries) {
                if (!oneFile.containsKey(msLevel)) continue;
                for (TargetlistEntry entry : oneFile.get(msLevel)) {
                    if (msLevel == 1) {
                        LinkedHashMap<Object, Object> classHits = new LinkedHashMap();
                        if (sortedEntries.containsKey(entry.getAnalyteClass())) {
                            classHits = sortedEntries.get(entry.getAnalyteClass());
                        }
                        LinkedHashMap analyteHits = new LinkedHashMap();
                        if (classHits.containsKey(entry.getSpecies())) {
                            analyteHits = (LinkedHashMap)classHits.get(entry.getSpecies());
                        }
                        if (analyteHits.containsKey(entry.getModName())) {
                            System.out.println("The species " + entry.getSpecies() + " with the adduct \"" + entry.getModName() + "\" is present more than once!");
                            continue;
                        }
                        analyteHits.put(entry.getModName(), entry);
                        classHits.put(entry.getSpecies(), analyteHits);
                        sortedEntries.put(entry.getAnalyteClass(), classHits);
                        continue;
                    }
                    if (!sortedEntries.containsKey(entry.getAnalyteClass())) {
                        System.out.println("The Alex123 target list contains the fragment \"" + entry.getFragment() + "\" belonging to the species \"" + entry.getSpecies() + "\" that belongs to the class \"" + entry.getAnalyteClass() + "\" which does not exist in the MS1 entries.");
                        continue;
                    }
                    if (!sortedEntries.get(entry.getAnalyteClass()).containsKey(entry.getSpecies())) {
                        System.out.println("The Alex123 target list contains the fragment \"" + entry.getFragment() + "\" belonging to the species \"" + entry.getSpecies() + "\" that  which does not exist in the MS1 entries.");
                        continue;
                    }
                    if (!sortedEntries.get(entry.getAnalyteClass()).get(entry.getSpecies()).containsKey(entry.getModName())) {
                        System.out.println("The Alex123 target list contains the adduct \"" + entry.getFragment() + "\" belonging to the species \"" + entry.getSpecies() + "\" belonging to the adduct \"" + entry.getModName() + "\" which does not exist in the MS1 entries.");
                        continue;
                    }
                    TargetlistEntry ms1Entry = sortedEntries.get(entry.getAnalyteClass()).get(entry.getSpecies()).get(entry.getModName());
                    ms1Entry.addFragment(entry);
                    if (hasClassMsnFragments.containsKey(ms1Entry.getAnalyteClass())) continue;
                    hasClassMsnFragments.put(ms1Entry.getAnalyteClass(), true);
                }
            }
        }
        for (String className : sortedEntries.keySet()) {
            if (!hasClassMsnFragments.containsKey(className) || !((Boolean)hasClassMsnFragments.get(className)).booleanValue()) continue;
            for (LinkedHashMap<String, TargetlistEntry> analyteHits : sortedEntries.get(className).values()) {
                for (TargetlistEntry entry : analyteHits.values()) {
                    entry.setAlex123FragmentsForClass(true);
                }
            }
        }
        return sortedEntries;
    }

    public LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, TargetlistEntry>>> getResults() {
        return this.sortedEntries_;
    }
}

