/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.alex123;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.alex123.vos.TargetlistEntry;
import at.tugraz.genome.lda.exception.AlexTargetlistParserException;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.parser.spectrummill.ElementConfigParser;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.Vector;

public class TargetlistParser {
    private String fileName_;
    private boolean polarity_;
    private Hashtable<String, String> isoLookup_;
    private Hashtable<Integer, Vector<TargetlistEntry>> results_;
    private static final String DETECTOR_COLUMN = "Detector";
    private static final String POLARITY_COLUMN = "Polarity";
    private static final String MS_LEVEL_COLUMN = "MS dimension";
    private static final String MZ_COLUMN = "Target m/z";
    private static final String FRAGMENT_COLUMN = "Fragment name";
    private static final String STRUCTURE_COLUMN = "Structure information";
    private static final String SPECIES_COLUMN = "Lipid species";
    private static final String MOLECULAR_SPECIES_COLUMN = "Molecular lipid species";
    private static final String LIPID_CLASS_COLUMN = "Lipid class";
    private static final String MS2_PRECURSOR_COLUMN = "MS2 precursor m/z";
    private static final String MS2_ACTIVATION_COLUMN = "MS2 activation";
    private static final String MS3_PRECURSOR_COLUMN = "MS3 precursor m/z";
    private static final String MS3_ACTIVATION_COLUMN = "MS3 activation";
    private static final String ADDUCT_COLUMN = "Adduct";
    private static final String ID_COLUMN = "Lipid ID";
    private static final String CATEGORY_COLUMN = "Lipid category";
    private static final String CONFLICTS_COLUMN = "Conflicts";
    private static final String CHARGE_COLUMN = "Charge";
    private static final String CARBON_NUMBER_COLUMN = "C index from lipid species";
    private static final String DB_NUMBER_COLUMN = "DB index from lipid species";
    private static final String OH_NUMBER_COLUMN = "OH index from lipid species";
    private static final String SUM_COMPOSITION_COLUMN = "Sum composition from lipid species";
    private static final String FORMULA_COLUMN = "Sum formula from lipid species";
    private static final String FRAGMENT_CARBON_NUMBER_COLUMN = "C index from structure information";
    private static final String FRAGMENT_DB_NUMBER_COLUMN = "DB index from structure information";
    private static final String FRAGMENT_OH_NUMBER_COLUMN = "OH index from structure information";
    private static final String FRAGMENT_SUM_COMPOSITION_COLUMN = "Sum composition from structure information";
    private static final String FRAGMENT_FORMULA_COLUMN = "Sum formula from structure information";
    private static final String FRAGMENT_FORMULA_COLUMN_PARTIAL = "Sum formula from structure inf";

    public TargetlistParser(String fileName, boolean polarity) {
        this.fileName_ = fileName;
        this.polarity_ = polarity;
    }

    public void parse() throws AlexTargetlistParserException {
        BufferedReader reader = null;
        this.isoLookup_ = new Hashtable();
        this.results_ = new Hashtable();
        ElementConfigParser elementParser = Settings.getElementParser();
        try {
            String line;
            this.isoLookup_ = Settings.getAlexIsoLookup();
            reader = new LineNumberReader(new FileReader(this.fileName_));
            int lineNumber = 0;
            boolean headerLineFound = false;
            int detectorColumn = -1;
            int polarityColumn = -1;
            int msLevelColumn = -1;
            int mzColumn = -1;
            int fragmentColumn = -1;
            int structureColumn = -1;
            int speciesColumn = -1;
            int molecularSpeciesColumn = -1;
            int classColumn = -1;
            int ms2PrecursorColumn = -1;
            int ms2ActivationColumn = -1;
            int ms3PrecursorColumn = -1;
            int ms3ActivationColumn = -1;
            int adductColumn = -1;
            int idColumn = -1;
            int categoryColumn = -1;
            int conflictsColumn = -1;
            int chargeColumn = -1;
            int carbonNumberColumn = -1;
            int dbNumberColumn = -1;
            int ohNumberColumn = -1;
            int sumCompositionColumn = -1;
            int formulaColumn = -1;
            int fragmentCarbonNumberColumn = -1;
            int fragmentDbNumberColumn = -1;
            int fragmentOhNumberColumn = -1;
            int fragmentSumCompositionColumn = -1;
            int fragmentFormulaColumn = -1;
            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                line = line.trim();
                ++lineNumber;
                if (headerLineFound) {
                    String detector = null;
                    String polarity = null;
                    int msLevel = -1;
                    double mz = -1.0;
                    String fragment = null;
                    String structure = null;
                    String species = null;
                    String molecularSpecies = null;
                    String lipidClass = null;
                    String ms2Precursor = null;
                    String ms2Activation = null;
                    String ms3Precursor = null;
                    String ms3Activation = null;
                    String adduct = null;
                    Hashtable<String, Integer> adductCategorized = null;
                    String id = null;
                    String category = null;
                    String conflicts = null;
                    int charge = -1;
                    int carbonNumber = -1;
                    int dbNumber = -1;
                    int ohNumber = -1;
                    String sumComposition = null;
                    String formula = null;
                    Hashtable<String, Integer> formulaCategorized = null;
                    int fragmentCarbonNumber = -1;
                    int fragmentDbNumber = -1;
                    int fragmentOhNumber = -1;
                    String fragmentSumComposition = null;
                    String fragmentFormula = null;
                    String[] columns = line.split("\t");
                    for (int columnNr = 0; columnNr != columns.length; ++columnNr) {
                        String entry;
                        if (columns[columnNr] == null || (entry = columns[columnNr].trim()).length() == 0) continue;
                        if (columnNr == detectorColumn) {
                            detector = entry;
                            continue;
                        }
                        if (columnNr == polarityColumn) {
                            polarity = entry;
                            continue;
                        }
                        if (columnNr == msLevelColumn) {
                            if (entry.equalsIgnoreCase("ms")) {
                                msLevel = 1;
                                continue;
                            }
                            msLevel = this.parseIntegerEntry(entry.substring(2), MS_LEVEL_COLUMN, lineNumber);
                            continue;
                        }
                        if (columnNr == mzColumn) {
                            mz = this.parseDoubleEntry(entry, MZ_COLUMN, lineNumber);
                            continue;
                        }
                        if (columnNr == fragmentColumn) {
                            fragment = entry;
                            if (!fragment.startsWith("=")) continue;
                            fragment = fragment.substring(1);
                            continue;
                        }
                        if (columnNr == structureColumn) {
                            structure = entry;
                            continue;
                        }
                        if (columnNr == speciesColumn) {
                            species = entry;
                            continue;
                        }
                        if (columnNr == molecularSpeciesColumn) {
                            molecularSpecies = entry;
                            continue;
                        }
                        if (columnNr == classColumn) {
                            lipidClass = entry;
                            continue;
                        }
                        if (columnNr == ms2PrecursorColumn) {
                            this.parseDoubleEntry(entry, MS2_PRECURSOR_COLUMN, lineNumber);
                            ms2Precursor = entry;
                            continue;
                        }
                        if (columnNr == ms2ActivationColumn) {
                            ms2Activation = entry;
                            continue;
                        }
                        if (columnNr == ms3PrecursorColumn) {
                            this.parseDoubleEntry(entry, MS3_PRECURSOR_COLUMN, lineNumber);
                            ms3Precursor = entry;
                            continue;
                        }
                        if (columnNr == ms3ActivationColumn) {
                            ms3Activation = entry;
                            continue;
                        }
                        if (columnNr == adductColumn) {
                            adduct = entry;
                            String adductForCategorization = new String(adduct);
                            if (adductForCategorization.endsWith("+") || adductForCategorization.endsWith("-")) {
                                adductForCategorization = adductForCategorization.substring(0, adductForCategorization.length() - 1);
                            }
                            adductForCategorization = adductForCategorization.replaceAll("\\+ ", " ");
                            adductForCategorization = adductForCategorization.replaceAll("- ", " ");
                            adductCategorized = StaticUtils.categorizeAdduct(adductForCategorization);
                            continue;
                        }
                        if (columnNr == idColumn) {
                            id = entry;
                            continue;
                        }
                        if (columnNr == categoryColumn) {
                            category = entry;
                            continue;
                        }
                        if (columnNr == conflictsColumn) {
                            conflicts = entry;
                            continue;
                        }
                        if (columnNr == chargeColumn) {
                            charge = Math.abs(this.parseIntegerEntry(entry, CHARGE_COLUMN, lineNumber));
                            continue;
                        }
                        if (columnNr == carbonNumberColumn) {
                            carbonNumber = this.parseIntegerEntry(entry, CARBON_NUMBER_COLUMN, lineNumber);
                            continue;
                        }
                        if (columnNr == dbNumberColumn) {
                            dbNumber = this.parseIntegerEntry(entry, DB_NUMBER_COLUMN, lineNumber);
                            continue;
                        }
                        if (columnNr == ohNumberColumn) {
                            ohNumber = this.parseIntegerEntry(entry, OH_NUMBER_COLUMN, lineNumber);
                            continue;
                        }
                        if (columnNr == sumCompositionColumn) {
                            sumComposition = entry;
                            continue;
                        }
                        if (columnNr == formulaColumn) {
                            formula = entry;
                            formulaCategorized = StaticUtils.categorizeFormula(this.parseChemicalFormula(elementParser, entry, FORMULA_COLUMN, lineNumber));
                            continue;
                        }
                        if (columnNr == fragmentCarbonNumberColumn) {
                            fragmentCarbonNumber = this.parseIntegerEntry(entry, FRAGMENT_CARBON_NUMBER_COLUMN, lineNumber);
                            continue;
                        }
                        if (columnNr == fragmentDbNumberColumn) {
                            fragmentDbNumber = this.parseIntegerEntry(entry, FRAGMENT_DB_NUMBER_COLUMN, lineNumber);
                            continue;
                        }
                        if (columnNr == fragmentOhNumberColumn) {
                            fragmentOhNumber = this.parseIntegerEntry(entry, FRAGMENT_OH_NUMBER_COLUMN, lineNumber);
                            continue;
                        }
                        if (columnNr == fragmentSumCompositionColumn) {
                            fragmentSumComposition = entry;
                            continue;
                        }
                        if (columnNr != fragmentFormulaColumn) continue;
                        fragmentFormula = this.parseChemicalFormula(elementParser, entry, FRAGMENT_FORMULA_COLUMN, lineNumber);
                    }
                    if (msLevel < 1) {
                        throw new AlexTargetlistParserException("An entry must contain information in the \"MS dimension\" column. The entry at line " + lineNumber + " in file " + this.fileName_ + " does not.");
                    }
                    if (!polarity.equalsIgnoreCase("+") && !polarity.equalsIgnoreCase("-")) {
                        throw new AlexTargetlistParserException("The \"Polarity\" column must contain \"+\" or \"-\" as entry. The entry at line " + lineNumber + " in file " + this.fileName_ + " does not.");
                    }
                    if (this.polarity_ && !polarity.equalsIgnoreCase("+") || !this.polarity_ && !polarity.equalsIgnoreCase("-")) continue;
                    if (mz < 0.0) {
                        throw new AlexTargetlistParserException("The \"Target m/z\" column must contain a positive number in double format. The entry at line " + lineNumber + " in file " + this.fileName_ + " is not.");
                    }
                    if (msLevel > 1 && fragment == null) {
                        throw new AlexTargetlistParserException("The \"Fragment name\" column must not be empty if the \"MS dimension\" is higher than 1. The entry at line " + lineNumber + " in file " + this.fileName_ + " is empty.");
                    }
                    if (msLevel > 1 && fragment == null) {
                        throw new AlexTargetlistParserException("The \"Structure information\" column must not be empty if the \"MS dimension\" is higher than 1. The entry at line " + lineNumber + " in file " + this.fileName_ + " is empty.");
                    }
                    if (species == null) {
                        throw new AlexTargetlistParserException("The \"Lipid species\" column must not be empty. The entry at line " + lineNumber + " in file " + this.fileName_ + " is empty.");
                    }
                    if (msLevel > 1 && molecularSpecies == null) {
                        throw new AlexTargetlistParserException("The \"Molecular lipid species\" column must not be empty if the \"MS dimension\" is higher than 1. The entry at line " + lineNumber + " in file " + this.fileName_ + " is empty.");
                    }
                    if (lipidClass == null) {
                        throw new AlexTargetlistParserException("The \"Lipid class\" column must not be empty. The entry at line " + lineNumber + " in file " + this.fileName_ + " is empty.");
                    }
                    if (msLevel == 2 && ms2Precursor == null) {
                        throw new AlexTargetlistParserException("The \"MS2 precursor m/z\" column must not be empty if the \"MS dimension\" equals 2. The entry at line " + lineNumber + " in file " + this.fileName_ + " is empty.");
                    }
                    if (msLevel == 2 && ms2Activation == null) {
                        throw new AlexTargetlistParserException("The \"MS2 activation\" column must not be empty if the \"MS dimension\" equals 2. The entry at line " + lineNumber + " in file " + this.fileName_ + " is empty.");
                    }
                    if (msLevel == 3 && ms3Precursor == null) {
                        throw new AlexTargetlistParserException("The \"MS2 precursor m/z\" column must not be empty if the \"MS dimension\" equals 3. The entry at line " + lineNumber + " in file " + this.fileName_ + " is empty.");
                    }
                    if (msLevel == 3 && ms3Activation == null) {
                        throw new AlexTargetlistParserException("The \"MS2 activation\" column must not be empty if the \"MS dimension\" equals 3. The entry at line " + lineNumber + " in file " + this.fileName_ + " is empty.");
                    }
                    if (adduct == null || adductCategorized == null) {
                        throw new AlexTargetlistParserException("The \"Adduct\" column must not be empty. The entry at line " + lineNumber + " in file " + this.fileName_ + " is empty.");
                    }
                    if (id == null) {
                        throw new AlexTargetlistParserException("The \"Lipid ID\" column must not be empty. The entry at line " + lineNumber + " in file " + this.fileName_ + " is empty.");
                    }
                    if (category == null) {
                        throw new AlexTargetlistParserException("The \"Lipid category\" column must not be empty. The entry at line " + lineNumber + " in file " + this.fileName_ + " is empty.");
                    }
                    if (charge < 1) {
                        throw new AlexTargetlistParserException("An entry in \"Lipid category\" must be contain a higher integer value than 0. The entry at line " + lineNumber + " in file " + this.fileName_ + " does not.");
                    }
                    if (formula == null || formulaCategorized == null) {
                        throw new AlexTargetlistParserException("The \"Sum formula from lipid species\" column must not be empty. The entry at line " + lineNumber + " in file " + this.fileName_ + " is empty.");
                    }
                    for (String element : adductCategorized.keySet()) {
                        int amount = 0;
                        if (formulaCategorized.containsKey(element)) {
                            amount = (Integer)formulaCategorized.get(element);
                        }
                        if ((amount -= ((Integer)adductCategorized.get(element)).intValue()) != 0) {
                            formulaCategorized.put(element, amount);
                            continue;
                        }
                        if (!formulaCategorized.containsKey(element)) continue;
                        formulaCategorized.remove(element);
                    }
                    TargetlistEntry entry = new TargetlistEntry(detector, polarity, msLevel, mz, fragment, structure, species, molecularSpecies, lipidClass, ms2Precursor, ms2Activation, ms3Precursor, ms3Activation, adduct, StaticUtils.getFormulaInHillNotation(adductCategorized, true), id, category, conflicts, charge, carbonNumber, dbNumber, ohNumber, sumComposition, StaticUtils.getFormulaInHillNotation(formulaCategorized, true), formula, fragmentCarbonNumber, fragmentDbNumber, fragmentOhNumber, fragmentSumComposition, fragmentFormula);
                    Vector<TargetlistEntry> entries = new Vector<TargetlistEntry>();
                    if (this.results_.containsKey(msLevel)) {
                        entries = this.results_.get(msLevel);
                    }
                    entries.add(entry);
                    this.results_.put(msLevel, entries);
                    continue;
                }
                if (!line.contains(POLARITY_COLUMN) || !line.contains(MS_LEVEL_COLUMN) || !line.contains(MZ_COLUMN) || !line.contains(LIPID_CLASS_COLUMN) || !line.contains(ADDUCT_COLUMN) || !line.contains(CHARGE_COLUMN) || !line.contains(FORMULA_COLUMN)) continue;
                String[] columns = line.split("\t");
                for (int columnNr = 0; columnNr != columns.length; ++columnNr) {
                    if (columns[columnNr].equalsIgnoreCase(DETECTOR_COLUMN)) {
                        detectorColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(POLARITY_COLUMN)) {
                        polarityColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(MS_LEVEL_COLUMN)) {
                        msLevelColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(MZ_COLUMN)) {
                        mzColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(FRAGMENT_COLUMN)) {
                        fragmentColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(STRUCTURE_COLUMN)) {
                        structureColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(SPECIES_COLUMN)) {
                        speciesColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(MOLECULAR_SPECIES_COLUMN)) {
                        molecularSpeciesColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(LIPID_CLASS_COLUMN)) {
                        classColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(MS2_PRECURSOR_COLUMN)) {
                        ms2PrecursorColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(MS2_ACTIVATION_COLUMN)) {
                        ms2ActivationColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(MS3_PRECURSOR_COLUMN)) {
                        ms3PrecursorColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(MS3_ACTIVATION_COLUMN)) {
                        ms3ActivationColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(ADDUCT_COLUMN)) {
                        adductColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(ID_COLUMN)) {
                        idColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(CATEGORY_COLUMN)) {
                        categoryColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(CONFLICTS_COLUMN)) {
                        conflictsColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(CHARGE_COLUMN)) {
                        chargeColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(CARBON_NUMBER_COLUMN)) {
                        carbonNumberColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(DB_NUMBER_COLUMN)) {
                        dbNumberColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(OH_NUMBER_COLUMN)) {
                        ohNumberColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(SUM_COMPOSITION_COLUMN)) {
                        sumCompositionColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(FORMULA_COLUMN)) {
                        formulaColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(FRAGMENT_CARBON_NUMBER_COLUMN)) {
                        fragmentCarbonNumberColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(FRAGMENT_DB_NUMBER_COLUMN)) {
                        fragmentDbNumberColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(FRAGMENT_OH_NUMBER_COLUMN)) {
                        fragmentOhNumberColumn = columnNr;
                        continue;
                    }
                    if (columns[columnNr].equalsIgnoreCase(FRAGMENT_SUM_COMPOSITION_COLUMN)) {
                        fragmentSumCompositionColumn = columnNr;
                        continue;
                    }
                    if (!columns[columnNr].equalsIgnoreCase(FRAGMENT_FORMULA_COLUMN) && !columns[columnNr].startsWith(FRAGMENT_FORMULA_COLUMN_PARTIAL)) continue;
                    fragmentFormulaColumn = columnNr;
                }
                headerLineFound = true;
            }
        }
        catch (IOException iox) {
            throw new AlexTargetlistParserException(iox);
        }
        catch (ChemicalFormulaException | HydroxylationEncodingException e) {
            throw new AlexTargetlistParserException(e);
        }
        catch (AlexTargetlistParserException alx) {
            throw alx;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private int parseIntegerEntry(String entry, String columnName, int lineNumber) throws AlexTargetlistParserException {
        try {
            return Integer.parseInt(entry);
        }
        catch (NumberFormatException nfx) {
            throw new AlexTargetlistParserException("Entries in the column \"" + columnName + "\" must be integer format. The one at line " + lineNumber + " in file " + this.fileName_ + " is not!");
        }
    }

    private double parseDoubleEntry(String entry, String columnName, int lineNumber) throws AlexTargetlistParserException {
        try {
            return Double.parseDouble(entry);
        }
        catch (NumberFormatException nfx) {
            throw new AlexTargetlistParserException("Entries in the column \"" + columnName + "\" must be double format. The one at line " + lineNumber + " in file " + this.fileName_ + " is not!");
        }
    }

    private String parseChemicalFormula(ElementConfigParser parser, String formula, String columnName, int lineNumber) throws AlexTargetlistParserException {
        String formulaString = new String(formula);
        if (formulaString.indexOf("_") != -1) {
            formulaString = formulaString.substring(0, formulaString.indexOf("_"));
        }
        if (formulaString.contains("-")) {
            throw new AlexTargetlistParserException("The formula " + formula + " must not contain any negative values! Affected is column \"" + columnName + "\" at line " + lineNumber + " in file " + this.fileName_ + ".");
        }
        char[] formulaChars = formulaString.toCharArray();
        String formulaToCheck = "";
        boolean isPreviousDigit = false;
        for (int i = 0; i != formulaChars.length; ++i) {
            char currentChar = formulaChars[i];
            if (isPreviousDigit && !Character.isDigit(currentChar)) {
                formulaToCheck = formulaToCheck + " ";
            }
            if (currentChar == '[') {
                boolean isoFound = false;
                for (String iso : this.isoLookup_.keySet()) {
                    if (i + iso.length() - 1 >= formulaChars.length || !formulaString.substring(i, i + iso.length()).equalsIgnoreCase(iso)) continue;
                    isoFound = true;
                    formulaToCheck = formulaToCheck + this.isoLookup_.get(iso);
                    i += iso.length() - 1;
                    break;
                }
                if (!isoFound) {
                    throw new AlexTargetlistParserException("The formula \"" + formula + "\" contains an istope that is not defined yet. Affected is column \"" + columnName + "\" at line " + lineNumber + " in file " + this.fileName_ + ".");
                }
            } else {
                formulaToCheck = formulaToCheck + String.valueOf(currentChar);
            }
            if ((isPreviousDigit = Character.isDigit(currentChar)) || currentChar == ' ' || i + 1 >= formulaChars.length || !Character.isUpperCase(formulaChars[i + 1]) && formulaChars[i + 1] != '[') continue;
            formulaToCheck = formulaToCheck + " ";
        }
        try {
            parser.calculateTheoreticalMass(formulaToCheck, false);
            return formulaToCheck;
        }
        catch (SpectrummillParserException spx) {
            throw new AlexTargetlistParserException(spx.getMessage() + " Affected is column \"" + columnName + "\" at line " + lineNumber + " in file " + this.fileName_ + ".");
        }
    }

    public Hashtable<Integer, Vector<TargetlistEntry>> getResults() {
        return this.results_;
    }
}

