/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.alex123.vos;

import at.tugraz.genome.lda.exception.AlexTargetlistParserException;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.QuantVO;
import java.util.Hashtable;
import java.util.Vector;

public class TargetlistEntry
extends QuantVO {
    private String originalClassName_;
    private String detector_ = null;
    private String polarity_ = null;
    private int msLevel_ = -1;
    private String fragment_ = null;
    private String structure_ = null;
    private String species_ = null;
    private String originalMolecularSpecies_ = null;
    private String molecularSpecies_ = null;
    private String ms2Precursor_ = null;
    private String ms2Activation_ = null;
    private String ms3Precursor_ = null;
    private String ms3Activation_ = null;
    private String id_ = null;
    private String category_ = null;
    private String conflicts_ = null;
    private int carbonNumber_ = -1;
    private int dbNumber_ = -1;
    private String sumComposition_ = null;
    private String originalSumFormula_ = null;
    private int fragmentCarbonNumber_ = -1;
    private int fragmentDbNumber_ = -1;
    private int fragmentOhNumber_ = -1;
    private String fragmentSumComposition_ = null;
    private String fragmentFormula_ = null;
    private boolean alex123FragmentsForClass_ = false;
    private Hashtable<Integer, Hashtable<String, Hashtable<String, TargetlistEntry>>> msnFragments_;

    public TargetlistEntry(String detector, String polarity, int msLevel, double mz, String fragment, String structure, String species, String molecularSpecies, String lipidClass, String ms2Precursor, String ms2Activation, String ms3Precursor, String ms3Activation, String adduct, String adductFormula, String id, String category, String conflicts, int charge, int carbonNumber, int dbNumber, int ohNumber, String sumComposition, String formula, String originalSumFormula, int fragmentCarbonNumber, int fragmentDbNumber, int fragmentOhNumber, String fragmentSumComposition, String fragmentFormula) throws AlexTargetlistParserException, HydroxylationEncodingException {
        super(lipidClass, species, -1, ohNumber, formula, mz, charge, adduct, adductFormula, -1.0f, 0.0f, 0.0f, new Vector<Double>(), new Vector<Double>(), 0, "");
        this.originalClassName_ = lipidClass;
        this.detector_ = detector;
        this.polarity_ = polarity;
        this.msLevel_ = msLevel;
        this.fragment_ = fragment;
        this.structure_ = structure;
        this.species_ = species;
        this.originalMolecularSpecies_ = molecularSpecies;
        try {
            Object[] ldaEncoding = StaticUtils.translateAlexNomenclatureToLDA(this.originalClassName_, this.species_, this.originalMolecularSpecies_);
            this.analyteClass_ = (String)ldaEncoding[0];
            FattyAcidVO speciesVO = (FattyAcidVO)ldaEncoding[1];
            this.prefixOrName_ = speciesVO.getPrefix();
            this.carbons_ = speciesVO.getcAtoms();
            this.dbs_ = speciesVO.getDoubleBonds();
            this.molecularSpecies_ = (String)ldaEncoding[2];
        }
        catch (LipidCombinameEncodingException e) {
            throw new AlexTargetlistParserException(e);
        }
        this.ms2Precursor_ = ms2Precursor;
        this.ms2Activation_ = ms2Activation;
        this.ms3Precursor_ = ms3Precursor;
        this.ms3Activation_ = ms3Activation;
        this.id_ = id;
        this.category_ = category;
        this.conflicts_ = conflicts;
        this.carbonNumber_ = carbonNumber;
        this.dbNumber_ = dbNumber;
        this.sumComposition_ = sumComposition;
        this.originalSumFormula_ = originalSumFormula;
        this.fragmentCarbonNumber_ = fragmentCarbonNumber;
        this.fragmentDbNumber_ = fragmentDbNumber;
        this.fragmentOhNumber_ = fragmentOhNumber;
        this.fragmentSumComposition_ = fragmentSumComposition;
        this.fragmentFormula_ = fragmentFormula;
        this.msnFragments_ = new Hashtable();
        this.alex123FragmentsForClass_ = false;
    }

    public String getOriginalClassName() {
        return this.originalClassName_;
    }

    public String getDetector() {
        return this.detector_;
    }

    public String getPolarity() {
        return this.polarity_;
    }

    public int getMsLevel() {
        return this.msLevel_;
    }

    public void setMsLevel_(int msLevel) {
        this.msLevel_ = msLevel;
    }

    public String getFragment() {
        return this.fragment_;
    }

    public String getStructure() {
        return this.structure_;
    }

    public String getSpecies() {
        return this.species_;
    }

    public String getMolecularSpecies() {
        return this.molecularSpecies_;
    }

    public String getOriginalMolecularSpecies() {
        return this.originalMolecularSpecies_;
    }

    public void setOriginalMolecularSpecies(String originalMolecularSpecies) throws AlexTargetlistParserException {
        this.originalMolecularSpecies_ = originalMolecularSpecies;
        try {
            Object[] ldaEncoding = StaticUtils.translateAlexNomenclatureToLDA(this.originalClassName_, this.species_, this.originalMolecularSpecies_);
            this.analyteClass_ = (String)ldaEncoding[0];
            FattyAcidVO speciesVO = (FattyAcidVO)ldaEncoding[1];
            this.prefixOrName_ = speciesVO.getPrefix();
            this.carbons_ = speciesVO.getcAtoms();
            this.dbs_ = speciesVO.getDoubleBonds();
            this.molecularSpecies_ = (String)ldaEncoding[2];
        }
        catch (LipidCombinameEncodingException e) {
            throw new AlexTargetlistParserException(e);
        }
    }

    public String getMs2Precursor() {
        return this.ms2Precursor_;
    }

    public void setMs2Precursor(String ms2Precursor) {
        this.ms2Precursor_ = ms2Precursor;
    }

    public String getMs2Activation() {
        return this.ms2Activation_;
    }

    public void setMs2Activation(String ms2Activation) {
        this.ms2Activation_ = ms2Activation;
    }

    public String getMs3Precursor() {
        return this.ms3Precursor_;
    }

    public void setMs3Precursor(String ms3Precursor) {
        this.ms3Precursor_ = ms3Precursor;
    }

    public String getMs3Activation() {
        return this.ms3Activation_;
    }

    public void setMs3Activation(String ms3Activation) {
        this.ms3Activation_ = ms3Activation;
    }

    public String getId() {
        return this.id_;
    }

    public String getCategory() {
        return this.category_;
    }

    public String getConflicts() {
        return this.conflicts_;
    }

    public int getCarbonNumber() {
        return this.carbonNumber_;
    }

    public int getDbNumber() {
        return this.dbNumber_;
    }

    public String getSumComposition() {
        return this.sumComposition_;
    }

    public String getOriginalSumFormula() {
        return this.originalSumFormula_;
    }

    public int getFragmentCarbonNumber() {
        return this.fragmentCarbonNumber_;
    }

    public int getFragmentDbNumber() {
        return this.fragmentDbNumber_;
    }

    public int getFragmentOhNumber() {
        return this.fragmentOhNumber_;
    }

    public String getFragmentSumComposition() {
        return this.fragmentSumComposition_;
    }

    public String getFragmentFormula() {
        return this.fragmentFormula_;
    }

    public void addFragment(TargetlistEntry fragment) {
        Hashtable<Object, Object> fragments = new Hashtable();
        if (this.msnFragments_.containsKey(fragment.getMsLevel())) {
            fragments = this.msnFragments_.get(fragment.getMsLevel());
        }
        Hashtable sameFragmentDiffMolSpecies = new Hashtable();
        if (fragments.containsKey(fragment.getFragment())) {
            sameFragmentDiffMolSpecies = (Hashtable)fragments.get(fragment.getFragment());
        }
        if (sameFragmentDiffMolSpecies.containsKey(fragment.getMolecularSpecies())) {
            System.out.println("The fragment " + fragment.getFragment() + " with the adduct \"" + fragment.getModName() + "\" is defined more than once for the species \"" + this.species_ + "\" and molecular species \"" + fragment.getMolecularSpecies() + "\"!");
            return;
        }
        sameFragmentDiffMolSpecies.put(fragment.getMolecularSpecies(), fragment);
        fragments.put(fragment.getFragment(), sameFragmentDiffMolSpecies);
        this.msnFragments_.put(fragment.getMsLevel(), fragments);
    }

    public void setTimeConstraints(float retTime, float minusTime, float plusTime) {
        this.isobaricRetTime_ = retTime;
        this.isobaricMinusTime_ = minusTime;
        this.isobaricPlusTime_ = plusTime;
    }

    public void setDistributionValues(Vector<Double> mustMatchProbabs, Vector<Double> probabs, int negativeStartValue) {
        this.mustMatchProbabs_ = mustMatchProbabs;
        this.probabs_ = probabs;
        this.negStartValue_ = negativeStartValue;
    }

    public Hashtable<Integer, Hashtable<String, Hashtable<String, TargetlistEntry>>> getMsnFragments() {
        return this.msnFragments_;
    }

    public boolean hasAlex123FragmentsForClass() {
        return this.alex123FragmentsForClass_;
    }

    public void setAlex123FragmentsForClass(boolean alex123FragmentsForClass) {
        this.alex123FragmentsForClass_ = alex123FragmentsForClass;
    }

    @Override
    protected Object[] splitInCarbonNumberAndPrefix(String analyteClass, String analyteName) {
        Object[] prefixAndC = new Object[]{"", 0};
        return prefixAndC;
    }

    public Hashtable<String, String> getMolSpeciesLookup() {
        Hashtable<String, String> molSpecies = new Hashtable<String, String>();
        for (Hashtable<String, Hashtable<String, TargetlistEntry>> targetsOfLevel : this.msnFragments_.values()) {
            for (Hashtable<String, TargetlistEntry> targetsOfFragment : targetsOfLevel.values()) {
                for (String molName : targetsOfFragment.keySet()) {
                    if (molSpecies.containsKey(molName)) continue;
                    molSpecies.put(molName, targetsOfFragment.get(molName).getOriginalMolecularSpecies());
                }
            }
        }
        return molSpecies;
    }
}

