/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.analysis;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.ExcelInputFileException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.stream.Stream;
import javax.swing.JFrame;
import org.dhatim.fastexcel.reader.ReadableWorkbook;
import org.dhatim.fastexcel.reader.Sheet;

public class ClassNamesExtractor {
    protected Vector<File> resultFiles_;
    protected Vector<String> lipidClasses_;
    private Hashtable<String, String> classesHash_;

    public ClassNamesExtractor(Vector<File> resultFiles) {
        this.resultFiles_ = resultFiles;
    }

    public void parseInput(int statisticsViewMode, boolean combineOxWithNonOx) throws ExcelInputFileException, LipidCombinameEncodingException {
        this.extractInformation(statisticsViewMode, combineOxWithNonOx);
    }

    protected void extractInformation(int statisticsViewMode, boolean combineOxWithNonOx) throws ExcelInputFileException, LipidCombinameEncodingException {
        this.lipidClasses_ = new Vector();
        this.classesHash_ = new Hashtable();
        for (int i = 0; i != this.resultFiles_.size(); ++i) {
            File resultFile = this.resultFiles_.get(i);
            this.parseResultFile(resultFile);
        }
    }

    protected void parseResultFile(File resultFile) throws ExcelInputFileException, LipidCombinameEncodingException {
        if (!resultFile.getAbsolutePath().endsWith(".xlsx")) {
            new WarningMessage(new JFrame(), "ERROR", "The specified file format is not supported!");
            throw new ExcelInputFileException("The specified file format is not supported!");
        }
        this.parseResultFileFastExcel(resultFile);
    }

    protected void parseResultFileFastExcel(File resultFile) throws ExcelInputFileException, LipidCombinameEncodingException {
        try (FileInputStream is = new FileInputStream(resultFile);
             ReadableWorkbook wb = new ReadableWorkbook(is);
             Stream<Sheet> sheets = wb.getSheets();){
            sheets.filter(s -> !s.getName().equals("About") && !s.getName().endsWith(" - Omega") && !s.getName().endsWith(" - Overview") && !s.getName().endsWith(" - MSn")).forEach(s -> {
                if (!this.classesHash_.containsKey(s.getName())) {
                    this.lipidClasses_.add(s.getName());
                    this.classesHash_.put(s.getName(), s.getName());
                }
            });
        }
        catch (IOException ex) {
            ex.printStackTrace();
            new WarningMessage(new JFrame(), "ERROR", ex.getMessage());
            throw new ExcelInputFileException(ex);
        }
    }

    public Vector<String> getLipidClasses() {
        return this.lipidClasses_;
    }
}

