/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.analysis;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.analysis.SampleLookup;
import at.tugraz.genome.lda.analysis.exception.CalculationNotPossibleException;
import at.tugraz.genome.lda.utils.DoubleCalculator;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.ResultAreaVO;
import at.tugraz.genome.lda.vos.ResultCompVO;
import at.tugraz.genome.lda.vos.ResultDisplaySettingsVO;
import at.tugraz.genome.maspectras.graphics.MacOSResizer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class LipidomicsHeatMap {
    public static final int NUMBER_OF_COLOR_GROUPS = 9;
    private Color borderColor_ = new Color(0, 0, 0);
    protected int defaultNrOfGradientPixels_ = 10000;
    protected static final Color DEFAULT_COLOR0 = new Color(0, 32, 180);
    protected static final Color DEFAULT_COLOR1 = new Color(0, 153, 102);
    protected static final Color DEFAULT_COLOR2 = new Color(255, 255, 0);
    protected static final Color DEFAULT_COLOR3 = new Color(255, 255, 0);
    protected static final Color DEFAULT_COLOR4 = new Color(255, 0, 0);
    private static final String LABEL_DB_CONFLICT = "\u03c9-DB assignment conflict";
    private static final String LABEL_DB_ASSIGNED = "\u03c9-DB assigned";
    protected int heatRectWidth_ = 20;
    protected int heatRectHeight_ = 10;
    protected int borderCorrection_ = 1;
    protected int annotationSpace_ = 200;
    protected int sampleSpace_ = 80;
    protected int pictureIndent_ = 5;
    protected int gradientHeight_ = 10;
    protected int analyteNameSpace_ = 3;
    protected int analyteTextWidthMax_ = 0;
    protected int sampleNameStart_ = 0;
    protected int doubleBondTextWidthMax_ = 0;
    int partCorrection_ = 0;
    protected Vector<String> sampleNames_;
    protected ArrayList<String> analyteNames_;
    protected BufferedImage gradient_;
    protected transient BufferedImage expressionImage_;
    protected float lowerValue_ = 0.2f;
    protected float upperValue_ = 5.0f;
    protected SampleLookup lookup_;
    private ArrayList<HeatMapRow> heatMapRows_;
    private boolean isMarkDoublePeaks_;
    protected boolean ignorePlatformSettings_;
    public static final Color ATTENTION_COLOR_DOUBLE_PEAK = Color.YELLOW;
    public static final Color ATTENTION_COLOR_NOT_ALL_MODS = new Color(51, 153, 255);
    public static final Color ATTENTION_DOUBLE_AND_NOT_ALL_MODS = new Color(204, 153, 255);

    public LipidomicsHeatMap(Hashtable<String, Hashtable<String, ResultCompVO>> resultsOfOneGroup, Vector<String> experimentNames, SampleLookup lookup, Vector<String> moleculeNames, int maxIsotope, ResultDisplaySettingsVO settingVO, boolean isMarkDoublePeaks) throws CalculationNotPossibleException {
        this.isMarkDoublePeaks_ = isMarkDoublePeaks;
        this.sampleNames_ = experimentNames;
        this.heatMapRows_ = this.computeRows(resultsOfOneGroup, moleculeNames, maxIsotope, settingVO);
        this.analyteNames_ = this.computeAnalyteNames();
        this.gradient_ = this.createThreeColGradientImage(this.defaultNrOfGradientPixels_);
        this.lookup_ = lookup;
        this.ignorePlatformSettings_ = false;
    }

    private ArrayList<String> computeAnalyteNames() {
        ArrayList<String> analyteNames = new ArrayList<String>();
        for (HeatMapRow row : this.heatMapRows_) {
            analyteNames.add(row.getAnalyteName());
        }
        return analyteNames;
    }

    private ArrayList<HeatMapRow> computeRows(Hashtable<String, Hashtable<String, ResultCompVO>> resultsOfOneGroup, Vector<String> moleculeNames, int maxIsotope, ResultDisplaySettingsVO settingVO) throws CalculationNotPossibleException {
        ArrayList<HeatMapRow> rows = new ArrayList<HeatMapRow>();
        for (int j = 0; j != moleculeNames.size(); ++j) {
            String sumCompositionName = moleculeNames.get(j);
            Hashtable<String, ResultCompVO> resultsOfOneSumComp = resultsOfOneGroup.get(sumCompositionName);
            Hashtable<String, ArrayList<Double>> medianValues = this.computeMedianAreaAtMolSpeciesLevel(resultsOfOneSumComp, settingVO, maxIsotope);
            ResultCompVO dummyCompVO = new ResultCompVO();
            HeatMapRow rowSumComp = this.computeHeatMapRow("Sum composition", medianValues, sumCompositionName, settingVO, resultsOfOneSumComp, maxIsotope, dummyCompVO);
            rows.add(rowSumComp);
            for (String name : medianValues.keySet()) {
                if (name.equals("Sum composition")) continue;
                HeatMapRow row = this.computeHeatMapRow(name, medianValues, sumCompositionName, settingVO, resultsOfOneSumComp, maxIsotope, dummyCompVO);
                row.setAttentionValues(rowSumComp.getAttentionValues());
                rows.add(row);
            }
        }
        return rows;
    }

    private HeatMapRow computeHeatMapRow(String name, Hashtable<String, ArrayList<Double>> medianValues, String sumCompositionName, ResultDisplaySettingsVO settingVO, Hashtable<String, ResultCompVO> resultsOfOneSumComp, int maxIsotope, ResultCompVO dummyCompVO) {
        ArrayList<Double> median = medianValues.get(name);
        HeatMapRow row = new HeatMapRow(sumCompositionName, name, this.computePreferredUnit(median.get(0), settingVO));
        Hashtable<String, Color> attentionValues = new Hashtable<String, Color>();
        for (int i = 0; i != this.sampleNames_.size(); ++i) {
            String experiment = this.sampleNames_.get(i);
            double relativeValue = -1.0;
            if (this.isReasonableIdentification(name, resultsOfOneSumComp, experiment)) {
                ResultCompVO compVO = resultsOfOneSumComp.get(experiment);
                compVO.addRelativeMedianArea(name, median);
                row.addCompVO(experiment, compVO);
                if (name.equals("Sum composition") && this.isMarkDoublePeaks_) {
                    this.computeAttentionValuesRow(attentionValues, experiment, compVO, maxIsotope, sumCompositionName);
                } else if (!name.equals("Sum composition")) {
                    row.addMolecularSpeciesContributionOfAllMods(experiment, compVO.getResultMolecule().getMolecularSpeciesContributionOfAllMods(name));
                }
                relativeValue = this.computeRelativeValue(compVO, maxIsotope, settingVO, name, row.getMolecularSpeciesContribution(experiment));
                row.addRelativeValue(experiment, relativeValue);
                continue;
            }
            dummyCompVO.addRelativeMedianArea(name, median);
            row.addCompVO(this.sampleNames_.get(i), dummyCompVO);
            row.addRelativeValue(this.sampleNames_.get(i), relativeValue);
        }
        if (name.equals("Sum composition")) {
            row.setAttentionValues(attentionValues);
        }
        return row;
    }

    private boolean isReasonableIdentification(String name, Hashtable<String, ResultCompVO> resultsOfOneSumComp, String experiment) {
        if (resultsOfOneSumComp.containsKey(experiment)) {
            if (name.equals("Sum composition")) {
                return true;
            }
            if (resultsOfOneSumComp.get(experiment).getResultMolecule() == null) {
                return false;
            }
            return !resultsOfOneSumComp.get(experiment).getResultMolecule().getMolecularSpeciesContributionOfAllMods(name).isInfinite() && !resultsOfOneSumComp.get(experiment).getResultMolecule().getMolecularSpeciesContributionOfAllMods(name).isNaN();
        }
        return false;
    }

    private Hashtable<String, ArrayList<Double>> computeMedianAreaAtMolSpeciesLevel(Hashtable<String, ResultCompVO> result, ResultDisplaySettingsVO settingVO, int maxIsotope) throws CalculationNotPossibleException {
        Hashtable<String, ArrayList<Double>> medianValues = new Hashtable<String, ArrayList<Double>>();
        if (result == null) {
            return medianValues;
        }
        for (int k = 0; k != this.computeMaxApplicableIso(maxIsotope, settingVO, result); ++k) {
            Hashtable<String, ArrayList<Double>> areaList = this.computeAreaListOfIsotope(result, settingVO, k);
            for (String name : areaList.keySet()) {
                ArrayList<Double> areas = areaList.get(name);
                if (!medianValues.containsKey(name)) {
                    medianValues.put(name, new ArrayList());
                }
                medianValues.get(name).add(DoubleCalculator.median(areas));
            }
        }
        return medianValues;
    }

    private Hashtable<String, ArrayList<Double>> computeAreaListOfIsotope(Hashtable<String, ResultCompVO> result, ResultDisplaySettingsVO settingVO, int k) throws CalculationNotPossibleException {
        Hashtable<String, ArrayList<Double>> values = new Hashtable<String, ArrayList<Double>>();
        values.put("Sum composition", new ArrayList());
        for (int i = 0; i != this.sampleNames_.size(); ++i) {
            ResultCompVO compVO;
            double value;
            if (!result.containsKey(this.sampleNames_.get(i)) || !((value = (compVO = result.get(this.sampleNames_.get(i))).getArea(k, settingVO)) > 0.0)) continue;
            values.get("Sum composition").add(value);
            ResultAreaVO areaVO = compVO.getResultMolecule();
            if (areaVO == null) continue;
            Set<String> names = areaVO.getAllMolecularSpeciesNamesHumanReadable();
            for (String name : names) {
                if (!values.containsKey(name)) {
                    values.put(name, new ArrayList());
                }
                values.get(name).add(value * areaVO.getMolecularSpeciesContributionOfAllMods(name));
            }
        }
        return values;
    }

    private Double computeRelativeValue(ResultCompVO compVO, int maxIsotope, ResultDisplaySettingsVO settingVO, String molecularSpecies, double molecularSpeciesContribution) {
        double relativeValue = compVO.getRelativeValue(compVO.getAvailableIsotopeNr(maxIsotope), settingVO, molecularSpecies, molecularSpeciesContribution);
        if (Double.isInfinite(relativeValue) || Double.isNaN(relativeValue)) {
            relativeValue = -1.0;
        }
        return relativeValue;
    }

    private void computeAttentionValuesRow(Hashtable<String, Color> attentionValues, String experimentName, ResultCompVO compVO, int maxIsotope, String moleculeName) {
        if (!compVO.getMoreThanOnePeak(compVO.getAvailableIsotopeNr(maxIsotope)) && compVO.hasAllModsFound()) {
            return;
        }
        Color color = null;
        if (compVO.getMoreThanOnePeak(compVO.getAvailableIsotopeNr(maxIsotope)) && !compVO.hasAllModsFound()) {
            color = ATTENTION_DOUBLE_AND_NOT_ALL_MODS;
        } else if (compVO.getMoreThanOnePeak(compVO.getAvailableIsotopeNr(maxIsotope))) {
            color = ATTENTION_COLOR_DOUBLE_PEAK;
        } else if (!compVO.hasAllModsFound()) {
            color = ATTENTION_COLOR_NOT_ALL_MODS;
        }
        attentionValues.put(experimentName, color);
    }

    private int computeMaxApplicableIso(int maxIsotope, ResultDisplaySettingsVO settingVO, Hashtable<String, ResultCompVO> result) {
        int maxApplicableIso = maxIsotope + 1;
        if (!settingVO.getType().equalsIgnoreCase("relative to measured class amount") && !settingVO.getType().equalsIgnoreCase("relative to total amount")) {
            maxApplicableIso = StaticUtils.getMaxApplicableIsotope(result, maxIsotope);
        }
        return maxApplicableIso;
    }

    private String computePreferredUnit(double median, ResultDisplaySettingsVO settingVO) {
        String unit = "";
        if (!Double.isInfinite(median) && !Double.isNaN(median)) {
            if (!(settingVO.getType().equalsIgnoreCase("relative value") || settingVO.getType().equalsIgnoreCase("relative to base peak") || settingVO.getType().equalsIgnoreCase("relative to measured class amount") || settingVO.getType().equalsIgnoreCase("relative to highest total peak") || settingVO.getType().equalsIgnoreCase("relative to total amount"))) {
                unit = StaticUtils.extractPreferredUnit(median);
            } else if (settingVO.getType().equalsIgnoreCase("relative to base peak") || settingVO.getType().equalsIgnoreCase("relative to measured class amount") || settingVO.getType().equalsIgnoreCase("relative to highest total peak") || settingVO.getType().equalsIgnoreCase("relative to total amount")) {
                unit = LipidomicsHeatMap.extractPercentUnit(median);
            }
        }
        return unit;
    }

    protected BufferedImage createThreeColGradientImage(int sizeX) {
        BufferedImage gradient = new BufferedImage(sizeX, 1, 5);
        Graphics2D graphics = gradient.createGraphics();
        GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, Color.green, sizeX / 2, 0.0f, Color.BLACK);
        GradientPaint gp1 = new GradientPaint(sizeX / 2, 0.0f, Color.black, sizeX, 0.0f, Color.red);
        graphics.setPaint(gp0);
        graphics.drawRect(0, 0, sizeX / 2, 1);
        graphics.setPaint(gp1);
        graphics.drawRect(sizeX / 2, 0, sizeX / 2, 1);
        graphics.dispose();
        return gradient;
    }

    protected void paintHeader(Graphics2D expressionGraphics, int imageSizeX) {
        GradientPaint gp0 = new GradientPaint(this.pictureIndent_, 0.0f, Color.green, imageSizeX / 2, 0.0f, Color.black);
        GradientPaint gp1 = new GradientPaint(imageSizeX / 2, 0.0f, Color.black, imageSizeX - 2 * this.pictureIndent_, 0.0f, Color.red);
        int gradientYPosition = this.pictureIndent_;
        expressionGraphics.setPaint(gp0);
        expressionGraphics.fillRect(this.pictureIndent_, gradientYPosition, (imageSizeX - 2 * this.pictureIndent_) / 2, this.gradientHeight_);
        expressionGraphics.setPaint(gp1);
        expressionGraphics.fillRect(this.pictureIndent_ + (imageSizeX - 2 * this.pictureIndent_) / 2, gradientYPosition, (imageSizeX - 2 * this.pictureIndent_) / 2, this.gradientHeight_);
        String minText = String.valueOf(this.lowerValue_);
        String middleText = "1.0";
        String maxText = String.valueOf(this.upperValue_);
        Font descriptionFont = new Font("Dialog", 0, 8);
        expressionGraphics.setColor(this.getLegendColor());
        expressionGraphics.setFont(descriptionFont);
        FontMetrics descriptionFontMetrics = expressionGraphics.getFontMetrics();
        int textHeight = descriptionFontMetrics.getHeight();
        int textWidth = descriptionFontMetrics.stringWidth(minText);
        int textYPosition = gradientYPosition + this.gradientHeight_ + textHeight / 2 + 2;
        expressionGraphics.drawString(minText, this.pictureIndent_, textYPosition);
        textWidth = descriptionFontMetrics.stringWidth(middleText);
        expressionGraphics.drawString(middleText, imageSizeX / 2 - textWidth / 2, textYPosition);
        textWidth = descriptionFontMetrics.stringWidth(maxText);
        expressionGraphics.drawString(maxText, imageSizeX - this.pictureIndent_ - textWidth, textYPosition);
    }

    public BufferedImage createImage() {
        return this.createImage(null);
    }

    /*
     * WARNING - void declaration
     */
    public BufferedImage createImage(Graphics2D extGraphics) {
        int width;
        BufferedImage dummyImage = new BufferedImage(1000, 1000, 5);
        Font descriptionFont = new Font("Dialog", 0, 9);
        Graphics2D dummyGraphics = (Graphics2D)dummyImage.getGraphics();
        dummyGraphics.setFont(descriptionFont);
        FontMetrics descriptionFontMetrics = dummyGraphics.getFontMetrics();
        int textWidth = 0;
        for (String string : this.sampleNames_) {
            String toDisplay = this.getSampleNameToDisplay(string);
            width = descriptionFontMetrics.stringWidth(toDisplay);
            if (width <= textWidth) continue;
            textWidth = width;
        }
        int annotationWidth = 0;
        for (HeatMapRow row : this.heatMapRows_) {
            width = descriptionFontMetrics.stringWidth(row.getAnalyteName());
            if (width <= annotationWidth) continue;
            annotationWidth = width;
        }
        try {
            void var8_13;
            this.sampleNameStart_ = this.pictureIndent_ + this.gradientHeight_ + descriptionFontMetrics.getHeight();
            this.sampleSpace_ = textWidth + this.sampleNameStart_;
            this.annotationSpace_ = annotationWidth + 2 * this.pictureIndent_;
            int xcorrection = 0;
            int ycorrection = 0;
            int xSpaceForMap = this.heatRectWidth_ * this.sampleNames_.size() + this.borderCorrection_;
            int imageSizeX = xSpaceForMap + xcorrection + this.annotationSpace_ + 2 * this.pictureIndent_;
            this.expressionImage_ = new BufferedImage(imageSizeX, this.heatRectHeight_ * this.heatMapRows_.size() + this.borderCorrection_ + ycorrection + this.sampleSpace_ + 2 * this.pictureIndent_, 5);
            Graphics2D graphics2D = (Graphics2D)this.expressionImage_.getGraphics();
            if (extGraphics != null) {
                Graphics2D graphics2D2 = extGraphics;
            }
            var8_13.setColor(this.getBackgroundColor());
            var8_13.fillRect(0, 0, this.expressionImage_.getWidth(), this.expressionImage_.getHeight());
            this.paintHeader((Graphics2D)var8_13, imageSizeX - this.annotationSpace_);
            this.paintSampleNames((Graphics2D)var8_13, this.pictureIndent_, this.sampleSpace_);
            this.paintExpressionImage((Graphics2D)var8_13, this.pictureIndent_, this.sampleSpace_);
            this.paintAnalyteNames((Graphics2D)var8_13, this.pictureIndent_ + xSpaceForMap, this.sampleSpace_);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        return this.expressionImage_;
    }

    protected void paintSampleNames(Graphics2D expressionGraphics, int xoffset, int sampleSpace_) {
        Font bigFont = new Font("SansSerif", 0, 200);
        expressionGraphics.setFont(bigFont);
        FontMetrics fm2 = expressionGraphics.getFontMetrics();
        Font descriptionFont = new Font("Dialog", 0, 9);
        expressionGraphics.setColor(this.getLegendColor());
        expressionGraphics.setFont(descriptionFont);
        FontMetrics descriptionFontMetrics = expressionGraphics.getFontMetrics();
        int textHeight = descriptionFontMetrics.getHeight();
        double rotationAngle = -1.5707963267948966;
        if (!this.isOSMacAndJavaLookAndFeel()) {
            expressionGraphics.rotate(rotationAngle);
        }
        for (int i = 0; i != this.sampleNames_.size(); ++i) {
            String sampleName = this.sampleNames_.get(i);
            String toDisplay = this.getSampleNameToDisplay(sampleName);
            if (this.isOSMacAndJavaLookAndFeel()) {
                BufferedImage image = new BufferedImage(fm2.stringWidth(toDisplay), fm2.getHeight(), 2);
                Graphics2D g22 = (Graphics2D)image.getGraphics();
                g22.setColor(this.getLegendColor());
                g22.setFont(bigFont);
                g22.drawString(toDisplay, 0, fm2.getAscent());
                int sw2 = fm2.stringWidth(toDisplay);
                int swXExtension2 = (int)((double)sw2 * Math.cos(-rotationAngle));
                int swYExtension2 = (int)((double)sw2 * Math.sin(-rotationAngle));
                int shYExtension2 = (int)((double)fm2.getHeight() * Math.cos(-rotationAngle));
                int shXExtension2 = (int)((double)fm2.getHeight() * Math.sin(-rotationAngle));
                BufferedImage image2 = new BufferedImage(swXExtension2 + shXExtension2, swYExtension2 + shYExtension2, 2);
                Graphics2D g23 = (Graphics2D)image2.getGraphics();
                g23.rotate(rotationAngle);
                boolean normalStringXCoordinate2 = false;
                int normalStringYCoordinate2 = swYExtension2;
                double coordinateRadius2 = Math.sqrt(Math.pow(0.0, 2.0) + Math.pow(normalStringYCoordinate2, 2.0));
                double angle2 = Math.atan((double)normalStringYCoordinate2 / (double)normalStringXCoordinate2);
                g23.drawImage((Image)image, (int)(coordinateRadius2 * Math.cos(angle2 - rotationAngle)), (int)(coordinateRadius2 * Math.sin(angle2 - rotationAngle)), null);
                g23.rotate(-rotationAngle);
                image2 = MacOSResizer.resizeTrick(image2, descriptionFontMetrics.getHeight(), descriptionFontMetrics.stringWidth(toDisplay));
                expressionGraphics.drawImage((Image)image2, this.heatRectWidth_ * i + this.heatRectWidth_ / 2, sampleSpace_ - 2 - descriptionFontMetrics.stringWidth(toDisplay), null);
                continue;
            }
            expressionGraphics.drawString(toDisplay, -sampleSpace_ + 2, this.heatRectWidth_ * i + this.heatRectWidth_ / 2 + textHeight / 2 + xoffset);
        }
        if (!this.isOSMacAndJavaLookAndFeel()) {
            expressionGraphics.rotate(-rotationAngle);
        }
    }

    protected void paintExpressionImage(Graphics2D expressionGraphics, int xoffset, int yoffset) {
        for (int i = 0; i < this.heatMapRows_.size(); ++i) {
            this.heatMapRows_.get(i).paintExpressionRow(expressionGraphics, xoffset, yoffset, i);
        }
    }

    protected void paintAnalyteNames(Graphics2D expressionGraphics, int xoffset, int yoffset) {
        Font descriptionFont = new Font("Dialog", 0, 9);
        expressionGraphics.setColor(this.getLegendColor());
        expressionGraphics.setFont(descriptionFont);
        FontMetrics descriptionFontMetrics = expressionGraphics.getFontMetrics();
        int textHeight = descriptionFontMetrics.getHeight();
        for (int i = 0; i < this.heatMapRows_.size(); ++i) {
            String analyteName = this.heatMapRows_.get(i).getAnalyteName();
            int textWidth = descriptionFontMetrics.stringWidth(analyteName);
            if (textWidth > this.analyteTextWidthMax_) {
                this.analyteTextWidthMax_ = textWidth;
            }
            expressionGraphics.drawString(analyteName, xoffset + this.analyteNameSpace_, this.heatRectHeight_ * i + 2 + yoffset + textHeight / 2);
        }
    }

    public void paintAttentionRectangle(Graphics2D g2, Color color, int row, int column, int xoffset, int yoffset) {
        this.heatMapRows_.get(row).paintAttentionRectangle(g2, color, row, column, xoffset, yoffset);
    }

    public Color getColorForCell(int cellRow, int cellColumn) {
        return new Color(this.getColorForValue(this.heatMapRows_.get(cellRow).getValue(this.sampleNames_.get(cellColumn))));
    }

    protected int getColorForValue(double value) {
        int rgb1 = 0;
        if (value > 1.0) {
            int coordinate = this.getCoordinateBigger1(value);
            rgb1 = this.gradient_.getRGB(coordinate, 0);
        } else if (value > 0.0) {
            int coordinate = this.getCoordinateSmaller1(value);
            rgb1 = this.gradient_.getRGB(coordinate, 0);
        } else {
            rgb1 = Color.gray.getRGB();
        }
        return rgb1;
    }

    public int getExpressionImageXStart() {
        return this.pictureIndent_;
    }

    public int getExpressionImageXEnd() {
        return this.pictureIndent_ + this.heatRectWidth_ * this.sampleNames_.size();
    }

    public int getExpressionImageYStart() {
        return this.sampleSpace_;
    }

    public int getExpressionImageYEnd() {
        return this.sampleSpace_ + this.heatRectHeight_ * this.analyteNames_.size();
    }

    public String getRowName(int x, int y) {
        String analyteName = null;
        if (this.getRowNameStart() <= x && x < this.getRowNameEnd() && this.getExpressionImageYStart() <= y && y < this.getExpressionImageYEnd()) {
            analyteName = this.analyteNames_.get(this.calculateYPosition(y));
        }
        return analyteName;
    }

    public int getRowNumber(int x, int y) {
        int rowNumber = -1;
        if (this.getRowNameStart() <= x && x < this.getRowNameEnd() && this.getExpressionImageYStart() <= y && y < this.getExpressionImageYEnd()) {
            rowNumber = this.calculateYPosition(y);
        }
        return rowNumber;
    }

    public int[] getCellPosition(int x, int y) {
        int[] cellPosition = new int[]{-1, -1};
        if (this.getExpressionImageXStart() <= x && x < this.getExpressionImageXEnd() && this.getExpressionImageYStart() <= y && y < this.getExpressionImageYEnd()) {
            cellPosition[0] = this.calculateXPosition(x);
            cellPosition[1] = this.calculateYPosition(y);
        }
        return cellPosition;
    }

    public Rectangle getRectangleForCell(int x, int y) {
        Rectangle rect = null;
        if (this.getExpressionImageXStart() <= x && x < this.getExpressionImageXEnd() && this.getExpressionImageYStart() <= y && y < this.getExpressionImageYEnd()) {
            int cellColumn = this.calculateXPosition(x);
            int cellRow = this.calculateYPosition(y);
            rect = this.getRectangleForCellByRowAndColumn(cellRow, cellColumn);
        }
        return rect;
    }

    public Rectangle getRectangleForCellByRowAndColumn(int cellRow, int cellColumn) {
        return new Rectangle(this.heatRectWidth_ * cellColumn + this.getExpressionImageXStart(), this.heatRectHeight_ * cellRow + this.getExpressionImageYStart(), this.heatRectWidth_, this.heatRectHeight_);
    }

    public int getRowNameStart() {
        return this.getExpressionImageXEnd() + this.analyteNameSpace_;
    }

    public int getRowNameEnd() {
        return this.getRowNameStart() + this.analyteTextWidthMax_;
    }

    public Rectangle getRectangleForRowNumber(int row) {
        Rectangle rect = null;
        if (row >= 0) {
            rect = new Rectangle(this.getRowNameStart(), this.heatRectHeight_ * row + this.getExpressionImageYStart(), this.analyteTextWidthMax_ + this.analyteNameSpace_, this.heatRectHeight_);
        }
        return rect;
    }

    private int calculateXPosition(int x) {
        return (x - this.getExpressionImageXStart()) / this.heatRectWidth_;
    }

    private int calculateYPosition(int y) {
        return (y - this.getExpressionImageYStart()) / this.heatRectHeight_;
    }

    public int getColumnNameStart() {
        return this.sampleNameStart_ - 2;
    }

    public int getColumnNameEnd() {
        return this.sampleSpace_ - 2;
    }

    public String getColumnName(int x, int y) {
        String sampleName = null;
        if (this.getExpressionImageXStart() <= x && x < this.getExpressionImageXEnd() && this.getColumnNameStart() <= y && y < this.getColumnNameEnd()) {
            sampleName = this.sampleNames_.get(this.calculateXPosition(x));
        }
        return sampleName;
    }

    public Rectangle getRectangleForColumnName(String columnName) {
        int columnPosition = -1;
        int count = 0;
        for (String name : this.sampleNames_) {
            if (columnName.equalsIgnoreCase(name)) {
                columnPosition = count;
                break;
            }
            ++count;
        }
        Rectangle rect = null;
        if (columnPosition >= 0) {
            rect = new Rectangle(this.heatRectWidth_ * columnPosition + this.getExpressionImageXStart(), this.getColumnNameStart(), this.heatRectWidth_, this.getColumnNameEnd() - this.getColumnNameStart());
        }
        return rect;
    }

    private int getCoordinateBigger1(double intValue) {
        int pixelsPositive = this.defaultNrOfGradientPixels_ / 2;
        int coordinate = pixelsPositive + (int)((intValue - 1.0) * (double)((float)pixelsPositive / (this.upperValue_ - 1.0f)));
        if (coordinate >= this.defaultNrOfGradientPixels_ || coordinate < 0) {
            coordinate = this.defaultNrOfGradientPixels_ - 1;
        }
        return coordinate;
    }

    private int getCoordinateSmaller1(double intValue) {
        int pixelsNegative = this.defaultNrOfGradientPixels_ / 2;
        int coordinate = pixelsNegative - (int)(((intValue = 1.0 / intValue) - 1.0) * (double)((float)pixelsNegative / (1.0f / this.lowerValue_ - 1.0f)));
        if (coordinate < 1) {
            coordinate = 1;
        }
        return coordinate;
    }

    public String getSampleNameToDisplay(String sampleName) {
        return this.lookup_.getDisplayName(sampleName);
    }

    private static String extractPercentUnit(double value) {
        if (value <= 0.0) {
            return null;
        }
        if (value * 100.0 >= 1.0) {
            return "%";
        }
        return "\u2030";
    }

    protected boolean isOSMacAndJavaLookAndFeel() {
        if (this.ignorePlatformSettings_) {
            return false;
        }
        return Settings.isOSMacAndJavaLookAndFeel();
    }

    protected Color getLegendColor() {
        return Color.WHITE;
    }

    protected Color getBackgroundColor() {
        return Color.BLACK;
    }

    public String getAbsoluteFilePathOfExperiment(int column) {
        for (HeatMapRow row : this.heatMapRows_) {
            ResultCompVO compVO = row.getCompVO(this.sampleNames_.get(column));
            if (compVO == null) continue;
            return compVO.getAbsoluteFilePath();
        }
        return null;
    }

    public Color getAttentionProbe(int row, String experiment) {
        return (Color)this.heatMapRows_.get(row).getAttentionValues().get(experiment);
    }

    public Color getAttentionProbe(String analyte, String experiment) {
        return (Color)this.heatMapRows_.get(this.analyteNames_.indexOf(analyte)).getAttentionValues().get(experiment);
    }

    public ResultCompVO getCompVO(int column, int row) {
        return this.heatMapRows_.get(row).getCompVO(this.sampleNames_.get(column));
    }

    public ResultCompVO getSumCompVO(int column, int row) {
        return this.heatMapRows_.get(this.getSumCompVORow(row)).getCompVO(this.sampleNames_.get(column));
    }

    public Integer getSumCompVORow(int row) {
        if (this.isMolecularSpeciesLevel(row)) {
            String sumComposition = this.heatMapRows_.get(row).getOriginalAnalyteName();
            for (int i = 0; i < this.heatMapRows_.size(); ++i) {
                if (i == row || !this.heatMapRows_.get(i).getOriginalAnalyteName().equals(sumComposition) || this.isMolecularSpeciesLevel(i)) continue;
                return i;
            }
        } else {
            return row;
        }
        return -1;
    }

    public ArrayList<Integer> getAllRowsOfSameSumComposition(int row) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        String sumComposition = this.heatMapRows_.get(row).getOriginalAnalyteName();
        for (int i = 0; i < this.heatMapRows_.size(); ++i) {
            if (i == row || !this.heatMapRows_.get(i).getOriginalAnalyteName().equals(sumComposition)) continue;
            rows.add(i);
        }
        return rows;
    }

    public Double getMolecularSpeciesContributionOfAllMods(String name, int row) {
        return this.heatMapRows_.get(row).getMolecularSpeciesContribution(name);
    }

    public String getMolecularSpeciesLevelName(int row) {
        return this.isMolecularSpeciesLevel(row) ? this.getMolecularSpeciesName(row) : this.getSumCompositionName(row);
    }

    public String getMolecularSpeciesName(int row) {
        return this.heatMapRows_.get(row).getMolecularSpeciesName();
    }

    public String getSumCompositionName(int row) {
        return this.heatMapRows_.get(row).getSumCompositionName();
    }

    public String getRetentionTime(int row) {
        return this.heatMapRows_.get(row).getRtGroup();
    }

    public boolean isMolecularSpeciesLevel(int row) {
        return !this.heatMapRows_.get(row).getMolecularSpeciesName().equals("Sum composition");
    }

    public String extractPreferredUnitForExp() {
        ArrayList<Integer> unitValues = new ArrayList<Integer>();
        for (HeatMapRow row : this.heatMapRows_) {
            this.addUnitValue(unitValues, row.getPreferredUnit());
        }
        return this.computePreferredUnit(unitValues);
    }

    public String extractPreferredUnitForExp(Hashtable<String, String> preferredUnits) {
        ArrayList<Integer> unitValues = new ArrayList<Integer>();
        for (String unit : preferredUnits.values()) {
            this.addUnitValue(unitValues, unit);
        }
        return this.computePreferredUnit(unitValues);
    }

    private void addUnitValue(List<Integer> unitValues, String unit) {
        switch (unit) {
            case "": {
                unitValues.add(0);
                break;
            }
            case "%": {
                unitValues.add(1);
                break;
            }
            case "\u2030": {
                unitValues.add(2);
                break;
            }
            case "m": {
                unitValues.add(3);
                break;
            }
            case "\u03bc": {
                unitValues.add(4);
                break;
            }
            case "n": {
                unitValues.add(5);
                break;
            }
            case "p": {
                unitValues.add(6);
                break;
            }
            case "f": {
                unitValues.add(7);
                break;
            }
            case "a": {
                unitValues.add(8);
                break;
            }
        }
    }

    private String computePreferredUnit(List<Integer> unitValues) {
        String preferredUnit = "";
        Collections.sort(unitValues);
        int unitPlaceHolder = 0;
        unitPlaceHolder = unitValues.size() % 2 == 0 ? unitValues.get(unitValues.size() / 2).intValue() : unitValues.get((unitValues.size() + 1) / 2 - 1).intValue();
        switch (unitPlaceHolder) {
            case 0: {
                preferredUnit = "";
                break;
            }
            case 1: {
                preferredUnit = "%";
                break;
            }
            case 2: {
                preferredUnit = "\u2030";
                break;
            }
            case 3: {
                preferredUnit = "m";
                break;
            }
            case 4: {
                preferredUnit = "\u03bc";
                break;
            }
            case 5: {
                preferredUnit = "n";
                break;
            }
            case 6: {
                preferredUnit = "p";
                break;
            }
            case 7: {
                preferredUnit = "f";
                break;
            }
            case 8: {
                preferredUnit = "a";
                break;
            }
        }
        return preferredUnit;
    }

    public String getPreferredUnit(int row) {
        return this.heatMapRows_.get(row).getPreferredUnit();
    }

    public ArrayList<String> getOriginalAnalyteNames() {
        LinkedHashSet<String> analyteNames = new LinkedHashSet<String>();
        for (HeatMapRow row : this.heatMapRows_) {
            analyteNames.add(row.getOriginalAnalyteName());
        }
        return new ArrayList<String>(analyteNames);
    }

    public int getAnalyteIndex(String analyte) {
        ArrayList<String> originalNames = this.getOriginalAnalyteNames();
        return originalNames.indexOf(analyte);
    }

    public String getAnalyteName(int row) {
        return this.analyteNames_.get(row);
    }

    public String getOriginalAnalyteName(int row) {
        return this.heatMapRows_.get(row).getOriginalAnalyteName();
    }

    public String getExperimentName(int column) {
        String name = null;
        if (column >= 0 && column < this.sampleNames_.size()) {
            name = this.sampleNames_.get(column);
        }
        return name;
    }

    public Set<ResultCompVO> getPresentCompVOsWithMod(Set<Integer> rows, Vector<String> selectedMods) {
        ConcurrentHashMap.KeySetView compVOs = ConcurrentHashMap.newKeySet();
        for (Integer row : rows) {
            for (ResultCompVO compVO : this.heatMapRows_.get(row).getAllCompVO()) {
                if (compVO.getAbsoluteFilePath() == null || compVO.getAbsoluteFilePath().length() <= 0 || !compVO.existsInFile()) continue;
                for (String modName : selectedMods) {
                    if (!compVO.containsMod(modName)) continue;
                    compVOs.add(compVO);
                }
            }
        }
        return compVOs;
    }

    public Set<String> eliminateMolecularSpecies(Set<Integer> rows, Vector<String> selectedMods) {
        ConcurrentHashMap.KeySetView filePaths = ConcurrentHashMap.newKeySet();
        for (Integer row : rows) {
            for (ResultCompVO compVO : this.heatMapRows_.get(row).getAllCompVO()) {
                if (compVO.getAbsoluteFilePath() == null || compVO.getAbsoluteFilePath().length() <= 0 || !compVO.existsInFile()) continue;
                for (String modName : selectedMods) {
                    if (!compVO.containsMod(modName)) continue;
                    String humanReadable = this.heatMapRows_.get(row).getMolecularSpeciesName();
                    compVO.getResultMolecule().removeMolecularSpeciesFromParams(humanReadable, modName);
                    filePaths.add(compVO.getAbsoluteFilePath());
                }
            }
        }
        return filePaths;
    }

    private class HeatMapRow {
        private String sumCompositionName_;
        private String rtGroup_;
        private String molecularSpeciesName_;
        private String preferredUnit_;
        private Hashtable<String, ResultCompVO> compVOs_;
        private Hashtable<String, Color> attentionValues_;
        private Hashtable<String, Double> relativeValues_;
        private Hashtable<String, Double> molecularSpeciesContribution_;
        private static final String RT_DELIMITER = "_";
        private static final String STANDARD = "std";

        private HeatMapRow(String sumCompositionName, String molecularSpeciesName, String preferredUnit) {
            this.sumCompositionName_ = this.extractSumCompositionName(sumCompositionName);
            this.rtGroup_ = this.extractRetentionTime(sumCompositionName);
            this.molecularSpeciesName_ = molecularSpeciesName;
            this.preferredUnit_ = preferredUnit;
            this.compVOs_ = new Hashtable();
            this.attentionValues_ = new Hashtable();
            this.relativeValues_ = new Hashtable();
            this.molecularSpeciesContribution_ = new Hashtable();
        }

        private void paintExpressionRow(Graphics2D expressionGraphics, int xoffset, int yoffset, int row) {
            expressionGraphics.setColor(LipidomicsHeatMap.this.borderColor_);
            for (int i = 0; i < LipidomicsHeatMap.this.sampleNames_.size(); ++i) {
                double value = this.relativeValues_.get(LipidomicsHeatMap.this.sampleNames_.get(i));
                Color color = new Color(LipidomicsHeatMap.this.getColorForValue(value));
                expressionGraphics.setColor(color);
                expressionGraphics.fillRect(LipidomicsHeatMap.this.heatRectWidth_ * i + 1 + xoffset + LipidomicsHeatMap.this.partCorrection_, LipidomicsHeatMap.this.heatRectHeight_ * row + 1 + yoffset, LipidomicsHeatMap.this.heatRectWidth_ - 1, LipidomicsHeatMap.this.heatRectHeight_ - 1);
                if (!this.attentionValues_.containsKey(LipidomicsHeatMap.this.sampleNames_.get(i))) continue;
                this.paintAttentionRectangle(expressionGraphics, this.attentionValues_.get(LipidomicsHeatMap.this.sampleNames_.get(i)), row, i, xoffset, yoffset);
            }
        }

        private void paintAttentionRectangle(Graphics2D g2, Color color, int row, int column, int xoffset, int yoffset) {
            g2.setColor(this.attentionValues_.get(LipidomicsHeatMap.this.sampleNames_.get(column)));
            g2.drawRect(LipidomicsHeatMap.this.heatRectWidth_ * column + 1 + xoffset + LipidomicsHeatMap.this.partCorrection_, LipidomicsHeatMap.this.heatRectHeight_ * row + 1 + yoffset, LipidomicsHeatMap.this.heatRectWidth_ - 2, LipidomicsHeatMap.this.heatRectHeight_ - 2);
        }

        private String getAnalyteName() {
            String delimiter = " ... ";
            String rtGroup = this.getRtGroup().equalsIgnoreCase(STANDARD) ? delimiter : String.format("%s%s min %s", delimiter, this.getRtGroup(), delimiter);
            return String.format("%s%s%s", this.getSumCompositionName(), rtGroup, this.getMolecularSpeciesName());
        }

        private String getOriginalAnalyteName() {
            String rtGroup = this.getRtGroup().equalsIgnoreCase(STANDARD) ? "" : RT_DELIMITER + this.getRtGroup();
            return this.getSumCompositionName() + rtGroup;
        }

        private String extractSumCompositionName(String name) {
            String nameString = name;
            if (name.contains(RT_DELIMITER)) {
                nameString = name.substring(0, name.indexOf(RT_DELIMITER));
            }
            return nameString;
        }

        private String extractRetentionTime(String name) {
            String nameString = STANDARD;
            if (name.contains(RT_DELIMITER)) {
                nameString = name.substring(name.indexOf(RT_DELIMITER) + 1, name.length());
            }
            return nameString;
        }

        private String getSumCompositionName() {
            return this.sumCompositionName_;
        }

        private String getMolecularSpeciesName() {
            return this.molecularSpeciesName_;
        }

        private String getRtGroup() {
            return this.rtGroup_;
        }

        private String getPreferredUnit() {
            return this.preferredUnit_;
        }

        private void addCompVO(String experimentName, ResultCompVO compVO) {
            this.compVOs_.put(experimentName, compVO);
        }

        private ResultCompVO getCompVO(String experimentName) {
            return this.compVOs_.get(experimentName);
        }

        private ArrayList<ResultCompVO> getAllCompVO() {
            return new ArrayList<ResultCompVO>(this.compVOs_.values());
        }

        private Hashtable<String, Color> getAttentionValues() {
            return this.attentionValues_;
        }

        private void setAttentionValues(Hashtable<String, Color> attentionValues) {
            if (this.molecularSpeciesName_.equals("Sum composition")) {
                this.attentionValues_ = attentionValues;
            } else {
                for (String experiment : attentionValues.keySet()) {
                    if (this.molecularSpeciesContribution_.get(experiment) == null) continue;
                    this.attentionValues_.put(experiment, attentionValues.get(experiment));
                }
            }
        }

        private Hashtable<String, Double> getRelativeValues() {
            return this.relativeValues_;
        }

        private Double getValue(String experiment) {
            return this.relativeValues_.get(experiment);
        }

        private void addRelativeValue(String experimentName, Double relativeValue) {
            this.relativeValues_.put(experimentName, relativeValue);
        }

        private void addMolecularSpeciesContributionOfAllMods(String experimentName, Double value) {
            this.molecularSpeciesContribution_.put(experimentName, value);
        }

        private Double getMolecularSpeciesContribution(String experimentName) {
            if (this.molecularSpeciesName_.equals("Sum composition")) {
                return 1.0;
            }
            if (this.molecularSpeciesContribution_.get(experimentName) == null) {
                return 0.0;
            }
            return this.molecularSpeciesContribution_.get(experimentName);
        }
    }
}

