/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.analysis.vos;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.maspectras.quantification.Probe3D;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;

public class IsoLocationSpaces {
    private String overlapAnalyte_;
    private int maxIsos_;
    private int nrOfPeaks_;
    private Hashtable<Integer, Hashtable<Integer, Vector<Float>>> timeRange_;
    private Hashtable<Integer, Hashtable<Integer, Vector<Float>>> mzRange_;
    private Hashtable<Integer, Float> zeroAreas_;
    private Vector<Vector<CgProbe>> probes_;
    private Hashtable<Integer, Hashtable<Integer, Vector<String>>> overlaps_;
    private Vector<Double> distri_;
    private boolean negative_;

    public IsoLocationSpaces(String name, int maxIsotope) {
        this.overlapAnalyte_ = name;
        this.maxIsos_ = maxIsotope;
        this.overlaps_ = null;
    }

    public void setParameterSet(LipidParameterSet set, Vector<Double> distri, boolean negative) {
        this.negative_ = negative;
        this.distri_ = distri;
        this.probes_ = set.getIsotopicProbes();
        this.nrOfPeaks_ = this.probes_.get(0).size();
        this.timeRange_ = new Hashtable();
        this.mzRange_ = new Hashtable();
        this.zeroAreas_ = new Hashtable();
        int count = 0;
        for (CgProbe probe : this.probes_.get(0)) {
            Hashtable timeRangeOfSinglePeak = new Hashtable();
            Hashtable mzRangeOfSinglePeak = new Hashtable();
            float zeroTimeStart = probe.LowerValley;
            float zeroTimeEnd = probe.UpperValley;
            float zeroMzStart = probe.Mz - probe.LowerMzBand;
            float zeroMzEnd = probe.Mz + probe.UpperMzBand;
            if (probe instanceof Probe3D) {
                Probe3D dProbe = (Probe3D)probe;
                zeroTimeStart = dProbe.getEllipseTimePosition() - dProbe.getEllipseTimeStretch();
                zeroTimeEnd = dProbe.getEllipseTimePosition() + dProbe.getEllipseTimeStretch();
                zeroMzStart = dProbe.getEllipseMzPosition() - dProbe.getEllipseMzStretch();
                zeroMzEnd = dProbe.getEllipseMzPosition() + dProbe.getEllipseMzStretch();
            }
            float negate = 1.0f;
            if (negative) {
                negate = -1.0f;
            }
            for (int i = 0; i != this.maxIsos_; ++i) {
                Vector<Float> timeRange = new Vector<Float>();
                Vector<Float> mzRange = new Vector<Float>();
                timeRange.add(Float.valueOf(zeroTimeStart));
                timeRange.add(Float.valueOf(zeroTimeEnd));
                mzRange.add(Float.valueOf(zeroMzStart + (float)i * LipidomicsConstants.getNeutronMass() * negate / (float)set.getCharge().intValue()));
                mzRange.add(Float.valueOf(zeroMzEnd + (float)i * LipidomicsConstants.getNeutronMass() * negate / (float)set.getCharge().intValue()));
                timeRangeOfSinglePeak.put(i, timeRange);
                mzRangeOfSinglePeak.put(i, mzRange);
            }
            this.timeRange_.put(count, timeRangeOfSinglePeak);
            this.mzRange_.put(count, mzRangeOfSinglePeak);
            float meanZeroArea = probe.Area;
            if (this.probes_.size() > 1) {
                float oneArea = -1.0f;
                if (this.probes_.get(0).size() == 1 && this.probes_.get(1).size() == 1) {
                    oneArea = this.probes_.get((int)1).get((int)0).Area;
                } else {
                    for (CgProbe probe1 : this.probes_.get(1)) {
                        if (!(probe.LowerMzBand < probe1.Peak) || !(probe1.Peak < probe.UpperMzBand)) continue;
                        oneArea = probe.Area;
                        break;
                    }
                }
                if (oneArea > 0.0f) {
                    meanZeroArea = (meanZeroArea + oneArea * (float)distri.get(0).doubleValue() / (float)distri.get(1).doubleValue()) / 2.0f;
                }
            }
            this.zeroAreas_.put(count, Float.valueOf(meanZeroArea));
            ++count;
        }
    }

    public boolean determineOverlappingParts(LipidParameterSet set) {
        boolean overlap = false;
        this.overlaps_ = new Hashtable();
        Vector<Vector<CgProbe>> probes = set.getIsotopicProbes();
        int iso = 0;
        for (Vector<CgProbe> isoProbes : probes) {
            int probeNr = 0;
            Hashtable overlapIso = new Hashtable();
            for (CgProbe probe : isoProbes) {
                float timeStart = probe.LowerValley;
                float timeEnd = probe.UpperValley;
                float mzStart = probe.Mz - probe.LowerMzBand;
                float mzEnd = probe.Mz + probe.UpperMzBand;
                if (probe instanceof Probe3D) {
                    Probe3D dProbe = (Probe3D)probe;
                    timeStart = dProbe.getEllipseTimePosition() - dProbe.getEllipseTimeStretch();
                    timeEnd = dProbe.getEllipseTimePosition() + dProbe.getEllipseTimeStretch();
                    mzStart = dProbe.getEllipseMzPosition() - dProbe.getEllipseMzStretch();
                    mzEnd = dProbe.getEllipseMzPosition() + dProbe.getEllipseMzStretch();
                }
                Vector overlaps = new Vector();
                for (int i = 0; i != this.nrOfPeaks_; ++i) {
                    Hashtable<Integer, Vector<Float>> timeRangeOfSinglePeak = this.timeRange_.get(i);
                    Hashtable<Integer, Vector<Float>> mzRangeOfSinglePeak = this.mzRange_.get(i);
                    Vector<String> isoOverlapsOfTheSamePeak = new Vector<String>();
                    for (int j = 0; j != timeRangeOfSinglePeak.size(); ++j) {
                        Vector<Float> timeRange = timeRangeOfSinglePeak.get(j);
                        Vector<Float> mzRange = mzRangeOfSinglePeak.get(j);
                        if (!this.isWithinRange(timeStart, timeEnd, timeRange.get(0).floatValue(), timeRange.get(1).floatValue()) || !this.isWithinRange(mzStart, mzEnd, mzRange.get(0).floatValue(), mzRange.get(1).floatValue())) continue;
                        overlap = true;
                        String id_Overlap = i + "_" + j;
                        isoOverlapsOfTheSamePeak.add(id_Overlap);
                    }
                    if (LipidomicsConstants.useMostOverlappingIsotopeOnly() && isoOverlapsOfTheSamePeak.size() > 0) {
                        String bestId = null;
                        float highestOverlapPercentage = 0.0f;
                        float range = mzEnd - mzStart;
                        for (String id_Overlap : isoOverlapsOfTheSamePeak) {
                            float percentOverlap;
                            int j = Integer.parseInt(id_Overlap.split("_")[1]);
                            Vector<Float> mzRange = mzRangeOfSinglePeak.get(j);
                            float start = mzRange.get(0).floatValue();
                            float stop = mzRange.get(1).floatValue();
                            if (mzStart > start) {
                                start = mzStart;
                            }
                            if (stop > mzEnd) {
                                stop = mzEnd;
                            }
                            if (!((percentOverlap = (stop - start) / range) > highestOverlapPercentage)) continue;
                            highestOverlapPercentage = percentOverlap;
                            bestId = id_Overlap;
                        }
                        isoOverlapsOfTheSamePeak = new Vector();
                        isoOverlapsOfTheSamePeak.add(bestId);
                    }
                    overlaps.addAll(isoOverlapsOfTheSamePeak);
                }
                if (overlaps.size() > 0) {
                    overlapIso.put(probeNr, overlaps);
                }
                ++probeNr;
            }
            if (overlapIso.size() > 0) {
                this.overlaps_.put(iso, overlapIso);
            }
            ++iso;
        }
        return overlap;
    }

    public boolean hasOverlap() {
        if (this.overlaps_ == null) {
            return false;
        }
        for (int i = 0; i != this.maxIsos_; ++i) {
            if (!this.overlaps_.containsKey(i)) continue;
            return true;
        }
        return false;
    }

    public Vector<Integer> getAffectedIsos() {
        Vector<Integer> isos = new Vector<Integer>(this.overlaps_.keySet());
        Collections.sort(isos);
        return isos;
    }

    private boolean isWithinRange(float start1, float end1, float start2, float end2) {
        boolean isInRange = false;
        if (start1 <= start2 && end1 >= start2 || start1 >= start2 && end2 >= start1) {
            isInRange = true;
        }
        return isInRange;
    }

    public Hashtable<Integer, Vector<String>> getOverlapsOfIso(int iso) {
        return this.overlaps_.get(iso);
    }

    public Vector<String> getOverlapsOfIso(int iso, int probeNr) {
        Vector<String> overlapInfo = new Vector<String>();
        Hashtable<Integer, Vector<String>> overlaps = this.getOverlapsOfIso(iso);
        if (overlaps.containsKey(probeNr)) {
            overlapInfo = overlaps.get(probeNr);
        }
        return overlapInfo;
    }

    public String getId() {
        return this.overlapAnalyte_;
    }

    public boolean isTheSame(IsoLocationSpaces overlapLocation) {
        if (overlapLocation.probes_.size() == this.probes_.size()) {
            if (overlapLocation.probes_.get(0).size() != this.probes_.get(0).size()) {
                return false;
            }
        } else {
            return false;
        }
        overlapLocation.probes_.get(0);
        Vector<CgProbe> probes1 = overlapLocation.probes_.get(0);
        Vector<CgProbe> probes2 = this.probes_.get(0);
        for (CgProbe probe1 : probes1) {
            boolean found = false;
            for (CgProbe probe2 : probes2) {
                if (!this.checkTheSame(probe1, probe2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean checkTheSame(CgProbe p1, CgProbe p2) {
        if (!(p1.Area * 0.99f < p2.Area) || !(p2.Area < p1.Area * 1.01f)) {
            return false;
        }
        Probe3D p31 = null;
        Probe3D p32 = null;
        if (p1 instanceof Probe3D) {
            p31 = (Probe3D)p1;
        }
        if (p2 instanceof Probe3D) {
            p32 = (Probe3D)p2;
        }
        if (p31 != null && p32 != null) {
            if (!(p31.getEllipseMzPosition() * 0.99f < p32.getEllipseMzPosition()) || !(p32.getEllipseMzPosition() < p31.getEllipseMzPosition() * 1.01f)) {
                return false;
            }
            if (!(p31.getEllipseMzStretch() * 0.99f < p32.getEllipseMzStretch()) || !(p32.getEllipseMzStretch() < p31.getEllipseMzStretch() * 1.01f)) {
                return false;
            }
            if (!(p31.getEllipseTimePosition() * 0.99f < p32.getEllipseTimePosition()) || !(p32.getEllipseTimePosition() < p31.getEllipseTimePosition() * 1.01f)) {
                return false;
            }
            if (!(p31.getEllipseTimeStretch() * 0.99f < p32.getEllipseTimeStretch()) || !(p32.getEllipseTimeStretch() < p31.getEllipseTimeStretch() * 1.01f)) {
                return false;
            }
        } else if (p31 == null && p32 == null) {
            if (!(p1.LowerValley * 0.99f < p2.LowerValley) || !(p2.LowerValley < p1.LowerValley * 1.01f)) {
                return false;
            }
            if (!(p1.UpperValley * 0.99f < p2.UpperValley) || !(p2.UpperValley < p1.UpperValley * 1.01f)) {
                return false;
            }
            if (!(p1.LowerMzBand * 0.99f < p2.LowerMzBand) || !(p2.LowerMzBand < p1.LowerMzBand * 1.01f)) {
                return false;
            }
            if (!(p1.UpperMzBand * 0.99f < p2.UpperMzBand) || !(p2.UpperMzBand < p1.UpperMzBand * 1.01f)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean getNegative() {
        return this.negative_;
    }

    public float getOtherIsotopeArea(int iso, int probeNr) {
        Vector<String> affectedPeaks = this.getOverlapsOfIso(iso, probeNr);
        float area = 0.0f;
        for (String peakId : affectedPeaks) {
            int probRef = Integer.parseInt(peakId.substring(0, peakId.indexOf("_")));
            int isoRef = Integer.parseInt(peakId.substring(peakId.indexOf("_") + 1));
            if (this.distri_.size() <= isoRef) continue;
            area += this.zeroAreas_.get(probRef).floatValue() * this.distri_.get(isoRef).floatValue() / this.distri_.get(0).floatValue();
        }
        return area;
    }

    public Vector<Double> getDistri() {
        return this.distri_;
    }
}

