/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.export;

import at.tugraz.genome.lda.analysis.ComparativeResultsLookup;
import at.tugraz.genome.lda.exception.ExcelInputFileException;
import at.tugraz.genome.lda.exception.ExportException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.RetentionTimeGroupingException;
import at.tugraz.genome.lda.export.LDAExporter;
import at.tugraz.genome.lda.export.vos.SpeciesExportVO;
import at.tugraz.genome.lda.export.vos.SummaryVO;
import at.tugraz.genome.lda.msn.hydroxy.parser.HydroxyEncoding;
import at.tugraz.genome.lda.parser.LDAResultReader;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.QuantificationResult;
import at.tugraz.genome.lda.swing.LipidomicsTableCellRenderer;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.ExportOptionsVO;
import at.tugraz.genome.lda.vos.ResultAreaVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelAndTextExporter
extends LDAExporter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportToFile(boolean includeResultFiles, short speciesType, boolean exportDoubleBondPositionsForClass, String sheetName, OutputStream out, boolean excelFile, int maxIsotope, Vector<String> molNames, boolean isRtGrouped, boolean isGrouped, Vector<String> expIdNames, Hashtable<String, String> expNames, LinkedHashMap<String, String> expFullPaths, LinkedHashMap<String, Vector<String>> expsOfGroup, Hashtable<String, Hashtable<String, Vector<Double>>> results, String preferredUnit, String headerText, ExportOptionsVO expVO, ComparativeResultsLookup compLookup, ArrayList<String> modifications) throws ExportException, SpectrummillParserException, ExcelInputFileException, IOException, LipidCombinameEncodingException, RetentionTimeGroupingException {
        Hashtable<String, QuantificationResult> originalExcelResults = new Hashtable<String, QuantificationResult>();
        HydroxyEncoding faEncoding = null;
        HydroxyEncoding lcbEncoding = null;
        for (String expId : expFullPaths.keySet()) {
            QuantificationResult result = LDAResultReader.readResultFile(expFullPaths.get(expId), new Hashtable<String, Boolean>(), sheetName);
            if (result.getFaHydroxyEncoding() != null) {
                faEncoding = result.getFaHydroxyEncoding();
            }
            if (result.getLcbHydroxyEncoding() != null) {
                lcbEncoding = result.getLcbHydroxyEncoding();
            }
            originalExcelResults.put(expId, result);
        }
        LinkedHashMap<String, Boolean> adductsSorted = ExcelAndTextExporter.extractAdductsSortedByAbundance(sheetName, originalExcelResults);
        boolean rtGroupingUsed = isRtGrouped;
        LinkedHashMap<String, SummaryVO> molSpeciesDetails = new LinkedHashMap<String, SummaryVO>();
        for (String molName : molNames) {
            Hashtable<String, Hashtable<String, Vector<LipidParameterSet>>> relevantOriginals = null;
            if (includeResultFiles) {
                relevantOriginals = new Hashtable<String, Hashtable<String, Vector<LipidParameterSet>>>();
                for (String expId : expFullPaths.keySet()) {
                    ResultAreaVO areaVO = compLookup.getResultAreaVO(sheetName, molName, expId);
                    if (!isGrouped && !expNames.containsKey(expId) || areaVO == null) continue;
                    if (areaVO.isAStandard()) {
                        rtGroupingUsed = false;
                    }
                    Hashtable<String, Vector<LipidParameterSet>> sets = ExcelAndTextExporter.getRelevantOriginalResults(originalExcelResults.get(expId).getIdentifications().get(sheetName), areaVO, false);
                    relevantOriginals.put(expId, sets);
                }
            }
            SpeciesExportVO exportVO = LDAExporter.extractExportableSummaryInformation(speciesType, exportDoubleBondPositionsForClass, false, 0, 0, false, 0, 0, rtGroupingUsed, adductsSorted, new Vector<String>(expFullPaths.keySet()), expsOfGroup, molName, results.get(molName), relevantOriginals, maxIsotope, faEncoding, lcbEncoding);
            for (SummaryVO sumVO : exportVO.getSummaries()) {
                String id = "";
                if (includeResultFiles) {
                    id = id + sheetName + " ";
                }
                id = id + sumVO.getSpeciesId();
                if (sumVO.getMolecularId() != null) {
                    id = id + " | " + sumVO.getMolecularId();
                }
                molSpeciesDetails.put(id, sumVO);
            }
        }
        try {
            ExcelAndTextExporter.writeToFile(sheetName, out, excelFile, molSpeciesDetails, isGrouped, expIdNames, expNames, expsOfGroup, preferredUnit, expVO, modifications);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static void writeToFile(String sheetName, OutputStream out, boolean excelFile, LinkedHashMap<String, SummaryVO> molSpeciesDetails, boolean isGrouped, Vector<String> expIdNames, Hashtable<String, String> expNames, LinkedHashMap<String, Vector<String>> expsOfGroup, String preferredUnit, ExportOptionsVO expVO, ArrayList<String> modifications) throws IOException {
        XSSFWorkbook workbook = null;
        Sheet sheet = null;
        Row row = null;
        CellStyle headerStyle = null;
        CellStyle normalStyle = null;
        CellStyle zeroStyle = null;
        CellStyle ms2Unambiguous = null;
        CellStyle ms2Split = null;
        CellStyle ms2NoSplitPossible = null;
        if (excelFile) {
            workbook = new XSSFWorkbook();
            sheet = workbook.createSheet(sheetName);
            headerStyle = ExcelAndTextExporter.getHeaderStyle(workbook);
            normalStyle = ExcelAndTextExporter.getNormalStyle(workbook);
            zeroStyle = ExcelAndTextExporter.getZeroStyle(workbook);
            ms2Unambiguous = ExcelAndTextExporter.getMs2UnambiguousStyle(workbook);
            ms2Split = ExcelAndTextExporter.getMs2SplitStyle(workbook);
            ms2NoSplitPossible = ExcelAndTextExporter.getMs2NoSplitPossibleStyle(workbook);
            row = sheet.createRow(0);
        }
        boolean expInColumn = false;
        Vector<String> columnNames = new Vector<String>(molSpeciesDetails.keySet());
        Vector<String> rowNames = new Vector<String>(expIdNames);
        if (!expVO.isAnalyteInColumn()) {
            columnNames = new Vector<String>(expIdNames);
            rowNames = new Vector<String>(molSpeciesDetails.keySet());
            expInColumn = true;
        }
        StaticUtils.printOutLabelToFile(sheetName, out, row, headerStyle, (columnNames.size() + 2) / 2, excelFile, false);
        if (!excelFile) {
            out.write("\n".getBytes());
        }
        int rowCount = 1;
        int columnCount = 0;
        Hashtable<Integer, String> headerValues = new Hashtable<Integer, String>();
        Hashtable<Integer, Integer> longestValues = new Hashtable<Integer, Integer>();
        String unit = "Arb.Units / AU";
        if (preferredUnit != null && preferredUnit.length() > 0) {
            unit = preferredUnit;
        }
        String unitString = unit;
        if (excelFile) {
            row = sheet.createRow(rowCount);
        }
        StaticUtils.printOutLabelToFile(unitString, out, row, headerStyle, columnCount, excelFile, false);
        headerValues.put(columnCount, unitString);
        longestValues.put(columnCount, 0);
        StaticUtils.printOutLabelToFile("", out, row, headerStyle, ++columnCount, excelFile, true);
        headerValues.put(columnCount, "");
        longestValues.put(columnCount, 0);
        ++columnCount;
        Iterator<String> iterator = columnNames.iterator();
        while (iterator.hasNext()) {
            String columnName;
            String valueToPrint = columnName = iterator.next();
            if (expInColumn) {
                valueToPrint = expNames.get(columnName);
            }
            StaticUtils.printOutLabelToFile(valueToPrint, out, row, headerStyle, columnCount, excelFile, true);
            headerValues.put(columnCount, valueToPrint);
            longestValues.put(columnCount, 0);
            ++columnCount;
        }
        ++rowCount;
        if (excelFile) {
            row = sheet.createRow(rowCount);
        }
        if (!excelFile) {
            out.write("\n".getBytes());
        }
        for (String rowName : rowNames) {
            CellStyle style;
            columnCount = 0;
            String valueToPrint = rowName;
            if (!expInColumn) {
                valueToPrint = expNames.get(rowName);
            }
            StaticUtils.printOutLabelToFile(valueToPrint, out, row, headerStyle, columnCount, excelFile, false);
            if (valueToPrint.length() > ((String)headerValues.get(columnCount)).length()) {
                headerValues.put(columnCount, valueToPrint);
            }
            StaticUtils.printOutLabelToFile("Value", out, row, headerStyle, ++columnCount, excelFile, true);
            if ("Value".length() > ((String)headerValues.get(columnCount)).length()) {
                headerValues.put(columnCount, "Value");
            }
            ++columnCount;
            for (String string : columnNames) {
                String toWrite = "0";
                String molName = string;
                String expName = rowName;
                if (!expVO.isAnalyteInColumn()) {
                    molName = rowName;
                    expName = string;
                }
                SummaryVO sumVO = molSpeciesDetails.get(molName);
                double area = isGrouped ? sumVO.getMeanArea(expName).doubleValue() : sumVO.getArea(expName).doubleValue();
                toWrite = StaticUtils.extractDisplayValue(area, expVO.getCommaPositions());
                CellStyle style2 = null;
                style2 = toWrite.equalsIgnoreCase("0") || toWrite.equalsIgnoreCase("0.0") ? zeroStyle : ExcelAndTextExporter.getCorrespondingCellStyle(sumVO.getEvidenceReliabilty(expName), normalStyle, ms2Unambiguous, ms2Split, ms2NoSplitPossible);
                StaticUtils.printOutNumberToFile(toWrite, out, row, style2, columnCount, excelFile, true);
                if (toWrite.length() > (Integer)longestValues.get(columnCount)) {
                    longestValues.put(columnCount, toWrite.length());
                }
                ++columnCount;
            }
            ++rowCount;
            if (excelFile) {
                row = sheet.createRow(rowCount);
            }
            if (!excelFile) {
                out.write("\n".getBytes());
            }
            if (expVO != null && expVO.getExportType() != 0) {
                columnCount = 0;
                StaticUtils.printOutLabelToFile("", out, row, headerStyle, columnCount, excelFile, false);
                ++columnCount;
                String title = "";
                if (expVO.getExportType() == 1) {
                    title = title + "SD-" + expVO.getSdValue();
                } else if (expVO.getExportType() == 2) {
                    title = title + "SE";
                }
                StaticUtils.printOutLabelToFile(title, out, row, headerStyle, columnCount, excelFile, true);
                if (title.length() > ((String)headerValues.get(columnCount)).length()) {
                    headerValues.put(columnCount, title);
                }
                ++columnCount;
                for (String columnName2 : columnNames) {
                    SummaryVO sumVO;
                    double value;
                    Object toWrite = "-1.0";
                    String molName = columnName2;
                    String expName = rowName;
                    if (!expVO.isAnalyteInColumn()) {
                        molName = rowName;
                        expName = columnName2;
                    }
                    if (!Double.isInfinite(value = (sumVO = molSpeciesDetails.get(molName)).calculateDeviationValue(expVO, expsOfGroup.get(expName))) && !Double.isNaN(value)) {
                        toWrite = StaticUtils.extractDisplayValue(value);
                    }
                    style = null;
                    style = ((String)toWrite).equalsIgnoreCase("-1") || ((String)toWrite).equalsIgnoreCase("-1.0") ? zeroStyle : ExcelAndTextExporter.getCorrespondingCellStyle(sumVO.getEvidenceReliabilty(expName), normalStyle, ms2Unambiguous, ms2Split, ms2NoSplitPossible);
                    StaticUtils.printOutNumberToFile((String)toWrite, out, row, style, columnCount, excelFile, true);
                    if (((String)toWrite).length() > (Integer)longestValues.get(columnCount)) {
                        longestValues.put(columnCount, ((String)toWrite).length());
                    }
                    ++columnCount;
                }
                ++rowCount;
                if (!excelFile) {
                    out.write("\n".getBytes());
                } else {
                    row = sheet.createRow(rowCount);
                }
            }
            for (String string : modifications) {
                if (expVO != null && expVO.isExportRT()) {
                    columnCount = 0;
                    StaticUtils.printOutLabelToFile("", out, row, headerStyle, columnCount, excelFile, false);
                    ++columnCount;
                    String rtName = "RT";
                    if (modifications.size() > 1) {
                        rtName = rtName + "-" + string;
                    }
                    StaticUtils.printOutLabelToFile(rtName, out, row, headerStyle, columnCount, excelFile, true);
                    if (rtName.length() > ((String)headerValues.get(columnCount)).length()) {
                        headerValues.put(columnCount, rtName);
                    }
                    ++columnCount;
                    for (String columnName : columnNames) {
                        String toWrite = "-1.0";
                        String molName = columnName;
                        String expName = rowName;
                        if (!expVO.isAnalyteInColumn()) {
                            molName = rowName;
                            expName = columnName;
                        }
                        SummaryVO sumVO = molSpeciesDetails.get(molName);
                        Double rt = isGrouped ? sumVO.getMeanRetentionTime(string, expName) : sumVO.getRetentionTime(string, expName);
                        if (rt != null && !Double.isInfinite(rt) && !Double.isNaN(rt)) {
                            toWrite = StaticUtils.extractDisplayValue(rt);
                        }
                        CellStyle style3 = null;
                        style3 = toWrite.equalsIgnoreCase("-1") || toWrite.equalsIgnoreCase("-1.0") ? zeroStyle : ExcelAndTextExporter.getCorrespondingCellStyle(sumVO.getEvidenceReliabilty(expName), normalStyle, ms2Unambiguous, ms2Split, ms2NoSplitPossible);
                        StaticUtils.printOutNumberToFile(toWrite, out, row, style3, columnCount, excelFile, true);
                        if (toWrite.length() > (Integer)longestValues.get(columnCount)) {
                            longestValues.put(columnCount, toWrite.length());
                        }
                        ++columnCount;
                    }
                    ++rowCount;
                    if (excelFile) {
                        row = sheet.createRow(rowCount);
                    } else {
                        out.write("\n".getBytes());
                    }
                }
                if (expVO == null || !expVO.isExportRTDev()) continue;
                columnCount = 0;
                StaticUtils.printOutLabelToFile("", out, row, headerStyle, columnCount, excelFile, false);
                StaticUtils.printOutLabelToFile("RT-StDev", out, row, headerStyle, ++columnCount, excelFile, true);
                if ("RT-StDev".length() > ((String)headerValues.get(columnCount)).length()) {
                    headerValues.put(columnCount, "RT-StDev");
                }
                ++columnCount;
                for (String columnName : columnNames) {
                    SummaryVO sumVO;
                    Double rtStdev;
                    String toWrite = "-1.0";
                    String molName = columnName;
                    String expName = rowName;
                    if (!expVO.isAnalyteInColumn()) {
                        molName = rowName;
                        expName = columnName;
                    }
                    if ((rtStdev = (sumVO = molSpeciesDetails.get(molName)).getStdevRetentionTime(string, expName)) != null && !Double.isInfinite(rtStdev) && !Double.isNaN(rtStdev)) {
                        toWrite = StaticUtils.extractDisplayValue(rtStdev);
                    }
                    style = null;
                    style = toWrite.equalsIgnoreCase("-1") || toWrite.equalsIgnoreCase("-1.0") ? zeroStyle : ExcelAndTextExporter.getCorrespondingCellStyle(sumVO.getEvidenceReliabilty(expName), normalStyle, ms2Unambiguous, ms2Split, ms2NoSplitPossible);
                    StaticUtils.printOutNumberToFile(toWrite, out, row, style, columnCount, excelFile, true);
                    ++columnCount;
                }
                ++rowCount;
                if (excelFile) {
                    row = sheet.createRow(rowCount);
                    continue;
                }
                out.write("\n".getBytes());
            }
        }
        if (excelFile) {
            Iterator<String> iterator2 = headerValues.keySet().iterator();
            while (iterator2.hasNext()) {
                int column = (Integer)((Object)iterator2.next());
                ExcelAndTextExporter.setColumnWidth(sheet, column, (String)headerValues.get(column), (Integer)longestValues.get(column));
            }
            workbook.write(out);
        }
    }

    private static CellStyle getNormalStyle(Workbook wb) {
        CellStyle arialStyle = wb.createCellStyle();
        Font arialfont = ExcelAndTextExporter.getArialFont(wb);
        arialStyle.setFont(arialfont);
        return arialStyle;
    }

    private static CellStyle getZeroStyle(Workbook wb) {
        CellStyle arialStyle = wb.createCellStyle();
        Font arialfont = ExcelAndTextExporter.getArialRedFont(wb);
        arialStyle.setFont(arialfont);
        return arialStyle;
    }

    private static CellStyle getHeaderStyle(Workbook wb) {
        CellStyle arial12style = wb.createCellStyle();
        Font arial12font = ExcelAndTextExporter.getArial12BoldFont(wb);
        arial12style.setFont(arial12font);
        arial12style.setAlignment((short)2);
        return arial12style;
    }

    private static CellStyle getMs2UnambiguousStyle(XSSFWorkbook wb) {
        XSSFCellStyle arialStyleGreen = wb.createCellStyle();
        Font arialfont = ExcelAndTextExporter.getArialFont(wb);
        arialStyleGreen.setFont(arialfont);
        XSSFColor color = new XSSFColor(LipidomicsTableCellRenderer.BRIGHT_GREEN);
        arialStyleGreen.setFillForegroundColor(color);
        arialStyleGreen.setFillPattern((short)1);
        return arialStyleGreen;
    }

    private static CellStyle getMs2SplitStyle(XSSFWorkbook wb) {
        XSSFCellStyle arialStyleYellow = wb.createCellStyle();
        Font arialfont = ExcelAndTextExporter.getArialFont(wb);
        arialStyleYellow.setFont(arialfont);
        XSSFColor color = new XSSFColor(Color.YELLOW);
        arialStyleYellow.setFillForegroundColor(color);
        arialStyleYellow.setFillPattern((short)1);
        return arialStyleYellow;
    }

    private static CellStyle getMs2NoSplitPossibleStyle(XSSFWorkbook wb) {
        XSSFCellStyle arialStyleOrange = wb.createCellStyle();
        Font arialfont = ExcelAndTextExporter.getArialFont(wb);
        arialStyleOrange.setFont(arialfont);
        XSSFColor color = new XSSFColor(Color.ORANGE);
        arialStyleOrange.setFillForegroundColor(color);
        arialStyleOrange.setFillPattern((short)1);
        return arialStyleOrange;
    }

    private static Font getArial12BoldFont(Workbook wb) {
        Font arial12font = ExcelAndTextExporter.getArialFont(wb);
        arial12font.setFontHeightInPoints((short)12);
        arial12font.setBoldweight((short)700);
        return arial12font;
    }

    private static Font getArialRedFont(Workbook wb) {
        Font arialfont = ExcelAndTextExporter.getArialFont(wb);
        arialfont.setColor((short)10);
        return arialfont;
    }

    private static Font getArialFont(Workbook wb) {
        Font arial12font = wb.createFont();
        arial12font.setFontName("Arial");
        return arial12font;
    }

    private static void setColumnWidth(Sheet sheet, int column, String headerValue, int longestValue) {
        int columnWidth = (int)((double)(headerValue.length() * 256) * 1.4);
        if ((longestValue + 1) * 256 > columnWidth) {
            columnWidth = (longestValue + 1) * 256;
        }
        sheet.setColumnWidth(column, columnWidth);
    }

    private static CellStyle getCorrespondingCellStyle(short evidence, CellStyle normalStyle, CellStyle ms2Unambiguous, CellStyle ms2Split, CellStyle ms2NoSplitPossible) {
        if (evidence == 1) {
            return ms2Unambiguous;
        }
        if (evidence == 2) {
            return ms2Split;
        }
        if (evidence == 3) {
            return ms2NoSplitPossible;
        }
        return normalStyle;
    }
}

