/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.export;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.ExportException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.RetentionTimeGroupingException;
import at.tugraz.genome.lda.export.vos.EvidenceBase;
import at.tugraz.genome.lda.export.vos.EvidenceVO;
import at.tugraz.genome.lda.export.vos.FeatureVO;
import at.tugraz.genome.lda.export.vos.SpeciesExportVO;
import at.tugraz.genome.lda.export.vos.SummaryVO;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.hydroxy.parser.HydroxyEncoding;
import at.tugraz.genome.lda.msn.vos.IntensityPositionVO;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.QuantificationResult;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.DoubleBondPositionVO;
import at.tugraz.genome.lda.vos.DoubleStringVO;
import at.tugraz.genome.lda.vos.ResultAreaVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.voutils.GeneralComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;

public abstract class LDAExporter {
    protected static Hashtable<String, Vector<LipidParameterSet>> getRelevantOriginalResults(Vector<LipidParameterSet> all, ResultAreaVO areaVO, boolean msnOnly) {
        Hashtable<String, Vector<LipidParameterSet>> results = new Hashtable<String, Vector<LipidParameterSet>>();
        for (LipidParameterSet set : all) {
            if (msnOnly && !(set instanceof LipidomicsMSnSet) || !areaVO.getMoleculeNameWoRT().equalsIgnoreCase(set.getNameStringWithoutRt()) || !areaVO.belongsRtToThisAreaVO(set.getRt(), set.getModificationName())) continue;
            Vector<LipidParameterSet> ofOneMod = new Vector<LipidParameterSet>();
            if (results.containsKey(set.getModificationName())) {
                ofOneMod = results.get(set.getModificationName());
            }
            ofOneMod.add(set);
            results.put(set.getModificationName(), ofOneMod);
        }
        return results;
    }

    protected static String isSpeciesAlreadyInList(String species, Vector<String> molecularSpecies) throws LipidCombinameEncodingException {
        for (String other : molecularSpecies) {
            if (!species.equalsIgnoreCase(other) && !StaticUtils.isAPermutedVersion(species, other, "_")) continue;
            return other;
        }
        return null;
    }

    protected static HashMap<String, String> replaceSpeciesByPositionAccordingToEvidence(Vector<String> molecularSpecies, Hashtable<String, Integer> molSpeciesCount, Hashtable<String, Hashtable<String, Integer>> positionCount, Hashtable<String, Vector<String>> ambiguous) {
        HashMap<String, String> newValues = new HashMap<String, String>();
        for (String woPosition : molecularSpecies) {
            int totalCount = molSpeciesCount.get(woPosition);
            Hashtable<String, Integer> positionsFound = positionCount.get(woPosition);
            boolean usePositionIdentification = false;
            if (positionsFound.size() == 1) {
                int detections = positionsFound.values().iterator().next();
                if (ambiguous != null && ambiguous.containsKey(woPosition)) {
                    boolean allDetected = true;
                    String detected = positionsFound.keySet().iterator().next();
                    for (String ambi : ambiguous.get(woPosition)) {
                        String[] possibilities;
                        boolean oneTimeCorrect = false;
                        for (String onePossibility : possibilities = ambi.split(";")) {
                            if (!onePossibility.equalsIgnoreCase(detected)) continue;
                            oneTimeCorrect = true;
                            break;
                        }
                        if (oneTimeCorrect) {
                            ++detections;
                            continue;
                        }
                        allDetected = false;
                        break;
                    }
                    if (!allDetected) {
                        detections = 0;
                    }
                }
                usePositionIdentification = true;
            }
            if (usePositionIdentification) {
                newValues.put(positionsFound.keySet().iterator().next(), woPosition);
                continue;
            }
            newValues.put(woPosition, woPosition);
        }
        return newValues;
    }

    /*
     * WARNING - void declaration
     */
    protected static SpeciesExportVO extractExportableSummaryInformation(short speciesType, boolean exportDoubleBondPositionsForClass, boolean extractFeatures, int currentSummaryId, int currentFeatureId, boolean extractEvidence, int currentEvidenceId, int currentEvGroupingId, boolean isRtGrouped, LinkedHashMap<String, Boolean> adductsSorted, Vector<String> expNames, LinkedHashMap<String, Vector<String>> expsOfGroup, String molName, Hashtable<String, Vector<Double>> resultsMol, Hashtable<String, Hashtable<String, Vector<LipidParameterSet>>> relevantOriginals, int maxIsotope, HydroxyEncoding faHydroxyEncoding, HydroxyEncoding lcbHydroxyEncoding) throws ExportException, SpectrummillParserException, LipidCombinameEncodingException, RetentionTimeGroupingException {
        if (extractEvidence && !extractFeatures) {
            throw new ExportException("It is not possible to extract the evidence without extracting the features");
        }
        String chemFormula = "";
        Double neutralMassTheoretical = null;
        Vector<DoubleBondPositionVO> allAssignedDoubleBondPositions = new Vector<DoubleBondPositionVO>();
        if (relevantOriginals != null) {
            block4: for (Hashtable<String, Vector<LipidParameterSet>> origs : relevantOriginals.values()) {
                if (origs.size() == 0) continue;
                if (chemFormula.length() > 0) break;
                block5: for (Vector<LipidParameterSet> sets : origs.values()) {
                    if (sets.size() == 0) continue;
                    if (chemFormula.length() > 0) continue block4;
                    for (LipidParameterSet set : sets) {
                        try {
                            Hashtable<String, Integer> categorized = StaticUtils.categorizeFormula(set.getAnalyteFormula());
                            chemFormula = StaticUtils.getFormulaInHillNotation(categorized, false);
                            neutralMassTheoretical = Settings.getElementParser().calculateTheoreticalMass(StaticUtils.getFormulaInHillNotation(categorized, true), false);
                            continue block5;
                        }
                        catch (ChemicalFormulaException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        Vector<SummaryVO> speciesSummaries = new Vector<SummaryVO>();
        String molNameWORt = new String(molName);
        if (isRtGrouped) {
            molNameWORt = molName.substring(0, molName.lastIndexOf("_"));
        }
        LinkedHashMap<String, FeatureVO> features = null;
        if (extractFeatures) {
            features = new LinkedHashMap<String, FeatureVO>();
            for (String mod : adductsSorted.keySet()) {
                boolean foundOneHit = false;
                double totalArea = 0.0;
                double areaTimesMz = 0.0;
                double weightedMz = 0.0;
                double areaTimesRt = 0.0;
                double weightedRt = 0.0;
                int charge = 0;
                float f = Float.MAX_VALUE;
                float stopRt = 0.0f;
                Vector<Double> vector = new Vector<Double>();
                for (String expName : expNames) {
                    if (!relevantOriginals.containsKey(expName) || !relevantOriginals.get(expName).containsKey(mod)) {
                        vector.add(null);
                        continue;
                    }
                    Vector<LipidParameterSet> sets = relevantOriginals.get(expName).get(mod);
                    double areaOfAssay = 0.0;
                    for (LipidParameterSet set : sets) {
                        if (charge == 0) {
                            charge = set.getCharge();
                        }
                        double areaOfOnePeak = set.getArea(maxIsotope);
                        double areaOfSet = 0.0;
                        double areaTimesMzOfSet = 0.0;
                        double areaTimesRtOfSet = 0.0;
                        boolean lowerRtHardLimitSet = false;
                        boolean upperRtHardLimitSet = false;
                        if (set.getLowerRtHardLimit() > 0.0f) {
                            if (set.getLowerRtHardLimit() < f) {
                                f = set.getLowerRtHardLimit();
                            }
                            lowerRtHardLimitSet = true;
                        }
                        if (set.getUpperRtHardLimit() > 0.0f) {
                            if (set.getUpperRtHardLimit() > stopRt) {
                                stopRt = set.getUpperRtHardLimit();
                            }
                            upperRtHardLimitSet = true;
                        }
                        for (CgProbe probe : set.getIsotopicProbes().get(0)) {
                            areaOfSet += (double)probe.Area;
                            areaTimesMzOfSet += (double)probe.Area * (double)probe.Mz;
                            areaTimesRtOfSet += (double)probe.Area * (double)probe.Peak;
                            if (!lowerRtHardLimitSet && probe.LowerValley < f) {
                                f = probe.LowerValley;
                            }
                            if (upperRtHardLimitSet || !(probe.UpperValley > stopRt)) continue;
                            stopRt = probe.UpperValley;
                        }
                        double weightedMeanArea = areaTimesMzOfSet / areaOfSet;
                        double d = areaTimesRtOfSet / areaOfSet;
                        totalArea += areaOfOnePeak;
                        areaOfAssay += areaOfOnePeak;
                        areaTimesMz += weightedMeanArea * areaOfOnePeak;
                        areaTimesRt += d * areaOfOnePeak;
                    }
                    if (sets.size() > 0) {
                        foundOneHit = true;
                        weightedMz = areaTimesMz / totalArea;
                        weightedRt = areaTimesRt / totalArea;
                    }
                    vector.add(areaOfAssay > 0.0 ? Double.valueOf(areaOfAssay) : null);
                }
                if (!foundOneHit) continue;
                FeatureVO featureVO = new FeatureVO(currentFeatureId, mod, weightedMz, charge, weightedRt, f, stopRt, vector);
                ++currentFeatureId;
                features.put(mod, featureVO);
            }
        }
        if (speciesType == 0) {
            Hashtable<String, Double> areas = LDAExporter.calculateRelativeAreas(null, resultsMol, null);
            String strongestExp = LDAExporter.getStrongestExp(areas);
            int mzTabReliability = 3;
            float rTime = 0.0f;
            Vector<String> adducts = null;
            Hashtable<String, Hashtable<String, Double>> rtsOfMods = new Hashtable<String, Hashtable<String, Double>>();
            Hashtable<String, Hashtable<String, Hashtable<String, Short>>> evidenceReliabilityOfMods = new Hashtable<String, Hashtable<String, Hashtable<String, Short>>>();
            if (relevantOriginals != null) {
                Hashtable<String, String> foundMods = new Hashtable<String, String>();
                for (String exp : relevantOriginals.keySet()) {
                    Hashtable<String, Vector<LipidParameterSet>> hashtable = relevantOriginals.get(exp);
                    if (exportDoubleBondPositionsForClass) {
                        for (Vector vector : hashtable.values()) {
                            for (LipidParameterSet lipidParameterSet : vector) {
                                if (!lipidParameterSet.hasOmegaInformation()) continue;
                                allAssignedDoubleBondPositions.addAll(StaticUtils.getAssignedDoubleBondPositions(lipidParameterSet.getOmegaInformation()));
                            }
                        }
                    }
                    for (String string : hashtable.keySet()) {
                        foundMods.put(string, string);
                        short evidence = 0;
                        for (LipidParameterSet lipidParameterSet : hashtable.get(string)) {
                            short otherEvidence;
                            if (mzTabReliability == 3 && lipidParameterSet instanceof LipidomicsMSnSet && ((LipidomicsMSnSet)lipidParameterSet).getStatus() >= 2) {
                                mzTabReliability = 2;
                            }
                            if ((otherEvidence = StaticUtils.determineEvidenceStateOfHit(lipidParameterSet)) <= evidence) continue;
                            evidence = otherEvidence;
                        }
                        LDAExporter.storeEvidenceToHash(evidence, evidenceReliabilityOfMods, molName, string, exp);
                        Vector rtAndArea = LDAExporter.getRtOfHighestZeroIsoArea((Collection<LipidParameterSet>)hashtable.get(string));
                        if (!rtsOfMods.containsKey(string)) {
                            rtsOfMods.put(string, new Hashtable());
                        }
                        rtsOfMods.get(string).put(exp, (Double)rtAndArea.get(0) / 60.0);
                    }
                }
                if (strongestExp != null) {
                    Vector<LipidParameterSet> allParams = new Vector<LipidParameterSet>();
                    for (Vector<LipidParameterSet> vector : relevantOriginals.get(strongestExp).values()) {
                        allParams.addAll(vector);
                    }
                    Vector rtAndArea = LDAExporter.getRtOfHighestZeroIsoArea(allParams);
                    rTime = ((Double)rtAndArea.get(0)).floatValue();
                }
                adducts = LDAExporter.getSortedModifications(adductsSorted, foundMods);
            }
            Vector<Integer> featureRefs = LDAExporter.getFeatureRefs(molName, adducts, features);
            String displayString = null;
            if (exportDoubleBondPositionsForClass) {
                for (DoubleBondPositionVO assignedDoubleBondPosition : allAssignedDoubleBondPositions) {
                    String assignedSpecies = assignedDoubleBondPosition.getDoubleBondPositionsHumanReadable(speciesType);
                    if (displayString != null && !displayString.equals(assignedSpecies)) {
                        System.out.println(String.format("Analytes with differing assigned double bond positions have been grouped together (%s and %s).Consider lowering the setting for 'Show hits with different RT separately' in the 'Selection' tab.", displayString, assignedSpecies));
                        displayString = null;
                        break;
                    }
                    displayString = assignedSpecies;
                }
            }
            SummaryVO sumVO = new SummaryVO(currentSummaryId, molName, displayString, featureRefs, chemFormula, neutralMassTheoretical, Float.valueOf(rTime), adducts, mzTabReliability, areas, rtsOfMods, (Hashtable)evidenceReliabilityOfMods.get(molName), expsOfGroup);
            ++currentSummaryId;
            speciesSummaries.add(sumVO);
        } else if (speciesType == 1 || speciesType == 2) {
            void var38_81;
            Vector<String> species = new Vector<String>();
            int mzTabReliabilityOfSumSpecies = 3;
            Vector<String> molecularSpecies = new Vector<String>();
            Hashtable<String, Hashtable<String, Integer>> positionCount = new Hashtable<String, Hashtable<String, Integer>>();
            Hashtable<String, Integer> molSpeciesCount = new Hashtable<String, Integer>();
            Hashtable<String, Vector<String>> ambiguousOnes = new Hashtable<String, Vector<String>>();
            HashMap<String, String> positionToWithoutHash = null;
            Hashtable<String, Hashtable<String, Double>> percentalSplits = new Hashtable<String, Hashtable<String, Double>>();
            Hashtable<String, Hashtable<String, Float>> highestRts = new Hashtable<String, Hashtable<String, Float>>();
            Hashtable<String, Hashtable> modsOfSpecies = new Hashtable<String, Hashtable>();
            Hashtable rtsOfMods = new Hashtable();
            Hashtable<String, Hashtable<String, Hashtable<String, Short>>> evidenceReliabilityOfMods = new Hashtable<String, Hashtable<String, Hashtable<String, Short>>>();
            for (String expName : expNames) {
                if (!relevantOriginals.containsKey(expName)) continue;
                Hashtable<String, Vector<LipidParameterSet>> hashtable = relevantOriginals.get(expName);
                Vector<LipidParameterSet> allSets = new Vector<LipidParameterSet>();
                for (Vector<LipidParameterSet> vector : hashtable.values()) {
                    allSets.addAll(vector);
                }
                if (exportDoubleBondPositionsForClass) {
                    for (LipidParameterSet lipidParameterSet : allSets) {
                        if (!lipidParameterSet.hasOmegaInformation()) continue;
                        allAssignedDoubleBondPositions.addAll(StaticUtils.getAssignedDoubleBondPositions(lipidParameterSet.getOmegaInformation()));
                    }
                }
                Hashtable<String, Float> hashtable2 = new Hashtable<String, Float>();
                Hashtable<String, Float> hashtable3 = new Hashtable<String, Float>();
                if (StaticUtils.isThereChainInformationAvailable(molNameWORt, allSets)) {
                    Object sets;
                    Hashtable<String, Double> totalAreasOfMolSpecies = new Hashtable<String, Double>();
                    Vector<String> modsWoChainAssignment = new Vector<String>();
                    for (String mod : adductsSorted.keySet()) {
                        if (!hashtable.containsKey(mod) || StaticUtils.isThereChainInformationAvailable(molNameWORt, hashtable.get(mod))) continue;
                        modsWoChainAssignment.add(mod);
                    }
                    for (String mod : adductsSorted.keySet()) {
                        if (!hashtable.containsKey(mod)) continue;
                        sets = hashtable.get(mod);
                        double areaOfMod = 0.0;
                        Hashtable<String, Double> molSpeciesAreasOfMod = new Hashtable<String, Double>();
                        Hashtable highestAreas = new Hashtable();
                        Iterator iterator = ((Vector)sets).iterator();
                        while (iterator.hasNext()) {
                            LipidParameterSet set = (LipidParameterSet)iterator.next();
                            double areaOfOnePeak = set.getArea(maxIsotope);
                            areaOfMod += areaOfOnePeak;
                            short evidence = StaticUtils.determineEvidenceStateOfHit(set);
                            if (!(set instanceof LipidomicsMSnSet) || ((LipidomicsMSnSet)set).getStatus() <= 2) continue;
                            LipidomicsMSnSet msn = (LipidomicsMSnSet)set;
                            float highestProbeArea = 0.0f;
                            float rtOfHighestProbe = 0.0f;
                            for (CgProbe cgProbe : msn.getIsotopicProbes().get(0)) {
                                if (!(cgProbe.Area > highestProbeArea)) continue;
                                highestProbeArea = cgProbe.Area;
                                rtOfHighestProbe = cgProbe.Peak;
                            }
                            int currIdentificationNumber = -1;
                            for (Object object : msn.getMSnIdentificationNames()) {
                                String detection = null;
                                String detectionWithAmbuiguities = null;
                                String detectionSn = null;
                                ++currIdentificationNumber;
                                if (object instanceof Vector) {
                                    detection = (String)((Vector)object).get(0);
                                    detectionSn = msn.getMSnIdentificationNamesWithSNPositions().get(currIdentificationNumber);
                                    detectionWithAmbuiguities = "";
                                    if (((Vector)object).size() > 1) {
                                        for (String name : (Vector)object) {
                                            if (detectionWithAmbuiguities.length() > 0) {
                                                detectionWithAmbuiguities = detectionWithAmbuiguities + ";";
                                            }
                                            detectionWithAmbuiguities = detectionWithAmbuiguities + name;
                                        }
                                    }
                                } else if (object instanceof String) {
                                    detection = (String)object;
                                    detectionSn = (String)object;
                                }
                                if (detection == null) {
                                    throw new ExportException("It is not possible that one MSn detection is null!");
                                }
                                String woPosition = StaticUtils.sortFASequenceUnassigned(detection.replaceAll("/", "_"), "_");
                                while (woPosition.endsWith("_-")) {
                                    woPosition = woPosition.substring(0, woPosition.length() - 2);
                                }
                                String speciesInList = LDAExporter.isSpeciesAlreadyInList(woPosition, molecularSpecies);
                                Hashtable<Object, Object> positions = new Hashtable();
                                int count = 0;
                                float highestPeakAreaOfAll = 0.0f;
                                float rtOfHighestPeakAreaOfAll = 0.0f;
                                if (speciesInList != null) {
                                    woPosition = speciesInList;
                                    positions = positionCount.get(woPosition);
                                    count = molSpeciesCount.get(woPosition);
                                    if (hashtable2.containsKey(woPosition)) {
                                        highestPeakAreaOfAll = ((Float)hashtable2.get(woPosition)).floatValue();
                                        rtOfHighestPeakAreaOfAll = ((Float)hashtable3.get(woPosition)).floatValue();
                                    }
                                } else {
                                    molecularSpecies.add(woPosition);
                                }
                                double relativeArea = 0.0;
                                if (molSpeciesAreasOfMod.containsKey(woPosition)) {
                                    relativeArea = (Double)molSpeciesAreasOfMod.get(woPosition);
                                }
                                double relativePercentage = msn.getRelativeIntensity(detectionSn);
                                molSpeciesAreasOfMod.put(woPosition, relativeArea += relativePercentage * areaOfOnePeak);
                                if (adductsSorted.containsKey(mod) && adductsSorted.get(mod).booleanValue()) {
                                    ++count;
                                    if (detection.contains("/")) {
                                        if (detectionWithAmbuiguities != null) {
                                            Vector<String> ambiguous = new Vector<String>();
                                            if (ambiguousOnes.containsKey(woPosition)) {
                                                ambiguous = ambiguousOnes.get(woPosition);
                                            }
                                            ambiguous.add(detectionWithAmbuiguities);
                                            ambiguousOnes.put(woPosition, ambiguous);
                                        } else {
                                            int posCount = 0;
                                            if (positions.containsKey(detection)) {
                                                posCount = (Integer)positions.get(detection);
                                            }
                                            positions.put(detection, ++posCount);
                                        }
                                    }
                                }
                                positionCount.put(woPosition, positions);
                                molSpeciesCount.put(woPosition, count);
                                if (relativePercentage * (double)highestProbeArea > (double)highestPeakAreaOfAll) {
                                    highestPeakAreaOfAll = (float)relativePercentage * highestProbeArea;
                                    rtOfHighestPeakAreaOfAll = rtOfHighestProbe;
                                }
                                hashtable2.put(woPosition, Float.valueOf(highestPeakAreaOfAll));
                                hashtable3.put(woPosition, Float.valueOf(rtOfHighestPeakAreaOfAll));
                                float highestArea = 0.0f;
                                if (highestAreas.containsKey(woPosition)) {
                                    highestArea = ((Float)highestAreas.get(woPosition)).floatValue();
                                }
                                if (relativePercentage * areaOfOnePeak > (double)highestArea) {
                                    highestAreas.put(woPosition, Float.valueOf(highestArea));
                                    if (!rtsOfMods.containsKey(woPosition)) {
                                        rtsOfMods.put(woPosition, new Hashtable());
                                    }
                                    if (!((Hashtable)rtsOfMods.get(woPosition)).containsKey(mod)) {
                                        ((Hashtable)rtsOfMods.get(woPosition)).put(mod, new Hashtable());
                                    }
                                    ((Hashtable)((Hashtable)rtsOfMods.get(woPosition)).get(mod)).put(expName, Double.parseDouble(set.getRt()));
                                    for (String aMod : modsWoChainAssignment) {
                                        if (!((Hashtable)rtsOfMods.get(woPosition)).containsKey(aMod)) {
                                            ((Hashtable)rtsOfMods.get(woPosition)).put(aMod, new Hashtable());
                                        }
                                        if (((Hashtable)((Hashtable)rtsOfMods.get(woPosition)).get(aMod)).containsKey(expName) || !hashtable.containsKey(aMod) || hashtable.get(aMod).size() == 0) continue;
                                        Vector rtAndArea = LDAExporter.getRtOfHighestZeroIsoArea((Collection<LipidParameterSet>)hashtable.get(aMod));
                                        ((Hashtable)((Hashtable)rtsOfMods.get(woPosition)).get(aMod)).put(expName, (Double)rtAndArea.get(0) / 60.0);
                                    }
                                }
                                Hashtable mods = new Hashtable();
                                if (modsOfSpecies.containsKey(woPosition)) {
                                    mods = (Hashtable)modsOfSpecies.get(woPosition);
                                }
                                mods.put(mod, mod);
                                for (String aMod : modsWoChainAssignment) {
                                    mods.put(aMod, aMod);
                                }
                                modsOfSpecies.put(woPosition, mods);
                                LDAExporter.storeEvidenceToHash(evidence, evidenceReliabilityOfMods, woPosition, mod, expName);
                            }
                        }
                        double totalMsnModArea = 0.0;
                        for (Double area : molSpeciesAreasOfMod.values()) {
                            totalMsnModArea += area.doubleValue();
                        }
                        for (String molSpecies : molSpeciesAreasOfMod.keySet()) {
                            double percentage = (Double)molSpeciesAreasOfMod.get(molSpecies) / totalMsnModArea;
                            double totalAreaOfOneMolSpecies = 0.0;
                            if (totalAreasOfMolSpecies.containsKey(molSpecies)) {
                                totalAreaOfOneMolSpecies = (Double)totalAreasOfMolSpecies.get(molSpecies);
                            }
                            totalAreasOfMolSpecies.put(molSpecies, totalAreaOfOneMolSpecies += percentage * areaOfMod);
                        }
                    }
                    double totalArea = 0.0;
                    sets = totalAreasOfMolSpecies.values().iterator();
                    while (sets.hasNext()) {
                        double area = (Double)sets.next();
                        totalArea += area;
                    }
                    Hashtable<Object, Double> splitsForExp = new Hashtable<Object, Double>();
                    for (Object molSpecies : totalAreasOfMolSpecies.keySet()) {
                        splitsForExp.put(molSpecies, (Double)totalAreasOfMolSpecies.get(molSpecies) / totalArea);
                    }
                    percentalSplits.put(expName, splitsForExp);
                } else {
                    Object molSpecies;
                    if (species.size() == 0) {
                        species.add(molName);
                    }
                    Hashtable<String, Double> splitsForExp = new Hashtable<String, Double>();
                    splitsForExp.put(molName, 1.0);
                    percentalSplits.put(expName, splitsForExp);
                    Hashtable mods = new Hashtable();
                    if (modsOfSpecies.containsKey(molName)) {
                        mods = (Hashtable)modsOfSpecies.get(molName);
                    }
                    float highestPeakAreaOfAll = 0.0f;
                    float rtOfHighestPeakAreaOfAll = 0.0f;
                    molSpecies = hashtable.keySet().iterator();
                    while (molSpecies.hasNext()) {
                        String aMod = molSpecies.next();
                        mods.put(aMod, aMod);
                        short evidence = 0;
                        for (LipidParameterSet set : hashtable.get(aMod)) {
                            short currentEvidence;
                            if (mzTabReliabilityOfSumSpecies == 3 && set instanceof LipidomicsMSnSet && ((LipidomicsMSnSet)set).getStatus() >= 2) {
                                mzTabReliabilityOfSumSpecies = 2;
                            }
                            if ((currentEvidence = StaticUtils.determineEvidenceStateOfHit(set)) <= evidence) continue;
                            evidence = currentEvidence;
                        }
                        LDAExporter.storeEvidenceToHash(evidence, evidenceReliabilityOfMods, molName, aMod, expName);
                        Vector rtAndArea = LDAExporter.getRtOfHighestZeroIsoArea((Collection<LipidParameterSet>)hashtable.get(aMod));
                        double rtOfHighest = (Double)rtAndArea.get(0) / 60.0;
                        float highestArea = ((Float)rtAndArea.get(1)).floatValue();
                        if (highestArea > highestPeakAreaOfAll) {
                            highestPeakAreaOfAll = highestArea;
                            rtOfHighestPeakAreaOfAll = (float)(rtOfHighest * 60.0);
                        }
                        if (!rtsOfMods.containsKey(molName)) {
                            rtsOfMods.put(molName, new Hashtable());
                        }
                        if (!((Hashtable)rtsOfMods.get(molName)).containsKey(aMod)) {
                            ((Hashtable)rtsOfMods.get(molName)).put(aMod, new Hashtable());
                        }
                        ((Hashtable)((Hashtable)rtsOfMods.get(molName)).get(aMod)).put(expName, rtOfHighest);
                    }
                    hashtable3.put(molName, Float.valueOf(rtOfHighestPeakAreaOfAll));
                    modsOfSpecies.put(molName, mods);
                }
                highestRts.put(expName, hashtable3);
            }
            if (speciesType == 2) {
                positionToWithoutHash = LDAExporter.replaceSpeciesByPositionAccordingToEvidence(molecularSpecies, molSpeciesCount, positionCount, ambiguousOnes);
                molecularSpecies = new Vector();
                for (String molSpecies : positionToWithoutHash.keySet()) {
                    molecularSpecies.add(molSpecies);
                }
            }
            for (String aSpecies : species) {
                Hashtable<String, Double> hashtable = LDAExporter.calculateRelativeAreas(aSpecies, resultsMol, percentalSplits);
                Float rTime = Float.valueOf(LDAExporter.getRtOfHighestPeak(aSpecies, hashtable, highestRts));
                Vector<String> vector = LDAExporter.getSortedModifications(adductsSorted, (Hashtable)modsOfSpecies.get(aSpecies));
                Vector<Integer> vector2 = LDAExporter.getFeatureRefs(aSpecies, vector, features);
                SummaryVO sumVO = new SummaryVO(currentSummaryId, aSpecies, null, vector2, chemFormula, neutralMassTheoretical, rTime, vector, mzTabReliabilityOfSumSpecies, hashtable, (Hashtable)rtsOfMods.get(molName), (Hashtable)evidenceReliabilityOfMods.get(molName), expsOfGroup);
                ++currentSummaryId;
                speciesSummaries.add(sumVO);
            }
            Hashtable<String, SummaryVO> hashtable = new Hashtable<String, SummaryVO>();
            ArrayList<DoubleStringVO> molSpeciesTotalAreas = new ArrayList<DoubleStringVO>();
            for (String aSpecies : molecularSpecies) {
                String string = positionToWithoutHash == null ? aSpecies : positionToWithoutHash.get(aSpecies);
                Hashtable<String, Double> hashtable4 = LDAExporter.calculateRelativeAreas(string, resultsMol, percentalSplits);
                Float rTime = Float.valueOf(LDAExporter.getRtOfHighestPeak(string, hashtable4, highestRts));
                Vector<String> adducts = LDAExporter.getSortedModifications(adductsSorted, (Hashtable)modsOfSpecies.get(string));
                Vector<Integer> featureRefs = LDAExporter.getFeatureRefs(aSpecies, adducts, features);
                String displayString = aSpecies;
                if (exportDoubleBondPositionsForClass) {
                    displayString = LDAExporter.getDoubleBondPositionDisplayString(aSpecies, allAssignedDoubleBondPositions);
                }
                SummaryVO sumVO = new SummaryVO(molName, displayString, featureRefs, chemFormula, neutralMassTheoretical, rTime, adducts, 2, hashtable4, (Hashtable)rtsOfMods.get(string), (Hashtable)evidenceReliabilityOfMods.get(string), expsOfGroup);
                hashtable.put(aSpecies, sumVO);
                double totalArea = 0.0;
                for (Double area : hashtable4.values()) {
                    totalArea += area.doubleValue();
                }
                molSpeciesTotalAreas.add(new DoubleStringVO(aSpecies, totalArea));
            }
            Collections.sort(molSpeciesTotalAreas, new GeneralComparator("at.tugraz.genome.lda.vos.DoubleStringVO", "getValue", "java.lang.Double"));
            int n = molSpeciesTotalAreas.size() - 1;
            while (var38_81 != -1) {
                SummaryVO sumVO = (SummaryVO)hashtable.get(((DoubleStringVO)molSpeciesTotalAreas.get((int)var38_81)).getKey());
                sumVO.setId(currentSummaryId);
                ++currentSummaryId;
                speciesSummaries.add(sumVO);
                --var38_81;
            }
        }
        Vector<EvidenceVO> evidence = null;
        if (extractEvidence && extractFeatures) {
            evidence = new Vector<EvidenceVO>();
            for (String mod : features.keySet()) {
                FeatureVO feature = features.get(mod);
                EvidenceBase base = new EvidenceBase(mod, feature.getCharge());
                Vector<String> speciesToCheck = new Vector<String>();
                speciesToCheck.add(molName);
                Hashtable<String, SummaryVO> speciesToSummary = new Hashtable<String, SummaryVO>();
                if (speciesSummaries.size() > 0 && speciesSummaries.get(0).getMolecularId() == null) {
                    speciesToSummary.put(molName, speciesSummaries.get(0));
                }
                for (SummaryVO summary : speciesSummaries) {
                    if (summary.getMolecularId() == null) continue;
                    speciesToCheck.add(summary.getMolecularId());
                    speciesToSummary.put(summary.getMolecularId(), summary);
                }
                Hashtable evGroupingIdLookup = new Hashtable();
                for (String species : speciesToCheck) {
                    String molecularSpecies = null;
                    if (speciesToSummary.containsKey(species) && ((SummaryVO)speciesToSummary.get(species)).getMolecularId() != null) {
                        molecularSpecies = ((SummaryVO)speciesToSummary.get(species)).getMolecularId();
                    }
                    String noPosition = null;
                    boolean bl = false;
                    if (molecularSpecies != null) {
                        noPosition = StaticUtils.sortFASequenceUnassigned(molecularSpecies.replaceAll("/", "_"), "_");
                        while (noPosition.endsWith("_-")) {
                            noPosition = noPosition.substring(0, noPosition.length() - 2);
                        }
                        if (molecularSpecies.indexOf("/") != -1 && !StaticUtils.areAllChainsTheSame(molecularSpecies)) {
                            bl = true;
                        }
                    }
                    LipidParameterSet oneSet = null;
                    Object var40_106 = null;
                    neutralMassTheoretical = null;
                    for (String expName : expNames) {
                        void var40_107;
                        if (!evGroupingIdLookup.containsKey(expName)) {
                            evGroupingIdLookup.put(expName, new Hashtable());
                        }
                        String speciesId = new String(molName);
                        Object var36_200 = null;
                        boolean hasHitPositionInfo = false;
                        if (!relevantOriginals.containsKey(expName) || !relevantOriginals.get(expName).containsKey(mod) || speciesToSummary.containsKey(species) && ((SummaryVO)speciesToSummary.get(species)).getArea(expName) == 0.0) continue;
                        Vector<LipidParameterSet> sets = relevantOriginals.get(expName).get(mod);
                        boolean evaluate = false;
                        if (molecularSpecies == null) {
                            if (speciesType == 0 || !StaticUtils.isThereChainInformationAvailable(molNameWORt, sets)) {
                                evaluate = true;
                            }
                        } else if (StaticUtils.isThereChainInformationAvailable(molNameWORt, sets)) {
                            evaluate = true;
                        }
                        if (!evaluate) continue;
                        String bestIdentification = null;
                        HashSet<Integer> msLevels = new HashSet<Integer>();
                        double weightedMz = 0.0;
                        double totalArea = 0.0;
                        double areaTimesMz = 0.0;
                        boolean foundOneHit = false;
                        Hashtable<Integer, Set<Integer>> scanNrs = new Hashtable<Integer, Set<Integer>>();
                        for (LipidParameterSet set : relevantOriginals.get(expName).get(mod)) {
                            if (!(set instanceof LipidomicsMSnSet) || ((LipidomicsMSnSet)set).getStatus() < 2) continue;
                            evaluate = false;
                            oneSet = set;
                            LipidomicsMSnSet msn = (LipidomicsMSnSet)set;
                            if (molecularSpecies != null) {
                                for (Object object : msn.getMSnIdentificationNames()) {
                                    void var61_222;
                                    Object var61_219 = null;
                                    if (object instanceof Vector) {
                                        String string = (String)((Vector)object).get(0);
                                    } else if (object instanceof String) {
                                        String string = (String)object;
                                    }
                                    if (var61_222 == null) {
                                        throw new ExportException("It is not possible that one MSn detection is null!");
                                    }
                                    String woPosition = StaticUtils.sortFASequenceUnassigned(var61_222.replaceAll("/", "_"), "_");
                                    while (woPosition.endsWith("_-")) {
                                        woPosition = woPosition.substring(0, woPosition.length() - 2);
                                    }
                                    if (!StaticUtils.isAPermutedVersion(woPosition, noPosition, "_")) continue;
                                    evaluate = true;
                                    Set<Integer> msnLevels = msn.getMSLevels((String)var61_222, faHydroxyEncoding, lcbHydroxyEncoding);
                                    msLevels.addAll(msnLevels);
                                    LDAExporter.addMsnScanNrsToHash(expName, msnLevels, msn.getMsnRetentionTimes(), scanNrs);
                                    String identification = var61_222;
                                    if (object instanceof Vector) {
                                        identification = "";
                                        for (String name : (Vector)object) {
                                            if (identification.length() > 0) {
                                                identification = identification + " | ";
                                            }
                                            identification = identification + name;
                                        }
                                    }
                                    if (bestIdentification == null) {
                                        bestIdentification = identification;
                                    } else if (bestIdentification.contains("/")) {
                                        if (bestIdentification.contains("|") && identification.contains("/") && !identification.contains("|")) {
                                            bestIdentification = identification;
                                        }
                                    } else if (identification.contains("/")) {
                                        bestIdentification = identification;
                                    }
                                    if (bl && var61_222.indexOf("/") != -1 && LDAExporter.hasPositionEvidence(msn.getPositionEvidence((String)var61_222, faHydroxyEncoding, lcbHydroxyEncoding))) {
                                        hasHitPositionInfo = true;
                                    }
                                    break;
                                }
                            } else {
                                evaluate = true;
                                bestIdentification = molNameWORt;
                                if (speciesType == 0) {
                                    Set<Integer> msnLevels = msn.getMSLevels("all", faHydroxyEncoding, lcbHydroxyEncoding);
                                    msLevels.addAll(msnLevels);
                                    LDAExporter.addMsnScanNrsToHash(expName, msnLevels, msn.getMsnRetentionTimes(), scanNrs);
                                } else if (!StaticUtils.isThereChainInformationAvailable(molNameWORt, sets)) {
                                    Set<Integer> msnLevels = msn.getMSLevels("head", faHydroxyEncoding, lcbHydroxyEncoding);
                                    msLevels.addAll(msnLevels);
                                    LDAExporter.addMsnScanNrsToHash(expName, msnLevels, msn.getMsnRetentionTimes(), scanNrs);
                                }
                            }
                            if (!evaluate) continue;
                            foundOneHit = true;
                            double areaOfOnePeak = set.getArea(maxIsotope);
                            double d = 0.0;
                            double areaTimesMzOfSet = 0.0;
                            for (CgProbe probe : set.getIsotopicProbes().get(0)) {
                                d += (double)probe.Area;
                                areaTimesMzOfSet += (double)probe.Area * (double)probe.Mz;
                            }
                            double weightedMeanArea = areaTimesMzOfSet / d;
                            totalArea += areaOfOnePeak;
                            areaTimesMz += weightedMeanArea * areaOfOnePeak;
                        }
                        if (!foundOneHit) continue;
                        if (var40_107 == null) {
                            try {
                                Hashtable<String, Integer> categorized = StaticUtils.categorizeFormula(oneSet.getChemicalFormula());
                                String string = StaticUtils.getFormulaInHillNotation(categorized, false);
                                neutralMassTheoretical = Settings.getElementParser().calculateTheoreticalMass(StaticUtils.getFormulaInHillNotation(categorized, true), false);
                            }
                            catch (ChemicalFormulaException e) {
                                e.printStackTrace();
                            }
                        }
                        if (molecularSpecies != null && bestIdentification.indexOf("/") == -1) {
                            bestIdentification = StaticUtils.sortFASequenceUnassigned(bestIdentification, "_");
                        }
                        weightedMz = areaTimesMz / totalArea;
                        if (molecularSpecies != null) {
                            if (bl && !hasHitPositionInfo) {
                                String string = noPosition;
                            } else {
                                String string = bestIdentification;
                            }
                        }
                        ArrayList msLevelsSorted = new ArrayList(msLevels);
                        Iterator iterator = msLevelsSorted.iterator();
                        while (iterator.hasNext()) {
                            void var36_203;
                            int currentGroupingId;
                            int msLevel = (Integer)iterator.next();
                            if (!((Hashtable)evGroupingIdLookup.get(expName)).containsKey(msLevel)) {
                                ((Hashtable)evGroupingIdLookup.get(expName)).put(msLevel, new Hashtable());
                            }
                            if ((currentGroupingId = LDAExporter.checkForSameGroupingEvidence((Hashtable)((Hashtable)evGroupingIdLookup.get(expName)).get(msLevel), scanNrs.get(msLevel))) == -1) {
                                currentGroupingId = currentEvGroupingId;
                                ((Hashtable)((Hashtable)evGroupingIdLookup.get(expName)).get(msLevel)).put(currentEvGroupingId, scanNrs.get(msLevel));
                                ++currentEvGroupingId;
                            }
                            evidence.add(new EvidenceVO(expName, base, currentEvidenceId, currentGroupingId, speciesId, (String)var36_203, (String)var40_107, weightedMz, neutralMassTheoretical, msLevel, scanNrs.get(msLevel)));
                            feature.addEvidenceRef(currentEvidenceId);
                            ++currentEvidenceId;
                        }
                    }
                }
            }
        }
        SpeciesExportVO exportVO = new SpeciesExportVO(currentSummaryId, speciesSummaries, currentFeatureId, features != null ? new Vector<FeatureVO>(features.values()) : new Vector(), currentEvidenceId, currentEvGroupingId, evidence);
        return exportVO;
    }

    public static String getDoubleBondPositionDisplayString(String aSpecies, Vector<DoubleBondPositionVO> allAssignedDoubleBondPositions) {
        String displayString = aSpecies;
        int snPositionLevel = aSpecies.contains("/") ? 2 : 1;
        String previousAssignedSpecies = null;
        for (DoubleBondPositionVO assignedDoubleBondPosition : allAssignedDoubleBondPositions) {
            String assignedSpecies = assignedDoubleBondPosition.getDoubleBondPositionsHumanReadable(0);
            if (!StaticUtils.isChainCombinationEquivalent(assignedSpecies, aSpecies)) continue;
            if (previousAssignedSpecies != null && !previousAssignedSpecies.equals(assignedSpecies)) {
                System.out.println(String.format("Analytes with differing assigned double bond positions have been grouped together. (%s and %s) Consider lowering the setting for 'Show hits with different RT separately' in the 'Selection' tab.", previousAssignedSpecies, assignedSpecies));
                displayString = aSpecies;
                break;
            }
            if (snPositionLevel == 1) {
                displayString = assignedSpecies;
            } else if (snPositionLevel == 2 && assignedDoubleBondPosition.areChainPositionsFixed()) {
                displayString = assignedDoubleBondPosition.getDoubleBondPositionsHumanReadable(snPositionLevel);
            } else if (snPositionLevel == 2 && assignedDoubleBondPosition.getMolecularSpecies().contains("/")) {
                displayString = assignedSpecies;
            }
            previousAssignedSpecies = assignedSpecies;
        }
        return displayString;
    }

    public static Hashtable<String, LinkedHashMap<String, Boolean>> extractAdductsSortedByAbundance(Collection<String> lClasses, Hashtable<String, QuantificationResult> originalExcelResults) {
        Hashtable<String, LinkedHashMap<String, Boolean>> adductsSorted = new Hashtable<String, LinkedHashMap<String, Boolean>>();
        for (String aClass : lClasses) {
            LinkedHashMap<String, Boolean> modsSorted = LDAExporter.extractAdductsSortedByAbundance(aClass, originalExcelResults);
            if (modsSorted == null) continue;
            adductsSorted.put(aClass, modsSorted);
        }
        return adductsSorted;
    }

    protected static LinkedHashMap<String, Boolean> extractAdductsSortedByAbundance(String aClass, Hashtable<String, QuantificationResult> originalExcelResults) {
        Hashtable<String, DoubleStringVO> areasPerAdduct = new Hashtable<String, DoubleStringVO>();
        Hashtable<String, Boolean> containsPositionInformation = new Hashtable<String, Boolean>();
        for (QuantificationResult result : originalExcelResults.values()) {
            if (!result.getIdentifications().containsKey(aClass)) continue;
            for (LipidParameterSet hit : result.getIdentifications().get(aClass)) {
                double area = 0.0;
                if (areasPerAdduct.containsKey(hit.getModificationName())) {
                    area = ((DoubleStringVO)areasPerAdduct.get(hit.getModificationName())).getValue();
                }
                if (!((area += (double)hit.getArea()) > 0.0)) continue;
                areasPerAdduct.put(hit.getModificationName(), new DoubleStringVO(hit.getModificationName(), area));
                boolean posInfo = false;
                if (containsPositionInformation.containsKey(hit.getModificationName())) {
                    posInfo = (Boolean)containsPositionInformation.get(hit.getModificationName());
                }
                if (hit instanceof LipidomicsMSnSet && ((LipidomicsMSnSet)hit).getStatus() >= 4 && ((LipidomicsMSnSet)hit).getPositionEvidence().size() > 0) {
                    boolean isARuleFulfilled = false;
                    for (Hashtable<Integer, Vector<IntensityPositionVO>> posEv : ((LipidomicsMSnSet)hit).getPositionEvidence().values()) {
                        if (LDAExporter.hasPositionEvidence(posEv)) {
                            isARuleFulfilled = true;
                        }
                        if (!isARuleFulfilled) continue;
                        break;
                    }
                    if (isARuleFulfilled) {
                        posInfo = true;
                    }
                }
                containsPositionInformation.put(hit.getModificationName(), posInfo);
            }
        }
        if (areasPerAdduct.size() == 0) {
            return null;
        }
        ArrayList unsorted = new ArrayList(areasPerAdduct.values());
        Collections.sort(unsorted, new GeneralComparator("at.tugraz.genome.lda.vos.DoubleStringVO", "getValue", "java.lang.Double"));
        LinkedHashMap<String, Boolean> modsSorted = new LinkedHashMap<String, Boolean>();
        for (int i = unsorted.size() - 1; i != -1; --i) {
            String adduct = ((DoubleStringVO)unsorted.get(i)).getKey();
            boolean positionInformation = false;
            if (containsPositionInformation.containsKey(adduct)) {
                positionInformation = (Boolean)containsPositionInformation.get(adduct);
            }
            modsSorted.put(adduct, positionInformation);
        }
        return modsSorted;
    }

    private static Hashtable<String, Double> calculateRelativeAreas(String species, Hashtable<String, Vector<Double>> expResults, Hashtable<String, Hashtable<String, Double>> percentualSplits) {
        Hashtable<String, Double> relAreas = new Hashtable<String, Double>();
        for (String exp : expResults.keySet()) {
            if (expResults.get(exp).get(0) == 0.0) {
                relAreas.put(exp, 0.0);
                continue;
            }
            if (percentualSplits != null) {
                if (!percentualSplits.get(exp).containsKey(species)) continue;
                relAreas.put(exp, expResults.get(exp).get(0) * percentualSplits.get(exp).get(species));
                continue;
            }
            relAreas.put(exp, expResults.get(exp).get(0));
        }
        return relAreas;
    }

    private static float getRtOfHighestPeak(String species, Hashtable<String, Double> areas, Hashtable<String, Hashtable<String, Float>> highestRts) {
        float rt = 0.0f;
        String strongestExp = LDAExporter.getStrongestExp(areas);
        if (strongestExp != null) {
            rt = highestRts.get(strongestExp).get(species).floatValue();
        }
        return rt;
    }

    private static String getStrongestExp(Hashtable<String, Double> areas) {
        String strongestExp = null;
        double area = 0.0;
        for (String exp : areas.keySet()) {
            if (!(areas.get(exp) > area)) continue;
            strongestExp = exp;
            area = areas.get(exp);
        }
        return strongestExp;
    }

    private static Vector<String> getSortedModifications(LinkedHashMap<String, Boolean> available, Hashtable<String, String> found) {
        Vector<String> sorted = new Vector<String>();
        for (String mod : available.keySet()) {
            if (!found.containsKey(mod)) continue;
            sorted.add(mod);
        }
        return sorted;
    }

    private static Vector<Integer> getFeatureRefs(String displayName, Vector<String> adducts, LinkedHashMap<String, FeatureVO> features) {
        if (features == null) {
            return null;
        }
        Vector<Integer> featureRefs = new Vector<Integer>();
        for (String adduct : adducts) {
            featureRefs.add(features.get(adduct).getId());
        }
        return featureRefs;
    }

    private static boolean hasPositionEvidence(Hashtable<Integer, Vector<IntensityPositionVO>> posEv) {
        if (posEv == null) {
            return false;
        }
        boolean isARuleFulfilled = false;
        for (Vector<IntensityPositionVO> rules : posEv.values()) {
            if (rules.size() <= 0) continue;
            isARuleFulfilled = true;
            break;
        }
        return isARuleFulfilled;
    }

    private static void addMsnScanNrsToHash(String expName, Set<Integer> msnLevels, Hashtable<Integer, LinkedHashMap<Integer, Float>> foundScans, Hashtable<Integer, Set<Integer>> toAdd) {
        for (Integer msLevel : msnLevels) {
            Set<Object> scans = new HashSet();
            if (toAdd.containsKey(msLevel)) {
                scans = toAdd.get(msLevel);
            }
            for (Integer scanNr : foundScans.get(msLevel).keySet()) {
                scans.add(scanNr);
            }
            toAdd.put(msLevel, scans);
        }
    }

    private static Vector getRtOfHighestZeroIsoArea(Collection<LipidParameterSet> params) {
        float highestZeroIsoArea = 0.0f;
        double rTime = -1.0;
        for (LipidParameterSet param : params) {
            float areaSplit = 1.0f;
            if (param.getPercentalSplit() > 0.0f) {
                areaSplit = param.getPercentalSplit();
            }
            for (CgProbe probe : param.getIsotopicProbes().get(0)) {
                if (!(probe.Area * areaSplit > highestZeroIsoArea)) continue;
                highestZeroIsoArea = probe.Area * areaSplit;
                rTime = probe.Peak;
            }
        }
        Vector<Number> timeAndArea = new Vector<Number>();
        timeAndArea.add(rTime);
        timeAndArea.add(Float.valueOf(highestZeroIsoArea));
        return timeAndArea;
    }

    private static void storeEvidenceToHash(short evidence, Hashtable<String, Hashtable<String, Hashtable<String, Short>>> hash, String molName, String mod, String expName) {
        if (!hash.containsKey(molName)) {
            hash.put(molName, new Hashtable());
        }
        if (!hash.get(molName).containsKey(mod)) {
            hash.get(molName).put(mod, new Hashtable());
        }
        if (!hash.get(molName).get(mod).containsKey(expName) || evidence > hash.get(molName).get(mod).get(expName)) {
            hash.get(molName).get(mod).put(expName, evidence);
        }
    }

    private static int checkForSameGroupingEvidence(Hashtable<Integer, Set<Integer>> groupIds, Set<Integer> spectra) {
        for (Integer groupId : groupIds.keySet()) {
            Set<Integer> groupSpectra = groupIds.get(groupId);
            if (spectra.size() != groupSpectra.size()) continue;
            boolean allFound = true;
            for (Integer specNr : spectra) {
                if (groupSpectra.contains(specNr)) continue;
                allFound = false;
                break;
            }
            if (!allFound) continue;
            return groupId;
        }
        return -1;
    }
}

