/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.export.vos;

import at.tugraz.genome.lda.vos.IsotopicLabelVO;
import java.util.Vector;

public class AnalyteOmegaInfoVO {
    private String analyteName_;
    private String labelDetection_;
    private Vector<IsotopicLabelVO> labels_;
    private boolean singelDoubleBond_;

    public AnalyteOmegaInfoVO(String analyteName, String labelDetection, Vector<IsotopicLabelVO> labels, boolean singleDoubleBond) {
        this.analyteName_ = analyteName;
        this.labelDetection_ = labelDetection;
        this.labels_ = labels;
        this.singelDoubleBond_ = singleDoubleBond;
    }

    public String getAnalyteName() {
        return this.analyteName_;
    }

    public String getLabelDetection() {
        return this.labelDetection_;
    }

    public Vector<IsotopicLabelVO> getLabels() {
        return this.labels_;
    }

    public String getAppliedLabelId() {
        String labelPrefix = "";
        for (IsotopicLabelVO label : this.labels_) {
            labelPrefix = labelPrefix + label.getLabelId();
        }
        return labelPrefix;
    }

    public boolean isSingelDoubleBond() {
        return this.singelDoubleBond_;
    }

    public double calculateRtIncludingTheShift(double rtOfLabeledSpecies) {
        for (IsotopicLabelVO labelVO : this.labels_) {
            rtOfLabeledSpecies /= 1.0 + (double)labelVO.getRrtShift().floatValue() / 100.0;
        }
        return rtOfLabeledSpecies;
    }
}

