/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.export.vos;

import at.tugraz.genome.lda.export.vos.EvidenceBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class EvidenceVO
extends EvidenceBase {
    private String expName_;
    private int id_;
    private int evidenceGroupingId_;
    private String chemFormula_;
    private double expMz_;
    private double theorMz_;
    private String speciesId_;
    private String ldaStructure_;
    private int msLevel_;
    private List<Integer> scanNrs_;

    public EvidenceVO(String expName, EvidenceBase base, int id, int evidenceGroupingId, String speciesId, String ldaStructure, String chemFormula, double expMz, double theorMz, int msLevel, Set<Integer> scanNrs) {
        super(base.getModification(), base.getCharge());
        this.expName_ = expName;
        this.id_ = id;
        this.evidenceGroupingId_ = evidenceGroupingId;
        this.speciesId_ = speciesId;
        this.ldaStructure_ = ldaStructure;
        this.chemFormula_ = chemFormula;
        this.expMz_ = expMz;
        this.theorMz_ = theorMz;
        this.msLevel_ = msLevel;
        this.scanNrs_ = null;
        if (scanNrs != null) {
            this.scanNrs_ = new ArrayList<Integer>(scanNrs);
            Collections.sort(this.scanNrs_);
        }
    }

    public String getExpName() {
        return this.expName_;
    }

    public int getId() {
        return this.id_;
    }

    public int getEvidenceGroupingId() {
        return this.evidenceGroupingId_;
    }

    public String getSpeciesId() {
        return this.speciesId_;
    }

    public String getLdaStructure() {
        return this.ldaStructure_;
    }

    public String getChemFormula() {
        return this.chemFormula_;
    }

    public double getExpMz() {
        return this.expMz_;
    }

    public double getTheorMz() {
        return this.theorMz_;
    }

    public int getMsLevel() {
        return this.msLevel_;
    }

    public List<Integer> getScanNrs() {
        if (this.scanNrs_ != null) {
            return this.scanNrs_;
        }
        return null;
    }
}

