/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.export.vos;

import at.tugraz.genome.lda.vos.ExportOptionsVO;
import at.tugraz.genome.maspectras.utils.Calculator;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Vector;

public class SummaryVO {
    private Integer id_;
    private String speciesId_;
    private Vector<Integer> featureRefs_;
    private String molecularId_;
    private String chemFormula_;
    private Double neutralMass_;
    private Vector<String> mods_;
    private int mzTabReliability_;
    private Hashtable<String, Double> areas_;
    private LinkedHashMap<String, Double> groupMeans_;
    private LinkedHashMap<String, Double> groupCoeffVar_;
    private Hashtable<String, Hashtable<String, Double>> rtsOfMods_;
    private Hashtable<String, Hashtable<String, Short>> evidenceReliabilityOfMods_;
    private Hashtable<String, Hashtable<String, Double>> groupRts_;
    private Hashtable<String, Hashtable<String, Double>> groupRtStdevs_;
    public static final short EVIDENCE_MS1_ONLY = 0;
    public static final short EVIDENCE_MS2_UNAMBIGUOUS = 1;
    public static final short EVIDENCE_MS2_SPLIT = 2;
    public static final short EVIDENCE_MS2_NO_SPLIT_POSSIBLE = 3;

    public SummaryVO(Integer id, String speciesId, String molecularId, Vector<Integer> featureRefs, String chemFormula, Double neutralMass, Float rt, Vector<String> mods, int mzTabReliability, Hashtable<String, Double> areas, Hashtable<String, Hashtable<String, Double>> rtsOfMods, Hashtable<String, Hashtable<String, Short>> evidenceReliabilityOfMods, LinkedHashMap<String, Vector<String>> expsOfGroup) {
        this.id_ = id;
        this.speciesId_ = speciesId;
        this.featureRefs_ = featureRefs;
        this.molecularId_ = molecularId;
        this.chemFormula_ = chemFormula;
        this.neutralMass_ = neutralMass;
        this.mods_ = mods;
        this.mzTabReliability_ = mzTabReliability;
        this.areas_ = areas;
        this.evidenceReliabilityOfMods_ = evidenceReliabilityOfMods;
        this.rtsOfMods_ = rtsOfMods;
        if (expsOfGroup.size() > 0) {
            this.groupMeans_ = new LinkedHashMap();
            this.groupCoeffVar_ = new LinkedHashMap();
            this.groupRts_ = new Hashtable();
            this.groupRtStdevs_ = new Hashtable();
            for (String groupName : expsOfGroup.keySet()) {
                Vector<Double> areasOfGroup = new Vector<Double>();
                for (String exp : expsOfGroup.get(groupName)) {
                    if (!areas.containsKey(exp) || !(areas.get(exp) > 0.0)) continue;
                    areasOfGroup.add(areas.get(exp));
                }
                if (areasOfGroup.size() == 0) {
                    this.groupMeans_.put(groupName, 0.0);
                    this.groupCoeffVar_.put(groupName, Double.NaN);
                    continue;
                }
                double[] doubleArray = new double[areasOfGroup.size()];
                for (int i = 0; i != areasOfGroup.size(); ++i) {
                    doubleArray[i] = (Double)areasOfGroup.get(i);
                }
                double mean = Calculator.mean(doubleArray);
                this.groupMeans_.put(groupName, mean);
                this.groupCoeffVar_.put(groupName, Calculator.stddeviation(areasOfGroup) / mean);
                for (String mod : rtsOfMods.keySet()) {
                    Hashtable<String, Double> rts = rtsOfMods.get(mod);
                    Vector<Double> rtsOfGroup = new Vector<Double>();
                    for (String exp : expsOfGroup.get(groupName)) {
                        if (!rts.containsKey(exp)) continue;
                        rtsOfGroup.add(rts.get(exp));
                    }
                    if (!this.groupRts_.containsKey(mod)) {
                        this.groupRts_.put(mod, new Hashtable());
                        this.groupRtStdevs_.put(mod, new Hashtable());
                    }
                    doubleArray = new double[rtsOfGroup.size()];
                    for (int i = 0; i != rtsOfGroup.size(); ++i) {
                        doubleArray[i] = (Double)rtsOfGroup.get(i);
                    }
                    this.groupRts_.get(mod).put(groupName, Calculator.mean(doubleArray));
                    this.groupRtStdevs_.get(mod).put(groupName, Calculator.stddeviation(rtsOfGroup));
                }
            }
        }
    }

    public SummaryVO(String speciesId, String molecularId, Vector<Integer> featureRefs, String chemFormula, Double neutralMass, Float rt, Vector<String> mods, int mzTabReliability, Hashtable<String, Double> areas, Hashtable<String, Hashtable<String, Double>> rtsOfMods, Hashtable<String, Hashtable<String, Short>> evidenceReliabilityOfMods, LinkedHashMap<String, Vector<String>> expsOfGroup) {
        this(null, speciesId, molecularId, featureRefs, chemFormula, neutralMass, rt, mods, mzTabReliability, areas, rtsOfMods, evidenceReliabilityOfMods, expsOfGroup);
    }

    public Integer getId() {
        return this.id_;
    }

    public void setId(Integer id) {
        this.id_ = id;
    }

    public String getSpeciesId() {
        return this.speciesId_;
    }

    public Vector<Integer> getFeatureRefs() {
        return this.featureRefs_;
    }

    public String getMolecularId() {
        return this.molecularId_;
    }

    public String getChemFormula() {
        return this.chemFormula_;
    }

    public Double getNeutralMass() {
        return this.neutralMass_;
    }

    public Vector<String> getModifications() {
        return this.mods_;
    }

    public int getMzTabReliability() {
        return this.mzTabReliability_;
    }

    public Double getArea(String exp) {
        if (this.areas_.containsKey(exp)) {
            return this.areas_.get(exp);
        }
        return 0.0;
    }

    public short getEvidenceReliabilty(String exp) {
        short reliability = 0;
        for (Hashtable<String, Short> relies : this.evidenceReliabilityOfMods_.values()) {
            if (!relies.containsKey(exp) || relies.get(exp) <= reliability) continue;
            reliability = relies.get(exp);
        }
        return reliability;
    }

    public Double getMeanArea(String groupName) {
        Double area = 0.0;
        if (this.groupMeans_ != null && this.groupMeans_.containsKey(groupName)) {
            area = this.groupMeans_.get(groupName);
        }
        return area;
    }

    public Double getCoeffVar(String groupName) {
        Double stdev = Double.NaN;
        if (this.groupCoeffVar_.containsKey(groupName)) {
            stdev = this.groupCoeffVar_.get(groupName);
        }
        return stdev;
    }

    public double calculateDeviationValue(ExportOptionsVO expOptions, Vector<String> expsOfGroup) {
        double sdValue = Double.NaN;
        if (expOptions != null && expOptions.getExportType() != 0) {
            Vector<Double> areasOfGroup = new Vector<Double>();
            for (String exp : expsOfGroup) {
                double area = this.getArea(exp);
                if (!(area > 0.0)) continue;
                areasOfGroup.add(area);
            }
            sdValue = Calculator.stddeviation(areasOfGroup);
            if (expOptions.getExportType() == 1 || expOptions.getExportType() == 3) {
                sdValue *= Double.parseDouble(expOptions.getSdValue());
            }
            if (expOptions.getExportType() == 2 || expOptions.getExportType() == 3) {
                sdValue /= Math.sqrt(areasOfGroup.size());
            }
        }
        return sdValue;
    }

    public Double getRetentionTime(String mod, String exp) {
        if (this.rtsOfMods_.containsKey(mod) && this.rtsOfMods_.get(mod).containsKey(exp)) {
            return this.rtsOfMods_.get(mod).get(exp);
        }
        return null;
    }

    public Double getMeanRetentionTime(String mod, String group) {
        if (this.groupRts_.containsKey(mod) && this.groupRts_.get(mod).containsKey(group)) {
            return this.groupRts_.get(mod).get(group);
        }
        return null;
    }

    public Double getStdevRetentionTime(String mod, String group) {
        if (this.groupRtStdevs_.containsKey(mod) && this.groupRtStdevs_.get(mod).containsKey(group)) {
            return this.groupRtStdevs_.get(mod).get(group);
        }
        return null;
    }
}

