/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.exception.NoRuleException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.exception.SheetNotPresentException;
import at.tugraz.genome.lda.msn.parser.FALibParser;
import at.tugraz.genome.lda.msn.parser.LCBLibParser;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Set;

public class FattyAcidsContainer {
    private static final String DEFAULT_ACIDS_DIR = "fattyAcids";
    public static final String FA_FILE_SUFFIX_NEW = ".xlsx";
    public static final String FA_FILE_SUFFIX_OLD = ".xls";
    private static FattyAcidsContainer instance_;
    private static String faDir_;
    private Hashtable<String, Hashtable<String, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>>> fattyAcids_;
    private Hashtable<String, Set<String>> availableLabels_;
    private Hashtable<String, Hashtable<String, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>>> lcbs_;

    private FattyAcidsContainer(String faDir) throws RulesException, IOException {
        faDir_ = faDir;
        this.fattyAcids_ = new Hashtable();
        this.lcbs_ = new Hashtable();
        this.availableLabels_ = new Hashtable();
        this.extractChains();
    }

    private static FattyAcidsContainer getInstance(String faDir) throws RulesException, IOException {
        if (instance_ == null || !faDir_.equalsIgnoreCase(faDir)) {
            instance_ = new FattyAcidsContainer(faDir);
        }
        return instance_;
    }

    private boolean hasFALib(String faLibName) {
        return this.fattyAcids_.containsKey(faLibName) || this.lcbs_.containsKey(faLibName);
    }

    private static void checkIfFALibExists(String faLib, String faLibDir) throws RulesException, IOException, NoRuleException {
        String faDir = faLibDir;
        if (faDir == null || faDir.length() == 0) {
            faDir = DEFAULT_ACIDS_DIR;
        }
        FattyAcidsContainer.getInstance(faLibDir);
        if (instance_.hasFALib(faLib)) {
            return;
        }
        instance_ = new FattyAcidsContainer(faLibDir);
        if (!instance_.hasFALib(faLib)) {
            throw new NoRuleException("There is no fatty acid lib called \"" + faLib + "\"!");
        }
    }

    public static Hashtable<String, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> getAllFattyAcidChains(String faLibName) throws RulesException, NoRuleException, IOException {
        return FattyAcidsContainer.getAllFattyAcidChains(faLibName, faDir_);
    }

    public static Hashtable<String, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> getAllFattyAcidChains(String faLibName, String faLibDir) throws RulesException, NoRuleException, IOException {
        FattyAcidsContainer.checkIfFALibExists(faLibName, faLibDir);
        return FattyAcidsContainer.instance_.fattyAcids_.get(faLibName);
    }

    private void extractChains() throws RulesException, IOException {
        File[] files;
        File faLibDir = new File(faDir_);
        if (!faLibDir.exists()) {
            throw new RulesException("The provided fatty acid lib directory does not exist!");
        }
        if (!faLibDir.isDirectory()) {
            throw new RulesException("The fatty acid lib directory is a file - not a directory!");
        }
        for (File file : files = faLibDir.listFiles()) {
            if (!file.getAbsolutePath().endsWith(FA_FILE_SUFFIX_NEW) && !file.getAbsolutePath().endsWith(FA_FILE_SUFFIX_OLD)) continue;
            try {
                try {
                    FALibParser parser = new FALibParser(file);
                    parser.parseFile();
                    this.fattyAcids_.put(file.getName().substring(0, file.getName().length()), parser.getFattyAcids());
                    this.availableLabels_.put(file.getName().substring(0, file.getName().length()), parser.getAvailableLabels());
                }
                catch (SheetNotPresentException ex) {
                    LCBLibParser parser = new LCBLibParser(file);
                    parser.parseFile();
                    this.lcbs_.put(file.getName().substring(0, file.getName().length()), parser.getResult());
                    this.availableLabels_.put(file.getName().substring(0, file.getName().length()), parser.getAvailableLabels());
                }
            }
            catch (RulesException ex) {
                throw new RulesException(file.getName() + ": " + ex.getMessage());
            }
        }
    }

    public static Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>> getFattyAcidChains(String faLibName, String encoded) throws HydroxylationEncodingException, RulesException, NoRuleException, IOException {
        return FattyAcidsContainer.getFattyAcidChains(faLibName, faDir_, encoded);
    }

    public static Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>> getFattyAcidChains(String faLibName, String faLibDir, String encoded) throws HydroxylationEncodingException, RulesException, NoRuleException, IOException {
        FattyAcidsContainer.checkIfFALibExists(faLibName, faLibDir);
        if (!FattyAcidsContainer.instance_.fattyAcids_.get(faLibName).containsKey(encoded)) {
            throw new HydroxylationEncodingException("The demanded hydroxylation encoding \"" + encoded + "\" is not available in your FA-library: " + faLibName + "!");
        }
        return FattyAcidsContainer.instance_.fattyAcids_.get(faLibName).get(encoded);
    }

    public static Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>> getFattyAcidChains(String faLibName, short hydroxyNr) throws HydroxylationEncodingException, RulesException, NoRuleException, IOException {
        return FattyAcidsContainer.getFattyAcidChains(faLibName, faDir_, hydroxyNr);
    }

    public static Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>> getFattyAcidChains(String faLibName, String faLibDir, short hydroxyNr) throws HydroxylationEncodingException, RulesException, NoRuleException, IOException {
        String encoding = Settings.getFaHydroxyEncoding().getEncodedPrefix(hydroxyNr);
        try {
            return FattyAcidsContainer.getFattyAcidChains(faLibName, faLibDir, encoding);
        }
        catch (HydroxylationEncodingException hdx) {
            throw new HydroxylationEncodingException("The demanded hydroxylation number \"" + hydroxyNr + "\" is not available in your FA-library!");
        }
    }

    public static Hashtable<String, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> getAllLCBs(String lcbLibName) throws RulesException, NoRuleException, IOException {
        return FattyAcidsContainer.getAllLCBs(lcbLibName, faDir_);
    }

    public static Hashtable<String, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> getAllLCBs(String lcbLibName, String lcbLibDir) throws RulesException, NoRuleException, IOException {
        FattyAcidsContainer.checkIfFALibExists(lcbLibName, lcbLibDir);
        return FattyAcidsContainer.instance_.lcbs_.get(lcbLibName);
    }

    public static Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>> getLCBs(String lcbLibName, String encoded) throws HydroxylationEncodingException, RulesException, NoRuleException, IOException {
        return FattyAcidsContainer.getLCBs(lcbLibName, faDir_, encoded);
    }

    public static Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>> getLCBs(String lcbLibName, String lcbLibDir, String encoded) throws HydroxylationEncodingException, RulesException, NoRuleException, IOException {
        FattyAcidsContainer.checkIfFALibExists(lcbLibName, lcbLibDir);
        if (!FattyAcidsContainer.instance_.lcbs_.get(lcbLibName).containsKey(encoded)) {
            throw new HydroxylationEncodingException("The demanded hydroxylation encoding \"" + encoded + "\" is not available in your LCB-library: " + lcbLibName + "!");
        }
        return FattyAcidsContainer.instance_.lcbs_.get(lcbLibName).get(encoded);
    }

    public static Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>> getLCBs(String lcbLibName, short hydroxyNr) throws HydroxylationEncodingException, RulesException, NoRuleException, IOException {
        return FattyAcidsContainer.getLCBs(lcbLibName, faDir_, hydroxyNr);
    }

    public static Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>> getLCBs(String lcbLibName, String lcbLibDir, short hydroxyNr) throws HydroxylationEncodingException, RulesException, NoRuleException, IOException {
        String encoding = Settings.getLcbHydroxyEncoding().getEncodedPrefix(hydroxyNr);
        try {
            return FattyAcidsContainer.getLCBs(lcbLibName, lcbLibDir, encoding);
        }
        catch (HydroxylationEncodingException hdx) {
            throw new HydroxylationEncodingException("The demanded hydroxylation number \"" + hydroxyNr + "\" is not available in your LCB-library!");
        }
    }

    public static Set<String> getAvailableLabels(String libName) throws RulesException, NoRuleException, IOException {
        return FattyAcidsContainer.getAvailableLabels(libName, faDir_);
    }

    public static Set<String> getAvailableLabels(String libName, String libDir) throws RulesException, NoRuleException, IOException {
        FattyAcidsContainer.checkIfFALibExists(libName, libDir);
        return FattyAcidsContainer.instance_.availableLabels_.get(libName);
    }

    static {
        faDir_ = DEFAULT_ACIDS_DIR;
    }
}

