/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.msn.hydroxy.parser.HydroxyEncoding;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.msn.vos.IntensityChainVO;
import at.tugraz.genome.lda.msn.vos.IntensityPositionVO;
import at.tugraz.genome.lda.msn.vos.IntensityRuleVO;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.DoubleBondPositionVO;
import at.tugraz.genome.lda.vos.DoubleStringVO;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.voutils.GeneralComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import javafx.util.Pair;

public class LipidomicsMSnSet
extends LipidParameterSet {
    public static final int NO_MSN_PRESENT = 0;
    public static final int DISCARD_HIT = 1;
    public static final int HEAD_GROUP_DETECTED = 2;
    public static final int FRAGMENTS_DETECTED = 3;
    public static final int POSITION_DETECTED = 4;
    private int status_;
    private Hashtable<String, CgProbe> headGroupFragments_;
    private Hashtable<String, IntensityRuleVO> headIntensityRules_;
    private Hashtable<String, Hashtable<String, CgProbe>> chainFragments_;
    private Hashtable<String, Hashtable<String, IntensityChainVO>> chainIntensityRules_;
    private Vector<String> validChainCombinations_;
    private int numberOfPositions_;
    private Hashtable<Integer, Float> basePeakValues_;
    private Hashtable<Integer, LinkedHashMap<Integer, Float>> msnRetentionTimes_;
    private Hashtable<String, Set<Integer>> msLevels_;
    public static final String MSLEVEL_HEAD_IDENTIFIER = "head";
    public static final String MSLEVEL_ALL_IDENTIFIER = "all";
    private Hashtable<String, Hashtable<Integer, Integer>> positionDefinition_;
    private Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>> positionEvidence_;
    private LinkedHashMap<String, String> nameLookupHumReadableToPositionInsensitve_;
    private LinkedHashMap<String, String> nameLookupPositionSnNomenclature_;
    private LinkedHashMap<String, String> nameLookupPositionInsensitve_;
    private Hashtable<String, Vector<String>> ambiguousPositionIdentifications_;
    private Hashtable<String, Double> relativeIntensityOfCombination_;
    private Hashtable<String, String> chainNameLookupHumanReadable_;
    private Hashtable<String, FattyAcidVO> involvedFAs_;
    private HydroxyEncoding faEncoding_;
    private HydroxyEncoding lcbEncoding_;

    private LipidomicsMSnSet(LipidParameterSet set, int status, Hashtable<String, CgProbe> headGroupFragments, Hashtable<String, IntensityRuleVO> headIntensityRules, Hashtable<String, Hashtable<String, CgProbe>> chainFragments, Hashtable<String, Hashtable<String, IntensityChainVO>> chainIntensityRules, Vector<String> validChainCombinations, Hashtable<String, Double> relativeIntensityOfCombination, Hashtable<String, Hashtable<Integer, Integer>> positionDefinition, Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>> positionEvidence, int numberOfPositions, Hashtable<Integer, Float> basePeakValues, Hashtable<Integer, LinkedHashMap<Integer, Float>> msnRetentionTimes) throws LipidCombinameEncodingException {
        super(set);
        this.status_ = status;
        this.msLevels_ = new Hashtable();
        this.involvedFAs_ = new Hashtable();
        HashSet<Integer> headLevel = new HashSet<Integer>();
        this.headGroupFragments_ = new Hashtable<String, CgProbe>(headGroupFragments);
        for (CgProbe probe : this.headGroupFragments_.values()) {
            headLevel.add(probe.getMsLevel());
        }
        this.msLevels_.put(MSLEVEL_HEAD_IDENTIFIER, headLevel);
        HashSet allLevel = new HashSet(headLevel);
        Hashtable faLevels = new Hashtable();
        this.headIntensityRules_ = new Hashtable<String, IntensityRuleVO>(headIntensityRules);
        this.chainFragments_ = new Hashtable();
        for (String fa : chainFragments.keySet()) {
            this.chainFragments_.put(fa, new Hashtable(chainFragments.get(fa)));
            HashSet<Integer> faSpecificLevel = new HashSet<Integer>();
            for (CgProbe probe : chainFragments.get(fa).values()) {
                faSpecificLevel.add(probe.getMsLevel());
            }
            allLevel.addAll(faSpecificLevel);
            faLevels.put(fa, faSpecificLevel);
        }
        this.chainIntensityRules_ = new Hashtable();
        for (String key : chainIntensityRules.keySet()) {
            this.chainIntensityRules_.put(key, new Hashtable(chainIntensityRules.get(key)));
        }
        this.validChainCombinations_ = new Vector<String>(validChainCombinations);
        for (String combi : this.validChainCombinations_) {
            HashSet combiLevel = new HashSet();
            for (FattyAcidVO fa : StaticUtils.decodeLipidNamesFromChainCombi(combi)) {
                this.involvedFAs_.put(fa.getChainId(), fa);
                if (!faLevels.containsKey(fa.getChainId())) continue;
                combiLevel.addAll((Collection)faLevels.get(fa.getChainId()));
            }
            this.msLevels_.put(combi, combiLevel);
        }
        this.msLevels_.put(MSLEVEL_ALL_IDENTIFIER, allLevel);
        this.relativeIntensityOfCombination_ = relativeIntensityOfCombination;
        this.positionDefinition_ = new Hashtable();
        for (String key : positionDefinition.keySet()) {
            this.positionDefinition_.put(key, new Hashtable(positionDefinition.get(key)));
        }
        this.positionEvidence_ = new Hashtable();
        for (String key1 : positionEvidence.keySet()) {
            Hashtable subTable = new Hashtable();
            for (Integer key2 : positionEvidence.get(key1).keySet()) {
                subTable.put(key2, new Vector(positionEvidence.get(key1).get(key2)));
            }
            this.positionEvidence_.put(key1, subTable);
        }
        this.numberOfPositions_ = numberOfPositions;
        this.basePeakValues_ = new Hashtable<Integer, Float>(basePeakValues);
        this.setMsnRetentionTimes(msnRetentionTimes);
    }

    /*
     * WARNING - void declaration
     */
    public LipidomicsMSnSet(LipidParameterSet set, int status, Hashtable<String, CgProbe> headGroupFragments, Hashtable<String, IntensityRuleVO> headIntensityRules, Hashtable<String, Hashtable<String, CgProbe>> chainFragments, Hashtable<String, Hashtable<String, IntensityChainVO>> chainIntensityRules, Vector<String> validChainCombinations, Hashtable<String, Double> relativeIntensityOfCombination, Hashtable<String, Hashtable<Integer, Integer>> positionDefinition, Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>> positionEvidence, int numberOfPositions, Hashtable<Integer, Float> basePeakValues, Hashtable<Integer, LinkedHashMap<Integer, Float>> msnRetentionTimes, HydroxyEncoding faEncoding, HydroxyEncoding lcbEncoding) throws LipidCombinameEncodingException {
        this(set, status, headGroupFragments, headIntensityRules, chainFragments, chainIntensityRules, validChainCombinations, relativeIntensityOfCombination, positionDefinition, positionEvidence, numberOfPositions, basePeakValues, msnRetentionTimes);
        int count;
        boolean ohPresent;
        Vector<FattyAcidVO> chains;
        this.nameLookupHumReadableToPositionInsensitve_ = new LinkedHashMap();
        this.nameLookupPositionSnNomenclature_ = new LinkedHashMap();
        this.nameLookupPositionInsensitve_ = new LinkedHashMap();
        this.ambiguousPositionIdentifications_ = new Hashtable();
        this.chainNameLookupHumanReadable_ = new Hashtable();
        this.faEncoding_ = faEncoding;
        this.lcbEncoding_ = lcbEncoding;
        Hashtable<String, Integer> faChainOccurrences = new Hashtable<String, Integer>();
        if (this.status_ == 0 || this.status_ == 2) {
            this.nameLookupHumReadableToPositionInsensitve_.put(this.getNameStringWithoutRt(), this.getNameStringWithoutRt());
            this.nameLookupPositionSnNomenclature_.put(this.getNameStringWithoutRt(), this.getNameStringWithoutRt());
        } else if (this.status_ == 3 || this.status_ == 4) {
            void var18_21;
            for (String string : this.validChainCombinations_) {
                chains = StaticUtils.decodeLipidNamesFromChainCombi(string);
                ohPresent = StaticUtils.areThereOhInCombi(chains);
                for (FattyAcidVO combiChain : chains) {
                    if (!this.chainNameLookupHumanReadable_.containsKey(combiChain.getChainId())) {
                        this.chainNameLookupHumanReadable_.put(combiChain.getChainId(), StaticUtils.getHumanReadableChainName(combiChain, faEncoding, lcbEncoding, ohPresent));
                    }
                    count = 0;
                    if (faChainOccurrences.containsKey(combiChain.getChainId())) {
                        count = (Integer)faChainOccurrences.get(combiChain.getChainId());
                    }
                    faChainOccurrences.put(combiChain.getChainId(), ++count);
                }
            }
            ArrayList<DoubleStringVO> toSort = new ArrayList<DoubleStringVO>();
            for (String combi : this.relativeIntensityOfCombination_.keySet()) {
                toSort.add(new DoubleStringVO(combi, this.relativeIntensityOfCombination_.get(combi)));
            }
            Collections.sort(toSort, new GeneralComparator("at.tugraz.genome.lda.vos.DoubleStringVO", "getValue", "java.lang.Double"));
            this.validChainCombinations_ = new Vector();
            int n = toSort.size() - 1;
            while (var18_21 != -1) {
                this.validChainCombinations_.add(((DoubleStringVO)toSort.get((int)var18_21)).getKey());
                --var18_21;
            }
        }
        if (this.status_ == 3 || this.status_ == 4) {
            for (String string : this.validChainCombinations_) {
                this.nameLookupPositionInsensitve_.put(string, StaticUtils.getHumanReadableCombiName(string, faEncoding, lcbEncoding, false));
                if (this.status_ == 4 && this.positionDefinition_.containsKey(string)) {
                    Vector<String> posNames = this.getPositionSpecificCombiNames(string, this.positionDefinition_.get(string), faEncoding, lcbEncoding);
                    Vector<String> snPosNames = this.getPositionSpecificCombiName(string, this.positionDefinition_.get(string), faEncoding, lcbEncoding);
                    if (posNames.size() == 1) {
                        this.nameLookupHumReadableToPositionInsensitve_.put(posNames.get(0), string);
                        this.nameLookupPositionSnNomenclature_.put(snPosNames.get(0), string);
                    } else {
                        this.ambiguousPositionIdentifications_.put(string, posNames);
                        for (String ambigName : posNames) {
                            this.nameLookupHumReadableToPositionInsensitve_.put(ambigName, string);
                        }
                    }
                    this.nameLookupPositionSnNomenclature_.put(snPosNames.get(0), string);
                } else {
                    this.nameLookupHumReadableToPositionInsensitve_.put(StaticUtils.getHumanReadableCombiName(string, faEncoding, lcbEncoding), string);
                    this.nameLookupPositionSnNomenclature_.put(StaticUtils.getHumanReadableCombiName(string, faEncoding, lcbEncoding), string);
                }
                chains = StaticUtils.decodeLipidNamesFromChainCombi(string);
                ohPresent = StaticUtils.areThereOhInCombi(chains);
                for (FattyAcidVO combiChain : chains) {
                    if (!this.chainNameLookupHumanReadable_.containsKey(combiChain.getChainId())) {
                        this.chainNameLookupHumanReadable_.put(combiChain.getChainId(), StaticUtils.getHumanReadableChainName(combiChain, faEncoding, lcbEncoding, ohPresent));
                    }
                    count = 0;
                    if (faChainOccurrences.containsKey(combiChain.getChainId())) {
                        count = (Integer)faChainOccurrences.get(combiChain.getChainId());
                    }
                    faChainOccurrences.put(combiChain.getChainId(), ++count);
                }
            }
        }
    }

    public LipidomicsMSnSet(LipidomicsMSnSet set) throws LipidCombinameEncodingException {
        this(set, set.status_, set.headGroupFragments_, set.headIntensityRules_, set.chainFragments_, set.chainIntensityRules_, set.validChainCombinations_, set.relativeIntensityOfCombination_, set.positionDefinition_, set.positionEvidence_, set.numberOfPositions_, set.basePeakValues_, set.getMsnRetentionTimes());
        this.nameLookupHumReadableToPositionInsensitve_ = set.nameLookupHumReadableToPositionInsensitve_;
        this.nameLookupPositionSnNomenclature_ = set.nameLookupPositionSnNomenclature_;
        this.ambiguousPositionIdentifications_ = set.ambiguousPositionIdentifications_;
        this.nameLookupPositionInsensitve_ = set.nameLookupPositionInsensitve_;
        this.chainNameLookupHumanReadable_ = set.chainNameLookupHumanReadable_;
        this.involvedFAs_ = set.involvedFAs_;
        this.msLevels_ = set.msLevels_;
    }

    public void removeMolecularSpecies(String humanReadable) {
        String humanReadableWithoutDB = StaticUtils.getHumanReadableWODoubleBondPositions(humanReadable);
        String positionInsensitive = this.nameLookupHumReadableToPositionInsensitve_.get(humanReadableWithoutDB);
        this.nameLookupHumReadableToPositionInsensitve_.remove(humanReadableWithoutDB);
        this.nameLookupPositionSnNomenclature_.remove(humanReadableWithoutDB);
        this.nameLookupPositionInsensitve_.remove(positionInsensitive);
        this.positionDefinition_.remove(positionInsensitive);
        this.positionEvidence_.remove(positionInsensitive);
        this.ambiguousPositionIdentifications_.remove(positionInsensitive);
        this.chainIntensityRules_.remove(positionInsensitive);
        this.validChainCombinations_.remove(positionInsensitive);
        Double multiplier = 1.0 / (1.0 - this.relativeIntensityOfCombination_.get(positionInsensitive));
        System.out.println(multiplier);
        this.relativeIntensityOfCombination_.remove(positionInsensitive);
        for (String key : this.relativeIntensityOfCombination_.keySet()) {
            Double rel = this.relativeIntensityOfCombination_.get(key);
            Double newRel = rel * multiplier;
            System.out.println(newRel);
            this.relativeIntensityOfCombination_.put(key, newRel);
        }
        Vector<DoubleBondPositionVO> omegaVOs = this.getOmegaInformation();
        Vector<DoubleBondPositionVO> newOmegaVOs = new Vector<DoubleBondPositionVO>();
        for (DoubleBondPositionVO omegaVO : omegaVOs) {
            String noOmegaPos = omegaVO.getEncodedDetailed(true, false);
            if (noOmegaPos.equals(positionInsensitive)) continue;
            newOmegaVOs.add(omegaVO);
        }
        this.setOmegaInformation(newOmegaVOs);
        HashSet<String> potentiallyRemovedFA = new HashSet<String>(Arrays.asList(positionInsensitive.split("<->")));
        HashSet<String> remainingFA = new HashSet<String>();
        for (String validChainCombi : this.validChainCombinations_) {
            remainingFA.addAll(Arrays.asList(validChainCombi.split("<->")));
        }
        for (String valid : remainingFA) {
            potentiallyRemovedFA.remove(valid);
        }
        for (String removed : potentiallyRemovedFA) {
            this.chainFragments_.remove(removed);
            this.involvedFAs_.remove(removed);
            this.chainNameLookupHumanReadable_.remove(removed);
            this.chainIntensityRules_.remove(removed);
        }
        if (this.chainFragments_.isEmpty()) {
            this.status_ = this.headGroupFragments_.isEmpty() ? 0 : 2;
        }
    }

    public Hashtable<String, CgProbe> getHeadGroupFragments() {
        return this.headGroupFragments_;
    }

    public Hashtable<String, IntensityRuleVO> getHeadIntensityRules() {
        return this.headIntensityRules_;
    }

    public Hashtable<String, Hashtable<String, CgProbe>> getChainFragments() {
        return this.chainFragments_;
    }

    public Hashtable<String, Hashtable<String, IntensityChainVO>> getChainIntensityRules() {
        return this.chainIntensityRules_;
    }

    public Hashtable<String, Hashtable<Integer, Integer>> getPositionDefinition() {
        return this.positionDefinition_;
    }

    public Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>> getPositionEvidence() {
        return this.positionEvidence_;
    }

    public Vector<Object> getMSnIdentificationNames() {
        Vector<Object> names = new Vector<Object>();
        HashSet<String> usedCombis = new HashSet<String>();
        for (String humanReadable : this.nameLookupHumReadableToPositionInsensitve_.keySet()) {
            String uniqueCombiId = this.nameLookupHumReadableToPositionInsensitve_.get(humanReadable);
            if (usedCombis.contains(uniqueCombiId)) continue;
            usedCombis.add(uniqueCombiId);
            if (this.ambiguousPositionIdentifications_.containsKey(uniqueCombiId)) {
                names.add(this.ambiguousPositionIdentifications_.get(uniqueCombiId));
                continue;
            }
            names.add(humanReadable);
        }
        return names;
    }

    public Vector<String> getMSnIdentificationNamesWithSNPositions() {
        Vector<String> names = new Vector<String>();
        for (String humanReadable : this.nameLookupPositionSnNomenclature_.keySet()) {
            names.add(humanReadable);
        }
        return names;
    }

    public String getPositionInsensitiveHumanReadableCombiName(String encoded) {
        return this.nameLookupPositionInsensitve_.get(encoded);
    }

    private Vector<String> getPositionSpecificCombiNames(String combiName, Hashtable<Integer, Integer> positions, HydroxyEncoding faEncoding, HydroxyEncoding lcbEncoding) throws LipidCombinameEncodingException {
        Vector<String> unassignedFAs = new Vector<String>();
        Vector<FattyAcidVO> chains = StaticUtils.decodeLipidNamesFromChainCombi(combiName);
        boolean hydroxylationSites = StaticUtils.areThereOhInCombi(chains);
        Hashtable<Integer, String> definedPositions = new Hashtable<Integer, String>();
        for (int i = 0; i != chains.size(); ++i) {
            if (!positions.containsKey(i) || positions.get(i) == -1) {
                unassignedFAs.add(StaticUtils.getHumanReadableChainName(chains.get(i), faEncoding, lcbEncoding, hydroxylationSites));
                continue;
            }
            definedPositions.put(positions.get(i), StaticUtils.getHumanReadableChainName(chains.get(i), faEncoding, lcbEncoding, hydroxylationSites));
        }
        return this.getPermutedChainPositionNames(definedPositions, unassignedFAs);
    }

    private Vector<String> getPositionSpecificCombiName(String combiName, Hashtable<Integer, Integer> positions, HydroxyEncoding faEncoding, HydroxyEncoding lcbEncoding) throws LipidCombinameEncodingException {
        Vector<String> unassignedFAs = new Vector<String>();
        Vector<FattyAcidVO> chains = StaticUtils.decodeLipidNamesFromChainCombi(combiName);
        boolean hydroxylationSites = StaticUtils.areThereOhInCombi(chains);
        Hashtable<Integer, String> definedPositions = new Hashtable<Integer, String>();
        for (int i = 0; i != chains.size(); ++i) {
            if (!positions.containsKey(i) || positions.get(i) == -1) {
                unassignedFAs.add(StaticUtils.getHumanReadableChainName(chains.get(i), faEncoding, lcbEncoding, hydroxylationSites));
                continue;
            }
            definedPositions.put(positions.get(i), StaticUtils.getHumanReadableChainName(chains.get(i), faEncoding, lcbEncoding, hydroxylationSites));
        }
        return this.getChainPositionNames(definedPositions, unassignedFAs);
    }

    private Vector<String> getPermutedChainPositionNames(Hashtable<Integer, String> definedPositions, Vector<String> unassignedFAs) throws LipidCombinameEncodingException {
        Vector possibleCombis = new Vector();
        Vector<String> names = new Vector<String>();
        if (unassignedFAs.size() == 0) {
            possibleCombis.add(definedPositions);
        } else {
            Hashtable<String, String> combis = new Hashtable<String, String>();
            Vector<String> vector = new Vector<String>(unassignedFAs);
            for (int i = definedPositions.size() + unassignedFAs.size(); i < this.numberOfPositions_; ++i) {
                vector.add("-");
            }
            Vector<String> permutedNames = StaticUtils.getPermutedChainNames(vector, "_");
            for (String permutedName : permutedNames) {
                if (combis.containsKey(permutedName)) continue;
                combis.put(permutedName, permutedName);
            }
            for (String permutedName : combis.keySet()) {
                Vector<String> parts = StaticUtils.splitChainCombiToEncodedStrings(permutedName, "_");
                int permutedPos = 0;
                Hashtable<Integer, String> combiHash = new Hashtable<Integer, String>();
                for (int i = 0; i != definedPositions.size() + vector.size(); ++i) {
                    String fa = null;
                    if (definedPositions.containsKey(i)) {
                        fa = definedPositions.get(i);
                    } else {
                        fa = parts.get(permutedPos);
                        ++permutedPos;
                    }
                    combiHash.put(i, fa);
                }
                possibleCombis.add(combiHash);
            }
        }
        for (Hashtable hashtable : possibleCombis) {
            String name = "";
            for (int i = 0; i != this.numberOfPositions_; ++i) {
                if (i != 0) {
                    name = name + "/";
                }
                name = hashtable.containsKey(i) ? name + (String)hashtable.get(i) : name + "-";
            }
            names.add(name);
        }
        return names;
    }

    /*
     * WARNING - void declaration
     */
    private Vector<String> getChainPositionNames(Hashtable<Integer, String> definedPositions, Vector<String> unassignedFAs) throws LipidCombinameEncodingException {
        Vector possibleCombis = new Vector();
        Hashtable<Integer, String> combiHash = new Hashtable<Integer, String>();
        Vector<String> names = new Vector<String>();
        if (unassignedFAs.size() == 0) {
            possibleCombis.add(definedPositions);
            String name = "";
            for (Hashtable hashtable : possibleCombis) {
                for (int i = 0; i != this.numberOfPositions_; ++i) {
                    if (i != 0) {
                        name = name + "/";
                    }
                    name = hashtable.containsKey(i) ? name + (String)hashtable.get(i) : name + "-";
                }
                names.add(name);
            }
        } else {
            Vector<String> unassigned = new Vector<String>(unassignedFAs);
            for (int i = definedPositions.size() + unassignedFAs.size(); i < this.numberOfPositions_; ++i) {
                unassigned.add("-");
            }
            int noPositionCount = 0;
            String string = "_";
            for (int i = 0; i != definedPositions.size() + unassigned.size(); ++i) {
                String fa = null;
                if (definedPositions.containsKey(i)) {
                    if (this.numberOfPositions_ - definedPositions.size() > 1) {
                        fa = definedPositions.get(i) + " " + "(sn-" + (i + 1) + ")";
                    } else {
                        fa = definedPositions.get(i);
                        String string2 = "/";
                    }
                } else {
                    fa = unassigned.get(noPositionCount);
                    ++noPositionCount;
                }
                combiHash.put(i, fa);
            }
            possibleCombis.add(combiHash);
            String name = "";
            for (Hashtable hashtable : possibleCombis) {
                for (int i = 0; i != this.numberOfPositions_; ++i) {
                    if (i != 0) {
                        void var8_12;
                        name = name + (String)var8_12;
                    }
                    name = hashtable.containsKey(i) ? name + (String)hashtable.get(i) : name + "-";
                }
                names.add(name);
            }
        }
        return names;
    }

    public Hashtable<String, Double> getChainCombinationRelativeAreas() {
        return this.relativeIntensityOfCombination_;
    }

    public double getRelativeIntensity(String fullName) {
        double relativeIntensity = 0.0;
        if (this.nameLookupPositionSnNomenclature_.get(fullName) != null) {
            if (this.status_ < 3) {
                return 1.0;
            }
            relativeIntensity = this.relativeIntensityOfCombination_.get(this.nameLookupPositionSnNomenclature_.get(fullName));
        }
        return relativeIntensity;
    }

    public Hashtable<Integer, Vector<IntensityPositionVO>> getPositionEvidence(String fullName, HydroxyEncoding faEncoding, HydroxyEncoding lcbEncoding) throws LipidCombinameEncodingException {
        Hashtable<Integer, Vector<IntensityPositionVO>> posEvidence = null;
        if (!this.positionEvidence_.containsKey(fullName)) {
            for (String combiName : this.validChainCombinations_) {
                if (!this.positionDefinition_.containsKey(combiName)) continue;
                Vector<String> posCombiNames = this.getPositionSpecificCombiNames(combiName, this.positionDefinition_.get(combiName), faEncoding, lcbEncoding);
                for (String posCombiName : posCombiNames) {
                    if (!posCombiName.equalsIgnoreCase(fullName)) continue;
                    return this.positionEvidence_.get(combiName);
                }
            }
        } else {
            posEvidence = this.positionEvidence_.get(fullName);
        }
        return posEvidence;
    }

    public Set<Integer> getMSLevels(String fullName, HydroxyEncoding faEncoding, HydroxyEncoding lcbEncoding) throws LipidCombinameEncodingException {
        Set<Integer> msLevels = null;
        String encodedCombi = fullName;
        if (this.nameLookupHumReadableToPositionInsensitve_.containsKey(fullName)) {
            encodedCombi = this.nameLookupHumReadableToPositionInsensitve_.get(fullName);
        }
        if (fullName.equalsIgnoreCase(MSLEVEL_HEAD_IDENTIFIER) || fullName.equalsIgnoreCase(MSLEVEL_ALL_IDENTIFIER) || this.msLevels_.containsKey(encodedCombi)) {
            msLevels = this.msLevels_.get(encodedCombi);
        } else {
            for (String combiName : this.validChainCombinations_) {
                if (!this.positionDefinition_.containsKey(combiName)) continue;
                Vector<String> posCombiNames = this.getPositionSpecificCombiNames(combiName, this.positionDefinition_.get(combiName), faEncoding, lcbEncoding);
                for (String posCombiName : posCombiNames) {
                    if (!posCombiName.equalsIgnoreCase(fullName)) continue;
                    msLevels = this.msLevels_.get(combiName);
                    break;
                }
                if (msLevels == null) continue;
                break;
            }
        }
        return msLevels;
    }

    public int getStatus() {
        return this.status_;
    }

    public Hashtable<Integer, LinkedHashMap<Integer, Float>> getMsnRetentionTimes() {
        return this.msnRetentionTimes_;
    }

    public float getBasePeak(IntensityRuleVO rule) {
        CgProbe probe = rule.getAnyNonBasepeakFragment(this.headGroupFragments_, this.chainFragments_);
        if (probe == null) {
            System.out.println("hi!");
        }
        return this.getBasePeak(probe.getMsLevel());
    }

    public float getBasePeak(int msLevel) {
        float result = Float.NaN;
        if (this.basePeakValues_.containsKey(msLevel)) {
            result = this.basePeakValues_.get(msLevel).floatValue();
        }
        return result;
    }

    public Hashtable<String, Float> getFragmentAreas(IntensityRuleVO ruleVO) {
        return LipidomicsMSnSet.getFragmentAreas(ruleVO, this.headGroupFragments_, this.chainFragments_);
    }

    public static Hashtable<String, Float> getFragmentAreas(IntensityRuleVO ruleVO, Hashtable<String, CgProbe> headGroupFragments, Hashtable<String, Hashtable<String, CgProbe>> chainFragments) {
        String identifier;
        Hashtable<String, Float> areas = new Hashtable<String, Float>();
        for (String biggerName : ruleVO.getBiggerNonBasePeakNames().keySet()) {
            Float biggerArea = LipidomicsMSnSet.getFragmentArea(ruleVO, biggerName, headGroupFragments, chainFragments);
            if (biggerArea == null) continue;
            identifier = biggerName;
            if (ruleVO.getBiggerPosition() > 0) {
                identifier = identifier + "[" + String.valueOf(ruleVO.getBiggerPosition()) + "]";
            }
            areas.put(identifier, biggerArea);
        }
        for (String smallerName : ruleVO.getSmallerNonBasePeakNames().keySet()) {
            Float smallerArea = LipidomicsMSnSet.getFragmentArea(ruleVO, smallerName, headGroupFragments, chainFragments);
            if (smallerArea == null) continue;
            identifier = smallerName;
            if (ruleVO.getSmallerPosition() > 0) {
                identifier = identifier + "[" + String.valueOf(ruleVO.getSmallerPosition()) + "]";
            }
            areas.put(identifier, smallerArea);
        }
        return areas;
    }

    private static Float getFragmentArea(IntensityRuleVO intRule, String name, Hashtable<String, CgProbe> headGroupFragments, Hashtable<String, Hashtable<String, CgProbe>> chainFragments) {
        Float area = null;
        if (name.equalsIgnoreCase("$BASEPEAK")) {
            return area;
        }
        CgProbe fragment = intRule.checkForFragmentAvailability(name, headGroupFragments, chainFragments);
        area = fragment != null ? Float.valueOf(fragment.Area) : Float.valueOf(-1.0f);
        return area;
    }

    public Vector<IntensityRuleVO> getFAsInSequenceAsInRule(String combiName) throws LipidCombinameEncodingException {
        Vector<IntensityRuleVO> result = new Vector<IntensityRuleVO>();
        Hashtable<Integer, Vector<IntensityPositionVO>> posRules = this.positionEvidence_.get(combiName);
        Hashtable<Integer, Integer> posDef = this.positionDefinition_.get(combiName);
        if (this.status_ < 4 || posDef == null) {
            return result;
        }
        Vector<String> fas = StaticUtils.splitChainCombiToEncodedStrings(combiName, "<->");
        Hashtable<String, IntensityRuleVO> usedRules = new Hashtable<String, IntensityRuleVO>();
        for (int i = 0; i != fas.size(); ++i) {
            if (!posDef.containsKey(i) || posDef.get(i) == -1 || posRules.size() == 0) continue;
            int position = posDef.get(i);
            Vector<IntensityPositionVO> rules = posRules.get(position + 1);
            for (IntensityRuleVO intensityRuleVO : rules) {
                if (usedRules.containsKey(intensityRuleVO.getRuleIdentifier()) && ((IntensityRuleVO)usedRules.get(intensityRuleVO.getRuleIdentifier())).equals(intensityRuleVO)) continue;
                result.add(intensityRuleVO);
                usedRules.put(intensityRuleVO.getRuleIdentifier(), intensityRuleVO);
            }
        }
        return result;
    }

    public Hashtable<String, FattyAcidVO> getInvolvedFAs() {
        return this.involvedFAs_;
    }

    public String getCombiIdFromHumanReadable(String humanReadable) {
        return this.nameLookupHumReadableToPositionInsensitve_.get(humanReadable);
    }

    public void setMsnRetentionTimes(Hashtable<Integer, LinkedHashMap<Integer, Float>> msnRetentionTimes_) {
        this.msnRetentionTimes_ = msnRetentionTimes_;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LipidomicsMSnSet other = (LipidomicsMSnSet)obj;
        return Objects.equals(this.ambiguousPositionIdentifications_, other.ambiguousPositionIdentifications_) && Objects.equals(this.basePeakValues_, other.basePeakValues_) && Objects.equals(this.chainIntensityRules_, other.chainIntensityRules_) && Objects.equals(this.chainNameLookupHumanReadable_, other.chainNameLookupHumanReadable_) && Objects.equals(this.headIntensityRules_, other.headIntensityRules_) && Objects.equals(this.involvedFAs_, other.involvedFAs_) && Objects.equals(this.msLevels_, other.msLevels_) && Objects.equals(this.msnRetentionTimes_, other.msnRetentionTimes_) && this.numberOfPositions_ == other.numberOfPositions_ && Objects.equals(this.positionDefinition_, other.positionDefinition_) && this.status_ == other.status_ && Objects.equals(this.validChainCombinations_, other.validChainCombinations_);
    }

    public LinkedHashMap<String, String> getNameLookupHumReadableToPositionInsensitive() {
        return this.nameLookupHumReadableToPositionInsensitve_;
    }

    public Set<String> getHumanReadableNameSet() {
        return new HashSet<String>(this.getMSnIdentificationNamesWithSNPositions());
    }

    public Vector<Pair<String, String>> getLabeledUnlabeledPairs() {
        Vector<Pair<String, String>> labeledUnlabeledPairs = new Vector<Pair<String, String>>();
        try {
            Set<String> humanReadableNames = this.getHumanReadableNameSet();
            for (String name : humanReadableNames) {
                Vector<FattyAcidVO> chains = new Vector<FattyAcidVO>();
                Vector<String> chainNames = new Vector<String>();
                String[] splitName = StaticUtils.splitChainCombinationsAtChainSeparators(name);
                for (int i = 0; i < splitName.length; ++i) {
                    FattyAcidVO fa = StaticUtils.decodeHumanReadableChain(splitName[i], Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), false, null);
                    chains.add(fa);
                    chainNames.add(splitName[i]);
                }
                boolean ohPresent = StaticUtils.areThereOhInCombi(chains);
                Vector<String> sortedChainNamesWithPrefix = StaticUtils.sortChainNames(chainNames, ohPresent, false);
                Vector<String> sortedChainNamesWithoutPrefix = StaticUtils.sortChainNames(chainNames, ohPresent, true);
                StringBuilder nameStringWithPrefix = new StringBuilder();
                StringBuilder nameStringWithoutPrefix = new StringBuilder();
                for (int i = 0; i < splitName.length; ++i) {
                    if (i > 0) {
                        nameStringWithPrefix.append("_");
                        nameStringWithoutPrefix.append("_");
                    }
                    nameStringWithPrefix.append(sortedChainNamesWithPrefix.get(i));
                    nameStringWithoutPrefix.append(sortedChainNamesWithoutPrefix.get(i));
                }
                labeledUnlabeledPairs.add((Pair<String, String>)new Pair((Object)nameStringWithoutPrefix.toString(), (Object)nameStringWithPrefix.toString()));
            }
        }
        catch (LipidCombinameEncodingException ex) {
            ex.printStackTrace();
        }
        return labeledUnlabeledPairs;
    }

    public Set<String> getPositionInsensitiveHumanReadableNameSet(boolean excludePrefix) {
        HashSet<String> positionInsensitive = new HashSet<String>();
        for (String combiName : this.validChainCombinations_) {
            try {
                Vector<FattyAcidVO> chains = StaticUtils.decodeLipidNamesFromChainCombi(combiName);
                boolean ohPresent = StaticUtils.areThereOhInCombi(chains);
                Vector<String> chainNames = new Vector<String>();
                for (FattyAcidVO chain : chains) {
                    chainNames.add(StaticUtils.getHumanReadableChainName(chain, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), ohPresent));
                }
                Vector<String> sortedChainNames = StaticUtils.sortChainNames(chainNames, ohPresent, excludePrefix);
                String nameString = "";
                for (String name : sortedChainNames) {
                    if (nameString.length() > 0) {
                        nameString = nameString + "_";
                    }
                    nameString = nameString + name;
                }
                positionInsensitive.add(nameString);
            }
            catch (LipidCombinameEncodingException ex) {
                ex.printStackTrace();
            }
        }
        return positionInsensitive;
    }

    public String getHumanReadableChainCombi(String internalRepresentation, boolean isPositionWanted) throws LipidCombinameEncodingException {
        Vector<String> posNames;
        if ((this.status_ == 3 || this.status_ == 4) && isPositionWanted && this.status_ == 4 && this.positionDefinition_.containsKey(internalRepresentation) && (posNames = this.getPositionSpecificCombiNames(internalRepresentation, this.positionDefinition_.get(internalRepresentation), this.faEncoding_, this.lcbEncoding_)).size() == 1) {
            return posNames.get(0);
        }
        return StaticUtils.getHumanReadableCombiName(internalRepresentation, this.faEncoding_, this.lcbEncoding_, false);
    }

    public Vector<String> getValidChainCombinations() {
        return this.validChainCombinations_;
    }
}

