/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn;

import at.tugraz.genome.lda.exception.LMException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.msn.vos.MSnDebugVO;
import at.tugraz.genome.lda.utils.LMLinearFaCombination;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.FloatStringVO;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.util.FloatMatrix;
import at.tugraz.genome.voutils.GeneralComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Vector;

public class MSnRelativeShareCalculator {
    private Hashtable<String, Vector<FattyAcidVO>> combiFAs_;
    private Hashtable<String, String> combiLookup_;
    private LinkedHashMap<FattyAcidVO, Double> sortedFAs_;
    private Vector<String> sortedCombis_;
    private double relativeChainCutoff_;
    private Hashtable<String, Double> relativeIntensities_;
    private boolean debug_;
    private MSnDebugVO debugVO_;

    public MSnRelativeShareCalculator(Hashtable<String, Vector<FattyAcidVO>> combiFAs, Hashtable<String, Hashtable<String, CgProbe>> chainFragments, double relativeChainCutoff, boolean debug, MSnDebugVO debugVO) throws LipidCombinameEncodingException {
        this.combiFAs_ = combiFAs;
        Vector<FattyAcidVO> fas = new Vector<FattyAcidVO>();
        for (String chainId : chainFragments.keySet()) {
            fas.add(StaticUtils.decodeLipidNameForCreatingCombis(chainId));
        }
        this.sortedFAs_ = new LinkedHashMap();
        for (FattyAcidVO fa : StaticUtils.sortChainVOs(fas)) {
            double area = 0.0;
            for (CgProbe probe : chainFragments.get(fa.getChainId()).values()) {
                area += (double)probe.Area;
            }
            this.sortedFAs_.put(fa, area);
        }
        this.combiLookup_ = new Hashtable();
        for (String combi : combiFAs.keySet()) {
            this.combiLookup_.put(StaticUtils.encodeLipidCombi(StaticUtils.sortChainVOs(StaticUtils.decodeLipidNamesFromChainCombi(combi))), combi);
        }
        this.sortedCombis_ = StaticUtils.sortChainCombinations(new HashSet<String>(this.combiLookup_.keySet()));
        this.relativeChainCutoff_ = relativeChainCutoff;
        this.debug_ = debug;
        this.debugVO_ = debugVO;
    }

    public void splitIntensities() {
        int i;
        int negativeParams = 1;
        FloatMatrix params = null;
        LMLinearFaCombination optimizer = null;
        while (negativeParams > 0) {
            int i2;
            negativeParams = 0;
            optimizer = this.parameterPrediction();
            params = optimizer.getResultParams();
            ArrayList<FloatStringVO> negatives = new ArrayList<FloatStringVO>();
            Hashtable<String, Integer> lookup = new Hashtable<String, Integer>();
            float highest = 0.0f;
            for (i = 0; i != params.A.length; ++i) {
                if (!(params.A[i][0] > highest)) continue;
                highest = params.A[i][0];
            }
            for (i = 0; i != params.A.length; ++i) {
                if ((double)params.A[i][0] >= this.relativeChainCutoff_ * (double)highest) continue;
                if (this.debug_) {
                    this.debugVO_.addViolatedCombinations(this.combiLookup_.get(this.sortedCombis_.get(i)), 4);
                }
                ++negativeParams;
                negatives.add(new FloatStringVO(this.sortedCombis_.get(i), Float.valueOf(params.A[i][0])));
                lookup.put(this.sortedCombis_.get(i), i);
            }
            Collections.sort(negatives, new GeneralComparator("at.tugraz.genome.lda.vos.FloatStringVO", "getValue", "java.lang.Float"));
            Vector toRemove = new Vector();
            int maxRemove = negatives.size() / 2 + negatives.size() % 2;
            for (i2 = 0; i2 != maxRemove; ++i2) {
                toRemove.add(lookup.get(((FloatStringVO)negatives.get(i2)).getKey()));
            }
            Collections.sort(toRemove);
            for (i2 = toRemove.size() - 1; i2 != -1; --i2) {
                this.sortedCombis_.remove((Integer)toRemove.get(i2));
            }
            Vector<FattyAcidVO> fasToRemove = new Vector<FattyAcidVO>();
            for (FattyAcidVO fa : this.sortedFAs_.keySet()) {
                boolean faFound = false;
                for (String combi : this.sortedCombis_) {
                    for (FattyAcidVO otherFA : this.combiFAs_.get(this.combiLookup_.get(combi))) {
                        if (!fa.getChainId().equalsIgnoreCase(otherFA.getChainId())) continue;
                        faFound = true;
                        break;
                    }
                    if (!faFound) continue;
                    break;
                }
                if (faFound) continue;
                fasToRemove.add(fa);
            }
            for (FattyAcidVO fa : fasToRemove) {
                this.sortedFAs_.remove(fa);
            }
        }
        float total = 0.0f;
        for (i = 0; i != params.A.length; ++i) {
            total += params.A[i][0];
        }
        this.relativeIntensities_ = new Hashtable();
        for (i = 0; i != params.A.length; ++i) {
            this.relativeIntensities_.put(this.combiLookup_.get(this.sortedCombis_.get(i)), (double)params.A[i][0] / (double)total);
        }
    }

    private LMLinearFaCombination parameterPrediction() {
        float[][] values = new float[this.sortedFAs_.size()][this.sortedCombis_.size()];
        float[] intensities = new float[this.sortedFAs_.size()];
        int rowCount = 0;
        for (FattyAcidVO fa : this.sortedFAs_.keySet()) {
            int columnCount = 0;
            for (String combi : this.sortedCombis_) {
                int faCount = 0;
                for (FattyAcidVO otherFA : this.combiFAs_.get(this.combiLookup_.get(combi))) {
                    if (!fa.getChainId().equalsIgnoreCase(otherFA.getChainId())) continue;
                    ++faCount;
                }
                values[rowCount][columnCount] = faCount;
                ++columnCount;
            }
            intensities[rowCount] = this.sortedFAs_.get(fa).floatValue();
            ++rowCount;
        }
        LMLinearFaCombination optimizer = new LMLinearFaCombination(values, intensities);
        try {
            optimizer.fit();
            return optimizer;
        }
        catch (LMException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Hashtable<String, FattyAcidVO> getAllowedFAs() {
        Hashtable<String, FattyAcidVO> possible = new Hashtable<String, FattyAcidVO>();
        for (FattyAcidVO fa : this.sortedFAs_.keySet()) {
            possible.put(fa.getChainId(), fa);
        }
        return possible;
    }

    public Hashtable<String, Double> getRelativeIntensities() {
        return this.relativeIntensities_;
    }
}

