/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn;

import at.tugraz.genome.lda.exception.LMException;
import at.tugraz.genome.lda.exception.NoRuleException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.MSnPeakSeparator;
import at.tugraz.genome.lda.msn.OtherAdductChecker;
import at.tugraz.genome.lda.msn.RulesContainer;
import at.tugraz.genome.lda.msn.vos.RtPredictVO;
import at.tugraz.genome.lda.msn.vos.SharedMS1PeakVO;
import at.tugraz.genome.lda.msn.vos.SharedPeakContributionVO;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.utils.LMAsymptDecayThreeVariables;
import at.tugraz.genome.lda.utils.LMAsymptDecayTwoVariables;
import at.tugraz.genome.lda.utils.LMAsymptVarDecayThreeVariables;
import at.tugraz.genome.lda.utils.LMAsymptVarDecayTwoVariables;
import at.tugraz.genome.lda.utils.LMLogDecayThreeVariables;
import at.tugraz.genome.lda.utils.LMLogDecayTwoVariables;
import at.tugraz.genome.lda.utils.LevenbergMarquardtOptimizer;
import at.tugraz.genome.lda.utils.RangeInteger;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.QuantVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.maspectras.utils.Calculator;
import at.tugraz.genome.util.FloatMatrix;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostQuantificationProcessor {
    private Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> results_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> ms2Removed_;
    private Hashtable<String, Boolean> adductInsensitiveRtFilter_;
    private static final int MINIMUM_MEASUREMENTS = 7;
    private static final float COUNTER_SERIES_TOLERANCE = 3.0f;
    private Hashtable<String, LevenbergMarquardtOptimizer> predictedModels_;
    private Hashtable<String, Boolean> respectOhs_;

    public PostQuantificationProcessor(Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> results, Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> ms2Removed, Hashtable<String, Boolean> adductInsensitiveRtFilter) {
        this.results_ = results;
        this.ms2Removed_ = ms2Removed;
        this.adductInsensitiveRtFilter_ = adductInsensitiveRtFilter;
        this.predictedModels_ = new Hashtable();
        this.respectOhs_ = new Hashtable();
    }

    public Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> processData() throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        this.results_ = this.correctByRetentionTimeSeries(this.results_, this.ms2Removed_, this.adductInsensitiveRtFilter_);
        return this.results_;
    }

    public Hashtable<String, Hashtable<String, RtPredictVO>> predictRetentionTimesBasedOnResults(Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> ms1ToPredict, Hashtable<String, Hashtable<String, RtPredictVO>> prevPredictions) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        Vector<Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>>> dataOrdered = this.orderData(this.results_, this.ms2Removed_, null);
        Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> postProcessData = dataOrdered.get(1);
        Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> negativeExamples = dataOrdered.get(2);
        Hashtable<String, Hashtable<String, RtPredictVO>> rtPredictVOs = new Hashtable<String, Hashtable<String, RtPredictVO>>();
        for (String className : ms1ToPredict.keySet()) {
            if (!postProcessData.containsKey(className)) continue;
            Hashtable<String, RtPredictVO> classRtPredictVOs = new Hashtable<String, RtPredictVO>();
            for (String mod : postProcessData.get(className).keySet()) {
                Hashtable<String, Hashtable<String, LipidParameterSet>> negatives = new Hashtable();
                if (negativeExamples.containsKey(className) && negativeExamples.get(className).containsKey(mod)) {
                    negatives = negativeExamples.get(className).get(mod);
                }
                String ruleName = StaticUtils.getRuleName(className, mod);
                Hashtable<String, Hashtable<String, LipidParameterSet>> result = postProcessData.get(className).get(mod);
                try {
                    Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> paramsOrdered = new Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>>();
                    Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> negativesOrdered = new Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>>();
                    RangeInteger cAtomsRange = null;
                    Hashtable<Integer, RangeInteger> dbsRanges = null;
                    Vector ranges = this.groupAccordingToCAtomsAndDoubleBonds(result, new Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>>(), paramsOrdered, className, ruleName);
                    cAtomsRange = (RangeInteger)ranges.get(0);
                    dbsRanges = (Hashtable<Integer, RangeInteger>)ranges.get(1);
                    Vector rangesNeg = this.groupAccordingToCAtomsAndDoubleBonds(negatives, new Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>>(), negativesOrdered, className, ruleName);
                    float tolerance = 4.0f;
                    float maxDev = -1.0f;
                    if (RulesContainer.getRetentionTimeMaxDeviation(ruleName) != null) {
                        maxDev = new Float(RulesContainer.getRetentionTimeMaxDeviation(ruleName)).floatValue();
                    }
                    boolean diffOh = false;
                    int oh = -1;
                    for (Hashtable<Integer, Hashtable<String, LipidParameterSet>> sameC : paramsOrdered.values()) {
                        for (Hashtable<String, LipidParameterSet> sameDbs : sameC.values()) {
                            for (LipidParameterSet set : sameDbs.values()) {
                                if (oh == -1) {
                                    oh = set.getOhNumber();
                                    continue;
                                }
                                if (oh == set.getOhNumber()) continue;
                                diffOh = true;
                            }
                        }
                    }
                    Vector resultsLM = this.doIterativeLMOptimization(paramsOrdered, paramsOrdered, cAtomsRange, dbsRanges, negativesOrdered, tolerance, maxDev, diffOh);
                    LevenbergMarquardtOptimizer optimizer = (LevenbergMarquardtOptimizer)resultsLM.get(0);
                    LevenbergMarquardtOptimizer counterModel = (LevenbergMarquardtOptimizer)resultsLM.get(1);
                    Hashtable<String, Hashtable<String, LipidParameterSet>> unprocResult = new Hashtable<String, Hashtable<String, LipidParameterSet>>(result);
                    for (String analyteName : ms1ToPredict.get(className).keySet()) {
                        Hashtable<String, QuantVO> analytesMod = ms1ToPredict.get(className).get(analyteName);
                        if (!analytesMod.containsKey(mod) || unprocResult.containsKey(analyteName)) continue;
                        QuantVO quantVO = analytesMod.get(mod);
                        LipidParameterSet setForPred = new LipidParameterSet((float)quantVO.getAnalyteMass(), quantVO.getAnalyteName(), quantVO.getDbs(), quantVO.getModName(), -1.0, quantVO.getAnalyteFormula(), quantVO.getModFormula(), quantVO.getCharge(), quantVO.getOhNumber());
                        Hashtable<String, LipidParameterSet> forPred = new Hashtable<String, LipidParameterSet>();
                        forPred.put(setForPred.getRt(), setForPred);
                        unprocResult.put(analyteName, forPred);
                    }
                    Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> unprocessed = new Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>>();
                    ranges = this.groupAccordingToCAtomsAndDoubleBonds(unprocResult, new Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>>(), unprocessed, className, ruleName);
                    RangeInteger cAtomsMaxRange = (RangeInteger)ranges.get(0);
                    Hashtable dbsMaxRanges = (Hashtable)ranges.get(1);
                    if (prevPredictions != null && prevPredictions.containsKey(className) && prevPredictions.get(className).containsKey(mod)) {
                        RtPredictVO predVO = prevPredictions.get(className).get(mod);
                        cAtomsRange = predVO.getcAtomsRange();
                        dbsRanges = predVO.getDbsRanges();
                    }
                    Vector proposedRanges = this.proposeLMFilterRanges(unprocessed, cAtomsMaxRange, dbsMaxRanges, cAtomsRange, dbsRanges);
                    RangeInteger newCAtomsRange = (RangeInteger)proposedRanges.get(0);
                    Hashtable newDbsRanges = (Hashtable)proposedRanges.get(1);
                    RtPredictVO predVO = new RtPredictVO(optimizer, counterModel, newCAtomsRange, newDbsRanges);
                    classRtPredictVOs.put(mod, predVO);
                    Pattern cAtomsPattern = Pattern.compile(RulesContainer.getCAtomsFromNamePattern(ruleName));
                    Pattern dbsPattern = Pattern.compile(RulesContainer.getDoubleBondsFromNamePattern(ruleName));
                    for (String analyteName : ms1ToPredict.get(className).keySet()) {
                        Hashtable<String, QuantVO> analytesMod = ms1ToPredict.get(className).get(analyteName);
                        if (!analytesMod.containsKey(mod)) continue;
                        QuantVO quantVO = analytesMod.get(mod);
                        Matcher cAtomsMatcher = cAtomsPattern.matcher(analyteName.split(";")[0]);
                        if (!cAtomsMatcher.matches()) {
                            throw new RulesException("The analyte " + analyteName + " does not match the " + "CAtomsFromName" + " pattern \"" + RulesContainer.getCAtomsFromNamePattern(ruleName) + "\" of the class " + ruleName + "!");
                        }
                        Matcher dbsMatcher = dbsPattern.matcher(analyteName.split(";")[0]);
                        int cAtoms = Integer.parseInt(cAtomsMatcher.group(1));
                        if (!dbsMatcher.matches()) {
                            throw new RulesException("The analyte " + analyteName + " does not match the " + "DoubleBondsFromName" + " pattern \"" + RulesContainer.getDoubleBondsFromNamePattern(ruleName) + "\" of the class " + ruleName + "!");
                        }
                        int dbs = Integer.parseInt(dbsMatcher.group(1));
                        quantVO.setRetTime(optimizer.calculateFitValue(new float[]{cAtoms, dbs}));
                    }
                }
                catch (LMException e) {
                    System.out.println("Warning: " + className + "_" + mod + " was not RT filtered: " + e.getMessage());
                }
            }
            if (classRtPredictVOs.size() <= 0) continue;
            rtPredictVOs.put(className, classRtPredictVOs);
        }
        return rtPredictVOs;
    }

    /*
     * WARNING - void declaration
     */
    private Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> correctByRetentionTimeSeries(Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> unprocessed, Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> ms2Removed, Hashtable<String, Boolean> adductInsensitiveRtFilter_) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        Vector<Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>>> dataOrdered = this.orderData(unprocessed, ms2Removed, adductInsensitiveRtFilter_);
        Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> results = dataOrdered.get(0);
        Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> postProcessData = dataOrdered.get(1);
        Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> negativeExamples = dataOrdered.get(2);
        for (String className : postProcessData.keySet()) {
            Hashtable resultsAnalyte;
            Hashtable<Object, Object> resultsClass;
            if (adductInsensitiveRtFilter_.get(className).booleanValue()) {
                boolean diffOh = false;
                int oh = -1;
                Hashtable<String, Hashtable<String, LipidParameterSet>> resultsModIgnored = new Hashtable<String, Hashtable<String, LipidParameterSet>>();
                Hashtable<String, Hashtable<String, LipidParameterSet>> negatives = new Hashtable<String, Hashtable<String, LipidParameterSet>>();
                String anyValidRuleName = null;
                float maxDev = -1.0f;
                for (String mod : postProcessData.get(className).keySet()) {
                    void var19_34;
                    int count;
                    Hashtable<Object, Object> sameAnalyte;
                    try {
                        if (RulesContainer.isRtPostprocessing(StaticUtils.getRuleName(className, mod))) {
                            anyValidRuleName = StaticUtils.getRuleName(className, mod);
                            float aDev = -1.0f;
                            if (RulesContainer.getRetentionTimeMaxDeviation(anyValidRuleName) != null) {
                                aDev = new Float(RulesContainer.getRetentionTimeMaxDeviation(anyValidRuleName)).floatValue();
                            }
                            if (aDev > 0.0f && aDev > maxDev) {
                                maxDev = aDev;
                            }
                        }
                    }
                    catch (Exception aDev) {
                        // empty catch block
                    }
                    Hashtable<String, Hashtable<String, LipidParameterSet>> analytes = postProcessData.get(className).get(mod);
                    Hashtable hashtable = new Hashtable();
                    if (negativeExamples.containsKey(className) && negativeExamples.get(className).containsKey(mod)) {
                        Hashtable<String, Hashtable<String, LipidParameterSet>> hashtable2 = negativeExamples.get(className).get(mod);
                    }
                    for (String analyteName : analytes.keySet()) {
                        sameAnalyte = new Hashtable();
                        if (resultsModIgnored.containsKey(analyteName)) {
                            sameAnalyte = resultsModIgnored.get(analyteName);
                        }
                        for (String rt : ((Hashtable)analytes.get(analyteName)).keySet()) {
                            if (sameAnalyte.containsKey(rt)) {
                                count = 1;
                                while (sameAnalyte.containsKey(rt + "_" + count)) {
                                    ++count;
                                }
                                sameAnalyte.put(rt + "_" + String.valueOf(count), ((Hashtable)analytes.get(analyteName)).get(rt));
                            } else {
                                sameAnalyte.put(rt, ((Hashtable)analytes.get(analyteName)).get(rt));
                            }
                            if (oh == -1) {
                                oh = ((LipidParameterSet)((Hashtable)analytes.get(analyteName)).get(rt)).getOhNumber();
                                continue;
                            }
                            if (oh == ((LipidParameterSet)((Hashtable)analytes.get(analyteName)).get(rt)).getOhNumber()) continue;
                            diffOh = true;
                        }
                        resultsModIgnored.put(analyteName, sameAnalyte);
                    }
                    for (String analyteName : var19_34.keySet()) {
                        sameAnalyte = new Hashtable();
                        if (negatives.containsKey(analyteName)) {
                            sameAnalyte = negatives.get(analyteName);
                        }
                        for (String rt : ((Hashtable)var19_34.get(analyteName)).keySet()) {
                            if (sameAnalyte.containsKey(rt)) {
                                count = 1;
                                while (sameAnalyte.containsKey(rt + "_" + count)) {
                                    ++count;
                                }
                                sameAnalyte.put(rt + "_" + String.valueOf(count), ((Hashtable)var19_34.get(analyteName)).get(rt));
                                continue;
                            }
                            sameAnalyte.put(rt, ((Hashtable)var19_34.get(analyteName)).get(rt));
                        }
                        negatives.put(analyteName, sameAnalyte);
                    }
                }
                float minDev = this.extractMinimumAcceptedDeviationValue(className, resultsModIgnored);
                try {
                    resultsModIgnored = this.filterRetentionTimeSeries(className, anyValidRuleName, resultsModIgnored, negatives, maxDev, minDev, true, diffOh);
                }
                catch (LMException e) {
                    System.out.println("Warning: " + className + " was not RT filtered: " + e.getMessage());
                }
                resultsClass = new Hashtable();
                for (String string : resultsModIgnored.keySet()) {
                    resultsAnalyte = new Hashtable();
                    Hashtable<String, LipidParameterSet> sameAnalyte = resultsModIgnored.get(string);
                    for (String rt : sameAnalyte.keySet()) {
                        LipidParameterSet set = sameAnalyte.get(rt);
                        String finalRt = new String(rt);
                        if (finalRt.indexOf("_") != -1) {
                            finalRt = finalRt.substring(0, finalRt.indexOf("_"));
                        }
                        String mod = set.getModificationName();
                        Hashtable resultsMod = new Hashtable();
                        if (resultsAnalyte.containsKey(mod)) {
                            resultsMod = (Hashtable)resultsAnalyte.get(mod);
                        }
                        resultsMod.put(finalRt, set);
                        resultsAnalyte.put(mod, resultsMod);
                        resultsClass.put(string, resultsAnalyte);
                        results.put(className, resultsClass);
                    }
                }
                continue;
            }
            for (String mod : postProcessData.get(className).keySet()) {
                Hashtable<String, Hashtable<String, LipidParameterSet>> negatives = new Hashtable();
                if (negativeExamples.containsKey(className) && negativeExamples.get(className).containsKey(mod)) {
                    negatives = negativeExamples.get(className).get(mod);
                }
                String ruleName = StaticUtils.getRuleName(className, mod);
                Hashtable<String, Hashtable<String, LipidParameterSet>> result = postProcessData.get(className).get(mod);
                boolean diffOh = false;
                int oh = -1;
                for (Hashtable<String, LipidParameterSet> sameAnalyte : result.values()) {
                    for (LipidParameterSet set : sameAnalyte.values()) {
                        if (oh == -1) {
                            oh = set.getOhNumber();
                            continue;
                        }
                        if (oh == set.getOhNumber()) continue;
                        diffOh = true;
                    }
                }
                try {
                    float maxDev = -1.0f;
                    if (RulesContainer.getRetentionTimeMaxDeviation(ruleName) != null) {
                        maxDev = new Float(RulesContainer.getRetentionTimeMaxDeviation(ruleName)).floatValue();
                    }
                    float minDev = this.extractMinimumAcceptedDeviationValue(className, postProcessData.get(className).get(mod));
                    result = this.filterRetentionTimeSeries(className, ruleName, postProcessData.get(className).get(mod), negatives, maxDev, minDev, false, diffOh);
                }
                catch (LMException e) {
                    System.out.println("Warning: " + className + "_" + mod + " was not RT filtered: " + e.getMessage());
                }
                resultsClass = new Hashtable();
                if (results.containsKey(className)) {
                    resultsClass = results.get(className);
                }
                for (String string : result.keySet()) {
                    resultsAnalyte = new Hashtable();
                    if (resultsClass.containsKey(string)) {
                        resultsAnalyte = (Hashtable)resultsClass.get(string);
                    }
                    resultsAnalyte.put(mod, result.get(string));
                    resultsClass.put(string, resultsAnalyte);
                    results.put(className, resultsClass);
                }
            }
        }
        return results;
    }

    private Vector<Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>>> orderData(Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> unprocessed, Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> ms2Removed, Hashtable<String, Boolean> adductInsensitiveRtFilter) {
        Vector<Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>>> dataOrdered = new Vector<Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>>>();
        Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> results = new Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>>();
        Hashtable postProcessData = new Hashtable();
        Hashtable negativeExamples = new Hashtable();
        for (String className : unprocessed.keySet()) {
            boolean adductInsensitive = false;
            if (adductInsensitiveRtFilter != null && adductInsensitiveRtFilter.containsKey(className) && adductInsensitiveRtFilter.get(className).booleanValue()) {
                adductInsensitive = true;
            }
            boolean acceptAnyMod = false;
            for (String string : unprocessed.get(className).keySet()) {
                if (!adductInsensitive) continue;
                boolean modFound = false;
                for (String mod : unprocessed.get(className).get(string).keySet()) {
                    try {
                        if (!RulesContainer.isRtPostprocessing(StaticUtils.getRuleName(className, mod))) continue;
                        modFound = true;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                if (!modFound) continue;
                acceptAnyMod = true;
                break;
            }
            Hashtable<String, Hashtable> postProcessOfClass = new Hashtable<String, Hashtable>();
            for (String analyteName3 : unprocessed.get(className).keySet()) {
                for (String mod : unprocessed.get(className).get(analyteName3).keySet()) {
                    try {
                        if (!className.contains("ox") && (acceptAnyMod || RulesContainer.isRtPostprocessing(StaticUtils.getRuleName(className, mod)))) {
                            Hashtable postProcessOfMod = new Hashtable();
                            if (postProcessOfClass.containsKey(mod)) {
                                postProcessOfMod = (Hashtable)postProcessOfClass.get(mod);
                            }
                            postProcessOfMod.put(analyteName3, unprocessed.get(className).get(analyteName3).get(mod));
                            postProcessOfClass.put(mod, postProcessOfMod);
                        }
                    }
                    catch (Exception postProcessOfMod) {
                        // empty catch block
                    }
                    if (postProcessOfClass.containsKey(mod)) continue;
                    Hashtable resultsClass = new Hashtable();
                    if (results.containsKey(className)) {
                        resultsClass = (Hashtable)results.get(className);
                    }
                    Hashtable resultsAnalyte = new Hashtable();
                    if (resultsClass.containsKey(analyteName3)) {
                        resultsAnalyte = (Hashtable)resultsClass.get(analyteName3);
                    }
                    resultsAnalyte.put(mod, unprocessed.get(className).get(analyteName3).get(mod));
                    resultsClass.put(analyteName3, resultsAnalyte);
                    results.put(className, resultsClass);
                }
            }
            if (postProcessOfClass.size() > 0) {
                postProcessData.put(className, postProcessOfClass);
                Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
                if (ms2Removed.containsKey(className)) {
                    for (String analyteName4 : ms2Removed.get(className).keySet()) {
                        for (String mod : ms2Removed.get(className).get(analyteName4).keySet()) {
                            if (!postProcessOfClass.containsKey(mod)) continue;
                            Hashtable negativeMod = new Hashtable();
                            if (hashtable.containsKey(mod)) {
                                negativeMod = (Hashtable)hashtable.get(mod);
                            }
                            negativeMod.put(analyteName4, ms2Removed.get(className).get(analyteName4).get(mod));
                            hashtable.put(mod, negativeMod);
                        }
                    }
                }
                negativeExamples.put(className, hashtable);
                continue;
            }
            if (results.containsKey(className)) continue;
            results.put(className, unprocessed.get(className));
        }
        dataOrdered.add(results);
        dataOrdered.add(postProcessData);
        dataOrdered.add(negativeExamples);
        return dataOrdered;
    }

    private Hashtable<String, Hashtable<String, LipidParameterSet>> filterRetentionTimeSeries(String className, String ruleName, Hashtable<String, Hashtable<String, LipidParameterSet>> unprocessed, Hashtable<String, Hashtable<String, LipidParameterSet>> negatives, float maxDev, float minDev, boolean adductInsensitive, boolean respectOh) throws RulesException, NoRuleException, IOException, SpectrummillParserException, LMException {
        Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> paramsOrdered = new Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>>();
        Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> unprocessedOrdered = new Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>>();
        Vector ranges = this.groupAccordingToCAtomsAndDoubleBonds(unprocessed, paramsOrdered, unprocessedOrdered, className, ruleName);
        RangeInteger cAtomsRange = (RangeInteger)ranges.get(0);
        Hashtable dbsRanges = (Hashtable)ranges.get(1);
        Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> negativesOrdered = new Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>>();
        Vector rangesNeg = this.groupAccordingToCAtomsAndDoubleBonds(negatives, new Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>>(), negativesOrdered, className, ruleName);
        float tolerance = 4.0f;
        Vector results = this.doIterativeLMOptimization(unprocessedOrdered, paramsOrdered, cAtomsRange, dbsRanges, negativesOrdered, tolerance, maxDev, respectOh);
        LevenbergMarquardtOptimizer optimizer = (LevenbergMarquardtOptimizer)results.get(0);
        if (adductInsensitive) {
            this.predictedModels_.put(className, optimizer);
            this.respectOhs_.put(className, respectOh);
        } else {
            this.predictedModels_.put(ruleName, optimizer);
            this.respectOhs_.put(ruleName, respectOh);
        }
        LevenbergMarquardtOptimizer counterModel = (LevenbergMarquardtOptimizer)results.get(1);
        Hashtable foundNegatives = (Hashtable)results.get(2);
        Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> newForModel = this.filterValidHitsBasedOnModel(optimizer, unprocessedOrdered, cAtomsRange, dbsRanges, tolerance, maxDev, minDev, counterModel, foundNegatives, respectOh);
        Hashtable<String, Hashtable<String, LipidParameterSet>> filteredValues = new Hashtable<String, Hashtable<String, LipidParameterSet>>();
        Pattern cAtomsPattern = Pattern.compile(RulesContainer.getCAtomsFromNamePattern(ruleName));
        Pattern dbsPattern = Pattern.compile(RulesContainer.getDoubleBondsFromNamePattern(ruleName));
        for (String analyteName : unprocessed.keySet()) {
            Hashtable<String, LipidParameterSet> sameAnalyte = unprocessed.get(analyteName);
            Matcher cAtomsMatcher = cAtomsPattern.matcher(analyteName.split(";")[0]);
            if (!cAtomsMatcher.matches()) {
                throw new RulesException("The analyte " + analyteName + " does not match the " + "CAtomsFromName" + " pattern \"" + RulesContainer.getCAtomsFromNamePattern(ruleName) + "\" of the class " + ruleName + "!");
            }
            int cAtoms = Integer.parseInt(cAtomsMatcher.group(1));
            Matcher dbsMatcher = dbsPattern.matcher(analyteName.split(";")[0]);
            if (!dbsMatcher.matches()) {
                throw new RulesException("The analyte " + analyteName + " does not match the " + "DoubleBondsFromName" + " pattern \"" + RulesContainer.getDoubleBondsFromNamePattern(ruleName) + "\" of the class " + ruleName + "!");
            }
            int dbs = Integer.parseInt(dbsMatcher.group(1));
            if (!newForModel.containsKey(cAtoms) || !newForModel.get(cAtoms).containsKey(dbs)) continue;
            Hashtable<String, LipidParameterSet> filteredRts = newForModel.get(cAtoms).get(dbs);
            Hashtable<String, LipidParameterSet> acceptedRts = new Hashtable<String, LipidParameterSet>();
            for (String rt : sameAnalyte.keySet()) {
                if (!filteredRts.containsKey(rt)) continue;
                acceptedRts.put(rt, sameAnalyte.get(rt));
            }
            if (acceptedRts.size() <= 0) continue;
            filteredValues.put(analyteName, acceptedRts);
        }
        return filteredValues;
    }

    private Vector doIterativeLMOptimization(Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> unprocessed, Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> forModel, RangeInteger cAtomsMaxRange, Hashtable<Integer, RangeInteger> dbsMaxRanges, Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> negatives, float tolerance, float maxDev, boolean respectOh) throws LMException {
        return this.doIterativeLMOptimization(unprocessed, forModel, cAtomsMaxRange, dbsMaxRanges, null, null, null, negatives, new Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>>(), tolerance, maxDev, 0, respectOh);
    }

    private Vector doIterativeLMOptimization(Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> unprocessed, Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> forModel, RangeInteger cAtomsMaxRange, Hashtable<Integer, RangeInteger> dbsMaxRanges, RangeInteger cAtomsRange, Hashtable<Integer, RangeInteger> dbsRanges, LevenbergMarquardtOptimizer prevOptimizer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> negatives, Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> remainingNegatives, float tolerance, float maxDev, int count, boolean respectOh) throws LMException {
        Vector result;
        if (prevOptimizer != null) {
            // empty if block
        }
        LevenbergMarquardtOptimizer optimizer = this.optimizeLMModel(forModel, null, respectOh);
        Vector currentRanges = this.getCurrentRanges(forModel, cAtomsRange, dbsRanges);
        RangeInteger currentCAtomsRange = (RangeInteger)currentRanges.get(0);
        Hashtable currentDbsRanges = (Hashtable)currentRanges.get(1);
        LevenbergMarquardtOptimizer counterModel = null;
        Hashtable returnedNegatives = new Hashtable();
        Hashtable unusedNegatives = new Hashtable();
        try {
            Vector result2 = this.checkForLMCounterModel(optimizer, negatives, remainingNegatives, currentCAtomsRange, currentDbsRanges, tolerance, respectOh);
            if (result2 != null) {
                counterModel = (LevenbergMarquardtOptimizer)result2.get(0);
                returnedNegatives = (Hashtable)result2.get(1);
                unusedNegatives = (Hashtable)result2.get(2);
            }
        }
        catch (LMException lmx) {
            System.out.println("Warning: calculation of counter model was not possible! Reason: " + lmx.getMessage());
        }
        if (counterModel != null && count == 0) {
            Vector<LevenbergMarquardtOptimizer> optimizers = this.evaluateFilterAgainBasedOnCounterModel(forModel, returnedNegatives, optimizer, counterModel, respectOh);
            optimizer = optimizers.get(0);
            counterModel = optimizers.get(1);
        }
        Vector ranges = this.proposeLMFilterRanges(unprocessed, cAtomsMaxRange, dbsMaxRanges, currentCAtomsRange, currentDbsRanges);
        RangeInteger newCAtomsRange = (RangeInteger)ranges.get(0);
        Hashtable newDbsRanges = (Hashtable)ranges.get(1);
        if (counterModel != null && (result = this.checkForLMCounterModel(optimizer, returnedNegatives, unusedNegatives, newCAtomsRange, newDbsRanges, tolerance, respectOh)) != null && result.size() > 0 && result.get(0) != null) {
            counterModel = (LevenbergMarquardtOptimizer)result.get(0);
            returnedNegatives = (Hashtable)result.get(1);
            unusedNegatives = (Hashtable)result.get(2);
        }
        Vector<Object> results = new Vector<Object>();
        results.add(optimizer);
        results.add(counterModel);
        results.add(returnedNegatives);
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private LevenbergMarquardtOptimizer optimizeLMModel(Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> forModel, FloatMatrix prevParams, boolean respectOh) throws LMException {
        void var8_19;
        int dataSize = 0;
        for (Hashtable<Integer, Hashtable<String, LipidParameterSet>> values1 : forModel.values()) {
            for (Hashtable<String, LipidParameterSet> hashtable : values1.values()) {
                for (LipidParameterSet set : hashtable.values()) {
                    ++dataSize;
                }
            }
        }
        float[][] values = respectOh ? new float[dataSize][3] : new float[dataSize][2];
        float[] rtValues = new float[dataSize];
        int count = 0;
        for (Integer cAtoms : forModel.keySet()) {
            Hashtable<Integer, Hashtable<String, LipidParameterSet>> sameCAtoms = forModel.get(cAtoms);
            for (Integer dbs : sameCAtoms.keySet()) {
                Hashtable<String, LipidParameterSet> sameCAndDbs = sameCAtoms.get(dbs);
                for (String rt : sameCAndDbs.keySet()) {
                    values[count][0] = cAtoms.intValue();
                    values[count][1] = dbs.intValue();
                    if (respectOh) {
                        values[count][2] = sameCAndDbs.get(rt).getOhNumber().intValue();
                    }
                    rtValues[count] = this.getRtFromRtString(rt);
                    ++count;
                }
            }
        }
        Object var8_11 = null;
        if (respectOh) {
            try {
                LMAsymptVarDecayThreeVariables lMAsymptVarDecayThreeVariables = new LMAsymptVarDecayThreeVariables(values, rtValues, prevParams);
                ((LevenbergMarquardtOptimizer)lMAsymptVarDecayThreeVariables).fit();
            }
            catch (Exception ex) {
                try {
                    LMAsymptDecayThreeVariables lMAsymptDecayThreeVariables = new LMAsymptDecayThreeVariables(values, rtValues, prevParams);
                    ((LevenbergMarquardtOptimizer)lMAsymptDecayThreeVariables).fit();
                }
                catch (Exception ex2) {
                    try {
                        LMLogDecayThreeVariables lMLogDecayThreeVariables = new LMLogDecayThreeVariables(values, rtValues, prevParams);
                        ((LevenbergMarquardtOptimizer)lMLogDecayThreeVariables).fit();
                    }
                    catch (Exception ex3) {
                        throw new LMException("The model could not be fitted!");
                    }
                }
            }
        } else {
            try {
                LMAsymptVarDecayTwoVariables lMAsymptVarDecayTwoVariables = new LMAsymptVarDecayTwoVariables(values, rtValues, prevParams);
                ((LevenbergMarquardtOptimizer)lMAsymptVarDecayTwoVariables).fit();
            }
            catch (Exception ex) {
                try {
                    LMAsymptDecayTwoVariables lMAsymptDecayTwoVariables = new LMAsymptDecayTwoVariables(values, rtValues, prevParams);
                    ((LevenbergMarquardtOptimizer)lMAsymptDecayTwoVariables).fit();
                }
                catch (Exception ex2) {
                    try {
                        LMLogDecayTwoVariables lMLogDecayTwoVariables = new LMLogDecayTwoVariables(values, rtValues, prevParams);
                        ((LevenbergMarquardtOptimizer)lMLogDecayTwoVariables).fit();
                    }
                    catch (Exception ex3) {
                        throw new LMException("The model could not be fitted!");
                    }
                }
            }
        }
        return var8_19;
    }

    private Vector getCurrentRanges(Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> forModel, RangeInteger cAtomsRange, Hashtable<Integer, RangeInteger> dbsRanges) {
        Vector<Object> results = new Vector<Object>();
        RangeInteger currC = null;
        Hashtable<Integer, RangeInteger> currDbs = null;
        if (cAtomsRange == null || dbsRanges == null) {
            currC = new RangeInteger(Integer.MAX_VALUE, 0);
            currDbs = new Hashtable();
            for (Integer cAtoms : forModel.keySet()) {
                if (cAtoms < currC.getStart()) {
                    currC = new RangeInteger(cAtoms, currC.getStop());
                }
                if (cAtoms > currC.getStop()) {
                    currC = new RangeInteger(currC.getStart(), cAtoms);
                }
                for (Integer dbs : forModel.get(cAtoms).keySet()) {
                    RangeInteger dbsRange = new RangeInteger(Integer.MAX_VALUE, 0);
                    if (currDbs.containsKey(cAtoms)) {
                        dbsRange = currDbs.get(cAtoms);
                    }
                    if (dbs < dbsRange.getStart()) {
                        dbsRange = new RangeInteger(dbs, dbsRange.getStop());
                    }
                    if (dbs > dbsRange.getStop()) {
                        dbsRange = new RangeInteger(dbsRange.getStart(), dbs);
                    }
                    currDbs.put(cAtoms, dbsRange);
                }
            }
        } else {
            currC = cAtomsRange;
            currDbs = dbsRanges;
        }
        results.add(currC);
        results.add(currDbs);
        return results;
    }

    private Vector proposeLMFilterRanges(Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> unprocessed, RangeInteger cAtomsMaxRange, Hashtable<Integer, RangeInteger> dbsMaxRanges, RangeInteger cAtomsRange, Hashtable<Integer, RangeInteger> dbsRanges) {
        boolean oneMissing = false;
        boolean allCRangesCovered = true;
        int minCDistance = Integer.MAX_VALUE;
        int minDbsDistance = Integer.MAX_VALUE;
        for (Integer cAt : unprocessed.keySet()) {
            if (dbsRanges.containsKey(cAt)) {
                RangeInteger dbRange = dbsRanges.get(cAt);
                Hashtable<Integer, Hashtable<String, LipidParameterSet>> sameC = unprocessed.get(cAt);
                for (Integer dbs : sameC.keySet()) {
                    if (dbRange.insideRange(dbs)) continue;
                    oneMissing = true;
                    int dist = dbs - dbRange.getStop();
                    if (dbs < dbRange.getStart()) {
                        dist = dbRange.getStart() - dbs;
                    }
                    if (dist >= minDbsDistance) continue;
                    minDbsDistance = dist;
                }
                continue;
            }
            allCRangesCovered = false;
            oneMissing = true;
            for (Integer cFound : dbsRanges.keySet()) {
                int dist = Math.abs(cAt - cFound);
                if (dist >= minCDistance) continue;
                minCDistance = dist;
            }
        }
        Vector<Object> results = new Vector<Object>();
        if (oneMissing) {
            Object sameC;
            Hashtable<Integer, RangeInteger> proposedDbs = new Hashtable<Integer, RangeInteger>();
            ArrayList<Integer> cAtomsList = new ArrayList<Integer>(unprocessed.keySet());
            Collections.sort(cAtomsList);
            for (int i = 0; i != cAtomsList.size(); ++i) {
                Integer cAtoms = (Integer)cAtomsList.get(i);
                sameC = unprocessed.get(cAtoms);
                RangeInteger dbsRange = null;
                if (dbsRanges.containsKey(cAtoms)) {
                    dbsRange = dbsRanges.get(cAtoms);
                    if (((Hashtable)sameC).containsKey(dbsRange.getStart() - minDbsDistance)) {
                        dbsRange = new RangeInteger(dbsRange.getStart() - minDbsDistance, dbsRange.getStop());
                    }
                    if (((Hashtable)sameC).containsKey(dbsRange.getStop() + minDbsDistance)) {
                        dbsRange = new RangeInteger(dbsRange.getStart(), dbsRange.getStop() + minDbsDistance);
                    }
                }
                RangeInteger maxDbsRange = dbsMaxRanges.get(cAtoms);
                if (i != 0 && (dbsRanges.containsKey(cAtoms - minCDistance) || allCRangesCovered)) {
                    RangeInteger lessCs = null;
                    lessCs = allCRangesCovered ? dbsRanges.get(cAtomsList.get(i - 1)) : dbsRanges.get(cAtoms - minCDistance);
                    if (dbsRange == null) {
                        dbsRange = lessCs;
                    } else {
                        dbsRange.extendToOtherRanges(dbsRange, maxDbsRange);
                    }
                }
                if (i != cAtomsList.size() - 1 && (dbsRanges.containsKey(cAtoms + minCDistance) || allCRangesCovered)) {
                    RangeInteger moreCs = null;
                    moreCs = allCRangesCovered ? dbsRanges.get(cAtomsList.get(i + 1)) : dbsRanges.get(cAtoms + minCDistance);
                    if (dbsRange == null) {
                        dbsRange = moreCs;
                    } else {
                        dbsRange.extendToOtherRanges(dbsRange, maxDbsRange);
                    }
                }
                if (dbsRange == null) continue;
                proposedDbs.put(cAtoms, dbsRange);
            }
            int lowestCs = Integer.MAX_VALUE;
            int highestCs = 0;
            sameC = proposedDbs.keySet().iterator();
            while (sameC.hasNext()) {
                int cAtoms = (Integer)sameC.next();
                if (cAtoms < lowestCs) {
                    lowestCs = cAtoms;
                }
                if (cAtoms <= highestCs) continue;
                highestCs = cAtoms;
            }
            RangeInteger proposedCs = new RangeInteger(lowestCs, highestCs);
            results.add(proposedCs);
            results.add(proposedDbs);
        } else {
            results.add(cAtomsMaxRange);
            results.add(dbsMaxRanges);
        }
        return results;
    }

    private Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> filterValidHitsBasedOnModel(LevenbergMarquardtOptimizer model, Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> unprocessed, RangeInteger cAtomsRange, Hashtable<Integer, RangeInteger> dbsRanges, float tolerance, float maxDev, float minDev, LevenbergMarquardtOptimizer counterModel, Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> negatives, boolean respectOh) throws LMException {
        Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> forModel = new Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>>();
        for (Integer cAtoms : unprocessed.keySet()) {
            if (!dbsRanges.containsKey(cAtoms)) continue;
            Hashtable<Integer, Hashtable<String, LipidParameterSet>> sameC = unprocessed.get(cAtoms);
            Hashtable sameCModel = new Hashtable();
            Hashtable<Object, Object> negSameC = new Hashtable();
            if (negatives.containsKey(cAtoms)) {
                negSameC = negatives.get(cAtoms);
            }
            RangeInteger dbsRange = dbsRanges.get(cAtoms);
            for (Integer dbs : sameC.keySet()) {
                if (!dbsRange.insideRange(dbs)) continue;
                Hashtable<String, LipidParameterSet> sameDbs = sameC.get(dbs);
                Hashtable<String, LipidParameterSet> sameDbsModel = new Hashtable<String, LipidParameterSet>();
                Hashtable negSameDbs = new Hashtable();
                if (negSameC.containsKey(dbs)) {
                    negSameDbs = (Hashtable)negSameC.get(dbs);
                }
                for (String rtString : sameDbs.keySet()) {
                    if (negSameDbs.containsKey(rtString)) continue;
                    float rt = this.getRtFromRtString(rtString);
                    float[] cAndDbs = new float[2];
                    if (respectOh) {
                        cAndDbs = new float[3];
                    }
                    cAndDbs[0] = cAtoms.intValue();
                    cAndDbs[1] = dbs.intValue();
                    if (respectOh) {
                        cAndDbs[2] = sameDbs.get(rtString).getOhNumber().intValue();
                    }
                    float fitRt = model.calculateFitValue(cAndDbs);
                    float counterRt = Float.NaN;
                    if (counterModel != null) {
                        counterRt = counterModel.calculateFitValue(cAndDbs);
                    }
                    float allowedRange = model.getMeanDeviation() * tolerance;
                    if (maxDev > 0.0f && allowedRange > maxDev) {
                        allowedRange = maxDev;
                    }
                    if (minDev > allowedRange) {
                        allowedRange = minDev;
                    }
                    if (!(fitRt - allowedRange < rt) || !(rt < fitRt + allowedRange)) continue;
                    if (PostQuantificationProcessor.fallsOnCounterModelSide(rt, fitRt, counterRt)) {
                        negSameDbs.put(rtString, sameDbs.get(rtString));
                        continue;
                    }
                    sameDbsModel.put(rtString, sameDbs.get(rtString));
                }
                if (sameDbsModel.size() > 0) {
                    sameCModel.put(dbs, sameDbsModel);
                }
                if (negSameDbs.size() <= 0) continue;
                negSameC.put(dbs, negSameDbs);
            }
            if (sameCModel.size() > 0) {
                forModel.put(cAtoms, sameCModel);
            }
            if (negSameC.size() <= 0) continue;
            negatives.put(cAtoms, negSameC);
        }
        return forModel;
    }

    private Vector groupAccordingToCAtomsAndDoubleBonds(Hashtable<String, Hashtable<String, LipidParameterSet>> input, Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> msnOrdered, Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> allOrdered, String className, String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        Pattern cAtomsPattern = Pattern.compile(RulesContainer.getCAtomsFromNamePattern(ruleName));
        Pattern dbsPattern = Pattern.compile(RulesContainer.getDoubleBondsFromNamePattern(ruleName));
        RangeInteger cAtomsRange = new RangeInteger(Integer.MAX_VALUE, 0);
        Hashtable<Integer, RangeInteger> dbsRanges = new Hashtable<Integer, RangeInteger>();
        for (String analyteName : input.keySet()) {
            Matcher cAtomsMatcher = cAtomsPattern.matcher(analyteName.split(";")[0]);
            if (!cAtomsMatcher.matches()) {
                throw new RulesException("The analyte " + analyteName + " does not match the " + "CAtomsFromName" + " pattern \"" + RulesContainer.getCAtomsFromNamePattern(ruleName) + "\" of the class " + ruleName + "!");
            }
            int cAtoms = Integer.parseInt(cAtomsMatcher.group(1));
            Matcher dbsMatcher = dbsPattern.matcher(analyteName.split(";")[0]);
            if (!dbsMatcher.matches()) {
                throw new RulesException("The analyte " + analyteName + " does not match the " + "DoubleBondsFromName" + " pattern \"" + RulesContainer.getDoubleBondsFromNamePattern(ruleName) + "\" of the class " + ruleName + "!");
            }
            int dbs = Integer.parseInt(dbsMatcher.group(1));
            if (cAtoms < cAtomsRange.getStart()) {
                cAtomsRange = new RangeInteger(cAtoms, cAtomsRange.getStop());
            }
            if (cAtoms > cAtomsRange.getStop()) {
                cAtomsRange = new RangeInteger(cAtomsRange.getStart(), cAtoms);
            }
            RangeInteger dbsRange = new RangeInteger(Integer.MAX_VALUE, 0);
            if (dbsRanges.containsKey(cAtoms)) {
                dbsRange = (RangeInteger)dbsRanges.get(cAtoms);
            }
            if (dbs < dbsRange.getStart()) {
                dbsRange = new RangeInteger(dbs, dbsRange.getStop());
            }
            if (dbs > dbsRange.getStop()) {
                dbsRange = new RangeInteger(dbsRange.getStart(), dbs);
            }
            dbsRanges.put(cAtoms, dbsRange);
            Hashtable<String, LipidParameterSet> hitsOfAnalyte = input.get(analyteName);
            for (String rt : hitsOfAnalyte.keySet()) {
                LipidParameterSet params = hitsOfAnalyte.get(rt);
                if (params.isSuitableForRtProcessingHit(className)) {
                    Hashtable<Object, Object> paramsSameC = new Hashtable();
                    if (msnOrdered.containsKey(cAtoms)) {
                        paramsSameC = msnOrdered.get(cAtoms);
                    }
                    Hashtable paramsSameDbs = new Hashtable();
                    if (paramsSameC.containsKey(dbs)) {
                        paramsSameDbs = (Hashtable)paramsSameC.get(dbs);
                    }
                    paramsSameDbs.put(rt, params);
                    paramsSameC.put(dbs, paramsSameDbs);
                    msnOrdered.put(cAtoms, paramsSameC);
                }
                Hashtable<Object, Object> unprocSameC = new Hashtable();
                if (allOrdered.containsKey(cAtoms)) {
                    unprocSameC = allOrdered.get(cAtoms);
                }
                Hashtable unprocSameDbs = new Hashtable();
                if (unprocSameC.containsKey(dbs)) {
                    unprocSameDbs = (Hashtable)unprocSameC.get(dbs);
                }
                unprocSameDbs.put(rt, params);
                unprocSameC.put(dbs, unprocSameDbs);
                allOrdered.put(cAtoms, unprocSameC);
            }
        }
        Vector<Object> results = new Vector<Object>();
        results.add(cAtomsRange);
        results.add(dbsRanges);
        return results;
    }

    private Vector checkForLMCounterModel(LevenbergMarquardtOptimizer optimizer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> negatives, Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> remainingNegatives, RangeInteger cAtomsRange, Hashtable<Integer, RangeInteger> dbsRanges, float tolerance, boolean respectOh) throws LMException {
        Vector<Object> result = null;
        Vector<Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>>> results = this.filterAdequateNegatives(optimizer, negatives, remainingNegatives, cAtomsRange, dbsRanges, tolerance);
        if (results != null) {
            try {
                Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> usables = results.get(0);
                Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> notUsed = results.get(1);
                LevenbergMarquardtOptimizer counterModel = this.optimizeLMModel(usables, null, respectOh);
                result = new Vector<Object>();
                result.add(counterModel);
                result.add(usables);
                result.add(notUsed);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private Vector<Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>>> filterAdequateNegatives(LevenbergMarquardtOptimizer optimizer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> negatives, Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> remainingNegatives, RangeInteger cAtomsRange, Hashtable<Integer, RangeInteger> dbsRanges, float tolerance) throws LMException {
        Vector<Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>>> results = new Vector<Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>>>();
        Hashtable negs = new Hashtable();
        Hashtable unusedNegs = new Hashtable();
        Hashtable diffs = new Hashtable();
        for (Integer cAtoms : remainingNegatives.keySet()) {
            Hashtable<Integer, Hashtable<String, LipidParameterSet>> sameC = new Hashtable();
            if (negatives.containsKey(cAtoms)) {
                sameC = negatives.get(cAtoms);
            }
            for (Integer dbs : remainingNegatives.get(cAtoms).keySet()) {
                Hashtable<Object, Object> sameDbs = new Hashtable();
                if (sameC.containsKey(dbs)) {
                    sameDbs = sameC.get(dbs);
                }
                for (String rt : remainingNegatives.get(cAtoms).get(dbs).keySet()) {
                    sameDbs.put(rt, remainingNegatives.get(cAtoms).get(dbs).get(rt));
                }
                sameC.put(dbs, sameDbs);
            }
            negatives.put(cAtoms, sameC);
        }
        int countPos = 0;
        int countNeg = 0;
        for (Integer cAt : negatives.keySet()) {
            Hashtable<Integer, Hashtable<String, LipidParameterSet>> sameC = negatives.get(cAt);
            if (!cAtomsRange.insideRange(cAt) || !dbsRanges.containsKey(cAt)) {
                unusedNegs.put(cAt, sameC);
                continue;
            }
            Hashtable sameCDiffs = new Hashtable();
            Hashtable<Integer, Hashtable<String, LipidParameterSet>> unusedSameC = new Hashtable<Integer, Hashtable<String, LipidParameterSet>>();
            RangeInteger dbsRange = dbsRanges.get(cAt);
            for (Integer dbs : sameC.keySet()) {
                Hashtable<String, LipidParameterSet> sameDbs = sameC.get(dbs);
                if (!dbsRange.insideRange(dbs)) {
                    unusedSameC.put(dbs, sameDbs);
                    continue;
                }
                Hashtable<String, Float> sameDbsDiffs = new Hashtable<String, Float>();
                for (String rt : sameDbs.keySet()) {
                    float[] input = new float[]{cAt.intValue(), dbs.intValue()};
                    float difference = this.getRtFromRtString(rt) - optimizer.calculateFitValue(input);
                    float tol = tolerance * optimizer.getMeanDeviation();
                    if (3.0f > tol) {
                        tol = 3.0f;
                    }
                    if (Math.abs(difference) > tol) continue;
                    sameDbsDiffs.put(rt, Float.valueOf(difference));
                    if (difference < 0.0f) {
                        ++countNeg;
                        continue;
                    }
                    ++countPos;
                }
                if (sameDbsDiffs.size() <= 0) continue;
                sameCDiffs.put(dbs, sameDbsDiffs);
            }
            if (sameCDiffs.size() > 0) {
                diffs.put(cAt, sameCDiffs);
            }
            if (unusedSameC.size() <= 0) continue;
            unusedNegs.put(cAt, unusedSameC);
        }
        if (countPos >= 3 * countNeg || countNeg >= 3 * countPos && countPos + countNeg >= 7) {
            boolean usePos = true;
            if (countNeg > countPos) {
                usePos = false;
            }
            for (Integer cAt : diffs.keySet()) {
                Hashtable sameC = new Hashtable();
                for (Integer dbs : ((Hashtable)diffs.get(cAt)).keySet()) {
                    Hashtable<String, LipidParameterSet> sameDbs = new Hashtable<String, LipidParameterSet>();
                    for (String rt : ((Hashtable)((Hashtable)diffs.get(cAt)).get(dbs)).keySet()) {
                        float diff = ((Float)((Hashtable)((Hashtable)diffs.get(cAt)).get(dbs)).get(rt)).floatValue();
                        if (!(diff > 0.0f && usePos) && (!(diff < 0.0f) || usePos)) continue;
                        sameDbs.put(rt, negatives.get(cAt).get(dbs).get(rt));
                    }
                    if (sameDbs.size() <= 0) continue;
                    sameC.put(dbs, sameDbs);
                }
                if (sameC.size() <= 0) continue;
                negs.put(cAt, sameC);
            }
        } else {
            return null;
        }
        results.add(negs);
        results.add(unusedNegs);
        return results;
    }

    public static boolean fallsOnCounterModelSide(String className, String modName, String analyteName, String rtString, LevenbergMarquardtOptimizer model, LevenbergMarquardtOptimizer counterModel) throws RulesException, NoRuleException, IOException, SpectrummillParserException, LMException {
        String ruleName = StaticUtils.getRuleName(className, modName);
        Pattern cAtomsPattern = Pattern.compile(RulesContainer.getCAtomsFromNamePattern(ruleName));
        Pattern dbsPattern = Pattern.compile(RulesContainer.getDoubleBondsFromNamePattern(ruleName));
        Matcher cAtomsMatcher = cAtomsPattern.matcher(analyteName.split(";")[0]);
        if (!cAtomsMatcher.matches()) {
            throw new RulesException("The analyte " + analyteName + " does not match the " + "CAtomsFromName" + " pattern \"" + RulesContainer.getCAtomsFromNamePattern(ruleName) + "\" of the class " + ruleName + "!");
        }
        Matcher dbsMatcher = dbsPattern.matcher(analyteName.split(";")[0]);
        int cAtoms = Integer.parseInt(cAtomsMatcher.group(1));
        if (!dbsMatcher.matches()) {
            throw new RulesException("The analyte " + analyteName + " does not match the " + "DoubleBondsFromName" + " pattern \"" + RulesContainer.getDoubleBondsFromNamePattern(ruleName) + "\" of the class " + ruleName + "!");
        }
        int dbs = Integer.parseInt(dbsMatcher.group(1));
        float rt = Float.valueOf(rtString).floatValue();
        float[] cAndDbs = new float[]{cAtoms, dbs};
        float fitRt = model.calculateFitValue(cAndDbs);
        float counterRt = Float.NaN;
        if (counterModel != null) {
            counterRt = counterModel.calculateFitValue(cAndDbs);
        }
        return PostQuantificationProcessor.fallsOnCounterModelSide(rt, fitRt, counterRt);
    }

    private static boolean fallsOnCounterModelSide(float rt, float fitRt, float counterRt) {
        boolean onCounterSide = false;
        float percentToCount = 0.2f;
        if (!Float.isNaN(counterRt)) {
            if (fitRt < counterRt) {
                if (rt > counterRt || rt > counterRt - (counterRt - fitRt) * percentToCount) {
                    onCounterSide = true;
                }
            } else if (rt < counterRt || rt < counterRt + (fitRt - counterRt) * percentToCount) {
                onCounterSide = true;
            }
        }
        return onCounterSide;
    }

    private Vector<LevenbergMarquardtOptimizer> evaluateFilterAgainBasedOnCounterModel(Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> currentHits, Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> negatives, LevenbergMarquardtOptimizer model, LevenbergMarquardtOptimizer counter, boolean respectOh) throws LMException {
        int countNegatives = 0;
        Vector<LevenbergMarquardtOptimizer> models = new Vector<LevenbergMarquardtOptimizer>();
        Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>> forModel = new Hashtable<Integer, Hashtable<Integer, Hashtable<String, LipidParameterSet>>>();
        for (Integer cAtoms : currentHits.keySet()) {
            Hashtable newSameC = new Hashtable();
            Hashtable<Object, Object> negSameC = new Hashtable();
            if (negatives.containsKey(cAtoms)) {
                negSameC = negatives.get(cAtoms);
            }
            for (Integer dbs : currentHits.get(cAtoms).keySet()) {
                Hashtable<String, LipidParameterSet> newSameDbs = new Hashtable<String, LipidParameterSet>();
                Hashtable negSameDbs = new Hashtable();
                if (negSameC.containsKey(dbs)) {
                    negSameDbs = (Hashtable)negSameC.get(dbs);
                }
                for (String rtString : currentHits.get(cAtoms).get(dbs).keySet()) {
                    if (negatives.containsKey(cAtoms) && negatives.get(cAtoms).containsKey(dbs) && negatives.get(cAtoms).get(dbs).containsKey(rtString)) break;
                    float rt = this.getRtFromRtString(rtString);
                    float[] cAndDbs = new float[]{cAtoms.intValue(), dbs.intValue()};
                    float fitRt = model.calculateFitValue(cAndDbs);
                    float counterRt = Float.NaN;
                    if (counter != null) {
                        counterRt = counter.calculateFitValue(cAndDbs);
                    }
                    if (PostQuantificationProcessor.fallsOnCounterModelSide(rt, fitRt, counterRt)) {
                        negSameDbs.put(rtString, currentHits.get(cAtoms).get(dbs).get(rtString));
                        ++countNegatives;
                        continue;
                    }
                    newSameDbs.put(rtString, currentHits.get(cAtoms).get(dbs).get(rtString));
                }
                if (newSameDbs.size() > 0) {
                    newSameC.put(dbs, newSameDbs);
                }
                if (negSameDbs.size() <= 0) continue;
                negSameC.put(dbs, negSameDbs);
            }
            if (newSameC.size() > 0) {
                forModel.put(cAtoms, newSameC);
            }
            if (negSameC.size() <= 0) continue;
            negatives.put(cAtoms, negSameC);
        }
        if (countNegatives > 0) {
            LevenbergMarquardtOptimizer newModel = this.optimizeLMModel(forModel, null, respectOh);
            LevenbergMarquardtOptimizer newCounterModel = this.optimizeLMModel(negatives, null, respectOh);
            models.add(newModel);
            models.add(newCounterModel);
            models.add((LevenbergMarquardtOptimizer)((Object)negatives));
            return models;
        }
        models.add(model);
        models.add(counter);
        models.add((LevenbergMarquardtOptimizer)((Object)negatives));
        return models;
    }

    private float getRtFromRtString(String rtString) {
        String rt = new String(rtString);
        if (rt.indexOf("_") != -1) {
            rt = rt.substring(0, rt.indexOf("_"));
        }
        return Float.valueOf(rt).floatValue();
    }

    private float extractMinimumAcceptedDeviationValue(String className, Hashtable<String, Hashtable<String, LipidParameterSet>> data) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        Vector<Float> peakWidths = new Vector<Float>();
        for (Hashtable<String, LipidParameterSet> sameAnal : data.values()) {
            for (LipidParameterSet set : sameAnal.values()) {
                Vector<Vector<CgProbe>> probes;
                if (!set.isSuitableForRtProcessingHit(className) || (probes = set.getIsotopicProbes()).size() == 0) continue;
                for (CgProbe probe : probes.get(0)) {
                    peakWidths.add(Float.valueOf((probe.UpperValley - probe.LowerValley) / 60.0f));
                }
            }
        }
        float minDev = 0.0f;
        if (peakWidths.size() > 0) {
            minDev = Calculator.median(peakWidths).floatValue() / 2.0f;
        }
        return minDev;
    }

    public Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> chooseMoreLikelyOne(Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects) throws RulesException, NoRuleException, IOException, SpectrummillParserException, LMException {
        HashSet<String> affectedClasses = new HashSet<String>();
        HashSet<String> affectedMods = new HashSet<String>();
        Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> undecidedHits = new Hashtable<QuantVO, Hashtable<String, LipidParameterSet>>();
        Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> unprocessed = new Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>>();
        for (String aClass : this.results_.keySet()) {
            for (String anal : this.results_.get(aClass).keySet()) {
                for (String mod : this.results_.get(aClass).get(anal).keySet()) {
                    for (String rt : this.results_.get(aClass).get(anal).get(mod).keySet()) {
                        LipidParameterSet set = this.results_.get(aClass).get(anal).get(mod).get(rt);
                        if (!set.isChoseMoreLikelyRtWhenEqualMSn()) continue;
                        affectedClasses.add(aClass);
                        affectedMods.add(StaticUtils.getRuleName(aClass, set.getModificationName()));
                        QuantVO quant = quantObjects.get(aClass).get(anal).get(mod);
                        if (!undecidedHits.containsKey(quant)) {
                            undecidedHits.put(quant, new Hashtable());
                        }
                        undecidedHits.get(quant).put(rt, set);
                    }
                }
            }
        }
        for (String aClass : this.results_.keySet()) {
            if (!affectedClasses.contains(aClass)) continue;
            unprocessed.put(aClass, this.results_.get(aClass));
        }
        this.correctByRetentionTimeSeries(unprocessed, this.ms2Removed_, this.adductInsensitiveRtFilter_);
        Vector<SharedMS1PeakVO> sharedPeaks = MSnPeakSeparator.detectSharedMS1PeakInstances(undecidedHits);
        Hashtable<String, LipidParameterSet> toRemove = new Hashtable<String, LipidParameterSet>();
        for (SharedMS1PeakVO shared : sharedPeaks) {
            if (shared.getPartners().size() < 2 || shared.hasAnyPartnerDistinctFragments() || !shared.haveAllChooseOnRtSetToTrue()) continue;
            boolean forAllModelsFound = true;
            float smallestDiff = Float.MAX_VALUE;
            String correct = null;
            for (SharedPeakContributionVO contr : shared.getPartners()) {
                LevenbergMarquardtOptimizer predictedModel = null;
                boolean respectOh = false;
                String ruleName = StaticUtils.getRuleName(contr.getQuantVO().getAnalyteClass(), contr.getQuantVO().getModName());
                if (this.adductInsensitiveRtFilter_.get(contr.getQuantVO().getAnalyteClass()).booleanValue()) {
                    if (this.predictedModels_.containsKey(contr.getQuantVO().getAnalyteClass())) {
                        predictedModel = this.predictedModels_.get(contr.getQuantVO().getAnalyteClass());
                        respectOh = this.respectOhs_.get(contr.getQuantVO().getAnalyteClass());
                    }
                } else if (this.predictedModels_.containsKey(ruleName)) {
                    predictedModel = this.predictedModels_.get(ruleName);
                    respectOh = this.respectOhs_.get(ruleName);
                }
                if (predictedModel == null) {
                    forAllModelsFound = false;
                    break;
                }
                Pattern cAtomsPattern = Pattern.compile(RulesContainer.getCAtomsFromNamePattern(ruleName));
                Pattern dbsPattern = Pattern.compile(RulesContainer.getDoubleBondsFromNamePattern(ruleName));
                Matcher cAtomsMatcher = cAtomsPattern.matcher(contr.getQuantVO().getIdString().split(";")[0]);
                if (!cAtomsMatcher.matches()) {
                    throw new RulesException("The analyte " + contr.getQuantVO().getIdString() + " does not match the " + "CAtomsFromName" + " pattern \"" + RulesContainer.getCAtomsFromNamePattern(ruleName) + "\" of the class " + ruleName + "!");
                }
                int cAtoms = Integer.parseInt(cAtomsMatcher.group(1));
                Matcher dbsMatcher = dbsPattern.matcher(contr.getQuantVO().getIdString().split(";")[0]);
                if (!dbsMatcher.matches()) {
                    throw new RulesException("The analyte " + contr.getQuantVO().getIdString() + " does not match the " + "DoubleBondsFromName" + " pattern \"" + RulesContainer.getDoubleBondsFromNamePattern(ruleName) + "\" of the class " + ruleName + "!");
                }
                int dbs = Integer.parseInt(dbsMatcher.group(1));
                float[] cAndDbs = new float[2];
                if (respectOh) {
                    cAndDbs = new float[3];
                }
                cAndDbs[0] = cAtoms;
                cAndDbs[1] = dbs;
                if (respectOh) {
                    cAndDbs[2] = contr.getSet().getOhNumber().intValue();
                }
                float fitRt = predictedModel.calculateFitValue(cAndDbs);
                float rt = Float.parseFloat(contr.getSet().getRt());
                float rtDiff = Math.abs(rt - fitRt);
                if (!(rtDiff < smallestDiff)) continue;
                correct = OtherAdductChecker.getUniqueId(contr.getQuantVO().getAnalyteClass(), contr.getQuantVO().getIdString(), contr.getQuantVO().getModName(), contr.getSet().getRt());
            }
            if (!forAllModelsFound) continue;
            for (SharedPeakContributionVO contr : shared.getPartners()) {
                String idi = OtherAdductChecker.getUniqueId(contr.getQuantVO().getAnalyteClass(), contr.getQuantVO().getIdString(), contr.getQuantVO().getModName(), contr.getSet().getRt());
                if (!correct.equalsIgnoreCase(idi)) {
                    toRemove.put(idi, contr.getSet());
                    continue;
                }
                contr.getSet().setPercentalSplit(100.0f);
            }
        }
        for (String id : toRemove.keySet()) {
            Vector<String> params = OtherAdductChecker.getParamsFromId(id);
            this.results_.get(params.get(0)).get(params.get(1)).get(params.get(2)).remove(params.get(3));
        }
        return this.results_;
    }
}

