/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn.vos;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.msn.vos.IntensityRuleVO;
import java.util.Hashtable;
import java.util.Vector;

public class MSnDebugVO {
    public static final int UNKNOWN_REASON = 0;
    public static final int NO_PEAK_THERE = 1;
    public static final int BELOW_BASE_PEAK_CUTOFF = 2;
    public static final int NO_CHAIN_COMINATION_POSSIBLE = 3;
    public static final int COMBINATION_LOWER_CHAIN_CUTOFF = 4;
    public static final String ID_COMBI_REMOVE = "COMBINATION";
    private int status_;
    private Hashtable<String, Integer> headGroupStatuses_ = new Hashtable();
    private Hashtable<String, IntensityRuleVO> violatedHeadRules_ = new Hashtable();
    private Hashtable<String, Hashtable<String, Object>> violatedChainRules_ = new Hashtable();
    private Hashtable<String, Integer> violatedCombinations_ = new Hashtable();
    private Hashtable<String, Hashtable<String, IntensityRuleVO>> unfulfilledPositionRules_ = new Hashtable();
    private Hashtable<String, Vector<Vector<IntensityRuleVO>>> contradictingPositionRules_ = new Hashtable();
    private boolean spectrumCoverageFulfilled_ = false;

    public int getStatus() {
        return this.status_;
    }

    public void setStatus(int status) {
        this.status_ = status;
    }

    public void addDiscardedHeadGroupFragment(String name, int status) {
        this.headGroupStatuses_.put(name, status);
    }

    public Hashtable<String, Integer> getDiscardedHeadGroupFragments() {
        return this.headGroupStatuses_;
    }

    public void addViolatedHeadRule(IntensityRuleVO ruleVO) throws LipidCombinameEncodingException {
        this.violatedHeadRules_.put(ruleVO.getReadableRuleInterpretation(Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding()), ruleVO);
    }

    public Hashtable<String, IntensityRuleVO> getViolatedHeadRules() {
        return this.violatedHeadRules_;
    }

    public void addViolatedChainFragment(String faName, String fragmentName, int status) {
        Hashtable<String, Object> violatedRules = new Hashtable<String, Integer>();
        if (this.violatedChainRules_.containsKey(faName)) {
            violatedRules = this.violatedChainRules_.get(faName);
        }
        violatedRules.put(fragmentName, status);
        this.violatedChainRules_.put(faName, violatedRules);
    }

    public void addViolatedChainRule(String faName, IntensityRuleVO ruleVO) {
        Hashtable<String, Object> violatedRules = new Hashtable<String, IntensityRuleVO>();
        if (this.violatedChainRules_.containsKey(faName)) {
            violatedRules = this.violatedChainRules_.get(faName);
        }
        violatedRules.put(ruleVO.getRuleIdentifier(), ruleVO);
        this.violatedChainRules_.put(faName, violatedRules);
    }

    public void addViolatedCombinations(String combiName, int status) {
        this.violatedCombinations_.put(combiName, status);
    }

    public Hashtable<String, Hashtable<String, Object>> getViolatedChainRules() {
        return this.violatedChainRules_;
    }

    public Hashtable<String, Integer> getViolatedCombinations() {
        return this.violatedCombinations_;
    }

    public boolean isSpectrumCoverageFulfilled() {
        return this.spectrumCoverageFulfilled_;
    }

    public void setSpectrumCoverageFulfilled(boolean spectrumCoverageFulfilled) {
        this.spectrumCoverageFulfilled_ = spectrumCoverageFulfilled;
    }

    public void addUnfulfilledPositionRule(String combiName, IntensityRuleVO ruleVO) {
        Hashtable<String, IntensityRuleVO> unfulfilled = new Hashtable<String, IntensityRuleVO>();
        if (this.unfulfilledPositionRules_.containsKey(combiName)) {
            unfulfilled = this.unfulfilledPositionRules_.get(combiName);
        }
        unfulfilled.put(ruleVO.getRuleIdentifier(), ruleVO);
        this.unfulfilledPositionRules_.put(combiName, unfulfilled);
    }

    public void addContradictingPositionRules(String combiName, IntensityRuleVO firstRule, IntensityRuleVO secondRule) {
        Vector<Object> rules = new Vector();
        if (this.contradictingPositionRules_.containsKey(combiName)) {
            rules = this.contradictingPositionRules_.get(combiName);
        }
        Vector<IntensityRuleVO> rulePair = new Vector<IntensityRuleVO>();
        rulePair.add(firstRule);
        rulePair.add(secondRule);
        rules.add(rulePair);
        this.contradictingPositionRules_.put(combiName, rules);
    }

    public Hashtable<String, Vector<Vector<IntensityRuleVO>>> getContradictingPositionRules() {
        return this.contradictingPositionRules_;
    }

    public Hashtable<String, Hashtable<String, IntensityRuleVO>> getUnfulfilledPositionRules() {
        return this.unfulfilledPositionRules_;
    }
}

