/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn.vos;

import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.vos.FragmentMultVO;
import at.tugraz.genome.lda.msn.vos.RuleHydroxyRequirementsVO;
import java.util.HashSet;
import java.util.Objects;
import java.util.Vector;

public class RuleHydroxyRequirementSet {
    private Vector<RuleHydroxyRequirementsVO> requirements_;

    public RuleHydroxyRequirementSet(Vector<RuleHydroxyRequirementsVO> requirements) {
        this.requirements_ = requirements;
    }

    public void setUndefinedMandatorySettings(short mandatory) {
        for (RuleHydroxyRequirementsVO req : this.requirements_) {
            if (req.getMandatory() != -1) continue;
            req.setMandatory(mandatory);
        }
    }

    public boolean hasEntry(short ohNumber) {
        for (RuleHydroxyRequirementsVO req : this.requirements_) {
            if (req.getOh() != ohNumber) continue;
            return true;
        }
        return false;
    }

    public short getMandatory(short chainType, short ohNumber) {
        short mand = -1;
        Vector<RuleHydroxyRequirementsVO> reqs = this.getEntry(ohNumber);
        for (RuleHydroxyRequirementsVO req : reqs) {
            if (req.getChainType() != chainType) continue;
            mand = req.getMandatory();
        }
        return mand;
    }

    public Vector<RuleHydroxyRequirementsVO> getEntry(short ohNumber) {
        Vector<RuleHydroxyRequirementsVO> reqs = new Vector<RuleHydroxyRequirementsVO>();
        for (RuleHydroxyRequirementsVO req : this.requirements_) {
            if (req.getOh() != ohNumber) continue;
            reqs.add(req);
        }
        return reqs;
    }

    public void checkAndCorrectChainTypes(short ruleChainType, Vector<FragmentMultVO> allFrags, int lineNumber, boolean headSection) throws RulesException {
        if (headSection) {
            return;
        }
        if (ruleChainType != -1) {
            for (RuleHydroxyRequirementsVO vo : this.requirements_) {
                if (vo.getChainType() == -1) {
                    vo.setChainType(ruleChainType);
                    continue;
                }
                if (vo.getChainType() == ruleChainType) continue;
                throw new RulesException("The set chain type for the \"oh\" setting is not possible for this intensity rule! Error at line number " + lineNumber + "!");
            }
        } else {
            boolean hasLcbChain = false;
            HashSet<Short> availableChainTypes = new HashSet<Short>();
            for (FragmentMultVO frag : allFrags) {
                availableChainTypes.add(frag.getFragmentType());
            }
            if (availableChainTypes.contains((short)3)) {
                hasLcbChain = true;
            }
            for (RuleHydroxyRequirementsVO vo : this.requirements_) {
                if (vo.chainType_ == -1) {
                    if (hasLcbChain) {
                        vo.setChainType((short)3);
                        continue;
                    }
                    throw new RulesException("For \"oh\", when there are more fragment types are present, but no $LCB is set, the chain type as to be specified (consult manual)! Error at line: " + lineNumber + "!");
                }
                if (availableChainTypes.contains(vo.getChainType())) continue;
                throw new RulesException("The set chain type for the \"oh\" setting is not possible for this intensity rule! Error at line number " + lineNumber + "!");
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleHydroxyRequirementSet other = (RuleHydroxyRequirementSet)obj;
        return Objects.equals(this.requirements_, other.requirements_);
    }
}

