/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.mztab;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.analysis.ComparativeAnalysis;
import at.tugraz.genome.lda.exception.ExportException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.RetentionTimeGroupingException;
import at.tugraz.genome.lda.export.LDAExporter;
import at.tugraz.genome.lda.export.vos.EvidenceVO;
import at.tugraz.genome.lda.export.vos.FeatureVO;
import at.tugraz.genome.lda.export.vos.SpeciesExportVO;
import at.tugraz.genome.lda.export.vos.SummaryVO;
import at.tugraz.genome.lda.msn.hydroxy.parser.HydroxyEncoding;
import at.tugraz.genome.lda.mztab.SmallMztabMolecule;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.QuantificationResult;
import at.tugraz.genome.lda.vos.ResultAreaVO;
import at.tugraz.genome.lda.vos.ResultCompVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import de.isas.mztab2.model.MsRun;
import de.isas.mztab2.model.OptColumnMapping;
import de.isas.mztab2.model.Parameter;
import de.isas.mztab2.model.SmallMoleculeEvidence;
import de.isas.mztab2.model.SmallMoleculeFeature;
import de.isas.mztab2.model.SmallMoleculeSummary;
import de.isas.mztab2.model.SpectraRef;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;

public class MztabUtils
extends LDAExporter {
    private static final Parameter BEST_CONFID_MEASURE = new Parameter().cvLabel("MS").cvAccession("MS:1002890").name("fragmentation score");

    public static SmallMztabMolecule createSmallMztabMolecule(short speciesType, boolean exportDoubleBondPositionsForClass, int currentSummaryId, int currentFeatureId, int currentEvidenceId, int currentEvGroupingId, int maxIsotopes, ComparativeAnalysis analysisModule, Hashtable<String, MsRun> msruns, Hashtable<String, QuantificationResult> originalExcelResults, String molGroup, String molName, Hashtable<String, Vector<Double>> resultsMol, LinkedHashMap<String, Boolean> adductsSorted, LinkedHashMap<String, Vector<String>> expsOfGroup, HydroxyEncoding faHydroxyEncoding, HydroxyEncoding lcbHydroxyEncoding) throws ExportException, SpectrummillParserException, LipidCombinameEncodingException, RetentionTimeGroupingException {
        Hashtable<String, String> modFormulas = new Hashtable<String, String>();
        Hashtable<String, Integer> modCharges = new Hashtable<String, Integer>();
        Hashtable<String, Double> calcMasses = new Hashtable<String, Double>();
        Hashtable<String, Hashtable<String, Vector<LipidParameterSet>>> relevantOriginals = new Hashtable<String, Hashtable<String, Vector<LipidParameterSet>>>();
        ResultCompVO comp = analysisModule.getResults().get(molGroup).get(molName).values().iterator().next();
        int isotopes = comp.getAvailableIsotopeNr(maxIsotopes);
        boolean isRtGrouped = analysisModule.isRtGrouped();
        Parameter identificationMethod = new Parameter().name("LipidDataAnalyzer").value("2.10.0_1");
        for (String expName : analysisModule.getExpNamesInSequence()) {
            ResultAreaVO areaVO = analysisModule.getResultAreaVO(molGroup, molName, expName);
            if (areaVO == null) continue;
            if (areaVO.isAStandard()) {
                isRtGrouped = false;
            }
            Hashtable<String, Vector<LipidParameterSet>> sets = MztabUtils.getRelevantOriginalResults(originalExcelResults.get(expName).getIdentifications().get(molGroup), areaVO, false);
            relevantOriginals.put(expName, sets);
            for (String string : adductsSorted.keySet()) {
                if (modFormulas.containsKey(string) || !areaVO.hasModification(string)) continue;
                modFormulas.put(string, areaVO.getModificationFormula(string));
                modCharges.put(string, areaVO.getCharge(string));
                calcMasses.put(string, areaVO.getTheoreticalMass(string));
            }
        }
        SpeciesExportVO exportVO = LDAExporter.extractExportableSummaryInformation(speciesType, exportDoubleBondPositionsForClass, true, currentSummaryId, currentFeatureId, true, currentEvidenceId, currentEvGroupingId, isRtGrouped, adductsSorted, analysisModule.getExpNamesInSequence(), expsOfGroup, molName, resultsMol, relevantOriginals, isotopes, faHydroxyEncoding, lcbHydroxyEncoding);
        Vector<SmallMoleculeSummary> summaries = new Vector<SmallMoleculeSummary>();
        Vector<String> dbIdentifiers = null;
        Vector<String> chemicalNames = null;
        for (SummaryVO vo : exportVO.getSummaries()) {
            Iterator<FeatureVO> summary = new SmallMoleculeSummary();
            ((SmallMoleculeSummary)((Object)summary)).setSmlId(vo.getId());
            ((SmallMoleculeSummary)((Object)summary)).setSmfIdRefs(vo.getFeatureRefs());
            dbIdentifiers = new Vector<String>();
            dbIdentifiers.add("lda2:" + molGroup + " " + (isRtGrouped ? vo.getSpeciesId().substring(0, vo.getSpeciesId().lastIndexOf("_")) : vo.getSpeciesId()));
            ((SmallMoleculeSummary)((Object)summary)).setDatabaseIdentifier(dbIdentifiers);
            ArrayList<String> chemFormula = new ArrayList<String>();
            chemFormula.add(vo.getChemFormula());
            ((SmallMoleculeSummary)((Object)summary)).setChemicalFormula(chemFormula);
            chemicalNames = new Vector<String>();
            String bestId = molGroup + " ";
            bestId = bestId + (vo.getMolecularId() != null ? vo.getMolecularId() : (isRtGrouped ? vo.getSpeciesId().substring(0, vo.getSpeciesId().lastIndexOf("_")) : vo.getSpeciesId()));
            chemicalNames.add(bestId);
            ((SmallMoleculeSummary)((Object)summary)).setChemicalName(chemicalNames);
            Vector<Double> neutralMasses = new Vector<Double>();
            neutralMasses.add(vo.getNeutralMass());
            ((SmallMoleculeSummary)((Object)summary)).setTheoreticalNeutralMass(neutralMasses);
            ArrayList<String> adducts = new ArrayList<String>();
            for (String string : vo.getModifications()) {
                String mztabAdduct = LipidomicsConstants.getMzTabAdduct(string) != null ? LipidomicsConstants.getMzTabAdduct(string) : string;
                adducts.add(mztabAdduct);
            }
            ((SmallMoleculeSummary)((Object)summary)).setAdductIons(adducts);
            ((SmallMoleculeSummary)((Object)summary)).setReliability(String.valueOf(vo.getMzTabReliability()));
            ((SmallMoleculeSummary)((Object)summary)).setBestIdConfidenceMeasure(BEST_CONFID_MEASURE);
            ArrayList<Double> abundanceAssay = new ArrayList<Double>();
            for (String expName : analysisModule.getExpNamesInSequence()) {
                Double smlArea = vo.getArea(expName);
                abundanceAssay.add(smlArea > 0.0 ? vo.getArea(expName) : null);
            }
            ((SmallMoleculeSummary)((Object)summary)).setAbundanceAssay(abundanceAssay);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<Double> abundanceCoeffvarStudyVariable = new ArrayList<Double>();
            for (String group : expsOfGroup.keySet()) {
                arrayList.add(vo.getMeanArea(group));
                abundanceCoeffvarStudyVariable.add(vo.getCoeffVar(group));
            }
            ((SmallMoleculeSummary)((Object)summary)).setAbundanceStudyVariable(arrayList);
            ((SmallMoleculeSummary)((Object)summary)).setAbundanceVariationStudyVariable(abundanceCoeffvarStudyVariable);
            ArrayList optList = new ArrayList();
            optList.add(new OptColumnMapping().identifier("global_lipid_species").value(molGroup + " " + (isRtGrouped ? vo.getSpeciesId().substring(0, vo.getSpeciesId().lastIndexOf("_")) : vo.getSpeciesId())));
            if (isRtGrouped) {
                optList.add(new OptColumnMapping().identifier("global_lipid_lda_species").value(molGroup + " " + vo.getSpeciesId()));
            }
            ((SmallMoleculeSummary)((Object)summary)).setOpt(optList);
            summaries.add((SmallMoleculeSummary)((Object)summary));
        }
        Vector<SmallMoleculeFeature> vector = new Vector<SmallMoleculeFeature>();
        Hashtable<String, Short> polarities = new Hashtable<String, Short>();
        for (String expName : analysisModule.getExpNamesInSequence()) {
            polarities.put(expName, (short)0);
        }
        if (exportVO.getFeatures() != null) {
            for (FeatureVO vo : exportVO.getFeatures()) {
                SmallMoleculeFeature feature = new SmallMoleculeFeature();
                feature.setSmfId(vo.getId());
                if (vo.getEvidenceRefs().size() > 0) {
                    feature.setSmeIdRefs(vo.getEvidenceRefs());
                }
                if (vo.getEvidenceRefs().size() > 1) {
                    feature.setSmeIdRefAmbiguityCode(2);
                }
                String mztabAdduct = LipidomicsConstants.getMzTabAdduct(vo.getAdduct()) != null ? LipidomicsConstants.getMzTabAdduct(vo.getAdduct()) : vo.getAdduct();
                feature.setAdductIon(mztabAdduct);
                feature.setExpMassToCharge(vo.getExpMz());
                int charge = vo.getCharge();
                if (mztabAdduct.endsWith("-")) {
                    charge *= -1;
                }
                feature.setCharge(charge);
                feature.setRetentionTimeInSeconds(vo.getRtApex());
                feature.setRetentionTimeInSecondsStart(vo.getRtStart());
                feature.setRetentionTimeInSecondsEnd(vo.getRtEnd());
                feature.setAbundanceAssay(new ArrayList<Double>(vo.getAreas()));
                for (int i = 0; i != analysisModule.getExpNamesInSequence().size(); ++i) {
                    int polarity = 0;
                    if (vo.getAreas().get(i) == null) continue;
                    String string = analysisModule.getExpNamesInSequence().get(i);
                    if (mztabAdduct.endsWith("+")) {
                        polarity = polarities.get(string) == 2 ? 3 : 1;
                    } else if (mztabAdduct.endsWith("-")) {
                        polarity = polarities.get(string) == 1 ? 3 : 2;
                    }
                    polarities.put(string, (short)polarity);
                }
                vector.add(feature);
            }
        }
        Vector<SmallMoleculeEvidence> evidences = new Vector<SmallMoleculeEvidence>();
        String dbId = null;
        if (exportVO.getEvidence() != null) {
            for (EvidenceVO vo : exportVO.getEvidence()) {
                SmallMoleculeEvidence evidence = new SmallMoleculeEvidence();
                evidence.setSmeId(vo.getId());
                evidence.setEvidenceInputId(String.valueOf(vo.getEvidenceGroupingId()));
                String speciesName = molGroup + " " + (isRtGrouped ? vo.getSpeciesId().substring(0, vo.getSpeciesId().lastIndexOf("_")) : vo.getSpeciesId());
                dbId = "lda2:" + speciesName;
                evidence.setDatabaseIdentifier(dbId);
                evidence.setChemicalFormula(vo.getChemFormula());
                evidence.setChemicalName(vo.getLdaStructure() == null ? speciesName : molGroup + " " + vo.getLdaStructure().replaceAll(" \\| ", " | " + molGroup + " "));
                String mztabAdduct = LipidomicsConstants.getMzTabAdduct(vo.getModification()) != null ? LipidomicsConstants.getMzTabAdduct(vo.getModification()) : vo.getModification();
                evidence.setAdductIon(mztabAdduct);
                evidence.setExpMassToCharge(vo.getExpMz());
                int n = vo.getCharge();
                if (mztabAdduct.endsWith("-")) {
                    n *= -1;
                }
                evidence.setCharge(n);
                evidence.setTheoreticalMassToCharge(vo.getTheorMz());
                evidence.setIdentificationMethod(identificationMethod);
                evidence.setMsLevel(new Parameter().cvLabel("MS").cvAccession("MS:1000511").name("ms level").value(String.valueOf(vo.getMsLevel())));
                ArrayList<SpectraRef> spectraNrs = new ArrayList<SpectraRef>();
                for (Integer scanNr : vo.getScanNrs()) {
                    spectraNrs.add(new SpectraRef().msRun(msruns.get(vo.getExpName())).reference("scan=" + scanNr.toString()));
                }
                evidence.setSpectraRef(spectraNrs);
                ArrayList<Double> confidenceMeasures = new ArrayList<Double>();
                confidenceMeasures.add(null);
                evidence.setIdConfidenceMeasure(confidenceMeasures);
                evidence.setRank(1);
                ArrayList<OptColumnMapping> optList = new ArrayList<OptColumnMapping>();
                optList.add(new OptColumnMapping().identifier("global_lipid_species").value(molGroup + " " + (isRtGrouped ? vo.getSpeciesId().substring(0, vo.getSpeciesId().lastIndexOf("_")) : vo.getSpeciesId())));
                if (isRtGrouped) {
                    optList.add(new OptColumnMapping().identifier("global_lipid_lda_species").value(molGroup + " " + vo.getSpeciesId()));
                }
                evidence.setOpt(optList);
                evidences.add(evidence);
            }
        }
        SmallMztabMolecule result = new SmallMztabMolecule(exportVO.getCurrentSummaryId(), polarities, summaries, exportVO.getCurrentFeatureId(), vector, exportVO.getCurrentEvidenceId(), exportVO.getCurrentEvGroupingId(), evidences);
        return result;
    }
}

