/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.quantification;

import at.tugraz.genome.lda.quantification.LipidomicsAnalyzer;
import at.tugraz.genome.lda.quantification.LipidomicsDefines;
import at.tugraz.genome.lda.quantification.SavGolJNI;
import at.tugraz.genome.maspectras.quantification.CgChromatogram;
import at.tugraz.genome.maspectras.utils.Calculator;

public class LipidomicsChromatogram
extends CgChromatogram {
    private boolean greedyFragment_ = false;
    private int loSteepnessPoint_;
    private int upSteepnessPoint_;
    public float greedySteepnessChange1_ = 1.5f;
    public float greedySteepnessChange2_ = 1.8f;
    public float greedyIntensityCutoff1_ = 0.15f;
    public float greedyIntensityCutoff2_ = 0.2f;
    public float intensityCutoff_ = 0.0f;

    public LipidomicsChromatogram(int size) {
        super(size);
    }

    public LipidomicsChromatogram(CgChromatogram cgc) {
        this(cgc.Value.length);
        this.LowerMzBand = cgc.LowerMzBand;
        this.Mz = cgc.Mz;
        this.UpperMzBand = cgc.UpperMzBand;
        this.ScanCount = cgc.ScanCount;
        this.Value = (float[][])cgc.Value.clone();
        this.LoValley = cgc.LoValley;
        this.Peak = cgc.Peak;
        this.UpValley = cgc.UpValley;
        this.PeakTime = cgc.PeakTime;
        this.PeakTimeAverage = cgc.PeakTimeAverage;
        this.Background = cgc.Background;
        this.Area = cgc.Area;
        this.AreaErr = cgc.AreaErr;
        this.Good = cgc.Good;
        this.m_peakValue = cgc.getM_peakValue();
        this.m_average = cgc.getM_average();
        this.startPosition_ = cgc.getStartPosition();
        this.isProfile_ = cgc.isProfile_;
        this.highestIntensity_ = cgc.getHighestIntensity();
        this.startSmoothScan_ = cgc.startSmoothScan_;
        this.stopSmoothScan_ = cgc.stopSmoothScan_;
    }

    @Override
    public void FindPeak(int position, int direction, int valleyMethod) {
        this.greedyFragment_ = false;
        this.loSteepnessPoint_ = -1;
        this.upSteepnessPoint_ = -1;
        super.FindPeak(position, direction, valleyMethod);
    }

    @Override
    protected void GetValleys(int method) {
        if (method == LipidomicsDefines.StandardValleyMethod) {
            this.GetValleysOriginal();
        } else if (method == LipidomicsDefines.EnhancedValleyMethod) {
            this.GetValleysEnhanced(true);
        } else if (method == LipidomicsDefines.GreedySteepnessReductionMethod) {
            this.GetValleysGreedy();
        } else if (method == LipidomicsDefines.GreedySteepnessPoint) {
            this.GetValleysGreedySteepnessPoint();
        } else if (method == LipidomicsDefines.GreedySteepnessImproved) {
            this.GetValleysGreedyImproved();
        } else if (method == LipidomicsDefines.GreedySteepnessPointImproved) {
            this.GetValleysGreedySteepnessPointImproved();
        } else {
            this.GetValleysOriginal();
        }
    }

    public void Smooth(float range, int repeats, boolean copyRawDataFirst, SavGolJNI sav_gol) {
        if (copyRawDataFirst) {
            this.copyRawData();
        }
        float[] result = sav_gol.Smooth(this.Value, this.ScanCount, range, repeats, this.startSmoothScan_, this.stopSmoothScan_);
        for (int i = 0; i < this.ScanCount; ++i) {
            this.Value[i][2] = result[i];
        }
    }

    public void Smooth(float range, int repeats, SavGolJNI sav_gol) {
        this.Smooth(range, repeats, true, sav_gol);
    }

    private void GetValleysGreedy() {
        int oldPosition;
        int position;
        this.GetValleysGreedySteepnessPoint();
        int steepnessPointLoValley = this.LoValley;
        int steepnessPointUpValley = this.UpValley;
        float[] diffs = this.calculateUpwardsDifferential(position);
        float differential1 = diffs[0];
        float differential2 = diffs[1];
        if (1.5 * (double)differential2 < (double)differential1) {
            oldPosition = position;
            for (position = this.UpValley; position < this.ScanCount - 1; ++position) {
                if (position > 0) {
                    differential1 = this.Value[position - 1][2] - this.Value[position][2];
                }
                if ((double)(differential2 = this.Value[position][2] - this.Value[position + 1][2]) > 1.1 * (double)differential1 || this.Value[position + 1][2] > this.Value[position][2]) break;
            }
            position = (double)this.Value[this.Peak][2] * 0.1 < (double)this.Value[position][2] ? (position + oldPosition) / 2 + 1 : oldPosition;
        }
        this.UpValley = position;
        if (this.UpValley > this.ScanCount - 2) {
            this.UpValley = this.ScanCount - 2;
        }
        if (1.5 * (double)(differential2 = (diffs = this.calculateDownwardsDifferential(position = this.LoValley))[1]) < (double)(differential1 = diffs[0])) {
            oldPosition = position;
            while (position > 0 && !((double)(differential2 = this.Value[position][2] - this.Value[position - 1][2]) > 1.1 * (double)(differential1 = this.Value[position + 1][2] - this.Value[position][2])) && !(this.Value[position - 1][2] > this.Value[position][2])) {
                --position;
            }
            position = (double)this.Value[this.Peak][2] * 0.1 < (double)this.Value[position][2] ? (position + oldPosition) / 2 : oldPosition;
        }
        this.LoValley = position;
        if (this.LoValley < 1) {
            this.LoValley = 1;
        }
        if (this.startPosition_ < steepnessPointLoValley || steepnessPointUpValley < this.startPosition_) {
            int greedyLoValley = this.LoValley;
            int greedyUpValley = this.UpValley;
            int peakDistanceGreedy = greedyUpValley - greedyLoValley;
            this.GetValleysOriginal();
            int distanceRest = 0;
            if (this.startPosition_ < steepnessPointLoValley) {
                distanceRest = greedyLoValley - this.LoValley;
            }
            if (this.startPosition_ > steepnessPointUpValley) {
                distanceRest = this.UpValley - greedyUpValley;
            }
            if (distanceRest > peakDistanceGreedy / 3) {
                this.greedyFragment_ = true;
                if (this.startPosition_ < steepnessPointLoValley) {
                    this.UpValley = greedyLoValley;
                }
                if (this.startPosition_ > steepnessPointUpValley) {
                    this.LoValley = greedyUpValley;
                }
                this.Peak = (this.UpValley + this.LoValley) / 2;
            } else {
                this.LoValley = greedyLoValley;
                this.UpValley = greedyUpValley;
            }
        }
    }

    private void GetValleysGreedySteepnessPoint() {
        float[] diffs;
        int position;
        float differential1 = 0.0f;
        float differential2 = 0.0f;
        for (position = this.Peak; position < this.ScanCount - 1; ++position) {
            diffs = this.calculateUpwardsDifferential(position);
            differential1 = diffs[0];
            differential2 = diffs[1];
            if (position >= this.ScanCount - 2) {
                ++position;
                break;
            }
            if (1.5 * (double)differential2 < (double)differential1 || this.Value[position + 1][2] > this.Value[position][2]) break;
        }
        this.UpValley = position;
        if (this.UpValley > this.ScanCount - 2) {
            this.UpValley = this.ScanCount - 2;
        }
        differential1 = 0.0f;
        differential2 = 0.0f;
        for (position = this.Peak; position > 0; --position) {
            diffs = this.calculateDownwardsDifferential(position);
            differential1 = diffs[0];
            differential2 = diffs[1];
            if (position < this.ScanCount - 2) {
                differential1 = this.Value[position + 1][2] - this.Value[position][2];
            }
            if (position <= 0 || 1.5 * (double)(differential2 = this.Value[position][2] - this.Value[position - 1][2]) < (double)differential1 || this.Value[position - 1][2] > this.Value[position][2]) break;
        }
        this.LoValley = position;
        if (this.LoValley < 1) {
            this.LoValley = 1;
        }
    }

    private void GetValleysGreedyImproved() {
        this.GetValleysGreedySteepnessPointImproved();
        int steepnessPointLoValley = this.LoValley;
        int steepnessPointUpValley = this.UpValley;
        if (this.LoValley < 1) {
            this.LoValley = 1;
        }
        if (this.startPosition_ < steepnessPointLoValley && steepnessPointLoValley != -1 || steepnessPointUpValley < this.startPosition_ && steepnessPointUpValley != -1) {
            int greedyLoValley = this.LoValley;
            int greedyUpValley = this.UpValley;
            int peakDistanceGreedy = greedyUpValley - greedyLoValley;
            this.GetValleysOriginal();
            int distanceRest = 0;
            if (this.startPosition_ < steepnessPointLoValley) {
                distanceRest = greedyLoValley - this.LoValley;
            }
            if (this.startPosition_ > steepnessPointUpValley) {
                distanceRest = this.UpValley - greedyUpValley;
            }
            if (distanceRest > peakDistanceGreedy / 3) {
                this.greedyFragment_ = true;
                if (this.startPosition_ < steepnessPointLoValley) {
                    this.UpValley = greedyLoValley;
                    if (this.loSteepnessPoint_ != -1 && this.loSteepnessPoint_ > this.UpValley) {
                        this.UpValley = this.loSteepnessPoint_ + (this.loSteepnessPoint_ - this.UpValley);
                    }
                }
                if (this.startPosition_ > steepnessPointUpValley) {
                    this.LoValley = greedyUpValley;
                    if (this.upSteepnessPoint_ != -1 && this.upSteepnessPoint_ < this.LoValley) {
                        this.LoValley = this.upSteepnessPoint_ + (this.LoValley - this.upSteepnessPoint_);
                    }
                }
                this.Peak = (this.UpValley + this.LoValley) / 2;
                if (this.startPosition_ < steepnessPointLoValley) {
                    this.upSteepnessPoint_ = this.loSteepnessPoint_;
                    this.loSteepnessPoint_ = -1;
                }
                if (this.startPosition_ > steepnessPointUpValley) {
                    this.loSteepnessPoint_ = this.upSteepnessPoint_;
                    this.upSteepnessPoint_ = -1;
                }
            } else {
                this.LoValley = greedyLoValley;
                this.UpValley = greedyUpValley;
            }
        }
        if (this.UpValley > this.ScanCount - 2) {
            this.UpValley = this.ScanCount - 2;
        }
        if (this.LoValley < 1) {
            this.LoValley = 1;
        }
    }

    private void GetValleysGreedySteepnessPointImproved() {
        int interimPosition;
        int positionDifference;
        float newDifferential;
        float[] diffs;
        int position = this.Peak;
        if (this.Value[position][2] < 1.0E-9f) {
            this.LoValley = position - 1;
            this.UpValley = position + 1;
            if (this.UpValley > this.ScanCount - 2) {
                this.UpValley = this.ScanCount - 2;
                this.LoValley = this.ScanCount - 4;
            }
            if (this.LoValley < 1) {
                this.LoValley = 1;
                this.UpValley = 3;
            }
            return;
        }
        float differential1 = 0.0f;
        float differential2 = 0.0f;
        while (position < this.ScanCount - 1) {
            diffs = this.calculateUpwardsDifferential(position);
            differential1 = diffs[0];
            differential2 = diffs[1];
            if (position >= this.ScanCount - 2) {
                ++position;
                break;
            }
            if (Math.abs(differential1) < 0.001f * this.Value[position][2]) {
                ++position;
                continue;
            }
            if (this.greedySteepnessChange1_ * differential2 < differential1 && this.Value[position][2] / this.Value[this.Peak][2] > this.greedyIntensityCutoff1_ && (this.greedySteepnessChange2_ * differential2 < differential1 || this.Value[position][2] / this.Value[this.Peak][2] > this.greedyIntensityCutoff2_)) {
                this.upSteepnessPoint_ = position;
                if (differential1 > 0.0f) {
                    float differential = differential1;
                    newDifferential = this.getHighestCloseDifferentialUp(position);
                    if (newDifferential > differential) {
                        differential = newDifferential;
                    }
                    positionDifference = (int)Calculator.roundFloat(this.Value[position][2] / differential, 0);
                    position += positionDifference;
                }
                for (interimPosition = this.upSteepnessPoint_ + 1; interimPosition < position && interimPosition < this.ScanCount - 1; ++interimPosition) {
                    if (!(this.Value[interimPosition + 1][2] > this.Value[interimPosition][2]) && !(this.Value[interimPosition][2] < 1.0f)) continue;
                    position = interimPosition;
                    break;
                }
                if (position <= this.ScanCount - 1) break;
                position = this.ScanCount - 1;
                break;
            }
            if (this.Value[position + 1][2] > this.Value[position][2] || this.Value[position + 1][2] < this.Value[this.Peak][2] * this.intensityCutoff_) break;
            ++position;
        }
        this.UpValley = position;
        if (this.UpValley > this.ScanCount - 2) {
            this.UpValley = this.ScanCount - 2;
        }
        position = this.Peak;
        differential1 = 0.0f;
        differential2 = 0.0f;
        while (position > 0) {
            diffs = this.calculateDownwardsDifferential(position);
            differential1 = diffs[0];
            differential2 = diffs[1];
            if (position < this.ScanCount - 2) {
                differential1 = this.Value[position + 1][2] - this.Value[position][2];
            }
            if (position <= 0) break;
            differential2 = this.Value[position][2] - this.Value[position - 1][2];
            if (Math.abs(differential1) < 0.001f * this.Value[position][2]) {
                --position;
                continue;
            }
            if (this.greedySteepnessChange1_ * differential2 < differential1 && this.Value[position][2] / this.Value[this.Peak][2] > this.greedyIntensityCutoff1_ && (this.greedySteepnessChange2_ * differential2 < differential1 || this.Value[position][2] / this.Value[this.Peak][2] > this.greedyIntensityCutoff2_)) {
                this.loSteepnessPoint_ = position;
                if (differential1 > 0.0f) {
                    float differential = differential1;
                    newDifferential = this.getHighestCloseDifferentialLo(position);
                    if (newDifferential > differential) {
                        differential = newDifferential;
                    }
                    positionDifference = (int)Calculator.roundFloat(this.Value[position][2] / differential, 0);
                    position -= positionDifference;
                }
                for (interimPosition = this.loSteepnessPoint_ - 1; interimPosition > position && interimPosition > 0; --interimPosition) {
                    if (!(this.Value[interimPosition - 1][2] > this.Value[interimPosition][2]) && !(this.Value[interimPosition][2] < 1.0f)) continue;
                    position = interimPosition;
                    break;
                }
                if (position >= 0) break;
                position = 0;
                break;
            }
            if (this.Value[position - 1][2] > this.Value[position][2] || this.Value[position - 1][2] < this.Value[this.Peak][2] * this.intensityCutoff_) break;
            --position;
        }
        this.LoValley = position;
        if (this.LoValley < 1) {
            this.LoValley = 1;
        }
        if (this.Peak - this.LoValley > (this.UpValley - this.Peak) * 7 && this.LoValley < this.Peak && this.Peak < this.UpValley || this.UpValley - this.Peak > (this.Peak - this.LoValley) * 7 && this.LoValley < this.Peak && this.Peak < this.UpValley) {
            this.GetBackground(50);
            if (this.Peak - this.LoValley > (this.UpValley - this.Peak) * 7 && this.LoValley < this.Peak && this.Peak < this.UpValley) {
                this.LoValley = this.Peak - (this.UpValley - this.Peak);
                while (this.LoValley > -1 && (double)this.Value[this.LoValley][2] > (double)this.Value[this.Peak][2] * 0.05 && this.Value[this.LoValley][2] > this.Background * 3.0f) {
                    --this.LoValley;
                }
            }
            if (this.UpValley - this.Peak > (this.Peak - this.LoValley) * 7 && this.LoValley < this.Peak && this.Peak < this.UpValley) {
                this.UpValley = this.Peak + (this.Peak - this.LoValley);
                while (this.UpValley < this.ScanCount && (double)this.Value[this.UpValley][2] > (double)this.Value[this.Peak][2] * 0.05 && this.Value[this.UpValley][2] > this.Background * 3.0f) {
                    ++this.UpValley;
                }
            }
        }
        if (this.UpValley > this.ScanCount - 2) {
            this.UpValley = this.ScanCount - 2;
        }
        if (this.LoValley < 1) {
            this.LoValley = 1;
        }
    }

    public void detectPeakIntensityInsideBorders(int low, int high) {
        this.LoValley = low;
        this.UpValley = high;
        float intensity = 0.0f;
        for (int i = this.LoValley; i < this.UpValley; ++i) {
            if (i < 0 || i >= this.ScanCount || !(this.Value[i][2] > intensity)) continue;
            intensity = this.Value[i][2];
            this.Peak = i;
        }
    }

    private float getHighestCloseDifferentialUp(int position) {
        float differential = 0.0f;
        for (int i = 0; i != 10; ++i) {
            if (position - i - 1 <= 0 || !(this.Value[position - i - 1][2] - this.Value[position - i][2] > differential)) continue;
            differential = this.Value[position - i - 1][2] - this.Value[position - i][2];
        }
        return differential;
    }

    private float getHighestCloseDifferentialLo(int position) {
        float differential = 0.0f;
        for (int i = 0; i != 10; ++i) {
            if (position >= this.ScanCount - (i + 1) || !(this.Value[position + i + 1][2] - this.Value[position + i][2] > differential)) continue;
            differential = this.Value[position + i + 1][2] - this.Value[position + i][2];
        }
        return differential;
    }

    private float[] calculateDownwardsDifferential(int position) {
        float[] differentials = new float[2];
        float differential1 = 0.0f;
        float differential2 = 0.0f;
        if (position < this.ScanCount - 2) {
            differential1 = this.Value[position + 1][2] - this.Value[position][2];
        }
        if (position > 0) {
            differential2 = this.Value[position][2] - this.Value[position - 1][2];
        }
        differentials[0] = differential1;
        differentials[1] = differential2;
        return differentials;
    }

    private float[] calculateUpwardsDifferential(int position) {
        float[] differentials = new float[2];
        float differential1 = 0.0f;
        float differential2 = 0.0f;
        if (position > 0) {
            differential1 = this.Value[position - 1][2] - this.Value[position][2];
        }
        if (position < this.ScanCount - 2) {
            differential2 = this.Value[position][2] - this.Value[position + 1][2];
        }
        differentials[0] = differential1;
        differentials[1] = differential2;
        return differentials;
    }

    public boolean isGreedyFragment() {
        return this.greedyFragment_;
    }

    public int getLoSteepnessPoint() {
        return this.loSteepnessPoint_;
    }

    public int getUpSteepnessPoint() {
        return this.upSteepnessPoint_;
    }

    public float[] findPercentualBorders(float percent, float start, float stop) {
        float startPercent = Float.MAX_VALUE;
        float stopPercent = 0.0f;
        int startScan = LipidomicsAnalyzer.findIndexByTime(start, this);
        if (--startScan < 0) {
            ++startScan;
        }
        int stopScan = LipidomicsAnalyzer.findIndexByTime(stop, this);
        if (++stopScan >= this.Value.length) {
            --stopScan;
        }
        int highestScanNumber = -1;
        float intensity = 0.0f;
        for (int i = startScan; i <= stopScan; ++i) {
            if (!(this.Value[i][2] > intensity)) continue;
            highestScanNumber = i;
            intensity = this.Value[i][2];
        }
        float threshold = intensity * percent / 100.0f;
        if (highestScanNumber > -1) {
            int scanCount = highestScanNumber;
            for (scanCount = highestScanNumber; scanCount >= startScan && !(this.Value[scanCount][2] < threshold); --scanCount) {
            }
            startPercent = scanCount <= startScan ? start : (scanCount < 0 ? 0.0f : (scanCount + 1 == this.Value.length ? this.Value[scanCount][0] : this.Value[scanCount][0] + (this.Value[scanCount + 1][0] - this.Value[scanCount][0]) / 10.0f));
            scanCount = highestScanNumber;
            for (scanCount = highestScanNumber; scanCount <= stopScan && !(this.Value[scanCount][2] < threshold); ++scanCount) {
            }
            stopPercent = scanCount >= stopScan ? stop : (scanCount >= this.Value.length - 1 ? Float.MAX_VALUE : (scanCount <= 0 ? this.Value[0][0] : this.Value[scanCount][0] + (this.Value[scanCount][0] - this.Value[scanCount - 1][0]) / 10.0f));
        }
        float[] result = new float[]{startPercent, stopPercent};
        return result;
    }

    public int findIndexOfHighestIntensity() {
        int index = -1;
        float highestInt = 0.0f;
        for (int i = 0; i != this.Value.length; ++i) {
            if (!(this.Value[i][1] > highestInt)) continue;
            index = i;
            highestInt = this.Value[i][1];
        }
        return index;
    }
}

