/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.vos.RawQuantificationPairVO;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public class BatchQuantificationTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -6221307059304744458L;
    private static final Integer STATUS_ADDED = new Integer(0);
    private static final Integer STATUS_UPLOADED = new Integer(1);
    private static final Integer STATUS_ERROR = new Integer(2);
    private List<RawQuantificationPairVO> fileList;
    private Map<RawQuantificationPairVO, Integer> fileStatusMap;
    private int numFilesLeft = 0;
    private ImageIcon uploadedIcon = new ImageIcon(this.getClass().getResource("/images/uploaded.gif"));
    private ImageIcon errorIcon = new ImageIcon(this.getClass().getResource("/images/error.gif"));

    public BatchQuantificationTableModel() {
        this.fileList = new ArrayList<RawQuantificationPairVO>();
        this.fileStatusMap = new HashMap<RawQuantificationPairVO, Integer>();
    }

    public List<RawQuantificationPairVO> getFilesLeftToQuantify() {
        ArrayList<RawQuantificationPairVO> list = new ArrayList<RawQuantificationPairVO>(this.numFilesLeft);
        for (RawQuantificationPairVO file : this.fileList) {
            Integer status = this.fileStatusMap.get(file);
            if (status != STATUS_ADDED) continue;
            list.add(file);
        }
        return list;
    }

    public int getNumFiles() {
        return this.fileList.size();
    }

    public int getNumFilesLeftToUpload() {
        return this.numFilesLeft;
    }

    public int getFileRow(RawQuantificationPairVO file) {
        int row = 0;
        Iterator<RawQuantificationPairVO> it = this.fileList.iterator();
        while (it.hasNext()) {
            if (file.equals(it.next())) {
                return row;
            }
            ++row;
        }
        return -1;
    }

    public void addFiles(Vector<RawQuantificationPairVO> files) {
        for (RawQuantificationPairVO pairVO : files) {
            this.fileList.add(pairVO);
            this.fileStatusMap.put(pairVO, STATUS_ADDED);
            ++this.numFilesLeft;
        }
        this.fireTableDataChanged();
    }

    public void clearFiles() {
        this.fileList.clear();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return " ";
            }
            case 1: {
                return "Data";
            }
            case 2: {
                return "Quant-File";
            }
            case 3: {
                return "Progress";
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.fileList != null ? this.fileList.size() : 0;
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                RawQuantificationPairVO file = this.fileList.get(row);
                Integer status = this.fileStatusMap.get(file);
                if (status == STATUS_UPLOADED) {
                    return this.uploadedIcon;
                }
                if (status == STATUS_ERROR) {
                    return this.errorIcon;
                }
                return null;
            }
            case 1: {
                return this.fileList.get(row).getRawFileName();
            }
            case 2: {
                return this.fileList.get(row).getQuantFileName();
            }
            case 3: {
                return this.fileList.get(row).getStatus();
            }
        }
        return null;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Icon.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void fileQuantified(RawQuantificationPairVO file) {
        Integer status = this.fileStatusMap.get(file);
        if (status != STATUS_UPLOADED) {
            this.fileStatusMap.put(file, STATUS_UPLOADED);
            this.fireTableDataChanged();
            --this.numFilesLeft;
        }
    }

    public void fileQuantificationError(RawQuantificationPairVO file) {
        Integer status = this.fileStatusMap.get(file);
        if (status != STATUS_ERROR) {
            this.fileStatusMap.put(file, STATUS_ERROR);
            this.fireTableDataChanged();
            --this.numFilesLeft;
        }
    }

    public void updateRawFile(RawQuantificationPairVO file, File newRawFile) {
        Integer status = this.fileStatusMap.get(file);
        this.fileStatusMap.remove(file);
        file.setRawFile(newRawFile);
        this.fileStatusMap.put(file, status);
    }

    public RawQuantificationPairVO getDataByRow(int row) {
        return this.fileList.get(row);
    }
}

