/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CheckBoxOptionPane
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -5766256473109433281L;
    private final int NR_OF_ROWS = 5;
    private int value_ = 1;
    private ArrayList<String> checkBoxStrings_;
    private Hashtable<String, JCheckBox> checkBoxHash_;
    private boolean showOne_;

    private CheckBoxOptionPane(JFrame parent, String title, Vector<String> messages, ArrayList<String> chechboxStrings, boolean showOne) {
        super(parent, title, true);
        this.checkBoxStrings_ = chechboxStrings;
        this.showOne_ = showOne;
        this.checkBoxHash_ = new Hashtable();
        Vector<JCheckBox> chechboxes = new Vector<JCheckBox>();
        if (showOne && this.checkBoxStrings_.size() > 0 || this.checkBoxStrings_.size() > 1) {
            for (String name : this.checkBoxStrings_) {
                JCheckBox box = new JCheckBox(name);
                box.setSelected(true);
                this.checkBoxHash_.put(name, box);
                chechboxes.add(box);
            }
        }
        this.setLayout(new GridBagLayout());
        this.setLocation(380, 240);
        this.value_ = 1;
        int columns = chechboxes.size() / 5;
        if (chechboxes.size() % 5 != 0 || columns == 0) {
            ++columns;
        }
        int rowCount = 1;
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new GridLayout());
        for (String message : messages) {
            if (message == null || message.length() <= 0) continue;
            JLabel titleLabel = new JLabel(message);
            textPanel.add(titleLabel);
        }
        JScrollPane scrollPane = new JScrollPane(textPanel);
        scrollPane.setPreferredSize(new Dimension(950, 250));
        scrollPane.setMinimumSize(new Dimension(500, 150));
        this.add((Component)scrollPane, new GridBagConstraints(0, 0, columns, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        for (int i = 0; i != chechboxes.size(); ++i) {
            JCheckBox select = (JCheckBox)chechboxes.get(i);
            select.setSelected(true);
            int row = i % 5 + rowCount;
            int column = i / 5;
            this.add((Component)select, new GridBagConstraints(column, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        }
        int requiredRows = rowCount + chechboxes.size();
        if (requiredRows > 6) {
            requiredRows = 6;
        }
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, new GridBagConstraints(0, requiredRows + 1, columns, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("AcceptSelection");
        okButton.setToolTipText("<html>Accept settings</html>");
        buttonPanel.add(okButton);
        okButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("DeclineSelection");
        cancelButton.setToolTipText("<html>Cancel operation</html>");
        buttonPanel.add(cancelButton);
        cancelButton.addActionListener(this);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setVisible(true);
    }

    public static Vector<String> showConfirmDialog(JFrame parent, String title, Vector<String> messages, ArrayList<String> chechboxStrings, boolean showOne) {
        CheckBoxOptionPane dialog = new CheckBoxOptionPane(parent, title, messages, chechboxStrings, showOne);
        return dialog.getSelected();
    }

    public Vector<String> getSelected() {
        Vector<String> selected = new Vector<String>();
        if (this.getValue() == 0) {
            if (this.checkBoxStrings_.size() == 1 && !this.showOne_) {
                selected = new Vector<String>(this.checkBoxStrings_);
            } else {
                for (String name : this.checkBoxStrings_) {
                    if (!this.checkBoxHash_.get(name).isSelected()) continue;
                    selected.add(name);
                }
            }
        }
        return selected;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("AcceptSelection")) {
            this.value_ = 0;
            this.setVisible(false);
            this.dispose();
        } else if (e.getActionCommand().equalsIgnoreCase("DeclineSelection")) {
            this.value_ = 1;
            this.setVisible(false);
            this.dispose();
        }
    }

    public int getValue() {
        return this.value_;
    }
}

