/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.verifier.IntegerVerifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class ChromExportDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -2009258591034858049L;
    private final int columns_ = 8;
    private final int WIDTH_DEFAULT = 1024;
    private final int HEIGHT_DEFAULT = 768;
    private int value_ = 1;
    private JTabbedPane tabs_;
    private ArrayList<String> experiments_;
    private ArrayList<String> analytes_;
    private ArrayList<String> modifications_;
    private Hashtable<String, JCheckBox> expBoxes_;
    private Hashtable<String, JCheckBox> analBoxes_;
    private Hashtable<String, JCheckBox> modBoxes_;
    private JPanel expSelection_;
    private JPanel moleculeSelection_;
    private JPanel modificationsSelection_;
    private JRadioButton pngRadio_;
    private JRadioButton svgRadio_;
    private ActionListener parent_;
    private JTextField width_;
    private JTextField height_;
    private JButton okButton_;

    public ChromExportDialog(String title, ArrayList<String> experiments, ArrayList<String> analytes, ArrayList<String> modifications, ActionListener parent) {
        super(new JFrame(), title, true);
        this.experiments_ = experiments;
        this.analytes_ = analytes;
        this.modifications_ = modifications;
        this.setLayout(new BorderLayout());
        this.setLocation(380, 240);
        this.tabs_ = new JTabbedPane();
        this.parent_ = parent;
        this.expSelection_ = new JPanel();
        this.expBoxes_ = this.initCheckboxes(this.expSelection_, "Samples", this.experiments_);
        this.moleculeSelection_ = new JPanel();
        this.analBoxes_ = this.initCheckboxes(this.moleculeSelection_, "Analytes", this.analytes_);
        JScrollPane analScrollPane = new JScrollPane(this.moleculeSelection_);
        analScrollPane.setPreferredSize(new Dimension(1000, 600));
        this.modificationsSelection_ = new JPanel();
        this.modBoxes_ = this.initCheckboxes(this.modificationsSelection_, "Modifications", this.modifications_);
        this.tabs_.addTab("Sample", this.expSelection_);
        this.tabs_.setToolTipTextAt(0, "<html>Select samples to export</html>");
        this.tabs_.addTab("Analyte", analScrollPane);
        this.tabs_.setToolTipTextAt(1, "<html>Select analytes to export</html>");
        this.tabs_.addTab("Modifications", this.modificationsSelection_);
        this.tabs_.setToolTipTextAt(2, "<html>Select modifications to export</html>");
        this.add((Component)this.tabs_, "Center");
        this.initButtonPanel();
    }

    private Hashtable<String, JCheckBox> initCheckboxes(JPanel panel, String title, ArrayList<String> analytes) {
        panel.setLayout(new GridBagLayout());
        Hashtable<String, JCheckBox> boxes = new Hashtable<String, JCheckBox>();
        int titleColSpan = analytes.size();
        if (titleColSpan > 8) {
            titleColSpan = 8;
        }
        if (title != null && title.length() > 0) {
            JLabel titleLabel = new JLabel(title);
            panel.add((Component)titleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        }
        int rows = analytes.size() / 8;
        if (analytes.size() > 0 && analytes.size() % 8 != 0) {
            ++rows;
        }
        for (int i = 0; i != analytes.size(); ++i) {
            String name = analytes.get(i);
            JCheckBox select = new JCheckBox(name);
            select.setSelected(true);
            int row = i % rows;
            int column = i / rows;
            select.setToolTipText("<html>Accept " + name + "?</html>");
            panel.add((Component)select, new GridBagConstraints(column, row + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
            boxes.put(name, select);
        }
        return boxes;
    }

    private void initButtonPanel() {
        JPanel buttonAndRadio = new JPanel();
        buttonAndRadio.setLayout(new GridBagLayout());
        JPanel radioPanel = new JPanel();
        buttonAndRadio.add((Component)radioPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 0, 1, 0), 0, 0));
        ButtonGroup pictType = new ButtonGroup();
        this.pngRadio_ = new JRadioButton("PNG");
        this.pngRadio_.setToolTipText("<html>Export image to PNG format (portable image format).</html>");
        this.pngRadio_.setSelected(true);
        pictType.add(this.pngRadio_);
        radioPanel.add(this.pngRadio_);
        this.svgRadio_ = new JRadioButton("SVG");
        this.svgRadio_.setToolTipText("<html>Export image to SVG format (scalable vector graphics).</html>");
        pictType.add(this.svgRadio_);
        radioPanel.add(this.svgRadio_);
        JLabel widthLabel = new JLabel("Width: ");
        radioPanel.add(widthLabel);
        this.width_ = new JTextField(5);
        this.width_.setHorizontalAlignment(4);
        this.width_.setInputVerifier(new IntegerVerifier(true));
        this.width_.setText(String.valueOf(1024));
        radioPanel.add(this.width_);
        JLabel heightLabel = new JLabel("Height: ");
        radioPanel.add(heightLabel);
        this.height_ = new JTextField(5);
        this.height_.setHorizontalAlignment(4);
        this.height_.setInputVerifier(new IntegerVerifier(true));
        this.height_.setText(String.valueOf(768));
        radioPanel.add(this.height_);
        JPanel buttonPanel = new JPanel();
        buttonAndRadio.add((Component)buttonPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 0, 1, 0), 0, 0));
        this.add((Component)buttonAndRadio, "South");
        JButton allButton = new JButton("All");
        allButton.setActionCommand("SelectAll");
        allButton.setToolTipText("<html>Select all</html>");
        buttonPanel.add(allButton);
        allButton.addActionListener(this);
        JButton noneButton = new JButton("None");
        noneButton.setActionCommand("SelectNone");
        noneButton.setToolTipText("<html>Select none</html>");
        buttonPanel.add(noneButton);
        noneButton.addActionListener(this);
        JButton invertButton = new JButton("Invert");
        invertButton.setActionCommand("Invert");
        invertButton.setToolTipText("<html>Invert selection</html>");
        buttonPanel.add(invertButton);
        invertButton.addActionListener(this);
        JLabel emptyLabel = new JLabel("   ");
        buttonPanel.add(emptyLabel);
        this.okButton_ = new JButton("OK");
        this.okButton_.setActionCommand("AcceptChromExport");
        this.okButton_.setToolTipText("<html>Accept settings</html>");
        buttonPanel.add(this.okButton_);
        this.okButton_.addActionListener(this);
        this.okButton_.addActionListener(this.parent_);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("DeclineSelection");
        cancelButton.setToolTipText("<html>Cancel operation</html>");
        buttonPanel.add(cancelButton);
        cancelButton.addActionListener(this);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("AcceptChromExport")) {
            this.value_ = 0;
            this.setVisible(false);
            this.dispose();
        } else if (e.getActionCommand().equalsIgnoreCase("DeclineSelection")) {
            this.value_ = 1;
            this.setVisible(false);
            this.dispose();
        } else if (e.getActionCommand().equalsIgnoreCase("SelectAll") || e.getActionCommand().equalsIgnoreCase("SelectNone") || e.getActionCommand().equalsIgnoreCase("Invert")) {
            ArrayList<String> names = null;
            Hashtable<String, JCheckBox> boxes = null;
            if (this.tabs_.getSelectedIndex() == 0) {
                names = this.experiments_;
                boxes = this.expBoxes_;
            } else if (this.tabs_.getSelectedIndex() == 1) {
                names = this.analytes_;
                boxes = this.analBoxes_;
            } else if (this.tabs_.getSelectedIndex() == 2) {
                names = this.modifications_;
                boxes = this.modBoxes_;
            }
            if (names == null || boxes == null) {
                return;
            }
            for (String name : names) {
                JCheckBox box = boxes.get(name);
                if (e.getActionCommand().equalsIgnoreCase("SelectAll")) {
                    box.setSelected(true);
                }
                if (e.getActionCommand().equalsIgnoreCase("SelectNone")) {
                    box.setSelected(false);
                }
                if (!e.getActionCommand().equalsIgnoreCase("Invert")) continue;
                box.setSelected(!box.isSelected());
            }
        }
    }

    public int getValue() {
        return this.value_;
    }

    public void refreshNames(ArrayList<String> names) {
        for (int i = 0; i != names.size(); ++i) {
            String newName;
            String oldName = this.experiments_.get(i);
            if (oldName.equalsIgnoreCase(newName = names.get(i))) continue;
            JCheckBox check = this.expBoxes_.get(oldName);
            check.setText(newName);
            check.invalidate();
            check.updateUI();
            this.expBoxes_.put(newName, check);
        }
        this.experiments_ = names;
        this.correctDialogSize();
    }

    public void checkMolecules(Vector<String> anals, boolean check) {
        for (String anal : anals) {
            JCheckBox box = this.analBoxes_.get(anal);
            box.setSelected(check);
            box.invalidate();
            box.updateUI();
        }
        this.correctDialogSize();
    }

    private void correctDialogSize() {
        this.invalidate();
        this.doLayout();
        this.setSize(this.getPreferredSize());
        this.repaint();
        this.pack();
    }

    public boolean isExperimentSelected(String expName) {
        return this.expBoxes_.containsKey(expName) && this.expBoxes_.get(expName).isSelected();
    }

    public boolean isMoleculeSelected(String molName) {
        return this.analBoxes_.containsKey(molName) && this.analBoxes_.get(molName).isSelected();
    }

    public boolean isModificationSelected(String molName) {
        return this.modBoxes_.containsKey(molName) && this.modBoxes_.get(molName).isSelected();
    }

    public String getPictureType() {
        if (this.pngRadio_.isSelected()) {
            return "exportPNG";
        }
        return "exportSVG";
    }

    public Dimension getPictureDimension() {
        return new Dimension(Integer.parseInt(this.width_.getText()), Integer.parseInt(this.height_.getText()));
    }

    public void cleanup() {
        this.okButton_.removeActionListener(this.parent_);
        this.parent_ = null;
    }
}

