/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.verifier.DoubleVerifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EditRtDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -7614750501692196104L;
    private ActionListener parent_;
    private JTextField rTime_;

    public EditRtDialog(String rt, ActionListener parent) {
        this.parent_ = parent;
        this.setLayout(new BorderLayout());
        this.setLocation(380, 240);
        this.initMainPanel(rt);
        this.initButtonPanel();
        this.pack();
        this.setVisible(true);
    }

    private void initMainPanel(String rt) {
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridBagLayout());
        JLabel label = new JLabel("RT: ");
        label.setToolTipText("<html>The RT identifier of the analyte.</html>");
        centerPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.rTime_ = new JTextField(5);
        this.rTime_.setHorizontalAlignment(4);
        this.rTime_.setInputVerifier(new DoubleVerifier(true, true));
        this.rTime_.setText(rt);
        this.rTime_.setToolTipText("<html>The RT identifier of the analyte.</html>");
        centerPanel.add((Component)this.rTime_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.add((Component)centerPanel, "Center");
    }

    private void initButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("AcceptChangedRT");
        okButton.setToolTipText("<html>Accept settings</html>");
        buttonPanel.add(okButton);
        okButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("DeclineChangedRT");
        cancelButton.setToolTipText("<html>Cancel operation</html>");
        buttonPanel.add(cancelButton);
        cancelButton.addActionListener(this);
        cancelButton.addActionListener(this.parent_);
        this.setDefaultCloseOperation(2);
        this.add((Component)buttonPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("AcceptChangedRT")) {
            try {
                Double.parseDouble(this.rTime_.getText());
                this.setVisible(false);
                this.parent_.actionPerformed(e);
                this.dispose();
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (e.getActionCommand().equalsIgnoreCase("DeclineChangedRT")) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public Double getRt() {
        return Double.parseDouble(this.rTime_.getText());
    }
}

