/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.swing.ExportButton;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ExportPanel
extends JPanel {
    private static final long serialVersionUID = 1684790632349952418L;
    public static final String EXPORT_SVG = "exportSVG";
    public static final String EXPORT_PNG = "exportPNG";
    public static final String EXPORT_EXCEL = "exportExcel";
    public static final String EXPORT_TEXT = "exportText";
    public static final String EXPORT_CHROMS = "exportChroms";
    public static final String EXPORT_MZTAB = "exportMztab";
    public static final String EXPORT_RDB = "exportRdb";
    public static final String EXPORT_MAF = "exportMAF";
    private ActionListener parent_;

    public ExportPanel(Color background, Color font, ActionListener parent) {
        this(background, font, parent, false, false, false);
    }

    public ExportPanel(Color background, Color font, ActionListener parent, boolean chroms, boolean mzTab, boolean pictureOnly) {
        this.parent_ = parent;
        if (background != null) {
            this.setBackground(background);
        }
        Font textFont = new Font("Helvetica", 1, 9);
        JLabel label = null;
        if (!pictureOnly) {
            label = new JLabel("Export: ");
            label.setForeground(font);
            label.setFont(textFont);
            label.setToolTipText("<html>The available export options.</html>");
            this.add(label);
        }
        ExportButton png = new ExportButton("PNG", EXPORT_PNG, font, background, this.parent_);
        png.setToolTipText("<html>Export image to PNG format (portable image format).</html>");
        this.add(png);
        label = new JLabel(" | ");
        label.setForeground(font);
        label.setFont(textFont);
        this.add(label);
        ExportButton svg = new ExportButton("SVG", EXPORT_SVG, font, background, this.parent_);
        svg.setToolTipText("<html>Export image to SVG format (scalable vector graphics).</html>");
        this.add(svg);
        if (pictureOnly) {
            return;
        }
        label = new JLabel(" | ");
        label.setForeground(font);
        label.setFont(textFont);
        this.add(label);
        ExportButton excel = new ExportButton("Excel", EXPORT_EXCEL, font, background, this.parent_);
        excel.setToolTipText("<html>Export data in Excel format.</html>");
        this.add(excel);
        if (mzTab) {
            label = new JLabel(" | ");
            label.setForeground(font);
            label.setFont(textFont);
            this.add(label);
            ExportButton mztab = new ExportButton("mzTab", EXPORT_MZTAB, font, background, this.parent_);
            mztab.setToolTipText("<html>Export data in mzTab format.</html>");
            this.add(mztab);
            label = new JLabel(" | ");
            label.setForeground(font);
            label.setFont(textFont);
            this.add(label);
            ExportButton rdb = new ExportButton("rdb", EXPORT_RDB, font, background, this.parent_);
            rdb.setToolTipText("<html>Export data in relational database format.</html>");
            this.add(rdb);
        }
        label = new JLabel(" | ");
        label.setForeground(font);
        label.setFont(textFont);
        this.add(label);
        ExportButton text = new ExportButton("Text", EXPORT_TEXT, font, background, this.parent_);
        text.setToolTipText("<html>Export data tab-delimited plain text format.</html>");
        this.add(text);
        if (chroms) {
            label = new JLabel(" | ");
            label.setForeground(font);
            label.setFont(textFont);
            this.add(label);
            ExportButton chrom = new ExportButton("Chroms", EXPORT_CHROMS, font, background, this.parent_);
            chrom.setToolTipText("<html>Export the chromatograms in a picture.</html>");
            this.add(chrom);
        }
    }
}

