/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.DoubleBondPositionVO;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class LipidomicsTableModel
extends DefaultTableModel
implements TableModel {
    private static final long serialVersionUID = 4607090326610106898L;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_AREA = 1;
    private Hashtable<Integer, String> rowToName_;
    private Hashtable<Integer, String> areaLookup_;
    private Hashtable<Integer, LipidParameterSet> rowToParam_;
    private Hashtable<Integer, Integer> rowToOriginal_;
    private Hashtable<Integer, Boolean> rowToOmegaEvidenceConflict_;
    private Set<String> uniqueIdentifiers_;
    private Hashtable<Integer, String> rowToMolecularSpeciesHumanReadable_;
    private boolean showMSn_;
    private boolean showOmega_;
    private boolean showMod_;
    private boolean hasOh_;

    public LipidomicsTableModel(Vector<LipidParameterSet> params, Vector<LipidParameterSet> paramsOriginal, boolean showMSn, boolean showOmega, boolean showMod) {
        this.showMSn_ = showMSn;
        this.showOmega_ = showOmega;
        this.showMod_ = showMod;
        this.hasOh_ = false;
        this.rowToName_ = new Hashtable();
        this.rowToParam_ = new Hashtable();
        this.rowToOriginal_ = new Hashtable();
        this.areaLookup_ = new Hashtable();
        this.rowToOmegaEvidenceConflict_ = new Hashtable();
        this.uniqueIdentifiers_ = new HashSet<String>();
        this.rowToMolecularSpeciesHumanReadable_ = new Hashtable();
        int rowCount = 0;
        for (LipidParameterSet param : params) {
            if (param.getOhNumber() > -1) {
                this.hasOh_ = true;
            }
            boolean hasRequestedOmegaData = this.hasRequestedOmegaData(showOmega, param);
            boolean hasRequestedMSnData = this.hasRequestedMSnData(showMSn, param);
            if (hasRequestedOmegaData || hasRequestedMSnData) {
                if (hasRequestedOmegaData) {
                    rowCount = this.showRequestedOmegaData(param, paramsOriginal, rowCount);
                }
                if (!hasRequestedMSnData) continue;
                rowCount = this.showRequestedMSnData(param, paramsOriginal, rowCount);
                continue;
            }
            rowCount = this.showRequestedParams(param, paramsOriginal, rowCount);
        }
    }

    private boolean hasRequestedMSnData(boolean showMSn, LipidParameterSet param) {
        return showMSn && param instanceof LipidomicsMSnSet && ((LipidomicsMSnSet)param).getStatus() > 2;
    }

    private boolean hasRequestedOmegaData(boolean showOmega, LipidParameterSet param) {
        Vector<DoubleBondPositionVO> assignedLabeledHits;
        return showOmega && param.hasOmegaInformation() && !(assignedLabeledHits = StaticUtils.getAssignedDoubleBondPositions(param.getOmegaInformation())).isEmpty();
    }

    private int showRequestedOmegaData(LipidParameterSet param, Vector<LipidParameterSet> paramsOriginal, int rowCount) {
        Vector<DoubleBondPositionVO> omegaInfo = param.getOmegaInformation();
        Set<String> molecularSpeciesSet = StaticUtils.getMolecularSpeciesSet(omegaInfo);
        for (String molecularSpecies : molecularSpeciesSet) {
            Vector<DoubleBondPositionVO> labeledChainCombiVOsWithUnlabeledAssignment = StaticUtils.getDoubleBondAssignmentsOfMolecularSpecies(omegaInfo, molecularSpecies);
            Vector<DoubleBondPositionVO> assignedHits = StaticUtils.getAssignedDoubleBondPositions(labeledChainCombiVOsWithUnlabeledAssignment);
            if (!assignedHits.isEmpty()) {
                for (DoubleBondPositionVO labeledChainCombiVO : assignedHits) {
                    String doubleBondPositionsHumanReadable = labeledChainCombiVO.getDoubleBondPositionsHumanReadable();
                    this.rowToMolecularSpeciesHumanReadable_.put(rowCount, molecularSpecies);
                    this.uniqueIdentifiers_.add(molecularSpecies + "_" + param.getRt());
                    this.areaLookup_.put(rowCount, molecularSpecies);
                    if (param.getRt() != null && param.getRt().length() > 0) {
                        doubleBondPositionsHumanReadable = doubleBondPositionsHumanReadable + "_" + param.getRt();
                    }
                    String paramName = this.getLipidParamsDisplayString(param, doubleBondPositionsHumanReadable);
                    this.rowToName_.put(rowCount, paramName);
                    this.rowToParam_.put(rowCount, param);
                    for (int i = 0; i != paramsOriginal.size(); ++i) {
                        if (!this.getLipidParamsDisplayString(param, param.getNameString()).equalsIgnoreCase(this.getLipidParamsDisplayString(paramsOriginal.get(i), paramsOriginal.get(i).getNameString()))) continue;
                        this.rowToOriginal_.put(rowCount, i);
                        break;
                    }
                    ++rowCount;
                }
                continue;
            }
            if (this.showMSn_) continue;
            this.areaLookup_.put(rowCount, molecularSpecies);
            this.rowToMolecularSpeciesHumanReadable_.put(rowCount, molecularSpecies);
            rowCount = this.showRequestedParams(param, paramsOriginal, rowCount);
        }
        return rowCount;
    }

    private int showRequestedMSnData(LipidParameterSet param, Vector<LipidParameterSet> paramsOriginal, int rowCount) {
        LipidomicsMSnSet msnSet = (LipidomicsMSnSet)param;
        Vector<String> detected = msnSet.getMSnIdentificationNamesWithSNPositions();
        for (String name : detected) {
            if (this.uniqueIdentifiers_.contains(name + "_" + param.getRt())) continue;
            this.areaLookup_.put(rowCount, name);
            Vector<DoubleBondPositionVO> doubleBondPositionVO = StaticUtils.getDoubleBondAssignmentsOfMolecularSpecies(param.getOmegaInformation(), name);
            if (StaticUtils.getHighAccuracyDoubleBondPositions(doubleBondPositionVO).size() > 1) {
                this.rowToOmegaEvidenceConflict_.put(rowCount, true);
            }
            this.rowToMolecularSpeciesHumanReadable_.put(rowCount, name);
            if (param.getRt() != null && param.getRt().length() > 0) {
                name = name + "_" + param.getRt();
            }
            String paramName = this.getLipidParamsDisplayString(param, name);
            this.rowToName_.put(rowCount, paramName);
            this.rowToParam_.put(rowCount, param);
            for (int i = 0; i != paramsOriginal.size(); ++i) {
                if (!this.getLipidParamsDisplayString(param, param.getNameString()).equalsIgnoreCase(this.getLipidParamsDisplayString(paramsOriginal.get(i), paramsOriginal.get(i).getNameString()))) continue;
                this.rowToOriginal_.put(rowCount, i);
                break;
            }
            ++rowCount;
        }
        return rowCount;
    }

    private int showRequestedParams(LipidParameterSet param, Vector<LipidParameterSet> paramsOriginal, int rowCount) {
        Vector<DoubleBondPositionVO> highAccuracyHits = StaticUtils.getHighAccuracyDoubleBondPositions(param.getOmegaInformation());
        if (highAccuracyHits.size() > 1) {
            this.rowToOmegaEvidenceConflict_.put(rowCount, true);
        }
        String paramName = this.getLipidParamsDisplayString(param, param.getNameString());
        this.rowToName_.put(rowCount, paramName);
        this.rowToParam_.put(rowCount, param);
        for (int i = 0; i != paramsOriginal.size(); ++i) {
            if (!paramName.equalsIgnoreCase(this.getLipidParamsDisplayString(paramsOriginal.get(i), paramsOriginal.get(i).getNameString()))) continue;
            this.rowToOriginal_.put(rowCount, i);
            break;
        }
        return ++rowCount;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String paramName = this.rowToName_.get(rowIndex);
        if (columnIndex == 0) {
            return paramName;
        }
        if (columnIndex == 1) {
            LipidParameterSet param = this.rowToParam_.get(rowIndex);
            if ((this.hasRequestedMSnData(this.showMSn_, param) || this.hasRequestedOmegaData(this.showOmega_, param)) && param instanceof LipidomicsMSnSet) {
                LipidomicsMSnSet msnSet = (LipidomicsMSnSet)param;
                return String.valueOf((float)msnSet.getRelativeIntensity(this.areaLookup_.get(rowIndex)) * param.getArea());
            }
            return String.valueOf(param.getArea());
        }
        return null;
    }

    public String getDisplayedNameAt(int rowIndex) {
        return this.rowToName_.get(rowIndex);
    }

    private String getLipidParamsDisplayString(LipidParameterSet params, String nameString) {
        String displayString = new String(nameString);
        if (this.showMod_) {
            displayString = displayString + "_" + params.getModificationName();
        }
        return displayString;
    }

    @Override
    public int getRowCount() {
        if (this.rowToName_ == null) {
            return 0;
        }
        return this.rowToName_.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Name";
        }
        if (columnIndex == 1) {
            return "Area";
        }
        return null;
    }

    public boolean hasMS2Evidence(int rowIndex) {
        LipidParameterSet param = this.rowToParam_.get(rowIndex);
        return StaticUtils.checkMS2Evidence(param) == 3;
    }

    public boolean hasOmegaEvidenceConflict(int rowIndex) {
        if (this.showOmega_ && this.rowToOmegaEvidenceConflict_.containsKey(rowIndex)) {
            return this.rowToOmegaEvidenceConflict_.get(rowIndex);
        }
        return false;
    }

    public Hashtable<Integer, Integer> getPositionToOriginal() {
        return this.rowToOriginal_;
    }

    public String getMSnIdentificationName(int rowIndex) {
        if (this.areaLookup_ != null && this.areaLookup_.containsKey(rowIndex)) {
            return this.areaLookup_.get(rowIndex);
        }
        return null;
    }

    public Hashtable<Integer, String> getRowToName() {
        return this.rowToName_;
    }

    public Hashtable<Integer, String> getRowToMolecularSpeciesHumanReadable() {
        return this.rowToMolecularSpeciesHumanReadable_;
    }

    public boolean isSplitInstance(int rowIndex) {
        LipidParameterSet param = this.rowToParam_.get(rowIndex);
        return StaticUtils.checkMS2Evidence(param) == 2;
    }

    public boolean isPercentalSplitInstance(int rowIndex) {
        LipidParameterSet param = this.rowToParam_.get(rowIndex);
        return StaticUtils.checkMS2Evidence(param) == 1;
    }

    public boolean isShowMSn() {
        return this.showMSn_;
    }

    public boolean isShowOmega() {
        return this.showOmega_;
    }

    public boolean hasOhInfo() {
        return this.hasOh_;
    }
}

