/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ResultSelectionSettings
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 8102700619746913853L;
    private final int columns_ = 8;
    private Vector<String> moleculeNames_;
    private Hashtable<String, JCheckBox> checkboxes_;
    JButton button_;

    public ResultSelectionSettings(String title, Vector<String> moleculeNames, boolean selected) {
        this.moleculeNames_ = moleculeNames;
        this.checkboxes_ = new Hashtable();
        this.setLayout(new BorderLayout());
        this.setLocation(380, 240);
        int titleColSpan = moleculeNames.size();
        if (titleColSpan > 8) {
            titleColSpan = 8;
        }
        if (title != null && title.length() > 0) {
            JLabel titleLabel = new JLabel(title);
            this.add((Component)titleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        }
        JPanel moleculeSelection = new JPanel(new GridBagLayout());
        int rows = this.moleculeNames_.size() / 8;
        if (this.moleculeNames_.size() > 0 && this.moleculeNames_.size() % 8 != 0) {
            ++rows;
        }
        for (int i = 0; i != this.moleculeNames_.size(); ++i) {
            String name = this.moleculeNames_.get(i);
            JCheckBox select = new JCheckBox(name);
            select.setSelected(selected);
            int row = i % rows;
            int column = i / rows;
            select.setToolTipText("<html>Accept " + name + "?</html>");
            moleculeSelection.add((Component)select, new GridBagConstraints(column, row + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
            this.checkboxes_.put(name, select);
        }
        JScrollPane analScrollPane = new JScrollPane(moleculeSelection);
        analScrollPane.setPreferredSize(new Dimension(1000, 600));
        this.add((Component)analScrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, "South");
        JButton allButton = new JButton("All");
        allButton.setActionCommand("SelectAll");
        allButton.setToolTipText("<html>Select all</html>");
        buttonPanel.add(allButton);
        allButton.addActionListener(this);
        JButton noneButton = new JButton("None");
        noneButton.setActionCommand("SelectNone");
        noneButton.setToolTipText("<html>Select none</html>");
        buttonPanel.add(noneButton);
        noneButton.addActionListener(this);
        JButton invertButton = new JButton("Invert");
        invertButton.setActionCommand("Invert");
        invertButton.setToolTipText("<html>Invert selection</html>");
        buttonPanel.add(invertButton);
        invertButton.addActionListener(this);
        JLabel emptyLabel = new JLabel("   ");
        buttonPanel.add(emptyLabel);
        this.button_ = new JButton("OK");
        this.button_.setToolTipText("<html>Accept settings</html>");
        this.button_.setActionCommand("AcceptDisplaySettings");
        buttonPanel.add(this.button_);
        this.setVisible(false);
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    public void addActionListener(ActionListener parent) {
        this.button_.addActionListener(parent);
    }

    public void removeActionListener(ActionListener parent) {
        this.button_.removeActionListener(parent);
    }

    public boolean isSelected(String moleculeName) {
        boolean isSelected = false;
        if (this.checkboxes_.containsKey(moleculeName) && this.checkboxes_.get(moleculeName).isSelected()) {
            isSelected = true;
        }
        return isSelected;
    }

    public Vector<String> getSelected() {
        Vector<String> selected = new Vector<String>();
        for (String molName : this.moleculeNames_) {
            if (!this.checkboxes_.containsKey(molName) || !this.checkboxes_.get(molName).isSelected()) continue;
            selected.add(molName);
        }
        return selected;
    }

    public void refreshNames(Vector<String> names) {
        for (int i = 0; i != names.size(); ++i) {
            String newName;
            String oldName = this.moleculeNames_.get(i);
            if (oldName.equalsIgnoreCase(newName = names.get(i))) continue;
            JCheckBox check = this.checkboxes_.get(oldName);
            check.setText(newName);
            check.invalidate();
            check.updateUI();
            this.checkboxes_.put(newName, check);
        }
        this.moleculeNames_ = names;
        this.invalidate();
        this.doLayout();
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("SelectAll") || e.getActionCommand().equalsIgnoreCase("SelectNone") || e.getActionCommand().equalsIgnoreCase("Invert")) {
            for (String name : this.checkboxes_.keySet()) {
                JCheckBox box = this.checkboxes_.get(name);
                if (e.getActionCommand().equalsIgnoreCase("SelectAll")) {
                    box.setSelected(true);
                }
                if (e.getActionCommand().equalsIgnoreCase("SelectNone")) {
                    box.setSelected(false);
                }
                if (!e.getActionCommand().equalsIgnoreCase("Invert")) continue;
                box.setSelected(!box.isSelected());
            }
        }
    }
}

