/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.NoRuleException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.interfaces.rdi.GeneralSettingsPanelListener;
import at.tugraz.genome.lda.listeners.AddChainEquationDocumentListener;
import at.tugraz.genome.lda.listeners.AddChainFragmentDocumentListener;
import at.tugraz.genome.lda.listeners.AddHeadEquationDocumentListener;
import at.tugraz.genome.lda.listeners.AddHeadFragmentDocumentListener;
import at.tugraz.genome.lda.listeners.AddPositionEquationDocumentListener;
import at.tugraz.genome.lda.listeners.ChangeEquationDocumentListener;
import at.tugraz.genome.lda.listeners.ChangeFragmentDocumentListener;
import at.tugraz.genome.lda.listeners.ChangeFragmentFocusListener;
import at.tugraz.genome.lda.msn.FragmentCalculator;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.MSnAnalyzer;
import at.tugraz.genome.lda.msn.RulesContainer;
import at.tugraz.genome.lda.msn.parser.FragRuleParser;
import at.tugraz.genome.lda.msn.vos.FragmentRuleVO;
import at.tugraz.genome.lda.msn.vos.IntensityChainVO;
import at.tugraz.genome.lda.msn.vos.IntensityRuleVO;
import at.tugraz.genome.lda.msn.vos.MSnDebugVO;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.LipidomicsAnalyzer;
import at.tugraz.genome.lda.swing.Range;
import at.tugraz.genome.lda.swing.SpectrumUpdateListener;
import at.tugraz.genome.lda.swing.rdi.FragmentFormulaTextField;
import at.tugraz.genome.lda.swing.rdi.FragmentNameTextField;
import at.tugraz.genome.lda.swing.rdi.GeneralSettingsPanel;
import at.tugraz.genome.lda.swing.rdi.IntegerRangeDocument;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.verifier.EquationVerifier;
import at.tugraz.genome.lda.verifier.FragmentVerifier;
import at.tugraz.genome.lda.vos.rdi.GeneralSettingsVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.parser.spectrummill.ElementConfigParser;
import at.tugraz.genome.maspectras.quantification.CgAreaStatus;
import at.tugraz.genome.maspectras.quantification.CgException;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RuleDefinitionInterface
extends JSplitPane
implements GeneralSettingsPanelListener {
    private static final long serialVersionUID = 6626019779002700255L;
    public JSplitPane topSplitPane_;
    private GridBagLayout gridBayLayout_;
    private JScrollPane permanentHead_ = new JScrollPane();
    private JTabbedPane middleTabSection_;
    private JPanel bottomSectionButtons_;
    private LipidParameterSet data_;
    private int highestMSLevel_;
    private String lipidClassName_;
    private String lipidName_;
    private String lipidAdduct_;
    private double lipidPrecursorValue_;
    private String lipidFormula_;
    private GeneralSettingsVO generalSettingsVO_;
    private String ruleClassIdentifier_;
    private Hashtable<String, FragmentRuleVO> headFragmentRules_;
    private Vector<IntensityRuleVO> headIntensityRules_;
    private Hashtable<String, FragmentRuleVO> chainFragmentRules_;
    private Vector<IntensityRuleVO> chainIntensityRules_;
    private Vector<IntensityRuleVO> positionIntensityRules_;
    private Vector<FragmentRuleVO> headFragments_;
    private Vector<FragmentRuleVO> sortedChainFragments_;
    private ElementConfigParser elementParser_ = Settings.getElementParser();
    private String[] possibibilityListPostProcessing_ = new String[]{"true", "false"};
    LipidomicsAnalyzer analyzer_;
    private JTextField fragRuleNameField_;
    private JTextField fragRuleFormulaField_;
    private JTextField fragRuleChargeField_;
    private JTextField fragRuleMsLevelField_;
    private JTextField chainRuleNameField_;
    private JTextField chainRuleFormulaField_;
    private JTextField chainRuleChargeField_;
    private JTextField chainRuleMsLevelField_;
    private JComboBox<Object> fragRuleMandatoryCombo_;
    private JComboBox<Object> chainRuleMandatoryCombo_;
    private JLabel fragRuleOK_;
    private JLabel chainRuleOK_;
    private URL resource1_;
    private URL redCrossPicture_;
    private JPanel headRuleTab_;
    private JPanel chainTab_;
    private JPanel positionTab_;
    private JTextField equRuleEquationField_;
    private JComboBox<Object> equRuleMandatoryCombo_;
    private JLabel equRuleOK_;
    private JLabel positionRuleOK_;
    private JTextField positionEquationField_;
    private JComboBox<Object> positionRuleMandatoryCombo_;
    private JLabel equChainRuleOK_;
    private JTextField equChainRuleEquationField_;
    private JComboBox<Object> equChainRuleMandatoryCombo_;
    private SpectrumUpdateListener spectrumUpdater_;
    private JDialog showHeadDetails_;
    MSnAnalyzer msnAnalyzer_;
    public boolean errorMessageNeeded_ = false;
    public FragmentVerifier[] headFragmentFormulaVerifier_;
    public FragmentVerifier[] headFragmentChargeVerifier_;
    public FragmentVerifier[] headFragmentMsLevelVerifier_;
    private JTextField headFragRuleName_;
    public static JTextField[] headRuleFormulas_;
    public static JTextField[] headRuleCharges_;
    public static JTextField[] headRuleMSLevels_;
    public FragmentVerifier[] chainFragmentFormulaVerifier_;
    public FragmentVerifier[] chainFragmentChargeVerifier_;
    public FragmentVerifier[] chainFragmentMsLevelVerifier_;
    private JTextField chainFragRuleName_;
    public static JTextField[] chainRuleFormulas_;
    public static JTextField[] chainRuleCharges_;
    public static JTextField[] chainRuleMSLevels_;
    public JComboBox<Object> fragRuleMandatoryField_;
    private boolean[] headFragmentMandatories_;
    private boolean[] chainFragmentMandatories_;
    public EquationVerifier[] headEquationVerifier_;
    public JTextField[] headRuleEquationFields_;
    private boolean[] headEquationMandatories_;
    public EquationVerifier[] chainEquationVerifier_;
    public JTextField[] chainRuleEquationFields_;
    private boolean[] chainEquationMandatories_;
    public EquationVerifier[] positionEquationVerifier_;
    public JTextField[] positionRuleEquationFields_;
    private boolean[] positionEquationMandatories_;
    public static final String CACHE_DIR = "cache";
    private static final int TYPE_HEAD = 1;
    private static final int TYPE_CHAIN = 2;
    private static final int TYPE_POSITION = 3;
    private final int MIN_MSLEVEL = 2;
    private GeneralSettingsPanel generalSettings_;
    private boolean showFragmentTabs_ = true;

    public void createPanel() {
        this.generalTopSection();
        this.ruleTabsSection();
        this.topSplitPane_ = new JSplitPane(0);
        this.topSplitPane_.setDividerSize(0);
        this.topSplitPane_.setTopComponent(this.permanentHead_);
        this.topSplitPane_.setBottomComponent(this.middleTabSection_);
        this.topSplitPane_.setResizeWeight(0.4);
        this.setTopComponent(this.topSplitPane_);
    }

    public JPanel makeFinalButtonSection() {
        this.finalButtonsSection();
        return this.bottomSectionButtons_;
    }

    public void generalTopSection() {
        JPanel permanent = new JPanel();
        this.gridBayLayout_ = new GridBagLayout();
        permanent.setLayout(this.gridBayLayout_);
        JLabel spaceClass1 = new JLabel("    ");
        this.gridBayLayout_.setConstraints(spaceClass1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel lipidClass = new JLabel("  Lipid Class  ");
        this.gridBayLayout_.setConstraints(lipidClass, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        final JTextField lipidClassField = new JTextField();
        this.gridBayLayout_.setConstraints(lipidClassField, new GridBagConstraints(1, 1, 1, 1, 1000.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        lipidClassField.setColumns(15);
        lipidClassField.setText(this.lipidClassName_);
        lipidClassField.setToolTipText("Enter the lipid class here!");
        JLabel adductClass = new JLabel("  Adduct  ");
        this.gridBayLayout_.setConstraints(adductClass, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        final JTextField adductClassField = new JTextField();
        this.gridBayLayout_.setConstraints(adductClassField, new GridBagConstraints(1, 2, 1, 1, 1000.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        adductClassField.setColumns(15);
        adductClassField.setText(this.lipidAdduct_);
        adductClassField.setToolTipText("Enter the adduct here!");
        JLabel nameClass = new JLabel("  Name  ");
        this.gridBayLayout_.setConstraints(nameClass, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        final JTextField nameClassField = new JTextField();
        this.gridBayLayout_.setConstraints(nameClassField, new GridBagConstraints(1, 3, 1, 1, 1000.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        nameClassField.setColumns(15);
        nameClassField.setText(this.lipidName_);
        nameClassField.setEditable(true);
        nameClassField.setToolTipText("Enter the full name with the _RT here!");
        JLabel precursorClass = new JLabel("  Precursor  ");
        this.gridBayLayout_.setConstraints(precursorClass, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        final JTextField precursorClassField = new JTextField();
        this.gridBayLayout_.setConstraints(precursorClassField, new GridBagConstraints(3, 1, 1, 1, 1000.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        precursorClassField.setColumns(15);
        precursorClassField.setText(Double.toString(this.lipidPrecursorValue_));
        precursorClassField.setEditable(true);
        precursorClassField.setToolTipText("Enter the precursor here!");
        JLabel formulaLabel = new JLabel("  Neutral formula  ");
        this.gridBayLayout_.setConstraints(formulaLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        final JTextField formulaField = new JTextField();
        this.gridBayLayout_.setConstraints(formulaField, new GridBagConstraints(3, 2, 1, 1, 1000.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        formulaField.setColumns(15);
        formulaField.setText(this.lipidFormula_);
        formulaField.setEditable(true);
        formulaField.setToolTipText("Enter the precursor here!");
        JLabel spaceClass2 = new JLabel("    ");
        this.gridBayLayout_.setConstraints(spaceClass2, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JButton changeSettingsClass = new JButton("Change Settings");
        this.gridBayLayout_.setConstraints(changeSettingsClass, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        changeSettingsClass.setToolTipText("Changes the settings and refreshes the spectrum");
        changeSettingsClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleDefinitionInterface.this.deleteDetailsBoxes();
                boolean error = false;
                RuleDefinitionInterface.this.ruleClassIdentifier_ = StaticUtils.getRuleName(lipidClassField.getText(), adductClassField.getText());
                try {
                    RuleDefinitionInterface.this.getRules();
                }
                catch (NoRuleException e1) {
                    int reply = JOptionPane.showConfirmDialog(RuleDefinitionInterface.this.topSplitPane_, "This class does not exist. Create new one?", "Create new class", 0);
                    if (reply == 0) {
                        error = false;
                        RuleDefinitionInterface.this.setEverythingNull();
                        RuleDefinitionInterface.this.lipidClassName_ = lipidClassField.getText();
                        RuleDefinitionInterface.this.lipidAdduct_ = adductClassField.getText();
                        RuleDefinitionInterface.this.showFragmentTabs_ = false;
                    } else {
                        error = true;
                    }
                }
                catch (SpectrummillParserException e1) {
                    JOptionPane.showMessageDialog(RuleDefinitionInterface.this.topSplitPane_, e1.getMessage());
                }
                catch (RulesException e1) {
                    JOptionPane.showMessageDialog(RuleDefinitionInterface.this.topSplitPane_, e1.getMessage());
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(RuleDefinitionInterface.this.topSplitPane_, e1.getMessage());
                }
                if (!error) {
                    RuleDefinitionInterface.this.lipidClassName_ = lipidClassField.getText();
                    RuleDefinitionInterface.this.lipidAdduct_ = adductClassField.getText();
                    try {
                        RuleDefinitionInterface.this.lipidPrecursorValue_ = Double.parseDouble(precursorClassField.getText());
                        RuleDefinitionInterface.this.lipidFormula_ = formulaField.getText();
                        RuleDefinitionInterface.this.lipidName_ = nameClassField.getText();
                        RuleDefinitionInterface.this.data_.setNameString(nameClassField.getText());
                        Float mz = Float.valueOf(Float.parseFloat(precursorClassField.getText()));
                        if (StaticUtils.checkChemicalFormula(formulaField.getText())) {
                            RuleDefinitionInterface.this.data_ = new LipidParameterSet(mz.floatValue(), RuleDefinitionInterface.this.data_.getName(), RuleDefinitionInterface.this.data_.getDoubleBonds(), adductClassField.getText(), RuleDefinitionInterface.this.data_.getPreciseRT(), formulaField.getText(), "", 1, RuleDefinitionInterface.this.data_.getOhNumber());
                            ((RuleDefinitionInterface)RuleDefinitionInterface.this).data_.LowerMzBand = LipidomicsConstants.getCoarseChromMzTolerance(mz.floatValue());
                            ((RuleDefinitionInterface)RuleDefinitionInterface.this).data_.UpperMzBand = LipidomicsConstants.getCoarseChromMzTolerance(mz.floatValue());
                            RuleDefinitionInterface.this.refreshMiddleWithoutCurrentGenerals(0);
                            RuleDefinitionInterface.this.paintNewSpectra(true);
                        }
                    }
                    catch (NumberFormatException nfx) {
                        new WarningMessage(new JFrame(), "Error", "The entered precursor m/z value is not double format!");
                    }
                }
            }
        });
        permanent.add(spaceClass1);
        permanent.add(lipidClass);
        permanent.add(lipidClassField);
        permanent.add(adductClass);
        permanent.add(adductClassField);
        permanent.add(precursorClass);
        permanent.add(precursorClassField);
        permanent.add(formulaLabel);
        permanent.add(formulaField);
        permanent.add(nameClass);
        permanent.add(nameClassField);
        permanent.add(spaceClass2);
        permanent.add(changeSettingsClass);
        this.permanentHead_ = new JScrollPane(permanent);
    }

    public void ruleTabsSection() {
        this.middleTabSection_ = new JTabbedPane(1, 1);
        this.createGeneralTab();
        this.createHeadRuleTab();
        this.createChainTab();
        this.createPositionTab();
        this.middleTabSection_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (RuleDefinitionInterface.this.showFragmentTabs_ && !RuleDefinitionInterface.this.generalSettings_.updateGeneralEntries(false)) {
                    RuleDefinitionInterface.this.middleTabSection_.setSelectedIndex(0);
                }
            }
        });
    }

    public void createGeneralTab() {
        this.generalSettings_ = new GeneralSettingsPanel(this.generalSettingsVO_, this);
        JScrollPane general = new JScrollPane(this.generalSettings_);
        this.middleTabSection_.addTab("General", general);
    }

    public void createHeadRuleTab() {
        int i;
        this.headRuleTab_ = new JPanel();
        this.headRuleTab_.setLayout(this.gridBayLayout_);
        this.resource1_ = RuleDefinitionInterface.class.getResource("/images/uploaded.gif");
        this.redCrossPicture_ = RuleDefinitionInterface.class.getResource("/images/error.gif");
        JLabel fragRuleName = new JLabel("Name");
        this.gridBayLayout_.setConstraints(fragRuleName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel fragRuleFormula = new JLabel("Formula");
        this.gridBayLayout_.setConstraints(fragRuleFormula, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel fragRuleCharge = new JLabel("Charge");
        this.gridBayLayout_.setConstraints(fragRuleCharge, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel fragRuleMsLevel = new JLabel("MS Level");
        this.gridBayLayout_.setConstraints(fragRuleMsLevel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel fragRuleMandatory = new JLabel("Mandatory");
        this.gridBayLayout_.setConstraints(fragRuleMandatory, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.headFragments_ = this.getSortedVector(this.headFragmentRules_, 1);
        if (this.headFragments_.size() != 0) {
            this.headFragmentFormulaVerifier_ = new FragmentVerifier[this.headFragments_.size()];
            headRuleFormulas_ = new JTextField[this.headFragments_.size()];
            this.headFragmentChargeVerifier_ = new FragmentVerifier[this.headFragments_.size()];
            headRuleCharges_ = new JTextField[this.headFragments_.size()];
            this.headFragmentMsLevelVerifier_ = new FragmentVerifier[this.headFragments_.size()];
            headRuleMSLevels_ = new JTextField[this.headFragments_.size()];
            this.headFragmentMandatories_ = new boolean[this.headFragments_.size()];
            for (i = 0; i < this.headFragments_.size(); ++i) {
                final int positionInTable = i;
                this.headFragRuleName_ = new JTextField();
                this.gridBayLayout_.setConstraints(this.headFragRuleName_, new GridBagConstraints(1, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.headFragRuleName_.setColumns(20);
                this.headFragRuleName_.setText(this.headFragments_.elementAt(i).getName());
                this.headFragRuleName_.setEditable(false);
                FragmentVerifier fragmentFormulaVerifier = new FragmentVerifier(this, FragmentVerifier.TYPE_FORMULA, 1);
                JTextField headRuleFormula = fragmentFormulaVerifier.getTextField();
                this.gridBayLayout_.setConstraints(headRuleFormula, new GridBagConstraints(2, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                headRuleFormula.setText(this.headFragments_.elementAt(i).getFormula());
                headRuleFormula.getDocument().addDocumentListener(new ChangeFragmentDocumentListener(this, positionInTable, 0, 1));
                headRuleFormula.addFocusListener(new ChangeFragmentFocusListener(this, positionInTable, 0, 1));
                this.headFragmentFormulaVerifier_[i] = fragmentFormulaVerifier;
                RuleDefinitionInterface.headRuleFormulas_[i] = headRuleFormula;
                FragmentVerifier fragmentChargeVerifier = new FragmentVerifier(this, 2, 1);
                JTextField headRuleCharge = fragmentChargeVerifier.getTextField();
                headRuleCharge.setColumns(5);
                this.gridBayLayout_.setConstraints(headRuleCharge, new GridBagConstraints(3, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                headRuleCharge.setText(Integer.toString(this.headFragments_.elementAt(i).getCharge()));
                headRuleCharge.setEditable(true);
                headRuleCharge.getDocument().addDocumentListener(new ChangeFragmentDocumentListener(this, positionInTable, 1, 1));
                headRuleCharge.addFocusListener(new ChangeFragmentFocusListener(this, positionInTable, 1, 1));
                this.headFragmentChargeVerifier_[i] = fragmentChargeVerifier;
                RuleDefinitionInterface.headRuleCharges_[i] = headRuleCharge;
                FragmentVerifier fragmentMsLevelVerifier = new FragmentVerifier(this, 3, 1);
                JTextField headRuleMSLevel = fragmentMsLevelVerifier.getTextField();
                headRuleMSLevel.setDocument(new IntegerRangeDocument(2, this.highestMSLevel_));
                headRuleMSLevel.setColumns(5);
                headRuleMSLevel.setText(Integer.toString(this.headFragments_.elementAt(i).getMsLevel()));
                this.gridBayLayout_.setConstraints(headRuleMSLevel, new GridBagConstraints(4, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                headRuleMSLevel.setEditable(true);
                headRuleMSLevel.getDocument().addDocumentListener(new ChangeFragmentDocumentListener(this, positionInTable, 2, 1));
                headRuleMSLevel.addFocusListener(new ChangeFragmentFocusListener(this, positionInTable, 2, 1));
                this.headFragmentMsLevelVerifier_[i] = fragmentMsLevelVerifier;
                RuleDefinitionInterface.headRuleMSLevels_[i] = headRuleMSLevel;
                final JComboBox<String> fragRuleMandatoryField = new JComboBox<String>(this.possibibilityListPostProcessing_);
                if (this.headFragments_.elementAt(i).isMandatory() == 1) {
                    fragRuleMandatoryField.setSelectedIndex(0);
                } else {
                    fragRuleMandatoryField.setSelectedIndex(1);
                }
                this.gridBayLayout_.setConstraints(fragRuleMandatoryField, new GridBagConstraints(5, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                fragRuleMandatoryField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent eventSource) {
                        ((RuleDefinitionInterface)RuleDefinitionInterface.this).headFragmentMandatories_[positionInTable] = RuleDefinitionInterface.this.intToBoolean(fragRuleMandatoryField.getSelectedIndex());
                        RuleDefinitionInterface.this.refreshTextfieldToVerifie(positionInTable, 0, 1);
                        RuleDefinitionInterface.this.checkFragmentWithErrors(positionInTable, 2, 1);
                    }
                });
                JButton deleteButton = new JButton();
                this.gridBayLayout_.setConstraints(deleteButton, new GridBagConstraints(6, i + 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                deleteButton.setToolTipText("Deletes this fragment");
                try {
                    BufferedImage img = ImageIO.read(this.getClass().getResource("/images/error.gif"));
                    deleteButton.setIcon(new ImageIcon(img));
                }
                catch (IOException img) {
                    // empty catch block
                }
                final String key = this.headFragments_.elementAt(i).getName();
                deleteButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        int reply = JOptionPane.showConfirmDialog(RuleDefinitionInterface.this.topSplitPane_, "Delete \"" + ((FragmentRuleVO)RuleDefinitionInterface.this.headFragmentRules_.get(key)).getName() + "\" rule?", "Delete Rule", 0);
                        if (reply == 0) {
                            RuleDefinitionInterface.this.headFragmentRules_.remove(key);
                            RuleDefinitionInterface.this.deleteDependingRules(key, 1);
                            RuleDefinitionInterface.this.refreshMiddle(1);
                            RuleDefinitionInterface.this.paintNewSpectra(false);
                        }
                    }
                });
                this.headRuleTab_.add(this.headFragRuleName_);
                this.headRuleTab_.add(headRuleFormulas_[i]);
                this.headRuleTab_.add(headRuleCharges_[i]);
                this.headRuleTab_.add(headRuleMSLevels_[i]);
                this.headRuleTab_.add(fragRuleMandatoryField);
                this.headRuleTab_.add(deleteButton);
            }
        }
        for (i = 0; i < this.headFragments_.size(); ++i) {
            for (int j = 0; j < 3; ++j) {
                this.refreshTextfieldToVerifieFirstTime(i, j, 1);
            }
        }
        this.fragRuleOK_ = new JLabel(new ImageIcon(this.redCrossPicture_));
        this.gridBayLayout_.setConstraints(this.fragRuleOK_, new GridBagConstraints(0, this.headFragments_.size() + 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.headRuleTab_.add(this.fragRuleOK_);
        this.fragRuleOK_.setToolTipText("Shows if the fragment is found in the spectra");
        this.fragRuleNameField_ = new FragmentNameTextField(null, new AddHeadFragmentDocumentListener(this));
        this.gridBayLayout_.setConstraints(this.fragRuleNameField_, new GridBagConstraints(1, this.headFragments_.size() + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.fragRuleNameField_.setToolTipText("Enter the name of the fragment here!");
        this.fragRuleFormulaField_ = new FragmentFormulaTextField(null, new AddHeadFragmentDocumentListener(this));
        this.gridBayLayout_.setConstraints(this.fragRuleFormulaField_, new GridBagConstraints(2, this.headFragments_.size() + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.fragRuleFormulaField_.setToolTipText("Enter the formula of the fragment here!");
        this.fragRuleChargeField_ = new JTextField();
        this.gridBayLayout_.setConstraints(this.fragRuleChargeField_, new GridBagConstraints(3, this.headFragments_.size() + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.fragRuleChargeField_.setColumns(5);
        this.fragRuleChargeField_.setToolTipText("Enter the charge of the fragment here!");
        this.fragRuleChargeField_.getDocument().addDocumentListener(new AddHeadFragmentDocumentListener(this));
        this.fragRuleMsLevelField_ = new JTextField();
        this.fragRuleMsLevelField_.setDocument(new IntegerRangeDocument(2, this.highestMSLevel_));
        this.gridBayLayout_.setConstraints(this.fragRuleMsLevelField_, new GridBagConstraints(4, this.headFragments_.size() + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.fragRuleMsLevelField_.setColumns(5);
        this.fragRuleMsLevelField_.setToolTipText("Enter the ms lever of the fragment here!");
        this.fragRuleMsLevelField_.getDocument().addDocumentListener(new AddHeadFragmentDocumentListener(this));
        this.fragRuleMandatoryCombo_ = new JComboBox<String>(this.possibibilityListPostProcessing_);
        this.fragRuleMandatoryCombo_.setSelectedIndex(1);
        this.gridBayLayout_.setConstraints(this.fragRuleMandatoryCombo_, new GridBagConstraints(5, this.headFragments_.size() + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.fragRuleMandatoryCombo_.setToolTipText("Choose the mandatory here!");
        this.fragRuleMandatoryCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent eventSource) {
                try {
                    RuleDefinitionInterface.this.checkToAddHeadFragment();
                }
                catch (ChemicalFormulaException | HydroxylationEncodingException | LipidCombinameEncodingException | NoRuleException | RulesException | SpectrummillParserException | CgException | IOException e) {
                    e.printStackTrace();
                }
            }
        });
        JButton addFragmentFragRuleButton = new JButton("Add Fragment");
        this.gridBayLayout_.setConstraints(addFragmentFragRuleButton, new GridBagConstraints(1, this.headFragments_.size() + 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        addFragmentFragRuleButton.setToolTipText("Adds the fragment to the others");
        addFragmentFragRuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    FragmentRuleVO ruleVO = new FragmentRuleVO(RuleDefinitionInterface.this.fragRuleNameField_.getText(), RuleDefinitionInterface.this.fragRuleFormulaField_.getText(), Integer.parseInt(RuleDefinitionInterface.this.fragRuleChargeField_.getText()), Integer.parseInt(RuleDefinitionInterface.this.fragRuleMsLevelField_.getText()), RuleDefinitionInterface.this.getFragMandatory(RuleDefinitionInterface.this.fragRuleMandatoryCombo_.getSelectedIndex()), RuleDefinitionInterface.this.headFragmentRules_, RuleDefinitionInterface.this.chainFragmentRules_, RuleDefinitionInterface.this.elementParser_);
                    RuleDefinitionInterface.this.headFragmentRules_.put(RuleDefinitionInterface.this.fragRuleNameField_.getText(), ruleVO);
                    RuleDefinitionInterface.this.refreshMiddle(1);
                }
                catch (RulesException e2) {
                    JOptionPane.showMessageDialog(RuleDefinitionInterface.this.topSplitPane_, e2.getMessage());
                }
                catch (NumberFormatException e2) {
                    JOptionPane.showMessageDialog(RuleDefinitionInterface.this.topSplitPane_, e2.getMessage());
                }
            }
        });
        JLabel space1 = new JLabel("     ");
        this.gridBayLayout_.setConstraints(space1, new GridBagConstraints(1, this.headFragments_.size() + 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel equRuleEquation = new JLabel("Equation");
        this.gridBayLayout_.setConstraints(equRuleEquation, new GridBagConstraints(1, this.headFragments_.size() + 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel equRuleMandatory = new JLabel("Mandatory");
        this.gridBayLayout_.setConstraints(equRuleMandatory, new GridBagConstraints(2, this.headFragments_.size() + 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        int headIntensityRulesSize = this.headIntensityRules_.size();
        if (headIntensityRulesSize != 0) {
            this.headEquationVerifier_ = new EquationVerifier[this.headIntensityRules_.size()];
            this.headRuleEquationFields_ = new JTextField[this.headIntensityRules_.size()];
            this.headEquationMandatories_ = new boolean[this.headIntensityRules_.size()];
            int i2 = 0;
            while (i2 < headIntensityRulesSize) {
                final int equationTablePosition = i2;
                EquationVerifier headEquationVerifier = new EquationVerifier(this, 1, equationTablePosition);
                JTextField equRuleEquationField = headEquationVerifier.getTextField();
                equRuleEquationField.setColumns(20);
                this.gridBayLayout_.setConstraints(equRuleEquationField, new GridBagConstraints(1, this.headFragments_.size() + 5 + i2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                equRuleEquationField.setText(this.headIntensityRules_.elementAt(i2).getRuleIdentifier());
                equRuleEquationField.setEditable(true);
                equRuleEquationField.getDocument().addDocumentListener(new ChangeEquationDocumentListener(this, equationTablePosition, 1));
                this.headEquationVerifier_[i2] = headEquationVerifier;
                this.headRuleEquationFields_[i2] = equRuleEquationField;
                final JComboBox<String> equRuleMandatoryField = new JComboBox<String>(this.possibibilityListPostProcessing_);
                if (this.headIntensityRules_.elementAt(i2).isMandatory()) {
                    equRuleMandatoryField.setSelectedIndex(0);
                } else {
                    equRuleMandatoryField.setSelectedIndex(1);
                }
                this.gridBayLayout_.setConstraints(equRuleMandatoryField, new GridBagConstraints(2, this.headFragments_.size() + 5 + i2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                equRuleMandatoryField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((RuleDefinitionInterface)RuleDefinitionInterface.this).headEquationMandatories_[equationTablePosition] = RuleDefinitionInterface.this.intToBoolean(equRuleMandatoryField.getSelectedIndex());
                        RuleDefinitionInterface.this.refreshEquationFieldToVerifie(equationTablePosition, 1);
                    }
                });
                this.headEquationMandatories_[equationTablePosition] = this.intToBoolean(equRuleMandatoryField.getSelectedIndex());
                JButton deleteButton = new JButton();
                this.gridBayLayout_.setConstraints(deleteButton, new GridBagConstraints(3, this.headFragments_.size() + 5 + i2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                deleteButton.setToolTipText("Deletes this equation");
                try {
                    BufferedImage img = ImageIO.read(this.getClass().getResource("/images/error.gif"));
                    deleteButton.setIcon(new ImageIcon(img));
                }
                catch (IOException img) {
                    // empty catch block
                }
                final int currentElement = i2++;
                deleteButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        int reply = JOptionPane.showConfirmDialog(RuleDefinitionInterface.this.topSplitPane_, "Delete \"" + ((IntensityRuleVO)RuleDefinitionInterface.this.headIntensityRules_.elementAt(currentElement)).getRuleIdentifier() + "\" rule?", "Delete Rule", 0);
                        if (reply == 0) {
                            RuleDefinitionInterface.this.headIntensityRules_.remove(currentElement);
                            RuleDefinitionInterface.this.refreshMiddle(1);
                            RuleDefinitionInterface.this.paintNewSpectra(false);
                        }
                    }
                });
                this.headRuleTab_.add(equRuleEquationField);
                this.headRuleTab_.add(equRuleMandatoryField);
                this.headRuleTab_.add(deleteButton);
            }
        }
        for (int i3 = 0; i3 < this.headIntensityRules_.size(); ++i3) {
            this.refreshEquationTextfieldToVerifieFirstTime(i3, 1);
        }
        this.equRuleOK_ = new JLabel(new ImageIcon(this.redCrossPicture_));
        this.gridBayLayout_.setConstraints(this.equRuleOK_, new GridBagConstraints(0, headIntensityRulesSize + this.headFragments_.size() + 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.equRuleOK_.setToolTipText("Shows if the equation is fulfilled");
        this.equRuleEquationField_ = new JTextField();
        this.gridBayLayout_.setConstraints(this.equRuleEquationField_, new GridBagConstraints(1, headIntensityRulesSize + this.headFragments_.size() + 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.equRuleEquationField_.setColumns(20);
        this.equRuleEquationField_.setToolTipText("Enter the equation here!");
        this.equRuleEquationField_.getDocument().addDocumentListener(new AddHeadEquationDocumentListener(this));
        this.equRuleMandatoryCombo_ = new JComboBox<String>(this.possibibilityListPostProcessing_);
        this.equRuleMandatoryCombo_.setSelectedIndex(1);
        this.gridBayLayout_.setConstraints(this.equRuleMandatoryCombo_, new GridBagConstraints(2, headIntensityRulesSize + this.headFragments_.size() + 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.equRuleMandatoryCombo_.setToolTipText("Choose the mandatory here!");
        this.equRuleMandatoryCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RuleDefinitionInterface.this.checkToAddHeadIntensityRule();
                }
                catch (RulesException e0) {
                    new WarningMessage(new JFrame(), "Error", e0.getMessage());
                }
                catch (ChemicalFormulaException | NoRuleException | SpectrummillParserException | CgException | IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        JButton addFragmentEquRuleButton = new JButton("Add Equation");
        this.gridBayLayout_.setConstraints(addFragmentEquRuleButton, new GridBagConstraints(1, headIntensityRulesSize + this.headFragments_.size() + 6, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        addFragmentEquRuleButton.setToolTipText("Adds the equation to the others");
        addFragmentEquRuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    IntensityRuleVO ruleVO = FragRuleParser.extractIntensityVOFromEquation(RuleDefinitionInterface.this.equRuleEquationField_.getText(), 0, 2, FragmentRuleVO.getStringKeyHash(RuleDefinitionInterface.this.headFragmentRules_), FragmentRuleVO.getStringKeyHash(RuleDefinitionInterface.this.chainFragmentRules_), RuleDefinitionInterface.this.generalSettingsVO_.getAmountOfChains());
                    ruleVO.setMandatory(RuleDefinitionInterface.this.getIntensityMandatory(RuleDefinitionInterface.this.equRuleMandatoryCombo_.getSelectedIndex()));
                    RuleDefinitionInterface.this.headIntensityRules_.add(ruleVO);
                    RuleDefinitionInterface.this.refreshMiddle(1);
                    RuleDefinitionInterface.this.paintNewSpectra(false);
                }
                catch (RulesException e2) {
                    JOptionPane.showMessageDialog(RuleDefinitionInterface.this.topSplitPane_, e2.getMessage());
                }
            }
        });
        JLabel space2 = new JLabel("     ");
        this.gridBayLayout_.setConstraints(space2, new GridBagConstraints(0, headIntensityRulesSize + this.headFragments_.size() + 7, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JButton addShowDetailsButton = new JButton("Show Details");
        this.gridBayLayout_.setConstraints(addShowDetailsButton, new GridBagConstraints(1, headIntensityRulesSize + this.headFragments_.size() + 8, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        addShowDetailsButton.setToolTipText("Shows the details about the decision");
        addShowDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    RuleDefinitionInterface.this.msnAnalyzer_ = RuleDefinitionInterface.this.updateMSnAnalyzerToCurrentSettings();
                    Hashtable<String, CgProbe> detectedFragments = RuleDefinitionInterface.this.msnAnalyzer_.getHeadGroupFragments();
                    Hashtable<String, IntensityRuleVO> fulfilledIntensityRules = RuleDefinitionInterface.this.msnAnalyzer_.getFulfilledHeadIntensityRules();
                    RuleDefinitionInterface.this.printInDialogShowDetailsBox(detectedFragments, fulfilledIntensityRules, null, null);
                }
                catch (RulesException rx) {
                    if (rx.getMessage().endsWith("The rules file must contain a [HEAD] or a [CHAINS] section!")) {
                        new WarningMessage(new JFrame(), "Error", "There are no rules entered!");
                    } else {
                        rx.printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (SpectrummillParserException e) {
                    e.printStackTrace();
                }
                catch (CgException e) {
                    e.printStackTrace();
                }
                catch (NoRuleException e) {
                    e.printStackTrace();
                }
                catch (ChemicalFormulaException | HydroxylationEncodingException | LipidCombinameEncodingException e) {
                    e.printStackTrace();
                }
            }
        });
        this.headRuleTab_.add(fragRuleName);
        this.headRuleTab_.add(fragRuleFormula);
        this.headRuleTab_.add(fragRuleCharge);
        this.headRuleTab_.add(fragRuleMsLevel);
        this.headRuleTab_.add(fragRuleMandatory);
        this.headRuleTab_.add(this.fragRuleNameField_);
        this.headRuleTab_.add(this.fragRuleFormulaField_);
        this.headRuleTab_.add(this.fragRuleChargeField_);
        this.headRuleTab_.add(this.fragRuleMsLevelField_);
        this.headRuleTab_.add(this.fragRuleMandatoryCombo_);
        this.headRuleTab_.add(addFragmentFragRuleButton);
        this.headRuleTab_.add(space1);
        this.headRuleTab_.add(this.equRuleOK_);
        this.headRuleTab_.add(equRuleEquation);
        this.headRuleTab_.add(equRuleMandatory);
        this.headRuleTab_.add(this.equRuleEquationField_);
        this.headRuleTab_.add(this.equRuleMandatoryCombo_);
        this.headRuleTab_.add(addFragmentEquRuleButton);
        this.headRuleTab_.add(space2);
        this.headRuleTab_.add(addShowDetailsButton);
        this.headRuleTab_.setVisible(this.showFragmentTabs_);
        JScrollPane headRule = new JScrollPane(this.headRuleTab_);
        this.middleTabSection_.addTab("Head Rules", headRule);
    }

    private void deletePossibleDummy() {
        if (this.headFragmentRules_.containsKey("EMPTY")) {
            this.headFragmentRules_.remove("EMPTY");
        }
        this.headFragments_ = this.getSortedVector(this.headFragmentRules_, 1);
    }

    public void createChainTab() {
        int i;
        this.chainTab_ = new JPanel();
        this.chainTab_.setLayout(this.gridBayLayout_);
        JLabel chainRuleName = new JLabel("Name");
        this.gridBayLayout_.setConstraints(chainRuleName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel chainRuleFormula = new JLabel("Formula");
        this.gridBayLayout_.setConstraints(chainRuleFormula, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel chainRuleCharge = new JLabel("Charge");
        this.gridBayLayout_.setConstraints(chainRuleCharge, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel chainRuleMsLevel = new JLabel("MS Level");
        this.gridBayLayout_.setConstraints(chainRuleMsLevel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel chainRuleMandatory = new JLabel("Mandatory");
        this.gridBayLayout_.setConstraints(chainRuleMandatory, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.sortedChainFragments_ = this.getSortedVector(this.chainFragmentRules_, 2);
        if (this.sortedChainFragments_.size() != 0) {
            this.chainFragmentFormulaVerifier_ = new FragmentVerifier[this.chainFragmentRules_.size()];
            chainRuleFormulas_ = new JTextField[this.chainFragmentRules_.size()];
            this.chainFragmentChargeVerifier_ = new FragmentVerifier[this.chainFragmentRules_.size()];
            chainRuleCharges_ = new JTextField[this.chainFragmentRules_.size()];
            this.chainFragmentMsLevelVerifier_ = new FragmentVerifier[this.chainFragmentRules_.size()];
            chainRuleMSLevels_ = new JTextField[this.chainFragmentRules_.size()];
            this.chainFragmentMandatories_ = new boolean[this.chainFragmentRules_.size()];
            for (i = 0; i < this.sortedChainFragments_.size(); ++i) {
                final int positionInTable = i;
                this.chainFragRuleName_ = new JTextField();
                this.gridBayLayout_.setConstraints(this.chainFragRuleName_, new GridBagConstraints(1, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.chainFragRuleName_.setColumns(20);
                this.chainFragRuleName_.setText(this.sortedChainFragments_.elementAt(i).getName());
                this.chainFragRuleName_.setEditable(false);
                FragmentVerifier chainFragmentFormulaVerifier = new FragmentVerifier(this, FragmentVerifier.TYPE_FORMULA, 2);
                JTextField chainRuleFormulaField = chainFragmentFormulaVerifier.getTextField();
                this.gridBayLayout_.setConstraints(chainRuleFormulaField, new GridBagConstraints(2, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                chainRuleFormulaField.setText(this.sortedChainFragments_.elementAt(i).getFormula());
                chainRuleFormulaField.getDocument().addDocumentListener(new ChangeFragmentDocumentListener(this, positionInTable, 0, 2));
                chainRuleFormulaField.addFocusListener(new ChangeFragmentFocusListener(this, positionInTable, 0, 2));
                this.chainFragmentFormulaVerifier_[i] = chainFragmentFormulaVerifier;
                RuleDefinitionInterface.chainRuleFormulas_[i] = chainRuleFormulaField;
                FragmentVerifier chainFragmentChargeVerifier = new FragmentVerifier(this, 2, 2);
                JTextField chainRuleChargeField = chainFragmentChargeVerifier.getTextField();
                chainRuleChargeField.setColumns(5);
                this.gridBayLayout_.setConstraints(chainRuleChargeField, new GridBagConstraints(3, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                chainRuleChargeField.setText(Integer.toString(this.sortedChainFragments_.elementAt(i).getCharge()));
                chainRuleChargeField.setEditable(true);
                chainRuleChargeField.getDocument().addDocumentListener(new ChangeFragmentDocumentListener(this, positionInTable, 1, 2));
                chainRuleChargeField.addFocusListener(new ChangeFragmentFocusListener(this, positionInTable, 1, 2));
                this.chainFragmentChargeVerifier_[i] = chainFragmentChargeVerifier;
                RuleDefinitionInterface.chainRuleCharges_[i] = chainRuleChargeField;
                FragmentVerifier chainFragmentMsLevelVerifier = new FragmentVerifier(this, 3, 2);
                JTextField chainRuleMsLevelField = chainFragmentMsLevelVerifier.getTextField();
                chainRuleMsLevelField.setDocument(new IntegerRangeDocument(2, this.highestMSLevel_));
                chainRuleMsLevelField.setColumns(5);
                this.gridBayLayout_.setConstraints(chainRuleMsLevelField, new GridBagConstraints(4, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                chainRuleMsLevelField.setText(Integer.toString(this.sortedChainFragments_.elementAt(i).getMsLevel()));
                chainRuleMsLevelField.setEditable(true);
                chainRuleMsLevelField.getDocument().addDocumentListener(new ChangeFragmentDocumentListener(this, positionInTable, 2, 2));
                chainRuleMsLevelField.addFocusListener(new ChangeFragmentFocusListener(this, positionInTable, 2, 2));
                this.chainFragmentMsLevelVerifier_[i] = chainFragmentMsLevelVerifier;
                RuleDefinitionInterface.chainRuleMSLevels_[i] = chainRuleMsLevelField;
                final JComboBox<String> chainRuleMandatoryField = new JComboBox<String>(this.possibibilityListPostProcessing_);
                if (this.sortedChainFragments_.elementAt(i).isMandatory() == 1) {
                    chainRuleMandatoryField.setSelectedIndex(0);
                } else {
                    chainRuleMandatoryField.setSelectedIndex(1);
                }
                this.gridBayLayout_.setConstraints(chainRuleMandatoryField, new GridBagConstraints(5, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                chainRuleMandatoryField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((RuleDefinitionInterface)RuleDefinitionInterface.this).chainFragmentMandatories_[positionInTable] = RuleDefinitionInterface.this.intToBoolean(chainRuleMandatoryField.getSelectedIndex());
                        RuleDefinitionInterface.this.refreshTextfieldToVerifie(positionInTable, 0, 2);
                        RuleDefinitionInterface.this.checkFragmentWithErrors(positionInTable, 2, 2);
                    }
                });
                JButton deleteButton = new JButton();
                this.gridBayLayout_.setConstraints(deleteButton, new GridBagConstraints(6, i + 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                deleteButton.setToolTipText("Deletes this fragment");
                try {
                    BufferedImage img = ImageIO.read(this.getClass().getResource("/images/error.gif"));
                    deleteButton.setIcon(new ImageIcon(img));
                }
                catch (IOException img) {
                    // empty catch block
                }
                final String key = this.sortedChainFragments_.elementAt(i).getName();
                deleteButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        int reply = JOptionPane.showConfirmDialog(RuleDefinitionInterface.this.topSplitPane_, "Delete \"" + ((FragmentRuleVO)RuleDefinitionInterface.this.chainFragmentRules_.get(key)).getName() + "\" rule?", "Delete Rule", 0);
                        if (reply == 0) {
                            RuleDefinitionInterface.this.chainFragmentRules_.remove(key);
                            RuleDefinitionInterface.this.deleteDependingRules(key, 2);
                            RuleDefinitionInterface.this.refreshMiddle(2);
                            RuleDefinitionInterface.this.paintNewSpectra(false);
                        }
                    }
                });
                this.chainTab_.add(this.chainFragRuleName_);
                this.chainTab_.add(chainRuleFormulas_[i]);
                this.chainTab_.add(chainRuleCharges_[i]);
                this.chainTab_.add(chainRuleMSLevels_[i]);
                this.chainTab_.add(chainRuleMandatoryField);
                this.chainTab_.add(deleteButton);
            }
        }
        for (i = 0; i < this.sortedChainFragments_.size(); ++i) {
            for (int j = 0; j < 3; ++j) {
                this.refreshTextfieldToVerifieFirstTime(i, j, 2);
            }
        }
        this.chainRuleOK_ = new JLabel(new ImageIcon(this.redCrossPicture_));
        this.gridBayLayout_.setConstraints(this.chainRuleOK_, new GridBagConstraints(0, this.chainFragmentRules_.size() + 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.chainTab_.add(this.chainRuleOK_);
        this.chainRuleOK_.setToolTipText("Shows if the fragment is found in the spectra");
        this.chainRuleNameField_ = new FragmentNameTextField(null, new AddChainFragmentDocumentListener(this));
        this.gridBayLayout_.setConstraints(this.chainRuleNameField_, new GridBagConstraints(1, this.chainFragmentRules_.size() + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.chainRuleNameField_.setToolTipText("Enter name of the fragment here!");
        this.chainRuleFormulaField_ = new FragmentFormulaTextField(null, new AddChainFragmentDocumentListener(this));
        this.gridBayLayout_.setConstraints(this.chainRuleFormulaField_, new GridBagConstraints(2, this.chainFragmentRules_.size() + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.chainRuleFormulaField_.setToolTipText("Enter formula of the fragment here!");
        this.chainRuleChargeField_ = new JTextField();
        this.gridBayLayout_.setConstraints(this.chainRuleChargeField_, new GridBagConstraints(3, this.chainFragmentRules_.size() + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.chainRuleChargeField_.setColumns(5);
        this.chainRuleChargeField_.setToolTipText("Enter the charge of the fragment here!");
        this.chainRuleChargeField_.getDocument().addDocumentListener(new AddChainFragmentDocumentListener(this));
        this.chainRuleMsLevelField_ = new JTextField();
        this.chainRuleMsLevelField_.setDocument(new IntegerRangeDocument(2, this.highestMSLevel_));
        this.gridBayLayout_.setConstraints(this.chainRuleMsLevelField_, new GridBagConstraints(4, this.chainFragmentRules_.size() + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.chainRuleMsLevelField_.setColumns(5);
        this.chainRuleMsLevelField_.setVisible(true);
        this.chainRuleMsLevelField_.setToolTipText("Enter the ms lever of the fragment here!");
        this.chainRuleMsLevelField_.getDocument().addDocumentListener(new AddChainFragmentDocumentListener(this));
        this.chainRuleMandatoryCombo_ = new JComboBox<String>(this.possibibilityListPostProcessing_);
        this.chainRuleMandatoryCombo_.setSelectedIndex(1);
        this.gridBayLayout_.setConstraints(this.chainRuleMandatoryCombo_, new GridBagConstraints(5, this.chainFragmentRules_.size() + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.chainRuleMandatoryCombo_.setToolTipText("Choose the mandatory here!");
        this.chainRuleMandatoryCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RuleDefinitionInterface.this.checkToAddChainFragment();
                }
                catch (ChemicalFormulaException | HydroxylationEncodingException | LipidCombinameEncodingException | NoRuleException | RulesException | SpectrummillParserException | CgException | IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        JButton addFragmentChainRuleButton = new JButton("Add Fragment");
        this.gridBayLayout_.setConstraints(addFragmentChainRuleButton, new GridBagConstraints(1, this.chainFragmentRules_.size() + 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        addFragmentChainRuleButton.setToolTipText("Adds the fragment to the others");
        addFragmentChainRuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    FragmentRuleVO ruleVO = new FragmentRuleVO(RuleDefinitionInterface.this.chainRuleNameField_.getText(), RuleDefinitionInterface.this.chainRuleFormulaField_.getText(), Integer.parseInt(RuleDefinitionInterface.this.chainRuleChargeField_.getText()), Integer.parseInt(RuleDefinitionInterface.this.chainRuleMsLevelField_.getText()), RuleDefinitionInterface.this.getFragMandatory(RuleDefinitionInterface.this.chainRuleMandatoryCombo_.getSelectedIndex()), RuleDefinitionInterface.this.headFragmentRules_, RuleDefinitionInterface.this.chainFragmentRules_, RuleDefinitionInterface.this.elementParser_);
                    RuleDefinitionInterface.this.chainFragmentRules_.put(RuleDefinitionInterface.this.chainRuleNameField_.getText(), ruleVO);
                    RuleDefinitionInterface.this.refreshMiddle(2);
                }
                catch (RulesException e2) {
                    JOptionPane.showMessageDialog(RuleDefinitionInterface.this.topSplitPane_, e2.getMessage());
                }
                catch (NumberFormatException e2) {
                    JOptionPane.showMessageDialog(RuleDefinitionInterface.this.topSplitPane_, e2.getMessage());
                }
            }
        });
        JLabel space4 = new JLabel("     ");
        this.gridBayLayout_.setConstraints(space4, new GridBagConstraints(1, this.chainFragmentRules_.size() + 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel equChainRuleEquation = new JLabel("Equation");
        this.gridBayLayout_.setConstraints(equChainRuleEquation, new GridBagConstraints(1, this.chainFragmentRules_.size() + 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel equChainRuleMandatory = new JLabel("Mandatory");
        this.gridBayLayout_.setConstraints(equChainRuleMandatory, new GridBagConstraints(2, this.chainFragmentRules_.size() + 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        int chainIntensityRulesSize = this.chainIntensityRules_.size();
        if (chainIntensityRulesSize != 0) {
            this.chainEquationVerifier_ = new EquationVerifier[this.chainIntensityRules_.size()];
            this.chainRuleEquationFields_ = new JTextField[this.chainIntensityRules_.size()];
            this.chainEquationMandatories_ = new boolean[this.chainIntensityRules_.size()];
            int i2 = 0;
            while (i2 < chainIntensityRulesSize) {
                final int equationTablePosition = i2;
                EquationVerifier chainEquationVerifier = new EquationVerifier(this, 2, equationTablePosition);
                JTextField equChainRuleEquationField = chainEquationVerifier.getTextField();
                equChainRuleEquationField.setColumns(20);
                this.gridBayLayout_.setConstraints(equChainRuleEquationField, new GridBagConstraints(1, this.chainFragmentRules_.size() + 5 + i2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                equChainRuleEquationField.setText(this.chainIntensityRules_.elementAt(i2).getRuleIdentifier());
                equChainRuleEquationField.setEditable(true);
                equChainRuleEquationField.getDocument().addDocumentListener(new ChangeEquationDocumentListener(this, equationTablePosition, 2));
                this.chainEquationVerifier_[i2] = chainEquationVerifier;
                this.chainRuleEquationFields_[i2] = equChainRuleEquationField;
                final JComboBox<String> equChainRuleMandatoryField = new JComboBox<String>(this.possibibilityListPostProcessing_);
                if (this.chainIntensityRules_.elementAt(i2).isMandatory()) {
                    equChainRuleMandatoryField.setSelectedIndex(0);
                } else {
                    equChainRuleMandatoryField.setSelectedIndex(1);
                }
                this.gridBayLayout_.setConstraints(equChainRuleMandatoryField, new GridBagConstraints(2, this.chainFragmentRules_.size() + 5 + i2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                equChainRuleMandatoryField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((RuleDefinitionInterface)RuleDefinitionInterface.this).chainEquationMandatories_[equationTablePosition] = RuleDefinitionInterface.this.intToBoolean(equChainRuleMandatoryField.getSelectedIndex());
                        RuleDefinitionInterface.this.refreshEquationFieldToVerifie(equationTablePosition, 2);
                    }
                });
                this.chainEquationMandatories_[equationTablePosition] = this.intToBoolean(equChainRuleMandatoryField.getSelectedIndex());
                JButton deleteButton = new JButton();
                this.gridBayLayout_.setConstraints(deleteButton, new GridBagConstraints(3, this.chainFragmentRules_.size() + 5 + i2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                deleteButton.setToolTipText("Deletes this equation");
                try {
                    BufferedImage img = ImageIO.read(this.getClass().getResource("/images/error.gif"));
                    deleteButton.setIcon(new ImageIcon(img));
                }
                catch (IOException img) {
                    // empty catch block
                }
                final int currentElement = i2++;
                deleteButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        int reply = JOptionPane.showConfirmDialog(RuleDefinitionInterface.this.topSplitPane_, "Delete \"" + ((IntensityRuleVO)RuleDefinitionInterface.this.chainIntensityRules_.elementAt(currentElement)).getRuleIdentifier() + "\" rule?", "Delete Rule", 0);
                        if (reply == 0) {
                            RuleDefinitionInterface.this.chainIntensityRules_.remove(currentElement);
                            RuleDefinitionInterface.this.refreshMiddle(2);
                            RuleDefinitionInterface.this.paintNewSpectra(false);
                        }
                    }
                });
                this.chainTab_.add(equChainRuleEquationField);
                this.chainTab_.add(equChainRuleMandatoryField);
                this.chainTab_.add(deleteButton);
            }
        }
        this.equChainRuleOK_ = new JLabel(new ImageIcon(this.redCrossPicture_));
        this.gridBayLayout_.setConstraints(this.equChainRuleOK_, new GridBagConstraints(0, chainIntensityRulesSize + this.chainFragmentRules_.size() + 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.equChainRuleOK_.setToolTipText("Shows if the equation is fulfilled");
        this.equChainRuleEquationField_ = new JTextField();
        this.gridBayLayout_.setConstraints(this.equChainRuleEquationField_, new GridBagConstraints(1, chainIntensityRulesSize + this.chainFragmentRules_.size() + 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.equChainRuleEquationField_.setColumns(20);
        this.equChainRuleEquationField_.setToolTipText("Enter the equation here!");
        this.equChainRuleEquationField_.getDocument().addDocumentListener(new AddChainEquationDocumentListener(this));
        this.equChainRuleMandatoryCombo_ = new JComboBox<String>(this.possibibilityListPostProcessing_);
        this.equChainRuleMandatoryCombo_.setSelectedIndex(1);
        this.gridBayLayout_.setConstraints(this.equChainRuleMandatoryCombo_, new GridBagConstraints(2, chainIntensityRulesSize + this.chainFragmentRules_.size() + 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.equChainRuleMandatoryCombo_.setToolTipText("Choose the mandatory here!");
        this.equChainRuleMandatoryCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RuleDefinitionInterface.this.checkToAddChainIntensityRule();
                }
                catch (RulesException e0) {
                    new WarningMessage(new JFrame(), "Error", e0.getMessage());
                }
                catch (ChemicalFormulaException | NoRuleException | SpectrummillParserException | CgException | IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        JButton addFragmentChainRuleButton2 = new JButton("Add Equation");
        this.gridBayLayout_.setConstraints(addFragmentChainRuleButton2, new GridBagConstraints(1, chainIntensityRulesSize + this.chainFragmentRules_.size() + 6, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        addFragmentChainRuleButton2.setToolTipText("Adds the equation to the others");
        addFragmentChainRuleButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    IntensityRuleVO ruleVO = FragRuleParser.extractIntensityVOFromEquation(RuleDefinitionInterface.this.equChainRuleEquationField_.getText(), 0, 3, FragmentRuleVO.getStringKeyHash(RuleDefinitionInterface.this.headFragmentRules_), FragmentRuleVO.getStringKeyHash(RuleDefinitionInterface.this.chainFragmentRules_), RuleDefinitionInterface.this.generalSettingsVO_.getAmountOfChains());
                    ruleVO.setMandatory(RuleDefinitionInterface.this.getIntensityMandatory(RuleDefinitionInterface.this.equChainRuleMandatoryCombo_.getSelectedIndex()));
                    RuleDefinitionInterface.this.chainIntensityRules_.add(ruleVO);
                    RuleDefinitionInterface.this.refreshMiddle(2);
                    RuleDefinitionInterface.this.paintNewSpectra(false);
                }
                catch (RulesException e2) {
                    JOptionPane.showMessageDialog(RuleDefinitionInterface.this.topSplitPane_, e2.getMessage());
                }
            }
        });
        JLabel space5 = new JLabel("     ");
        this.gridBayLayout_.setConstraints(space5, new GridBagConstraints(0, chainIntensityRulesSize + this.chainFragmentRules_.size() + 7, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JButton addChainShowDetailsButton = new JButton("Show Details");
        this.gridBayLayout_.setConstraints(addChainShowDetailsButton, new GridBagConstraints(1, chainIntensityRulesSize + this.chainFragmentRules_.size() + 8, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChainShowDetailsButton.setToolTipText("Shows the details about the decision");
        addChainShowDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    try {
                        RuleDefinitionInterface.this.msnAnalyzer_ = RuleDefinitionInterface.this.updateMSnAnalyzerToCurrentSettings();
                    }
                    catch (ChemicalFormulaException | HydroxylationEncodingException | LipidCombinameEncodingException | NoRuleException e) {
                        e.printStackTrace();
                    }
                    Hashtable<String, Hashtable<String, CgProbe>> chainFragments = RuleDefinitionInterface.this.msnAnalyzer_.getChainFragments();
                    Hashtable<String, Hashtable<String, IntensityChainVO>> fulfilledChainIntensityRules = RuleDefinitionInterface.this.msnAnalyzer_.getFulfilledChainIntensityRules();
                    RuleDefinitionInterface.this.printInDialogShowDetailsBox(null, null, chainFragments, fulfilledChainIntensityRules);
                }
                catch (RulesException rx) {
                    if (rx.getMessage().endsWith("The rules file must contain a [HEAD] or a [CHAINS] section!")) {
                        new WarningMessage(new JFrame(), "Error", "There are no rules entered!");
                    } else {
                        rx.printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (SpectrummillParserException e) {
                    e.printStackTrace();
                }
                catch (ChemicalFormulaException | HydroxylationEncodingException | LipidCombinameEncodingException | CgException e) {
                    e.printStackTrace();
                }
            }
        });
        this.chainTab_.add(chainRuleName);
        this.chainTab_.add(chainRuleFormula);
        this.chainTab_.add(chainRuleCharge);
        this.chainTab_.add(chainRuleMsLevel);
        this.chainTab_.add(chainRuleMandatory);
        this.chainTab_.add(this.chainRuleNameField_);
        this.chainTab_.add(this.chainRuleFormulaField_);
        this.chainTab_.add(this.chainRuleChargeField_);
        this.chainTab_.add(this.chainRuleMsLevelField_);
        this.chainTab_.add(this.chainRuleMandatoryCombo_);
        this.chainTab_.add(addFragmentChainRuleButton);
        this.chainTab_.add(space4);
        this.chainTab_.add(equChainRuleEquation);
        this.chainTab_.add(equChainRuleMandatory);
        this.chainTab_.add(this.equChainRuleOK_);
        this.chainTab_.add(this.equChainRuleEquationField_);
        this.chainTab_.add(this.equChainRuleMandatoryCombo_);
        this.chainTab_.add(addFragmentChainRuleButton2);
        this.chainTab_.add(space5);
        this.chainTab_.add(addChainShowDetailsButton);
        this.chainTab_.setVisible(this.showFragmentTabs_);
        JScrollPane chain = new JScrollPane(this.chainTab_);
        this.middleTabSection_.addTab("Chain", chain);
    }

    public void createPositionTab() {
        this.positionTab_ = new JPanel();
        this.positionTab_.setLayout(this.gridBayLayout_);
        JLabel positionRuleEquation = new JLabel("Equation");
        this.gridBayLayout_.setConstraints(positionRuleEquation, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel positionRuleMandatory = new JLabel("Mandatory");
        this.gridBayLayout_.setConstraints(positionRuleMandatory, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        int positionIntensityRulesSize = this.positionIntensityRules_.size();
        if (positionIntensityRulesSize != 0) {
            this.positionEquationVerifier_ = new EquationVerifier[this.positionIntensityRules_.size()];
            this.positionRuleEquationFields_ = new JTextField[this.positionIntensityRules_.size()];
            this.positionEquationMandatories_ = new boolean[this.positionIntensityRules_.size()];
            int i = 0;
            while (i < positionIntensityRulesSize) {
                final int equationTablePosition = i;
                EquationVerifier positionEquationVerifier = new EquationVerifier(this, 3, equationTablePosition);
                JTextField positionEquationField = positionEquationVerifier.getTextField();
                positionEquationField.setColumns(20);
                this.gridBayLayout_.setConstraints(positionEquationField, new GridBagConstraints(1, 1 + i, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                positionEquationField.setText(this.positionIntensityRules_.elementAt(i).getRuleIdentifier());
                positionEquationField.setEditable(true);
                positionEquationField.getDocument().addDocumentListener(new ChangeEquationDocumentListener(this, equationTablePosition, 3));
                this.positionEquationVerifier_[i] = positionEquationVerifier;
                this.positionRuleEquationFields_[i] = positionEquationField;
                final JComboBox<String> positionMandatoryField = new JComboBox<String>(this.possibibilityListPostProcessing_);
                if (this.positionIntensityRules_.elementAt(i).isMandatory()) {
                    positionMandatoryField.setSelectedIndex(0);
                } else {
                    positionMandatoryField.setSelectedIndex(1);
                }
                this.gridBayLayout_.setConstraints(positionMandatoryField, new GridBagConstraints(2, 1 + i, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                positionMandatoryField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((RuleDefinitionInterface)RuleDefinitionInterface.this).positionEquationMandatories_[equationTablePosition] = RuleDefinitionInterface.this.intToBoolean(positionMandatoryField.getSelectedIndex());
                        RuleDefinitionInterface.this.refreshEquationFieldToVerifie(equationTablePosition, 3);
                    }
                });
                this.positionEquationMandatories_[equationTablePosition] = this.intToBoolean(positionMandatoryField.getSelectedIndex());
                JButton deleteButton = new JButton();
                this.gridBayLayout_.setConstraints(deleteButton, new GridBagConstraints(3, 1 + i, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                deleteButton.setToolTipText("Deletes this equation");
                try {
                    BufferedImage img = ImageIO.read(this.getClass().getResource("/images/error.gif"));
                    deleteButton.setIcon(new ImageIcon(img));
                }
                catch (IOException img) {
                    // empty catch block
                }
                final int currentElement = i++;
                deleteButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        int reply = JOptionPane.showConfirmDialog(RuleDefinitionInterface.this.topSplitPane_, "Delete \"" + ((IntensityRuleVO)RuleDefinitionInterface.this.positionIntensityRules_.elementAt(currentElement)).getRuleIdentifier() + "\" rule?", "Delete Rule", 0);
                        if (reply == 0) {
                            RuleDefinitionInterface.this.positionIntensityRules_.remove(currentElement);
                            RuleDefinitionInterface.this.refreshMiddle(3);
                            RuleDefinitionInterface.this.paintNewSpectra(false);
                        }
                    }
                });
                this.positionTab_.add(positionEquationField);
                this.positionTab_.add(positionMandatoryField);
                this.positionTab_.add(deleteButton);
            }
        }
        this.positionRuleOK_ = new JLabel(new ImageIcon(this.redCrossPicture_));
        this.gridBayLayout_.setConstraints(this.positionRuleOK_, new GridBagConstraints(0, 1 + positionIntensityRulesSize, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.positionRuleOK_.setToolTipText("Shows if the equation is fulfilled");
        this.positionEquationField_ = new JTextField();
        this.gridBayLayout_.setConstraints(this.positionEquationField_, new GridBagConstraints(1, 1 + positionIntensityRulesSize, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.positionEquationField_.setColumns(20);
        this.positionEquationField_.setToolTipText("Enter the equation here!");
        this.positionEquationField_.getDocument().addDocumentListener(new AddPositionEquationDocumentListener(this));
        this.positionRuleMandatoryCombo_ = new JComboBox<String>(this.possibibilityListPostProcessing_);
        this.positionRuleMandatoryCombo_.setSelectedIndex(1);
        this.gridBayLayout_.setConstraints(this.positionRuleMandatoryCombo_, new GridBagConstraints(2, 1 + positionIntensityRulesSize, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.positionRuleMandatoryCombo_.setToolTipText("Choose the mandatory here!");
        this.positionRuleMandatoryCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RuleDefinitionInterface.this.checkToAddPositionRule();
                }
                catch (NoRuleException | RulesException | SpectrummillParserException | CgException | IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        JButton addFragmentPositionButton = new JButton("Add Equation");
        this.gridBayLayout_.setConstraints(addFragmentPositionButton, new GridBagConstraints(1, 6 + positionIntensityRulesSize, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        addFragmentPositionButton.setToolTipText("Adds the equation to the others");
        addFragmentPositionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    IntensityRuleVO ruleVO = FragRuleParser.extractIntensityVOFromEquation(RuleDefinitionInterface.this.positionEquationField_.getText(), 0, 4, FragmentRuleVO.getStringKeyHash(RuleDefinitionInterface.this.headFragmentRules_), FragmentRuleVO.getStringKeyHash(RuleDefinitionInterface.this.chainFragmentRules_), RuleDefinitionInterface.this.generalSettingsVO_.getAmountOfChains());
                    ruleVO.setMandatory(RuleDefinitionInterface.this.getIntensityMandatory(RuleDefinitionInterface.this.positionRuleMandatoryCombo_.getSelectedIndex()));
                    RuleDefinitionInterface.this.positionIntensityRules_.add(ruleVO);
                    RuleDefinitionInterface.this.refreshMiddle(3);
                    RuleDefinitionInterface.this.paintNewSpectra(false);
                }
                catch (RulesException e2) {
                    JOptionPane.showMessageDialog(RuleDefinitionInterface.this.topSplitPane_, e2.getMessage());
                }
            }
        });
        JLabel space3 = new JLabel("     ");
        this.gridBayLayout_.setConstraints(space3, new GridBagConstraints(0, 7 + positionIntensityRulesSize, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JButton addPositionShowDetailsButton = new JButton("Show Details");
        this.gridBayLayout_.setConstraints(addPositionShowDetailsButton, new GridBagConstraints(1, 8 + positionIntensityRulesSize, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        addPositionShowDetailsButton.setToolTipText("Shows the details about the decision");
        addPositionShowDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    RuleDefinitionInterface.this.msnAnalyzer_ = RuleDefinitionInterface.this.updateMSnAnalyzerToCurrentSettings();
                    RuleDefinitionInterface.this.printPositionRecomandation(RuleDefinitionInterface.this.msnAnalyzer_.getResult(), RuleDefinitionInterface.this.msnAnalyzer_.getPositionDefinition());
                }
                catch (RulesException rx) {
                    if (rx.getMessage().endsWith("The rules file must contain a [HEAD] or a [CHAINS] section!")) {
                        new WarningMessage(new JFrame(), "Error", "There are no rules entered!");
                    } else {
                        rx.printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (SpectrummillParserException e) {
                    e.printStackTrace();
                }
                catch (CgException e) {
                    e.printStackTrace();
                }
                catch (NoRuleException e) {
                    e.printStackTrace();
                }
                catch (ChemicalFormulaException | HydroxylationEncodingException | LipidCombinameEncodingException e) {
                    e.printStackTrace();
                }
            }
        });
        this.positionTab_.add(positionRuleEquation);
        this.positionTab_.add(positionRuleMandatory);
        this.positionTab_.add(this.positionRuleOK_);
        this.positionTab_.add(this.positionEquationField_);
        this.positionTab_.add(this.positionRuleMandatoryCombo_);
        this.positionTab_.add(addFragmentPositionButton);
        this.positionTab_.add(space3);
        this.positionTab_.add(addPositionShowDetailsButton);
        JScrollPane position = new JScrollPane(this.positionTab_);
        this.positionTab_.setVisible(this.showFragmentTabs_);
        this.middleTabSection_.addTab("Position", position);
    }

    public void finalButtonsSection() {
        this.bottomSectionButtons_ = new JPanel();
        this.bottomSectionButtons_.setLayout(this.gridBayLayout_);
        JButton showTotalDecisionButton = new JButton("Show Total Decision");
        this.gridBayLayout_.setConstraints(showTotalDecisionButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        showTotalDecisionButton.setToolTipText("Shows the total deciosion");
        showTotalDecisionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleDefinitionInterface.this.printTotalDecisionInBox();
            }
        });
        JButton saveRulesButton = new JButton("Save Rules");
        this.gridBayLayout_.setConstraints(saveRulesButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        saveRulesButton.setVisible(true);
        saveRulesButton.setToolTipText("Saves the rules in the .txt file");
        saveRulesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int reply = JOptionPane.showConfirmDialog(RuleDefinitionInterface.this.topSplitPane_, "Do you want to save the changed Rules? Existing Rules are overwritten and influence the running calculations.", "Save Rules", 0);
                if (reply == 0) {
                    String fileBeforeSave;
                    try {
                        fileBeforeSave = RuleDefinitionInterface.this.readFile("fragRules/" + RuleDefinitionInterface.this.lipidClassName_ + "_" + RuleDefinitionInterface.this.lipidAdduct_ + ".frag.txt");
                        if (fileBeforeSave.length() > 0) {
                            fileBeforeSave = fileBeforeSave.substring(0, fileBeforeSave.length() - 1);
                        }
                    }
                    catch (IOException e1) {
                        fileBeforeSave = "EMPTY";
                    }
                    try {
                        if (RuleDefinitionInterface.this.generalSettings_.checkPercentageFieldsForNumbers()) {
                            RuleDefinitionInterface.this.setRuleClassIdentifier();
                            RuleDefinitionInterface.this.saveRules("default");
                            RuleDefinitionInterface.this.getRules();
                            JOptionPane.showMessageDialog(RuleDefinitionInterface.this.topSplitPane_, "Rules successfully saved.");
                            RuleDefinitionInterface.this.refreshMiddle(0);
                        }
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(RuleDefinitionInterface.this.topSplitPane_, e.getMessage());
                        try {
                            RuleDefinitionInterface.this.writeStringInCurrentFile(fileBeforeSave);
                        }
                        catch (IOException iOException) {}
                    }
                    catch (SpectrummillParserException e) {
                        JOptionPane.showMessageDialog(RuleDefinitionInterface.this.topSplitPane_, e.getMessage());
                        try {
                            RuleDefinitionInterface.this.writeStringInCurrentFile(fileBeforeSave);
                        }
                        catch (IOException iOException) {}
                    }
                    catch (RulesException e) {
                        JOptionPane.showMessageDialog(RuleDefinitionInterface.this.topSplitPane_, e.getMessage());
                        try {
                            RuleDefinitionInterface.this.writeStringInCurrentFile(fileBeforeSave);
                        }
                        catch (IOException iOException) {}
                    }
                    catch (NoRuleException e) {
                        JOptionPane.showMessageDialog(RuleDefinitionInterface.this.topSplitPane_, e.getMessage());
                        try {
                            RuleDefinitionInterface.this.writeStringInCurrentFile(fileBeforeSave);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    try {
                        if (RuleDefinitionInterface.this.readFile(RulesContainer.currentRulesDir_ + "/" + RuleDefinitionInterface.this.lipidClassName_ + "_" + RuleDefinitionInterface.this.lipidAdduct_ + ".frag.txt").contains("EMPTY")) {
                            RuleDefinitionInterface.this.deleteFile(RulesContainer.currentRulesDir_ + "/" + RuleDefinitionInterface.this.lipidClassName_ + "_" + RuleDefinitionInterface.this.lipidAdduct_ + ".frag.txt");
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        this.bottomSectionButtons_.add(showTotalDecisionButton);
        this.bottomSectionButtons_.add(saveRulesButton);
    }

    private void setRuleClassIdentifier() throws RulesException, IOException, SpectrummillParserException {
        this.ruleClassIdentifier_ = StaticUtils.getRuleName(this.lipidClassName_, this.lipidAdduct_);
    }

    private String readFile(String dateiName) throws IOException {
        byte zeichen;
        String text = "";
        FileInputStream leseStrom = new FileInputStream(dateiName);
        do {
            zeichen = (byte)leseStrom.read();
            text = text + (char)zeichen;
        } while (zeichen != -1);
        leseStrom.close();
        return text;
    }

    private void deleteFile(String path) {
        File datei = new File(path);
        if (datei.exists()) {
            datei.delete();
        }
    }

    private void writeStringInCurrentFile(String input) throws IOException {
        String filename = this.lipidClassName_ + "_" + this.lipidAdduct_ + ".frag.txt";
        File file = new File("fragRules/" + filename);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        if (input != null || input != "0") {
            bw.write(input);
        }
        bw.close();
    }

    private void getRulesFromCacheFirst() throws NoRuleException, RulesException, IOException, SpectrummillParserException {
        block5: {
            try {
                this.getRulesFromCertainDirectory(CACHE_DIR);
            }
            catch (NoRuleException nrx) {
                try {
                    this.getRules();
                }
                catch (NoRuleException nrx2) {
                    int reply = JOptionPane.showConfirmDialog(this.topSplitPane_, "This class does not exist. Create new one?", "Create new class", 0);
                    if (reply == 0) {
                        this.setEverythingNull();
                        this.showFragmentTabs_ = false;
                        break block5;
                    }
                    throw nrx2;
                }
            }
        }
    }

    void getRules() throws NoRuleException, RulesException, IOException, SpectrummillParserException {
        Double rtMaxDev = null;
        if (RulesContainer.getRetentionTimeMaxDeviation(this.ruleClassIdentifier_) != null) {
            rtMaxDev = new Double(RulesContainer.getRetentionTimeMaxDeviation(this.ruleClassIdentifier_));
        }
        int faHydroxyRangeStart = -1;
        int faHydroxyRangeStop = -1;
        int lcbHydroxyRangeStart = -1;
        int lcbHydroxyRangeStop = -1;
        if (RulesContainer.getFaHydroxyRange(this.ruleClassIdentifier_) != null && RulesContainer.getFaHydroxyRange(this.ruleClassIdentifier_).getStop() > 0) {
            faHydroxyRangeStart = RulesContainer.getFaHydroxyRange(this.ruleClassIdentifier_).getStart();
            faHydroxyRangeStop = RulesContainer.getFaHydroxyRange(this.ruleClassIdentifier_).getStop();
        }
        if (RulesContainer.getLcbHydroxyRange(this.ruleClassIdentifier_) != null && RulesContainer.getLcbHydroxyRange(this.ruleClassIdentifier_).getStop() > 0) {
            lcbHydroxyRangeStart = RulesContainer.getLcbHydroxyRange(this.ruleClassIdentifier_).getStart();
            lcbHydroxyRangeStop = RulesContainer.getLcbHydroxyRange(this.ruleClassIdentifier_).getStop();
        }
        this.generalSettingsVO_ = new GeneralSettingsVO(new Integer(RulesContainer.getAmountOfChains(this.ruleClassIdentifier_)), new Integer(RulesContainer.getAmountOfAlkylChains(this.ruleClassIdentifier_)), new Integer(RulesContainer.getAmountOfAlkenylChains(this.ruleClassIdentifier_)), new Short(RulesContainer.getAmountOfLCBs(this.ruleClassIdentifier_)), RulesContainer.getAddChainPositions(this.ruleClassIdentifier_), RulesContainer.getChainlibrary(this.ruleClassIdentifier_), RulesContainer.getLcbLibrary(this.ruleClassIdentifier_), faHydroxyRangeStart, faHydroxyRangeStop, lcbHydroxyRangeStart, lcbHydroxyRangeStop, RulesContainer.getCAtomsFromNamePattern(this.ruleClassIdentifier_), RulesContainer.getDoubleBondsFromNamePattern(this.ruleClassIdentifier_), RulesContainer.isSingleChainIdentification(this.ruleClassIdentifier_), RulesContainer.getChainCutoffAsString(this.ruleClassIdentifier_), RulesContainer.getBasePeakCutoffAsString(this.ruleClassIdentifier_), RulesContainer.getSpectrumCoverageMinAsString(this.ruleClassIdentifier_), RulesContainer.isRtPostprocessing(this.ruleClassIdentifier_), RulesContainer.correctRtForParallelModel(this.ruleClassIdentifier_), rtMaxDev, RulesContainer.getMSIdentificationOrder(this.ruleClassIdentifier_));
        this.headFragmentRules_ = RulesContainer.getHeadFragmentRules(this.ruleClassIdentifier_);
        this.headIntensityRules_ = RulesContainer.getHeadIntensityRules(this.ruleClassIdentifier_);
        this.chainFragmentRules_ = RulesContainer.getChainFragmentRules(this.ruleClassIdentifier_);
        this.chainIntensityRules_ = RulesContainer.getChainIntensityRules(this.ruleClassIdentifier_);
        this.positionIntensityRules_ = RulesContainer.getPositionIntensityRules(this.ruleClassIdentifier_);
    }

    void getRulesFromCertainDirectory(String fileDir) throws NoRuleException, RulesException, IOException, SpectrummillParserException {
        Double rtMaxDev = null;
        if (RulesContainer.getRetentionTimeMaxDeviation(this.ruleClassIdentifier_, fileDir) != null) {
            rtMaxDev = new Double(RulesContainer.getRetentionTimeMaxDeviation(this.ruleClassIdentifier_, fileDir));
        }
        int faHydroxyRangeStart = -1;
        int faHydroxyRangeStop = -1;
        int lcbHydroxyRangeStart = -1;
        int lcbHydroxyRangeStop = -1;
        if (RulesContainer.getFaHydroxyRange(this.ruleClassIdentifier_, fileDir) != null && RulesContainer.getFaHydroxyRange(this.ruleClassIdentifier_, fileDir).getStop() > 0) {
            faHydroxyRangeStart = RulesContainer.getFaHydroxyRange(this.ruleClassIdentifier_, fileDir).getStart();
            faHydroxyRangeStop = RulesContainer.getFaHydroxyRange(this.ruleClassIdentifier_, fileDir).getStop();
        }
        if (RulesContainer.getLcbHydroxyRange(this.ruleClassIdentifier_, fileDir) != null && RulesContainer.getLcbHydroxyRange(this.ruleClassIdentifier_, fileDir).getStop() > 0) {
            lcbHydroxyRangeStart = RulesContainer.getLcbHydroxyRange(this.ruleClassIdentifier_, fileDir).getStart();
            lcbHydroxyRangeStop = RulesContainer.getLcbHydroxyRange(this.ruleClassIdentifier_, fileDir).getStop();
        }
        this.generalSettingsVO_ = new GeneralSettingsVO(new Integer(RulesContainer.getAmountOfChains(this.ruleClassIdentifier_, fileDir)), new Integer(RulesContainer.getAmountOfAlkylChains(this.ruleClassIdentifier_, fileDir)), new Integer(RulesContainer.getAmountOfAlkenylChains(this.ruleClassIdentifier_, fileDir)), new Short(RulesContainer.getAmountOfLCBs(this.ruleClassIdentifier_, fileDir)), RulesContainer.getAddChainPositions(this.ruleClassIdentifier_, fileDir), RulesContainer.getChainlibrary(this.ruleClassIdentifier_, fileDir), RulesContainer.getLcbLibrary(this.ruleClassIdentifier_, fileDir), faHydroxyRangeStart, faHydroxyRangeStop, lcbHydroxyRangeStart, lcbHydroxyRangeStop, RulesContainer.getCAtomsFromNamePattern(this.ruleClassIdentifier_, fileDir), RulesContainer.getDoubleBondsFromNamePattern(this.ruleClassIdentifier_, fileDir), RulesContainer.isSingleChainIdentification(this.ruleClassIdentifier_, fileDir), RulesContainer.getChainCutoffAsString(this.ruleClassIdentifier_, fileDir), RulesContainer.getBasePeakCutoffAsString(this.ruleClassIdentifier_, fileDir), RulesContainer.getSpectrumCoverageMinAsString(this.ruleClassIdentifier_, fileDir), RulesContainer.isRtPostprocessing(this.ruleClassIdentifier_, fileDir), RulesContainer.correctRtForParallelModel(this.ruleClassIdentifier_, fileDir), rtMaxDev, RulesContainer.getMSIdentificationOrder(this.ruleClassIdentifier_, fileDir));
        this.headFragmentRules_ = RulesContainer.getHeadFragmentRules(this.ruleClassIdentifier_, fileDir);
        this.headIntensityRules_ = RulesContainer.getHeadIntensityRules(this.ruleClassIdentifier_, fileDir);
        this.chainFragmentRules_ = RulesContainer.getChainFragmentRules(this.ruleClassIdentifier_, fileDir);
        this.chainIntensityRules_ = RulesContainer.getChainIntensityRules(this.ruleClassIdentifier_, fileDir);
        this.positionIntensityRules_ = RulesContainer.getPositionIntensityRules(this.ruleClassIdentifier_, fileDir);
    }

    void refreshMiddleWithoutCurrentGenerals(int tabIndex) {
        this.topSplitPane_.remove(this.middleTabSection_);
        this.topSplitPane_.validate();
        this.ruleTabsSection();
        this.middleTabSection_.setSelectedIndex(tabIndex);
        this.topSplitPane_.setBottomComponent(this.middleTabSection_);
    }

    void refreshMiddle(int tabIndex) {
        this.generalSettingsVO_ = this.generalSettings_.getValues();
        this.topSplitPane_.remove(this.middleTabSection_);
        this.topSplitPane_.validate();
        this.ruleTabsSection();
        this.middleTabSection_.setSelectedIndex(tabIndex);
        this.topSplitPane_.setBottomComponent(this.middleTabSection_);
    }

    public void saveRules(String dir) throws IOException, RulesException, SpectrummillParserException, NoRuleException {
        this.writeRules(dir);
        if (dir == "default") {
            RulesContainer.clearCache();
            this.getRulesFromCertainDirectory(RulesContainer.currentRulesDir_);
        } else {
            RulesContainer.clearCache(dir);
        }
        this.deletePossibleDummy();
    }

    public void writeRules(String dir) throws IOException, RulesException, SpectrummillParserException, NoRuleException {
        FragRuleParser.writeRules(dir, this.lipidClassName_, this.lipidAdduct_, this.generalSettingsVO_, this.headFragments_, this.headIntensityRules_, this.sortedChainFragments_, this.chainIntensityRules_, this.positionIntensityRules_);
    }

    public void saveDummy(String dir) throws IOException, RulesException, SpectrummillParserException, NoRuleException {
        String filename = this.lipidClassName_ + "_" + this.lipidAdduct_ + ".frag.txt";
        File file = dir == "default" ? new File("fragRules/" + filename) : new File(dir + "/" + filename);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write("[GENERAL]\n");
        bw.write("AmountOfChains=0\n");
        bw.write("ChainLibrary=fattyAcidChains.xlsx\n");
        bw.write("CAtomsFromName=(ENTER)\n");
        bw.write("DoubleBondsFromName=(ENTER)\n");
        bw.write("BasePeakCutoff=0.0%\n");
        bw.write("SpectrumCoverage=0.0%\n");
        bw.write("RetentionTimePostprocessing=false\n");
        bw.write("RetentionTimeParallelSeries=false\n");
        bw.write("\n");
        bw.write("[HEAD]\n");
        bw.write("!FRAGMENTS\n");
        FragmentRuleVO ruleVO = new FragmentRuleVO("EMPTY", "CCCC", 1, 2, 0, this.headFragmentRules_, this.chainFragmentRules_, this.elementParser_);
        this.headFragmentRules_.put("EMPTY", ruleVO);
        this.headFragments_ = this.getSortedVector(this.headFragmentRules_, 1);
        if (this.headFragments_.size() != 0) {
            for (int i = 0; i < this.headFragments_.size(); ++i) {
                String mandatory = "false";
                if (this.headFragments_.elementAt(i).isMandatory() == 1) {
                    mandatory = "true";
                }
                bw.write("Name=" + this.headFragments_.elementAt(i).getName() + "\tFormula=" + this.headFragments_.elementAt(i).getFormula() + "\tCharge=" + Integer.toString(this.headFragments_.elementAt(i).getCharge()) + "\tMSLevel=" + Integer.toString(this.headFragments_.elementAt(i).getMsLevel()) + "\tmandatory=" + mandatory + "\n");
            }
            bw.close();
        }
    }

    String getStringMandatory(boolean mandatoryInput) {
        String mandatory = "false";
        if (mandatoryInput) {
            mandatory = "true";
        }
        return mandatory;
    }

    private Vector<FragmentRuleVO> getSortedVector(Hashtable<String, FragmentRuleVO> input, int type) {
        Hashtable<String, FragmentRuleVO> cache = new Hashtable<String, FragmentRuleVO>(input);
        Vector<FragmentRuleVO> output = new Vector<FragmentRuleVO>();
        Hashtable<String, FragmentRuleVO> outputHash = new Hashtable<String, FragmentRuleVO>();
        int before = Integer.MIN_VALUE;
        while (cache.size() > 0 && before != cache.size()) {
            Vector<String> usedKeys = new Vector<String>();
            for (String key : cache.keySet()) {
                FragmentRuleVO rule = cache.get(key);
                try {
                    if (type == 1) {
                        new FragmentRuleVO(rule.getName(), rule.getFormula(), rule.getCharge(), rule.getMsLevel(), rule.isMandatory(), outputHash, new Hashtable<String, FragmentRuleVO>(), this.elementParser_);
                    } else if (type == 2) {
                        new FragmentRuleVO(rule.getName(), rule.getFormula(), rule.getCharge(), rule.getMsLevel(), rule.isMandatory(), this.headFragmentRules_, outputHash, this.elementParser_);
                    }
                    outputHash.put(key, rule);
                    output.add(rule);
                    usedKeys.add(key);
                }
                catch (RulesException rulesException) {}
            }
            before = cache.size();
            for (String key : usedKeys) {
                cache.remove(key);
            }
        }
        for (String key : cache.keySet()) {
            output.add(cache.get(key));
        }
        return output;
    }

    private short getFragMandatory(int inputNumber) {
        if (inputNumber == 0) {
            return 1;
        }
        return 0;
    }

    private boolean getIntensityMandatory(int inputNumber) {
        return inputNumber == 0;
    }

    MSnDebugVO getCurrentDebugInfo() throws RulesException, IOException, SpectrummillParserException, CgException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        MSnDebugVO debugInfo = null;
        try {
            this.msnAnalyzer_ = this.updateMSnAnalyzerToCurrentSettings();
        }
        catch (NoRuleException e) {
            e.printStackTrace();
        }
        debugInfo = this.msnAnalyzer_.getDebugInfo();
        return debugInfo;
    }

    private String showFragmentTabDetailsString(Hashtable<String, CgProbe> detectedFragments) throws RulesException, IOException, SpectrummillParserException, CgException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        MSnDebugVO debugInfo = this.getCurrentDebugInfo();
        String labeling = "Area";
        Enumeration<String> headFragmentEnum = detectedFragments.keys();
        String labelInput = "<br>Fragments:<br>";
        while (headFragmentEnum.hasMoreElements()) {
            String currentKey = headFragmentEnum.nextElement();
            CgProbe inhalt = detectedFragments.get(currentKey);
            String[] fragmentRuleResults = inhalt.toString().split(";");
            String[] labels = labeling.toString().split(";");
            labelInput = labelInput + "<br><font color='red'>" + currentKey + "</font><br>";
            if (fragmentRuleResults.length == 0) continue;
            labelInput = labelInput + labels[0] + " = " + fragmentRuleResults[0] + "<br>";
        }
        Hashtable<String, Integer> discHeads = debugInfo.getDiscardedHeadGroupFragments();
        labelInput = labelInput + "<br>Not found fragments: " + discHeads.size();
        for (String fragment : discHeads.keySet()) {
            labelInput = labelInput + "<br><br>Head-Discarded: " + fragment + "\tbecause " + this.printStatus(discHeads.get(fragment));
        }
        return labelInput;
    }

    private String showHeadIntensityTabDetailsString(Hashtable<String, IntensityRuleVO> fulfilledIntensityRules) throws RulesException, IOException, SpectrummillParserException, CgException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        MSnDebugVO debugInfo = this.getCurrentDebugInfo();
        String labelInput = "Intensity rules that were fulfilled by the head group fragments:<br><br>";
        Enumeration<String> headIntensityEnum = fulfilledIntensityRules.keys();
        int counter = 0;
        while (headIntensityEnum.hasMoreElements()) {
            String currentKey = headIntensityEnum.nextElement();
            IntensityRuleVO inhalt = fulfilledIntensityRules.get(currentKey);
            labelInput = labelInput + ++counter + ". Equation= " + inhalt.getRuleIdentifier() + " Mandatory= " + inhalt.isMandatory() + "<br>";
        }
        Hashtable<String, IntensityRuleVO> violHeadRules = debugInfo.getViolatedHeadRules();
        labelInput = labelInput + "<br><br>Violated head intensity rules: " + violHeadRules.size();
        return labelInput;
    }

    private String showChainIntensityTabDetailsString(Hashtable<String, IntensityChainVO> chainIntensities) throws LipidCombinameEncodingException {
        int counter = 0;
        String returnString = "";
        Enumeration<String> chainIntensitiesEnum = chainIntensities.keys();
        while (chainIntensitiesEnum.hasMoreElements()) {
            String currentKey = chainIntensitiesEnum.nextElement();
            IntensityChainVO intensityVo = chainIntensities.get(currentKey);
            returnString = returnString + ++counter + ". " + intensityVo.getReadableRuleInterpretation(Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding());
        }
        return returnString;
    }

    public void printPositionRecomandation(LipidParameterSet result, Hashtable<String, Hashtable<Integer, Integer>> positionRecommendations1) throws RulesException, IOException, SpectrummillParserException, CgException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        this.deleteDetailsBoxes();
        MSnDebugVO debugInfo = this.getCurrentDebugInfo();
        String toWrite = "";
        toWrite = toWrite + "<br>Possible Positions:<br>" + this.getResultWriteString(result, false);
        Hashtable<String, Hashtable<String, IntensityRuleVO>> unfulfilledPosRules = debugInfo.getUnfulfilledPositionRules();
        toWrite = toWrite + "<br><br>Unfulfilled rules: " + unfulfilledPosRules.size() + "<br/>";
        for (String string : unfulfilledPosRules.keySet()) {
            String humanReadable = StaticUtils.getHumanReadableCombiName(string, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding());
            Hashtable<String, IntensityRuleVO> unfulfilled = unfulfilledPosRules.get(string);
            for (IntensityRuleVO intensityRuleVO : unfulfilled.values()) {
                toWrite = toWrite + humanReadable + ":\tNOT " + intensityRuleVO.getReadableRuleInterpretation(Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding()) + "<br/>";
            }
        }
        toWrite = toWrite + "<br/>";
        Hashtable<String, Vector<Vector<IntensityRuleVO>>> contradictingPositionRules = debugInfo.getContradictingPositionRules();
        toWrite = toWrite + "<br>Any contradicting position rules: " + contradictingPositionRules.size() + "<br>";
        for (String combiName : contradictingPositionRules.keySet()) {
            Vector<Vector<IntensityRuleVO>> rulePairs = contradictingPositionRules.get(combiName);
            for (Vector vector : rulePairs) {
                IntensityRuleVO rule1 = (IntensityRuleVO)vector.get(0);
                IntensityRuleVO rule2 = (IntensityRuleVO)vector.get(1);
                toWrite = toWrite + combiName + ":\t" + rule1.getReadableRuleInterpretation(Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding()) + "\t!=\t" + rule2.getReadableRuleInterpretation(Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding());
            }
        }
        JLabel jLabel = new JLabel("<html>" + toWrite + "<br></html>");
        jLabel.setVerticalAlignment(1);
        this.showHeadDetails_ = new JDialog();
        this.showHeadDetails_.setTitle("Show Details");
        this.showHeadDetails_.setSize(600, 300);
        JScrollPane headRule = new JScrollPane(jLabel);
        this.showHeadDetails_.add(headRule);
        this.showHeadDetails_.setVisible(true);
    }

    public void deleteDetailsBoxes() {
        if (this.showHeadDetails_ != null) {
            this.showHeadDetails_.dispose();
        }
    }

    private void printInDialogShowDetailsBox(Hashtable<String, CgProbe> detectedFragments, Hashtable<String, IntensityRuleVO> fulfilledIntensityRules, Hashtable<String, Hashtable<String, CgProbe>> chainFragments, Hashtable<String, Hashtable<String, IntensityChainVO>> chainIntensities) throws RulesException, IOException, SpectrummillParserException, CgException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        try {
            this.deleteDetailsBoxes();
            MSnDebugVO debugInfo = this.getCurrentDebugInfo();
            String toWrite = "";
            if (detectedFragments != null) {
                toWrite = this.showFragmentTabDetailsString(detectedFragments) + "<br><br>" + this.showHeadIntensityTabDetailsString(fulfilledIntensityRules);
            } else {
                String humanReadable;
                ArrayList<String> chainNamesInternalRepresentation = new ArrayList<String>(chainFragments.keySet());
                toWrite = toWrite + "<br>Detected Chains<br><br>";
                for (String name : chainNamesInternalRepresentation) {
                    humanReadable = StaticUtils.getHumanReadableCombiName(name, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding());
                    toWrite = toWrite + "Chain " + humanReadable + "<br>";
                }
                toWrite = toWrite + "<br><br>";
                for (String name : chainNamesInternalRepresentation) {
                    humanReadable = StaticUtils.getHumanReadableCombiName(name, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding());
                    toWrite = toWrite + "Details Chain " + humanReadable + "<br>";
                    Hashtable<String, CgProbe> chainFragment = chainFragments.get(name);
                    toWrite = toWrite + this.showFragmentTabDetailsString(chainFragment) + "<br><br>";
                }
                toWrite = toWrite + "<br><br>Intensity rules that were fulfilled by the chain fragments:<br><br>";
                Enumeration<String> chainIntensityEnum = chainIntensities.keys();
                while (chainIntensityEnum.hasMoreElements()) {
                    String currentKey = chainIntensityEnum.nextElement();
                    Hashtable<String, IntensityChainVO> fulfilledChainIntensityRules = chainIntensities.get(currentKey);
                    toWrite = toWrite + this.showChainIntensityTabDetailsString(fulfilledChainIntensityRules) + "<br>";
                }
                toWrite = toWrite + "<br><br><br>";
                Hashtable<String, Hashtable<String, Object>> violChainRules = debugInfo.getViolatedChainRules();
                toWrite = toWrite + "Violated chain intensity rules: " + violChainRules.size() + "<br>";
                for (String faName : violChainRules.keySet()) {
                    String humanReadable2 = StaticUtils.getHumanReadableCombiName(faName, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding());
                    Hashtable<String, Object> violRule = violChainRules.get(faName);
                    for (String ruleName : violRule.keySet()) {
                        Object rule = violRule.get(ruleName);
                        if (rule instanceof Integer) {
                            int status = (Integer)rule;
                            toWrite = toWrite + "<br>Chain Discarded: " + humanReadable2 + "\t" + ruleName + "\tbecause " + this.printStatus(status);
                            continue;
                        }
                        if (!(rule instanceof IntensityRuleVO)) continue;
                        IntensityRuleVO ruleVO = (IntensityRuleVO)rule;
                        toWrite = toWrite + "<br>Violated chain rule: " + humanReadable2 + "\t" + ruleVO.getReadableRuleInterpretation(Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding());
                    }
                }
                Hashtable<String, Integer> violCombis = debugInfo.getViolatedCombinations();
                toWrite = toWrite + "<br><br>Violated combinations: " + violCombis.size() + "<br>";
                for (String combi : violCombis.keySet()) {
                    String humanReadable3 = StaticUtils.getHumanReadableCombiName(combi, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding());
                    toWrite = toWrite + "<br>Violated combi: " + humanReadable3 + "\t" + violCombis.get(combi);
                }
                toWrite = toWrite + "<br>Spectrum sufficiently covered: " + debugInfo.isSpectrumCoverageFulfilled();
            }
            JLabel lbl = new JLabel("<html>" + toWrite + "<br></html>");
            lbl.setVerticalAlignment(1);
            this.showHeadDetails_ = new JDialog();
            this.showHeadDetails_.setTitle("Show Details");
            this.showHeadDetails_.setSize(600, 800);
            JScrollPane headRule = new JScrollPane(lbl);
            this.showHeadDetails_.add(headRule);
            this.showHeadDetails_.setVisible(true);
        }
        catch (RulesException rx) {
            if (rx.getMessage().endsWith("The rules file must contain a [HEAD] or a [CHAINS] section!")) {
                new WarningMessage(new JFrame(), "Error", "There are no rules entered!");
            }
            throw rx;
        }
    }

    String printStatus(int status) {
        String returnStatus = null;
        if (status == 0) {
            returnStatus = "the reason for the discard is unknown";
        }
        if (status == 1) {
            returnStatus = "there is no peak at this m/z value";
            return "there is no peak at this m/z value";
        }
        if (status == 2) {
            returnStatus = "the peak is lower than the base peak intensity cutoff";
            return "the peak is lower than the base peak intensity cutoff";
        }
        if (status == 3) {
            returnStatus = "the found chain does not have any matching partner chains to match the total number of carbon atoms and double bonds";
            return "the found chain does not have any matching partner chains to match the total number of carbon atoms and double bonds";
        }
        if (status == 4) {
            returnStatus = "the found chain combination is of minor intensity - below the defined threshold";
            return "the found chain combination is of minor intensity - below the defined threshold";
        }
        return returnStatus;
    }

    public void deleteDependingRules(String name, int type) {
        Vector<String> names = this.deleteDependendFragment(name, type);
        this.deleteDependendEquation(names, type);
    }

    public Vector<String> deleteDependendFragment(String deletedName, int type) {
        Vector<FragmentRuleVO> sortedFragments;
        Vector<String> deleted = new Vector<String>();
        deleted.add(deletedName);
        Hashtable<String, FragmentRuleVO> allowedRules = new Hashtable();
        if (type == 1) {
            Hashtable<String, FragmentRuleVO> allowedHeadRules = new Hashtable<String, FragmentRuleVO>();
            sortedFragments = this.getSortedVector(this.headFragmentRules_, 1);
            for (FragmentRuleVO ruleVO : sortedFragments) {
                if (ruleVO.containsOnlyAllowedFragments(allowedRules)) {
                    allowedHeadRules.put(ruleVO.getName(), ruleVO);
                    allowedRules.put(ruleVO.getName(), ruleVO);
                    continue;
                }
                deleted.add(ruleVO.getName());
            }
            this.headFragmentRules_ = allowedHeadRules;
        } else {
            allowedRules = new Hashtable<String, FragmentRuleVO>(this.headFragmentRules_);
        }
        if (type < 3) {
            Hashtable<String, FragmentRuleVO> allowedChainRules = new Hashtable<String, FragmentRuleVO>();
            sortedFragments = this.getSortedVector(this.chainFragmentRules_, 2);
            for (FragmentRuleVO ruleVO : sortedFragments) {
                if (ruleVO.containsOnlyAllowedFragments(allowedRules)) {
                    allowedChainRules.put(ruleVO.getName(), ruleVO);
                    allowedRules.put(ruleVO.getName(), ruleVO);
                    continue;
                }
                deleted.add(ruleVO.getName());
            }
            this.chainFragmentRules_ = allowedChainRules;
        }
        return deleted;
    }

    public void deleteDependendEquation(Vector<String> names, int type) {
        if (type == 1) {
            this.headIntensityRules_ = this.removeDependentIntensityRule(this.headIntensityRules_, names);
        }
        if (type < 3) {
            this.chainIntensityRules_ = this.removeDependentIntensityRule(this.chainIntensityRules_, names);
        }
        this.positionIntensityRules_ = this.removeDependentIntensityRule(this.positionIntensityRules_, names);
    }

    private Vector<IntensityRuleVO> removeDependentIntensityRule(Vector<IntensityRuleVO> rules, Vector<String> fragmentNames) {
        Vector<IntensityRuleVO> passingRules = new Vector<IntensityRuleVO>();
        for (IntensityRuleVO rule : rules) {
            boolean hasWrongFragment = false;
            for (String name : fragmentNames) {
                if (!rule.containsFragment(name)) continue;
                hasWrongFragment = true;
            }
            if (hasWrongFragment) continue;
            passingRules.add(rule);
        }
        return passingRules;
    }

    public void printTotalDecisionInBox() {
        try {
            this.deleteDetailsBoxes();
            this.msnAnalyzer_ = null;
            try {
                this.msnAnalyzer_ = this.updateMSnAnalyzerToCurrentSettings();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (SpectrummillParserException e1) {
                e1.printStackTrace();
            }
            catch (CgException e1) {
                e1.printStackTrace();
            }
            catch (NoRuleException e1) {
            }
            catch (ChemicalFormulaException | HydroxylationEncodingException | LipidCombinameEncodingException e) {
                e.printStackTrace();
            }
            LipidParameterSet result = this.msnAnalyzer_.getResult();
            String toWrite = "";
            toWrite = toWrite + "<br><font color='red'>Result:<br>" + this.getResultWriteString(result, true) + "</font>";
            toWrite = toWrite + "<br><br>Double Bonds: " + result.getDoubleBonds();
            toWrite = toWrite + "<br><br>Modification Name: " + result.getModificationName();
            toWrite = toWrite + "<br><br>Analyte Formula: " + result.getAnalyteFormula();
            toWrite = toWrite + "<br><br>Modification Formula: " + result.getModificationFormula();
            toWrite = toWrite + "<br><br>Chemical Formula: " + result.getChemicalFormula();
            toWrite = toWrite + "<br><br>Charge: " + result.getCharge();
            toWrite = toWrite + "<br><br>Rt: " + result.getRt();
            JLabel lbl = new JLabel("<html>" + toWrite + "<br></html>");
            lbl.setVerticalAlignment(1);
            this.showHeadDetails_ = new JDialog();
            this.showHeadDetails_.setTitle("Total Decision");
            this.showHeadDetails_.setSize(600, 800);
            JScrollPane headRule = new JScrollPane(lbl);
            this.showHeadDetails_.add(headRule);
            this.showHeadDetails_.setVisible(true);
        }
        catch (RulesException rx) {
            if (rx.getMessage().endsWith("The rules file must contain a [HEAD] or a [CHAINS] section!") || !this.showFragmentTabs_) {
                new WarningMessage(new JFrame(), "Error", "There are no rules entered!");
            }
            rx.printStackTrace();
        }
    }

    public void checkToAddHeadFragment() throws IOException, RulesException, SpectrummillParserException, NoRuleException, CgException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        int before = 0;
        int after = 0;
        this.headRuleTab_.remove(this.fragRuleOK_);
        this.fragRuleOK_ = new JLabel(new ImageIcon(this.redCrossPicture_));
        this.gridBayLayout_.setConstraints(this.fragRuleOK_, new GridBagConstraints(0, this.headFragments_.size() + 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.headRuleTab_.add(this.fragRuleOK_);
        this.headRuleTab_.repaint();
        this.headRuleTab_.validate();
        this.paintNewSpectra(false);
        before = this.headFragmentCounter();
        FragmentRuleVO ruleVO = null;
        if (this.headFragmentRules_.containsKey(this.fragRuleNameField_.getText())) {
            return;
        }
        if (!this.checkHeadFragment()) {
            return;
        }
        ruleVO = new FragmentRuleVO(this.fragRuleNameField_.getText(), this.fragRuleFormulaField_.getText(), Integer.parseInt(this.fragRuleChargeField_.getText()), Integer.parseInt(this.fragRuleMsLevelField_.getText()), this.getFragMandatory(this.fragRuleMandatoryCombo_.getSelectedIndex()), this.headFragmentRules_, this.chainFragmentRules_, this.elementParser_);
        this.headFragmentRules_.put(this.fragRuleNameField_.getText(), ruleVO);
        this.headFragments_ = this.getSortedVector(this.headFragmentRules_, 1);
        this.paintNewSpectra(false);
        after = this.headFragmentCounter();
        if (after == before + 1) {
            this.headRuleTab_.remove(this.fragRuleOK_);
            this.fragRuleOK_ = new JLabel(new ImageIcon(this.resource1_));
            this.gridBayLayout_.setConstraints(this.fragRuleOK_, new GridBagConstraints(0, this.headFragments_.size(), 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.headRuleTab_.add(this.fragRuleOK_);
            this.headRuleTab_.repaint();
            this.headRuleTab_.validate();
        }
        if (this.checkHeadFragment()) {
            this.headFragmentRules_.remove(this.fragRuleNameField_.getText());
            this.headFragments_ = this.getSortedVector(this.headFragmentRules_, 1);
        }
    }

    public boolean checkHeadFragment() {
        boolean check = true;
        try {
            new FragmentRuleVO(this.fragRuleNameField_.getText(), this.fragRuleFormulaField_.getText(), Integer.parseInt(this.fragRuleChargeField_.getText()), Integer.parseInt(this.fragRuleMsLevelField_.getText()), this.getFragMandatory(this.fragRuleMandatoryCombo_.getSelectedIndex()), this.headFragmentRules_, this.chainFragmentRules_, this.elementParser_);
        }
        catch (NumberFormatException e) {
            check = false;
        }
        catch (RulesException e) {
            check = false;
        }
        if (this.fragRuleNameField_.getText() == null || this.fragRuleNameField_.getText().length() == 0 || this.fragRuleFormulaField_.getText() == null || this.fragRuleFormulaField_.getText().length() == 0 || this.fragRuleChargeField_.getText() == null || this.fragRuleChargeField_.getText().length() == 0 || this.fragRuleMsLevelField_.getText() == null || this.fragRuleMsLevelField_.getText().length() == 0) {
            check = false;
        }
        if (!FragmentVerifier.checkFragmentNameInput(this.fragRuleNameField_)) {
            check = false;
        }
        if (!FragmentVerifier.checkFragmentFormulaInput(this.fragRuleFormulaField_)) {
            check = false;
        }
        return check;
    }

    public int headFragmentCounter() throws RulesException, IOException, SpectrummillParserException, CgException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        int numberOfDetectedFragments = 0;
        try {
            this.msnAnalyzer_ = this.updateMSnAnalyzerToCurrentSettings();
            Hashtable<String, CgProbe> detectedFragments = this.msnAnalyzer_.getHeadGroupFragments();
            numberOfDetectedFragments = detectedFragments.size();
            return numberOfDetectedFragments;
        }
        catch (NoRuleException | RulesException e) {
            this.msnAnalyzer_ = new MSnAnalyzer(this.lipidClassName_, this.lipidAdduct_, this.data_, this.analyzer_, null, true, false);
            return 0;
        }
    }

    public void checkToAddHeadIntensityRule() throws RulesException, IOException, SpectrummillParserException, CgException, NoRuleException, ChemicalFormulaException {
        int before = 0;
        int after = 0;
        if (this.equRuleEquationField_.getText() == null || this.equRuleEquationField_.getText().length() == 0) {
            return;
        }
        this.headRuleTab_.remove(this.equRuleOK_);
        this.equRuleOK_ = new JLabel(new ImageIcon(this.redCrossPicture_));
        this.gridBayLayout_.setConstraints(this.equRuleOK_, new GridBagConstraints(0, this.headIntensityRules_.size() + this.headFragments_.size() + 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.headRuleTab_.add(this.equRuleOK_);
        this.headRuleTab_.repaint();
        this.headRuleTab_.validate();
        this.paintNewSpectra(false);
        before = this.headIntensityCounter();
        IntensityRuleVO ruleVO = FragRuleParser.extractIntensityVOFromEquation(this.equRuleEquationField_.getText(), 0, 2, FragmentRuleVO.getStringKeyHash(this.headFragmentRules_), FragmentRuleVO.getStringKeyHash(this.chainFragmentRules_), this.generalSettingsVO_.getAmountOfChains());
        ruleVO.setMandatory(this.getIntensityMandatory(this.equRuleMandatoryCombo_.getSelectedIndex()));
        this.headIntensityRules_.add(ruleVO);
        this.paintNewSpectra(false);
        after = this.headIntensityCounter();
        if (after == before + 1) {
            this.headRuleTab_.remove(this.equRuleOK_);
            this.equRuleOK_ = new JLabel(new ImageIcon(this.resource1_));
            this.gridBayLayout_.setConstraints(this.equRuleOK_, new GridBagConstraints(0, this.headIntensityRules_.size() + this.headFragments_.size() + 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.headRuleTab_.add(this.equRuleOK_);
            this.headRuleTab_.repaint();
            this.headRuleTab_.validate();
        }
        this.headIntensityRules_.remove(ruleVO);
    }

    public int headIntensityCounter() throws RulesException, IOException, SpectrummillParserException, CgException, ChemicalFormulaException {
        int numberOfFulfilledIntensityRules = 0;
        try {
            this.msnAnalyzer_ = this.updateMSnAnalyzerToCurrentSettings();
        }
        catch (HydroxylationEncodingException | LipidCombinameEncodingException | NoRuleException e) {
            e.printStackTrace();
        }
        Hashtable<String, IntensityRuleVO> fulfilledIntensityRules = this.msnAnalyzer_.getFulfilledHeadIntensityRules();
        numberOfFulfilledIntensityRules = fulfilledIntensityRules.size();
        return numberOfFulfilledIntensityRules;
    }

    public void checkToAddChainFragment() throws RulesException, IOException, SpectrummillParserException, CgException, NoRuleException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        int before = 0;
        int after = 0;
        if (this.chainRuleNameField_.getText() == null || this.chainRuleNameField_.getText().length() == 0) {
            return;
        }
        this.chainTab_.remove(this.chainRuleOK_);
        this.chainRuleOK_ = new JLabel(new ImageIcon(this.redCrossPicture_));
        this.gridBayLayout_.setConstraints(this.chainRuleOK_, new GridBagConstraints(0, this.chainFragmentRules_.size() + 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.chainTab_.add(this.chainRuleOK_);
        this.chainTab_.repaint();
        this.chainTab_.validate();
        this.paintNewSpectra(false);
        before = this.chainFragmentCounter();
        FragmentRuleVO ruleVO = null;
        if (this.chainFragmentRules_.containsKey(this.chainRuleNameField_.getText())) {
            return;
        }
        if (!this.checkChainFragment()) {
            return;
        }
        ruleVO = new FragmentRuleVO(this.chainRuleNameField_.getText(), this.chainRuleFormulaField_.getText(), Integer.parseInt(this.chainRuleChargeField_.getText()), Integer.parseInt(this.chainRuleMsLevelField_.getText()), this.getFragMandatory(this.chainRuleMandatoryCombo_.getSelectedIndex()), this.headFragmentRules_, this.chainFragmentRules_, this.elementParser_);
        this.chainFragmentRules_.put(this.chainRuleNameField_.getText(), ruleVO);
        this.sortedChainFragments_ = this.getSortedVector(this.chainFragmentRules_, 2);
        this.paintNewSpectra(false);
        after = this.chainFragmentCounter();
        if (after == before + 1) {
            this.chainTab_.remove(this.chainRuleOK_);
            this.chainRuleOK_ = new JLabel(new ImageIcon(this.resource1_));
            this.gridBayLayout_.setConstraints(this.chainRuleOK_, new GridBagConstraints(0, this.chainFragmentRules_.size(), 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.chainTab_.add(this.chainRuleOK_);
            this.chainTab_.repaint();
            this.chainTab_.validate();
        }
        if (this.checkChainFragment()) {
            this.chainFragmentRules_.remove(this.chainRuleNameField_.getText());
            this.sortedChainFragments_ = this.getSortedVector(this.chainFragmentRules_, 2);
        }
    }

    public boolean checkChainFragment() {
        boolean check = true;
        try {
            new FragmentRuleVO(this.chainRuleNameField_.getText(), this.chainRuleFormulaField_.getText(), Integer.parseInt(this.chainRuleChargeField_.getText()), Integer.parseInt(this.chainRuleMsLevelField_.getText()), this.getFragMandatory(this.chainRuleMandatoryCombo_.getSelectedIndex()), this.headFragmentRules_, this.chainFragmentRules_, this.elementParser_);
        }
        catch (NumberFormatException e) {
            check = false;
        }
        catch (RulesException e) {
            check = false;
        }
        if (this.chainRuleNameField_.getText() == null || this.chainRuleNameField_.getText().length() == 0 || this.chainRuleFormulaField_.getText() == null || this.chainRuleFormulaField_.getText().length() == 0 || this.chainRuleChargeField_.getText() == null || this.chainRuleChargeField_.getText().length() == 0 || this.chainRuleMsLevelField_.getText() == null || this.chainRuleMsLevelField_.getText().length() == 0) {
            check = false;
        }
        if (!FragmentVerifier.checkFragmentNameInput(this.chainRuleNameField_)) {
            check = false;
        }
        if (!FragmentVerifier.checkFragmentFormulaInput(this.chainRuleFormulaField_)) {
            check = false;
        }
        return check;
    }

    public int chainFragmentCounter() throws RulesException, IOException, SpectrummillParserException, CgException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        int maxFragmentsDetected = 0;
        try {
            this.msnAnalyzer_ = this.updateMSnAnalyzerToCurrentSettings();
            Hashtable<String, Hashtable<String, CgProbe>> chainFragments = this.msnAnalyzer_.getChainFragments();
            Enumeration<String> chainEnum = chainFragments.keys();
            while (chainEnum.hasMoreElements()) {
                String currentKey = chainEnum.nextElement();
                Hashtable<String, CgProbe> chainFragmentsDetected = chainFragments.get(currentKey);
                if (maxFragmentsDetected >= chainFragmentsDetected.size()) continue;
                maxFragmentsDetected = chainFragmentsDetected.size();
            }
        }
        catch (NoRuleException | RulesException e) {
            this.msnAnalyzer_ = new MSnAnalyzer(this.lipidClassName_, this.lipidAdduct_, this.data_, this.analyzer_, null, true, false);
            return 0;
        }
        return maxFragmentsDetected;
    }

    public void checkToAddChainIntensityRule() throws RulesException, IOException, SpectrummillParserException, NoRuleException, CgException, ChemicalFormulaException {
        int before = 0;
        int after = 0;
        this.chainTab_.remove(this.equChainRuleOK_);
        this.equChainRuleOK_ = new JLabel(new ImageIcon(this.redCrossPicture_));
        this.gridBayLayout_.setConstraints(this.equChainRuleOK_, new GridBagConstraints(0, this.chainIntensityRules_.size() + this.chainFragmentRules_.size() + 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.chainTab_.add(this.equChainRuleOK_);
        this.chainTab_.repaint();
        this.chainTab_.validate();
        this.paintNewSpectra(false);
        before = this.chainIntensityCounter();
        IntensityRuleVO ruleVO = FragRuleParser.extractIntensityVOFromEquation(this.equChainRuleEquationField_.getText(), 0, 2, FragmentRuleVO.getStringKeyHash(this.headFragmentRules_), FragmentRuleVO.getStringKeyHash(this.chainFragmentRules_), this.generalSettingsVO_.getAmountOfChains());
        ruleVO.setMandatory(this.getIntensityMandatory(this.equChainRuleMandatoryCombo_.getSelectedIndex()));
        this.chainIntensityRules_.add(ruleVO);
        this.paintNewSpectra(false);
        after = this.chainIntensityCounter();
        if (after == before + 1) {
            this.chainTab_.remove(this.equChainRuleOK_);
            this.equChainRuleOK_ = new JLabel(new ImageIcon(this.resource1_));
            this.gridBayLayout_.setConstraints(this.equChainRuleOK_, new GridBagConstraints(0, this.chainIntensityRules_.size() + this.chainFragmentRules_.size() + 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.chainTab_.add(this.equChainRuleOK_);
            this.chainTab_.repaint();
            this.chainTab_.validate();
        }
        this.chainIntensityRules_.remove(ruleVO);
    }

    public int chainIntensityCounter() throws RulesException, IOException, SpectrummillParserException, CgException, ChemicalFormulaException {
        try {
            this.msnAnalyzer_ = this.updateMSnAnalyzerToCurrentSettings();
        }
        catch (HydroxylationEncodingException | LipidCombinameEncodingException | NoRuleException e) {
            e.printStackTrace();
        }
        Hashtable<String, Hashtable<String, IntensityChainVO>> fulfilledChainIntensityRules = this.msnAnalyzer_.getFulfilledChainIntensityRules();
        int counter = 0;
        Enumeration<String> chainEnum = fulfilledChainIntensityRules.keys();
        while (chainEnum.hasMoreElements()) {
            String currentKey = chainEnum.nextElement();
            Hashtable<String, IntensityChainVO> currentfulfilledChainIntensityRules = fulfilledChainIntensityRules.get(currentKey);
            if (currentfulfilledChainIntensityRules.size() <= counter) continue;
            counter = currentfulfilledChainIntensityRules.size();
        }
        return counter;
    }

    public void checkToAddPositionRule() throws RulesException, IOException, SpectrummillParserException, NoRuleException, CgException {
        int before = 0;
        int after = 0;
        if (this.positionEquationField_.getText() == null || this.positionEquationField_.getText().length() == 0) {
            return;
        }
        this.positionTab_.remove(this.positionRuleOK_);
        this.positionRuleOK_ = new JLabel(new ImageIcon(this.redCrossPicture_));
        this.gridBayLayout_.setConstraints(this.positionRuleOK_, new GridBagConstraints(0, 1 + this.positionIntensityRules_.size(), 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.positionTab_.add(this.positionRuleOK_);
        this.positionTab_.repaint();
        this.positionTab_.validate();
        this.paintNewSpectra(false);
        before = this.unfulfilledPosRulesCounter();
        try {
            IntensityRuleVO ruleVO = FragRuleParser.extractIntensityVOFromEquation(this.positionEquationField_.getText(), 0, 4, FragmentRuleVO.getStringKeyHash(this.headFragmentRules_), FragmentRuleVO.getStringKeyHash(this.chainFragmentRules_), this.generalSettingsVO_.getAmountOfChains());
            ruleVO.setMandatory(this.getIntensityMandatory(this.positionRuleMandatoryCombo_.getSelectedIndex()));
            this.positionIntensityRules_.add(ruleVO);
            this.saveRules(CACHE_DIR);
            after = this.unfulfilledPosRulesCounter();
            if (!this.positionEquationField_.getText().equals("")) {
                if (after == before) {
                    this.positionTab_.remove(this.positionRuleOK_);
                    this.positionRuleOK_ = new JLabel(new ImageIcon(this.resource1_));
                    this.gridBayLayout_.setConstraints(this.positionRuleOK_, new GridBagConstraints(0, this.positionIntensityRules_.size(), 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                    this.positionTab_.add(this.positionRuleOK_);
                    this.positionTab_.repaint();
                    this.positionTab_.validate();
                }
                this.positionIntensityRules_.remove(ruleVO);
            } else {
                this.positionIntensityRules_.remove(ruleVO);
            }
        }
        catch (RulesException rulesException) {
            // empty catch block
        }
    }

    public int unfulfilledPosRulesCounter() {
        int result = 0;
        try {
            MSnDebugVO debugInfo = this.getCurrentDebugInfo();
            Hashtable<String, Hashtable<String, IntensityRuleVO>> unfulfilledPosRules = debugInfo.getUnfulfilledPositionRules();
            result = unfulfilledPosRules.size();
        }
        catch (ChemicalFormulaException | HydroxylationEncodingException | LipidCombinameEncodingException | RulesException | SpectrummillParserException | CgException | IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void setEverythingNull() {
        this.generalSettingsVO_ = new GeneralSettingsVO();
        this.headFragmentRules_ = new Hashtable();
        this.headIntensityRules_ = new Vector();
        this.chainFragmentRules_ = new Hashtable();
        this.chainIntensityRules_ = new Vector();
        this.positionIntensityRules_ = new Vector();
        if (this.topSplitPane_ != null) {
            this.topSplitPane_.remove(this.middleTabSection_);
            this.topSplitPane_.validate();
            this.ruleTabsSection();
            this.middleTabSection_.setSelectedIndex(0);
            this.topSplitPane_.setBottomComponent(this.middleTabSection_);
        }
    }

    public String getResultWriteString(LipidParameterSet result, boolean showRetentionTime) {
        String resultString = "";
        LipidomicsMSnSet msnSet = (LipidomicsMSnSet)result;
        Vector<String> detected = msnSet.getMSnIdentificationNamesWithSNPositions();
        for (String name : detected) {
            resultString = resultString + name + "_" + result.getRt() + "<br>";
        }
        return resultString;
    }

    public FragmentRuleVO checkFragment(String ruleName, String formula, int charge, int msLevel, short mandatory, int type, int fragmentType) throws RulesException {
        FragmentRuleVO ruleVO = null;
        Hashtable<String, FragmentRuleVO> source = null;
        if (fragmentType == 1) {
            source = this.headFragmentRules_;
        }
        if (fragmentType == 2) {
            source = this.chainFragmentRules_;
        }
        Enumeration<String> headFragmentEnum = source.keys();
        while (headFragmentEnum.hasMoreElements()) {
            String currentKey = headFragmentEnum.nextElement();
            FragmentRuleVO rule = source.get(currentKey);
            if (!currentKey.equals(ruleName)) continue;
            if (type == 1) {
                ruleVO = new FragmentRuleVO(currentKey, formula, rule.getCharge(), rule.getMsLevel(), mandatory, this.headFragmentRules_, this.chainFragmentRules_, this.elementParser_);
            }
            if (type == 2) {
                ruleVO = new FragmentRuleVO(currentKey, formula, charge, rule.getMsLevel(), mandatory, this.headFragmentRules_, this.chainFragmentRules_, this.elementParser_);
            }
            if (type == 3) {
                ruleVO = new FragmentRuleVO(currentKey, formula, charge, msLevel, mandatory, this.headFragmentRules_, this.chainFragmentRules_, this.elementParser_);
            }
            if (type != 1 && type != 2 && type != 3) continue;
            return ruleVO;
        }
        return null;
    }

    public void updateRuleVO(FragmentRuleVO ruleVO, int fragmentType) {
        Hashtable<String, FragmentRuleVO> source = null;
        if (fragmentType == 1) {
            source = this.headFragmentRules_;
        }
        if (fragmentType == 2) {
            source = this.chainFragmentRules_;
        }
        source.put(ruleVO.getName(), ruleVO);
        this.headFragments_ = this.getSortedVector(this.headFragmentRules_, 1);
        this.sortedChainFragments_ = this.getSortedVector(this.chainFragmentRules_, 2);
    }

    public LipidParameterSet testForMSnDetection(int specNumber) throws RulesException, NoRuleException, IOException, SpectrummillParserException, CgException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        try {
            MSnAnalyzer analyzer = this.updateMSnAnalyzerToCurrentSettings(specNumber);
            this.data_ = analyzer.getResult();
        }
        catch (RulesException rx) {
            if (rx.getMessage().endsWith("The rules file must contain a [HEAD] or a [CHAINS] section!") || !this.showFragmentTabs_) {
                this.data_ = new LipidParameterSet(this.data_);
            }
            throw rx;
        }
        return this.data_;
    }

    private MSnAnalyzer updateMSnAnalyzerToCurrentSettings() throws RulesException, NoRuleException, IOException, SpectrummillParserException, CgException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        return this.updateMSnAnalyzerToCurrentSettings(this.spectrumUpdater_.getMs2LevelSpectrumSelected());
    }

    private MSnAnalyzer updateMSnAnalyzerToCurrentSettings(int specNumber) throws RulesException, NoRuleException, IOException, SpectrummillParserException, CgException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        FragmentCalculator fragCalc_ = new FragmentCalculator(CACHE_DIR, this.lipidClassName_, this.lipidAdduct_, this.data_.getNameStringWithoutRt(), this.data_.getChemicalFormula(), this.data_.getChemicalFormulaWODeducts(), this.data_.Mz[0], this.data_.getCharge(), this.data_.getOhNumber(), this.data_.getOxState());
        float tol = LipidomicsConstants.getMs2PrecursorTolerance(this.data_.Mz[0]);
        this.analyzer_.prepareMSnSpectraCache(this.data_.Mz[0] - tol, this.data_.Mz[0] + tol, LipidomicsConstants.getMs2MinIntsForNoiseRemoval());
        Vector<Range> ranges = this.analyzer_.findSingleSpectraRanges(fragCalc_.getSpectrumLevelRange());
        Vector<CgProbe> probes = new Vector<CgProbe>();
        if (specNumber < 0 || specNumber >= ranges.size()) {
            for (Range range : ranges) {
                CgProbe probe = this.createDummyProbe(this.data_.Mz[0]);
                probe.Peak = (range.getStart() + range.getStop()) / 2.0f;
                probe.LowerValley = range.getStart();
                probe.UpperValley = range.getStop();
                probes.add(probe);
            }
        } else {
            Range range = ranges.get(specNumber);
            CgProbe probe = this.createDummyProbe(this.data_.Mz[0]);
            probe.Peak = (range.getStart() + range.getStop()) / 2.0f;
            probe.LowerValley = range.getStart();
            probe.UpperValley = range.getStop();
            probes.add(probe);
        }
        this.data_.setProbes(probes);
        MSnAnalyzer analyzer = new MSnAnalyzer(CACHE_DIR, this.lipidClassName_, this.lipidAdduct_, this.data_, this.analyzer_, null, false, true, true);
        return analyzer;
    }

    private CgProbe createDummyProbe(float mz) {
        CgProbe probe = new CgProbe(0, 1);
        probe.AreaStatus = CgAreaStatus.OK;
        probe.Area = 100.0f;
        probe.AreaError = 0.0f;
        probe.Background = 0.0f;
        probe.Mz = mz;
        probe.LowerMzBand = LipidomicsConstants.getCoarseChromMzTolerance(mz);
        probe.UpperMzBand = LipidomicsConstants.getCoarseChromMzTolerance(mz);
        probe.isotopeNumber = 0;
        return probe;
    }

    public void paintNewSpectra(boolean newPrec) {
        try {
            this.saveRules(CACHE_DIR);
            this.spectrumUpdater_.updateSpectra(this.data_, newPrec);
        }
        catch (NoRuleException | RulesException | SpectrummillParserException | CgException | IOException e) {
            e.printStackTrace();
        }
    }

    public void addEquationToIntensityRules(IntensityRuleVO ruleVO, int type, int position) {
        if (type == 1) {
            this.headIntensityRules_.set(position, ruleVO);
        }
        if (type == 2) {
            this.chainIntensityRules_.set(position, ruleVO);
        }
        if (type == 3) {
            this.positionIntensityRules_.set(position, ruleVO);
        }
    }

    public Hashtable<String, FragmentRuleVO> getHeadFragmentRules() {
        return this.headFragmentRules_;
    }

    public Hashtable<String, FragmentRuleVO> getChainFragmentRules() {
        return this.chainFragmentRules_;
    }

    public Vector<FragmentRuleVO> getHeadFragmentVector() {
        return this.headFragments_;
    }

    public Vector<FragmentRuleVO> getChainFragmentVector() {
        return this.sortedChainFragments_;
    }

    public String getAmountOfChains() {
        return this.generalSettingsVO_.getAmountOfChains().toString();
    }

    public boolean intToBoolean(int input) {
        if (input == 0) {
            return true;
        }
        if (input == 1) {
            return false;
        }
        return false;
    }

    public JTextField[] getHeadRuleFormulas() {
        return headRuleFormulas_;
    }

    public JTextField[] getHeadRuleCharges() {
        return headRuleCharges_;
    }

    public JTextField[] getHeadRuleMSLevels() {
        return headRuleMSLevels_;
    }

    public JTextField[] getChainRuleFormulas() {
        return chainRuleFormulas_;
    }

    public JTextField[] getChainRuleCharges() {
        return chainRuleCharges_;
    }

    public JTextField[] getChainRuleMSLevels() {
        return chainRuleMSLevels_;
    }

    public void checkFragmentWithErrors(int position, int type, int headOrChain) {
        if (headOrChain == 1) {
            if (type == 0) {
                this.headFragmentFormulaVerifier_[position].checkFragment();
            }
            if (type == 1) {
                this.headFragmentChargeVerifier_[position].checkFragment();
            }
            if (type == 2) {
                this.headFragmentMsLevelVerifier_[position].checkFragment();
            }
        }
        if (headOrChain == 2) {
            if (type == 0) {
                this.chainFragmentFormulaVerifier_[position].checkFragment();
            }
            if (type == 1) {
                this.chainFragmentChargeVerifier_[position].checkFragment();
            }
            if (type == 2) {
                this.chainFragmentMsLevelVerifier_[position].checkFragment();
            }
        }
    }

    public void refreshTextfieldToVerifie(int position, int type, int headOrChain) {
        if (headOrChain == 1) {
            if (type == 0) {
                this.headFragmentFormulaVerifier_[position].refresh(position);
            }
            if (type == 1) {
                this.headFragmentChargeVerifier_[position].refresh(position);
            }
            if (type == 2) {
                this.headFragmentMsLevelVerifier_[position].refresh(position);
            }
        }
        if (headOrChain == 2) {
            if (type == 0) {
                this.chainFragmentFormulaVerifier_[position].refresh(position);
            }
            if (type == 1) {
                this.chainFragmentChargeVerifier_[position].refresh(position);
            }
            if (type == 2) {
                this.chainFragmentMsLevelVerifier_[position].refresh(position);
            }
        }
    }

    public void refreshTextfieldToVerifieFirstTime(int position, int type, int headOrChain) {
        if (headOrChain == 1) {
            if (type == 0) {
                this.headFragmentFormulaVerifier_[position].refreshFirstTime(position);
            }
            if (type == 1) {
                this.headFragmentChargeVerifier_[position].refreshFirstTime(position);
            }
            if (type == 2) {
                this.headFragmentMsLevelVerifier_[position].refreshFirstTime(position);
            }
        }
        if (headOrChain == 2) {
            if (type == 0) {
                this.chainFragmentFormulaVerifier_[position].refreshFirstTime(position);
            }
            if (type == 1) {
                this.chainFragmentChargeVerifier_[position].refreshFirstTime(position);
            }
            if (type == 2) {
                this.chainFragmentMsLevelVerifier_[position].refreshFirstTime(position);
            }
        }
    }

    public void refreshEquationTextfieldToVerifieFirstTime(int position, int headOrChainOrPostion) {
        if (headOrChainOrPostion == 1) {
            this.headEquationVerifier_[position].refreshFirstTime();
        }
        if (headOrChainOrPostion == 2) {
            this.chainFragmentFormulaVerifier_[position].refreshFirstTime(position);
        }
        if (headOrChainOrPostion == 3) {
            this.chainFragmentFormulaVerifier_[position].refreshFirstTime(position);
        }
    }

    public boolean[] getHeadFragmentMandatories() {
        return this.headFragmentMandatories_;
    }

    public boolean[] getChainFragmentMandatories() {
        return this.chainFragmentMandatories_;
    }

    public boolean[] getHeadEquationtMandatories() {
        return this.headEquationMandatories_;
    }

    public void refreshEquationFieldToVerifie(int position, int headOrChainOrPosition) {
        if (headOrChainOrPosition == 1) {
            this.headEquationVerifier_[position].refresh();
        }
        if (headOrChainOrPosition == 2) {
            this.chainEquationVerifier_[position].refresh();
        }
        if (headOrChainOrPosition == 3) {
            this.positionEquationVerifier_[position].refresh();
        }
    }

    public JTextField[] getHeadEquations() {
        return this.headRuleEquationFields_;
    }

    public JTextField[] getChainEquations() {
        return this.chainRuleEquationFields_;
    }

    public boolean[] getChainEquationtMandatories() {
        return this.chainEquationMandatories_;
    }

    public JTextField[] getPositionEquations() {
        return this.positionRuleEquationFields_;
    }

    public boolean[] getPositionEquationtMandatories() {
        return this.positionEquationMandatories_;
    }

    public RuleDefinitionInterface(String lipidClassName, LipidParameterSet data, LipidomicsAnalyzer analyzer, int highestMSLevel, SpectrumUpdateListener object) throws NoRuleException, ChemicalFormulaException {
        super(0);
        this.setDividerSize(0);
        this.data_ = data;
        this.lipidClassName_ = lipidClassName;
        this.lipidName_ = data.getNameString();
        this.lipidPrecursorValue_ = data.Mz[0];
        this.lipidFormula_ = StaticUtils.getFormulaInHillNotation(StaticUtils.categorizeFormula(data.getAnalyteFormula()), true);
        this.lipidAdduct_ = data.getModificationName();
        this.ruleClassIdentifier_ = StaticUtils.getRuleName(this.lipidClassName_, this.lipidAdduct_);
        this.analyzer_ = analyzer;
        this.spectrumUpdater_ = object;
        this.highestMSLevel_ = highestMSLevel;
        try {
            RulesContainer.clearCache();
            this.getRulesFromCacheFirst();
        }
        catch (SpectrummillParserException e) {
            JOptionPane.showMessageDialog(this.topSplitPane_, e.getMessage());
        }
        catch (RulesException e) {
            JOptionPane.showMessageDialog(this.topSplitPane_, e.getMessage());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.topSplitPane_, e.getMessage());
        }
        this.createPanel();
        try {
            this.saveRules(CACHE_DIR);
        }
        catch (NoRuleException | RulesException | SpectrummillParserException | IOException e) {
            e.printStackTrace();
        }
        this.setVisible(true);
        this.invalidate();
    }

    public static void clearCacheDir() {
        File[] files;
        File dir = new File(CACHE_DIR);
        if (!dir.exists()) {
            dir.mkdir();
        }
        for (File file : files = dir.listFiles()) {
            file.delete();
        }
    }

    private void setFragmentTabsVisible(boolean visible) {
        this.headRuleTab_.setVisible(visible);
        this.chainTab_.setVisible(visible);
        this.positionTab_.setVisible(visible);
    }

    @Override
    public boolean performStorageOfInitialGeneralSettings() {
        try {
            this.saveRules(CACHE_DIR);
            this.showFragmentTabs_ = true;
            return true;
        }
        catch (NoRuleException | RulesException | SpectrummillParserException | IOException e1) {
            e1.printStackTrace();
            return false;
        }
    }

    @Override
    public void refreshGeneralSettingsDependantDisplay() {
        this.setFragmentTabsVisible(true);
        this.refreshMiddle(1);
    }

    @Override
    public String getAnalyteName() {
        return this.data_.getNameStringWithoutRt();
    }

    @Override
    public String getLipidClassName() {
        return this.ruleClassIdentifier_;
    }

    @Override
    public boolean areGeneralSettingsDependingFieldsVisible() {
        return this.showFragmentTabs_;
    }

    @Override
    public void updateGeneralSettings() {
        this.generalSettingsVO_ = this.generalSettings_.getValues();
        this.paintNewSpectra(false);
    }
}

