/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing.rdi;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.NoRuleException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.interfaces.rdi.GeneralSettingsPanelListener;
import at.tugraz.genome.lda.msn.FattyAcidsContainer;
import at.tugraz.genome.lda.msn.FragmentCalculator;
import at.tugraz.genome.lda.msn.parser.FragRuleParser;
import at.tugraz.genome.lda.verifier.GeneralSettingsVerifier;
import at.tugraz.genome.lda.vos.rdi.GeneralSettingsVO;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class GeneralSettingsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 8237230657153326314L;
    private JTextField chainsAmountField_;
    private JTextField alkylChainsAmountField_;
    private JTextField alkenylChainsAmountField_;
    private JTextField chainsLibraryField_;
    private JTextField carbonAtomsRuleField_;
    private JTextField doubleBondRuleField_;
    private JComboBox<String> singleChainIdentification_;
    private JTextField chainCutoffField_;
    private JComboBox<String> chainCutoffUnitCombo_;
    private JTextField basePeakCutoffField_;
    private String[] unitList_ = new String[]{"  ", "%", "\u2030"};
    private String[] trueFalseSeletion_ = new String[]{"true", "false"};
    private JComboBox<String> basePeakUnitCombo_;
    private JTextField spectrumCoverageField_;
    private JComboBox<String> spectrumCoverageUnitCombo_;
    private JComboBox<String> possibibilitiesPostProcessing_;
    private JComboBox<String> possibibilitiesParallelMode_;
    private JTextField rtMaxDevField_;
    private JTextField addChainPositions_;
    private static final String MS1_FIRST = "MS1 first";
    private static final String MSN_ONLY = "MSn only";
    private static final String MSN_FIRST = "MSn first";
    private static final String[] msIdCases_ = new String[]{"MS1 first", "MSn only", "MSn first"};
    private JComboBox<String> msIdentificationOrder_;
    private JButton saveGeneralRules_;
    private GeneralSettingsPanelListener listener_;
    private int DEFAULT_TEXT_INPUT_SIZE = 12;
    private static final String CHAIN_CUTOFF_DEFAULT = "default";
    private static final String ALKYLCHAINS_LABEL = "Alkylchains #";
    private static final String ALKENYLCHAINS_LABEL = "Alkenylchains #";
    private static final String CHAINCUTOFF_LABEL = "Chain Cutoff";
    private static final String RTMAXDEV_LABEL = "Retention Time Max Deviation";
    private static final String ADD_CHAIN_POSITIONS_LABEL = "Additional allowed positions";

    public GeneralSettingsPanel(GeneralSettingsVO vo, GeneralSettingsPanelListener listener) {
        this.listener_ = listener;
        this.init(vo);
    }

    private void init(GeneralSettingsVO vo) {
        this.setLayout(new GridBagLayout());
        JLabel spaceClass3 = new JLabel("    ");
        this.add((Component)spaceClass3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel chainsAmount = new JLabel("  Chains #  ");
        this.add((Component)chainsAmount, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.chainsAmountField_ = new JTextField();
        this.add((Component)this.chainsAmountField_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.chainsAmountField_.setColumns(this.DEFAULT_TEXT_INPUT_SIZE);
        String amountOfChains = null;
        if (vo.getAmountOfChains() != null) {
            amountOfChains = String.valueOf(vo.getAmountOfChains());
        }
        this.chainsAmountField_.setText(amountOfChains);
        this.chainsAmountField_.setToolTipText("Enter the amount of chains here!");
        this.chainsAmountField_.setInputVerifier(new GeneralSettingsVerifier(this));
        this.chainsAmountField_.setHorizontalAlignment(4);
        JLabel alkylChains = new JLabel("  Alkylchains #  ");
        this.add((Component)alkylChains, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.alkylChainsAmountField_ = new JTextField();
        this.add((Component)this.alkylChainsAmountField_, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.alkylChainsAmountField_.setColumns(this.DEFAULT_TEXT_INPUT_SIZE);
        String amountOfAlkylChains = null;
        if (vo.getAmountOfAlkylChains() != null) {
            amountOfAlkylChains = String.valueOf(vo.getAmountOfAlkylChains());
        }
        this.alkylChainsAmountField_.setText(amountOfAlkylChains);
        this.alkylChainsAmountField_.setToolTipText("Enter the amount of alkyl chains here!");
        this.alkylChainsAmountField_.setInputVerifier(new GeneralSettingsVerifier(this));
        this.alkylChainsAmountField_.setHorizontalAlignment(4);
        JLabel alkenylChains = new JLabel("  Alkenylchains #  ");
        this.add((Component)alkenylChains, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.alkenylChainsAmountField_ = new JTextField();
        this.add((Component)this.alkenylChainsAmountField_, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.alkenylChainsAmountField_.setColumns(this.DEFAULT_TEXT_INPUT_SIZE);
        String amountOfAlkenylChains = null;
        if (vo.getAmountOfAlkenylChains() != null) {
            amountOfAlkenylChains = String.valueOf(vo.getAmountOfAlkenylChains());
        }
        this.alkenylChainsAmountField_.setText(amountOfAlkenylChains);
        this.alkenylChainsAmountField_.setToolTipText("Enter the amount of alkenyl chains here!");
        this.alkenylChainsAmountField_.setInputVerifier(new GeneralSettingsVerifier(this));
        this.alkenylChainsAmountField_.setHorizontalAlignment(4);
        JLabel chainsLibrary = new JLabel("  Chain Library  ");
        this.add((Component)chainsLibrary, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.chainsLibraryField_ = new JTextField();
        this.add((Component)this.chainsLibraryField_, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.chainsLibraryField_.setColumns(this.DEFAULT_TEXT_INPUT_SIZE);
        this.chainsLibraryField_.setText(vo.getChainLibrary());
        this.chainsLibraryField_.setToolTipText("Enter the chain library here!");
        this.chainsLibraryField_.setInputVerifier(new GeneralSettingsVerifier(this));
        JButton selectButton = new JButton("Select");
        selectButton.setFont(selectButton.getFont().deriveFont(10.0f));
        selectButton.setMargin(new Insets(1, 5, 1, 5));
        this.add((Component)selectButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        selectButton.setToolTipText("Opens the file system");
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser chooser = new JFileChooser("fattyAcids");
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Excel-File", "xlsx");
                chooser.setFileFilter(filter);
                int returnVal = chooser.showOpenDialog(new JFrame());
                if (returnVal == 0) {
                    GeneralSettingsPanel.this.chainsLibraryField_.setText(chooser.getSelectedFile().getName());
                }
            }
        });
        JLabel carbonAtomsRule = new JLabel("  Carbon Atoms Rule  ");
        this.add((Component)carbonAtomsRule, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.carbonAtomsRuleField_ = new JTextField();
        this.add((Component)this.carbonAtomsRuleField_, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.carbonAtomsRuleField_.setColumns(this.DEFAULT_TEXT_INPUT_SIZE);
        this.carbonAtomsRuleField_.setText(vo.getCarbonAtomsRule());
        this.carbonAtomsRuleField_.setToolTipText("Enter the rule for carbon atoms here!");
        this.carbonAtomsRuleField_.setInputVerifier(new GeneralSettingsVerifier(this));
        JButton test1Button = new JButton("Test");
        test1Button.setFont(selectButton.getFont().deriveFont(10.0f));
        test1Button.setMargin(new Insets(1, 5, 1, 5));
        this.add((Component)test1Button, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        test1Button.setToolTipText("Shows the amount of carbon atoms for the entered rule");
        test1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int cAtoms = GeneralSettingsPanel.this.checkCAtomsRule(true);
                if (cAtoms > -1) {
                    JOptionPane.showMessageDialog(new JFrame(), "Number of Carbon Atoms = " + cAtoms);
                }
            }
        });
        JLabel doubleBondRule = new JLabel("  Double Bond Rule  ");
        this.add((Component)doubleBondRule, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.doubleBondRuleField_ = new JTextField();
        this.add((Component)this.doubleBondRuleField_, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.doubleBondRuleField_.setColumns(this.DEFAULT_TEXT_INPUT_SIZE);
        this.doubleBondRuleField_.setText(vo.getDoubleBondsRule());
        this.doubleBondRuleField_.setToolTipText("Enter the rule for double bonds here!");
        this.doubleBondRuleField_.setInputVerifier(new GeneralSettingsVerifier(this));
        JButton test2Button = new JButton("Test");
        test2Button.setFont(selectButton.getFont().deriveFont(10.0f));
        test2Button.setMargin(new Insets(1, 5, 1, 5));
        this.add((Component)test2Button, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        test2Button.setToolTipText("Shows the amount of double bonds for the entered rule");
        test2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int dbs = GeneralSettingsPanel.this.checkDoubleBondsRule(true);
                if (dbs > -1) {
                    JOptionPane.showMessageDialog(new JFrame(), "Number of Double Bonds = " + dbs);
                }
            }
        });
        JLabel singleChainIdentification = new JLabel("  Single Chain Identification ");
        this.add((Component)singleChainIdentification, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.singleChainIdentification_ = new JComboBox<String>(this.trueFalseSeletion_);
        this.singleChainIdentification_.setToolTipText("<html>Is an identification on one found chain sufficient?<html/>");
        if (vo.isAllowSingleChain()) {
            this.singleChainIdentification_.setSelectedIndex(0);
        } else {
            this.singleChainIdentification_.setSelectedIndex(1);
        }
        this.add(this.singleChainIdentification_, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.singleChainIdentification_.setInputVerifier(new GeneralSettingsVerifier(this));
        JLabel chainCutoffRule = new JLabel("  Chain Cutoff  ");
        this.add((Component)chainCutoffRule, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.chainCutoffField_ = new JTextField();
        this.add((Component)this.chainCutoffField_, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.chainCutoffField_.setColumns(this.DEFAULT_TEXT_INPUT_SIZE);
        String chainCutoffValue = vo.getChainCutoff();
        String ccMagnitude = " ";
        if (chainCutoffValue != null && (chainCutoffValue.endsWith("%") || chainCutoffValue.endsWith("\u2030"))) {
            ccMagnitude = chainCutoffValue.substring(chainCutoffValue.length() - 1);
            chainCutoffValue = chainCutoffValue.substring(0, chainCutoffValue.length() - 1);
        }
        if (chainCutoffValue != null) {
            try {
                double chainCutoff = Double.parseDouble(chainCutoffValue);
                if (chainCutoff < 0.0) {
                    chainCutoffValue = CHAIN_CUTOFF_DEFAULT;
                }
            }
            catch (NumberFormatException nfx) {
                chainCutoffValue = CHAIN_CUTOFF_DEFAULT;
            }
        } else {
            chainCutoffValue = CHAIN_CUTOFF_DEFAULT;
        }
        if (chainCutoffValue == null || chainCutoffValue.equalsIgnoreCase(CHAIN_CUTOFF_DEFAULT)) {
            ccMagnitude = "%";
        }
        this.chainCutoffField_.setText(chainCutoffValue);
        this.chainCutoffField_.setToolTipText("<html>Cutoff for removing minor chains<br/>The value is relative to the sum of intensities of the highest identified chain combination<html/>");
        this.chainCutoffField_.setInputVerifier(new GeneralSettingsVerifier(this));
        this.chainCutoffField_.setHorizontalAlignment(4);
        this.chainCutoffUnitCombo_ = new JComboBox<String>(this.unitList_);
        this.chainCutoffUnitCombo_.setSelectedItem(ccMagnitude);
        this.chainCutoffUnitCombo_.setToolTipText("Choose a unit!");
        this.add(this.chainCutoffUnitCombo_, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.chainCutoffUnitCombo_.setInputVerifier(new GeneralSettingsVerifier(this));
        JLabel basePeakCutoffRule = new JLabel("  Base Peak Cutoff  ");
        this.add((Component)basePeakCutoffRule, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.basePeakCutoffField_ = new JTextField();
        this.add((Component)this.basePeakCutoffField_, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.basePeakCutoffField_.setColumns(this.DEFAULT_TEXT_INPUT_SIZE);
        String basePeakValue = vo.getBasePeakCutoff();
        String bpMagnitude = " ";
        if (basePeakValue.endsWith("%") || basePeakValue.endsWith("\u2030")) {
            bpMagnitude = basePeakValue.substring(basePeakValue.length() - 1);
            basePeakValue = basePeakValue.substring(0, basePeakValue.length() - 1);
        }
        this.basePeakCutoffField_.setText(basePeakValue);
        this.basePeakCutoffField_.setToolTipText("Enter the base peak cutoff here!");
        this.basePeakCutoffField_.setInputVerifier(new GeneralSettingsVerifier(this));
        this.basePeakCutoffField_.setHorizontalAlignment(4);
        this.basePeakUnitCombo_ = new JComboBox<String>(this.unitList_);
        this.basePeakUnitCombo_.setSelectedItem(bpMagnitude);
        this.basePeakUnitCombo_.setToolTipText("Choose a unit!");
        this.add(this.basePeakUnitCombo_, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.basePeakUnitCombo_.setInputVerifier(new GeneralSettingsVerifier(this));
        JLabel spectrumCoverageRule = new JLabel("  Spectrum Coverage  ");
        this.add((Component)spectrumCoverageRule, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.spectrumCoverageField_ = new JTextField();
        this.add((Component)this.spectrumCoverageField_, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.spectrumCoverageField_.setColumns(this.DEFAULT_TEXT_INPUT_SIZE);
        String spCovValue = vo.getSpectrumCoverage();
        String spCovMagnitude = " ";
        if (spCovValue != null && (spCovValue.endsWith("%") || spCovValue.endsWith("\u2030"))) {
            spCovMagnitude = spCovValue.substring(spCovValue.length() - 1);
            spCovValue = spCovValue.substring(0, spCovValue.length() - 1);
        }
        if (spCovValue == null) {
            spCovMagnitude = "%";
        }
        this.spectrumCoverageField_.setText(spCovValue);
        this.spectrumCoverageField_.setToolTipText("Enter the spectrum coverage here!");
        this.spectrumCoverageField_.setInputVerifier(new GeneralSettingsVerifier(this));
        this.spectrumCoverageField_.setHorizontalAlignment(4);
        this.spectrumCoverageUnitCombo_ = new JComboBox<String>(this.unitList_);
        this.spectrumCoverageUnitCombo_.setSelectedItem(spCovMagnitude);
        this.spectrumCoverageUnitCombo_.setToolTipText("Choose a unit!");
        this.add(this.spectrumCoverageUnitCombo_, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.spectrumCoverageUnitCombo_.setInputVerifier(new GeneralSettingsVerifier(this));
        JLabel retentionTimePostProcessing = new JLabel("  Retention Time Post Processing ");
        this.add((Component)retentionTimePostProcessing, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        String[] possibibilityListPostProcessing = new String[]{"true", "false"};
        this.possibibilitiesPostProcessing_ = new JComboBox<String>(possibibilityListPostProcessing);
        this.possibibilitiesPostProcessing_.setToolTipText("Choose the retention time post processing!");
        if (vo.isRtPostProcessing()) {
            this.possibibilitiesPostProcessing_.setSelectedIndex(0);
        } else {
            this.possibibilitiesPostProcessing_.setSelectedIndex(1);
        }
        this.add(this.possibibilitiesPostProcessing_, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel retentionTimeParallelModel = new JLabel("  Retention Time Parallel Series ");
        this.add((Component)retentionTimeParallelModel, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        String[] possibibilitiesListParallelMode = new String[]{"true", "false"};
        this.possibibilitiesParallelMode_ = new JComboBox<String>(possibibilitiesListParallelMode);
        this.possibibilitiesParallelMode_.setToolTipText("Choose the retention time parallel series!");
        if (vo.isRtParallelSeries()) {
            this.possibibilitiesParallelMode_.setSelectedIndex(0);
        } else {
            this.possibibilitiesParallelMode_.setSelectedIndex(1);
        }
        this.add(this.possibibilitiesParallelMode_, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel rtMaxDevLabel = new JLabel("  Retention Time Max Deviation  ");
        this.add((Component)rtMaxDevLabel, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.rtMaxDevField_ = new JTextField();
        this.add((Component)this.rtMaxDevField_, new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.rtMaxDevField_.setColumns(this.DEFAULT_TEXT_INPUT_SIZE);
        String rtMaxDevValue = null;
        if (vo.getRtMaxDeviation() != null) {
            rtMaxDevValue = vo.getRtMaxDeviation().toString();
        }
        this.rtMaxDevField_.setText(rtMaxDevValue);
        this.rtMaxDevField_.setToolTipText("<html>Maximally allowed time deviation from the calcuated RT model<br/>If nothing is entered, the algorithm automatically allows four times the mean deviation as tolerance<html/>");
        this.rtMaxDevField_.setHorizontalAlignment(4);
        JLabel unitLabel = new JLabel("min");
        this.add((Component)unitLabel, new GridBagConstraints(5, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel msIdOrderLabel = new JLabel("  MS Identification Order ");
        this.add((Component)msIdOrderLabel, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.msIdentificationOrder_ = new JComboBox<String>(msIdCases_);
        this.msIdentificationOrder_.setToolTipText("<html>The sequence for the application of the MS1 and MSn algorithms (influences search time):<br/>&nbsp;&nbsp;MS<sup>1</sup> first: the data is searched first with the MS<sup>1</sup> algorithm first - default setting<br/>&nbsp;&nbsp;MS<sup>n</sup> only: MSn spectra are searched for candidates - MS<sup>1</sup> identification is performed only where MS<sup>n</sup> hits are detected<br/>&nbsp;&nbsp;MS<sup>n</sup> first: MSn spectra are searched for candidates - MS<sup>1</sup> identidication is performed where MS<sup>n</sup> hits are detected<br/>&nbsp;&nbsp;&nbsp;&nbsp;plus at retention times that are predicted for species not identified by MS<sup>n</sup><html/>");
        if (vo.getMsIdentificationOrder() == 0) {
            this.msIdentificationOrder_.setSelectedItem(MS1_FIRST);
        } else if (vo.getMsIdentificationOrder() == 2) {
            this.msIdentificationOrder_.setSelectedItem(MSN_ONLY);
        } else if (vo.getMsIdentificationOrder() == 1) {
            this.msIdentificationOrder_.setSelectedItem(MSN_FIRST);
        }
        this.add(this.msIdentificationOrder_, new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel addChainPositions = new JLabel("  Additional allowed positions  ");
        this.add((Component)addChainPositions, new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addChainPositions_ = new JTextField();
        this.addChainPositions_.setToolTipText("<html>Are ther more chain positions possible than fatty acids<br/>&nbsp;&nbsp;&nbsp;&nbsp;plus this is e.g. the case for DG class.<sup>n</sup><html/>");
        this.add((Component)this.addChainPositions_, new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.addChainPositions_.setColumns(this.DEFAULT_TEXT_INPUT_SIZE);
        String addPoss = null;
        if (vo.getAddChainPositions() != null && vo.getAddChainPositions() > 0) {
            addPoss = String.valueOf(vo.getAddChainPositions());
        }
        this.addChainPositions_.setText(addPoss);
        this.addChainPositions_.setInputVerifier(new GeneralSettingsVerifier(this));
        this.addChainPositions_.setHorizontalAlignment(4);
        this.saveGeneralRules_ = new JButton(" Save General Settings and Continue ");
        this.saveGeneralRules_.addActionListener(this);
        this.saveGeneralRules_.setActionCommand("saveGeneralRules");
        if (!this.listener_.areGeneralSettingsDependingFieldsVisible()) {
            this.add((Component)this.saveGeneralRules_, new GridBagConstraints(0, 9, 6, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        }
    }

    private boolean checkGeneralEntries(boolean verbose) {
        boolean inputOK;
        int chainsAmount = 0;
        if (this.chainsAmountField_.getText() == null || this.chainsAmountField_.getText().length() < 1) {
            if (verbose) {
                new WarningMessage(new JFrame(), "Error", "You have to enter a value for the \"Chains #\"");
            }
            this.chainsAmountField_.requestFocus();
            return false;
        }
        boolean inputOK2 = this.checkIntValueInRange(this.chainsAmountField_, "Chains #", 1, 10, verbose);
        if (!inputOK2) {
            this.chainsAmountField_.requestFocus();
            return false;
        }
        chainsAmount = Integer.parseInt(this.chainsAmountField_.getText());
        int alkylChains = 0;
        if (this.alkylChainsAmountField_ != null && this.alkylChainsAmountField_.getText().trim().length() > 0) {
            boolean inputOK3 = this.checkIntValueInRange(this.alkylChainsAmountField_, ALKYLCHAINS_LABEL, 0, chainsAmount, verbose);
            if (inputOK3) {
                alkylChains = Integer.parseInt(this.alkylChainsAmountField_.getText());
            } else {
                this.alkylChainsAmountField_.requestFocus();
                return false;
            }
        }
        int alkenylChains = 0;
        if (this.alkenylChainsAmountField_ != null && this.alkenylChainsAmountField_.getText().trim().length() > 0) {
            boolean inputOK4 = this.checkIntValueInRange(this.alkenylChainsAmountField_, ALKENYLCHAINS_LABEL, 0, chainsAmount, verbose);
            if (inputOK4) {
                alkenylChains = Integer.parseInt(this.alkenylChainsAmountField_.getText());
            } else {
                this.alkenylChainsAmountField_.requestFocus();
                return false;
            }
        }
        if (alkylChains + alkenylChains > chainsAmount) {
            if (verbose) {
                new WarningMessage(new JFrame(), "Error", "The sum of  \"Alkylchains #\"+\"Alkenylchains #\" must not be greater than \"Chains #\"");
            }
            if (alkenylChains > alkylChains) {
                this.alkenylChainsAmountField_.requestFocus();
            } else {
                this.alkylChainsAmountField_.requestFocus();
            }
            return false;
        }
        if (this.chainsLibraryField_.getText() == null || this.chainsLibraryField_.getText().length() < 1) {
            if (verbose) {
                new WarningMessage(new JFrame(), "Error", "You have to enter a value for the \"Chain Library\"");
            }
            this.chainsLibraryField_.requestFocus();
            return false;
        }
        try {
            FattyAcidsContainer.getAllFattyAcidChains(this.chainsLibraryField_.getText());
        }
        catch (NoRuleException | RulesException | IOException e) {
            if (verbose) {
                new WarningMessage(new JFrame(), "Error", "There is something wrong with your selected chain library: " + e.getMessage());
            }
            this.chainsLibraryField_.requestFocus();
            return false;
        }
        if (this.carbonAtomsRuleField_.getText() == null || this.carbonAtomsRuleField_.getText().length() < 1) {
            if (verbose) {
                new WarningMessage(new JFrame(), "Error", "You have to enter a value for the \"Carbon Atoms Rule\"");
            }
            this.carbonAtomsRuleField_.requestFocus();
            return false;
        }
        if (this.checkCAtomsRule(verbose) < 0) {
            this.carbonAtomsRuleField_.requestFocus();
            return false;
        }
        if (this.doubleBondRuleField_.getText() == null || this.doubleBondRuleField_.getText().length() < 1) {
            if (verbose) {
                new WarningMessage(new JFrame(), "Error", "You have to enter a value for the \"Double Bond Rule\"");
            }
            this.doubleBondRuleField_.requestFocus();
            return false;
        }
        if (this.checkDoubleBondsRule(verbose) < 0) {
            this.doubleBondRuleField_.requestFocus();
            return false;
        }
        if (this.chainCutoffField_.getText() != null && this.chainCutoffField_.getText().trim().length() > 0 && !this.chainCutoffField_.getText().trim().equalsIgnoreCase(CHAIN_CUTOFF_DEFAULT) && !this.isBetween0And100Percent(this.chainCutoffField_.getText(), (String)this.chainCutoffUnitCombo_.getSelectedItem(), CHAINCUTOFF_LABEL, verbose)) {
            this.chainCutoffField_.requestFocus();
            return false;
        }
        if (this.spectrumCoverageField_.getText() != null && this.spectrumCoverageField_.getText().trim().length() > 0 && !this.isBetween0And100Percent(this.spectrumCoverageField_.getText(), (String)this.spectrumCoverageUnitCombo_.getSelectedItem(), "spectrum coverage", verbose)) {
            this.spectrumCoverageField_.requestFocus();
            return false;
        }
        if (!this.isBetween0And100Percent(this.basePeakCutoffField_.getText(), (String)this.basePeakUnitCombo_.getSelectedItem(), "base peak cutoff", verbose)) {
            this.basePeakCutoffField_.requestFocus();
            return false;
        }
        if (this.rtMaxDevField_.getText() != null && this.rtMaxDevField_.getText().trim().length() > 0) {
            try {
                double value = Double.parseDouble(this.rtMaxDevField_.getText());
                if (value <= 0.0) {
                    if (verbose) {
                        new WarningMessage(new JFrame(), "Error", "The \"Retention Time Max Deviation\" value must be a positive value greather than 0");
                    }
                    this.rtMaxDevField_.requestFocus();
                    return false;
                }
            }
            catch (NumberFormatException nfx) {
                if (verbose) {
                    new WarningMessage(new JFrame(), "Error", "The \"Retention Time Max Deviation\" value must be double format");
                }
                this.rtMaxDevField_.requestFocus();
                return false;
            }
        }
        if (this.addChainPositions_.getText() != null && this.addChainPositions_.getText().trim().length() > 0 && !(inputOK = this.checkIntValueInRange(this.addChainPositions_, ADD_CHAIN_POSITIONS_LABEL, 0, 10, verbose))) {
            this.addChainPositions_.requestFocus();
            return false;
        }
        return true;
    }

    private boolean checkIntValueInRange(JTextField input, String label, int min, int max, boolean verbose) {
        try {
            int value = Integer.parseInt(input.getText());
            if (value < min) {
                if (verbose) {
                    new WarningMessage(new JFrame(), "Error", "The \"" + label + "\" value cannot be smaller than " + min);
                }
                return false;
            }
            if (value > max) {
                if (verbose) {
                    new WarningMessage(new JFrame(), "Error", "The \"" + label + "\" value cannot be higher than " + max);
                }
                return false;
            }
            return true;
        }
        catch (NumberFormatException nfx) {
            if (verbose) {
                new WarningMessage(new JFrame(), "Error", "The \"" + label + "\" value must be integer format");
            }
            return false;
        }
    }

    private String getFullPercentValue(String input, String magnitude) {
        String value = new String(input);
        if (!magnitude.equalsIgnoreCase(" ")) {
            value = value + magnitude;
        }
        return value;
    }

    private boolean isBetween0And100Percent(String input, String magnitude, String fieldName, boolean verbose) {
        try {
            FragRuleParser.readPercentPermilleValue(this.getFullPercentValue(input, magnitude), fieldName, -1);
            return true;
        }
        catch (RulesException e) {
            if (verbose) {
                if (e.getMessage().indexOf("must be double format") != -1) {
                    new WarningMessage(new JFrame(), "Error", "The " + fieldName + " value is not a number");
                } else if (e.getMessage().indexOf("must not be negative") != -1) {
                    new WarningMessage(new JFrame(), "Error", "The " + fieldName + " must not be smaller than 0!");
                } else if (e.getMessage().indexOf("must not be bigger than 100%") != -1) {
                    new WarningMessage(new JFrame(), "Error", "The " + fieldName + " must not be bigger or equal than 100%!");
                }
            }
            return false;
        }
    }

    private int checkCAtomsRule(boolean verbose) {
        try {
            int value = FragmentCalculator.getIntValueFromParsingRule(this.carbonAtomsRuleField_.getText(), this.listener_.getAnalyteName(), this.listener_.getLipidClassName(), "Carbon Atoms Rule");
            return value;
        }
        catch (RulesException rx) {
            if (verbose) {
                new WarningMessage(new JFrame(), "Error", rx.getMessage());
            }
            return -1;
        }
    }

    private int checkDoubleBondsRule(boolean verbose) {
        try {
            int value = FragmentCalculator.getIntValueFromParsingRule(this.doubleBondRuleField_.getText(), this.listener_.getAnalyteName(), this.listener_.getLipidClassName(), "Double Bond Rule");
            return value;
        }
        catch (RulesException rx) {
            if (verbose) {
                new WarningMessage(new JFrame(), "Error", rx.getMessage());
            }
            return -1;
        }
    }

    public boolean updateGeneralEntries() {
        return this.updateGeneralEntries(true);
    }

    public boolean updateGeneralEntries(boolean verbose) {
        if (!this.listener_.areGeneralSettingsDependingFieldsVisible()) {
            return true;
        }
        if (!this.checkGeneralEntries(verbose)) {
            return false;
        }
        this.listener_.updateGeneralSettings();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equalsIgnoreCase("saveGeneralRules")) {
            if (!this.checkGeneralEntries(true)) {
                return;
            }
            if (this.listener_.performStorageOfInitialGeneralSettings()) {
                this.saveGeneralRules_.setVisible(false);
                this.listener_.refreshGeneralSettingsDependantDisplay();
            }
        }
    }

    private static boolean isNumeric(String input) {
        try {
            Double.parseDouble(input);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public GeneralSettingsVO getValues() {
        double value;
        double value2;
        Integer alkylChains = this.readIntegerFromTextField(this.alkylChainsAmountField_);
        Integer alkenylChains = this.readIntegerFromTextField(this.alkenylChainsAmountField_);
        boolean isSingleChainAllowed = this.readBooleanComboBox(this.singleChainIdentification_);
        String chainCutoff = null;
        if (this.chainCutoffField_.getText() != null && this.chainCutoffField_.getText().trim().length() > 0 && !this.chainCutoffField_.getText().trim().equalsIgnoreCase(CHAIN_CUTOFF_DEFAULT) && (value2 = Double.parseDouble(this.chainCutoffField_.getText())) > 0.0) {
            chainCutoff = this.chainCutoffField_.getText();
            if (!((String)this.chainCutoffUnitCombo_.getSelectedItem()).endsWith(" ")) {
                chainCutoff = chainCutoff + (String)this.chainCutoffUnitCombo_.getSelectedItem();
            }
        }
        String basePeakCutoff = this.basePeakCutoffField_.getText();
        if (!((String)this.basePeakUnitCombo_.getSelectedItem()).endsWith(" ")) {
            basePeakCutoff = basePeakCutoff + (String)this.basePeakUnitCombo_.getSelectedItem();
        }
        String spectrumCoverage = null;
        if (this.spectrumCoverageField_.getText() != null && this.spectrumCoverageField_.getText().trim().length() > 0 && (value = Double.parseDouble(this.spectrumCoverageField_.getText())) >= 0.0) {
            spectrumCoverage = this.spectrumCoverageField_.getText();
            if (!((String)this.spectrumCoverageUnitCombo_.getSelectedItem()).endsWith(" ")) {
                spectrumCoverage = spectrumCoverage + (String)this.spectrumCoverageUnitCombo_.getSelectedItem();
            }
        }
        boolean rtPostProcessing = this.readBooleanComboBox(this.possibibilitiesPostProcessing_);
        boolean rtParallelSeries = this.readBooleanComboBox(this.possibibilitiesParallelMode_);
        Double rtMaxDev = this.readDoubleFromTextField(this.rtMaxDevField_);
        int msIdOrder = 0;
        if (this.msIdentificationOrder_.getItemAt(this.msIdentificationOrder_.getSelectedIndex()).equalsIgnoreCase(MSN_ONLY)) {
            msIdOrder = 2;
        }
        if (this.msIdentificationOrder_.getItemAt(this.msIdentificationOrder_.getSelectedIndex()).equalsIgnoreCase(MSN_FIRST)) {
            msIdOrder = 1;
        }
        Integer addPositions = this.readIntegerFromTextField(this.addChainPositions_);
        GeneralSettingsVO settings = new GeneralSettingsVO(new Integer(this.chainsAmountField_.getText()), alkylChains, alkenylChains, null, addPositions, this.chainsLibraryField_.getText(), null, -1, -1, -1, -1, this.carbonAtomsRuleField_.getText(), this.doubleBondRuleField_.getText(), isSingleChainAllowed, chainCutoff, basePeakCutoff, spectrumCoverage, rtPostProcessing, rtParallelSeries, rtMaxDev, msIdOrder);
        return settings;
    }

    private Integer readIntegerFromTextField(JTextField field) {
        Integer value = null;
        if (field.getText() != null && field.getText().trim().length() > 0) {
            value = new Integer(field.getText());
        }
        return value;
    }

    private Double readDoubleFromTextField(JTextField field) {
        Double value = null;
        if (field.getText() != null && field.getText().trim().length() > 0) {
            value = new Double(field.getText());
        }
        return value;
    }

    private boolean readBooleanComboBox(JComboBox<String> box) {
        boolean value = false;
        if (box.getItemAt(box.getSelectedIndex()).equalsIgnoreCase("true")) {
            value = true;
        }
        return value;
    }

    public boolean checkPercentageFieldsForNumbers() {
        if (GeneralSettingsPanel.isNumeric(this.basePeakCutoffField_.getText())) {
            return true;
        }
        JOptionPane.showMessageDialog(new JFrame(), "The Base Peak Cutoff Field is not a number!");
        return false;
    }
}

