/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.target.calibration;

import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

public class IdentificationVO {
    private ArrayList<File> files_ = new ArrayList();
    private String lipidClass_;
    private String lipidSpecies_;
    private boolean isMSnAvailable_ = false;
    private ArrayList<Double> retentionTimes_ = new ArrayList();
    private ArrayList<Double> areas_ = new ArrayList();
    private double groupingParameter_ = 0.05;

    protected IdentificationVO(File file, String lipidClass, LipidParameterSet param) {
        this.files_.add(file);
        this.lipidClass_ = lipidClass;
        this.lipidSpecies_ = param.getNameStringWithoutRt();
        this.isMSnAvailable_ = param instanceof LipidomicsMSnSet;
        this.retentionTimes_.add(param.getPreciseRT());
        this.areas_.add(new Double(param.getArea()));
    }

    protected boolean addParam(File file, LipidParameterSet param) {
        Double paramRT = param.getPreciseRT();
        for (int i = 0; i < this.retentionTimes_.size(); ++i) {
            Double rT = this.retentionTimes_.get(i);
            if (!(paramRT >= rT - this.groupingParameter_) || !(paramRT <= rT + this.groupingParameter_)) continue;
            this.files_.add(file);
            this.isMSnAvailable_ = param instanceof LipidomicsMSnSet ? true : this.isMSnAvailable_;
            this.retentionTimes_.add(param.getPreciseRT());
            this.areas_.add(new Double(param.getArea()));
            return true;
        }
        return false;
    }

    Double getAverageRT() {
        Double sum = 0.0;
        for (Double rT : this.retentionTimes_) {
            sum = sum + rT;
        }
        return sum / (double)this.retentionTimes_.size();
    }

    Double getAverageArea() {
        Double sum = 0.0;
        for (Double area : this.areas_) {
            sum = sum + area;
        }
        return sum / (double)this.areas_.size();
    }

    boolean isMSnAvailable() {
        return this.isMSnAvailable_;
    }

    protected boolean isIdentificationUnambiguous() {
        HashSet<File> uniqueFiles = new HashSet<File>(this.files_);
        return uniqueFiles.size() == this.files_.size();
    }

    int getIdentificationCount() {
        HashSet<File> uniqueFiles = new HashSet<File>(this.files_);
        return uniqueFiles.size();
    }

    protected String getLipidClass() {
        return this.lipidClass_;
    }

    protected String getLipidSpecies() {
        return this.lipidSpecies_;
    }

    public String toString() {
        return "IdentificationVO [files_=" + this.files_ + ", lipidClass_=" + this.lipidClass_ + ", lipidSpecies_=" + this.lipidSpecies_ + ", isMSnAvailable_=" + this.isMSnAvailable_ + ", retentionTimes_=" + this.retentionTimes_ + ", areas_=" + this.areas_ + "]";
    }
}

