/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.target.calibration;

import at.tugraz.genome.lda.target.calibration.IdentificationVO;
import at.tugraz.genome.lda.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class MatchedIdentificationVO {
    ArrayList<IdentificationVO> originals_;
    int maxOriginals_;
    ArrayList<IdentificationVO> matches_;
    int maxMatches_;
    Pair<IdentificationVO, IdentificationVO> highestConfidencePair_;
    int confidence_ = 0;
    ArrayList<Pair<IdentificationVO, IdentificationVO>> elutionOrderAssignments_ = new ArrayList();

    protected MatchedIdentificationVO(ArrayList<IdentificationVO> originals, int maxOriginals, ArrayList<IdentificationVO> matches, int maxMatches) {
        this.originals_ = originals;
        this.maxOriginals_ = maxOriginals;
        this.matches_ = matches;
        this.maxMatches_ = maxMatches;
        this.findHighestConfidencePair();
        this.findElutionOrderAssignments();
    }

    private void findElutionOrderAssignments() {
        int i;
        int indexMatch;
        Collections.sort(this.originals_, this.obtainRTComparator());
        Collections.sort(this.matches_, this.obtainRTComparator());
        int indexOriginal = this.originals_.indexOf(this.highestConfidencePair_.getKey());
        int j = indexMatch = this.matches_.indexOf(this.highestConfidencePair_.getValue());
        for (i = indexOriginal - 1; i >= 0; --i) {
            if (--j < 0) continue;
            this.elutionOrderAssignments_.add(new Pair<IdentificationVO, IdentificationVO>(this.originals_.get(i), this.matches_.get(j)));
        }
        j = indexMatch;
        for (i = indexOriginal + 1; i < this.originals_.size(); ++i) {
            if (++j >= this.matches_.size()) continue;
            this.elutionOrderAssignments_.add(new Pair<IdentificationVO, IdentificationVO>(this.originals_.get(i), this.matches_.get(j)));
        }
    }

    private void findHighestConfidencePair() {
        Collections.sort(this.originals_, this.obtainAreaComparator());
        Collections.sort(this.matches_, this.obtainAreaComparator());
        IdentificationVO highestIntensityOriginal = this.originals_.get(0);
        IdentificationVO highestIntensityMatch = this.matches_.get(0);
        this.highestConfidencePair_ = new Pair<IdentificationVO, IdentificationVO>(highestIntensityOriginal, highestIntensityMatch);
        this.confidence_ = this.isAlwaysFound(highestIntensityOriginal, this.maxOriginals_) && this.isAlwaysFound(highestIntensityMatch, this.maxMatches_) && this.isIntensityElutionOrderCorrelated() ? 2 : 0;
    }

    private boolean isIntensityElutionOrderCorrelated() {
        if (this.getNumberMSn(this.originals_) == 1 && this.getNumberMSn(this.matches_) == 1 && this.areBothMSn(this.originals_.get(0), this.matches_.get(0))) {
            return true;
        }
        if (this.getNumberMSn(this.originals_) == 1 || this.getNumberMSn(this.matches_) == 1) {
            return false;
        }
        return this.originals_.size() > 1 && this.matches_.size() > 1 && this.isCorrelatedTopDown();
    }

    private boolean isCorrelatedTopDown() {
        boolean isCorrelated = false;
        for (int i = 0; i < Math.min(this.originals_.size(), this.matches_.size()) - 1; ++i) {
            if (this.areBothMSn(this.originals_.get(i), this.matches_.get(i)) && this.areBothMSn(this.originals_.get(i + 1), this.matches_.get(i + 1))) {
                if (!(this.originals_.get(i).getAverageRT() > this.originals_.get(i + 1).getAverageRT() && this.matches_.get(i).getAverageRT() > this.matches_.get(i + 1).getAverageRT() || this.originals_.get(i).getAverageRT() < this.originals_.get(i + 1).getAverageRT() && this.matches_.get(i).getAverageRT() < this.matches_.get(i + 1).getAverageRT())) {
                    return false;
                }
            } else {
                if (i == 0) {
                    return false;
                }
                return isCorrelated;
            }
            isCorrelated = true;
        }
        return isCorrelated;
    }

    private int getNumberMSn(ArrayList<IdentificationVO> vos) {
        int count = 0;
        for (IdentificationVO vo : vos) {
            if (!vo.isMSnAvailable()) continue;
            ++count;
        }
        return count;
    }

    private boolean isAlwaysFound(IdentificationVO vo, int max) {
        return vo.getIdentificationCount() == max;
    }

    private boolean areBothMSn(IdentificationVO vo1, IdentificationVO vo2) {
        return vo1.isMSnAvailable() && vo2.isMSnAvailable();
    }

    private Comparator<IdentificationVO> obtainAreaComparator() {
        return new Comparator<IdentificationVO>(){

            @Override
            public int compare(IdentificationVO o1, IdentificationVO o2) {
                return -o1.getAverageArea().compareTo(o2.getAverageArea());
            }
        };
    }

    private Comparator<IdentificationVO> obtainRTComparator() {
        return new Comparator<IdentificationVO>(){

            @Override
            public int compare(IdentificationVO o1, IdentificationVO o2) {
                return o1.getAverageRT().compareTo(o2.getAverageRT());
            }
        };
    }

    public Pair<IdentificationVO, IdentificationVO> getHighestConfidencePair() {
        return this.highestConfidencePair_;
    }

    public int getConfidence() {
        return this.confidence_;
    }

    public ArrayList<Pair<IdentificationVO, IdentificationVO>> getElutionOrderAssignments() {
        return this.elutionOrderAssignments_;
    }
}

