/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.target.calibration;

import at.tugraz.genome.lda.target.calibration.CalibrationGraphPanel;
import at.tugraz.genome.lda.target.calibration.RecalibrationPlotMouseListener;
import at.tugraz.genome.lda.target.calibration.RecalibrationRegression;
import at.tugraz.genome.lda.utils.Pair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.util.ShapeUtils;
import org.jfree.data.function.Function2D;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class RecalibrationPlot
extends JPanel {
    private static final long serialVersionUID = 1L;
    ArrayList<Pair<Double, Double>> dataAll_;
    ArrayList<Pair<Double, Double>> dataStandards_;
    CalibrationGraphPanel panel_;
    XYDataset curveFitDataset_;
    XYDataset scatterPlotStandardsDataset_;
    XYDataset scatterPlotDataset_;

    public RecalibrationPlot(ArrayList<Pair<Double, Double>> data, ArrayList<Pair<Double, Double>> dataStandards, RecalibrationRegression regression, Dimension dimension, CalibrationGraphPanel panel) {
        this.dataAll_ = new ArrayList<Pair<Double, Double>>(data);
        this.dataStandards_ = dataStandards;
        this.panel_ = panel;
        this.dataAll_.removeAll(this.dataStandards_);
        XYPlot plot = new XYPlot();
        Font fontTitle = new Font("Dialog", 1, 25);
        Font fontLabel = new Font("Dialog", 0, 20);
        Font tickLabel = new Font("Dialog", 0, 14);
        plot.setDomainAxis(0, (ValueAxis)this.getAxis("Retention time original target list /min", fontLabel, tickLabel));
        plot.setRangeAxis(0, (ValueAxis)this.getAxis("Retention time difference original vs new target list /min", fontLabel, tickLabel));
        plot.mapDatasetToDomainAxis(0, 0);
        plot.mapDatasetToRangeAxis(0, 0);
        this.curveFitDataset_ = this.getCurveFitDataset(regression);
        plot.setDataset(0, this.curveFitDataset_);
        plot.setRenderer(0, (XYItemRenderer)this.getCurveRenderer(fontLabel));
        this.scatterPlotStandardsDataset_ = this.getScatterPlotDataset(this.dataStandards_, String.format("Standards (%s calibrants)", this.dataStandards_.size()));
        plot.setDataset(1, this.scatterPlotStandardsDataset_);
        plot.setRenderer(1, (XYItemRenderer)this.getScatterRenderer(fontLabel, new Color(204, 0, 0)));
        this.scatterPlotDataset_ = this.getScatterPlotDataset(this.dataAll_, String.format("Other (%s calibrants)", this.dataAll_.size()));
        plot.setDataset(2, this.scatterPlotDataset_);
        plot.setRenderer(2, (XYItemRenderer)this.getScatterRenderer(fontLabel, new Color(153, 204, 255)));
        JFreeChart chart = new JFreeChart("Target list recalibration curve", fontTitle, (Plot)plot, true);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.addChartMouseListener((ChartMouseListener)new RecalibrationPlotMouseListener(this));
        chartPanel.setPreferredSize(dimension);
        this.add((Component)chartPanel);
    }

    private NumberAxis getAxis(String label, Font fontLabel, Font tickLabel) {
        NumberAxis axis = new NumberAxis(label);
        axis.setLabelFont(fontLabel);
        axis.setTickLabelFont(tickLabel);
        return axis;
    }

    private XYLineAndShapeRenderer getCurveRenderer(Font fontLabel) {
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        renderer.setSeriesPaint(0, (Paint)new Color(0, 0, 102));
        renderer.setSeriesPaint(1, (Paint)new Color(0, 0, 102));
        renderer.setDefaultLegendTextFont(fontLabel);
        renderer.setAutoPopulateSeriesStroke(false);
        renderer.setDefaultStroke((Stroke)new BasicStroke(2.0f));
        return renderer;
    }

    private XYDataset getCurveFitDataset(RecalibrationRegression regression) {
        int num = 10000;
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries dataSeries = new XYSeries((Comparable)((Object)"Fitted recalibration curve"));
        double upperLimit = regression.getUpperRTLimit();
        double lowerLimit = regression.getLowerRTLimit();
        double step = (upperLimit - lowerLimit) / (double)num;
        for (int i = 0; i <= num; ++i) {
            double x = lowerLimit + (double)i * step;
            if (!regression.getFunction().isValidPoint(x)) continue;
            double y = regression.getFunction().value(x);
            dataSeries.add(x, y);
        }
        dataset.addSeries(dataSeries);
        return dataset;
    }

    public static XYSeries sampleFunctionOverY(Function2D f, double start, double end, int samples, Comparable<?> seriesKey) {
        XYSeries series = new XYSeries(seriesKey, false);
        double step = (end - start) / (double)(samples - 1);
        for (int i = 0; i < samples; ++i) {
            double y = start + step * (double)i;
            series.add(f.getValue(y), y);
        }
        return series;
    }

    private XYLineAndShapeRenderer getScatterRenderer(Font fontLabel, Color fillPaint) {
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(false, true);
        renderer.setDefaultLegendTextFont(fontLabel);
        renderer.setDefaultFillPaint((Paint)fillPaint);
        renderer.setDefaultOutlinePaint((Paint)new Color(64, 64, 64));
        renderer.setUseFillPaint(true);
        renderer.setUseOutlinePaint(true);
        renderer.setSeriesShape(0, ShapeUtils.createDiamond((float)5.0f));
        return renderer;
    }

    private XYDataset getScatterPlotDataset(ArrayList<Pair<Double, Double>> data, String label) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries dataSeries = new XYSeries((Comparable)((Object)label));
        for (Pair<Double, Double> dataPoint : data) {
            dataSeries.add((Number)dataPoint.getKey(), (Number)dataPoint.getValue());
        }
        dataset.addSeries(dataSeries);
        return dataset;
    }

    public ArrayList<Pair<Double, Double>> getDataAll() {
        return this.dataAll_;
    }

    public ArrayList<Pair<Double, Double>> getDataStandards() {
        return this.dataStandards_;
    }

    public CalibrationGraphPanel getPanel() {
        return this.panel_;
    }

    public XYDataset getCurveFitDataset() {
        return this.curveFitDataset_;
    }

    public XYDataset getScatterPlotStandardsDataset() {
        return this.scatterPlotStandardsDataset_;
    }

    public XYDataset getScatterPlotDataset() {
        return this.scatterPlotDataset_;
    }
}

