/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.target.calibration;

import at.tugraz.genome.lda.utils.Pair;
import java.util.ArrayList;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math3.exception.OutOfRangeException;

public class RecalibrationRegression {
    private ArrayList<Pair<Double, Double>> differences_;
    private double grouping_;
    private ArrayList<Pair<Double, Double>> clustered_;
    private PolynomialSplineFunction function_;
    private String dataType_ = "Combined";
    private String lipidClass_ = "Combined";

    protected RecalibrationRegression(ArrayList<Pair<Double, Double>> differences, double grouping, String dataType, String lipidClass) {
        this(differences, grouping);
        this.dataType_ = dataType;
        this.lipidClass_ = lipidClass;
    }

    private RecalibrationRegression(ArrayList<Pair<Double, Double>> differences, double grouping) {
        this.differences_ = differences;
        this.grouping_ = grouping;
        this.initRegression();
    }

    protected void initRegression() {
        this.initRegression(this.clusterKeys(this.differences_));
    }

    protected void initRegression(ArrayList<Pair<Double, Double>> clustered) {
        this.clustered_ = clustered;
        SplineInterpolator interpolator = new SplineInterpolator();
        double[] xValues = new double[this.clustered_.size()];
        double[] yValues = new double[this.clustered_.size()];
        for (int i = 0; i < this.clustered_.size(); ++i) {
            xValues[i] = this.clustered_.get(i).getKey();
            yValues[i] = this.clustered_.get(i).getValue();
        }
        this.function_ = this.clustered_.size() > 2 ? interpolator.interpolate(xValues, yValues) : null;
    }

    private ArrayList<Pair<Double, Double>> clusterKeys(ArrayList<Pair<Double, Double>> differences) {
        ArrayList<Pair<Double, Double>> clustered = new ArrayList<Pair<Double, Double>>();
        ArrayList<Double> intervals = new ArrayList<Double>();
        int i = 0;
        while ((double)i <= (this.getMax(differences) - this.getMin(differences)) / this.grouping_ + 1.0) {
            intervals.add(this.getMin(differences) + (double)i * this.grouping_);
            if (i > 0) {
                int count = 0;
                double xSum = 0.0;
                double ySum = 0.0;
                for (Pair<Double, Double> dataPoint : differences) {
                    if (!(dataPoint.getKey() >= (Double)intervals.get(i - 1)) || !(dataPoint.getKey() <= (Double)intervals.get(i))) continue;
                    xSum += dataPoint.getKey().doubleValue();
                    ySum += dataPoint.getValue().doubleValue();
                    ++count;
                }
                if (count > 0) {
                    clustered.add(new Pair<Double, Double>(xSum / (double)count, ySum / (double)count));
                }
            }
            ++i;
        }
        return clustered;
    }

    private double getMin(ArrayList<Pair<Double, Double>> data) {
        double min = 2.147483647E9;
        for (int i = 0; i < data.size(); ++i) {
            if (!(data.get(i).getKey() < min)) continue;
            min = data.get(i).getKey();
        }
        return min;
    }

    private double getMax(ArrayList<Pair<Double, Double>> data) {
        double max = -2.147483648E9;
        for (int i = 0; i < data.size(); ++i) {
            if (!(data.get(i).getKey() > max)) continue;
            max = data.get(i).getKey();
        }
        return max;
    }

    protected void removeDataPoint(Pair<Double, Double> dataPoint) {
        this.differences_.remove(dataPoint);
        this.initRegression();
    }

    public double getTargetRT(double referenceRT) throws OutOfRangeException {
        return referenceRT - this.function_.value(referenceRT);
    }

    protected ArrayList<Pair<Double, Double>> getDifferences() {
        return this.differences_;
    }

    protected int getClusteredWithoutDataPointSize(Pair<Double, Double> dataPoint) {
        ArrayList<Pair<Double, Double>> differences = new ArrayList<Pair<Double, Double>>(this.differences_);
        differences.remove(dataPoint);
        ArrayList<Pair<Double, Double>> clustered = this.clusterKeys(differences);
        return clustered.size();
    }

    protected ArrayList<Pair<Double, Double>> getClustered() {
        return this.clustered_;
    }

    protected PolynomialSplineFunction getFunction() {
        return this.function_;
    }

    protected double getLowerRTLimit() {
        return this.getMin(this.clustered_);
    }

    protected double getUpperRTLimit() {
        return this.getMax(this.clustered_);
    }

    public String getDataType() {
        return this.dataType_;
    }

    public void setDataType(String dataType) {
        this.dataType_ = dataType;
    }

    public String getLipidClass() {
        return this.lipidClass_;
    }

    public void setLipidClass(String lipidClass) {
        this.lipidClass_ = lipidClass;
    }

    public void setGrouping(double grouping) {
        this.grouping_ = grouping;
        this.initRegression();
    }
}

