/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.target.experiment;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.ExcelInputFileException;
import at.tugraz.genome.lda.parser.LDAResultReader;
import at.tugraz.genome.lda.quantification.QuantificationResult;
import at.tugraz.genome.lda.target.JDefaultComponents;
import at.tugraz.genome.lda.target.JOptionPanel;
import at.tugraz.genome.lda.target.LoadingPanel;
import at.tugraz.genome.lda.target.experiment.ExperimentFileChooserPanel;
import at.tugraz.genome.lda.verifier.IntegerMaxVerifier;
import at.tugraz.genome.lda.vos.ResultFileVO;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public abstract class ExperimentTableInputPanel
extends JOptionPanel {
    private static final long serialVersionUID = 1L;
    private static final int MINIMUM_ALLOWED_VALUE = 0;
    private static final int MAXIMUM_ALLOWED_VALUE = 49;
    private static final Dimension TABLE_PANEL_DIMENSION = new Dimension(825, 300);
    private ExperimentFileChooserPanel fileChooserPanel_;
    private String frameTitle_;
    private LoadingPanel loadingPanel_;
    private JPanel displayPanel_;
    private Vector<ResultFileVO> resultFileVO_;

    public ExperimentTableInputPanel(JDefaultComponents wizardComponents, ExperimentFileChooserPanel fileChooserPanel, String title, String frameTitle) {
        super(wizardComponents, title);
        this.fileChooserPanel_ = fileChooserPanel;
        this.frameTitle_ = frameTitle;
        this.initLoadingPanel();
        this.displayPanel_ = null;
        this.resultFileVO_ = null;
        this.init(this.loadingPanel_);
    }

    private void initLoadingPanel() {
        this.loadingPanel_ = new LoadingPanel("<html>Loading data, please wait...</html>");
    }

    protected void init(JPanel panel) {
        this.add((Component)panel, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.invalidate();
        this.updateUI();
    }

    public abstract void initDataDisplay();

    protected abstract Object[][] generateTableData();

    protected void cleanPanels() {
        if (this.loadingPanel_ != null) {
            this.remove(this.loadingPanel_);
            this.loadingPanel_ = null;
        }
        if (this.displayPanel_ != null) {
            this.remove(this.displayPanel_);
            this.displayPanel_ = null;
        }
    }

    protected void reset() {
        this.resultFileVO_ = null;
        this.cleanPanels();
        this.initLoadingPanel();
        this.init(this.loadingPanel_);
    }

    protected JPanel generateDisplayPanel(String[] columnNames, Object[][] tableData, final int editableColumn) {
        this.displayPanel_ = new JPanel();
        this.displayPanel_.setLayout(new GridBagLayout());
        final JTable standardsTable = new JTable(tableData, columnNames){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == editableColumn;
            }
        };
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        standardsTable.getColumnModel().getColumn(editableColumn).setCellRenderer(centerRenderer);
        SpinnerEditor editor = new SpinnerEditor();
        editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                SpinnerEditor source = (SpinnerEditor)e.getSource();
                int value = source.parseTextFieldContent();
                source.setTextFieldContent();
                standardsTable.setValueAt(value, source.getRow(), editableColumn);
                ExperimentTableInputPanel.this.updateValue(source.getRow(), value);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                System.out.println("Editing canceled!");
            }
        });
        standardsTable.getColumnModel().getColumn(editableColumn).setCellEditor(editor);
        standardsTable.setRowHeight(30);
        JScrollPane scrollPane = new JScrollPane(standardsTable);
        scrollPane.setPreferredSize(TABLE_PANEL_DIMENSION);
        this.displayPanel_.add((Component)scrollPane, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.displayPanel_.setBorder(this.getTitledPanelBorder(this.frameTitle_));
        return this.displayPanel_;
    }

    protected void loadData() {
        Vector<File> files = this.fileChooserPanel_.getFiles();
        this.resultFileVO_ = new Vector();
        try {
            for (File file : files) {
                QuantificationResult quantRes = LDAResultReader.readResultFile(file.getAbsolutePath(), new Hashtable<String, Boolean>());
                this.resultFileVO_.add(new ResultFileVO(file.getAbsolutePath(), file, quantRes));
            }
        }
        catch (ExcelInputFileException ex) {
            new WarningMessage(new JFrame(), "Warning", "An error occured while parsing the provided Excel files: " + ex.getMessage());
            this.goBack();
        }
        System.out.println("Data loaded!");
    }

    protected ExperimentFileChooserPanel getFileChooserPanel() {
        return this.fileChooserPanel_;
    }

    protected Vector<ResultFileVO> getResultFiles() {
        return this.resultFileVO_;
    }

    protected abstract void updateValue(int var1, int var2);

    private class SpinnerEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        final JSpinner spinner_ = new JSpinner();
        int row_ = -1;

        protected SpinnerEditor() {
            this.spinner_.setModel(new SpinnerNumberModel(0, 0, 49, 1));
            JFormattedTextField textField = (JFormattedTextField)this.spinner_.getEditor().getComponent(0);
            textField.setInputVerifier(new IntegerMaxVerifier(0, 49));
            this.spinner_.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ExperimentTableInputPanel.this.updateValue(SpinnerEditor.this.row_, (Integer)SpinnerEditor.this.spinner_.getValue());
                    ExperimentTableInputPanel.this.update();
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.spinner_.getValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row_ = row;
            this.spinner_.setValue(value);
            return this.spinner_;
        }

        protected int getRow() {
            return this.row_;
        }

        protected int parseTextFieldContent() {
            JFormattedTextField textField = (JFormattedTextField)this.spinner_.getEditor().getComponent(0);
            if (this.isTextFieldContentViable(textField)) {
                return Integer.parseInt(textField.getText());
            }
            return 0;
        }

        protected void setTextFieldContent() {
            JFormattedTextField textField = (JFormattedTextField)this.spinner_.getEditor().getComponent(0);
            int textFieldContent = this.parseTextFieldContent();
            textField.setText(Integer.toString(textFieldContent));
            this.spinner_.setValue(textFieldContent);
        }

        protected boolean isTextFieldContentViable(JFormattedTextField textField) {
            try {
                int number = Integer.parseInt(textField.getText());
                if (number > 49 || number < 0) {
                    return false;
                }
            }
            catch (NumberFormatException ex) {
                return false;
            }
            return true;
        }
    }
}

