/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.target.experiment;

import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.target.AbstractRegression;
import at.tugraz.genome.lda.target.IsotopeLabelVO;
import at.tugraz.genome.lda.target.experiment.MatchedPartnerVO;
import at.tugraz.genome.lda.utils.StaticUtils;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;

public class IsotopeEffectRegression
extends AbstractRegression {
    private Vector<MatchedPartnerVO> matchedIsotopologues_;
    private final int MAX_DEUTERIUM_ALLOWED;

    protected IsotopeEffectRegression(Vector<MatchedPartnerVO> matchedIsotopologues, Vector<IsotopeLabelVO> labels) {
        this.matchedIsotopologues_ = matchedIsotopologues;
        this.MAX_DEUTERIUM_ALLOWED = this.findMaximumDeuteriumAllowed(labels);
        super.setCoefficients(this.initRegression());
    }

    private int findMaximumDeuteriumAllowed(Vector<IsotopeLabelVO> labels) {
        int maxD = 0;
        for (IsotopeLabelVO label : labels) {
            if (!label.getLabelElements().containsKey("D") || label.getLabelElements().get("D") <= maxD) continue;
            maxD = label.getLabelElements().get("D");
        }
        return maxD;
    }

    @Override
    protected double[] initRegression() {
        double[] coefficients = new double[3];
        PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)2);
        WeightedObservedPoints observations = new WeightedObservedPoints();
        observations.add(10000.0, 0.0, 1.0);
        for (MatchedPartnerVO matched : this.matchedIsotopologues_) {
            if (!matched.isUseForCalibration()) continue;
            LipidomicsMSnSet standard = matched.getStandard();
            double standardRT = standard.getPreciseRT();
            System.out.println("standard: " + standard.getOmegaInformation().get(0).getDoubleBondPositionsHumanReadable() + " RT: " + standard.getPreciseRT());
            LipidomicsMSnSet isotopologue = matched.getIsotopologue();
            double isotopologueRT = isotopologue.getPreciseRT();
            Set<String> names = isotopologue.getHumanReadableNameSet();
            for (String name : names) {
                System.out.println("partner: " + name + " RT: " + isotopologueRT);
            }
            try {
                Hashtable<String, Integer> chemicalFormula = StaticUtils.categorizeFormula(isotopologue.getChemicalFormula());
                int numberDeuterium = chemicalFormula.get("D");
                double totalIsotopeEffect = standardRT / isotopologueRT;
                observations.add((double)numberDeuterium, totalIsotopeEffect);
            }
            catch (ChemicalFormulaException ex) {
                ex.printStackTrace();
            }
            coefficients = fitter.fit((Collection)observations.toList());
            for (int i = 0; i < coefficients.length - 1; ++i) {
                System.out.println(coefficients[i]);
            }
        }
        return coefficients;
    }

    public double getIsotopeEffect(double numberDeuterium) {
        return super.getAdjustFactor(numberDeuterium);
    }

    public double getIsotopeEffect(int numberDeuterium) {
        return super.getAdjustFactor(numberDeuterium);
    }

    public double getRTofUnlabeledSpecies(int numberDeuterium, double retentionTime) {
        double isotopeEffect = super.getAdjustFactor(numberDeuterium);
        return isotopeEffect * retentionTime;
    }

    public int getMaxNumDeuteriumAllowed() {
        return this.MAX_DEUTERIUM_ALLOWED;
    }
}

