/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.target.export;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.target.JDefaultComponents;
import at.tugraz.genome.lda.target.JOptionPanel;
import at.tugraz.genome.lda.target.JTargetFileWizard;
import at.tugraz.genome.lda.target.export.TargetListExporter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ExportPanel
extends JOptionPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTargetFileWizard jTargetFileWizard_;
    private TargetListExporter exporter_;
    private JTextField exportField_;
    private Path previousSelection_ = null;
    private static final String PLACEHOLDER_PREFIX = "Enter ";
    private static final String BROWSE = "Browse";
    private static final String COMMAND_OPEN_EXPORT = "Open export";
    private static final Dimension ENTER_FIELD_DIMENSION_MIN = new Dimension(300, 15);
    private static final Dimension ENTER_FIELD_DIMENSION = new Dimension(775, 30);
    private static final Dimension DEFAULT_FILE_CHOOSER_DIMENSION = new Dimension(750, 750);

    public ExportPanel(JDefaultComponents wizardComponents, JTargetFileWizard jTargetFileWizard) {
        super(wizardComponents, "Export your new C=C target list.");
        this.jTargetFileWizard_ = jTargetFileWizard;
        this.init();
    }

    private void init() {
        this.exportField_ = this.instantiateJTextField("Enter path and file name for the new C=C target file.");
        JButton exportButton = this.instantiateJButton(COMMAND_OPEN_EXPORT, BROWSE);
        JPanel exportPanel = this.instantiatePanel(this.exportField_, exportButton, "New C=C target file");
        this.add((Component)exportPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(100, 0, 0, 0), 0, 0));
    }

    private JTextField instantiateJTextField(final String placeholder) {
        final JTextField field = new JTextField();
        field.setMinimumSize(ENTER_FIELD_DIMENSION_MIN);
        field.setPreferredSize(ENTER_FIELD_DIMENSION);
        field.setText(placeholder);
        field.setForeground(Color.GRAY);
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (field.getText().equals(placeholder)) {
                    field.setText("");
                    field.setForeground(Color.BLACK);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (field.getText().isEmpty()) {
                    field.setForeground(Color.GRAY);
                    field.setText(placeholder);
                }
            }
        });
        return field;
    }

    private JButton instantiateJButton(String command, String title) {
        JButton button = new JButton(title);
        button.addActionListener(this);
        button.setActionCommand(command);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        switch (arg0.getActionCommand()) {
            case "Open export": {
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Only .xlsx", "xlsx");
                this.selectPath(0, this.exportField_, filter, "Select the path and file name for the new C=C target file (.xlsx file)");
                break;
            }
        }
    }

    private void selectPath(int selectionMode, JTextField field, FileNameExtensionFilter filter, String title) {
        int val;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(filter);
        chooser.setPreferredSize(DEFAULT_FILE_CHOOSER_DIMENSION);
        chooser.setFileSelectionMode(selectionMode);
        chooser.setDialogTitle(title);
        if (this.previousSelection_ != null) {
            chooser.setCurrentDirectory(this.previousSelection_.getParent().toFile());
        }
        if ((val = chooser.showOpenDialog(new JFrame())) != 0) {
            return;
        }
        String text = chooser.getSelectedFile().getAbsolutePath();
        this.previousSelection_ = Paths.get(text, new String[0]);
        field.setText(text);
        field.setForeground(Color.BLACK);
    }

    private JPanel instantiatePanel(JTextField textfield, JButton button, String borderTitle) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)textfield, this.getDefaultGridBagConstraints(0, 0));
        panel.add((Component)button, this.getDefaultGridBagConstraints(7, 0));
        panel.setBorder(this.getTitledPanelBorder(borderTitle));
        return panel;
    }

    private GridBagConstraints getDefaultGridBagConstraints(int column, int row) {
        return new GridBagConstraints(column, row, 6, 1, 0.0, 0.0, 13, 0, new Insets(10, 6, 0, 0), 0, 10);
    }

    public boolean isPlaceholderExport() {
        return this.exportField_.getText().startsWith(PLACEHOLDER_PREFIX);
    }

    public void setExporter(TargetListExporter exporter) {
        this.exporter_ = exporter;
    }

    public void export() {
        String templatePath = "D:\\Collaborator_Files\\SILDA\\SILDA_final\\masslists_all_labels\\negative.xlsx";
        try {
            if (this.exporter_.getTemplatePath() != null) {
                templatePath = this.exporter_.getTemplatePath();
            }
            this.exporter_.export(templatePath, this.exportField_.getText());
            this.exporter_.exportBeforeAfter("D:\\Collaborator_Files\\SILDA\\SILDA_final\\SILDA_II_b\\Recalibration\\Results\\ComparisonTest\\SILDA_II_b.xlsx", "D:\\Collaborator_Files\\SILDA\\SILDA_final\\SILDA_II_b\\Recalibration\\Results\\ComparisonTest\\comparison_1.xlsx");
        }
        catch (Exception ex) {
            new WarningMessage(new JFrame(), "Error", "An error occurred during the export: " + ex.getMessage());
        }
    }
}

