/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.target.export;

import at.tugraz.genome.lda.QuantificationThread;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.ExportException;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.QuantificationResult;
import at.tugraz.genome.lda.target.IsotopeLabelVO;
import at.tugraz.genome.lda.target.calibration.CalibrationGraphPanel;
import at.tugraz.genome.lda.target.calibration.RecalibrationRegression;
import at.tugraz.genome.lda.target.experiment.IsotopeEffectRegression;
import at.tugraz.genome.lda.utils.RangeDouble;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.DoubleBondPositionVO;
import at.tugraz.genome.lda.vos.QuantVO;
import at.tugraz.genome.lda.vos.ResultFileVO;
import at.tugraz.genome.maspectras.parser.spectrummill.ElementConfigParser;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javafx.util.Pair;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TargetListExporter {
    private static final String HEADER_NAME = "Name";
    private static final String HEADER_COLON = "";
    private static final String HEADER_DBS = "dbs";
    public static final String HEADER_MOLECULAR_SPECIES_WITH_DOUBLE_BOND_POSITIONS = "mol. species";
    private static final String HEADER_RETENTION_TIME = "tR (min)";
    private static final int HEADER_ROW = 1;
    private static final double THRESHOLD_FOR_CLUSTERING = 5.0;
    private IsotopeEffectRegression isotopeEffectRegression_;
    private Vector<ResultFileVO> resultFileVO_;
    private Vector<IsotopeLabelVO> labels_;
    private String templatePath_;
    private boolean calibrateSeparately_ = false;
    private CalibrationGraphPanel calibrationGraphPanel_ = null;
    Hashtable<String, Set<Pair<Double, DoubleBondPositionVO>>> beforeAfter_ = new Hashtable();

    public TargetListExporter(String templatePath, boolean calibrateSeparately, CalibrationGraphPanel calibrationGraphPanel) {
        this.calibrateSeparately_ = calibrateSeparately;
        this.templatePath_ = templatePath;
        this.calibrationGraphPanel_ = calibrationGraphPanel;
        this.beforeAfter_ = new Hashtable();
    }

    public TargetListExporter(IsotopeEffectRegression isotopeEffectRegression, Vector<ResultFileVO> resultFileVO, Vector<IsotopeLabelVO> labels) {
        this.isotopeEffectRegression_ = isotopeEffectRegression;
        this.resultFileVO_ = resultFileVO;
        this.labels_ = labels;
    }

    protected void export(String templatePath, String outPath) throws ExportException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outPath));
             XSSFWorkbook workbook = new XSSFWorkbook();){
            Vector quantInfo = QuantificationThread.getCorrectAnalyteSequence(templatePath, false);
            LinkedHashMap classSequence = (LinkedHashMap)quantInfo.get(0);
            LinkedHashMap analyteSequence = (LinkedHashMap)quantInfo.get(1);
            Hashtable quantObjects = (Hashtable)quantInfo.get(4);
            new ElementConfigParser("elementconfig.xml").parse();
            XSSFCellStyle headerStyle = TargetListExporter.getHeaderStyle(workbook);
            for (String cName : classSequence.keySet()) {
                System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" + cName + "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                Vector<DoubleBondPositionVO> allLabeledVOsToAdd = new Vector<DoubleBondPositionVO>();
                if (!this.isRecalibration()) {
                    MolecularSpeciesContainer container = new MolecularSpeciesContainer();
                    this.fillContainerForClass(cName, container);
                    Set labeledMolecularSpecies = container.getLabeledMolecularSpecies();
                    for (String molecularSpecies : labeledMolecularSpecies) {
                        Vector labeledVOs = container.getLabeledSpecies(molecularSpecies);
                        Vector<DoubleBondPositionVO> clusteredLabeledVOs = this.clusterMolecularSpecies(labeledVOs, true);
                        allLabeledVOsToAdd.addAll(clusteredLabeledVOs);
                    }
                }
                XSSFSheet sheet = workbook.createSheet(cName);
                this.writeMassListForSheet(sheet, headerStyle, (Vector)analyteSequence.get(cName), (Hashtable)quantObjects.get(cName), cName, allLabeledVOsToAdd);
            }
            workbook.write(out);
            System.out.println("workbook written!");
        }
        catch (Exception e) {
            throw new ExportException(e);
        }
    }

    private void writeMassListForSheet(Sheet sheet, XSSFCellStyle headerStyle, Vector<String> analytes, Hashtable<String, Hashtable<String, QuantVO>> quantObjects, String cName, Vector<DoubleBondPositionVO> allLabeledVOsToAdd) {
        try {
            Vector<Object> elModCharge = this.getAvailableElementsAndModificationsPlusCharge(quantObjects);
            Vector elements = (Vector)elModCharge.get(0);
            LinkedHashMap mods = (LinkedHashMap)elModCharge.get(1);
            Hashtable modToCharge = (Hashtable)elModCharge.get(2);
            List<String> headerTitles = TargetListExporter.createHeaderTitles(elements, mods, modToCharge);
            if (cName.equals("SM") || cName.equals("Cer")) {
                int rowCount = 0;
                Row outRow = sheet.createRow(rowCount);
                Cell cell = outRow.createCell(9, 1);
                cell.setCellValue("OH-Number: 2");
                cell = outRow.createCell(10, 1);
                cell.setCellValue("OH-Range: 2-3");
                cell = outRow.createCell(11, 1);
                cell.setCellValue("adductInsensitiveRtFilter");
            }
            TargetListExporter.createHeader(sheet, headerTitles, headerStyle);
            int firstModColumn = headerTitles.indexOf(headerTitles.stream().filter(s -> s.startsWith("mass(form[")).findFirst().get());
            int rowCount = 2;
            for (String analyte : analytes) {
                Hashtable<String, QuantVO> quantAnalytes = quantObjects.get(analyte);
                Hashtable<Object, Object> formula = new Hashtable();
                Vector<Object> doubleBondPositionVOs = new Vector();
                for (String mod : mods.keySet()) {
                    QuantVO quant = quantAnalytes.get(mod);
                    if (!this.isRecalibration() && quant.getDbs() > 0) {
                        for (DoubleBondPositionVO doubleBondPositionVO : allLabeledVOsToAdd) {
                            if (quant.getCarbons() != doubleBondPositionVO.getNumberOfCarbons() || quant.getDbs() != doubleBondPositionVO.getNumberOfDoubleBonds() || quant.getOhNumber() != doubleBondPositionVO.getNumberOfOH()) continue;
                            quant.addInfoForOmegaAssignment(doubleBondPositionVO);
                        }
                    }
                    doubleBondPositionVOs = quant.getInfoForOmegaAssignment();
                }
                if (this.isRecalibration()) {
                    RecalibrationRegression regressionByClass;
                    RecalibrationRegression regression = this.calibrationGraphPanel_.getRegressionByFields("Combined", "Combined");
                    if (this.calibrateSeparately_ && (regressionByClass = this.calibrationGraphPanel_.getRegressionByFields("Combined", cName)) != null) {
                        regression = regressionByClass;
                    }
                    boolean noRegressionAvailable = regression == null;
                    for (int i = 0; i < doubleBondPositionVOs.size(); ++i) {
                        DoubleBondPositionVO vo = (DoubleBondPositionVO)doubleBondPositionVOs.get(i);
                        if (noRegressionAvailable) {
                            vo.setExpectedRetentionTime(-1.0f);
                            continue;
                        }
                        try {
                            this.computeExpectedRetentionTime(vo, regression, cName);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                if (!doubleBondPositionVOs.isEmpty()) {
                    Collections.sort(doubleBondPositionVOs);
                }
                for (int i = -1; i < doubleBondPositionVOs.size(); ++i) {
                    int modCount = 0;
                    Row row = sheet.createRow(rowCount);
                    for (String mod : mods.keySet()) {
                        Cell cell;
                        QuantVO quant = quantAnalytes.get(mod);
                        if (modCount == 0) {
                            cell = row.createCell(headerTitles.indexOf(HEADER_NAME), 1);
                            cell.setCellValue(quant.getAnalyteName());
                            cell = row.createCell(headerTitles.indexOf(HEADER_COLON), 1);
                            cell.setCellValue(":");
                            cell = row.createCell(headerTitles.indexOf(HEADER_DBS), 0);
                            cell.setCellValue(quant.getDbs());
                            if (i >= 0) {
                                cell = row.createCell(headerTitles.indexOf(HEADER_MOLECULAR_SPECIES_WITH_DOUBLE_BOND_POSITIONS), 0);
                                cell.setCellValue(((DoubleBondPositionVO)doubleBondPositionVOs.get(i)).getDoubleBondPositionsHumanReadable(1));
                            }
                            formula = StaticUtils.categorizeFormula(quant.getAnalyteFormula());
                            for (String string : formula.keySet()) {
                                cell = row.createCell(headerTitles.indexOf(string), 0);
                                cell.setCellValue(((Integer)formula.get(string)).intValue());
                            }
                        }
                        cell = row.createCell(firstModColumn + modCount, 0);
                        cell.setCellValue(quant.getAnalyteMass());
                        ++modCount;
                        if (i < 0) continue;
                        cell = row.createCell(headerTitles.indexOf(HEADER_RETENTION_TIME), 0);
                        cell.setCellValue(((DoubleBondPositionVO)doubleBondPositionVOs.get(i)).getExpectedRetentionTime());
                    }
                    ++rowCount;
                }
            }
        }
        catch (ChemicalFormulaException ex) {
            ex.printStackTrace();
        }
    }

    private void computeExpectedRetentionTime(DoubleBondPositionVO vo, RecalibrationRegression regression, String cName) {
        double before = vo.getExpectedRetentionTime();
        try {
            double after = regression.getTargetRT(before);
            vo.setExpectedRetentionTime((float)after);
            System.out.println(String.format("original: %s, recalibrated: %s", before, after));
        }
        catch (OutOfRangeException ex) {
            vo.setExpectedRetentionTime(-1.0f);
        }
        if (!this.beforeAfter_.containsKey(cName)) {
            this.beforeAfter_.put(cName, ConcurrentHashMap.newKeySet());
        }
        this.beforeAfter_.get(cName).add((Pair<Double, DoubleBondPositionVO>)new Pair((Object)before, (Object)vo));
    }

    private Vector<DoubleBondPositionVO> clusterMolecularSpecies(Vector<DoubleBondPositionVO> doubleBondPositionVOs, boolean labeled) {
        if (labeled && !doubleBondPositionVOs.isEmpty()) {
            Vector<DoubleBondPositionVO> returnElements = new Vector<DoubleBondPositionVO>();
            Vector<Boolean> permutationPattern = doubleBondPositionVOs.get(0).getPermutationPattern();
            Hashtable<Vector<Integer>, Vector<DoubleBondPositionVO>> patternLookup = this.computePatternLookup(doubleBondPositionVOs);
            for (Vector<Integer> pattern : patternLookup.keySet()) {
                Vector<DoubleBondPositionVO> averageElements = this.computeClusters(patternLookup.get(pattern));
                patternLookup.put(pattern, averageElements);
            }
            Hashtable<Vector<Integer>, Vector<Vector<Integer>>> overlappingPatterns = this.computeOverlappingPatterns(patternLookup.keySet(), permutationPattern);
            Hashtable<DoubleBondPositionVO, Vector<DoubleBondPositionVO>> markedToCombine = this.markToCombine(patternLookup, overlappingPatterns);
            Vector<Pair> combineRanges = new Vector<Pair>();
            for (DoubleBondPositionVO doubleBondPositionVO : markedToCombine.keySet()) {
                boolean isRepresented = false;
                for (Pair range1 : combineRanges) {
                    if (!((RangeDouble)range1.getKey()).insideRange(doubleBondPositionVO.getExpectedRetentionTime())) continue;
                    RangeDouble range2 = new RangeDouble((double)doubleBondPositionVO.getExpectedRetentionTime() - 0.08333333333333333, (double)doubleBondPositionVO.getExpectedRetentionTime() + 0.08333333333333333);
                    ((RangeDouble)range1.getKey()).extendToOtherRanges(range2);
                    ((Vector)range1.getValue()).add(doubleBondPositionVO);
                    isRepresented = true;
                }
                if (isRepresented) continue;
                RangeDouble range2 = new RangeDouble((double)doubleBondPositionVO.getExpectedRetentionTime() - 0.08333333333333333, (double)doubleBondPositionVO.getExpectedRetentionTime() + 0.08333333333333333);
                Vector<DoubleBondPositionVO> newVector = new Vector<DoubleBondPositionVO>();
                newVector.add(doubleBondPositionVO);
                Pair newRange = new Pair((Object)range2, newVector);
                combineRanges.add(newRange);
            }
            for (Pair pair : combineRanges) {
                boolean combineSpecies = true;
                Vector<Vector<Integer>> added = new Vector<Vector<Integer>>();
                Vector<DoubleBondPositionVO> toBeRemovedFromLookup = new Vector<DoubleBondPositionVO>();
                Vector<DoubleBondPositionVO> toBeAddedToLookup = new Vector<DoubleBondPositionVO>();
                for (DoubleBondPositionVO doubleBondPositionVO : (Vector)pair.getValue()) {
                    Vector<DoubleBondPositionVO> vos = new Vector<DoubleBondPositionVO>();
                    vos.addAll((Collection)markedToCombine.get(doubleBondPositionVO));
                    Set<Vector<Integer>> combinedPatterns = this.computeCombinedPatterns(doubleBondPositionVO, vos);
                    if (combinedPatterns.size() != 1) {
                        combineSpecies = false;
                        continue;
                    }
                    Vector<Integer> pattern = combinedPatterns.iterator().next();
                    Vector<FattyAcidVO> original = doubleBondPositionVO.getChainCombination();
                    Vector<FattyAcidVO> combinedFattyAcidVO = new Vector<FattyAcidVO>();
                    for (int i = 0; i < pattern.size(); ++i) {
                        FattyAcidVO fattyAcid = new FattyAcidVO(original.get(i));
                        fattyAcid.setOmegaPosition(pattern.get(i));
                        combinedFattyAcidVO.add(fattyAcid);
                    }
                    float expectedRetentionTime = doubleBondPositionVO.getExpectedRetentionTime();
                    int count = 1;
                    for (DoubleBondPositionVO vo : vos) {
                        toBeRemovedFromLookup.add(vo);
                        expectedRetentionTime += vo.getExpectedRetentionTime();
                        ++count;
                    }
                    DoubleBondPositionVO combined = new DoubleBondPositionVO(combinedFattyAcidVO, expectedRetentionTime / (float)count, 0, doubleBondPositionVO.getMolecularSpecies());
                    toBeAddedToLookup.add(combined);
                    toBeRemovedFromLookup.add(doubleBondPositionVO);
                }
                if (!combineSpecies) continue;
                for (DoubleBondPositionVO toBeAdded : toBeAddedToLookup) {
                    if (added.contains(toBeAdded.getPositionAssignmentPattern())) continue;
                    if (!patternLookup.containsKey(toBeAdded.getPositionAssignmentPattern())) {
                        patternLookup.put(toBeAdded.getPositionAssignmentPattern(), new Vector());
                    }
                    patternLookup.get(toBeAdded.getPositionAssignmentPattern()).add(toBeAdded);
                    added.add(toBeAdded.getPositionAssignmentPattern());
                }
                for (DoubleBondPositionVO toBeRemoved : toBeRemovedFromLookup) {
                    patternLookup.get(toBeRemoved.getPositionAssignmentPattern()).remove(toBeRemoved);
                }
            }
            for (Vector vector : patternLookup.keySet()) {
                returnElements.addAll((Collection<DoubleBondPositionVO>)patternLookup.get(vector));
            }
            return returnElements;
        }
        return this.computeClusters(doubleBondPositionVOs);
    }

    private boolean isCombinationStraightforward(Set<Vector<Integer>> combinedPatterns) {
        return combinedPatterns.size() == 1;
    }

    private Set<Vector<Integer>> computeCombinedPatterns(DoubleBondPositionVO vo1, Vector<DoubleBondPositionVO> doubleBondPositionVOs) {
        HashSet<Vector<Integer>> combinedPatterns = new HashSet<Vector<Integer>>();
        for (DoubleBondPositionVO vo2 : doubleBondPositionVOs) {
            Vector<Integer> combinedPattern = this.computeCombinedPattern(vo1, vo2);
            combinedPatterns.add(combinedPattern);
        }
        return combinedPatterns;
    }

    private Vector<Integer> computeCombinedPattern(DoubleBondPositionVO vo1, DoubleBondPositionVO vo2) {
        Vector<Integer> combinedPattern = new Vector<Integer>();
        Vector<Integer> pattern1 = vo1.getPositionAssignmentPattern();
        Vector<Integer> pattern2 = vo2.getPositionAssignmentPattern();
        if (vo2.getPermutationPattern().contains(Boolean.TRUE) && pattern2.size() == 2) {
            int temp = pattern2.get(0);
            pattern2.setElementAt(pattern2.get(1), 0);
            pattern2.setElementAt(temp, 1);
        }
        for (int i = 0; i < pattern1.size(); ++i) {
            if (pattern1.get(i) == pattern2.get(i)) {
                combinedPattern.add(pattern1.get(i));
                continue;
            }
            if (pattern1.get(i) > 0 && pattern2.get(i) == -1) {
                combinedPattern.add(pattern1.get(i));
                continue;
            }
            if (pattern1.get(i) == -1 && pattern2.get(i) > 0) {
                combinedPattern.add(pattern2.get(i));
                continue;
            }
            combinedPattern.add(-1);
        }
        return combinedPattern;
    }

    private Hashtable<DoubleBondPositionVO, Vector<DoubleBondPositionVO>> markToCombine(Hashtable<Vector<Integer>, Vector<DoubleBondPositionVO>> patternLookup, Hashtable<Vector<Integer>, Vector<Vector<Integer>>> overlappingPatterns) {
        Hashtable<DoubleBondPositionVO, Vector<DoubleBondPositionVO>> markedToCombine = new Hashtable<DoubleBondPositionVO, Vector<DoubleBondPositionVO>>();
        for (Vector<Integer> pattern : overlappingPatterns.keySet()) {
            Vector<DoubleBondPositionVO> patternVOs = patternLookup.get(pattern);
            for (Vector<Integer> overlappingPattern : overlappingPatterns.get(pattern)) {
                Vector<DoubleBondPositionVO> overlappingPatternVOs = patternLookup.get(overlappingPattern);
                for (DoubleBondPositionVO vo1 : patternVOs) {
                    Float retentionTime1 = Float.valueOf(vo1.getExpectedRetentionTime());
                    for (DoubleBondPositionVO vo2 : overlappingPatternVOs) {
                        Float retentionTime2 = Float.valueOf(vo2.getExpectedRetentionTime());
                        if (!((double)Math.abs(retentionTime1.floatValue() - retentionTime2.floatValue()) < 0.08333333333333333)) continue;
                        if (!markedToCombine.containsKey(vo1)) {
                            markedToCombine.put(vo1, new Vector());
                        }
                        if (!markedToCombine.get(vo1).contains(vo2)) {
                            markedToCombine.get(vo1).add(vo2);
                        }
                        if (!markedToCombine.containsKey(vo2)) {
                            markedToCombine.put(vo2, new Vector());
                        }
                        if (markedToCombine.get(vo2).contains(vo1)) continue;
                        markedToCombine.get(vo2).add(vo1);
                    }
                }
            }
        }
        return this.removeDuplicates(markedToCombine);
    }

    private Hashtable<DoubleBondPositionVO, Vector<DoubleBondPositionVO>> removeDuplicates(Hashtable<DoubleBondPositionVO, Vector<DoubleBondPositionVO>> markedToCombine) {
        Set<DoubleBondPositionVO> keySet = markedToCombine.keySet();
        ArrayList<DoubleBondPositionVO> toRemoveList = new ArrayList<DoubleBondPositionVO>();
        for (DoubleBondPositionVO key : keySet) {
            if (toRemoveList.contains(key)) continue;
            Vector<DoubleBondPositionVO> collection1 = new Vector<DoubleBondPositionVO>();
            collection1.addAll((Collection)markedToCombine.get(key));
            collection1.add(key);
            Vector<DoubleBondPositionVO> keyVector = markedToCombine.get(key);
            for (int i = 0; i < keyVector.size(); ++i) {
                if (keyVector.get(i).equals(key) || toRemoveList.contains(keyVector.get(i)) || !markedToCombine.containsKey(keyVector.get(i))) continue;
                Vector<DoubleBondPositionVO> collection2 = new Vector<DoubleBondPositionVO>();
                collection2.addAll((Collection)markedToCombine.get(keyVector.get(i)));
                collection2.add(keyVector.get(i));
                if (collection2.containsAll(collection1)) {
                    toRemoveList.add(key);
                    continue;
                }
                if (!collection1.containsAll(collection2)) continue;
                toRemoveList.add(keyVector.get(i));
            }
        }
        for (DoubleBondPositionVO toRemove : toRemoveList) {
            markedToCombine.remove(toRemove);
        }
        return markedToCombine;
    }

    private Hashtable<Vector<Integer>, Vector<Vector<Integer>>> computeOverlappingPatterns(Set<Vector<Integer>> patterns, Vector<Boolean> permutationPattern) {
        Hashtable<Vector<Integer>, Vector<Vector<Integer>>> overlappingPatterns = new Hashtable<Vector<Integer>, Vector<Vector<Integer>>>();
        for (Vector<Integer> pattern1 : patterns) {
            overlappingPatterns.put(pattern1, new Vector());
            for (Vector<Integer> pattern2 : patterns) {
                boolean isOverlapping = true;
                boolean isIdentical = pattern1.equals(pattern2);
                if (isIdentical) continue;
                Vector<Vector<Integer>> patternPermutations = this.computePatternPermutations(pattern2, permutationPattern);
                for (Vector<Integer> pattern3 : patternPermutations) {
                    isOverlapping = true;
                    for (int i = 0; i < pattern1.size(); ++i) {
                        if (pattern1.get(i).equals(pattern3.get(i)) || pattern1.get(i) == -1 || pattern3.get(i) == -1) continue;
                        isOverlapping = false;
                    }
                }
                if (!isOverlapping) continue;
                overlappingPatterns.get(pattern1).add(pattern2);
            }
        }
        return overlappingPatterns;
    }

    private Vector<Vector<Integer>> computePatternPermutations(Vector<Integer> pattern, Vector<Boolean> permutationPattern) {
        Vector<Vector<Integer>> patternPermutations = new Vector<Vector<Integer>>();
        int size = pattern.size();
        patternPermutations.add(new Vector<Integer>(pattern));
        if (!permutationPattern.contains(Boolean.TRUE)) {
            return patternPermutations;
        }
        for (int i = 0; i < size; ++i) {
            int temp;
            Vector<Integer> tempPattern;
            if (permutationPattern.get(i) != Boolean.TRUE) continue;
            if (i < size - 1 && permutationPattern.get(i + 1) == Boolean.TRUE) {
                tempPattern = new Vector<Integer>(pattern);
                temp = tempPattern.get(i);
                tempPattern.setElementAt(tempPattern.get(i + 1), i);
                tempPattern.setElementAt(temp, i + 1);
                patternPermutations.add(tempPattern);
                continue;
            }
            if (size <= 2 || i != size - 1 || permutationPattern.firstElement() != Boolean.TRUE) continue;
            tempPattern = new Vector<Integer>(pattern);
            temp = tempPattern.get(i);
            tempPattern.setElementAt(tempPattern.firstElement(), i);
            tempPattern.setElementAt(temp, 0);
            patternPermutations.add(tempPattern);
        }
        return patternPermutations;
    }

    public DoubleBondPositionVO combineDoubleBondPositionVO(DoubleBondPositionVO vo1, DoubleBondPositionVO vo2) {
        if (vo1.getMolecularSpecies().equals(vo2.getMolecularSpecies())) {
            int i;
            float combinedRetentionTime = (vo1.getExpectedRetentionTime() + vo2.getExpectedRetentionTime()) / 2.0f;
            Vector<Integer> pattern1 = vo1.getPositionAssignmentPattern();
            Vector<Integer> pattern2 = vo2.getPositionAssignmentPattern();
            if (vo2.getPermutationPattern().contains(Boolean.TRUE) && pattern2.size() == 2) {
                int temp = pattern2.get(0);
                pattern2.setElementAt(pattern2.get(1), 0);
                pattern2.setElementAt(temp, 1);
            }
            Vector<Integer> combinedPattern = new Vector<Integer>();
            Vector<FattyAcidVO> combinedFattyAcidVO = new Vector<FattyAcidVO>(vo1.getChainCombination());
            for (i = 0; i < pattern1.size(); ++i) {
                if (pattern1.get(i) == pattern2.get(i)) {
                    combinedPattern.add(pattern1.get(i));
                    continue;
                }
                if (pattern1.get(i) > 0 && pattern2.get(i) == -1) {
                    combinedPattern.add(pattern1.get(i));
                    continue;
                }
                if (pattern1.get(i) == -1 && pattern2.get(i) > 0) {
                    combinedPattern.add(pattern2.get(i));
                    continue;
                }
                combinedPattern.add(-1);
            }
            for (i = 0; i < combinedPattern.size(); ++i) {
                combinedFattyAcidVO.get(i).setOmegaPosition((Integer)combinedPattern.get(i));
            }
            return new DoubleBondPositionVO(combinedFattyAcidVO, combinedRetentionTime, 0, vo1.getMolecularSpecies());
        }
        return null;
    }

    private Hashtable<Vector<Integer>, Vector<DoubleBondPositionVO>> computePatternLookup(Vector<DoubleBondPositionVO> doubleBondPositionVOs) {
        Hashtable<Vector<Integer>, Vector<DoubleBondPositionVO>> patternLookup = new Hashtable<Vector<Integer>, Vector<DoubleBondPositionVO>>();
        for (DoubleBondPositionVO doubleBondPositionVO : doubleBondPositionVOs) {
            Vector<Integer> pattern = doubleBondPositionVO.getPositionAssignmentPattern();
            if (!patternLookup.containsKey(pattern)) {
                patternLookup.put(pattern, new Vector());
            }
            patternLookup.get(pattern).add(doubleBondPositionVO);
        }
        return patternLookup;
    }

    private void calculateDistanceMatrix(Vector<DoubleBondPositionVO> doubleBondPositionVOs) {
        Vector distanceMatrix = new Vector();
        for (DoubleBondPositionVO vo1 : doubleBondPositionVOs) {
            Float retentionTime1 = Float.valueOf(vo1.getExpectedRetentionTime());
            Vector<Float> distances = new Vector<Float>();
            for (DoubleBondPositionVO vo2 : doubleBondPositionVOs) {
                distances.add(Float.valueOf(Math.abs(retentionTime1.floatValue() - vo2.getExpectedRetentionTime())));
            }
            distanceMatrix.add(distances);
            System.out.println(distances);
        }
    }

    private Vector<DoubleBondPositionVO> computeClusters(Vector<DoubleBondPositionVO> doubleBondPositionVOs) {
        Vector<DoubleBondPositionVO> averageElements = new Vector<DoubleBondPositionVO>();
        Hashtable<Integer, Integer> clusterLookup = new Hashtable<Integer, Integer>();
        Hashtable<Integer, Cluster> clusters = new Hashtable<Integer, Cluster>();
        int numClusters = 0;
        for (int i = 0; i < doubleBondPositionVOs.size(); ++i) {
            DoubleBondPositionVO vo1 = doubleBondPositionVOs.get(i);
            Float retentionTime1 = Float.valueOf(vo1.getExpectedRetentionTime());
            if (!clusterLookup.containsKey(i)) {
                Cluster cluster = new Cluster();
                cluster.addDoubleBondPositionVO(vo1);
                clusters.put(numClusters, cluster);
                clusterLookup.put(i, numClusters);
                ++numClusters;
            }
            for (int j = 0; j < doubleBondPositionVOs.size(); ++j) {
                int numCluster2;
                DoubleBondPositionVO vo2 = doubleBondPositionVOs.get(j);
                if (!((double)Math.abs(retentionTime1.floatValue() - vo2.getExpectedRetentionTime()) < 0.08333333333333333)) continue;
                if (!clusterLookup.containsKey(j)) {
                    int numCluster = (Integer)clusterLookup.get(i);
                    ((Cluster)clusters.get(numCluster)).addDoubleBondPositionVO(vo2);
                    clusterLookup.put(j, numCluster);
                    continue;
                }
                int numCluster1 = (Integer)clusterLookup.get(i);
                if (numCluster1 == (numCluster2 = ((Integer)clusterLookup.get(j)).intValue())) continue;
                Cluster cluster = new Cluster((Cluster)clusters.get(numCluster1), (Cluster)clusters.get(numCluster2));
                clusters.put(numCluster1, cluster);
                clusterLookup.forEach((k, v) -> {
                    if (v == numCluster2) {
                        clusterLookup.replace((Integer)k, numCluster1);
                    }
                });
                clusters.remove(numCluster2);
            }
        }
        clusters.forEach((k, v) -> averageElements.add(((Cluster)v).getAverageElement()));
        return averageElements;
    }

    private boolean containsMoreThanOneSpecies(Vector<Pair<String, String>> labeledUnlabeledPairs) {
        HashSet<Object> uniqueSpecies = new HashSet<Object>();
        for (Pair<String, String> pair : labeledUnlabeledPairs) {
            uniqueSpecies.add(pair.getKey());
        }
        return uniqueSpecies.size() > 1;
    }

    private void fillContainerForClass(String cName, MolecularSpeciesContainer container) {
        try {
            for (ResultFileVO resultFileVO : this.resultFileVO_) {
                QuantificationResult quantRes = resultFileVO.getQuantificationResult();
                Vector<LipidParameterSet> analytes = quantRes.getIdentifications().get(cName);
                for (LipidParameterSet analyte : analytes) {
                    LipidomicsMSnSet analyteMSn;
                    if (!(analyte instanceof LipidomicsMSnSet) || analyte.getDoubleBonds() <= 0 || (analyteMSn = (LipidomicsMSnSet)analyte).getStatus() < 3) continue;
                    Vector<Pair<String, String>> labeledUnlabeledPairs = analyteMSn.getLabeledUnlabeledPairs();
                    Hashtable<String, Integer> elements = StaticUtils.categorizeFormula(analyte.getChemicalFormula());
                    double expectedRetentionTime = analyte.getPreciseRT();
                    if (this.isotopeEffectRegression_ != null && analyte.getChemicalFormula().contains("D")) {
                        int numberDeuterium = elements.get("D");
                        if (numberDeuterium > this.isotopeEffectRegression_.getMaxNumDeuteriumAllowed()) continue;
                        expectedRetentionTime = this.isotopeEffectRegression_.getRTofUnlabeledSpecies(numberDeuterium, analyte.getPreciseRT());
                    }
                    for (Pair<String, String> pair : labeledUnlabeledPairs) {
                        String labeledSpecies = (String)pair.getValue();
                        Vector<FattyAcidVO> chains = new Vector<FattyAcidVO>();
                        String[] splitName = StaticUtils.splitChainCombinationsAtChainSeparators(labeledSpecies);
                        for (int i = 0; i < splitName.length; ++i) {
                            FattyAcidVO fa = StaticUtils.decodeHumanReadableChain(splitName[i], Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), false, null);
                            String prefix = fa.getPrefix();
                            if (!prefix.equals(HEADER_COLON)) {
                                for (IsotopeLabelVO label : this.labels_) {
                                    if (!label.getLabelId().equals(prefix)) continue;
                                    fa.setOmegaPosition(label.getOmegaPosition());
                                    fa.setPrefix(HEADER_COLON);
                                }
                            }
                            chains.add(fa);
                        }
                        if (analyte.getChemicalFormula().contains("D") || analyte.getChemicalFormula().contains("Cc")) {
                            container.addLabeledSpecies((String)pair.getKey(), new DoubleBondPositionVO(chains, (float)expectedRetentionTime, 0, (String)pair.getKey()));
                            continue;
                        }
                        container.addUnlabeledSpecies((String)pair.getKey(), new DoubleBondPositionVO(chains, (float)expectedRetentionTime, 0, (String)pair.getKey()));
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private LipidParameterSet addDoubleBondPositionVO(LipidomicsMSnSet analyte) {
        return analyte;
    }

    private Hashtable<String, Hashtable<String, QuantVO>> addDoubleBondPositionsToQuantVOs(Hashtable<String, Hashtable<String, QuantVO>> quantObjects, Vector<String> analyteSequence, String cName) {
        for (ResultFileVO resultFileVO : this.resultFileVO_) {
            QuantificationResult quantRes = resultFileVO.getQuantificationResult();
            Vector<LipidParameterSet> vector = quantRes.getIdentifications().get(cName);
        }
        return quantObjects;
    }

    private static void createHeader(Sheet sheet, List<String> headerTitles, XSSFCellStyle headerStyle) {
        Row row = sheet.createRow(1);
        for (int i = 0; i < headerTitles.size(); ++i) {
            Cell cell = row.createCell(i, 1);
            cell.setCellValue(headerTitles.get(i));
            cell.setCellStyle(headerStyle);
        }
    }

    private static List<String> createHeaderTitles(Vector<String> elements, LinkedHashMap<String, String> mods, Hashtable<String, Integer> modToCharge) {
        ArrayList<String> headerTitles = new ArrayList<String>();
        headerTitles.add(HEADER_NAME);
        headerTitles.add(HEADER_COLON);
        headerTitles.add(HEADER_DBS);
        headerTitles.add(HEADER_MOLECULAR_SPECIES_WITH_DOUBLE_BOND_POSITIONS);
        for (String element : elements) {
            headerTitles.add(element);
        }
        for (String mod : mods.keySet()) {
            String modHeader = "mass(form[" + mods.get(mod) + "] name[" + mod + "]";
            if (modToCharge.get(mod) > 1) {
                modHeader = modHeader + " charge=" + modToCharge.get(mod);
            }
            modHeader = modHeader + ")";
            headerTitles.add(modHeader);
        }
        headerTitles.add(HEADER_RETENTION_TIME);
        return headerTitles;
    }

    public static XSSFCellStyle getHeaderStyle(XSSFWorkbook wb) {
        XSSFCellStyle arial12style = wb.createCellStyle();
        XSSFFont arial12font = wb.createFont();
        arial12font.setBoldweight((short)700);
        arial12font.setFontName("Arial");
        arial12font.setFontHeightInPoints((short)12);
        arial12style.setFont(arial12font);
        arial12style.setAlignment((short)2);
        return arial12style;
    }

    protected Vector<Object> getAvailableElementsAndModificationsPlusCharge(Hashtable<String, Hashtable<String, QuantVO>> quantObjects) throws ChemicalFormulaException {
        Vector<Object> result = new Vector<Object>();
        HashSet<String> elements = new HashSet<String>();
        LinkedHashMap<String, String> modifications = new LinkedHashMap<String, String>();
        Hashtable<String, Integer> modToCharge = new Hashtable<String, Integer>();
        for (Hashtable<String, QuantVO> quantAnal : quantObjects.values()) {
            for (QuantVO quant : quantAnal.values()) {
                for (String element : StaticUtils.categorizeFormula(quant.getAnalyteFormula()).keySet()) {
                    if (!elements.contains(element)) {
                        elements.add(element);
                    }
                    if (modifications.containsKey(quant.getModName())) continue;
                    modifications.put(quant.getModName(), StaticUtils.getFormulaInHillNotation(StaticUtils.categorizeFormula(quant.getModFormula()), false));
                    modToCharge.put(quant.getModName(), quant.getCharge());
                }
            }
        }
        Vector<String> sorted = new Vector<String>();
        if (elements.contains("C")) {
            sorted.add("C");
        }
        if (elements.contains("H")) {
            sorted.add("H");
        }
        ArrayList<String> otherThanCH = new ArrayList<String>();
        for (String element : elements) {
            if (element.equalsIgnoreCase("C") || element.equalsIgnoreCase("H")) continue;
            otherThanCH.add(element);
        }
        Collections.sort(otherThanCH);
        for (String element : otherThanCH) {
            sorted.add(element);
        }
        result.add(sorted);
        result.add(modifications);
        result.add(modToCharge);
        return result;
    }

    public String getTemplatePath() {
        return this.templatePath_;
    }

    private boolean isRecalibration() {
        return this.calibrationGraphPanel_ != null;
    }

    private Hashtable<String, Set<Pair<Double, DoubleBondPositionVO>>> getBeforeAfter() {
        return this.beforeAfter_;
    }

    public void exportBeforeAfter(String targetPath, String outPath) throws ExportException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outPath));
             XSSFWorkbook workbook = new XSSFWorkbook();){
            XSSFSheet sheet = workbook.createSheet("beforeAfter");
            this.createBeforeAfterTitle(sheet);
            int rowCount = 1;
            Vector quantInfo = QuantificationThread.getCorrectAnalyteSequence(targetPath, false);
            LinkedHashMap classSequence = (LinkedHashMap)quantInfo.get(0);
            LinkedHashMap analyteSequence = (LinkedHashMap)quantInfo.get(1);
            Hashtable quantObjects = (Hashtable)quantInfo.get(4);
            for (String cName : classSequence.keySet()) {
                Hashtable<Pair<Double, DoubleBondPositionVO>, Pair> matchedRecalibratedToTarget = new Hashtable<Pair<Double, DoubleBondPositionVO>, Pair>();
                Hashtable<DoubleBondPositionVO, Pair> matchedTargetToRecalibrated = new Hashtable<DoubleBondPositionVO, Pair>();
                Set<Pair<Double, DoubleBondPositionVO>> pairsOfClass = this.getBeforeAfter().get(cName);
                if (pairsOfClass == null) continue;
                Vector<Object> elModCharge = this.getAvailableElementsAndModificationsPlusCharge((Hashtable)quantObjects.get(cName));
                LinkedHashMap mods = (LinkedHashMap)elModCharge.get(1);
                for (Pair<Double, DoubleBondPositionVO> pair : pairsOfClass) {
                    for (String analyte : (Vector)analyteSequence.get(cName)) {
                        Hashtable quantAnalytes = (Hashtable)((Hashtable)quantObjects.get(cName)).get(analyte);
                        for (String mod : mods.keySet()) {
                            QuantVO quant = (QuantVO)quantAnalytes.get(mod);
                            Vector<DoubleBondPositionVO> doubleBondPositionVOs = quant.getInfoForOmegaAssignment();
                            for (DoubleBondPositionVO vo : doubleBondPositionVOs) {
                                if (!((DoubleBondPositionVO)pair.getValue()).getDoubleBondPositionsHumanReadable().equals(vo.getDoubleBondPositionsHumanReadable())) continue;
                                double rtError = vo.getExpectedRetentionTime() - ((DoubleBondPositionVO)pair.getValue()).getExpectedRetentionTime();
                                double existingRtError = Double.MAX_VALUE;
                                if (matchedRecalibratedToTarget.containsKey(pair)) {
                                    existingRtError = (Double)((Pair)matchedRecalibratedToTarget.get(pair)).getKey();
                                } else if (matchedTargetToRecalibrated.containsKey(vo)) {
                                    existingRtError = (Double)((Pair)matchedTargetToRecalibrated.get(vo)).getKey();
                                } else if (Math.abs(rtError) < 1.0) {
                                    matchedRecalibratedToTarget.put(pair, new Pair((Object)rtError, (Object)vo));
                                    matchedTargetToRecalibrated.put(vo, new Pair((Object)rtError, pair));
                                }
                                if (!(existingRtError < Double.MAX_VALUE) || !(Math.abs(rtError) < Math.abs(existingRtError))) continue;
                                matchedRecalibratedToTarget.put(pair, new Pair((Object)rtError, (Object)vo));
                                matchedTargetToRecalibrated.put(vo, new Pair((Object)rtError, pair));
                            }
                        }
                    }
                }
                if (matchedRecalibratedToTarget.isEmpty()) continue;
                for (Pair originalPair : matchedRecalibratedToTarget.keySet()) {
                    Pair targetPair = (Pair)matchedRecalibratedToTarget.get(originalPair);
                    String molName = ((DoubleBondPositionVO)targetPair.getValue()).getDoubleBondPositionsHumanReadable();
                    double targetRT = ((DoubleBondPositionVO)targetPair.getValue()).getExpectedRetentionTime();
                    double originalRT = (Double)originalPair.getKey();
                    double recalibratedRT = ((DoubleBondPositionVO)originalPair.getValue()).getExpectedRetentionTime();
                    double rtError = (Double)targetPair.getKey();
                    Row row = sheet.createRow(rowCount);
                    Cell cell = row.createCell(0, 1);
                    cell.setCellValue(cName);
                    cell = row.createCell(1, 1);
                    cell.setCellValue(molName);
                    cell = row.createCell(2, 0);
                    cell.setCellValue(targetRT);
                    cell = row.createCell(3, 0);
                    cell.setCellValue(originalRT);
                    cell = row.createCell(4, 0);
                    cell.setCellValue(recalibratedRT);
                    cell = row.createCell(5, 0);
                    cell.setCellValue(targetRT - originalRT);
                    cell = row.createCell(6, 0);
                    cell.setCellValue(rtError);
                    ++rowCount;
                }
            }
            workbook.write(out);
            System.out.println("recalibration_comparison.xlsx written!");
        }
        catch (Exception e) {
            throw new ExportException(e);
        }
    }

    private void createBeforeAfterTitle(Sheet sheet) {
        Row row = sheet.createRow(0);
        Cell cell = row.createCell(2, 1);
        cell.setCellValue("target DB");
        cell = row.createCell(3, 1);
        cell.setCellValue("original DB");
        cell = row.createCell(4, 1);
        cell.setCellValue("recalibrated DB");
        cell = row.createCell(5, 1);
        cell.setCellValue("RT differences (target vs original)");
        cell = row.createCell(6, 1);
        cell.setCellValue("RT error");
    }

    private class MolecularSpeciesContainer {
        private Hashtable<String, Vector<DoubleBondPositionVO>> labeledSpecies_ = new Hashtable();
        private Hashtable<String, Vector<DoubleBondPositionVO>> unlabeledSpecies_ = new Hashtable();

        private MolecularSpeciesContainer() {
        }

        private void addLabeledSpecies(String molecularSpecies, DoubleBondPositionVO doubleBondPositionVO) {
            if (!this.labeledSpecies_.containsKey(molecularSpecies)) {
                this.labeledSpecies_.put(molecularSpecies, new Vector());
            }
            this.labeledSpecies_.get(molecularSpecies).add(doubleBondPositionVO);
        }

        private void addUnlabeledSpecies(String molecularSpecies, DoubleBondPositionVO doubleBondPositionVO) {
            if (!this.unlabeledSpecies_.containsKey(molecularSpecies)) {
                this.unlabeledSpecies_.put(molecularSpecies, new Vector());
            }
            this.unlabeledSpecies_.get(molecularSpecies).add(doubleBondPositionVO);
        }

        private Set<String> getLabeledMolecularSpecies() {
            return this.labeledSpecies_.keySet();
        }

        private Vector<DoubleBondPositionVO> getLabeledSpecies(String molecularSpecies) {
            if (this.labeledSpecies_.containsKey(molecularSpecies)) {
                return this.labeledSpecies_.get(molecularSpecies);
            }
            return null;
        }

        private Vector<DoubleBondPositionVO> getUnlabeledSpecies(String molecularSpecies) {
            if (this.unlabeledSpecies_.containsKey(molecularSpecies)) {
                return this.unlabeledSpecies_.get(molecularSpecies);
            }
            return null;
        }
    }

    private class Cluster {
        private Vector<DoubleBondPositionVO> doubleBondPositionVOs_ = new Vector();

        private Cluster() {
        }

        private Cluster(Cluster cluster1, Cluster cluster2) {
            this();
            this.doubleBondPositionVOs_.addAll(cluster1.getDoubleBondPositionVOs());
            this.doubleBondPositionVOs_.addAll(cluster2.getDoubleBondPositionVOs());
        }

        private void addDoubleBondPositionVO(DoubleBondPositionVO vo) {
            this.doubleBondPositionVOs_.add(vo);
        }

        private Vector<DoubleBondPositionVO> getDoubleBondPositionVOs() {
            return this.doubleBondPositionVOs_;
        }

        private DoubleBondPositionVO getAverageElement() {
            if (!this.doubleBondPositionVOs_.isEmpty()) {
                DoubleBondPositionVO combined = new DoubleBondPositionVO(this.doubleBondPositionVOs_.get(0));
                float sum = 0.0f;
                int count = 0;
                for (DoubleBondPositionVO vo : this.doubleBondPositionVOs_) {
                    sum += vo.getExpectedRetentionTime();
                    ++count;
                }
                float average = sum / (float)count;
                combined.setExpectedRetentionTime(average);
                return combined;
            }
            return null;
        }
    }
}

